/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.search;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import sferyx.administration.editors.HTMLEditor;
import sferyx.administration.editors.SferyxUtilities;

public class SearchDialog
extends JDialog
implements DocumentListener,
PropertyChangeListener {
    DefaultHighlighter hilit;
    DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(Color.yellow);
    HashSet allHighlights = new HashSet();
    JTextComponent textComponent;
    int pos = -1;
    private JLabel findWhatLabel;
    private JLabel searchDirectionLabel;
    private JRadioButton upRadioButton;
    private JCheckBox highlightSearchCheckbox;
    private JCheckBox matchCaseCheckBox;
    private JButton findButton;
    private JLabel searchOptionsTitle;
    private JButton cancelButton;
    private JSeparator jSeparator1;
    private JLabel searchOptionsLabel;
    private JRadioButton downRadioButton;
    private ButtonGroup searchDirectionRadioButtonGroup;
    private JTextField searchedWordTextField;
    private JCheckBox wholeWordsCheckBox;

    public SearchDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public SearchDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public void insertUpdate(DocumentEvent ev) {
        this.highlightSearchedText(this.highlightSearchCheckbox.isSelected());
    }

    public void removeUpdate(DocumentEvent ev) {
        this.highlightSearchedText(this.highlightSearchCheckbox.isSelected());
    }

    public void changedUpdate(DocumentEvent ev) {
    }

    private void initComponents() {
        this.searchDirectionRadioButtonGroup = new ButtonGroup();
        this.searchedWordTextField = new JTextField();
        this.findWhatLabel = new JLabel();
        this.searchOptionsTitle = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.cancelButton = new JButton();
        this.findButton = new JButton();
        this.upRadioButton = new JRadioButton();
        this.downRadioButton = new JRadioButton();
        this.searchOptionsLabel = new JLabel();
        this.searchDirectionLabel = new JLabel();
        this.matchCaseCheckBox = new JCheckBox();
        this.wholeWordsCheckBox = new JCheckBox();
        this.highlightSearchCheckbox = new JCheckBox();
        this.getContentPane().setLayout(null);
        this.setTitle("Find");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SearchDialog.this.closeDialog(evt);
            }
        });
        this.searchedWordTextField.setFont(new Font("Dialog", 0, 11));
        this.searchedWordTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.searchedWordTextFieldActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.searchedWordTextField);
        this.searchedWordTextField.setBounds(120, 20, 280, 20);
        this.findWhatLabel.setHorizontalAlignment(4);
        this.findWhatLabel.setText("Find what:");
        this.getContentPane().add(this.findWhatLabel);
        this.findWhatLabel.setBounds(10, 20, 100, 16);
        this.searchOptionsTitle.setHorizontalAlignment(4);
        this.searchOptionsTitle.setText("Search options:");
        this.getContentPane().add(this.searchOptionsTitle);
        this.searchOptionsTitle.setBounds(10, 50, 130, 16);
        this.getContentPane().add(this.jSeparator1);
        this.jSeparator1.setBounds(150, 60, 250, 2);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.cancelButton);
        this.cancelButton.setBounds(430, 50, 120, 26);
        this.findButton.setText("Find");
        this.findButton.setToolTipText("Find");
        this.findButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.findButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.findButton);
        this.findButton.setBounds(430, 20, 120, 26);
        this.upRadioButton.setText("Up");
        this.searchDirectionRadioButtonGroup.add(this.upRadioButton);
        this.upRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.upRadioButtonActionPerformed(evt);
            }
        });
        this.upRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SearchDialog.this.upRadioButtonStateChanged(evt);
            }
        });
        this.getContentPane().add(this.upRadioButton);
        this.upRadioButton.setBounds(120, 100, 130, 24);
        this.downRadioButton.setSelected(true);
        this.downRadioButton.setText("Down");
        this.searchDirectionRadioButtonGroup.add(this.downRadioButton);
        this.downRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SearchDialog.this.downRadioButtonStateChanged(evt);
            }
        });
        this.getContentPane().add(this.downRadioButton);
        this.downRadioButton.setBounds(120, 120, 130, 24);
        this.searchOptionsLabel.setText("Options:");
        this.getContentPane().add(this.searchOptionsLabel);
        this.searchOptionsLabel.setBounds(250, 80, 180, 16);
        this.searchDirectionLabel.setText("Direction:");
        this.getContentPane().add(this.searchDirectionLabel);
        this.searchDirectionLabel.setBounds(100, 80, 130, 16);
        this.matchCaseCheckBox.setText("Match case");
        this.matchCaseCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.matchCaseCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SearchDialog.this.matchCaseCheckBoxStateChanged(evt);
            }
        });
        this.getContentPane().add(this.matchCaseCheckBox);
        this.matchCaseCheckBox.setBounds(260, 100, 290, 20);
        this.wholeWordsCheckBox.setText("Whole words only");
        this.wholeWordsCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.wholeWordsCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SearchDialog.this.wholeWordsCheckBoxStateChanged(evt);
            }
        });
        this.getContentPane().add(this.wholeWordsCheckBox);
        this.wholeWordsCheckBox.setBounds(260, 120, 290, 20);
        this.highlightSearchCheckbox.setText("Highlight search");
        this.highlightSearchCheckbox.setMargin(new Insets(0, 0, 0, 0));
        this.highlightSearchCheckbox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SearchDialog.this.highlightSearchCheckboxStateChanged(evt);
            }
        });
        this.getContentPane().add(this.highlightSearchCheckbox);
        this.highlightSearchCheckbox.setBounds(260, 140, 290, 20);
        this.pack();
    }

    private void highlightSearchCheckboxStateChanged(ChangeEvent evt) {
    }

    private void searchedWordTextFieldActionPerformed(ActionEvent evt) {
        this.pos = -1;
        this.findNext();
    }

    private void downRadioButtonStateChanged(ChangeEvent evt) {
    }

    private void upRadioButtonStateChanged(ChangeEvent evt) {
    }

    private void wholeWordsCheckBoxStateChanged(ChangeEvent evt) {
    }

    private void matchCaseCheckBoxStateChanged(ChangeEvent evt) {
    }

    private void upRadioButtonActionPerformed(ActionEvent evt) {
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void findButtonActionPerformed(ActionEvent evt) {
        this.pos = -1;
        this.findNext();
        this.highlightSearchedText(this.highlightSearchCheckbox.isSelected());
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    void highlightSearchedText(boolean higlhight) {
        try {
            this.hilit = (DefaultHighlighter)this.textComponent.getHighlighter();
            Iterator iter = this.allHighlights.iterator();
            while (iter.hasNext()) {
                this.hilit.removeHighlight(iter.next());
            }
            this.allHighlights.clear();
            if (!higlhight) {
                return;
            }
            String s = this.searchedWordTextField.getText();
            if (s.length() <= 0) {
                return;
            }
            String content = this.textComponent.getText(0, this.textComponent.getDocument().getLength());
            int start = 0;
            int index = content.indexOf(s, 0);
            while (index >= 0) {
                if (index < 0) continue;
                try {
                    int end = index + s.length();
                    this.allHighlights.add(this.hilit.addHighlight(index, end, this.painter));
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                start = index + 1;
                index = content.indexOf(s, start);
            }
        }
        catch (Throwable thr) {
            thr.printStackTrace();
        }
    }

    public void setVisible(boolean b) {
        if (b) {
            this.setSize(570, 195);
            this.setLocation((int)(this.getParent().getBounds().getX() + this.getParent().getBounds().getWidth() / 2.0 - this.getBounds().getWidth() / 2.0), (int)(this.getParent().getBounds().getY() + this.getParent().getBounds().getHeight() / 2.0 - this.getBounds().getHeight() / 2.0));
        }
        super.setVisible(b);
        if (b) {
            this.searchedWordTextField.requestFocus();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.highlightSearchCheckbox.isSelected()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SearchDialog.this.highlightSearchedText(SearchDialog.this.highlightSearchCheckbox.isSelected());
                }
            });
        }
    }

    public void setTargetTextComponent(JTextComponent textComponent) {
        this.textComponent = textComponent;
        this.textComponent.getDocument().addDocumentListener(this);
        this.textComponent.addPropertyChangeListener("document", this);
    }

    public void findNext() {
        if (this.textComponent != null) {
            this.textComponent.grabFocus();
        }
        if (this.wholeWordsCheckBox.isSelected()) {
            if (this.upRadioButton.isSelected()) {
                this.findNextWordBackward();
            } else {
                this.findNextWord();
            }
        } else if (this.upRadioButton.isSelected()) {
            this.findNextOccuranceBackward();
        } else {
            this.findNextOccurance();
        }
    }

    public void findNextOccurance() {
        int index = -1;
        try {
            while (index == -1) {
                if (this.pos == -1) {
                    this.pos = this.textComponent.getCaretPosition();
                } else if (this.pos >= this.textComponent.getDocument().getEndPosition().getOffset()) {
                    JOptionPane.showMessageDialog(null, this.getTranslatedString("Search reached the end of the document"), this.getTranslatedString("Search"), 1);
                    return;
                }
                Element paragraph = Utilities.getParagraphElement(this.textComponent, this.pos);
                int start = paragraph.getStartOffset();
                int end = paragraph.getEndOffset();
                String text = this.textComponent.getText(start, end - start);
                index = this.matchCaseCheckBox.isSelected() ? text.indexOf(this.searchedWordTextField.getText(), this.pos - start) : text.toLowerCase().indexOf(this.searchedWordTextField.getText().toLowerCase(), this.pos - start);
                if (index == -1) {
                    ++this.pos;
                    continue;
                }
                this.textComponent.select(start + index, start + index + this.searchedWordTextField.getText().length());
                this.pos = start + index + this.searchedWordTextField.getText().length();
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void findNextOccuranceBackward() {
        int index = -1;
        try {
            while (index == -1) {
                if (this.pos == -1) {
                    this.pos = this.textComponent.getSelectionStart();
                    if (this.searchedWordTextField.getText().length() == 1) {
                        --this.pos;
                    }
                } else if (this.pos <= this.textComponent.getDocument().getStartPosition().getOffset()) {
                    JOptionPane.showMessageDialog(null, this.getTranslatedString("Search reached the beginning of the document"), this.getTranslatedString("Search"), 1);
                    return;
                }
                Element paragraph = Utilities.getParagraphElement(this.textComponent, this.pos);
                int start = paragraph.getStartOffset();
                int end = paragraph.getEndOffset();
                if (this.pos - start + 1 <= this.textComponent.getDocument().getStartPosition().getOffset()) {
                    JOptionPane.showMessageDialog(null, this.getTranslatedString("Search reached the beginning of the document"), this.getTranslatedString("Search"), 1);
                    return;
                }
                String text = this.textComponent.getText(start, this.pos - start + 1);
                index = this.matchCaseCheckBox.isSelected() ? text.lastIndexOf(this.searchedWordTextField.getText()) : text.toLowerCase().lastIndexOf(this.searchedWordTextField.getText().toLowerCase());
                if (index == -1) {
                    --this.pos;
                    if (this.pos > this.textComponent.getDocument().getStartPosition().getOffset()) continue;
                    JOptionPane.showMessageDialog(null, this.getTranslatedString("Search reached the beginning of the document"), this.getTranslatedString("Search"), 1);
                    return;
                }
                this.textComponent.select(start + index, start + index + this.searchedWordTextField.getText().length());
                this.pos = start + index - this.searchedWordTextField.getText().length();
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void findNextWord() {
        int index = -1;
        int pos = -1;
        try {
            while (index == -1) {
                int end;
                if (pos == -1) {
                    pos = this.textComponent.getCaretPosition();
                }
                if (pos >= this.textComponent.getDocument().getEndPosition().getOffset()) {
                    JOptionPane.showMessageDialog(null, this.getTranslatedString("Search reached the end of the document"), this.getTranslatedString("Search"), 1);
                    return;
                }
                int start = Utilities.getWordStart(this.textComponent, pos);
                String selectedText = this.textComponent.getText(start, (end = Utilities.getWordEnd(this.textComponent, pos)) - start);
                if (selectedText == null) {
                    return;
                }
                if (end == this.textComponent.getDocument().getLength() && selectedText.trim().equals("")) {
                    JOptionPane.showMessageDialog(null, this.getTranslatedString("Search reached the end of the document"), this.getTranslatedString("Search"), 1);
                    return;
                }
                if (start == this.textComponent.getDocument().getLength()) {
                    JOptionPane.showMessageDialog(null, this.getTranslatedString("Search reached the end of the document"), this.getTranslatedString("Search"), 1);
                    return;
                }
                if (this.textComponent.getDocument().getLength() < this.textComponent.getCaretPosition()) continue;
                if (selectedText.trim().equals("")) {
                    if ((pos += selectedText.length()) < this.textComponent.getDocument().getEndPosition().getOffset()) continue;
                    JOptionPane.showMessageDialog(null, this.getTranslatedString("Search reached the end of the document"), this.getTranslatedString("Search"), 1);
                    return;
                }
                if (this.matchCaseCheckBox.isSelected()) {
                    if (!selectedText.equals(this.searchedWordTextField.getText())) {
                        if ((pos += selectedText.length()) < this.textComponent.getDocument().getEndPosition().getOffset()) continue;
                        JOptionPane.showMessageDialog(null, this.getTranslatedString("Search reached the end of the document"), this.getTranslatedString("Search"), 1);
                        return;
                    }
                    this.textComponent.select(Math.min(start, end), Math.max(start, end));
                    index = 1;
                    if ((pos += selectedText.length()) < this.textComponent.getDocument().getEndPosition().getOffset()) continue;
                    JOptionPane.showMessageDialog(null, this.getTranslatedString("Search reached the end of the document"), this.getTranslatedString("Search"), 1);
                    return;
                }
                if (!selectedText.equalsIgnoreCase(this.searchedWordTextField.getText())) {
                    if ((pos += selectedText.length()) < this.textComponent.getDocument().getEndPosition().getOffset()) continue;
                    JOptionPane.showMessageDialog(null, "Search reached the end of the document", "Search", 1);
                    return;
                }
                this.textComponent.select(Math.min(start, end), Math.max(start, end));
                index = 1;
                if ((pos += selectedText.length()) < this.textComponent.getDocument().getEndPosition().getOffset()) continue;
                JOptionPane.showMessageDialog(null, this.getTranslatedString("Search reached the end of the document"), this.getTranslatedString("Search"), 1);
                return;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void findNextWordBackward() {
        int index = -1;
        int pos = -1;
        try {
            while (index == -1) {
                int end;
                if (pos == -1) {
                    pos = this.textComponent.getSelectionStart() - 1;
                }
                if (pos <= this.textComponent.getDocument().getStartPosition().getOffset()) {
                    JOptionPane.showMessageDialog(null, this.getTranslatedString("Search reached the beginning of the document"), this.getTranslatedString("Search"), 1);
                    return;
                }
                int start = Utilities.getWordStart(this.textComponent, pos);
                String selectedText = this.textComponent.getText(start, (end = Utilities.getWordEnd(this.textComponent, pos)) - start);
                if (selectedText == null) {
                    return;
                }
                if (this.textComponent.getDocument().getLength() < this.textComponent.getCaretPosition()) continue;
                if (selectedText.trim().equals("")) {
                    pos -= selectedText.length();
                    continue;
                }
                if (this.matchCaseCheckBox.isSelected()) {
                    if (!selectedText.equals(this.searchedWordTextField.getText())) {
                        if ((pos = pos - selectedText.length() - 1) > this.textComponent.getDocument().getStartPosition().getOffset()) continue;
                        JOptionPane.showMessageDialog(null, this.getTranslatedString("Search reached the beginning of the document"), this.getTranslatedString("Search"), 1);
                        return;
                    }
                    this.textComponent.select(Math.min(start, end), Math.max(start, end));
                    pos = pos - selectedText.length() - 1;
                    index = 1;
                    continue;
                }
                if (!selectedText.equalsIgnoreCase(this.searchedWordTextField.getText())) {
                    if ((pos = pos - selectedText.length() - 1) > this.textComponent.getDocument().getStartPosition().getOffset()) continue;
                    JOptionPane.showMessageDialog(null, this.getTranslatedString("Search reached the beginning of the document"), this.getTranslatedString("Search"), 1);
                    return;
                }
                this.textComponent.select(Math.min(start, end), Math.max(start, end));
                pos = pos - selectedText.length() - 1;
                index = 1;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    String getTranslatedString(String s) {
        if (s == null) {
            return s;
        }
        HTMLEditor editor = SferyxUtilities.getHostHTMLEditor(this.textComponent);
        if (editor != null) {
            return editor.getTranslatedString(s);
        }
        return s;
    }

    public static void main(String[] args) {
        new SearchDialog((Frame)new JFrame(), true).show();
    }
}

