/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.printing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BoxView;
import javax.swing.text.ElementIterator;
import javax.swing.text.GlyphView;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import sferyx.administration.editors.CustomBoxPainter;
import sferyx.administration.editors.CustomEmptyXMLTagView;
import sferyx.administration.editors.CustomFormInputView;
import sferyx.administration.editors.CustomListView;
import sferyx.administration.editors.EditorHTMLDocument;
import sferyx.administration.editors.SferyxUtilities;
import sferyx.common.PrintableView;

public class PrintingSystem
implements Printable {
    int currentPage = -1;
    JEditorPane printableEditor;
    double pageEndY = 0.0;
    double pageStartY = 0.0;
    boolean scaleWidthToFit = true;
    PageFormat pageFormat;
    PrinterJob printerJob = PrinterJob.getPrinterJob();
    boolean printCancelled = false;
    boolean resized = false;
    double scale = 1.0;
    View rootView;
    int hyperlinEncountered = 0;
    int currentViewIndex = 0;
    Rectangle currentAlloc;

    public boolean isPrintCancelled() {
        return this.printCancelled;
    }

    public void setPrintableEditor(JEditorPane editor) {
        this.printableEditor = editor;
    }

    public void resetToStart() {
        this.currentPage = -1;
        this.pageEndY = 0.0;
        this.pageStartY = 0.0;
    }

    public PageFormat getCurrentPageFormat() {
        return this.pageFormat;
    }

    public PrintingSystem() {
        PageFormat defaultPage = this.printerJob.defaultPage();
        this.pageFormat = this.printerJob.pageDialog(defaultPage);
        this.printCancelled = this.pageFormat == defaultPage;
    }

    public PrintingSystem(boolean quickPrint, PageFormat defaultPageFormat) {
        this.printerJob.defaultPage(defaultPageFormat);
        PageFormat defaultPage = defaultPageFormat;
        if (quickPrint) {
            this.pageFormat = defaultPageFormat;
            this.printCancelled = false;
        } else {
            this.pageFormat = this.printerJob.pageDialog(defaultPageFormat);
            this.printCancelled = this.pageFormat == defaultPage;
        }
    }

    public PrintingSystem(boolean quickPrint) {
        PageFormat defaultPage = this.printerJob.defaultPage();
        if (quickPrint) {
            this.pageFormat = this.printerJob.defaultPage();
            this.printCancelled = false;
        } else {
            this.pageFormat = this.printerJob.pageDialog(defaultPage);
            this.printCancelled = this.pageFormat == defaultPage;
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.printableEditor.getSize().width > (int)pageFormat.getImageableWidth()) {
            this.printableEditor.setSize((int)pageFormat.getImageableWidth(), Integer.MAX_VALUE);
            this.rootView = this.printableEditor.getUI().getRootView(this.printableEditor);
            if (this.scaleWidthToFit && this.printableEditor.getMinimumSize().getWidth() > pageFormat.getImageableWidth() && pageFormat.getImageableWidth() / this.printableEditor.getMinimumSize().getWidth() < 1.0) {
                this.scale = pageFormat.getImageableWidth() / this.printableEditor.getMinimumSize().getWidth();
                graphics2D.scale(this.scale, this.scale);
            }
            this.resized = true;
        } else {
            this.rootView = this.printableEditor.getUI().getRootView(this.printableEditor);
            graphics2D.scale(this.scale, this.scale);
        }
        graphics2D.setClip((int)(pageFormat.getImageableX() / this.scale), (int)(pageFormat.getImageableY() / this.scale), (int)(pageFormat.getImageableWidth() / this.scale), (int)(pageFormat.getImageableHeight() / this.scale));
        if (pageIndex > this.currentPage) {
            this.currentPage = pageIndex;
            this.pageStartY += this.pageEndY;
            this.pageEndY = graphics2D.getClipBounds().getHeight();
        }
        graphics2D.translate(graphics2D.getClipBounds().getX(), graphics2D.getClipBounds().getY());
        Rectangle allocation = new Rectangle(0, (int)(-this.pageStartY), (int)this.printableEditor.getMinimumSize().getWidth(), (int)this.printableEditor.getPreferredSize().getHeight());
        if (this.printView(graphics2D, allocation, this.rootView)) {
            return 0;
        }
        this.pageStartY = 0.0;
        this.pageEndY = 0.0;
        this.currentPage = -1;
        return 1;
    }

    public void print(JEditorPane hostEditor) {
        if (this.printCancelled) {
            return;
        }
        this.printableEditor = hostEditor;
        this.showPrintDialog();
    }

    private boolean printView(Graphics2D graphics2D, Shape allocation, View view) {
        boolean pageExists = false;
        Rectangle clipRectangle = graphics2D.getClipBounds();
        if (view.getViewCount() > 0) {
            if (view instanceof BoxView) {
                Rectangle a = (Rectangle)allocation;
                try {
                    CustomBoxPainter boxPainter = new CustomBoxPainter(view.getAttributes(), ((HTMLDocument)view.getDocument()).getStyleSheet(), view);
                    boxPainter.paint(graphics2D, a.x, a.y, a.width, a.height, view);
                    SferyxUtilities.paintViewBorder(view, a, graphics2D);
                }
                catch (Throwable thr) {
                    // empty catch block
                }
            }
            for (int i = 0; i < view.getViewCount(); ++i) {
                Shape childAllocation = view.getChildAllocation(i, allocation);
                if (childAllocation == null) continue;
                this.currentViewIndex = i;
                this.currentAlloc = (Rectangle)allocation;
                View childView = view.getView(i);
                if (!this.printView(graphics2D, childAllocation, childView)) continue;
                if (view instanceof CustomListView) {
                    ((CustomListView)view).paintOnlyBulletsForChild(graphics2D, this.currentAlloc, i);
                }
                pageExists = true;
            }
        } else if (allocation.getBounds().getMaxY() >= clipRectangle.getY()) {
            pageExists = true;
            if (allocation.getBounds().getHeight() > clipRectangle.getHeight() && allocation.intersects(clipRectangle)) {
                view.paint(graphics2D, allocation);
            } else if (allocation.getBounds().getY() >= clipRectangle.getY() || ((Rectangle)allocation).y < 0) {
                if (allocation.getBounds().getMaxY() <= clipRectangle.getMaxY()) {
                    if (view instanceof CustomFormInputView || view instanceof CustomEmptyXMLTagView) {
                        this.printComponentView(view, graphics2D, (Rectangle)allocation);
                        return pageExists;
                    }
                    view.paint(graphics2D, allocation);
                    if (view instanceof PrintableView) {
                        // empty if block
                    }
                } else if (allocation.getBounds().getY() < this.pageEndY) {
                    this.pageEndY = allocation.getBounds().getY();
                }
            }
        }
        return pageExists;
    }

    void printComponentView(View view, Graphics graphics2D, Rectangle allocation) {
        try {
            Component toPaint;
            if (view instanceof CustomEmptyXMLTagView) {
                Component c = ((CustomEmptyXMLTagView)view).getComponent();
                int imgWidth = c.getWidth();
                int imgHeight = c.getHeight();
                boolean imgMode = true;
                Image img = c.createImage(imgWidth, imgHeight);
                Graphics imgGraphics = img.getGraphics();
                c.paintAll(imgGraphics);
                graphics2D.drawImage(img, allocation.x, allocation.y, imgWidth, imgHeight, c);
                return;
            }
            if (((CustomFormInputView)view).getComponent() == null) {
                return;
            }
            Container c = ((CustomFormInputView)view).getComponent().getParent();
            if (c.getComponent(0) instanceof JPanel) {
                toPaint = ((JPanel)c.getComponent(0)).getComponent(0);
                toPaint.setBounds(allocation);
            } else {
                toPaint = c.getComponent(0);
            }
            if (toPaint instanceof PrintableView) {
                Image img = ((PrintableView)((Object)toPaint)).getImage();
                int width = img.getWidth(toPaint);
                int height = img.getHeight(toPaint);
                graphics2D.drawImage(img, allocation.x, allocation.y, width, height, toPaint);
            } else {
                int imgWidth = allocation.width;
                int imgHeight = allocation.height;
                Image img = toPaint.createImage(imgWidth, imgHeight);
                Graphics imgGraphics = img.getGraphics();
                toPaint.paintAll(imgGraphics);
                graphics2D.drawImage(img, allocation.x, allocation.y, imgWidth, imgHeight, toPaint);
            }
        }
        catch (Throwable thr) {
            // empty catch block
        }
    }

    int getStringLegnthFromView(View view, Graphics2D graphics2D) {
        if (view instanceof GlyphView) {
            try {
                Segment text = ((GlyphView)view).getText(view.getStartOffset(), view.getEndOffset());
                String result = text.toString();
                int length = graphics2D.getFontMetrics().stringWidth(result);
                return length;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 0;
    }

    private void showPrintDialog() {
        StyleSheet printStyle = null;
        boolean proceed = SferyxUtilities.getHostHTMLEditor(this.printableEditor).isDirectPrint();
        if (!proceed) {
            proceed = this.printerJob.printDialog();
        }
        if (proceed) {
            this.printerJob.setPrintable(this, this.pageFormat);
            try {
                HTMLDocument htdoc = (HTMLDocument)this.printableEditor.getDocument();
                ElementIterator iterator = new ElementIterator(this.printableEditor.getDocument());
                AbstractDocument.AbstractElement currentElement = null;
                while ((currentElement = (AbstractDocument.AbstractElement)iterator.next()) != null) {
                    if (!currentElement.getAttribute(StyleConstants.NameAttribute).equals(HTML.Tag.LINK)) continue;
                    Enumeration<?> allAttributes = currentElement.getAttributeNames();
                    while (allAttributes.hasMoreElements()) {
                        String href;
                        String media;
                        Object currentAttributeName = allAttributes.nextElement();
                        if (currentAttributeName == null || !currentAttributeName.toString().equalsIgnoreCase("media") || (media = (String)currentElement.getAttribute(currentAttributeName)) == null || !media.trim().equalsIgnoreCase("print") || (href = (String)currentElement.getAttribute(HTML.Attribute.HREF)) == null) continue;
                        if (printStyle == null) {
                            printStyle = new StyleSheet();
                        }
                        printStyle.importStyleSheet(new URL(htdoc.getBase(), href));
                    }
                }
                if (printStyle != null) {
                    ((HTMLDocument)this.printableEditor.getDocument()).getStyleSheet().addStyleSheet(printStyle);
                }
                SferyxUtilities.getHostHTMLEditor(this.printableEditor).setPrintingHost(true);
                View rootView = this.printableEditor.getUI().getRootView(this.printableEditor);
                try {
                    rootView.changedUpdate(((EditorHTMLDocument)rootView.getDocument()).getDefautEvent(rootView.getElement()), this.printableEditor.getVisibleRect(), rootView.getViewFactory());
                }
                catch (Throwable thr) {
                    thr.printStackTrace();
                }
                this.printerJob.print();
                SferyxUtilities.getHostHTMLEditor(this.printableEditor).setPrintingHost(false);
                if (printStyle != null) {
                    ((HTMLDocument)this.printableEditor.getDocument()).getStyleSheet().removeStyleSheet(printStyle);
                }
                try {
                    rootView.changedUpdate(((EditorHTMLDocument)rootView.getDocument()).getDefautEvent(rootView.getElement()), this.printableEditor.getVisibleRect(), rootView.getViewFactory());
                }
                catch (Throwable thr) {
                    thr.printStackTrace();
                }
            }
            catch (Throwable printerException) {
                this.pageStartY = 0.0;
                this.pageEndY = 0.0;
                this.currentPage = -1;
            }
        }
    }
}

