/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors.parser;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabStop;
import sferyx.administration.editors.SferyxUtilities;
import sferyx.administration.editors.parser.MockAttributeSet;
import sferyx.administration.editors.parser.RTFAttribute;
import sferyx.administration.editors.parser.RTFAttributes;
import sferyx.administration.editors.parser.RTFParser;

class RTFReader
extends RTFParser {
    StyledDocument target;
    Dictionary parserState;
    Destination rtfDestination;
    MutableAttributeSet documentAttributes;
    Dictionary fontTable;
    Color[] colorTable;
    Style[] characterStyles;
    Style[] paragraphStyles;
    Style[] sectionStyles;
    int rtfversion;
    boolean ignoreGroupIfUnknownKeyword;
    int skippingCharacters;
    private static Dictionary straightforwardAttributes = RTFAttributes.attributesByKeyword();
    private MockAttributeSet mockery;
    static Dictionary textKeywords = null;
    static final String TabAlignmentKey = "tab_alignment";
    static final String TabLeaderKey = "tab_leader";
    static Dictionary characterSets;
    static boolean useNeXTForAnsi;
    Vector cellBackgroundAttributes = new Vector();
    Vector cellWidthAttributes = new Vector();
    Vector allRowsVector = new Vector();
    boolean inParagraph = false;
    boolean inTable = false;
    boolean inCell = false;
    boolean intbl = false;
    boolean currentlyInTable = false;
    boolean firstNonEmptyText = false;
    StringBuffer convertedContent = new StringBuffer();
    int currentRowCellCount = 0;
    boolean fontsInited = false;
    static char[] ansi;
    static char[] cpg437;
    static char[] cpg850;
    static char[] mac;
    static char[] NeXT;
    StringBuffer tempBuffer;
    static /* synthetic */ Class class$sferyx$administration$editors$parser$RTFReader;

    public RTFReader(StyledDocument destination) {
        this.target = destination;
        this.parserState = new Hashtable();
        this.fontTable = new Hashtable();
        this.rtfversion = -1;
        this.mockery = new MockAttributeSet();
        this.documentAttributes = new SimpleAttributeSet();
    }

    public void handleBinaryBlob(byte[] data) {
        if (this.skippingCharacters > 0) {
            --this.skippingCharacters;
            return;
        }
    }

    public void handleText(String text) {
        if (text.equals("") && !this.fontsInited) {
            return;
        }
        if (this.skippingCharacters > 0) {
            if (this.skippingCharacters >= text.length()) {
                this.skippingCharacters -= text.length();
                return;
            }
            text = text.substring(this.skippingCharacters);
            this.skippingCharacters = 0;
        }
        if (this.rtfDestination != null) {
            this.rtfDestination.handleText(text);
            return;
        }
        this.warning("Text with no destination. oops.");
    }

    Color defaultColor() {
        return Color.black;
    }

    public void begingroup() {
        Object oldSaveState;
        if (this.skippingCharacters > 0) {
            this.skippingCharacters = 0;
        }
        if ((oldSaveState = this.parserState.get("_savedState")) != null) {
            this.parserState.remove("_savedState");
        }
        Dictionary saveState = (Dictionary)((Hashtable)this.parserState).clone();
        if (oldSaveState != null) {
            saveState.put("_savedState", oldSaveState);
        }
        this.parserState.put("_savedState", saveState);
        if (this.rtfDestination != null) {
            this.rtfDestination.begingroup();
        }
    }

    public void endgroup() {
        Dictionary restoredState;
        Destination restoredDestination;
        if (this.skippingCharacters > 0) {
            this.skippingCharacters = 0;
        }
        if ((restoredDestination = (Destination)(restoredState = (Dictionary)this.parserState.get("_savedState")).get("dst")) != this.rtfDestination) {
            this.rtfDestination.close();
            this.rtfDestination = restoredDestination;
        }
        Dictionary oldParserState = this.parserState;
        this.parserState = restoredState;
        if (this.rtfDestination != null) {
            this.rtfDestination.endgroup(oldParserState);
        }
    }

    protected void setRTFDestination(Destination newDestination) {
        Dictionary previousState = (Dictionary)this.parserState.get("_savedState");
        if (previousState != null && this.rtfDestination != previousState.get("dst")) {
            this.warning("Warning, RTF destination overridden, invalid RTF.");
            this.rtfDestination.close();
        }
        this.rtfDestination = newDestination;
        this.parserState.put("dst", this.rtfDestination);
    }

    public void close() throws IOException {
        Enumeration<?> docProps = this.documentAttributes.getAttributeNames();
        while (docProps.hasMoreElements()) {
            Object propName = docProps.nextElement();
            this.target.putProperty(propName, this.documentAttributes.getAttribute((String)propName));
        }
        this.warning("RTF filter done.");
        super.close();
    }

    public boolean handleKeyword(String keyword) {
        boolean ignoreGroupIfUnknownKeywordSave = this.ignoreGroupIfUnknownKeyword;
        if (this.skippingCharacters > 0) {
            --this.skippingCharacters;
            return true;
        }
        this.ignoreGroupIfUnknownKeyword = false;
        Object item = textKeywords.get(keyword);
        if (item != null) {
            this.handleText((String)item);
            return true;
        }
        if (keyword.equals("fonttbl")) {
            this.setRTFDestination(new FonttblDestination());
            return true;
        }
        if (keyword.equals("colortbl")) {
            this.setRTFDestination(new ColortblDestination());
            return true;
        }
        if (keyword.equals("stylesheet")) {
            this.setRTFDestination(new StylesheetDestination());
            return true;
        }
        if (keyword.equals("info")) {
            this.setRTFDestination(new InfoDestination());
            return false;
        }
        if (keyword.equals("pict")) {
            this.setRTFDestination(new PictureDestination());
            return true;
        }
        if (keyword.equals("trowd")) {
            if (this.inTable) {
                this.convertedContent.append("\n</td></tr>\n");
                this.inTable = false;
            }
            this.cellBackgroundAttributes = new Vector();
            this.cellWidthAttributes = new Vector();
            this.setRTFDestination(new TableDestination());
            this.currentRowCellCount = 0;
            return true;
        }
        if (keyword.equals("mac")) {
            this.setCharacterSet("mac");
            return true;
        }
        if (keyword.equals("ansi")) {
            if (useNeXTForAnsi) {
                this.setCharacterSet("NeXT");
            } else {
                this.setCharacterSet("ansi");
            }
            return true;
        }
        if (keyword.equals("next")) {
            this.setCharacterSet("NeXT");
            return true;
        }
        if (keyword.equals("pc")) {
            this.setCharacterSet("cpg437");
            return true;
        }
        if (keyword.equals("pca")) {
            this.setCharacterSet("cpg850");
            return true;
        }
        if (keyword.equals("*")) {
            this.ignoreGroupIfUnknownKeyword = true;
            return true;
        }
        if (this.rtfDestination != null && this.rtfDestination.handleKeyword(keyword)) {
            return true;
        }
        if (keyword.equals("aftncn") || keyword.equals("aftnsep") || keyword.equals("aftnsepc") || keyword.equals("annotation") || keyword.equals("atnauthor") || keyword.equals("atnicn") || keyword.equals("atnid") || keyword.equals("atnref") || keyword.equals("atntime") || keyword.equals("atrfend") || keyword.equals("atrfstart") || keyword.equals("bkmkend") || keyword.equals("bkmkstart") || keyword.equals("datafield") || keyword.equals("do") || keyword.equals("dptxbxtext") || keyword.equals("falt") || keyword.equals("field") || keyword.equals("file") || keyword.equals("filetbl") || keyword.equals("fname") || keyword.equals("fontemb") || keyword.equals("fontfile") || keyword.equals("footer") || keyword.equals("footerf") || keyword.equals("footerl") || keyword.equals("footerr") || keyword.equals("footnote") || keyword.equals("ftncn") || keyword.equals("ftnsep") || keyword.equals("ftnsepc") || keyword.equals("header") || keyword.equals("headerf") || keyword.equals("headerl") || keyword.equals("headerr") || keyword.equals("keycode") || keyword.equals("nextfile") || keyword.equals("object") || keyword.equals("pict") || keyword.equals("pn") || keyword.equals("pnseclvl") || keyword.equals("pntxtb") || keyword.equals("pntxta") || keyword.equals("revtbl") || keyword.equals("rxe") || keyword.equals("tc") || keyword.equals("template") || keyword.equals("txe") || keyword.equals("xe")) {
            ignoreGroupIfUnknownKeywordSave = true;
        }
        if (ignoreGroupIfUnknownKeywordSave) {
            this.setRTFDestination(new DiscardingDestination());
        }
        return false;
    }

    public boolean handleKeyword(String keyword, int parameter) {
        boolean ignoreGroupIfUnknownKeywordSave = this.ignoreGroupIfUnknownKeyword;
        if (this.skippingCharacters > 0) {
            --this.skippingCharacters;
            return true;
        }
        this.ignoreGroupIfUnknownKeyword = false;
        if (keyword.equals("uc")) {
            this.parserState.put("UnicodeSkip", new Integer(parameter));
            return true;
        }
        if (keyword.equals("u")) {
            if (parameter < 0) {
                parameter += 65536;
            }
            this.handleText((char)parameter);
            Number skip = (Number)this.parserState.get("UnicodeSkip");
            this.skippingCharacters = skip != null ? skip.intValue() : 1;
            return true;
        }
        if (keyword.equals("rtf")) {
            this.rtfversion = parameter;
            this.setRTFDestination(new DocumentDestination());
            return true;
        }
        if (keyword.startsWith("NeXT") || keyword.equals("private")) {
            ignoreGroupIfUnknownKeywordSave = true;
        }
        if (this.rtfDestination != null && this.rtfDestination.handleKeyword(keyword, parameter)) {
            return true;
        }
        if (ignoreGroupIfUnknownKeywordSave) {
            this.setRTFDestination(new DiscardingDestination());
        }
        return false;
    }

    private void setTargetAttribute(String name, Object value) {
    }

    public void setCharacterSet(String name) {
        Object set;
        try {
            set = RTFReader.getCharacterSet(name);
        }
        catch (Exception e) {
            this.warning("Exception loading RTF character set \"" + name + "\": " + e);
            set = null;
        }
        if (set != null) {
            this.translationTable = (char[])set;
        } else {
            this.warning("Unknown RTF character set \"" + name + "\"");
            if (!name.equals("ansi")) {
                try {
                    this.translationTable = (char[])RTFReader.getCharacterSet("ansi");
                }
                catch (IOException e) {
                    throw new InternalError("RTFReader: Unable to find character set resources (" + e + ")");
                }
            }
        }
        this.setTargetAttribute("rtfCharacterSet", name);
    }

    public static void defineCharacterSet(String name, char[] table) {
        if (table.length < 256) {
            throw new IllegalArgumentException("Translation table must have 256 entries.");
        }
        characterSets.put(name, table);
    }

    public static Object getCharacterSet(final String name) throws IOException {
        char[] set = (char[])characterSets.get(name);
        if (set == null) {
            if (name.equalsIgnoreCase("ansi")) {
                return ansi;
            }
            if (name.equalsIgnoreCase("cpg437")) {
                return cpg437;
            }
            if (name.equalsIgnoreCase("cpg850")) {
                return cpg850;
            }
            if (name.equalsIgnoreCase("mac")) {
                return mac;
            }
            if (name.equalsIgnoreCase("NeXT")) {
                return NeXT;
            }
            InputStream charsetStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return (class$sferyx$administration$editors$parser$RTFReader == null ? (class$sferyx$administration$editors$parser$RTFReader = RTFReader.class$("sferyx.administration.editors.parser.RTFReader")) : class$sferyx$administration$editors$parser$RTFReader).getResourceAsStream("charsets/" + name + ".txt");
                }
            });
            set = RTFReader.readCharset(charsetStream);
            RTFReader.defineCharacterSet(name, set);
        }
        return set;
    }

    static char[] readCharset(InputStream strm) throws IOException {
        char[] values = new char[256];
        StreamTokenizer in = new StreamTokenizer(new BufferedReader(new InputStreamReader(strm)));
        in.eolIsSignificant(false);
        in.commentChar(35);
        in.slashSlashComments(true);
        in.slashStarComments(true);
        for (int i = 0; i < 256; ++i) {
            int ttype;
            try {
                ttype = in.nextToken();
            }
            catch (Exception e) {
                throw new IOException("Unable to read from character set file (" + e + ")");
            }
            if (ttype != -2) {
                throw new IOException("Unexpected token in character set file");
            }
            values[i] = (char)in.nval;
        }
        return values;
    }

    static char[] readCharset(URL href) throws IOException {
        return RTFReader.readCharset(href.openStream());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        textKeywords = new Hashtable();
        textKeywords.put("\\", "\\");
        textKeywords.put("{", "{");
        textKeywords.put("}", "}");
        textKeywords.put(" ", "\u00a0");
        textKeywords.put("~", "\u00a0");
        textKeywords.put("_", "\u2011");
        textKeywords.put("bullet", "\u2022");
        textKeywords.put("emdash", "\u2014");
        textKeywords.put("emspace", "\u2003");
        textKeywords.put("endash", "\u2013");
        textKeywords.put("enspace", "\u2002");
        textKeywords.put("ldblquote", "\u201c");
        textKeywords.put("lquote", "\u2018");
        textKeywords.put("ltrmark", "\u200e");
        textKeywords.put("rdblquote", "\u201d");
        textKeywords.put("rquote", "\u2019");
        textKeywords.put("rtlmark", "\u200f");
        textKeywords.put("tab", "\t");
        textKeywords.put("zwj", "\u200d");
        textKeywords.put("zwnj", "\u200c");
        textKeywords.put("-", "\u2027");
        useNeXTForAnsi = false;
        characterSets = new Hashtable();
        ansi = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u0402', '\u0403', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\u0160', '\u2039', '\u015a', '\u0164', '\u017d', '\u0179', '\u0452', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u2122', '\u0161', '\u203a', '\u015b', '\u0165', '\u017e', '\u017a', '\u0000', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff'};
        cpg437 = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u00c7', '\u00fc', '\u00e9', '\u00e2', '\u00e4', '\u00e0', '\u00e5', '\u00e7', '\u00ea', '\u00eb', '\u00e8', '\u00ef', '\u00ee', '\u00ec', '\u00c4', '\u00c5', '\u00c9', '\u00e6', '\u00c6', '\u00f4', '\u00f6', '\u00f2', '\u00fb', '\u00f9', '\u00ff', '\u00d6', '\u00dc', '\u00a2', '\u00a3', '\u00a5', '\u20a7', '\u0192', '\u00e1', '\u00ed', '\u00f3', '\u00fa', '\u00f1', '\u00d1', '\u00aa', '\u00ba', '\u00bf', '\u2310', '\u00ac', '\u00bd', '\u00bc', '\u00a1', '\u00ab', '\u00bb', '\u2591', '\u2592', '\u2593', '\u2502', '\u2524', '\u2561', '\u2562', '\u2556', '\u2555', '\u2563', '\u2551', '\u2557', '\u255d', '\u255c', '\u255b', '\u2510', '\u2514', '\u2534', '\u252c', '\u251c', '\u2500', '\u253c', '\u255e', '\u255f', '\u255a', '\u2554', '\u2569', '\u2566', '\u2560', '\u2550', '\u256c', '\u2567', '\u2568', '\u2564', '\u2565', '\u2559', '\u2558', '\u2552', '\u2553', '\u256b', '\u256a', '\u2518', '\u250c', '\u2588', '\u2584', '\u258c', '\u2590', '\u2580', '\u03b1', '\u00df', '\u0393', '\u03c0', '\u03a3', '\u03c3', '\u00b5', '\u03c4', '\u03a6', '\u0398', '\u03a9', '\u03b4', '\u221e', '\u03c6', '\u03b5', '\u2229', '\u2261', '\u00b1', '\u2265', '\u2264', '\u2320', '\u2321', '\u00f7', '\u2248', '\u00b0', '\u2219', '\u00b7', '\u221a', '\u207f', '\u00b2', '\u25a0', '\u00a0'};
        cpg850 = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u00c7', '\u00fc', '\u00e9', '\u00e2', '\u00e4', '\u00e0', '\u00e5', '\u00e7', '\u00ea', '\u00eb', '\u00e8', '\u00ef', '\u00ee', '\u00ec', '\u00c4', '\u00c5', '\u00c9', '\u00e6', '\u00c6', '\u00f4', '\u00f6', '\u00f2', '\u00fb', '\u00f9', '\u00ff', '\u00d6', '\u00dc', '\u00f8', '\u00a3', '\u00d8', '\u00d7', '\u0192', '\u00e1', '\u00ed', '\u00f3', '\u00fa', '\u00f1', '\u00d1', '\u00aa', '\u00ba', '\u00bf', '\u00ae', '\u00ac', '\u00bd', '\u00bc', '\u00a1', '\u00ab', '\u00bb', '\u2591', '\u2592', '\u2593', '\u2502', '\u2524', '\u00c1', '\u00c2', '\u00c0', '\u00a9', '\u2563', '\u2551', '\u2557', '\u255d', '\u00a2', '\u00a5', '\u2510', '\u2514', '\u2534', '\u252c', '\u251c', '\u2500', '\u253c', '\u00e3', '\u00c3', '\u255a', '\u2554', '\u2569', '\u2566', '\u2560', '\u2550', '\u256c', '\u00a4', '\u00f0', '\u00d0', '\u00ca', '\u00cb', '\u00c8', '\u0131', '\u00cd', '\u00ce', '\u00cf', '\u2518', '\u250c', '\u2588', '\u2584', '\u00a6', '\u00cc', '\u2580', '\u00d3', '\u00df', '\u00d4', '\u00d2', '\u00f5', '\u00d5', '\u00b5', '\u00fe', '\u00de', '\u00da', '\u00db', '\u00d9', '\u00fd', '\u00dd', '\u00af', '\u00b4', '\u00ad', '\u00b1', '\u2017', '\u00be', '\u00b6', '\u00a7', '\u00f7', '\u00b8', '\u00b0', '\u00a8', '\u00b7', '\u00b9', '\u00b3', '\u00b2', '\u25a0', '\u00a0'};
        mac = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u00c4', '\u00c5', '\u00c7', '\u00c9', '\u00d1', '\u00d6', '\u00dc', '\u00e1', '\u00e0', '\u00e2', '\u00e4', '\u00e3', '\u00e5', '\u00e7', '\u00e9', '\u00e8', '\u00ea', '\u00eb', '\u00ed', '\u00ec', '\u00ee', '\u00ef', '\u00f1', '\u00f3', '\u00f2', '\u00f4', '\u00f6', '\u00f5', '\u00fa', '\u00f9', '\u00fb', '\u00fc', '\u2020', '\u00b0', '\u00a2', '\u00a3', '\u00a7', '\u2022', '\u00b6', '\u00df', '\u00ae', '\u00a9', '\u2122', '\u00b4', '\u00a8', '\u2260', '\u00c6', '\u00d8', '\u221e', '\u00b1', '\u2264', '\u2265', '\u00a5', '\u00b5', '\u2202', '\u2211', '\u220f', '\u03c0', '\u222b', '\u00aa', '\u00ba', '\u2126', '\u00e6', '\u00f8', '\u00bf', '\u00a1', '\u00ac', '\u221a', '\u0192', '\u2248', '\u2206', '\u00ab', '\u00bb', '\u2026', '\u00a0', '\u00c0', '\u00c3', '\u00d5', '\u0152', '\u0153', '\u2013', '\u2014', '\u201c', '\u201d', '\u2018', '\u2019', '\u00f7', '\u25ca', '\u00ff', '\u0178', '\u2044', '\u00a4', '\u2039', '\u203a', '\ufb01', '\ufb02', '\u2021', '\u00b7', '\u201a', '\u201e', '\u2030', '\u00c2', '\u00ca', '\u00c1', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '\u00d3', '\u00d4', '\u0000', '\u00d2', '\u00da', '\u00db', '\u00d9', '\u0131', '\u02c6', '\u02dc', '\u00af', '\u02d8', '\u02d9', '\u02da', '\u00b8', '\u02dd', '\u02db', '\u02c7'};
        NeXT = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\u0000', '\u000b', '\f', '\u0000', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\u0000', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u0000', '|', '\u0000', '~', '\u007f', '\u00a0', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00b5', '\u00d7', '\u00f7', '\u00a9', '\u00a1', '\u00a2', '\u00a3', '\u2044', '\u00a5', '\u0192', '\u00a7', '\u00a4', '\u2019', '\u201c', '\u00ab', '\u2039', '\u203a', '\ufb01', '\ufb02', '\u00ae', '\u2013', '\u2020', '\u2021', '\u00b7', '\u00a6', '\u00b6', '\u2022', '\u201a', '\u201e', '\u201d', '\u00bb', '\u2026', '\u2030', '\u00ac', '\u00bf', '\u00b9', '\u02cb', '\u00b4', '\u02c6', '\u02dc', '\u00af', '\u02d8', '\u02d9', '\u00a8', '\u00b2', '\u02da', '\u00b8', '\u00b3', '\u02dd', '\u02db', '\u02c7', '\u2014', '\u00b1', '\u00bc', '\u00bd', '\u00be', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00c6', '\u00ed', '\u00aa', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u0141', '\u00d8', '\u0152', '\u00ba', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00e6', '\u00f9', '\u00fa', '\u00fb', '\u0131', '\u00fc', '\u00fd', '\u0142', '\u00f8', '\u0153', '\u00df', '\u00fe', '\u00ff', '\u0000', '\u0000'};
    }

    class TableDestination
    extends DocumentDestination
    implements Destination {
        boolean rowClosed = true;
        boolean tableClosed = false;
        boolean lastRow = false;
        int lastTableIndex = -1;
        boolean nonesttables = false;
        int cellCount = 0;
        StringBuffer currentCellString;
        StringBuffer tempStringBuffer;

        public TableDestination() {
            this.lastTableIndex = RTFReader.this.convertedContent.length();
            if (!RTFReader.this.currentlyInTable) {
                RTFReader.this.convertedContent.append("\n<table cellspacing=\"0\" cellpadding=\"0\" style=\"border-collapse:collapse;border:1px solid black\">\n");
                RTFReader.this.currentlyInTable = true;
                RTFReader.this.allRowsVector.removeAllElements();
            }
            RTFReader.this.convertedContent.append("\n\n<tr>\n");
            this.rowClosed = false;
            RTFReader.this.inTable = true;
            RTFReader.this.inParagraph = false;
        }

        public void close() {
            super.close();
        }

        protected void beginParagraph() {
            if (!RTFReader.this.inTable || RTFReader.this.inCell) {
                RTFReader.this.inParagraph = true;
                MutableAttributeSet pgfAttributes = this.currentParagraphAttributes();
                String align = "left";
                int alignment = StyleConstants.getAlignment(pgfAttributes);
                if (alignment == 0) {
                    align = "left";
                } else if (alignment == 2) {
                    align = "right";
                } else if (alignment == 1) {
                    align = "center";
                } else if (alignment == 3) {
                    align = "justify";
                }
                float indexN = (float)((double)StyleConstants.getLeftIndent(pgfAttributes) * 1.33);
                String indent = "margin-left:" + indexN + "px;";
                RTFReader.this.convertedContent.append("<p style=\"margin-top:0px;margin-bottom:0px;" + indent + "align=\"" + align + "\" >");
            }
        }

        public boolean handleKeyword(String keyword, int parameter) {
            if (!keyword.equals("itap") || parameter < 2 || !this.nonesttables) {
                // empty if block
            }
            if ((!keyword.equals("itap") || parameter != 0 || !RTFReader.this.inTable) && keyword.equals("itap") && this.nonesttables) {
                this.nonesttables = false;
            }
            return super.handleKeyword(keyword, parameter);
        }

        public boolean handleKeyword(String keyword) {
            if (keyword.equals("nonesttables")) {
                this.nonesttables = true;
            }
            if (keyword.equals("nestcell")) {
                RTFReader.this.convertedContent.append("\n</td>\n</tr></table>\n");
                return true;
            }
            if (keyword.equals("lastrow")) {
                this.lastRow = true;
                return true;
            }
            if (keyword.equals("row")) {
                RTFReader.this.intbl = false;
                return true;
            }
            if (keyword.equals("cell") && RTFReader.this.inTable) {
                if (!RTFReader.this.inCell) {
                    this.deliverText(" ", this.characterAttributes);
                }
                RTFReader.this.convertedContent.append("\n</td>\n");
                RTFReader.this.inCell = false;
                if (RTFReader.this.cellWidthAttributes.size() == this.cellCount) {
                    RTFReader.this.convertedContent.append("\n</tr>\n");
                    this.rowClosed = true;
                    RTFReader.this.inTable = false;
                    this.tableClosed = true;
                    this.cellCount = 0;
                    RTFReader.this.allRowsVector.addElement(RTFReader.this.cellWidthAttributes.clone());
                }
                return true;
            }
            return super.handleKeyword(keyword);
        }

        void appendParagraphString() {
            MutableAttributeSet pgfAttributes = this.currentParagraphAttributes();
            String align = "left";
            int alignment = StyleConstants.getAlignment(pgfAttributes);
            if (alignment == 0) {
                align = "left";
            } else if (alignment == 2) {
                align = "right";
            } else if (alignment == 1) {
                align = "center";
            } else if (alignment == 3) {
                align = "justify";
            }
            float indexN = (float)((double)StyleConstants.getLeftIndent(pgfAttributes) * 1.33);
            String indent = "margin-left:" + indexN + "px;";
            RTFReader.this.convertedContent.append("<p style=\"margin-top:0px;margin-bottom:0px;" + indent + "align=\"" + align + "\" >");
        }

        public void deliverText(String text, AttributeSet characterAttributes) {
            if (!RTFReader.this.intbl && RTFReader.this.currentlyInTable) {
                RTFReader.this.convertedContent.append("\n</table>\n");
                RTFReader.this.currentlyInTable = false;
                this.findSpanningCells();
            }
            if (!RTFReader.this.inCell && RTFReader.this.inTable && RTFReader.this.intbl) {
                String background = "";
                String width = "";
                if (RTFReader.this.cellBackgroundAttributes != null && RTFReader.this.cellBackgroundAttributes.size() > this.cellCount && RTFReader.this.cellBackgroundAttributes.elementAt(this.cellCount) instanceof Color) {
                    background = ";background-color:" + SferyxUtilities.colorToString((Color)RTFReader.this.cellBackgroundAttributes.elementAt(this.cellCount));
                }
                if (RTFReader.this.cellWidthAttributes != null && RTFReader.this.cellWidthAttributes.size() > this.cellCount && RTFReader.this.cellWidthAttributes.elementAt(this.cellCount) instanceof Integer) {
                    width = ";width:" + (Integer)RTFReader.this.cellWidthAttributes.elementAt(this.cellCount);
                }
                RTFReader.this.convertedContent.append("\n<td colspan=\"" + RTFReader.this.allRowsVector.size() + "x" + this.cellCount + "\" style=\"border:solid 1px black;padding:4px;" + background + width + "\">\n");
                RTFReader.this.inCell = true;
                ++this.cellCount;
                this.appendParagraphString();
                super.deliverText(text, characterAttributes);
                return;
            }
            super.deliverText(text, characterAttributes);
        }

        public void endSection() {
        }

        public void endgroup(Dictionary oldState) {
            super.endgroup(oldState);
        }
    }

    class PictureDestination
    extends TextHandlingDestination
    implements Destination {
        int width = -1;
        int height = -1;
        boolean handleImage = false;
        int scaleX = 100;
        int scaleY = 100;
        StringBuffer pictBuffer = new StringBuffer();

        PictureDestination() {
        }

        public boolean handleKeyword(String keyword, int parameter) {
            if (keyword.equals("picwgoal")) {
                this.width = (int)((double)(parameter / 20) * 1.33);
                return true;
            }
            if (keyword.equals("pichgoal")) {
                this.height = (int)((double)(parameter / 20) * 1.33);
                return true;
            }
            if (keyword.equals("picscalex")) {
                this.scaleX = parameter;
                return true;
            }
            if (keyword.equals("picscaley")) {
                this.scaleY = parameter;
                return true;
            }
            return super.handleKeyword(keyword, parameter);
        }

        public boolean handleKeyword(String keyword) {
            if (keyword.equals("jpegblip") || keyword.equals("pngblip") || keyword.equals("shppict")) {
                this.handleImage = true;
            }
            return super.handleKeyword(keyword);
        }

        public void deliverText(String text, AttributeSet characterAttributes) {
            MutableAttributeSet attribs = this.currentTextAttributes();
            this.pictBuffer.append(text.trim());
        }

        public byte[] hexStringToByteArray(String s) {
            int len = s.length();
            byte[] data = new byte[len / 2];
            for (int i = 0; i < len; i += 2) {
                data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
            }
            return data;
        }

        public void finishParagraph(AttributeSet pgfAttributes, AttributeSet chrAttributes) {
            if (!this.handleImage) {
                return;
            }
            String s = SferyxUtilities.encodeBase64(this.hexStringToByteArray(this.pictBuffer.toString()));
            String widthS = "";
            if (this.width != -1) {
                widthS = "width=\"" + this.width * this.scaleX / 100 + "\"";
            }
            String heightS = "";
            if (this.height != -1) {
                heightS = "height=\"" + this.height * this.scaleY / 100 + "\"";
            }
            String img = "<img src=\"data:image/jpeg;base64," + s + "\" " + widthS + " " + heightS + ">";
            RTFReader.this.convertedContent.append(img);
        }

        public void endSection() {
        }

        protected void endParagraph() {
            this.finishParagraph(this.currentParagraphAttributes(), this.currentTextAttributes());
        }
    }

    class DocumentDestination
    extends TextHandlingDestination
    implements Destination {
        DocumentDestination() {
        }

        public void deliverText(String text, AttributeSet characterAttributes) {
            AttributeSet attribs = characterAttributes;
            String background = "";
            if (attribs.getAttribute(StyleConstants.Background) != null) {
                background = ";background-color:" + SferyxUtilities.colorToString(StyleConstants.getBackground(attribs));
            }
            String underline = "";
            boolean under = false;
            if (StyleConstants.isUnderline(attribs)) {
                underline = ";text-decoration:underline";
                under = true;
            }
            String strike = "";
            if (StyleConstants.isStrikeThrough(attribs) && under) {
                underline = ";text-decoration:underline line-through";
            } else if (StyleConstants.isStrikeThrough(attribs)) {
                strike = ";text-decoration:line-through";
            }
            String span = "<span style=\"font-family:" + StyleConstants.getFontFamily(attribs) + ";font-size:" + StyleConstants.getFontSize(attribs) + "pt;color:" + SferyxUtilities.colorToString(StyleConstants.getForeground(attribs)) + background + underline + strike + ";font-weight:" + (StyleConstants.isBold(attribs) ? "bold" : "normal") + ";font-style:" + (StyleConstants.isItalic(attribs) ? "italic" : "normal") + "\">";
            String superscript = "";
            String superscriptClose = "";
            if (StyleConstants.isSuperscript(attribs)) {
                superscript = "<sup>";
                superscriptClose = "</sup>";
            }
            String subscript = "";
            String subscriptClose = "";
            if (StyleConstants.isSubscript(attribs)) {
                subscript = "<sub>";
                subscriptClose = "</sub>";
            }
            text = SferyxUtilities.replaceAll(text, "\t", "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            RTFReader.this.convertedContent.append(span + superscript + subscript + text + subscriptClose + superscriptClose + "</span>");
        }

        public void finishParagraph(AttributeSet pgfAttributes, AttributeSet chrAttributes) {
        }

        public void endSection() {
        }
    }

    abstract class TextHandlingDestination
    extends AttributeTrackingDestination
    implements Destination {
        public TextHandlingDestination() {
            RTFReader.this.inParagraph = false;
        }

        public void handleText(String text) {
            if (!RTFReader.this.inParagraph) {
                this.beginParagraph();
            }
            if (RTFReader.this.currentlyInTable && !RTFReader.this.intbl) {
                return;
            }
            this.deliverText(text, this.currentTextAttributes());
        }

        abstract void deliverText(String var1, AttributeSet var2);

        public void close() {
            if (RTFReader.this.inParagraph) {
                this.endParagraph();
            }
            super.close();
        }

        public boolean handleKeyword(String keyword) {
            if (keyword.equals("\r") || keyword.equals("\n")) {
                keyword = "par";
            }
            if (keyword.equals("line")) {
                RTFReader.this.convertedContent.append("<br>");
            }
            if (keyword.equals("intbl")) {
                RTFReader.this.intbl = true;
                return true;
            }
            if (keyword.equals("par")) {
                if (!RTFReader.this.intbl && RTFReader.this.currentlyInTable) {
                    RTFReader.this.convertedContent.append("\n</table>\n");
                    RTFReader.this.currentlyInTable = false;
                    this.findSpanningCells();
                }
                this.endParagraph();
                this.resetParagraphAttributes();
                return true;
            }
            if (keyword.equals("sect")) {
                this.endSection();
                return true;
            }
            return super.handleKeyword(keyword);
        }

        void findSpanningCells() {
            int i;
            int indexMaxCols = 0;
            int maxColsNumber = 0;
            Vector maxColsVector = null;
            int maxWidth = 0;
            for (int i2 = 0; i2 < RTFReader.this.allRowsVector.size(); ++i2) {
                Vector currentRow = (Vector)RTFReader.this.allRowsVector.elementAt(i2);
                for (int j = 0; j < currentRow.size(); ++j) {
                    int currCellSize = (Integer)currentRow.elementAt(j);
                    if (currCellSize <= maxWidth) continue;
                    maxWidth = currCellSize;
                }
            }
            int secondMaxWidth = 0;
            for (int i3 = 0; i3 < RTFReader.this.allRowsVector.size(); ++i3) {
                Vector currentRow = (Vector)RTFReader.this.allRowsVector.elementAt(i3);
                for (int j = 0; j < currentRow.size(); ++j) {
                    int currCellSize = (Integer)currentRow.elementAt(j);
                    if (secondMaxWidth == 0) {
                        secondMaxWidth = currCellSize;
                        continue;
                    }
                    if (currCellSize >= secondMaxWidth) continue;
                    secondMaxWidth = currCellSize;
                }
            }
            int difference = Math.round((float)maxWidth / (float)secondMaxWidth);
            for (i = 0; i < RTFReader.this.allRowsVector.size(); ++i) {
                Vector currentRow = (Vector)RTFReader.this.allRowsVector.elementAt(i);
                if (currentRow.size() <= maxColsNumber) continue;
                indexMaxCols = i;
                maxColsNumber = currentRow.size();
                maxColsVector = (Vector)RTFReader.this.allRowsVector.elementAt(i);
            }
            for (i = 0; i < RTFReader.this.allRowsVector.size(); ++i) {
                Vector currentRow = (Vector)RTFReader.this.allRowsVector.elementAt(i);
                for (int j = 0; j < currentRow.size(); ++j) {
                    int colSpan = 0;
                    int currCellSize = (Integer)currentRow.elementAt(j);
                    int maxColsCellSizeAtIndex = (Integer)maxColsVector.elementAt(j);
                    boolean currentWidth = false;
                    colSpan = difference == 0 ? 1 : Math.round((float)currCellSize / (float)difference);
                    RTFReader.this.convertedContent = new StringBuffer(SferyxUtilities.replaceAll(RTFReader.this.convertedContent.toString(), "colspan=\"" + i + "x" + j + "\"", "colspan=\"" + colSpan + "\""));
                }
            }
        }

        protected void beginParagraph() {
            if (RTFReader.this.inTable && !RTFReader.this.inCell) {
                return;
            }
            RTFReader.this.inParagraph = true;
            MutableAttributeSet pgfAttributes = this.currentParagraphAttributes();
            String align = "left";
            int alignment = StyleConstants.getAlignment(pgfAttributes);
            if (alignment == 0) {
                align = "left";
            } else if (alignment == 2) {
                align = "right";
            } else if (alignment == 1) {
                align = "center";
            } else if (alignment == 3) {
                align = "justify";
            }
            float indexN = (float)((double)StyleConstants.getLeftIndent(pgfAttributes) * 1.33);
            String indent = "margin-left:" + indexN + "px;";
            float bottom = 0.0f;
            if (pgfAttributes.isDefined(StyleConstants.SpaceBelow) && pgfAttributes.containsAttribute(StyleConstants.SpaceBelow, pgfAttributes.getAttribute(StyleConstants.SpaceBelow))) {
                bottom = (float)((double)StyleConstants.getSpaceBelow(pgfAttributes) * 1.33);
            }
            String bottomMargin = "margin-bottom:" + bottom + "px;";
            RTFReader.this.convertedContent.append("<p style=\"margin-top:0px;" + bottomMargin + indent + "align=\"" + align + "\" >");
        }

        protected void endParagraph() {
            if (RTFReader.this.inTable && !RTFReader.this.inCell) {
                return;
            }
            MutableAttributeSet pgfAttributes = this.currentParagraphAttributes();
            MutableAttributeSet chrAttributes = this.currentTextAttributes();
            this.finishParagraph(pgfAttributes, chrAttributes);
            if (!RTFReader.this.inParagraph) {
                RTFReader.this.convertedContent.append("<p style=\"margin-top:0px;margin-bottom:0px;\">");
            }
            RTFReader.this.inParagraph = false;
            RTFReader.this.convertedContent.append("</p>");
        }

        abstract void finishParagraph(AttributeSet var1, AttributeSet var2);

        abstract void endSection();
    }

    abstract class AttributeTrackingDestination
    implements Destination {
        MutableAttributeSet characterAttributes = this.rootCharacterAttributes();
        MutableAttributeSet paragraphAttributes;
        MutableAttributeSet sectionAttributes;
        int lastCellX = 0;

        public AttributeTrackingDestination() {
            RTFReader.this.parserState.put("chr", this.characterAttributes);
            this.paragraphAttributes = this.rootParagraphAttributes();
            RTFReader.this.parserState.put("pgf", this.paragraphAttributes);
            this.sectionAttributes = this.rootSectionAttributes();
            RTFReader.this.parserState.put("sec", this.sectionAttributes);
        }

        public abstract void handleText(String var1);

        public void handleBinaryBlob(byte[] data) {
            RTFReader.this.warning("Unexpected binary data in RTF file.");
        }

        public void begingroup() {
            MutableAttributeSet characterParent = this.currentTextAttributes();
            MutableAttributeSet paragraphParent = this.currentParagraphAttributes();
            AttributeSet sectionParent = this.currentSectionAttributes();
            this.characterAttributes = new SimpleAttributeSet();
            this.characterAttributes.addAttributes(characterParent);
            RTFReader.this.parserState.put("chr", this.characterAttributes);
            this.paragraphAttributes = new SimpleAttributeSet();
            this.paragraphAttributes.addAttributes(paragraphParent);
            RTFReader.this.parserState.put("pgf", this.paragraphAttributes);
            this.sectionAttributes = new SimpleAttributeSet();
            this.sectionAttributes.addAttributes(sectionParent);
            RTFReader.this.parserState.put("sec", this.sectionAttributes);
        }

        public void endgroup(Dictionary oldState) {
            this.characterAttributes = (MutableAttributeSet)RTFReader.this.parserState.get("chr");
            this.paragraphAttributes = (MutableAttributeSet)RTFReader.this.parserState.get("pgf");
            this.sectionAttributes = (MutableAttributeSet)RTFReader.this.parserState.get("sec");
        }

        public void close() {
        }

        public boolean handleKeyword(String keyword) {
            if (keyword.equals("ulnone")) {
                return this.handleKeyword("ul", 0);
            }
            if (keyword.equals("strike")) {
                StyleConstants.setStrikeThrough(this.characterAttributes, true);
                return true;
            }
            Object item = straightforwardAttributes.get(keyword);
            if (item != null) {
                boolean ok;
                RTFAttribute attr = (RTFAttribute)item;
                switch (attr.domain()) {
                    case 0: {
                        ok = attr.set(this.characterAttributes);
                        break;
                    }
                    case 1: {
                        ok = attr.set(this.paragraphAttributes);
                        break;
                    }
                    case 2: {
                        ok = attr.set(this.sectionAttributes);
                        break;
                    }
                    case 4: {
                        ((RTFReader)RTFReader.this).mockery.backing = RTFReader.this.parserState;
                        ok = attr.set(RTFReader.this.mockery);
                        ((RTFReader)RTFReader.this).mockery.backing = null;
                        break;
                    }
                    case 3: {
                        ok = attr.set(RTFReader.this.documentAttributes);
                        break;
                    }
                    default: {
                        ok = false;
                    }
                }
                if (ok) {
                    return true;
                }
            }
            if (keyword.equals("plain")) {
                this.resetCharacterAttributes();
                return true;
            }
            if (keyword.equals("pard")) {
                RTFReader.this.intbl = false;
                this.resetParagraphAttributes();
                return true;
            }
            if (keyword.equals("sectd")) {
                this.resetSectionAttributes();
                return true;
            }
            if (keyword.equals("super")) {
                StyleConstants.setSuperscript(this.characterAttributes, true);
                return true;
            }
            if (keyword.equals("sub")) {
                StyleConstants.setSubscript(this.characterAttributes, true);
                return true;
            }
            if (keyword.equals("nosupersub")) {
                StyleConstants.setSubscript(this.characterAttributes, false);
                StyleConstants.setSuperscript(this.characterAttributes, false);
                return true;
            }
            return false;
        }

        public boolean handleKeyword(String keyword, int parameter) {
            boolean booleanParameter;
            if (RTFReader.this.currentRowCellCount == 0) {
                this.lastCellX = 0;
            }
            boolean bl = booleanParameter = parameter != 0;
            if (keyword.equals("fc")) {
                keyword = "cf";
            }
            if (keyword.equals("highlight")) {
                keyword = "cb";
            }
            if (keyword.equals("chcbpat")) {
                keyword = "cb";
            }
            if (keyword.equals("f")) {
                RTFReader.this.fontsInited = true;
                RTFReader.this.parserState.put(keyword, new Integer(parameter));
                return true;
            }
            if (keyword.equals("cf")) {
                RTFReader.this.parserState.put(keyword, new Integer(parameter));
                return true;
            }
            if (keyword.equals("cb")) {
                RTFReader.this.parserState.put(keyword, new Integer(parameter));
                return true;
            }
            if (keyword.equals("clcbpat")) {
                if (RTFReader.this.colorTable != null) {
                    Color bg = RTFReader.this.colorTable[parameter];
                    RTFReader.this.cellBackgroundAttributes.addElement(bg);
                }
                return true;
            }
            if (keyword.equals("clshdng")) {
                float f = 0.0f;
                f = parameter == 1000 ? 0.9f : (parameter == 2000 ? 0.8f : (float)(1.0 - (double)(parameter / 10000)));
                Color c = Color.getHSBColor(0.0f, 0.0f, f);
                RTFReader.this.cellBackgroundAttributes.addElement(c);
                return true;
            }
            if (keyword.equalsIgnoreCase("clwWidth")) {
                return true;
            }
            if (keyword.equals("trleft")) {
                this.lastCellX = parameter;
                return true;
            }
            if (keyword.equals("cellx")) {
                ++RTFReader.this.currentRowCellCount;
                if (RTFReader.this.cellBackgroundAttributes.size() < RTFReader.this.currentRowCellCount) {
                    RTFReader.this.cellBackgroundAttributes.addElement("empty");
                }
                int diff = parameter - this.lastCellX;
                RTFReader.this.cellWidthAttributes.addElement(new Integer((int)((double)((float)diff / 20.0f) * 1.33)));
                this.lastCellX = parameter;
                return true;
            }
            if (keyword.equals("strike")) {
                if (parameter == 1) {
                    StyleConstants.setStrikeThrough(this.characterAttributes, true);
                } else if (parameter == 0) {
                    StyleConstants.setStrikeThrough(this.characterAttributes, false);
                }
                return true;
            }
            Object item = straightforwardAttributes.get(keyword);
            if (item != null) {
                boolean ok;
                RTFAttribute attr = (RTFAttribute)item;
                switch (attr.domain()) {
                    case 0: {
                        ok = attr.set(this.characterAttributes, parameter);
                        break;
                    }
                    case 1: {
                        ok = attr.set(this.paragraphAttributes, parameter);
                        break;
                    }
                    case 2: {
                        ok = attr.set(this.sectionAttributes, parameter);
                        break;
                    }
                    case 4: {
                        ((RTFReader)RTFReader.this).mockery.backing = RTFReader.this.parserState;
                        ok = attr.set(RTFReader.this.mockery, parameter);
                        ((RTFReader)RTFReader.this).mockery.backing = null;
                        break;
                    }
                    case 3: {
                        ok = attr.set(RTFReader.this.documentAttributes, parameter);
                        break;
                    }
                    default: {
                        ok = false;
                    }
                }
                if (ok) {
                    return true;
                }
            }
            if (keyword.equals("fs")) {
                StyleConstants.setFontSize(this.characterAttributes, parameter / 2);
                return true;
            }
            if (keyword.equals("sl")) {
                if (parameter == 1000) {
                    this.characterAttributes.removeAttribute(StyleConstants.LineSpacing);
                } else {
                    StyleConstants.setLineSpacing(this.characterAttributes, (float)parameter / 20.0f);
                }
                return true;
            }
            if (keyword.equals("sa")) {
                if (parameter == 1000) {
                    this.paragraphAttributes.removeAttribute(StyleConstants.SpaceBelow);
                } else {
                    StyleConstants.setSpaceBelow(this.paragraphAttributes, (float)parameter / 20.0f);
                }
                return true;
            }
            if (keyword.equals("sb")) {
                if (parameter == 1000) {
                    this.paragraphAttributes.removeAttribute(StyleConstants.SpaceAbove);
                } else {
                    StyleConstants.setSpaceAbove(this.paragraphAttributes, (float)parameter / 20.0f);
                }
                return true;
            }
            if (keyword.equals("tx") || keyword.equals("tb")) {
                Integer stopCount;
                float tabPosition = (float)parameter / 20.0f;
                int tabAlignment = 0;
                Number item2 = (Number)RTFReader.this.parserState.get(RTFReader.TabAlignmentKey);
                if (item2 != null) {
                    tabAlignment = item2.intValue();
                }
                int tabLeader = 0;
                item2 = (Number)RTFReader.this.parserState.get(RTFReader.TabLeaderKey);
                if (item2 != null) {
                    tabLeader = item2.intValue();
                }
                if (keyword.equals("tb")) {
                    tabAlignment = 5;
                }
                RTFReader.this.parserState.remove(RTFReader.TabAlignmentKey);
                RTFReader.this.parserState.remove(RTFReader.TabLeaderKey);
                TabStop newStop = new TabStop(tabPosition, tabAlignment, tabLeader);
                Hashtable<Object, Serializable> tabs = (Hashtable<Object, Serializable>)RTFReader.this.parserState.get("_tabs");
                if (tabs == null) {
                    tabs = new Hashtable<Object, Serializable>();
                    RTFReader.this.parserState.put("_tabs", tabs);
                    stopCount = new Integer(1);
                } else {
                    stopCount = (Integer)((Dictionary)tabs).get("stop count");
                    stopCount = new Integer(1 + stopCount);
                }
                ((Dictionary)tabs).put(stopCount, newStop);
                ((Dictionary)tabs).put("stop count", stopCount);
                RTFReader.this.parserState.remove("_tabs_immutable");
                return true;
            }
            if (keyword.equals("s") && RTFReader.this.paragraphStyles != null) {
                RTFReader.this.parserState.put("paragraphStyle", RTFReader.this.paragraphStyles[parameter]);
                return true;
            }
            if (keyword.equals("cs") && RTFReader.this.characterStyles != null) {
                RTFReader.this.parserState.put("characterStyle", RTFReader.this.characterStyles[parameter]);
                return true;
            }
            if (keyword.equals("ds") && RTFReader.this.sectionStyles != null) {
                RTFReader.this.parserState.put("sectionStyle", RTFReader.this.sectionStyles[parameter]);
                return true;
            }
            return false;
        }

        protected MutableAttributeSet rootCharacterAttributes() {
            SimpleAttributeSet set = new SimpleAttributeSet();
            StyleConstants.setItalic(set, false);
            StyleConstants.setBold(set, false);
            StyleConstants.setUnderline(set, false);
            StyleConstants.setForeground(set, RTFReader.this.defaultColor());
            StyleConstants.setStrikeThrough(set, false);
            StyleConstants.setSubscript(set, false);
            StyleConstants.setSuperscript(set, false);
            return set;
        }

        protected MutableAttributeSet rootParagraphAttributes() {
            SimpleAttributeSet set = new SimpleAttributeSet();
            StyleConstants.setLeftIndent(set, 0.0f);
            StyleConstants.setRightIndent(set, 0.0f);
            StyleConstants.setSpaceBelow(set, 0.0f);
            StyleConstants.setFirstLineIndent(set, 0.0f);
            set.setResolveParent(RTFReader.this.target.getStyle("default"));
            return set;
        }

        protected MutableAttributeSet rootSectionAttributes() {
            SimpleAttributeSet set = new SimpleAttributeSet();
            return set;
        }

        MutableAttributeSet currentTextAttributes() {
            Style characterStyle;
            Integer stateItem;
            SimpleAttributeSet attributes = new SimpleAttributeSet(this.characterAttributes);
            Integer fontnum = (Integer)RTFReader.this.parserState.get("f");
            String fontFamily = fontnum != null ? (String)RTFReader.this.fontTable.get(fontnum) : null;
            if (fontFamily != null) {
                StyleConstants.setFontFamily(attributes, fontFamily);
            } else {
                attributes.removeAttribute(StyleConstants.FontFamily);
            }
            if (RTFReader.this.colorTable != null) {
                stateItem = (Integer)RTFReader.this.parserState.get("cf");
                if (stateItem != null) {
                    Color fg = RTFReader.this.colorTable[stateItem];
                    StyleConstants.setForeground(attributes, fg);
                } else {
                    attributes.removeAttribute(StyleConstants.Foreground);
                }
            }
            if (RTFReader.this.colorTable != null) {
                stateItem = (Integer)RTFReader.this.parserState.get("cb");
                if (stateItem != null) {
                    Color bg = RTFReader.this.colorTable[stateItem];
                    attributes.addAttribute(StyleConstants.Background, bg);
                } else {
                    attributes.removeAttribute(StyleConstants.Background);
                }
            }
            if ((characterStyle = (Style)RTFReader.this.parserState.get("characterStyle")) != null) {
                attributes.setResolveParent(characterStyle);
            }
            return attributes;
        }

        MutableAttributeSet currentParagraphAttributes() {
            Style paragraphStyle;
            Dictionary workingTabs;
            SimpleAttributeSet bld = new SimpleAttributeSet(this.paragraphAttributes);
            TabStop[] tabs = (TabStop[])RTFReader.this.parserState.get("_tabs_immutable");
            if (tabs == null && (workingTabs = (Dictionary)RTFReader.this.parserState.get("_tabs")) != null) {
                int count = (Integer)workingTabs.get("stop count");
                tabs = new TabStop[count];
                for (int ix = 1; ix <= count; ++ix) {
                    tabs[ix - 1] = (TabStop)workingTabs.get(new Integer(ix));
                }
                RTFReader.this.parserState.put("_tabs_immutable", tabs);
            }
            if (tabs != null) {
                bld.addAttribute("tabs", tabs);
            }
            if ((paragraphStyle = (Style)RTFReader.this.parserState.get("paragraphStyle")) != null) {
                bld.setResolveParent(paragraphStyle);
            }
            return bld;
        }

        public AttributeSet currentSectionAttributes() {
            SimpleAttributeSet attributes = new SimpleAttributeSet(this.sectionAttributes);
            Style sectionStyle = (Style)RTFReader.this.parserState.get("sectionStyle");
            if (sectionStyle != null) {
                attributes.setResolveParent(sectionStyle);
            }
            return attributes;
        }

        protected void resetCharacterAttributes() {
            this.handleKeyword("f", 0);
            this.handleKeyword("cf", 0);
            this.handleKeyword("fs", 24);
            Enumeration attributes = straightforwardAttributes.elements();
            while (attributes.hasMoreElements()) {
                RTFAttribute attr = (RTFAttribute)attributes.nextElement();
                if (attr.domain() != 0) continue;
                attr.setDefault(this.characterAttributes);
            }
            this.handleKeyword("sl", 1000);
            StyleConstants.setStrikeThrough(this.characterAttributes, false);
            StyleConstants.setSubscript(this.characterAttributes, false);
            StyleConstants.setSuperscript(this.characterAttributes, false);
            RTFReader.this.parserState.remove("characterStyle");
        }

        protected void resetParagraphAttributes() {
            RTFReader.this.parserState.remove("_tabs");
            RTFReader.this.parserState.remove("_tabs_immutable");
            RTFReader.this.parserState.remove("paragraphStyle");
            StyleConstants.setAlignment(this.paragraphAttributes, 0);
            StyleConstants.setSpaceBelow(this.paragraphAttributes, 0.0f);
            Enumeration attributes = straightforwardAttributes.elements();
            while (attributes.hasMoreElements()) {
                RTFAttribute attr = (RTFAttribute)attributes.nextElement();
                if (attr.domain() != 1) continue;
                attr.setDefault(this.characterAttributes);
            }
        }

        protected void resetSectionAttributes() {
            Enumeration attributes = straightforwardAttributes.elements();
            while (attributes.hasMoreElements()) {
                RTFAttribute attr = (RTFAttribute)attributes.nextElement();
                if (attr.domain() != 2) continue;
                attr.setDefault(this.characterAttributes);
            }
            RTFReader.this.parserState.remove("sectionStyle");
        }
    }

    class InfoDestination
    extends DiscardingDestination
    implements Destination {
        InfoDestination() {
        }
    }

    class StylesheetDestination
    extends DiscardingDestination
    implements Destination {
        Dictionary definedStyles = new Hashtable();

        public void begingroup() {
            RTFReader.this.setRTFDestination(new StyleDefiningDestination());
        }

        public void close() {
            Object[] styleArray;
            Vector chrStyles = new Vector();
            Vector pgfStyles = new Vector();
            Vector<Style> secStyles = new Vector<Style>();
            Enumeration styles = this.definedStyles.elements();
            while (styles.hasMoreElements()) {
                StyleDefiningDestination style = (StyleDefiningDestination)styles.nextElement();
                Style defined = style.realize();
                RTFReader.this.warning("Style " + style.number + " (" + style.styleName + "): " + defined);
                String stype = (String)defined.getAttribute("style:type");
                Vector<Style> toSet = stype.equals("section") ? secStyles : (stype.equals("character") ? chrStyles : pgfStyles);
                if (toSet.size() <= style.number) {
                    toSet.setSize(style.number + 1);
                }
                toSet.setElementAt(defined, style.number);
            }
            if (!chrStyles.isEmpty()) {
                styleArray = new Style[chrStyles.size()];
                chrStyles.copyInto(styleArray);
                RTFReader.this.characterStyles = styleArray;
            }
            if (!pgfStyles.isEmpty()) {
                styleArray = new Style[pgfStyles.size()];
                pgfStyles.copyInto(styleArray);
                RTFReader.this.paragraphStyles = styleArray;
            }
            if (!secStyles.isEmpty()) {
                styleArray = new Style[secStyles.size()];
                secStyles.copyInto(styleArray);
                RTFReader.this.sectionStyles = styleArray;
            }
        }

        class StyleDefiningDestination
        extends AttributeTrackingDestination
        implements Destination {
            final int STYLENUMBER_NONE = 222;
            boolean additive = false;
            boolean characterStyle = false;
            boolean sectionStyle = false;
            public String styleName = null;
            public int number = 0;
            int basedOn = 222;
            int nextStyle = 222;
            boolean hidden = false;
            Style realizedStyle;

            public void handleText(String text) {
                this.styleName = this.styleName != null ? this.styleName + text : text;
            }

            public void close() {
                int semicolon;
                if (this.styleName != null && (semicolon = this.styleName.indexOf(59)) > 0) {
                    this.styleName = this.styleName.substring(0, semicolon);
                }
                StylesheetDestination.this.definedStyles.put(new Integer(this.number), this);
                super.close();
            }

            public boolean handleKeyword(String keyword) {
                if (keyword.equals("additive")) {
                    this.additive = true;
                    return true;
                }
                if (keyword.equals("shidden")) {
                    this.hidden = true;
                    return true;
                }
                return super.handleKeyword(keyword);
            }

            public boolean handleKeyword(String keyword, int parameter) {
                if (keyword.equals("s")) {
                    this.characterStyle = false;
                    this.sectionStyle = false;
                    this.number = parameter;
                } else if (keyword.equals("cs")) {
                    this.characterStyle = true;
                    this.sectionStyle = false;
                    this.number = parameter;
                } else if (keyword.equals("ds")) {
                    this.characterStyle = false;
                    this.sectionStyle = true;
                    this.number = parameter;
                } else if (keyword.equals("sbasedon")) {
                    this.basedOn = parameter;
                } else if (keyword.equals("snext")) {
                    this.nextStyle = parameter;
                } else {
                    return super.handleKeyword(keyword, parameter);
                }
                return true;
            }

            public Style realize() {
                StyleDefiningDestination styleDest;
                Style basis = null;
                Style next = null;
                if (this.realizedStyle != null) {
                    return this.realizedStyle;
                }
                if (this.basedOn != 222 && (styleDest = (StyleDefiningDestination)StylesheetDestination.this.definedStyles.get(new Integer(this.basedOn))) != null) {
                    basis = styleDest.realize();
                }
                this.realizedStyle = ((StylesheetDestination)StylesheetDestination.this).RTFReader.this.target.addStyle(this.styleName, basis);
                if (this.characterStyle) {
                    this.realizedStyle.addAttributes(this.currentTextAttributes());
                    this.realizedStyle.addAttribute("style:type", "character");
                } else if (this.sectionStyle) {
                    this.realizedStyle.addAttributes(this.currentSectionAttributes());
                    this.realizedStyle.addAttribute("style:type", "section");
                } else {
                    this.realizedStyle.addAttributes(this.currentParagraphAttributes());
                    this.realizedStyle.addAttribute("style:type", "paragraph");
                }
                if (this.nextStyle != 222 && (styleDest = (StyleDefiningDestination)StylesheetDestination.this.definedStyles.get(new Integer(this.nextStyle))) != null) {
                    next = styleDest.realize();
                }
                if (next != null) {
                    this.realizedStyle.addAttribute("style:nextStyle", next);
                }
                this.realizedStyle.addAttribute("style:additive", this.additive);
                this.realizedStyle.addAttribute("style:hidden", this.hidden);
                return this.realizedStyle;
            }
        }
    }

    class ColortblDestination
    implements Destination {
        int red = 0;
        int green = 0;
        int blue = 0;
        Vector proTemTable = new Vector();

        public void handleText(String text) {
            int index = 0;
            for (index = 0; index < text.length(); ++index) {
                if (text.charAt(index) != ';') continue;
                Color newColor = new Color(this.red, this.green, this.blue);
                this.proTemTable.addElement(newColor);
            }
        }

        public void close() {
            int count = this.proTemTable.size();
            RTFReader.this.warning("Done reading color table, " + count + " entries.");
            RTFReader.this.colorTable = new Color[count];
            this.proTemTable.copyInto(RTFReader.this.colorTable);
        }

        public boolean handleKeyword(String keyword, int parameter) {
            if (keyword.equals("red")) {
                this.red = parameter;
            } else if (keyword.equals("green")) {
                this.green = parameter;
            } else if (keyword.equals("blue")) {
                this.blue = parameter;
            } else {
                return false;
            }
            return true;
        }

        public boolean handleKeyword(String keyword) {
            return false;
        }

        public void begingroup() {
        }

        public void endgroup(Dictionary oldState) {
        }

        public void handleBinaryBlob(byte[] data) {
        }
    }

    class FonttblDestination
    implements Destination {
        int nextFontNumber;
        String nextFontFamily;

        FonttblDestination() {
        }

        public void handleBinaryBlob(byte[] data) {
        }

        public void handleText(String text) {
            int semicolon = text.indexOf(59);
            String fontName = semicolon > 0 ? text.substring(0, semicolon) : text;
            RTFReader.this.fontTable.put(new Integer(this.nextFontNumber), fontName);
            this.nextFontNumber = -1;
            this.nextFontFamily = null;
        }

        public boolean handleKeyword(String keyword) {
            if (keyword.charAt(0) == 'f') {
                this.nextFontFamily = keyword.substring(1);
                return true;
            }
            return false;
        }

        public boolean handleKeyword(String keyword, int parameter) {
            if (keyword.equals("f")) {
                this.nextFontNumber = parameter;
                return true;
            }
            return false;
        }

        public void begingroup() {
        }

        public void endgroup(Dictionary oldState) {
        }

        public void close() {
            Enumeration nums = RTFReader.this.fontTable.keys();
            RTFReader.this.warning("Done reading font table.");
            while (nums.hasMoreElements()) {
                Integer num = (Integer)nums.nextElement();
                RTFReader.this.warning("Number " + num + ": " + RTFReader.this.fontTable.get(num));
            }
        }
    }

    class DiscardingDestination
    implements Destination {
        DiscardingDestination() {
        }

        public void handleBinaryBlob(byte[] data) {
        }

        public void handleText(String text) {
        }

        public boolean handleKeyword(String text) {
            return true;
        }

        public boolean handleKeyword(String text, int parameter) {
            return true;
        }

        public void begingroup() {
        }

        public void endgroup(Dictionary oldState) {
        }

        public void close() {
        }
    }

    static interface Destination {
        public void handleBinaryBlob(byte[] var1);

        public void handleText(String var1);

        public boolean handleKeyword(String var1);

        public boolean handleKeyword(String var1, int var2);

        public void begingroup();

        public void endgroup(Dictionary var1);

        public void close();
    }
}

