/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors.parser;

import java.io.CharArrayReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.text.html.parser.AttributeList;
import javax.swing.text.html.parser.ContentModel;
import javax.swing.text.html.parser.Element;
import javax.swing.text.html.parser.Entity;
import javax.swing.text.html.parser.Parser;
import javax.swing.text.html.parser.TagElement;
import sferyx.administration.editors.EditorHTMLDocument;
import sferyx.administration.editors.HTMLEditor;
import sferyx.administration.editors.RubyTag;
import sferyx.administration.editors.SferyxUtilities;
import sferyx.administration.editors.parser.CustomDTD;
import sferyx.administration.editors.parser.TagStack;

class CustomParser
extends Parser {
    boolean discardAllProprietaryTags = false;
    private int inbody;
    private int intitle;
    private int inhead;
    private int instyle;
    private int inscript;
    private boolean seentitle;
    private HTMLEditorKit.ParserCallback callback = null;
    private boolean ignoreCharSet = false;
    private char[] text = new char[1024];
    private int textpos = 0;
    private TagElement last;
    private boolean space;
    private char[] str = new char[128];
    private int strpos = 0;
    protected CustomDTD dtd = null;
    private int ch;
    private int ln;
    private Reader in;
    private Element recent;
    private TagStack stack;
    private boolean skipTag = false;
    private TagElement lastFormSent = null;
    private SimpleAttributeSet attributes = new SimpleAttributeSet();
    private boolean seenHtml = false;
    private boolean seenHead = false;
    private boolean seenBody = false;
    private boolean ignoreSpace;
    protected boolean strict = false;
    private int crlfCount;
    private int crCount;
    private int lfCount;
    private int currentBlockStartPos;
    private int lastBlockStartPos;
    private static final char[] cp1252Map = new char[]{'\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\u0160', '\u2039', '\u0152', '\u008d', '\u008e', '\u008f', '\u0090', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\u02dc', '\u2122', '\u0161', '\u203a', '\u0153', '\u009d', '\u009e', '\u0178'};
    boolean convertSymbolEntities = false;
    StringBuffer strBuffer = new StringBuffer();
    static Hashtable extendedEntityMap = new Hashtable();
    private char[] buf = new char[1];
    private int pos;
    private int len;
    private int currentPosition;

    public CustomParser(CustomDTD dtd) {
        super(dtd);
        this.dtd = dtd;
        this.initExtendedEntitiesTable();
    }

    public void initExtendedEntitiesTable() {
        extendedEntityMap.put("nbsp", "160");
        extendedEntityMap.put("iexcl", "161");
        extendedEntityMap.put("curren", "164");
        extendedEntityMap.put("cent", "162");
        extendedEntityMap.put("pound", "163");
        extendedEntityMap.put("yen", "165");
        extendedEntityMap.put("brvbar", "166");
        extendedEntityMap.put("sect", "167");
        extendedEntityMap.put("uml", "168");
        extendedEntityMap.put("copy", "169");
        extendedEntityMap.put("ordf", "170");
        extendedEntityMap.put("laquo", "171");
        extendedEntityMap.put("not", "172");
        extendedEntityMap.put("shy", "173");
        extendedEntityMap.put("reg", "174");
        extendedEntityMap.put("trade", "8482");
        extendedEntityMap.put("macr", "175");
        extendedEntityMap.put("deg", "176");
        extendedEntityMap.put("plusmn;", "177");
        extendedEntityMap.put("sup2", "178");
        extendedEntityMap.put("sup3", "179");
        extendedEntityMap.put("acute", "180");
        extendedEntityMap.put("micro", "181");
        extendedEntityMap.put("para", "182");
        extendedEntityMap.put("middot", "183");
        extendedEntityMap.put("cedil", "184");
        extendedEntityMap.put("sup1", "185");
        extendedEntityMap.put("ordm", "186");
        extendedEntityMap.put("raquo", "187");
        extendedEntityMap.put("frac14", "188");
        extendedEntityMap.put("frac12", "189");
        extendedEntityMap.put("frac34", "190");
        extendedEntityMap.put("iquest", "191");
        extendedEntityMap.put("times", "215");
        extendedEntityMap.put("divide", "247");
        extendedEntityMap.put("OElig", "338");
        extendedEntityMap.put("oelig", "339");
        extendedEntityMap.put("Scaron", "352");
        extendedEntityMap.put("scaron", "353");
        extendedEntityMap.put("Yuml", "376");
        extendedEntityMap.put("circ", "710");
        extendedEntityMap.put("tilde", "732");
        extendedEntityMap.put("ensp", "8194");
        extendedEntityMap.put("emsp", "8195");
        extendedEntityMap.put("thinsp", "8201");
        extendedEntityMap.put("zwnj", "8204");
        extendedEntityMap.put("zwj", "8205");
        extendedEntityMap.put("lrm", "8206");
        extendedEntityMap.put("rlm", "8207");
        extendedEntityMap.put("ndash", "8211");
        extendedEntityMap.put("mdash", "8212");
        extendedEntityMap.put("lsquo", "8216");
        extendedEntityMap.put("rsquo", "8217");
        extendedEntityMap.put("sbquo", "8218");
        extendedEntityMap.put("ldquo", "8220");
        extendedEntityMap.put("rdquo", "8221");
        extendedEntityMap.put("bdquo", "8222");
        extendedEntityMap.put("dagger", "8224");
        extendedEntityMap.put("Dagger", "8225");
        extendedEntityMap.put("hellip", "8230");
        extendedEntityMap.put("permil", "8240");
        extendedEntityMap.put("lsaquo", "8249");
        extendedEntityMap.put("rsaquo", "8250");
        extendedEntityMap.put("euro", "8364");
        extendedEntityMap.put("&Agrave", "192");
        extendedEntityMap.put("&Aacute", "193");
        extendedEntityMap.put("&Acirc", "194");
        extendedEntityMap.put("&Atilde", "195");
        extendedEntityMap.put("&Auml", "196");
        extendedEntityMap.put("&Aring", "197");
        extendedEntityMap.put("&AElig", "198");
        extendedEntityMap.put("&Ccedil", "199");
        extendedEntityMap.put("&Egrave", "200");
        extendedEntityMap.put("&Eacute", "201");
        extendedEntityMap.put("&Ecirc", "202");
        extendedEntityMap.put("&Euml", "203");
        extendedEntityMap.put("&Igrave", "204");
        extendedEntityMap.put("&Iacute", "205");
        extendedEntityMap.put("&Icirc", "206");
        extendedEntityMap.put("&Iuml", "207");
        extendedEntityMap.put("&ETH", "208");
        extendedEntityMap.put("&Ntilde", "209");
        extendedEntityMap.put("&Ograve", "210");
        extendedEntityMap.put("&Oacute", "211");
        extendedEntityMap.put("&Ocirc", "212");
        extendedEntityMap.put("&Otilde", "213");
        extendedEntityMap.put("&Ouml", "214");
        extendedEntityMap.put("&Oslash", "216");
        extendedEntityMap.put("&Ugrave", "217");
        extendedEntityMap.put("&Uacute", "218");
        extendedEntityMap.put("&Ucirc", "219");
        extendedEntityMap.put("&Uuml", "220");
        extendedEntityMap.put("&Yacute", "221");
        extendedEntityMap.put("&THORN", "222");
        extendedEntityMap.put("&szlig", "223");
        extendedEntityMap.put("&agrave", "224");
        extendedEntityMap.put("&aacute", "225");
        extendedEntityMap.put("&acirc", "226");
        extendedEntityMap.put("&atilde", "227");
        extendedEntityMap.put("&auml", "228");
        extendedEntityMap.put("&aring", "229");
        extendedEntityMap.put("&aelig", "230");
        extendedEntityMap.put("&ccedil", "231");
        extendedEntityMap.put("&egrave", "232");
        extendedEntityMap.put("&eacute", "233");
        extendedEntityMap.put("&ecirc", "234");
        extendedEntityMap.put("&euml", "235");
        extendedEntityMap.put("&igrave", "236");
        extendedEntityMap.put("&iacute", "237");
        extendedEntityMap.put("&icirc", "238");
        extendedEntityMap.put("&iuml", "239");
        extendedEntityMap.put("&eth", "240");
        extendedEntityMap.put("&ntilde", "241");
        extendedEntityMap.put("&ograve", "242");
        extendedEntityMap.put("&oacute", "243");
        extendedEntityMap.put("&ocirc", "244");
        extendedEntityMap.put("&otilde", "245");
        extendedEntityMap.put("&ouml", "246");
        extendedEntityMap.put("&oslash", "248");
        extendedEntityMap.put("&ugrave", "249");
        extendedEntityMap.put("&uacute", "250");
        extendedEntityMap.put("&ucirc", "251");
        extendedEntityMap.put("&uuml", "252");
        extendedEntityMap.put("&yacute", "253");
        extendedEntityMap.put("&thorn", "254");
        extendedEntityMap.put("&yuml", "255");
        extendedEntityMap.put("crarr", "8629");
        extendedEntityMap.put("darr", "8595");
        extendedEntityMap.put("dArr", "8659");
        extendedEntityMap.put("harr", "8596");
        extendedEntityMap.put("hArr", "8660");
        extendedEntityMap.put("larr", "8592");
        extendedEntityMap.put("lArr", "8656");
        extendedEntityMap.put("rarr", "8594");
        extendedEntityMap.put("rArr", "8658");
        extendedEntityMap.put("uarr", "8593");
        extendedEntityMap.put("uArr", "8657");
        extendedEntityMap.put("clubs", "9827");
        extendedEntityMap.put("diams", "9830");
        extendedEntityMap.put("hearts", "9829");
        extendedEntityMap.put("spades", "9824");
        extendedEntityMap.put("loz", "9674");
        extendedEntityMap.put("deg", "176");
        extendedEntityMap.put("divide", "247");
        extendedEntityMap.put("frac12", "189");
        extendedEntityMap.put("frac14", "188");
        extendedEntityMap.put("frac34", "190");
        extendedEntityMap.put("ge", "8805");
        extendedEntityMap.put("le", "8804");
        extendedEntityMap.put("minus", "8722");
        extendedEntityMap.put("sup2", "178");
        extendedEntityMap.put("sup3", "179");
        extendedEntityMap.put("times", "215");
        extendedEntityMap.put("alefsym", "8501");
        extendedEntityMap.put("and", "8743");
        extendedEntityMap.put("ang", "8736");
        extendedEntityMap.put("asymp", "8776");
        extendedEntityMap.put("cap", "8745");
        extendedEntityMap.put("cong", "8773");
        extendedEntityMap.put("cup", "8746");
        extendedEntityMap.put("empty", "8709");
        extendedEntityMap.put("equiv", "8801");
        extendedEntityMap.put("exist", "8707");
        extendedEntityMap.put("fnof", "402");
        extendedEntityMap.put("forall", "8704");
        extendedEntityMap.put("infin", "8734");
        extendedEntityMap.put("int", "8747");
        extendedEntityMap.put("isin", "8712");
        extendedEntityMap.put("lang", "9001");
        extendedEntityMap.put("lceil", "8968");
        extendedEntityMap.put("lfloor", "8970");
        extendedEntityMap.put("lowast", "8727");
        extendedEntityMap.put("micro", "181");
        extendedEntityMap.put("nabla", "8711");
        extendedEntityMap.put("ne", "8800");
        extendedEntityMap.put("ni", "8715");
        extendedEntityMap.put("notin", "8713");
        extendedEntityMap.put("nsub", "8836");
        extendedEntityMap.put("oplus", "8853");
        extendedEntityMap.put("or", "8744");
        extendedEntityMap.put("otimes", "8855");
        extendedEntityMap.put("part", "8706");
        extendedEntityMap.put("perp", "8869");
        extendedEntityMap.put("plusmn", "177");
        extendedEntityMap.put("prod", "8719");
        extendedEntityMap.put("prop", "8733");
        extendedEntityMap.put("radic", "8730");
        extendedEntityMap.put("rang", "9002");
        extendedEntityMap.put("rceil", "8969");
        extendedEntityMap.put("rfloor", "8971");
        extendedEntityMap.put("sdot", "8901");
        extendedEntityMap.put("sim", "8764");
        extendedEntityMap.put("sub", "8834");
        extendedEntityMap.put("sube", "8838");
        extendedEntityMap.put("sum", "8721");
        extendedEntityMap.put("sup", "8835");
        extendedEntityMap.put("supe", "8839");
        extendedEntityMap.put("there4", "8756");
        extendedEntityMap.put("Alpha", "913");
        extendedEntityMap.put("alpha", "945");
        extendedEntityMap.put("Beta", "914");
        extendedEntityMap.put("beta", "946");
        extendedEntityMap.put("Chi", "935");
        extendedEntityMap.put("chi", "967");
        extendedEntityMap.put("Delta", "916");
        extendedEntityMap.put("delta", "948");
        extendedEntityMap.put("Epsilon", "917");
        extendedEntityMap.put("epsilon", "949");
        extendedEntityMap.put("Eta", "919");
        extendedEntityMap.put("eta", "951");
        extendedEntityMap.put("Gamma", "915");
        extendedEntityMap.put("gamma", "947");
        extendedEntityMap.put("Iota", "921");
        extendedEntityMap.put("iota", "953");
        extendedEntityMap.put("Kappa", "922");
        extendedEntityMap.put("kappa", "954");
        extendedEntityMap.put("Lambda", "923");
        extendedEntityMap.put("lambda", "955");
        extendedEntityMap.put("Mu", "924");
        extendedEntityMap.put("mu", "956");
        extendedEntityMap.put("Nu", "925");
        extendedEntityMap.put("nu", "957");
        extendedEntityMap.put("Omega", "937");
        extendedEntityMap.put("omega", "969");
        extendedEntityMap.put("Omicron", "927");
        extendedEntityMap.put("omicron", "959");
        extendedEntityMap.put("Phi", "934");
        extendedEntityMap.put("phi", "966");
        extendedEntityMap.put("Pi", "928");
        extendedEntityMap.put("pi", "960");
        extendedEntityMap.put("piv", "982");
        extendedEntityMap.put("Psi", "936");
        extendedEntityMap.put("psi", "968");
        extendedEntityMap.put("Rho", "929");
        extendedEntityMap.put("rho", "961");
        extendedEntityMap.put("Sigma", "931");
        extendedEntityMap.put("sigma", "963");
        extendedEntityMap.put("sigmaf", "962");
        extendedEntityMap.put("Tau", "932");
        extendedEntityMap.put("tau", "964");
        extendedEntityMap.put("Theta", "920");
        extendedEntityMap.put("theta", "952");
        extendedEntityMap.put("thetasym", "977");
        extendedEntityMap.put("upsih", "978");
        extendedEntityMap.put("Upsilon", "933");
        extendedEntityMap.put("upsilon", "965");
        extendedEntityMap.put("Xi", "926");
        extendedEntityMap.put("xi", "958");
        extendedEntityMap.put("Zeta", "918");
        extendedEntityMap.put("zeta", "950");
        extendedEntityMap.put("image", "8465");
        extendedEntityMap.put("frasl", "8260");
        extendedEntityMap.put("bull", "8226");
        extendedEntityMap.put("oline", "8254");
        extendedEntityMap.put("prime", "8242");
        extendedEntityMap.put("Prime", "8243");
        extendedEntityMap.put("real", "8476");
        extendedEntityMap.put("weierp", "8472");
        extendedEntityMap.put("Symbol-A", "913");
        extendedEntityMap.put("Symbol-a", "945");
        extendedEntityMap.put("Symbol-B", "914");
        extendedEntityMap.put("Symbol-b", "946");
        extendedEntityMap.put("Symbol-C", "935");
        extendedEntityMap.put("Symbol-c", "967");
        extendedEntityMap.put("Symbol-D", "916");
        extendedEntityMap.put("Symbol-d", "948");
        extendedEntityMap.put("Symbol-E", "917");
        extendedEntityMap.put("Symbol-e", "949");
        extendedEntityMap.put("Symbol-H", "919");
        extendedEntityMap.put("Symbol-h", "951");
        extendedEntityMap.put("Symbol-G", "915");
        extendedEntityMap.put("Symbol-g", "947");
        extendedEntityMap.put("Symbol-I", "921");
        extendedEntityMap.put("Symbol-i", "953");
        extendedEntityMap.put("Symbol-K", "922");
        extendedEntityMap.put("Symbol-k", "954");
        extendedEntityMap.put("Symbol-L", "923");
        extendedEntityMap.put("Symbol-l", "955");
        extendedEntityMap.put("Symbol-M", "924");
        extendedEntityMap.put("Symbol-m", "956");
        extendedEntityMap.put("Symbol-N", "925");
        extendedEntityMap.put("Symbol-n", "957");
        extendedEntityMap.put("Symbol-W", "937");
        extendedEntityMap.put("Symbol-w", "969");
        extendedEntityMap.put("Symbol-O", "927");
        extendedEntityMap.put("Symbol-o", "959");
        extendedEntityMap.put("Symbol-F", "934");
        extendedEntityMap.put("Symbol-f", "966");
        extendedEntityMap.put("Symbol-P", "928");
        extendedEntityMap.put("Symbol-p", "960");
        extendedEntityMap.put("Symbol-v", "982");
        extendedEntityMap.put("Symbol-Y", "936");
        extendedEntityMap.put("Symbol-y", "968");
        extendedEntityMap.put("Symbol-R", "929");
        extendedEntityMap.put("Symbol-r", "961");
        extendedEntityMap.put("Symbol-S", "931");
        extendedEntityMap.put("Symbol-s", "963");
        extendedEntityMap.put("Symbol-V", "962");
        extendedEntityMap.put("Symbol-T", "932");
        extendedEntityMap.put("Symbol-t", "964");
        extendedEntityMap.put("Symbol-Q", "920");
        extendedEntityMap.put("Symbol-q", "952");
        extendedEntityMap.put("Symbol-J", "977");
        extendedEntityMap.put("Symbol-161", "978");
        extendedEntityMap.put("Symbol-U", "933");
        extendedEntityMap.put("Symbol-u", "965");
        extendedEntityMap.put("Symbol-X", "926");
        extendedEntityMap.put("Symbol-x", "958");
        extendedEntityMap.put("Symbol-Z", "918");
        extendedEntityMap.put("Symbol-z", "950");
        extendedEntityMap.put("Symbol-j", "981");
    }

    protected TagElement makeTag(Element elem, boolean fictional) {
        return new TagElement(elem, fictional);
    }

    protected TagElement makeTag(Element elem) {
        return this.makeTag(elem, false);
    }

    protected SimpleAttributeSet getAttributes() {
        return this.attributes;
    }

    protected void flushAttributes() {
        this.attributes.removeAttributes(this.attributes);
    }

    protected int getCurrentLine() {
        return this.ln;
    }

    int getBlockStartPosition() {
        return Math.max(0, this.lastBlockStartPos - 1);
    }

    protected void handleEOFInComment() {
        int commentEndPos = this.strIndexOf('\n');
        if (commentEndPos >= 0) {
            this.handleComment(this.getChars(0, commentEndPos));
            try {
                this.in.close();
                this.in = new CharArrayReader(this.getChars(commentEndPos + 1));
                this.ch = 62;
            }
            catch (IOException e) {
                this.error("ioexception");
            }
            this.resetStrBuffer();
        } else {
            this.error("eof.comment");
        }
    }

    protected void handleTitle(char[] text) {
        this.handleText(text);
    }

    protected void handleComment(char[] text) {
        if (this.discardAllProprietaryTags) {
            return;
        }
        this.callback.handleComment(text, this.getBlockStartPosition());
    }

    protected void handleText(char[] data) {
        if (data != null) {
            if (this.inscript != 0) {
                this.callback.handleText(data, this.getBlockStartPosition());
                return;
            }
            if (this.inbody != 0 || this.instyle != 0 || this.intitle != 0 && !this.seentitle) {
                if (this.instyle != 0) {
                    // empty if block
                }
                this.callback.handleText(data, this.getBlockStartPosition());
            }
        }
    }

    protected void handleEmptyTag(TagElement tag) throws ChangedCharSetException {
        String content;
        SimpleAttributeSet atts;
        Element elem = tag.getElement();
        if (elem == this.dtd.meta && !this.ignoreCharSet && (atts = this.getAttributes()) != null && (content = (String)atts.getAttribute(HTML.Attribute.CONTENT)) != null) {
            if ("content-type".equalsIgnoreCase((String)atts.getAttribute(HTML.Attribute.HTTPEQUIV))) {
                if (!content.equalsIgnoreCase("text/html") && !content.equalsIgnoreCase("text/plain")) {
                    throw new ChangedCharSetException(content, false);
                }
            } else if ("charset".equalsIgnoreCase((String)atts.getAttribute(HTML.Attribute.HTTPEQUIV))) {
                throw new ChangedCharSetException(content, true);
            }
        }
        if (this.inbody != 0 || elem == this.dtd.meta || elem == this.dtd.base || elem == this.dtd.isindex || elem == this.dtd.getElement("style") || elem == this.dtd.getElement("link")) {
            if (tag.fictional()) {
                SimpleAttributeSet attrs = new SimpleAttributeSet();
                attrs.addAttribute(HTMLEditorKit.ParserCallback.IMPLIED, Boolean.TRUE);
                this.callback.handleSimpleTag(tag.getHTMLTag(), attrs, this.getBlockStartPosition());
            } else {
                this.callback.handleSimpleTag(tag.getHTMLTag(), this.getAttributes(), this.getBlockStartPosition());
                this.flushAttributes();
            }
        }
    }

    protected void handleStartTag(TagElement tag) {
        Element elem = tag.getElement();
        if (elem == this.dtd.body) {
            ++this.inbody;
        } else if (elem != this.dtd.html) {
            if (elem == this.dtd.head) {
                ++this.inhead;
            } else if (elem == this.dtd.title) {
                ++this.intitle;
            } else if (elem == this.dtd.getElement("style")) {
                ++this.instyle;
            } else if (elem == this.dtd.getElement("script")) {
                ++this.inscript;
            }
        }
        if (tag.fictional()) {
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            attrs.addAttribute(HTMLEditorKit.ParserCallback.IMPLIED, Boolean.TRUE);
            this.callback.handleStartTag(tag.getHTMLTag(), attrs, this.getBlockStartPosition());
        } else {
            HTML.Tag currentTag = tag.getHTMLTag();
            if (currentTag != null && currentTag.toString().equalsIgnoreCase("ruby")) {
                currentTag = RubyTag.Ruby;
            }
            if (currentTag != null && currentTag.toString().equalsIgnoreCase("rt")) {
                currentTag = RubyTag.RT;
            }
            this.callback.handleStartTag(currentTag, this.getAttributes(), this.getBlockStartPosition());
            this.flushAttributes();
        }
    }

    public void parse(Reader in, HTMLEditorKit.ParserCallback callback, boolean ignoreCharSet) throws IOException {
        this.ignoreCharSet = ignoreCharSet;
        this.callback = callback;
        this.parse(in);
        callback.handleEndOfLineString(this.getEndOfLineString());
    }

    protected void handleEndTag(TagElement tag) {
        Element elem = tag.getElement();
        if (elem == this.dtd.body) {
            --this.inbody;
        } else if (elem == this.dtd.title) {
            --this.intitle;
            this.seentitle = true;
        } else if (elem == this.dtd.head) {
            --this.inhead;
        } else if (elem == this.dtd.getElement("style")) {
            --this.instyle;
        } else if (elem == this.dtd.getElement("script")) {
            --this.inscript;
        }
        HTML.Tag currentTag = tag.getHTMLTag();
        if (currentTag != null && currentTag.toString().equalsIgnoreCase("ruby")) {
            currentTag = RubyTag.Ruby;
        }
        if (currentTag != null && currentTag.toString().equalsIgnoreCase("rt")) {
            currentTag = RubyTag.RT;
        }
        this.callback.handleEndTag(currentTag, this.getBlockStartPosition());
    }

    protected void handleError(int ln, String errorMsg) {
        this.callback.handleError(errorMsg, this.getCurrentPos());
    }

    void handleText(TagElement tag) {
        char[] newtext;
        if (tag.breaksFlow()) {
            this.space = false;
            if (!this.strict) {
                this.ignoreSpace = true;
            }
        }
        if (!(this.textpos != 0 || this.space && this.stack != null && !this.last.breaksFlow() && this.stack.advance(this.dtd.pcdata))) {
            this.last = tag;
            this.space = false;
            this.lastBlockStartPos = this.currentBlockStartPos;
            return;
        }
        if (this.space) {
            if (!this.ignoreSpace) {
                if (this.textpos + 1 > this.text.length) {
                    newtext = new char[this.text.length + 200];
                    System.arraycopy(this.text, 0, newtext, 0, this.text.length);
                    this.text = newtext;
                }
                this.text[this.textpos++] = 32;
                if (!this.strict && !tag.getElement().isEmpty()) {
                    this.ignoreSpace = true;
                }
            }
            this.space = false;
        }
        newtext = new char[this.textpos];
        System.arraycopy(this.text, 0, newtext, 0, this.textpos);
        if (tag.getElement().getName().equals("title")) {
            this.handleTitle(newtext);
        } else if (!tag.getElement().getName().equals("script")) {
            if (this.convertSymbolEntities) {
                String str = new String(newtext);
                StringBuffer newString = new StringBuffer();
                for (int i = 0; i < str.length(); ++i) {
                    char ch = str.charAt(i);
                    if (ch >= '!' && ch <= '~') {
                        try {
                            newString.append((char)Integer.parseInt((String)extendedEntityMap.get("Symbol-" + ch)));
                        }
                        catch (Throwable thr) {
                            newString.append(ch);
                        }
                        continue;
                    }
                    newString.append(ch);
                }
                newtext = newString.toString().toCharArray();
                this.convertSymbolEntities = false;
            }
            this.handleText(newtext);
        }
        this.lastBlockStartPos = this.currentBlockStartPos;
        this.textpos = 0;
        this.last = tag;
        this.space = false;
    }

    protected void startTag(TagElement tag) throws ChangedCharSetException {
        Element elem = tag.getElement();
        SimpleAttributeSet elementAttribs = this.getAttributes();
        if (elementAttribs != null && elementAttribs.isDefined(HTML.Attribute.STYLE) && elementAttribs.getAttribute(HTML.Attribute.STYLE).toString().indexOf("font-family:Symbol") != -1) {
            this.convertSymbolEntities = true;
        }
        if (!elem.isEmpty() || this.textpos != 0) {
            this.handleText(tag);
        } else {
            this.last = tag;
            if (elem.isEmpty() && elem == this.dtd.getElement("unknown")) {
                this.handleText(tag);
            }
            this.space = false;
        }
        this.lastBlockStartPos = this.currentBlockStartPos;
        AttributeList a = elem.atts;
        while (a != null) {
            if (a.modifier == 2 && (this.attributes.isEmpty() || !this.attributes.isDefined(a.name))) {
                this.error("req.att ", a.getName(), elem.getName());
            }
            a = a.next;
        }
        if (elem.isEmpty()) {
            this.handleEmptyTag(tag);
        } else {
            char[] scriptText;
            this.recent = elem;
            this.stack = new TagStack(tag, this.stack);
            this.handleStartTag(tag);
            if (tag.getElement().getName().equals("script")) {
                try {
                    scriptText = this.parseScript();
                    this.handleComment(scriptText);
                    elem = this.dtd.getElement("script");
                    TagElement t = this.makeTag(elem);
                    this.handleEndTag(t);
                    this.stack = this.stack.next;
                    this.recent = elem;
                }
                catch (Throwable thr) {
                    thr.printStackTrace();
                }
            } else if (tag.getElement().getName().equals("style")) {
                try {
                    scriptText = this.parseStyle();
                    this.handleText(scriptText);
                    elem = this.dtd.getElement("style");
                    TagElement t = this.makeTag(elem);
                    this.handleEndTag(t);
                    this.stack = this.stack.next;
                    this.recent = elem;
                }
                catch (Throwable thr) {
                    thr.printStackTrace();
                }
            }
        }
    }

    protected void endTag(boolean omitted) {
        this.handleText(this.stack.tag);
        if (omitted && !this.stack.elem.omitEnd() || !this.stack.terminate()) {
            // empty if block
        }
        this.handleEndTag(this.stack.tag);
        this.stack = this.stack.next;
        this.recent = this.stack != null ? this.stack.elem : null;
    }

    boolean ignoreElement(Element elem) {
        String stackElement = this.stack.elem.getName();
        String elemName = elem.getName();
        if (elemName.equals("html") && this.seenHtml || elemName.equals("head") && this.seenHead || elemName.equals("body") && this.seenBody) {
            return true;
        }
        if (elemName.equals("col") && this.seenBody) {
            return true;
        }
        if (elemName.equals("dt") || elemName.equals("dd")) {
            TagStack s = this.stack;
            while (s != null && !s.elem.getName().equals("dl")) {
                s = s.next;
            }
            if (s == null) {
                return true;
            }
        }
        if (elemName.equals("script")) {
            return false;
        }
        if (elemName.equals("style")) {
            return false;
        }
        return stackElement.equals("table") && !elemName.equals("#pcdata") && !elemName.equals("input") || elemName.equals("font") && (stackElement.equals("ul") || stackElement.equals("ol")) || elemName.equals("meta") && this.stack != null || stackElement.equals("table") && elemName.equals("a");
    }

    protected void markFirstTime(Element elem) {
        String elemName = elem.getName();
        if (elemName.equals("html")) {
            this.seenHtml = true;
        } else if (elemName.equals("head")) {
            this.seenHead = true;
        } else if (elemName.equals("body")) {
            if (this.buf.length == 1) {
                char[] newBuf = new char[256];
                newBuf[0] = this.buf[0];
                this.buf = newBuf;
            }
            this.seenBody = true;
        }
    }

    boolean legalElementContext(Element elem) throws ChangedCharSetException {
        Element next;
        if (this.stack == null) {
            if (elem != this.dtd.html) {
                this.startTag(this.makeTag(this.dtd.html, true));
                return this.legalElementContext(elem);
            }
            return true;
        }
        if (this.stack.advance(elem)) {
            this.markFirstTime(elem);
            return true;
        }
        boolean insertTag = false;
        String stackElemName = this.stack.elem.getName();
        String elemName = elem.getName();
        if ((stackElemName.equals("h1") || stackElemName.equals("h2") || stackElemName.equals("h3") || stackElemName.equals("h4") || stackElemName.equals("h5") || stackElemName.equals("h6")) && (elemName.equals("div") || elemName.equals("h1"))) {
            return true;
        }
        if (stackElemName.equals("tr") && elemName.equals("span")) {
            return false;
        }
        if (!this.strict && (stackElemName.equals("table") && elemName.equals("td") || stackElemName.equals("table") && elemName.equals("th") || stackElemName.equals("tr") && !elemName.equals("tr"))) {
            insertTag = true;
        }
        if (!this.strict && !insertTag && (this.stack.elem.getName() != elem.getName() || elem.getName().equals("body")) && (this.skipTag = this.ignoreElement(elem))) {
            return this.skipTag;
        }
        if (!(this.strict || !stackElemName.equals("table") || elemName.equals("tr") || elemName.equals("td") || elemName.equals("th") || elemName.equals("caption"))) {
            Element e = this.dtd.getElement("tr");
            TagElement t = this.makeTag(e, true);
            this.legalTagContext(t);
            this.startTag(t);
            return this.legalElementContext(elem);
        }
        if (!insertTag && this.stack.terminate() && (!this.strict || this.stack.elem.omitEnd())) {
            TagStack s = this.stack.next;
            while (s != null) {
                if (s.advance(elem)) {
                    while (this.stack != s) {
                        this.endTag(true);
                    }
                    return true;
                }
                if (!s.terminate() || this.strict && !s.elem.omitEnd()) break;
                s = s.next;
            }
        }
        if (!((next = this.stack.first()) == null || this.strict && !next.omitStart() || next == this.dtd.head && elem == this.dtd.pcdata)) {
            TagElement t = this.makeTag(next, true);
            this.legalTagContext(t);
            this.startTag(t);
            if (!next.omitStart()) {
                this.error("start.missing", elem.getName());
            }
            return this.legalElementContext(elem);
        }
        if (!this.strict) {
            ContentModel content = this.stack.contentModel();
            Vector<Element> elemVec = new Vector<Element>();
            if (content != null) {
                content.getElements(elemVec);
                Enumeration<Element> v = elemVec.elements();
                while (v.hasMoreElements()) {
                    Element e = v.nextElement();
                    if (this.stack.excluded(e.getIndex())) continue;
                    boolean reqAtts = false;
                    AttributeList a = e.getAttributes();
                    while (a != null) {
                        if (a.modifier == 2) {
                            reqAtts = true;
                            break;
                        }
                        a = a.next;
                    }
                    if (reqAtts) continue;
                    ContentModel m = e.getContent();
                    if (HTMLEditor.jvm_version.startsWith("1.6") || HTMLEditor.jvm_version.startsWith("1.7")) {
                        try {
                            if (m == null || !m.first(elem)) continue;
                            TagElement t = this.makeTag(e, true);
                            this.legalTagContext(t);
                            this.startTag(t);
                            return this.legalElementContext(elem);
                        }
                        catch (Throwable thr) {
                            if (m == null || m.first() != elem) continue;
                            TagElement t = this.makeTag(e, true);
                            this.legalTagContext(t);
                            this.startTag(t);
                            return this.legalElementContext(elem);
                        }
                    }
                    if (m == null || !m.first(elem)) continue;
                    TagElement t = this.makeTag(e, true);
                    this.legalTagContext(t);
                    this.startTag(t);
                    this.error("start.missing", e.getName());
                    return this.legalElementContext(elem);
                }
            }
        }
        return false;
    }

    void legalTagContext(TagElement tag) throws ChangedCharSetException {
        if (this.legalElementContext(tag.getElement())) {
            this.markFirstTime(tag.getElement());
            return;
        }
        if (tag.breaksFlow() && tag.getElement() != this.dtd.getElement("form") && this.stack != null && !this.stack.tag.breaksFlow()) {
            this.endTag(true);
            this.legalTagContext(tag);
            return;
        }
        TagStack s = this.stack;
        while (s != null) {
            if (s.tag.getElement() == this.dtd.head && tag.getElement() != this.dtd.title && tag.getElement() != this.dtd.getElement("map") && tag.getElement() != this.dtd.getElement("style") && tag.getElement() != this.dtd.getElement("script") && tag.getElement() != this.dtd.getElement("comment") && tag.getElement() != this.dtd.getElement("meta") && tag.getElement() != this.dtd.pcdata && tag.getElement() != this.dtd.getElement("link") && tag.getElement() != this.dtd.getElement("title")) {
                while (this.stack != s) {
                    this.endTag(true);
                }
                this.endTag(true);
                this.legalTagContext(tag);
                return;
            }
            s = s.next;
        }
        this.error("tag.unexpected", tag.getElement().getName());
    }

    void errorContext() throws ChangedCharSetException {
        while (this.stack != null && this.stack.tag.getElement() != this.dtd.body) {
            this.handleEndTag(this.stack.tag);
            this.stack = this.stack.next;
        }
        if (this.stack == null) {
            this.legalElementContext(this.dtd.body);
            this.startTag(this.makeTag(this.dtd.body, true));
        }
    }

    void addString(int c) {
        if (this.strpos == this.str.length) {
            char[] newstr = new char[this.str.length + 1280];
            System.arraycopy(this.str, 0, newstr, 0, this.str.length);
            this.str = newstr;
        }
        this.str[this.strpos++] = (char)c;
    }

    String getString(int pos) {
        char[] newStr = new char[this.strpos - pos];
        System.arraycopy(this.str, pos, newStr, 0, this.strpos - pos);
        this.strpos = pos;
        return new String(newStr);
    }

    char[] getChars(int pos) {
        char[] newStr = new char[this.strpos - pos];
        System.arraycopy(this.str, pos, newStr, 0, this.strpos - pos);
        this.strpos = pos;
        return newStr;
    }

    char[] getChars(int pos, int endPos) {
        char[] newStr = new char[endPos - pos];
        System.arraycopy(this.str, pos, newStr, 0, endPos - pos);
        return newStr;
    }

    void resetStrBuffer() {
        this.strpos = 0;
        this.strBuffer = new StringBuffer();
    }

    int strIndexOf(char target) {
        for (int i = 0; i < this.strpos; ++i) {
            if (this.str[i] != target) continue;
            return i;
        }
        return -1;
    }

    void skipSpace() throws IOException {
        block5: while (true) {
            switch (this.ch) {
                case 10: {
                    ++this.ln;
                    this.ch = this.readCh();
                    ++this.lfCount;
                    continue block5;
                }
                case 13: {
                    ++this.ln;
                    this.ch = this.readCh();
                    if (this.ch == 10) {
                        this.ch = this.readCh();
                        ++this.crlfCount;
                        continue block5;
                    }
                    ++this.crCount;
                    continue block5;
                }
                case 9: 
                case 32: {
                    this.ch = this.readCh();
                    continue block5;
                }
            }
            break;
        }
    }

    boolean parseIdentifier(boolean lower) throws IOException {
        lower = false;
        switch (this.ch) {
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                if (lower) {
                    this.ch = 97 + (this.ch - 65);
                }
            }
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 63: 
            case 64: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                break;
            }
            default: {
                return false;
            }
        }
        block8: while (true) {
            this.addString(this.ch);
            this.ch = this.readCh();
            switch (this.ch) {
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: {
                    if (lower) {
                        this.ch = 97 + (this.ch - 65);
                    }
                }
                case 35: 
                case 36: 
                case 37: 
                case 39: 
                case 40: 
                case 41: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 63: 
                case 64: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    continue block8;
                }
            }
            break;
        }
        return true;
    }

    private char[] parseEntityReferenceForAttributeValue() throws IOException {
        int pos = this.strpos;
        boolean foundSemicolon = false;
        this.ch = this.readCh();
        if (this.ch == 35) {
            int n = 0;
            this.ch = this.readCh();
            if (this.ch >= 48 && this.ch <= 57) {
                while (this.ch >= 48 && this.ch <= 57) {
                    n = n * 10 + this.ch - 48;
                    this.ch = this.readCh();
                }
                switch (this.ch) {
                    case 10: {
                        ++this.ln;
                        this.ch = this.readCh();
                        ++this.lfCount;
                        break;
                    }
                    case 13: {
                        ++this.ln;
                        this.ch = this.readCh();
                        if (this.ch == 10) {
                            this.ch = this.readCh();
                            ++this.crlfCount;
                            break;
                        }
                        ++this.crCount;
                        break;
                    }
                    case 59: {
                        this.ch = this.readCh();
                    }
                }
                char[] data = new char[]{this.mapNumericReference((char)n)};
                return data;
            }
            this.addString(35);
            if (!this.parseIdentifier(false)) {
                this.error("ident.expected");
                this.strpos = pos;
                char[] data = new char[]{'&', '#'};
                return data;
            }
        } else if (!this.parseIdentifier(false)) {
            char[] data = new char[]{'&'};
            return data;
        }
        switch (this.ch) {
            case 10: {
                ++this.ln;
                this.ch = this.readCh();
                ++this.lfCount;
                break;
            }
            case 13: {
                ++this.ln;
                this.ch = this.readCh();
                if (this.ch == 10) {
                    this.ch = this.readCh();
                    ++this.crlfCount;
                    break;
                }
                ++this.crCount;
                break;
            }
            case 59: {
                foundSemicolon = true;
                this.ch = this.readCh();
            }
        }
        String nm = this.getString(pos);
        Entity ent = this.dtd.getEntity(nm);
        if (!this.strict && ent == null) {
            ent = this.dtd.getEntity(nm.toLowerCase(Locale.US));
        }
        if (ent == null || !ent.isGeneral()) {
            if (nm.length() == 0) {
                this.error("invalid.entref", nm);
                return new char[0];
            }
            String str = "&" + nm;
            if (foundSemicolon) {
                str = str + ";";
            }
            char[] b = new char[str.length()];
            str.getChars(0, b.length, b, 0);
            return b;
        }
        if (foundSemicolon) {
            nm = nm + ";";
        }
        if (ent != null) {
            return ("&" + nm).toCharArray();
        }
        return nm.toCharArray();
    }

    private char[] parseEntityReference() throws IOException {
        int pos = this.strpos;
        boolean foundSemicolon = false;
        this.ch = this.readCh();
        if (this.ch == 35) {
            int n = 0;
            this.ch = this.readCh();
            if (this.ch >= 48 && this.ch <= 57) {
                while (this.ch >= 48 && this.ch <= 57) {
                    n = n * 10 + this.ch - 48;
                    this.ch = this.readCh();
                }
                switch (this.ch) {
                    case 10: {
                        ++this.ln;
                        this.ch = this.readCh();
                        ++this.lfCount;
                        break;
                    }
                    case 13: {
                        ++this.ln;
                        this.ch = this.readCh();
                        if (this.ch == 10) {
                            this.ch = this.readCh();
                            ++this.crlfCount;
                            break;
                        }
                        ++this.crCount;
                        break;
                    }
                    case 59: {
                        this.ch = this.readCh();
                    }
                }
                char[] data = new char[]{this.mapNumericReference((char)n)};
                return data;
            }
            if (this.ch == 120) {
                this.ch = this.readCh();
                if (this.ch >= 48 && this.ch <= 57 || this.ch >= 65 && this.ch <= 70 || this.ch >= 97 && this.ch <= 102) {
                    String str = "";
                    while (this.ch >= 48 && this.ch <= 57 || this.ch >= 65 && this.ch <= 70 || this.ch >= 97 && this.ch <= 102) {
                        str = str + (char)this.ch;
                        this.ch = this.readCh();
                    }
                    switch (this.ch) {
                        case 10: {
                            ++this.ln;
                            this.ch = this.readCh();
                            ++this.lfCount;
                            break;
                        }
                        case 13: {
                            ++this.ln;
                            this.ch = this.readCh();
                            if (this.ch == 10) {
                                this.ch = this.readCh();
                                ++this.crlfCount;
                                break;
                            }
                            ++this.crCount;
                            break;
                        }
                        case 59: {
                            this.ch = this.readCh();
                        }
                    }
                    try {
                        n = Integer.parseInt(str, 16);
                    }
                    catch (Throwable thr) {
                        char[] data = str.toCharArray();
                        return data;
                    }
                    char[] data = new char[]{(char)n};
                    return data;
                }
                this.addString(120);
                if (!this.parseIdentifier(false)) {
                    this.error("ident.expected");
                    this.strpos = pos;
                    char[] data = new char[]{'&', '#', 'x'};
                    return data;
                }
            }
            this.addString(35);
            if (!this.parseIdentifier(false)) {
                this.error("ident.expected");
                this.strpos = pos;
                char[] data = new char[]{'&', '#'};
                return data;
            }
        } else if (!this.parseIdentifier(false)) {
            char[] data = new char[]{'&'};
            return data;
        }
        switch (this.ch) {
            case 10: {
                ++this.ln;
                this.ch = this.readCh();
                ++this.lfCount;
                break;
            }
            case 13: {
                ++this.ln;
                this.ch = this.readCh();
                if (this.ch == 10) {
                    this.ch = this.readCh();
                    ++this.crlfCount;
                    break;
                }
                ++this.crCount;
                break;
            }
            case 59: {
                this.ch = this.readCh();
                foundSemicolon = true;
            }
        }
        String nm = this.getString(pos);
        Entity ent = this.dtd.getEntity(nm);
        try {
            if (ent == null) {
                char[] data = new char[]{this.getEntendedEntity(nm)};
                return data;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!this.strict && ent == null) {
            ent = this.dtd.getEntity(nm.toLowerCase(Locale.US));
        }
        if (ent == null || !ent.isGeneral()) {
            if (nm.length() == 0) {
                this.error("invalid.entref", nm);
                return new char[0];
            }
            String str = "&" + nm;
            if (foundSemicolon) {
                str = str + ";";
            }
            char[] b = new char[str.length()];
            str.getChars(0, b.length, b, 0);
            return b;
        }
        return ent.getData();
    }

    private char mapNumericReference(char c) {
        if (c < '\u0082' || c > '\u009f') {
            return c;
        }
        return cp1252Map[c - 130];
    }

    char getEntendedEntity(String name) {
        char numValue = (char)Integer.parseInt((String)extendedEntityMap.get(name));
        return this.mapNumericReference(numValue);
    }

    void addString(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            this.addString(c);
        }
    }

    void parseComment() throws IOException {
        String checkString;
        StringBuffer commentStr = new StringBuffer();
        commentStr.append((char)this.ch);
        while (commentStr.length() < 3 || !(checkString = commentStr.substring(commentStr.length() - 3)).equalsIgnoreCase("-->")) {
            int c;
            this.ch = c = this.readCh();
            if (c == -1) break;
            commentStr.append((char)c);
        }
        this.addString("<!--" + commentStr.toString());
    }

    char[] parseScript() throws IOException {
        StringBuffer commentStr = new StringBuffer();
        commentStr.append((char)this.ch);
        while (true) {
            String checkString;
            if (commentStr.length() >= 9 && (checkString = commentStr.substring(commentStr.length() - 9)).equalsIgnoreCase("</script>")) {
                commentStr.setLength(commentStr.length() - 9);
                this.ch = this.readCh();
                break;
            }
            int c = this.readCh();
            if (c == -1) break;
            commentStr.append((char)c);
        }
        return commentStr.toString().toCharArray();
    }

    char[] parseStyle() throws IOException {
        StringBuffer commentStr = new StringBuffer();
        commentStr.append((char)this.ch);
        while (true) {
            String checkString;
            if (commentStr.length() >= 8 && (checkString = commentStr.substring(commentStr.length() - 8)).equalsIgnoreCase("</style>")) {
                commentStr.setLength(commentStr.length() - 8);
                this.ch = this.readCh();
                break;
            }
            int c = this.readCh();
            if (c == -1) break;
            commentStr.append((char)c);
        }
        return commentStr.toString().toCharArray();
    }

    char[] parseStyle1() throws IOException {
        StringBuffer commentStr = new StringBuffer();
        commentStr.append((char)this.ch);
        String currentSelector = "";
        String currentKey = "";
        String currentValue = "";
        boolean readingKey = false;
        boolean readingValue = false;
        boolean inSelector = false;
        SimpleAttributeSet mas = new SimpleAttributeSet();
        while (true) {
            int c;
            if ((char)(c = this.readCh()) == '<') {
                char char1 = (char)this.readCh();
                char char2 = (char)this.readCh();
                char char3 = (char)this.readCh();
                char char4 = (char)this.readCh();
                char char5 = (char)this.readCh();
                char char6 = (char)this.readCh();
                char char7 = (char)this.readCh();
                if (char1 == '/' && char2 == 's' && char3 == 't' && char4 == 'y' && char5 == 'l' && char6 == 'e' && char7 == '>') {
                    this.ch = this.readCh();
                    break;
                }
                commentStr.append((char)c);
                commentStr.append(char1);
                commentStr.append(char2);
                commentStr.append(char3);
                commentStr.append(char4);
                commentStr.append(char5);
                commentStr.append(char6);
                commentStr.append(char7);
                continue;
            }
            if (c == -1) break;
            if ((char)c == '{') {
                currentSelector = commentStr.toString();
                commentStr.setLength(0);
                inSelector = true;
                readingKey = true;
                continue;
            }
            if ((char)c == '}') {
                StyleSheet ss = ((EditorHTMLDocument.EditorHTMLReader)this.callback).getDocumentStyleSheet();
                Style style = ss.addStyle(currentSelector, null);
                style.addAttributes(mas.copyAttributes());
                mas.removeAttributes(mas);
                commentStr.setLength(0);
                inSelector = false;
                readingKey = false;
                readingValue = false;
                currentSelector = "";
                continue;
            }
            if (inSelector) {
                if ((char)c == ':') {
                    readingKey = false;
                    readingValue = true;
                    continue;
                }
                if ((char)c == ';') {
                    readingKey = true;
                    readingValue = false;
                    StyleSheet ss = ((EditorHTMLDocument.EditorHTMLReader)this.callback).getDocumentStyleSheet();
                    CSS.Attribute cssAttr = CSS.getAttribute(currentKey);
                    if (cssAttr == null) continue;
                    ss.addCSSAttribute(mas, cssAttr, currentValue);
                    currentKey = "";
                    currentValue = "";
                    continue;
                }
                if (readingKey) {
                    currentKey = currentKey + (char)c;
                    continue;
                }
                if (!readingValue) continue;
                currentValue = currentValue + (char)c;
                continue;
            }
            commentStr.append((char)c);
        }
        return commentStr.toString().toCharArray();
    }

    void parseLiteral(boolean replace) throws IOException {
        block7: while (true) {
            int c = this.ch;
            switch (c) {
                case -1: {
                    this.error("eof.literal", this.stack.elem.getName());
                    this.endTag(true);
                    return;
                }
                case 62: {
                    this.ch = this.readCh();
                    int i = this.textpos - (this.stack.elem.name.length() + 2);
                    int j = 0;
                    if (i < 0 || this.text[i++] != '<' || this.text[i] != '/') break;
                    while (++i < this.textpos && Character.toLowerCase(this.text[i]) == this.stack.elem.name.charAt(j++)) {
                    }
                    if (i != this.textpos) break;
                    this.textpos -= this.stack.elem.name.length() + 2;
                    if (this.textpos > 0 && this.text[this.textpos - 1] == '\n') {
                        --this.textpos;
                    }
                    this.endTag(false);
                    return;
                }
                case 38: {
                    char[] data = this.parseEntityReference();
                    if (this.textpos + data.length > this.text.length) {
                        char[] newtext = new char[Math.max(this.textpos + data.length + 128, this.text.length * 2)];
                        System.arraycopy(this.text, 0, newtext, 0, this.text.length);
                        this.text = newtext;
                    }
                    System.arraycopy(data, 0, this.text, this.textpos, data.length);
                    this.textpos += data.length;
                    continue block7;
                }
                case 10: {
                    ++this.ln;
                    this.ch = this.readCh();
                    ++this.lfCount;
                    break;
                }
                case 13: {
                    ++this.ln;
                    this.ch = this.readCh();
                    if (this.ch == 10) {
                        this.ch = this.readCh();
                        ++this.crlfCount;
                    } else {
                        ++this.crCount;
                    }
                    c = 10;
                    break;
                }
                default: {
                    this.ch = this.readCh();
                }
            }
            if (this.textpos == this.text.length) {
                char[] newtext = new char[this.text.length + 128];
                System.arraycopy(this.text, 0, newtext, 0, this.text.length);
                this.text = newtext;
            }
            this.text[this.textpos++] = (char)c;
        }
    }

    String parseAttributeValue(boolean lower) throws IOException {
        lower = false;
        int delim = -1;
        switch (this.ch) {
            case 34: 
            case 39: {
                delim = this.ch;
                this.ch = this.readCh();
            }
        }
        block14: while (true) {
            int c = this.ch;
            switch (c) {
                case 10: {
                    ++this.ln;
                    this.ch = this.readCh();
                    ++this.lfCount;
                    if (delim >= 0) break;
                    return this.getString(0);
                }
                case 13: {
                    ++this.ln;
                    this.ch = this.readCh();
                    if (this.ch == 10) {
                        this.ch = this.readCh();
                        ++this.crlfCount;
                    } else {
                        ++this.crCount;
                    }
                    if (delim >= 0) break;
                    return this.getString(0);
                }
                case 9: {
                    if (delim < 0) {
                        c = 32;
                    }
                }
                case 32: {
                    this.ch = this.readCh();
                    if (delim >= 0) break;
                    return this.getString(0);
                }
                case 60: 
                case 62: {
                    if (delim < 0) {
                        return this.getString(0);
                    }
                    this.ch = this.readCh();
                    break;
                }
                case 34: 
                case 39: {
                    this.ch = this.readCh();
                    if (c == delim) {
                        return this.getString(0);
                    }
                    if (delim != -1) break;
                    if (!this.strict && this.ch != 32) continue block14;
                    return this.getString(0);
                }
                case 61: {
                    if (delim < 0 && this.strict) {
                        return this.getString(0);
                    }
                    this.ch = this.readCh();
                    break;
                }
                case 38: {
                    if (this.strict && delim < 0) {
                        this.ch = this.readCh();
                        break;
                    }
                    char[] data = this.parseEntityReferenceForAttributeValue();
                    int i = 0;
                    while (true) {
                        if (i >= data.length) continue block14;
                        c = data[i];
                        this.addString(lower && c >= 65 && c <= 90 ? 97 + c - 65 : c);
                        ++i;
                    }
                }
                case -1: {
                    return this.getString(0);
                }
                default: {
                    if (lower && c >= 65 && c <= 90) {
                        c = 97 + c - 65;
                    }
                    this.ch = this.readCh();
                }
            }
            this.addString(c);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void parseAttributeSpecificationList(Element elem) throws IOException {
        block6: while (true) {
            String attvalue;
            String attname;
            AttributeList att;
            block31: {
                char[] str;
                block32: {
                    block33: {
                        block34: {
                            block29: {
                                block30: {
                                    this.skipSpace();
                                    switch (this.ch) {
                                        case -1: 
                                        case 60: 
                                        case 62: {
                                            return;
                                        }
                                        case 45: {
                                            this.ch = this.readCh();
                                            if (this.ch == 45) {
                                                this.ch = this.readCh();
                                                this.parseComment();
                                                this.strpos = 0;
                                                continue block6;
                                            }
                                            this.ch = this.readCh();
                                            continue block6;
                                        }
                                    }
                                    att = null;
                                    attname = null;
                                    attvalue = null;
                                    if (!this.parseIdentifier(true)) break block29;
                                    attname = this.getString(0);
                                    this.skipSpace();
                                    if (this.ch != 61) break block30;
                                    this.ch = this.readCh();
                                    this.skipSpace();
                                    att = elem.getAttribute(attname);
                                    attvalue = this.parseAttributeValue(att != null && att.type != 1 && att.type != 11 && att.type != 7);
                                    break block31;
                                }
                                attvalue = attname;
                                att = elem.getAttributeByValue(attvalue);
                                if (att != null) break block31;
                                att = elem.getAttribute(attname);
                                attvalue = att != null ? att.getValue() : null;
                                break block31;
                            }
                            if (!this.strict && this.ch == 44) {
                                this.ch = this.readCh();
                                continue;
                            }
                            if (this.strict || this.ch != 34 && this.ch != 39) break block32;
                            this.ch = this.readCh();
                            this.skipSpace();
                            if (!this.parseIdentifier(true)) break block33;
                            attname = this.getString(0);
                            if (this.ch == 34 || this.ch == 39) {
                                this.ch = this.readCh();
                            }
                            this.skipSpace();
                            if (this.ch != 61) break block34;
                            this.ch = this.readCh();
                            this.skipSpace();
                            att = elem.getAttribute(attname);
                            attvalue = this.parseAttributeValue(att != null && att.type != 1 && att.type != 11);
                            break block31;
                        }
                        attvalue = attname;
                        att = elem.getAttributeByValue(attvalue);
                        if (att != null || (att = elem.getAttribute(attname)) == null) break block31;
                        attvalue = att.getValue();
                        break block31;
                    }
                    str = new char[]{(char)this.ch};
                    this.ch = this.readCh();
                    continue;
                }
                if (!this.strict && this.attributes.isEmpty() && this.ch == 61) {
                    this.ch = this.readCh();
                    this.skipSpace();
                    attname = elem.getName();
                    att = elem.getAttribute(attname);
                    attvalue = this.parseAttributeValue(att != null && att.type != 1 && att.type != 11);
                } else {
                    if (!this.strict && this.ch == 61) {
                        this.ch = this.readCh();
                        this.skipSpace();
                        attvalue = this.parseAttributeValue(true);
                        this.error("attvalerr");
                        return;
                    }
                    str = new char[]{(char)this.ch};
                    this.error("invalid.tagchar", new String(str), elem.getName());
                    if (this.strict) return;
                    this.ch = this.readCh();
                    continue;
                }
            }
            if (att != null) {
                attname = att.getName();
            } else {
                this.error("invalid.tagatt", attname, elem.getName());
            }
            if (this.attributes.isDefined(attname)) {
                this.error("multi.tagatt", attname, elem.getName());
            }
            if (attvalue == null) {
                attvalue = att != null && att.value != null ? att.value : "#DEFAULT";
            } else if (att != null && att.values != null && !att.values.contains(attvalue)) {
                this.error("invalid.tagattval", attname, elem.getName());
            }
            HTML.Attribute attkey = HTML.getAttributeKey(attname.toLowerCase(Locale.US));
            if (attkey == HTML.Attribute.CLASS || attkey == HTML.Attribute.ID) {
                if (attkey == HTML.Attribute.CLASS) {
                    this.attributes.addAttribute(EditorHTMLDocument.realClassName, attvalue);
                } else {
                    this.attributes.addAttribute(EditorHTMLDocument.realIDName, attvalue);
                }
                attvalue = attvalue.toLowerCase(Locale.US);
            }
            if (attkey == HTML.Attribute.STYLE && attvalue != null) {
                attvalue = SferyxUtilities.replaceAll(attvalue, "&quot;", "");
            }
            if (attkey == null) {
                this.attributes.addAttribute(attname, attvalue);
                continue;
            }
            if (attkey == HTML.Attribute.ALIGN) {
                this.attributes.addAttribute(attkey, attvalue.toLowerCase());
                continue;
            }
            if (attkey == HTML.Attribute.STYLE && this.attributes.getAttribute(attkey) != null) {
                String exattString = this.attributes.getAttribute(attkey).toString();
                exattString = !exattString.trim().endsWith(";") && !attvalue.trim().startsWith(";") ? exattString + ";" + attvalue.toLowerCase() : exattString + attvalue.toLowerCase();
                exattString = SferyxUtilities.replaceAll(exattString, ";;", ";");
                exattString = SferyxUtilities.replaceAll(exattString, "; ;", ";");
                this.attributes.addAttribute(attkey, exattString);
                continue;
            }
            if (attkey == HTML.Attribute.SRC && attvalue != null && attvalue.indexOf(":\\") != -1 && attvalue.trim().indexOf(":\\") == 1 && attvalue.toLowerCase().indexOf("file:/") == -1 && attvalue.toLowerCase().indexOf("http://") == -1 && attvalue.toLowerCase().indexOf("https://") == -1) {
                try {
                    File f = new File(attvalue);
                    if (f == null) continue;
                    this.attributes.addAttribute(attkey, f.toURL().toString());
                }
                catch (Throwable thr) {
                    this.attributes.addAttribute(attkey, attvalue);
                }
                continue;
            }
            if (attkey == HTML.Attribute.VALUE) {
                String newValue = SferyxUtilities.replaceAll(attvalue, "&quot;", "\"");
                newValue = SferyxUtilities.replaceAll(newValue, "&amp;", "&");
                this.attributes.addAttribute(attkey, newValue);
                continue;
            }
            if (attkey == HTML.Attribute.STYLE && attvalue != null) {
                attvalue = SferyxUtilities.replaceAll(attvalue, ";;", ";");
                attvalue = SferyxUtilities.replaceAll(attvalue, "; ;", ";");
            }
            this.attributes.addAttribute(attkey, attvalue);
        }
    }

    public String parseDTDMarkup() throws IOException {
        StringBuffer strBuff = new StringBuffer();
        this.ch = this.readCh();
        block7: while (true) {
            switch (this.ch) {
                case 62: {
                    this.ch = this.readCh();
                    return strBuff.toString();
                }
                case -1: {
                    this.error("invalid.markup");
                    return strBuff.toString();
                }
                case 10: {
                    ++this.ln;
                    this.ch = this.readCh();
                    ++this.lfCount;
                    continue block7;
                }
                case 34: 
                case 39: {
                    this.ch = this.readCh();
                    continue block7;
                }
                case 13: {
                    ++this.ln;
                    this.ch = this.readCh();
                    if (this.ch == 10) {
                        this.ch = this.readCh();
                        ++this.crlfCount;
                        continue block7;
                    }
                    ++this.crCount;
                    continue block7;
                }
            }
            strBuff.append((char)(this.ch & 0xFF));
            this.ch = this.readCh();
        }
    }

    protected boolean parseMarkupDeclarations(StringBuffer strBuff) throws IOException {
        if (strBuff.length() == "DOCTYPE".length() && strBuff.toString().toUpperCase().equals("DOCTYPE")) {
            this.parseDTDMarkup();
            return true;
        }
        return false;
    }

    void parseInvalidTag() throws IOException {
        while (true) {
            this.skipSpace();
            switch (this.ch) {
                case -1: 
                case 62: {
                    this.ch = this.readCh();
                    return;
                }
                case 60: {
                    return;
                }
            }
            this.ch = this.readCh();
        }
    }

    void parseTag() throws IOException {
        Element elem = null;
        boolean net = false;
        boolean warned = false;
        boolean unknown = false;
        this.ch = this.readCh();
        switch (this.ch) {
            case 33: {
                this.ch = this.readCh();
                switch (this.ch) {
                    case 45: {
                        block36: while (true) {
                            if (this.ch == 45) {
                                if (!this.strict && (this.ch = this.readCh()) == 45) {
                                    int prevChar = this.ch;
                                    this.ch = this.readCh();
                                    if (!this.strict && this.ch == 45) {
                                        this.ch = this.readCh();
                                    }
                                    if (this.textpos != 0) {
                                        char[] newtext = new char[this.textpos];
                                        System.arraycopy(this.text, 0, newtext, 0, this.textpos);
                                        this.handleText(newtext);
                                        this.lastBlockStartPos = this.currentBlockStartPos;
                                        this.textpos = 0;
                                    }
                                    this.parseComment();
                                    this.last = this.makeTag(this.dtd.getElement("comment"), true);
                                    this.handleComment(this.getChars(0));
                                    continue;
                                }
                                if (!warned) {
                                    warned = true;
                                }
                            }
                            this.skipSpace();
                            switch (this.ch) {
                                case 45: {
                                    continue block36;
                                }
                                case 62: {
                                    this.ch = this.readCh();
                                }
                                case -1: {
                                    return;
                                }
                            }
                            this.ch = this.readCh();
                            if (warned) continue;
                            warned = true;
                        }
                    }
                }
                StringBuffer strBuff = new StringBuffer();
                block37: while (true) {
                    strBuff.append((char)this.ch);
                    if (this.parseMarkupDeclarations(strBuff)) {
                        return;
                    }
                    switch (this.ch) {
                        case 62: {
                            this.ch = this.readCh();
                        }
                        case -1: {
                            this.error("invalid.markup");
                            return;
                        }
                        case 10: {
                            ++this.ln;
                            this.ch = this.readCh();
                            ++this.lfCount;
                            continue block37;
                        }
                        case 13: {
                            ++this.ln;
                            this.ch = this.readCh();
                            if (this.ch == 10) {
                                this.ch = this.readCh();
                                ++this.crlfCount;
                                continue block37;
                            }
                            ++this.crCount;
                            continue block37;
                        }
                    }
                    this.ch = this.readCh();
                }
            }
            case 47: {
                this.ch = this.readCh();
                switch (this.ch) {
                    case 62: {
                        this.ch = this.readCh();
                    }
                    case 60: {
                        if (this.recent == null) {
                            return;
                        }
                        elem = this.recent;
                        break;
                    }
                    default: {
                        if (!this.parseIdentifier(false)) {
                            return;
                        }
                        this.skipSpace();
                        switch (this.ch) {
                            case 62: {
                                this.ch = this.readCh();
                            }
                            case 60: {
                                break;
                            }
                            default: {
                                while (this.ch != -1 && this.ch != 10 && this.ch != 62) {
                                    this.ch = this.readCh();
                                }
                                if (this.ch != 62) break;
                                this.ch = this.readCh();
                            }
                        }
                        String elemStr = this.getString(0);
                        if (elemStr.equalsIgnoreCase("span")) {
                            elemStr = elemStr.toLowerCase(Locale.US);
                        }
                        if (!this.dtd.elementExists(elemStr.toLowerCase(Locale.US))) {
                            if (this.textpos > 0 && this.text[this.textpos - 1] == '\n') {
                                --this.textpos;
                            }
                            elem = this.dtd.getElement("unknown");
                            elem.name = elemStr;
                            unknown = true;
                            break;
                        }
                        elem = this.dtd.getElement(elemStr.toLowerCase(Locale.US));
                    }
                }
                if (this.stack == null) {
                    this.error("end.extra.tag", elem.getName());
                    return;
                }
                if (this.textpos > 0 && this.text[this.textpos - 1] == '\n') {
                    if (this.stack.pre) {
                        if (this.textpos > 1 && this.text[this.textpos - 2] != '\n') {
                            --this.textpos;
                        }
                    } else {
                        --this.textpos;
                    }
                }
                if (unknown) {
                    TagElement t = this.makeTag(elem);
                    this.handleText(t);
                    this.attributes.addAttribute(HTML.Attribute.ENDTAG, "true");
                    this.handleEmptyTag(this.makeTag(elem));
                    unknown = false;
                    return;
                }
                if (!this.strict) {
                    String stackElem = this.stack.elem.getName();
                    if (stackElem.equals("table") && !elem.getName().equals(stackElem)) {
                        this.error("tag.ignore", elem.getName());
                        return;
                    }
                    if ((stackElem.equals("tr") || stackElem.equals("td")) && !elem.getName().equals("table") && !elem.getName().equals(stackElem)) {
                        this.error("tag.ignore", elem.getName());
                        return;
                    }
                }
                TagStack sp = this.stack;
                while (sp != null && elem != sp.elem) {
                    sp = sp.next;
                }
                if (sp == null) {
                    this.error("unmatched.endtag", elem.getName());
                    return;
                }
                String elemName = elem.getName();
                if (this.stack != sp && (elemName.equals("font") || elemName.equals("center"))) {
                    if (elemName.equals("center")) {
                        while (this.stack.elem.omitEnd() && this.stack != sp) {
                            this.endTag(true);
                        }
                        if (this.stack.elem == elem) {
                            this.endTag(false);
                        }
                    }
                    return;
                }
                while (this.stack != sp) {
                    this.endTag(true);
                }
                this.endTag(false);
                return;
            }
            case -1: {
                return;
            }
        }
        if (!this.parseIdentifier(false)) {
            elem = this.recent;
            if (this.ch != 62 || elem == null) {
                this.error("expected.tagname");
                return;
            }
        } else {
            String elemStr = this.getString(0);
            if (elemStr.equalsIgnoreCase("span")) {
                elemStr = elemStr.toLowerCase(Locale.US);
            }
            if (elemStr.equals("image")) {
                elemStr = new String("img");
            }
            if (!this.dtd.elementExists(elemStr)) {
                this.error("tag.unrecognized ", elemStr);
                elem = this.dtd.getElement("unknown");
                elem.name = elemStr;
                unknown = true;
            } else {
                elem = this.dtd.getElement(elemStr);
            }
        }
        this.parseAttributeSpecificationList(elem);
        switch (this.ch) {
            case 47: {
                net = true;
            }
            case 62: {
                this.ch = this.readCh();
            }
            case 60: {
                break;
            }
        }
        if (this.strict || elem.getName().equals("script")) {
            // empty if block
        }
        if (!elem.isEmpty()) {
            if (this.ch == 10) {
                ++this.ln;
                ++this.lfCount;
                this.ch = this.readCh();
            } else if (this.ch == 13) {
                ++this.ln;
                this.ch = this.readCh();
                if (this.ch == 10) {
                    this.ch = this.readCh();
                    ++this.crlfCount;
                } else {
                    ++this.crCount;
                }
            }
        }
        TagElement tag = this.makeTag(elem, false);
        if (!unknown) {
            this.legalTagContext(tag);
            if (!this.strict && this.skipTag) {
                this.skipTag = false;
                return;
            }
        }
        this.startTag(tag);
        if (!elem.isEmpty()) {
            switch (elem.getType()) {
                case 1: {
                    this.parseLiteral(false);
                    break;
                }
                case 16: {
                    this.parseLiteral(true);
                    break;
                }
                default: {
                    if (this.stack == null) break;
                    this.stack.net = net;
                }
            }
        }
    }

    void parseContent() throws IOException {
        Thread curThread = Thread.currentThread();
        block8: while (true) {
            if (curThread.isInterrupted()) break;
            int c = this.ch;
            this.currentBlockStartPos = this.currentPosition;
            switch (c) {
                case 60: {
                    this.parseTag();
                    this.lastBlockStartPos = this.currentPosition;
                    continue block8;
                }
                case -1: {
                    return;
                }
                case 38: {
                    char[] data;
                    if (this.textpos == 0) {
                        if (!this.legalElementContext(this.dtd.pcdata)) {
                            this.error("unexpected.pcdata");
                        }
                        if (this.last.breaksFlow()) {
                            this.space = false;
                        }
                    }
                    if (this.textpos + (data = this.parseEntityReference()).length + 1 > this.text.length) {
                        char[] newtext = new char[Math.max(this.textpos + data.length + 128, this.text.length * 2)];
                        System.arraycopy(this.text, 0, newtext, 0, this.text.length);
                        this.text = newtext;
                    }
                    if (this.space) {
                        this.space = false;
                        this.text[this.textpos++] = 32;
                    }
                    System.arraycopy(data, 0, this.text, this.textpos, data.length);
                    this.textpos += data.length;
                    this.ignoreSpace = false;
                    continue block8;
                }
                case 10: {
                    ++this.ln;
                    ++this.lfCount;
                    this.ch = this.readCh();
                    if (this.stack != null && this.stack.pre) break;
                    if (this.textpos == 0) {
                        this.lastBlockStartPos = this.currentPosition;
                    }
                    if (this.ignoreSpace) continue block8;
                    this.space = true;
                    continue block8;
                }
                case 13: {
                    ++this.ln;
                    c = 10;
                    this.ch = this.readCh();
                    if (this.ch == 10) {
                        this.ch = this.readCh();
                        ++this.crlfCount;
                    } else {
                        ++this.crCount;
                    }
                    if (this.stack != null && this.stack.pre) break;
                    if (this.textpos == 0) {
                        this.lastBlockStartPos = this.currentPosition;
                    }
                    if (this.ignoreSpace) continue block8;
                    this.space = true;
                    continue block8;
                }
                case 9: 
                case 32: {
                    this.ch = this.readCh();
                    if (this.stack != null && this.stack.pre) break;
                    if (this.textpos == 0) {
                        this.lastBlockStartPos = this.currentPosition;
                    }
                    if (this.ignoreSpace) continue block8;
                    this.space = true;
                    continue block8;
                }
                default: {
                    if (this.textpos == 0) {
                        if (!this.legalElementContext(this.dtd.pcdata)) {
                            this.error("unexpected.pcdata");
                        }
                        if (this.last.breaksFlow()) {
                            this.space = false;
                        }
                    }
                    this.ch = this.readCh();
                }
            }
            if (this.textpos + 2 > this.text.length) {
                char[] newtext = new char[this.text.length + 128];
                System.arraycopy(this.text, 0, newtext, 0, this.text.length);
                this.text = newtext;
            }
            if (this.space) {
                if (this.textpos == 0) {
                    --this.lastBlockStartPos;
                }
                this.text[this.textpos++] = 32;
                this.space = false;
            }
            this.text[this.textpos++] = (char)c;
            this.ignoreSpace = false;
        }
        curThread.interrupt();
    }

    String getEndOfLineString() {
        if (this.crlfCount >= this.crCount) {
            if (this.lfCount >= this.crlfCount) {
                return "\n";
            }
            return "\r\n";
        }
        if (this.crCount > this.lfCount) {
            return "\r";
        }
        return "\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void parse(Reader in) throws IOException {
        this.in = in;
        this.ln = 1;
        this.seenHtml = false;
        this.seenHead = false;
        this.seenBody = false;
        this.crlfCount = 0;
        this.lfCount = 0;
        this.crCount = 0;
        try {
            try {
                try {
                    this.ch = this.readCh();
                    this.text = new char[10024];
                    this.str = new char[12080];
                    this.parseContent();
                    while (this.stack != null) {
                        this.endTag(true);
                    }
                }
                finally {
                    in.close();
                }
                Object var4_6 = null;
            }
            catch (IOException e) {
                this.errorContext();
                throw e;
            }
            catch (Exception e) {
                this.errorContext();
                e.printStackTrace();
                Object var4_7 = null;
                while (true) {
                    if (this.stack == null) {
                        this.text = null;
                        this.str = null;
                        return;
                    }
                    this.handleEndTag(this.stack.tag);
                    this.stack = this.stack.next;
                }
            }
            catch (ThreadDeath e) {
                this.errorContext();
                e.printStackTrace();
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            while (true) {
                if (this.stack == null) {
                    this.text = null;
                    this.str = null;
                    throw throwable;
                }
                this.handleEndTag(this.stack.tag);
                this.stack = this.stack.next;
            }
        }
        while (this.stack != null) {
            this.handleEndTag(this.stack.tag);
            this.stack = this.stack.next;
        }
        this.text = null;
        this.str = null;
    }

    private final int readCh() throws IOException {
        if (this.pos >= this.len) {
            this.len = this.in.read(this.buf);
            if (this.len <= 0) {
                return -1;
            }
            this.pos = 0;
        }
        ++this.currentPosition;
        return this.buf[this.pos++];
    }

    protected int getCurrentPos() {
        return this.currentPosition;
    }
}

