/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors.filechooser;

import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.border.TitledBorder;

public class ImagePreview
extends JComponent
implements PropertyChangeListener {
    ImageIcon thumbnail = null;
    File file = null;
    JFileChooser fileChooser;

    public ImagePreview(JFileChooser fc) {
        fc.addPropertyChangeListener(this);
        this.setBorder(new TitledBorder("Image preview"));
        this.fileChooser = fc;
    }

    public void loadImage() {
        if (this.file == null) {
            this.thumbnail = null;
            this.setPreferredSize(new Dimension(0, 0));
            this.revalidate();
            this.fileChooser.doLayout();
            return;
        }
        if (this.file.getPath().toLowerCase().endsWith(".jpg") || this.file.getPath().endsWith(".gif") || this.file.getPath().endsWith(".png")) {
            this.setPreferredSize(new Dimension(200, 200));
            this.revalidate();
            this.fileChooser.doLayout();
        } else {
            this.setPreferredSize(new Dimension(0, 0));
            this.revalidate();
            this.fileChooser.doLayout();
        }
        ImageIcon tmpIcon = new ImageIcon(this.file.getPath());
        if (tmpIcon != null) {
            this.thumbnail = tmpIcon.getIconWidth() > this.getPreferredSize().width - 10 ? new ImageIcon(tmpIcon.getImage().getScaledInstance(this.getPreferredSize().width - 10, -1, 1)) : tmpIcon;
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        boolean update = false;
        String prop = e.getPropertyName();
        if ("directoryChanged".equals(prop)) {
            this.file = null;
            update = true;
        } else if ("SelectedFileChangedProperty".equals(prop)) {
            this.file = (File)e.getNewValue();
            update = true;
        }
        if (update) {
            this.thumbnail = null;
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }
    }

    protected void paintComponent(Graphics g) {
        if (this.thumbnail == null) {
            this.loadImage();
        }
        if (this.thumbnail != null) {
            int x = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
            int y = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
            if (y < 0) {
                y = 0;
            }
            if (x < 5) {
                x = 5;
            }
            this.thumbnail.paintIcon(this, g, x, y);
        }
    }
}

