/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors.filechooser;

import java.awt.Dimension;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import sferyx.administration.editors.filechooser.ImagePreview;

public class CustomFileChooser
extends JFileChooser {
    Dimension original_dimension;

    public CustomFileChooser() {
        this.setAccessory(new ImagePreview(this));
        this.original_dimension = this.getPreferredSize();
    }

    public void addNotify() {
        this.setPreferredSize(this.original_dimension);
        super.addNotify();
    }

    public void setImageFilter() {
        this.setFileFilter(new ImageFilter());
    }

    public void setTextFilter() {
        this.setFileFilter(new TextFilter());
    }

    public void resetFilter() {
        this.resetChoosableFileFilters();
    }

    public String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    class TextFilter
    extends FileFilter {
        TextFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = CustomFileChooser.this.getExtension(f);
            if (extension != null) {
                return extension.equals("htm") || extension.equals("html") || extension.equals("shtml") || extension.equals("shtm") || extension.equals("txt") || extension.equals("rtf") || extension.equals("xml") || extension.equals("css") || extension.equals("xhtml") || extension.startsWith("php") || extension.equals("js") || extension.equals("jsp") || extension.equals("java") || extension.equals("cfm") || extension.startsWith("asp");
            }
            return false;
        }

        public String getDescription() {
            return "*.htm; *.html; *.shtml; *.shtm; *.txt; *.rtf; *.xml; *.css; *.xhtml; *.php; *.js; *.jsp; *.java; *.cfm; *.asp";
        }
    }

    class ImageFilter
    extends FileFilter {
        ImageFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = CustomFileChooser.this.getExtension(f);
            if (extension != null) {
                return extension.equals("tiff") || extension.equals("tif") || extension.equals("gif") || extension.equals("jpeg") || extension.equals("jpg") || extension.equals("bmp") || extension.equals("png");
            }
            return false;
        }

        public String getDescription() {
            return "*.gif; *.jpeg; *.jpg; *.png; *.tiff; *.tif; *.bmp";
        }
    }
}

