/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.util.StringTokenizer;
import sferyx.administration.editors.CustomXMLTagsGrammarSpecification;

public class XMLGrammarBuilder {
    String[] knowTags = new String[]{"!DOCTYPE", "A", "ADDRESS", "APPLET", "AREA", "B", "BASE", "BASEFONT", "BIG", "BLOCKQUOTE", "BODY", "BR", "BR/", "CAPTION", "CENTER", "CITE", "CODE", "COL", "COLGROUP", "COMMENT", "CONTENT", "DD", "DFN", "DIR", "DIV", "DL", "DT", "EM", "EMBED", "FONT", "FORM", "FRAME", "FRAMESET", "H1", "H2", "H3", "H4", "H5", "H6", "HEAD", "HR", "HTML", "I", "IMG", "IMPLIED", "INPUT", "ISINDEX", "KBD", "LI", "LINK", "MAP", "MENU", "META", "NOBR", "NOFRAMES", "NOSCRIPT", "OBJECT", "OL", "OPTION", "P", "PARAM", "PRE", "S", "SAMP", "SCRIPT", "SELECT", "SMALL", "SPAN", "STRIKE", "STRONG", "STYLE", "SUB", "SUP", "TABLE", "TBODY", "TD", "TEXTAREA", "TH", "TITLE", "TR", "TT", "U", "UL", "VAR"};

    public XMLGrammarBuilder(String content) {
        this.buildGrammar(content);
    }

    public void buildGrammar(String content) {
        StringBuffer filteredContentBuffer = new StringBuffer();
        StringTokenizer st = new StringTokenizer(content, "<>", true);
        boolean inTag = false;
        boolean skipping = false;
        boolean skipClose = false;
        String previousTag = "";
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("<")) {
                inTag = true;
            } else if (token.equals(">")) {
                if (skipping) {
                    skipClose = true;
                    skipping = false;
                }
                inTag = false;
            }
            try {
                String tagName;
                if (!inTag || token.equals("<") || token.equals(">") || token.trim().equals("")) continue;
                int indexOfSpace = token.indexOf(" ");
                int indexOfSlash = token.lastIndexOf("/");
                boolean isClosingTagSlash = indexOfSlash == token.length() - 1;
                int indexOfLineBreak = token.indexOf("\n");
                int tokenLength = token.trim().length();
                if (indexOfLineBreak != -1 && indexOfLineBreak < tokenLength) {
                    token = token.substring(0, indexOfLineBreak);
                }
                if (this.isKnownTag((tagName = indexOfSpace != -1 && indexOfSpace < tokenLength ? token.substring(0, indexOfSpace) : (indexOfSlash == -1 ? token : (indexOfSlash == tokenLength - 1 ? token.substring(0, indexOfSlash) : token))).toLowerCase())) continue;
                if (indexOfSlash != -1 && isClosingTagSlash) {
                    CustomXMLTagsGrammarSpecification.registerCustomXMLTag(tagName, true);
                    continue;
                }
                if (content.indexOf("</" + tagName + ">") != -1) {
                    CustomXMLTagsGrammarSpecification.registerCustomXMLTag(tagName, false);
                    if (CustomXMLTagsGrammarSpecification.getRenderingModesSpecification().get(tagName) != null) continue;
                    if (CustomXMLTagsGrammarSpecification.isTreatAllBlockTagsAsBlocks()) {
                        CustomXMLTagsGrammarSpecification.registerCustomXMLTagRenderingType(tagName, "BLOCK_TAG");
                        continue;
                    }
                    CustomXMLTagsGrammarSpecification.registerCustomXMLTagRenderingType(tagName, "INLINE_TAG");
                    continue;
                }
                CustomXMLTagsGrammarSpecification.registerCustomXMLTag(tagName, true);
            }
            catch (Throwable thr) {}
        }
    }

    boolean isKnownTag(String tag) {
        if (tag.startsWith("/") || tag.startsWith("!--") || tag.trim().equals("")) {
            return true;
        }
        for (int i = 0; i < this.knowTags.length; ++i) {
            if (!this.knowTags[i].equalsIgnoreCase(tag.trim())) continue;
            return true;
        }
        return false;
    }
}

