/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.SizeRequirements;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import sferyx.administration.editors.AlternativeCSSAttribute;
import sferyx.administration.editors.ColumnLayoutHandler;
import sferyx.administration.editors.CustomBlockView;
import sferyx.administration.editors.CustomBoxPainter;
import sferyx.administration.editors.CustomLayoutBoxView;
import sferyx.administration.editors.CustomTableCelView;
import sferyx.administration.editors.CustomTableRowView;
import sferyx.administration.editors.EmptyView;
import sferyx.administration.editors.HTMLEditor;
import sferyx.administration.editors.RowLayoutHandler;
import sferyx.administration.editors.SferyxUtilities;

public class TableView
extends BoxView
implements ViewFactory {
    private AttributeSet attr;
    private StyleSheet.BoxPainter painter;
    int cellSpacing;
    private int captionIndex = -1;
    boolean relativeCells;
    boolean multiRowCells;
    int[] columnSpans;
    int[] columnOffsets;
    SizeRequirements totalColumnRequirements;
    SizeRequirements[] columnRequirements;
    RowLayoutHandler rowIterator_ = SferyxUtilities.getRowLayoutHandlerInstance(this);
    ColumnLayoutHandler colIterator_ = SferyxUtilities.getColumnLayoutHandlerInstance(this);
    Vector rows;
    boolean gridValid = false;
    static final BitSet EMPTY = new BitSet();
    boolean paintInvisibleCells = true;
    short captionTopHeight = 0;
    short captionBottomHeight = 0;
    boolean synchTable = false;
    StyleSheet sheet;
    AttributeSet oldElementAttributes;
    boolean skipComments = false;
    int[] offsets_X = new int[0];
    int[] offsets_Y = new int[0];
    int[] spans_X = new int[0];
    int[] spans_Y = new int[0];
    CustomBoxPainter boxPainter;
    boolean margin_right_em = false;
    boolean margin_left_em = false;
    Rectangle boundsRect;
    boolean loading = false;

    public TableView(Element elem) {
        super(elem, 1);
        this.rows = new Vector();
        this.totalColumnRequirements = new SizeRequirements();
    }

    public TableView(Element elem, boolean paintInvisibleCells_) {
        super(elem, 1);
        this.rows = new Vector();
        this.totalColumnRequirements = new SizeRequirements();
        this.paintInvisibleCells = paintInvisibleCells_;
    }

    protected void loadChildren_(ViewFactory f) {
        super.loadChildren(f);
    }

    public float getMinimumSpan(int axis) {
        return super.getMinimumSpan(axis);
    }

    public float getPreferredSpan(int axis) {
        return this.getPreferredSpan_(axis);
    }

    public float getPreferredSpan_(int axis) {
        if (axis == 0) {
            try {
                float width = this.getWidthCSSValue();
                if (width != -1.0f) {
                    return width;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.getPreferredSpan(axis);
    }

    public float getMaximumSpan(int axis) {
        return this.getMaximumSpan_(axis);
    }

    public float getMaximumSpan_(int axis) {
        if (axis == 0) {
            try {
                float width = this.getWidthCSSValue();
                if (width != -1.0f) {
                    return width;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.getMaximumSpan(axis);
    }

    public float getWidthCSSValue() {
        float span = -1.0f;
        if (this.getAttributes().getAttribute(CSS.Attribute.WIDTH) != null || this.getAttributes().getAttribute(HTML.Attribute.WIDTH) != null) {
            return -1.0f;
        }
        AttributeSet eleAttribs = this.getElement().getAttributes();
        String emMargin = (String)eleAttribs.getAttribute("width");
        AttributeSet viewAttributes = this.getAttributes();
        if (emMargin == null) {
            emMargin = (String)viewAttributes.getAttribute("width");
        }
        if (emMargin == null) {
            emMargin = (String)eleAttribs.getAttribute(AlternativeCSSAttribute.WIDTH);
        }
        if (emMargin == null) {
            emMargin = (String)viewAttributes.getAttribute(AlternativeCSSAttribute.WIDTH);
        }
        if (emMargin != null & (eleAttribs.isDefined("width") || viewAttributes.isDefined("width") || viewAttributes.isDefined(AlternativeCSSAttribute.WIDTH) || eleAttribs.isDefined(AlternativeCSSAttribute.WIDTH))) {
            if (emMargin != null && emMargin.indexOf("em") != -1 && emMargin.indexOf("rem") == -1) {
                float emValue = SferyxUtilities.convertEmValue(emMargin);
                if (emValue != -1.0f) {
                    Font font = this.getStyleSheet().getFont(this.getAttributes());
                    int result = (int)((float)font.getSize() * emValue);
                    this.margin_left_em = true;
                    return result;
                }
            } else if (emMargin != null && emMargin.indexOf("rem") != -1) {
                float emValue = SferyxUtilities.convertEmValue(emMargin);
                if (emValue != -1.0f && this.getContainer() != null) {
                    View rootView = ((JEditorPane)this.getContainer()).getUI().getRootView((JEditorPane)this.getContainer());
                    Font font = this.getStyleSheet().getFont(rootView.getAttributes());
                    int result = (int)((float)font.getSize() * emValue);
                    this.margin_left_em = true;
                    return result;
                }
            } else if (emMargin != null && emMargin.indexOf("%") != -1) {
                try {
                    float emValue = Float.parseFloat(emMargin.substring(0, emMargin.indexOf("%")));
                    if (emValue != -1.0f && this.getParent() instanceof BoxView) {
                        int result = (int)((float)((BoxView)this.getParent()).getWidth() * emValue / 100.0f);
                        return result;
                    }
                }
                catch (Throwable thr) {
                    // empty catch block
                }
            }
        }
        return span;
    }

    protected void loadChildren1(ViewFactory f) {
        final ViewFactory fac = f;
        Runnable docUpdate = new Runnable(){

            public void run() {
                TableView.this.loadChildren_(fac);
            }
        };
        SwingUtilities.invokeLater(new Thread(docUpdate));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void layout(int width, int height) {
        try {
            super.layout(width, height);
            if (this.offsets_X.length == 0) {
                this.offsets_X = new int[this.getViewCount()];
            }
            if (this.spans_X.length == 0) {
                this.spans_X = new int[this.getViewCount()];
            }
            if (this.offsets_Y.length == 0) {
                this.offsets_Y = new int[this.getViewCount()];
            }
            if (this.spans_Y.length == 0) {
                this.spans_Y = new int[this.getViewCount()];
            }
            if (this.offsets_X != null && this.spans_X != null && this.offsets_Y != null && this.spans_Y != null && !HTMLEditor.jvm_version.startsWith("1.3")) return;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected CustomTableRowView createTableRow(Element elem) {
        Object o = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (o == HTML.Tag.TR) {
            return new CustomTableRowView(elem, this);
        }
        return null;
    }

    public int getColumnCount() {
        return this.columnSpans.length;
    }

    public int getColumnSpan(int col) {
        if (col < this.columnSpans.length) {
            return this.columnSpans[col];
        }
        return 0;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getMultiRowSpan(int row0, int row1) {
        CustomTableRowView rv0 = this.getRow(row0);
        CustomTableRowView rv1 = this.getRow(row1);
        if (rv0 != null && rv1 != null) {
            int index0 = rv0.viewIndex;
            int index1 = rv1.viewIndex;
            int lastRowSpan = this.getSpan(1, index1);
            int span = this.getOffset(1, index1) - this.getOffset(1, index0) + lastRowSpan;
            return span;
        }
        return 0;
    }

    public int getRowSpan(int row) {
        CustomTableRowView rv = this.getRow(row);
        if (rv != null) {
            return this.getSpan(1, rv.viewIndex);
        }
        return 0;
    }

    CustomTableRowView getRow(int row) {
        if (row < this.rows.size()) {
            return (CustomTableRowView)this.rows.elementAt(row);
        }
        return null;
    }

    protected View getViewAtPoint(int x, int y, Rectangle alloc) {
        int n = this.getViewCount();
        View v = null;
        Rectangle allocation = new Rectangle();
        for (int i = 0; i < n; ++i) {
            allocation.setBounds(alloc);
            this.childAllocation(i, allocation);
            v = this.getView(i);
            if (v instanceof CustomTableRowView) {
                if ((v = ((CustomTableRowView)v).findViewAtPoint(x, y, allocation)) == null) continue;
                alloc.setBounds(allocation);
                return v;
            }
            v = this.findViewAtPoint(x, y, allocation);
            alloc.setBounds(allocation);
            return v;
        }
        return super.getViewAtPoint(x, y, alloc);
    }

    View findViewAtPoint(int x, int y, Rectangle alloc) {
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            if (!this.getChildAllocation(i, alloc).contains(x, y)) continue;
            this.childAllocation(i, alloc);
            return this.getView(i);
        }
        return null;
    }

    protected int getColumnsOccupied(View v) {
        String s;
        AttributeSet a = v.getElement().getAttributes();
        if (a.isDefined(HTML.Attribute.COLSPAN) && (s = (String)a.getAttribute(HTML.Attribute.COLSPAN)) != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return 1;
    }

    protected int getRowsOccupied(View v) {
        String s;
        AttributeSet a = v.getElement().getAttributes();
        if (a.isDefined(HTML.Attribute.ROWSPAN) && (s = (String)a.getAttribute(HTML.Attribute.ROWSPAN)) != null) {
            try {
                int rowSpan = Integer.parseInt(s);
                if (rowSpan > 1) {
                    View rowView = v.getParent();
                    for (int i = 0; i < rowView.getViewCount(); ++i) {
                        View cv = rowView.getView(i);
                        if (!(cv instanceof CustomTableCelView) || cv.getElement().getAttributes().isDefined(HTML.Attribute.ROWSPAN) && cv.getElement().getAttributes().getAttribute(HTML.Attribute.ROWSPAN) != null && cv.getElement().getAttributes().getAttribute(HTML.Attribute.ROWSPAN).equals(s)) continue;
                        return rowSpan;
                    }
                }
                return 1;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return 1;
    }

    public void invalidateGrid() {
        this.gridValid = false;
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        return doc.getStyleSheet();
    }

    void updateInsets() {
        short top = 0;
        short bottom = 0;
        this.captionTopHeight = 0;
        this.captionBottomHeight = 0;
        if (this.painter != null) {
            top = (short)this.painter.getInset(1, this);
            bottom = (short)this.painter.getInset(3, this);
        }
        if (this.captionIndex != -1) {
            View caption = this.getView(this.captionIndex);
            short h = (short)caption.getPreferredSpan(1);
            AttributeSet a = caption.getAttributes();
            Object align = SferyxUtilities.getAttributeValueFromString(a, "caption-side");
            if (align != null && align.equals("bottom")) {
                bottom = (short)(bottom + h);
                this.captionBottomHeight = h;
            } else {
                top = (short)(top + h);
                this.captionTopHeight = h;
            }
        }
        if (this.painter != null) {
            // empty if block
        }
    }

    public AttributeSet getAttributes() {
        if (this.sheet == null) {
            this.sheet = this.getStyleSheet();
        }
        if (this.attr == null || this.oldElementAttributes != null && !this.oldElementAttributes.equals(this.getElement().getAttributes())) {
            this.attr = this.sheet.getViewAttributes(this);
            this.oldElementAttributes = this.getElement().getAttributes().copyAttributes();
            this.synchTable = true;
        }
        return this.attr;
    }

    public void setPropertiesFromAttributes() {
        StyleSheet sheet = this.getStyleSheet();
        this.attr = sheet.getViewAttributes(this);
        try {
            if (!HTMLEditor.jvm_version.startsWith("1.7")) {
                this.painter = sheet.getBoxPainter(this.attr);
            }
            if (this.attr != null && this.painter != null) {
                this.setInsets((short)this.painter.getInset(1, this), (short)this.painter.getInset(2, this), (short)this.painter.getInset(3, this), (short)this.painter.getInset(4, this));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.synchTable = true;
    }

    public void updateGrid() {
        if (!this.gridValid) {
            this.relativeCells = false;
            this.multiRowCells = false;
            this.captionIndex = -1;
            this.rows.removeAllElements();
            int n = this.getViewCount();
            for (int i = 0; i < n; ++i) {
                HTML.Tag kind;
                View v = this.getView(i);
                if (v instanceof CustomTableRowView) {
                    this.rows.addElement(v);
                    CustomTableRowView rv = (CustomTableRowView)v;
                    rv.clearFilledColumns();
                    rv.rowIndex = this.rows.size() - 1;
                    rv.viewIndex = i;
                    continue;
                }
                Object o = v.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
                if (!(o instanceof HTML.Tag) || (kind = (HTML.Tag)o) != HTML.Tag.CAPTION) continue;
                this.captionIndex = i;
            }
            int maxColumns = 0;
            int nrows = this.rows.size();
            for (int row = 0; row < nrows; ++row) {
                CustomTableRowView rv = this.getRow(row);
                int col = 0;
                int cell = 0;
                while (cell < rv.getViewCount()) {
                    View cv = rv.getView(cell);
                    if (cv instanceof CustomTableCelView) {
                        int colSpan;
                        AttributeSet a;
                        Object lv;
                        if (!this.relativeCells && (lv = (a = cv.getAttributes()).getAttribute(CSS.Attribute.WIDTH)) != null && lv.toString().endsWith("%")) {
                            this.relativeCells = true;
                        }
                        while (rv.isFilled(col)) {
                            ++col;
                        }
                        int rowSpan = this.getRowsOccupied(cv);
                        if (rowSpan > 1) {
                            this.multiRowCells = true;
                        }
                        if ((colSpan = this.getColumnsOccupied(cv)) > 1 || rowSpan > 1) {
                            int rowLimit = row + rowSpan;
                            int colLimit = col + colSpan;
                            for (int i = row; i < rowLimit; ++i) {
                                for (int j = col; j < colLimit; ++j) {
                                    if (i == row && j == col) continue;
                                    this.addFill(i, j);
                                }
                            }
                            if (colSpan > 1) {
                                col += colSpan - 1;
                            }
                        }
                    }
                    ++cell;
                    ++col;
                }
                maxColumns = Math.max(maxColumns, col);
            }
            this.columnSpans = new int[maxColumns];
            this.columnOffsets = new int[maxColumns];
            this.columnRequirements = new SizeRequirements[maxColumns];
            for (int i = 0; i < maxColumns; ++i) {
                this.columnRequirements[i] = new SizeRequirements();
                this.columnRequirements[i].maximum = Integer.MAX_VALUE;
            }
            this.gridValid = true;
        }
    }

    void addFill(int row, int col) {
        CustomTableRowView rv = this.getRow(row);
        if (rv != null) {
            rv.fillColumn(col);
        }
    }

    protected void layoutColumns(int targetSpan, int[] offsets, int[] spans, SizeRequirements[] reqs) {
        try {
            Arrays.fill(offsets, 0);
            Arrays.fill(spans, 0);
            this.colIterator_.setLayoutArrays(offsets, spans, targetSpan);
            SferyxUtilities.calculateTiledLayout(this.colIterator_, targetSpan);
        }
        catch (Throwable thrrr) {
            thrrr.printStackTrace();
        }
    }

    void calculateColumnRequirements(int axis) {
        View cv;
        int cell;
        int ncells;
        int col;
        CustomTableRowView row;
        int i;
        for (int i2 = 0; i2 < this.columnRequirements.length; ++i2) {
            SizeRequirements req = this.columnRequirements[i2];
            req.minimum = 0;
            req.preferred = 0;
            req.maximum = Integer.MAX_VALUE;
        }
        Container host = this.getContainer();
        if (host != null) {
            if (host instanceof JTextComponent) {
                this.skipComments = !((JTextComponent)host).isEditable();
                this.skipComments = false;
            } else {
                this.skipComments = false;
            }
        }
        boolean hasMultiColumn = false;
        int nrows = this.getRowCount();
        for (i = 0; i < nrows; ++i) {
            row = this.getRow(i);
            col = 0;
            ncells = row.getViewCount();
            for (cell = 0; cell < ncells; ++cell) {
                cv = row.getView(cell);
                if (this.skipComments && !(cv instanceof CustomTableCelView)) continue;
                while (row.isFilled(col)) {
                    ++col;
                }
                int rowSpan = this.getRowsOccupied(cv);
                int colSpan = this.getColumnsOccupied(cv);
                if (colSpan == 1) {
                    this.checkSingleColumnCell(axis, col, cv);
                } else {
                    hasMultiColumn = true;
                    col += colSpan - 1;
                }
                ++col;
            }
        }
        if (hasMultiColumn) {
            for (i = 0; i < nrows; ++i) {
                row = this.getRow(i);
                col = 0;
                ncells = row.getViewCount();
                for (cell = 0; cell < ncells; ++cell) {
                    cv = row.getView(cell);
                    if (this.skipComments && !(cv instanceof CustomTableCelView)) continue;
                    while (row.isFilled(col)) {
                        ++col;
                    }
                    int colSpan = this.getColumnsOccupied(cv);
                    if (colSpan > 1) {
                        this.checkMultiColumnCell(axis, col, colSpan, cv);
                        col += colSpan - 1;
                    }
                    ++col;
                }
            }
        }
    }

    void checkSingleColumnCell(int axis, int col, View v) {
        try {
            SizeRequirements req = this.columnRequirements[col];
            req.minimum = Math.max((int)v.getMinimumSpan(axis), req.minimum);
            req.preferred = Math.max((int)v.getPreferredSpan(axis), req.preferred);
        }
        catch (Throwable thr) {
            // empty catch block
        }
    }

    void checkMultiColumnCell(int axis, int col, int ncols, View v) {
        int cpref;
        long min = 0L;
        long pref = 0L;
        long max = 0L;
        for (int i = 0; i < ncols; ++i) {
            if (col + i >= this.columnRequirements.length) {
                return;
            }
            SizeRequirements req = this.columnRequirements[col + i];
            min += (long)req.minimum;
            pref += (long)req.preferred;
            max += (long)req.maximum;
        }
        int cmin = (int)v.getMinimumSpan(axis);
        if ((long)cmin > min) {
            SizeRequirements[] reqs = new SizeRequirements[ncols];
            for (int i = 0; i < ncols; ++i) {
                reqs[i] = this.columnRequirements[col + i];
            }
            int[] spans = new int[ncols];
            int[] offsets = new int[ncols];
            SizeRequirements.calculateTiledPositions(cmin, null, reqs, offsets, spans);
            for (int i = 0; i < ncols; ++i) {
                SizeRequirements req = reqs[i];
                req.minimum = Math.max(spans[i], req.minimum);
                req.preferred = Math.max(req.minimum, req.preferred);
                req.maximum = Math.max(req.preferred, req.maximum);
            }
        }
        if ((long)(cpref = (int)v.getPreferredSpan(axis)) > pref) {
            SizeRequirements[] reqs = new SizeRequirements[ncols];
            for (int i = 0; i < ncols; ++i) {
                reqs[i] = this.columnRequirements[col + i];
            }
            int[] spans = new int[ncols];
            int[] offsets = new int[ncols];
            SizeRequirements.calculateTiledPositions(cpref, null, reqs, offsets, spans);
            for (int i = 0; i < ncols; ++i) {
                SizeRequirements req = reqs[i];
                req.preferred = Math.max(spans[i], req.preferred);
                req.maximum = Math.max(req.preferred, req.maximum);
            }
        }
    }

    static boolean spanSetFromAttributes(int axis, SizeRequirements r, Object cssWidth, Object cssHeight) {
        if (axis == 0) {
            if (cssWidth != null && !cssWidth.toString().endsWith("%")) {
                r.preferred = r.maximum = (int)SferyxUtilities.getNumberFromCSString(cssWidth.toString());
                r.minimum = r.maximum;
                return true;
            }
        } else if (cssHeight != null && !cssHeight.toString().endsWith("%")) {
            r.preferred = r.maximum = (int)SferyxUtilities.getNumberFromCSString(cssHeight.toString());
            r.minimum = r.maximum;
            return true;
        }
        return false;
    }

    protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
        String ta;
        this.updateGrid();
        this.calculateColumnRequirements(axis);
        if (r == null) {
            r = new SizeRequirements();
        }
        long min = 0L;
        long pref = 0L;
        int n = this.columnRequirements.length;
        for (int i = 0; i < n; ++i) {
            SizeRequirements req = this.columnRequirements[i];
            min += (long)req.minimum;
            pref += (long)req.preferred;
        }
        int adjust = (n - 1) * this.cellSpacing;
        r.minimum = (int)(min += (long)adjust);
        r.preferred = (int)(pref += (long)adjust);
        r.maximum = (int)pref;
        AttributeSet attr = this.getAttributes();
        Object cssWidth = attr.getAttribute(CSS.Attribute.WIDTH);
        if (TableView.spanSetFromAttributes(axis, r, cssWidth, null) && r.minimum < (int)min) {
            r.minimum = r.preferred = (int)min;
            r.maximum = r.preferred;
        }
        this.totalColumnRequirements.minimum = r.minimum;
        this.totalColumnRequirements.preferred = r.preferred;
        this.totalColumnRequirements.maximum = r.maximum;
        Object o = attr.getAttribute(CSS.Attribute.TEXT_ALIGN);
        r.alignment = o != null ? ((ta = o.toString()).equals("left") ? 0.0f : (ta.equals("center") ? 0.5f : (ta.equals("right") ? 1.0f : 0.0f))) : 0.0f;
        return r;
    }

    protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements r) {
        this.updateInsets();
        this.rowIterator_.updateAdjustments();
        r = SferyxUtilities.calculateTiledRequirements(this.rowIterator_, r);
        r.maximum = r.preferred;
        return r;
    }

    protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        this.updateGrid();
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            CustomTableRowView row = this.getRow(i);
            row.layoutChanged(axis);
        }
        this.layoutColumns(targetSpan, this.columnOffsets, this.columnSpans, this.columnRequirements);
        super.layoutMinorAxis(targetSpan, axis, offsets, spans);
        this.offsets_X = offsets;
        this.spans_X = spans;
    }

    protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        this.rowIterator_.setLayoutArrays(offsets, spans);
        SferyxUtilities.calculateTiledLayout(this.rowIterator_, targetSpan);
        if (this.captionIndex != -1) {
            int h;
            View caption = this.getView(this.captionIndex);
            spans[this.captionIndex] = h = (int)caption.getPreferredSpan(1);
            short boxBottom = 0;
            if (this.painter != null) {
                boxBottom = (short)this.painter.getInset(3, this);
            }
            offsets[this.captionIndex] = boxBottom != this.getBottomInset() ? (int)(-this.getTopInset()) : (int)(-this.getTopInset());
        }
        this.offsets_Y = offsets;
        this.spans_Y = spans;
    }

    protected View getViewAtPosition(int pos, Rectangle a) {
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            View v = this.getView(i);
            int p0 = v.getStartOffset();
            int p1 = v.getEndOffset();
            if (pos < p0 || pos >= p1) continue;
            if (a != null) {
                this.childAllocation(i, a);
            }
            return v;
        }
        if (pos == this.getEndOffset()) {
            View v = this.getView(n - 1);
            if (a != null) {
                this.childAllocation(n - 1, a);
            }
            return v;
        }
        return null;
    }

    public int getBottomMargin() {
        return SferyxUtilities.getBottomMargin(this);
    }

    public int getTopMargin() {
        return SferyxUtilities.getTopMargin(this);
    }

    public int getLeftMargin() {
        return SferyxUtilities.getLeftMargin(this);
    }

    public int getRightMargin() {
        return SferyxUtilities.getRightMargin(this);
    }

    public short getTopInset() {
        short inset = (short)SferyxUtilities.getCellTopBorderSize(this.getAttributes(), this.getElement());
        return (short)(inset + this.captionTopHeight);
    }

    public short getBottomInset() {
        short inset = (short)SferyxUtilities.getCellBottomBorderSize(this.getAttributes(), this.getElement());
        return (short)(inset + this.captionBottomHeight);
    }

    public short getRightInset() {
        short inset = (short)SferyxUtilities.getCellRightBorderSize(this.getAttributes(), this.getElement());
        return inset;
    }

    public short getLeftInset() {
        short inset = (short)SferyxUtilities.getCellLeftBorderSize(this.getAttributes(), this.getElement());
        return inset;
    }

    public void paint11(Graphics g, Shape allocation) {
        int i;
        Rectangle a = allocation.getBounds();
        this.setSize(a.width, a.height);
        if (this.captionIndex != -1) {
            short top = 0;
            short bottom = 0;
            if (this.painter != null) {
                top = (short)this.painter.getInset(1, this);
                bottom = (short)this.painter.getInset(3, this);
            }
            if (top != this.getTopInset()) {
                int h = this.getTopInset() - top;
                a.y += h;
                a.height -= h;
            } else {
                a.height -= this.getBottomInset() - bottom;
            }
        }
        if (this.boxPainter == null || !this.boxPainter.attr.equals(this.getAttributes())) {
            this.boxPainter = new CustomBoxPainter(this.getAttributes(), this.getStyleSheet(), this);
        }
        this.boxPainter.paint(g, a.x, a.y, a.width, a.height, this);
        int n = this.getViewCount();
        for (i = 0; i < n; ++i) {
            View v = this.getView(i);
            v.paint(g, this.getChildAllocation(i, allocation));
        }
        if (this.synchTable) {
            for (i = 0; i < n; ++i) {
                View v = this.getView(i);
                for (int j = 0; j < v.getViewCount(); ++j) {
                    View cell = v.getView(j);
                    if (!(cell instanceof CustomTableCelView)) continue;
                    ((CustomTableCelView)cell).oldElementAttributes = new SimpleAttributeSet();
                    SferyxUtilities.paintViewBorder(cell, (Rectangle)v.getChildAllocation(j, (Rectangle)this.getChildAllocation(i, allocation)), g);
                }
                SferyxUtilities.paintViewBorder(v, (Rectangle)this.getChildAllocation(i, allocation), g);
            }
        }
        Rectangle borderRect = new Rectangle(a.x, a.y, a.width, a.height);
        SferyxUtilities.paintViewBorder(this, borderRect, g);
        if (this.synchTable) {
            this.synchTable = false;
        }
    }

    public void paint(Graphics g, Shape allocation) {
        Rectangle a = allocation.getBounds();
        AffineTransform saveAT = (AffineTransform)((Graphics2D)g).getTransform().clone();
        this.checkTransformation(g, a);
        Rectangle borderRect_ = new Rectangle(a);
        int padding = 2;
        AttributeSet elementAttribs = this.getElement().getAttributes();
        if (elementAttribs.getAttribute(HTML.Attribute.CELLSPACING) != null && elementAttribs.containsAttribute(HTML.Attribute.CELLSPACING, elementAttribs.getAttribute(HTML.Attribute.CELLSPACING))) {
            try {
                padding = Integer.parseInt(elementAttribs.getAttribute(HTML.Attribute.CELLSPACING).toString());
            }
            catch (Throwable thr) {
                // empty catch block
            }
        }
        if (this.boundsRect == null) {
            this.boundsRect = new Rectangle(a.x, a.y, a.width, a.height);
        } else {
            this.boundsRect.x = a.x;
            this.boundsRect.y = a.y;
            this.boundsRect.width = a.width;
            this.boundsRect.height = a.height;
        }
        if (this.captionIndex != -1) {
            short top = 0;
            short bottom = 0;
            if (this.painter != null) {
                top = (short)this.painter.getInset(1, this);
                bottom = (short)this.painter.getInset(3, this);
            }
            if (top != this.getTopInset()) {
                int h = this.getTopInset() - top;
                a.y += h;
                a.height -= h;
            } else {
                a.height -= this.getBottomInset() - bottom;
            }
        }
        int borderThickness = SferyxUtilities.getCellLeftBorderSize(this.getAttributes(), this.getElement());
        borderRect_ = new Rectangle(a.x, a.y, a.width + padding, a.height + padding);
        if (this.boxPainter == null || !this.boxPainter.attr.equals(this.getAttributes())) {
            this.boxPainter = new CustomBoxPainter(this.getAttributes(), this.getStyleSheet(), this);
        }
        this.boxPainter.paint(g, borderRect_.x, borderRect_.y, borderRect_.width, borderRect_.height, this);
        boolean maxRowWidth = false;
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            View v = this.getView(i);
            Rectangle clip = g.getClipBounds();
            Rectangle tempRect = (Rectangle)this.getChildAllocation(i, allocation);
            v.paint(g, tempRect);
        }
        SferyxUtilities.paintViewBorder(this, borderRect_, g);
        if (this.synchTable) {
            this.synchTable = false;
        }
        ((Graphics2D)g).setTransform(saveAT);
    }

    public void setParent(View parent) {
        if (parent instanceof CustomLayoutBoxView) {
            this.loading = ((CustomLayoutBoxView)parent).loading;
        }
        super.setParent(parent);
        if (parent != null) {
            this.setPropertiesFromAttributes();
        }
    }

    public ViewFactory getViewFactory() {
        return this;
    }

    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.insertUpdate(e, a, this);
    }

    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.removeUpdate(e, a, this);
    }

    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.changedUpdate(e, a, this);
    }

    protected void forwardUpdate(DocumentEvent.ElementChange ec, DocumentEvent e, Shape a, ViewFactory f) {
        Container c;
        super.forwardUpdate(ec, e, a, f);
        if (a != null && (c = this.getContainer()) != null) {
            Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            c.repaint(alloc.x, alloc.y, alloc.width, alloc.height);
        }
    }

    public void replace(int offset, int length, View[] views) {
        super.replace(offset, length, views);
        this.invalidateGrid();
    }

    public View create(Element elem) {
        ViewFactory f;
        View p;
        Object o = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (o instanceof HTML.Tag) {
            HTML.Tag kind = (HTML.Tag)o;
            if (kind == HTML.Tag.TR) {
                return this.createTableRow(elem);
            }
            if (kind == HTML.Tag.TD || kind == HTML.Tag.TH) {
                CustomTableCelView cellView = new CustomTableCelView(elem);
                if (!this.paintInvisibleCells) {
                    cellView.paintInvisibleCells = this.paintInvisibleCells;
                }
                return cellView;
            }
            if (kind == HTML.Tag.CAPTION) {
                return new CustomBlockView(elem, 1);
            }
        }
        if ((p = this.getParent()) != null && (f = p.getViewFactory()) != null) {
            if (elem.getParentElement().getName().equals("table")) {
                return new EmptyView(elem);
            }
            return f.create(elem);
        }
        return null;
    }

    Shape getTransformedShape(Shape shape) {
        try {
            if (!(this.getParent() instanceof CustomLayoutBoxView)) {
                return shape;
            }
            int x = 0;
            int y = 0;
            int width = 0;
            int height = 0;
            if (this.getParent() instanceof CustomLayoutBoxView) {
                CustomLayoutBoxView parent = (CustomLayoutBoxView)this.getParent();
                x = parent.getOffset(0, SferyxUtilities.indexOfView(this));
                y = parent.getOffset(1, SferyxUtilities.indexOfView(this));
                width = parent.getSpan(0, SferyxUtilities.indexOfView(this));
                height = parent.getSpan(1, SferyxUtilities.indexOfView(this));
            }
            Rectangle alloc = new Rectangle(x, y, width, height);
            String transform = null;
            if (this.getElement().getAttributes().getAttribute("transform") != null && this.getElement().getAttributes().isDefined("transform")) {
                transform = this.getElement().getAttributes().getAttribute("transform").toString().toLowerCase().trim();
            } else if (this.getAttributes().getAttribute("transform") != null && this.getAttributes().isDefined("transform")) {
                transform = this.getAttributes().getAttribute("transform").toString().toLowerCase().trim();
            }
            if (transform != null && transform.startsWith("rotate(") && transform.endsWith(")") && transform.length() > 8) {
                String angle = transform.substring(transform.indexOf("(") + 1, transform.indexOf(")"));
                if (angle.endsWith("deg")) {
                    angle = angle.substring(0, angle.indexOf("deg"));
                }
                AffineTransform transf = AffineTransform.getRotateInstance(Double.valueOf(angle) * Math.PI / 180.0, alloc.x + alloc.width / 2, alloc.y + alloc.height / 2);
                shape = transf.createTransformedShape(shape);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return shape;
    }

    Point getInvertedTransformedPoint(Point p, Shape shape) {
        block10: {
            try {
                if (!(this.getParent() instanceof CustomLayoutBoxView)) {
                    return p;
                }
                int x = 0;
                int y = 0;
                int width = 0;
                int height = 0;
                if (this.getParent() instanceof CustomLayoutBoxView) {
                    CustomLayoutBoxView parent = (CustomLayoutBoxView)this.getParent();
                    x = parent.getOffset(0, SferyxUtilities.indexOfView(this));
                    y = parent.getOffset(1, SferyxUtilities.indexOfView(this));
                    width = parent.getSpan(0, SferyxUtilities.indexOfView(this));
                    height = parent.getSpan(1, SferyxUtilities.indexOfView(this));
                }
                Rectangle alloc = new Rectangle(x, y, width, height);
                String transform = null;
                if (this.getElement().getAttributes().getAttribute("transform") != null && this.getElement().getAttributes().isDefined("transform")) {
                    transform = this.getElement().getAttributes().getAttribute("transform").toString().toLowerCase().trim();
                } else if (this.getAttributes().getAttribute("transform") != null && this.getAttributes().isDefined("transform")) {
                    transform = this.getAttributes().getAttribute("transform").toString().toLowerCase().trim();
                }
                if (transform == null || !transform.startsWith("rotate(") || !transform.endsWith(")") || transform.length() <= 8) break block10;
                String angle = transform.substring(transform.indexOf("(") + 1, transform.indexOf(")"));
                if (angle.endsWith("deg")) {
                    angle = angle.substring(0, angle.indexOf("deg"));
                }
                AffineTransform transf = AffineTransform.getRotateInstance(Double.valueOf(angle) * Math.PI / 180.0, alloc.x + alloc.width / 2, alloc.y + alloc.height / 2);
                try {
                    transf = transf.createInverse();
                }
                catch (Throwable thr) {
                    // empty catch block
                }
                Point2D po = transf.transform(p, p);
                p = new Point((int)po.getX(), (int)po.getY());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return p;
    }

    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        Shape shape = super.modelToView(pos, a, b);
        shape = this.getTransformedShape(shape);
        return shape;
    }

    public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
        Point r = new Point((int)x, (int)y);
        r = this.getInvertedTransformedPoint(r, a);
        x = r.x;
        y = r.y;
        return super.viewToModel(x, y, a, bias);
    }

    void checkTransformation(Graphics g, Rectangle alloc) {
        try {
            String transform = null;
            if (this.getElement().getAttributes().getAttribute("transform") != null && this.getElement().getAttributes().isDefined("transform")) {
                transform = this.getElement().getAttributes().getAttribute("transform").toString().toLowerCase().trim();
            } else if (this.getAttributes().getAttribute("transform") != null && this.getAttributes().isDefined("transform")) {
                transform = this.getAttributes().getAttribute("transform").toString().toLowerCase().trim();
            }
            if (transform != null && transform.startsWith("rotate(") && transform.endsWith(")") && transform.length() > 8) {
                String angle = transform.substring(transform.indexOf("(") + 1, transform.indexOf(")"));
                if (angle.endsWith("deg")) {
                    angle = angle.substring(0, angle.indexOf("deg"));
                }
                Rectangle rot_alloc = alloc;
                AffineTransform transf = AffineTransform.getRotateInstance(Double.valueOf(angle) * Math.PI / 180.0, rot_alloc.x + rot_alloc.width / 2, rot_alloc.y + rot_alloc.height / 2);
                AffineTransform curr_transf = ((Graphics2D)g).getTransform();
                if (curr_transf != null) {
                    curr_transf.concatenate(transf);
                    ((Graphics2D)g).setTransform(curr_transf);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

