/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import sferyx.administration.editors.ColorChooserDialog;
import sferyx.administration.editors.HTMLEditor;
import sferyx.administration.editors.NumericTextFieldKeyListener;
import sferyx.administration.editors.RemoteFileDialog;
import sferyx.administration.editors.SferyxUtilities;
import sferyx.administration.editors.extensions.BrowsableComponent;
import sferyx.administration.editors.filechooser.CustomFileChooser;

public class TablePropertiesDialog
extends JDialog {
    NumericTextFieldKeyListener numericListener = new NumericTextFieldKeyListener();
    BrowsableComponent imageBrowsable;
    private JComboBox alignmentCombo;
    private JLabel captionLabe;
    private JButton browseBackgroundPictureButton;
    private JButton borderColorAutomatic;
    private JLabel backgroundColorLabel;
    private JSeparator bordersSeparator;
    private JRadioButton heightPixelsRadioBtn;
    private JSeparator backgroundSeparator;
    private JSeparator layoutSeparator;
    private JLabel backgroundLabel;
    private JButton selectBackgroundColorButton;
    private JTextField borderThicknessTextField;
    private JTextField specifyHeightTextField;
    private JLabel layoutLabel;
    private JLabel cellPaddingLabel;
    private JLabel widthLabel;
    private JPanel jPanel1;
    private ButtonGroup widthRadioButtonGroup;
    private JLabel borderThicknessLabel;
    private JTextField backgroundPictureTextField;
    private JTextArea tableCaptionTextArea;
    private JLabel cellSpacingLabel;
    private JRadioButton widthPercentsRadioBtn;
    private JComboBox styleClassComboBox;
    private JLabel styleClassLabel;
    private JTextField specifyWidthTextField;
    private JLabel borderColorLabel;
    private JRadioButton widthPixelsRadioBtn;
    private JButton cancelButton;
    private JButton selectBorderColorButton;
    private JLabel heightLabel;
    private JTextField cellPaddingTextField;
    private JSeparator jSeparator1;
    private JLabel bordersLabel;
    private JCheckBox backgroundPictureCheckBox;
    private JLabel borderColorPreviewLabel;
    private JScrollPane tableCaptionScrollPane;
    private JLabel alignmentLabel;
    private JLabel backgroundColorPreviewLabel;
    private JTextField cellSpacingTextField;
    private JRadioButton heightPercentsRadioBtn;
    private JButton backgroundColorAutomatic;
    private JButton okButton;
    private ButtonGroup heightRadioButtonGroup;
    JFileChooser fileChooser;
    AttributeSet attributes;
    boolean cancel = false;
    HTMLEditor htmlPanel;
    RemoteFileDialog remoteFileDialog;
    String tableCaption = "";

    public TablePropertiesDialog(Frame parent, boolean modal) {
        super(parent, true);
        this.initComponents();
        this.backgroundPictureTextField.setBackground(this.getBackground());
        this.selectBorderColorButton.setEnabled(true);
        this.borderColorPreviewLabel.setOpaque(true);
        this.borderThicknessTextField.addKeyListener(this.numericListener);
        this.specifyHeightTextField.addKeyListener(this.numericListener);
        this.cellSpacingTextField.addKeyListener(this.numericListener);
        this.specifyWidthTextField.addKeyListener(this.numericListener);
        this.cellPaddingTextField.addKeyListener(this.numericListener);
    }

    public TablePropertiesDialog(Dialog parent, boolean modal) {
        super(parent, true);
        this.initComponents();
        this.backgroundPictureTextField.setBackground(this.getBackground());
        this.selectBorderColorButton.setEnabled(true);
        this.borderColorPreviewLabel.setOpaque(true);
        this.borderThicknessTextField.addKeyListener(this.numericListener);
        this.specifyHeightTextField.addKeyListener(this.numericListener);
        this.cellSpacingTextField.addKeyListener(this.numericListener);
        this.specifyWidthTextField.addKeyListener(this.numericListener);
        this.cellPaddingTextField.addKeyListener(this.numericListener);
    }

    private void initComponents() {
        this.widthRadioButtonGroup = new ButtonGroup();
        this.heightRadioButtonGroup = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.layoutLabel = new JLabel();
        this.layoutSeparator = new JSeparator();
        this.alignmentLabel = new JLabel();
        this.alignmentCombo = new JComboBox();
        this.borderColorLabel = new JLabel();
        this.borderThicknessTextField = new JTextField();
        this.backgroundLabel = new JLabel();
        this.backgroundSeparator = new JSeparator();
        this.specifyWidthTextField = new JTextField();
        this.widthLabel = new JLabel();
        this.heightLabel = new JLabel();
        this.specifyHeightTextField = new JTextField();
        this.widthPixelsRadioBtn = new JRadioButton();
        this.widthPercentsRadioBtn = new JRadioButton();
        this.heightPercentsRadioBtn = new JRadioButton();
        this.heightPixelsRadioBtn = new JRadioButton();
        this.backgroundPictureCheckBox = new JCheckBox();
        this.cellPaddingTextField = new JTextField();
        this.cellPaddingLabel = new JLabel();
        this.cellSpacingTextField = new JTextField();
        this.cellSpacingLabel = new JLabel();
        this.bordersSeparator = new JSeparator();
        this.bordersLabel = new JLabel();
        this.borderThicknessLabel = new JLabel();
        this.selectBorderColorButton = new JButton();
        this.borderColorPreviewLabel = new JLabel();
        this.backgroundPictureTextField = new JTextField();
        this.browseBackgroundPictureButton = new JButton();
        this.backgroundColorLabel = new JLabel();
        this.backgroundColorPreviewLabel = new JLabel();
        this.selectBackgroundColorButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.backgroundColorAutomatic = new JButton();
        this.styleClassLabel = new JLabel();
        this.styleClassComboBox = new JComboBox();
        this.borderColorAutomatic = new JButton();
        this.captionLabe = new JLabel();
        this.tableCaptionScrollPane = new JScrollPane();
        this.tableCaptionTextArea = new JTextArea();
        this.setTitle("Table Properties");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                TablePropertiesDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(null);
        this.layoutLabel.setHorizontalAlignment(4);
        this.layoutLabel.setText("Layout");
        this.jPanel1.add(this.layoutLabel);
        this.layoutLabel.setBounds(10, 10, 130, 16);
        this.jPanel1.add(this.layoutSeparator);
        this.layoutSeparator.setBounds(150, 21, 330, 2);
        this.alignmentLabel.setHorizontalAlignment(4);
        this.alignmentLabel.setText("Alignment:");
        this.jPanel1.add(this.alignmentLabel);
        this.alignmentLabel.setBounds(10, 40, 140, 16);
        this.alignmentCombo.setEditable(true);
        this.alignmentCombo.setFont(new Font("Dialog", 0, 11));
        this.alignmentCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"default", "left", "right", "center", "justify"}));
        this.jPanel1.add(this.alignmentCombo);
        this.alignmentCombo.setBounds(160, 40, 100, 20);
        this.borderColorLabel.setHorizontalAlignment(4);
        this.borderColorLabel.setText("Color:");
        this.jPanel1.add(this.borderColorLabel);
        this.borderColorLabel.setBounds(20, 180, 110, 16);
        this.borderThicknessTextField.setFont(new Font("Dialog", 0, 11));
        this.borderThicknessTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablePropertiesDialog.this.borderThicknessTextFieldActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.borderThicknessTextField);
        this.borderThicknessTextField.setBounds(200, 150, 20, 19);
        this.backgroundLabel.setHorizontalAlignment(4);
        this.backgroundLabel.setText("Background");
        this.jPanel1.add(this.backgroundLabel);
        this.backgroundLabel.setBounds(10, 210, 120, 16);
        this.jPanel1.add(this.backgroundSeparator);
        this.backgroundSeparator.setBounds(140, 222, 340, 2);
        this.specifyWidthTextField.setFont(new Font("Dialog", 0, 11));
        this.jPanel1.add(this.specifyWidthTextField);
        this.specifyWidthTextField.setBounds(270, 50, 70, 19);
        this.widthLabel.setText("Width:");
        this.jPanel1.add(this.widthLabel);
        this.widthLabel.setBounds(270, 30, 70, 16);
        this.heightLabel.setText("Height:");
        this.jPanel1.add(this.heightLabel);
        this.heightLabel.setBounds(270, 80, 70, 16);
        this.specifyHeightTextField.setFont(new Font("Dialog", 0, 11));
        this.jPanel1.add(this.specifyHeightTextField);
        this.specifyHeightTextField.setBounds(270, 100, 70, 19);
        this.widthPixelsRadioBtn.setSelected(true);
        this.widthPixelsRadioBtn.setText("In pixels");
        this.widthRadioButtonGroup.add(this.widthPixelsRadioBtn);
        this.jPanel1.add(this.widthPixelsRadioBtn);
        this.widthPixelsRadioBtn.setBounds(340, 30, 150, 24);
        this.widthPercentsRadioBtn.setText("In percents");
        this.widthRadioButtonGroup.add(this.widthPercentsRadioBtn);
        this.jPanel1.add(this.widthPercentsRadioBtn);
        this.widthPercentsRadioBtn.setBounds(340, 50, 150, 24);
        this.heightPercentsRadioBtn.setText("In percents");
        this.heightRadioButtonGroup.add(this.heightPercentsRadioBtn);
        this.jPanel1.add(this.heightPercentsRadioBtn);
        this.heightPercentsRadioBtn.setBounds(340, 100, 150, 24);
        this.heightPixelsRadioBtn.setSelected(true);
        this.heightPixelsRadioBtn.setText("In pixels");
        this.heightRadioButtonGroup.add(this.heightPixelsRadioBtn);
        this.jPanel1.add(this.heightPixelsRadioBtn);
        this.heightPixelsRadioBtn.setBounds(340, 80, 150, 24);
        this.backgroundPictureCheckBox.setText("Use background picture");
        this.backgroundPictureCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                TablePropertiesDialog.this.backgroundPictureCheckBoxStateChanged(evt);
            }
        });
        this.jPanel1.add(this.backgroundPictureCheckBox);
        this.backgroundPictureCheckBox.setBounds(30, 270, 240, 24);
        this.cellPaddingTextField.setFont(new Font("Dialog", 0, 11));
        this.cellPaddingTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablePropertiesDialog.this.cellPaddingTextFieldActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cellPaddingTextField);
        this.cellPaddingTextField.setBounds(160, 70, 60, 19);
        this.cellPaddingLabel.setHorizontalAlignment(4);
        this.cellPaddingLabel.setText("Cell padding:");
        this.jPanel1.add(this.cellPaddingLabel);
        this.cellPaddingLabel.setBounds(10, 70, 140, 16);
        this.cellSpacingTextField.setFont(new Font("Dialog", 0, 11));
        this.cellSpacingTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablePropertiesDialog.this.cellSpacingTextFieldActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cellSpacingTextField);
        this.cellSpacingTextField.setBounds(160, 100, 60, 19);
        this.cellSpacingLabel.setHorizontalAlignment(4);
        this.cellSpacingLabel.setText("Cell spacing:");
        this.jPanel1.add(this.cellSpacingLabel);
        this.cellSpacingLabel.setBounds(10, 100, 140, 16);
        this.jPanel1.add(this.bordersSeparator);
        this.bordersSeparator.setBounds(130, 142, 350, 2);
        this.bordersLabel.setHorizontalAlignment(4);
        this.bordersLabel.setText("Borders");
        this.jPanel1.add(this.bordersLabel);
        this.bordersLabel.setBounds(10, 130, 110, 16);
        this.borderThicknessLabel.setHorizontalAlignment(4);
        this.borderThicknessLabel.setText("Border thickness:");
        this.jPanel1.add(this.borderThicknessLabel);
        this.borderThicknessLabel.setBounds(10, 150, 180, 16);
        this.selectBorderColorButton.setText("Select..");
        this.selectBorderColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablePropertiesDialog.this.selectBorderColorButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.selectBorderColorButton);
        this.selectBorderColorButton.setBounds(220, 180, 120, 26);
        this.borderColorPreviewLabel.setHorizontalAlignment(0);
        this.jPanel1.add(this.borderColorPreviewLabel);
        this.borderColorPreviewLabel.setBounds(140, 180, 60, 20);
        this.backgroundPictureTextField.setFont(new Font("Dialog", 0, 11));
        this.jPanel1.add(this.backgroundPictureTextField);
        this.backgroundPictureTextField.setBounds(30, 300, 270, 19);
        this.browseBackgroundPictureButton.setText("Browse..");
        this.browseBackgroundPictureButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablePropertiesDialog.this.browseBackgroundPictureButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.browseBackgroundPictureButton);
        this.browseBackgroundPictureButton.setBounds(310, 300, 120, 26);
        this.backgroundColorLabel.setHorizontalAlignment(4);
        this.backgroundColorLabel.setText("Color:");
        this.jPanel1.add(this.backgroundColorLabel);
        this.backgroundColorLabel.setBounds(10, 240, 100, 16);
        this.backgroundColorPreviewLabel.setHorizontalAlignment(0);
        this.backgroundColorPreviewLabel.setText("jLabel1");
        this.backgroundColorPreviewLabel.setOpaque(true);
        this.jPanel1.add(this.backgroundColorPreviewLabel);
        this.backgroundColorPreviewLabel.setBounds(120, 240, 70, 16);
        this.selectBackgroundColorButton.setText("Select..");
        this.selectBackgroundColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablePropertiesDialog.this.selectBackgroundColorButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.selectBackgroundColorButton);
        this.selectBackgroundColorButton.setBounds(220, 240, 120, 26);
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablePropertiesDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.okButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                TablePropertiesDialog.this.okButtonMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                TablePropertiesDialog.this.okButtonMouseReleased(evt);
            }
        });
        this.jPanel1.add(this.okButton);
        this.okButton.setBounds(230, 430, 120, 26);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablePropertiesDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelButton);
        this.cancelButton.setBounds(360, 430, 120, 26);
        this.jPanel1.add(this.jSeparator1);
        this.jSeparator1.setBounds(30, 420, 450, 2);
        this.backgroundColorAutomatic.setText("Automatic");
        this.backgroundColorAutomatic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablePropertiesDialog.this.backgroundColorAutomaticActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.backgroundColorAutomatic);
        this.backgroundColorAutomatic.setBounds(350, 240, 120, 26);
        this.styleClassLabel.setHorizontalAlignment(4);
        this.styleClassLabel.setText("Style:");
        this.jPanel1.add(this.styleClassLabel);
        this.styleClassLabel.setBounds(10, 340, 110, 16);
        this.styleClassComboBox.setEditable(true);
        this.styleClassComboBox.setFocusCycleRoot(true);
        this.styleClassComboBox.setVerifyInputWhenFocusTarget(false);
        this.styleClassComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablePropertiesDialog.this.styleClassComboBoxActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.styleClassComboBox);
        this.styleClassComboBox.setBounds(130, 340, 150, 20);
        this.borderColorAutomatic.setText("Automatic");
        this.borderColorAutomatic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablePropertiesDialog.this.borderColorAutomaticActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.borderColorAutomatic);
        this.borderColorAutomatic.setBounds(350, 180, 120, 26);
        this.captionLabe.setHorizontalAlignment(4);
        this.captionLabe.setText("Table caption:");
        this.jPanel1.add(this.captionLabe);
        this.captionLabe.setBounds(20, 380, 200, 16);
        this.tableCaptionScrollPane.setViewportView(this.tableCaptionTextArea);
        this.jPanel1.add(this.tableCaptionScrollPane);
        this.tableCaptionScrollPane.setBounds(230, 370, 250, 40);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void styleClassComboBoxActionPerformed(ActionEvent evt) {
    }

    private void cellPaddingTextFieldActionPerformed(ActionEvent evt) {
    }

    private void cellSpacingTextFieldActionPerformed(ActionEvent evt) {
    }

    private void borderColorAutomaticActionPerformed(ActionEvent evt) {
        this.borderColorPreviewLabel.setText("");
        this.borderColorPreviewLabel.setBackground(this.getBackground());
        this.borderColorPreviewLabel.setOpaque(false);
        this.borderThicknessTextField.setText("");
    }

    private void borderThicknessTextFieldActionPerformed(ActionEvent evt) {
    }

    private void okButtonMouseReleased(MouseEvent evt) {
    }

    private void okButtonMousePressed(MouseEvent evt) {
        this.okButton.requestFocus();
    }

    private void backgroundColorAutomaticActionPerformed(ActionEvent evt) {
        this.backgroundColorPreviewLabel.setText("");
        this.backgroundColorPreviewLabel.setOpaque(false);
    }

    public void setCustomImageBrowsable(BrowsableComponent browsable) {
        this.imageBrowsable = browsable;
        this.browseBackgroundPictureButton.setEnabled(true);
    }

    private void browseBackgroundPictureButtonActionPerformed(ActionEvent evt) {
        if (this.imageBrowsable != null) {
            this.imageBrowsable.show();
            if (this.imageBrowsable.isActionCancelled()) {
                return;
            }
            try {
                this.backgroundPictureTextField.setText(this.imageBrowsable.getResultingURL());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        if (this.fileChooser != null) {
            int returnVal;
            this.fileChooser.setDialogType(0);
            if (this.fileChooser instanceof CustomFileChooser) {
                ((CustomFileChooser)this.fileChooser).setImageFilter();
            }
            if ((returnVal = this.fileChooser.showOpenDialog(this)) == 0) {
                try {
                    this.backgroundPictureTextField.setText(this.htmlPanel.getRelativePath(this.fileChooser.getSelectedFile().toURL().toString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!this.backgroundPictureCheckBox.isSelected()) {
                    this.backgroundPictureCheckBox.doClick();
                }
            }
        } else if (this.remoteFileDialog != null) {
            try {
                this.remoteFileDialog.setVisible(true);
                String imageURL = this.remoteFileDialog.getSelectedFile();
                if (imageURL != null) {
                    this.backgroundPictureTextField.setText(this.htmlPanel.getRelativePath(imageURL));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void backgroundPictureCheckBoxStateChanged(ChangeEvent evt) {
        if (this.backgroundPictureCheckBox.isSelected()) {
            this.backgroundPictureTextField.setEnabled(true);
            this.backgroundPictureTextField.setBackground(Color.white);
        } else {
            this.backgroundPictureTextField.setEnabled(false);
            this.backgroundPictureTextField.setBackground(this.getBackground());
        }
    }

    private void selectBackgroundColorButtonActionPerformed(ActionEvent evt) {
        if (this.htmlPanel.colorChooserDialog == null) {
            this.htmlPanel.colorChooserDialog = SwingUtilities.windowForComponent(this) instanceof Frame ? new ColorChooserDialog((Frame)SwingUtilities.windowForComponent(this), true, this.htmlPanel.getTranslatedString("Choose Foreground Color")) : new ColorChooserDialog((Dialog)SwingUtilities.windowForComponent(this), true, this.htmlPanel.getTranslatedString("Choose Foreground Color"));
        }
        this.htmlPanel.colorChooserDialog.setTitle(this.htmlPanel.getTranslatedString("Choose Background Color"));
        if (this.backgroundColorPreviewLabel.isOpaque()) {
            this.htmlPanel.colorChooserDialog.setSelectedColor(this.backgroundColorPreviewLabel.getBackground());
        } else {
            this.htmlPanel.colorChooserDialog.setSelectedColor(null);
        }
        this.htmlPanel.translateContainer(this.htmlPanel.colorChooserDialog);
        this.htmlPanel.colorChooserDialog.setVisible(true);
        int result = this.htmlPanel.colorChooserDialog.getActionResult();
        ColorChooserDialog cfr_ignored_0 = this.htmlPanel.colorChooserDialog;
        if (result == ColorChooserDialog.OK_BUTTON) {
            Color newColor = this.htmlPanel.colorChooserDialog.getSelectedColor();
            if (newColor == null) {
                return;
            }
            this.backgroundColorPreviewLabel.setBackground(newColor);
            this.backgroundColorPreviewLabel.setOpaque(true);
            this.backgroundColorPreviewLabel.setText(this.htmlPanel.colorToString(newColor));
        }
    }

    private void selectBorderColorButtonActionPerformed(ActionEvent evt) {
        if (this.htmlPanel.colorChooserDialog == null) {
            this.htmlPanel.colorChooserDialog = SwingUtilities.windowForComponent(this) instanceof Frame ? new ColorChooserDialog((Frame)SwingUtilities.windowForComponent(this), true, this.htmlPanel.getTranslatedString("Choose Foreground Color")) : new ColorChooserDialog((Dialog)SwingUtilities.windowForComponent(this), true, this.htmlPanel.getTranslatedString("Choose Foreground Color"));
        }
        this.htmlPanel.colorChooserDialog.setTitle(this.htmlPanel.getTranslatedString("Choose Border Color"));
        if (this.borderColorPreviewLabel.isOpaque()) {
            this.htmlPanel.colorChooserDialog.setSelectedColor(this.borderColorPreviewLabel.getBackground());
        } else {
            this.htmlPanel.colorChooserDialog.setSelectedColor(null);
        }
        this.htmlPanel.translateContainer(this.htmlPanel.colorChooserDialog);
        this.htmlPanel.colorChooserDialog.setVisible(true);
        int result = this.htmlPanel.colorChooserDialog.getActionResult();
        ColorChooserDialog cfr_ignored_0 = this.htmlPanel.colorChooserDialog;
        if (result == ColorChooserDialog.OK_BUTTON) {
            Color newColor = this.htmlPanel.colorChooserDialog.getSelectedColor();
            if (newColor == null) {
                return;
            }
            this.borderColorPreviewLabel.setBackground(newColor);
            this.borderColorPreviewLabel.setOpaque(true);
            this.borderColorPreviewLabel.setText(this.htmlPanel.colorToString(newColor));
            if (this.borderThicknessTextField.getText().trim().equals("")) {
                this.borderThicknessTextField.setText("1");
            }
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.cancel = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.cancel = false;
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.cancel = true;
        this.setVisible(false);
        this.dispose();
    }

    public void setVisible(boolean b) {
        this.setSize(500, 500);
        if (b) {
            this.setLocation((int)((double)this.getParent().getLocationOnScreen().x + this.getParent().getBounds().getWidth() / 2.0 - this.getBounds().getWidth() / 2.0), (int)((double)this.getParent().getLocationOnScreen().y + this.getParent().getBounds().getHeight() / 2.0 - this.getBounds().getHeight() / 2.0));
        }
        super.setVisible(b);
    }

    public void setCaption(String caption) {
        this.tableCaptionTextArea.setText(caption);
    }

    public void initDialogFields(AttributeSet attribs) {
        String width;
        String bgColor;
        this.attributes = attribs;
        String backgroundPic = (String)attribs.getAttribute(HTML.Attribute.BACKGROUND);
        if (backgroundPic == null && attribs.getAttribute(CSS.Attribute.BACKGROUND_IMAGE) != null) {
            backgroundPic = attribs.getAttribute(CSS.Attribute.BACKGROUND_IMAGE).toString();
        }
        if (backgroundPic != null && this.attributes.containsAttribute(HTML.Attribute.BACKGROUND, backgroundPic)) {
            this.backgroundPictureTextField.setText(backgroundPic);
            if (!this.backgroundPictureCheckBox.isSelected()) {
                this.backgroundPictureCheckBox.doClick();
            }
        } else {
            this.backgroundPictureTextField.setText("");
            if (this.backgroundPictureCheckBox.isSelected()) {
                this.backgroundPictureCheckBox.doClick();
            }
        }
        if ((bgColor = (String)attribs.getAttribute(HTML.Attribute.BGCOLOR)) == null && attribs.getAttribute(CSS.Attribute.BACKGROUND_COLOR) != null) {
            bgColor = attribs.getAttribute(CSS.Attribute.BACKGROUND_COLOR).toString();
        }
        if (bgColor != null && (this.attributes.containsAttribute(HTML.Attribute.BGCOLOR, bgColor) || this.attributes.getAttribute(CSS.Attribute.BACKGROUND_COLOR) != null && this.attributes.containsAttribute(CSS.Attribute.BACKGROUND_COLOR, attribs.getAttribute(CSS.Attribute.BACKGROUND_COLOR)))) {
            try {
                this.backgroundColorPreviewLabel.setText(bgColor);
                this.backgroundColorPreviewLabel.setBackground(this.htmlPanel.convertStringToColor(bgColor));
                this.backgroundColorPreviewLabel.setOpaque(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.backgroundColorPreviewLabel.setText("");
            this.backgroundColorPreviewLabel.setOpaque(false);
        }
        Object borderColor = attribs.getAttribute(CSS.Attribute.BORDER_COLOR);
        if (borderColor != null && this.attributes.containsAttribute(CSS.Attribute.BORDER_COLOR, borderColor)) {
            try {
                this.borderColorPreviewLabel.setText(borderColor.toString());
                this.borderColorPreviewLabel.setBackground(this.htmlPanel.convertStringToColor(borderColor.toString()));
                this.borderColorPreviewLabel.setOpaque(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.borderColorPreviewLabel.setText("");
            this.borderColorPreviewLabel.setOpaque(false);
        }
        String align = (String)attribs.getAttribute(HTML.Attribute.ALIGN);
        if (align != null && this.attributes.containsAttribute(HTML.Attribute.ALIGN, align)) {
            this.alignmentCombo.setSelectedItem(align.toLowerCase());
        } else {
            this.alignmentCombo.setSelectedItem("default");
        }
        String border = (String)attribs.getAttribute(HTML.Attribute.BORDER);
        if (border != null) {
            this.borderThicknessTextField.setText(border);
        } else {
            this.borderThicknessTextField.setText("");
        }
        if (border != null && border.equals("0")) {
            Object altBorder = this.attributes.getAttribute(CSS.Attribute.BORDER_TOP_WIDTH);
            if (altBorder != null) {
                this.borderThicknessTextField.setText("" + (int)SferyxUtilities.getNumberFromCSString(altBorder.toString()));
            } else if (this.attributes.getAttribute(CSS.Attribute.BORDER_WIDTH) != null) {
                if (this.attributes.containsAttribute(CSS.Attribute.BORDER_WIDTH, this.attributes.getAttribute(CSS.Attribute.BORDER_WIDTH))) {
                    this.borderThicknessTextField.setText((int)SferyxUtilities.getNumberFromCSString(this.attributes.getAttribute(CSS.Attribute.BORDER_WIDTH).toString()) + "");
                } else {
                    this.borderThicknessTextField.setText("");
                }
            }
        }
        if ((width = (String)attribs.getAttribute(HTML.Attribute.WIDTH)) == null && attribs.getAttribute(CSS.Attribute.WIDTH) != null) {
            width = attribs.getAttribute(CSS.Attribute.WIDTH).toString();
        }
        if (width != null && !width.equals("") && (this.attributes.containsAttribute(HTML.Attribute.WIDTH, width) || this.attributes.getAttribute(CSS.Attribute.WIDTH) != null && this.attributes.containsAttribute(CSS.Attribute.WIDTH, this.attributes.getAttribute(CSS.Attribute.WIDTH)))) {
            this.specifyWidthTextField.setText(width);
            if (width.endsWith("%")) {
                this.widthPercentsRadioBtn.setSelected(true);
            } else {
                this.widthPixelsRadioBtn.setSelected(true);
            }
        } else {
            this.specifyWidthTextField.setText("");
            this.widthPixelsRadioBtn.setSelected(true);
        }
        String height = (String)attribs.getAttribute(HTML.Attribute.HEIGHT);
        if (height == null && attribs.getAttribute(CSS.Attribute.HEIGHT) != null) {
            height = attribs.getAttribute(CSS.Attribute.HEIGHT).toString();
        }
        if (height != null && !height.equals("") && (this.attributes.containsAttribute(HTML.Attribute.HEIGHT, height) || this.attributes.getAttribute(CSS.Attribute.HEIGHT) != null && this.attributes.containsAttribute(CSS.Attribute.HEIGHT, this.attributes.getAttribute(CSS.Attribute.HEIGHT)))) {
            this.specifyHeightTextField.setText(height);
            if (width.endsWith("%")) {
                this.heightPercentsRadioBtn.setSelected(true);
            } else {
                this.heightPixelsRadioBtn.setSelected(true);
            }
        } else {
            this.specifyHeightTextField.setText(height);
            this.heightPixelsRadioBtn.setSelected(true);
        }
        String cellspace = (String)attribs.getAttribute(HTML.Attribute.CELLSPACING);
        if (cellspace != null && this.attributes.containsAttribute(HTML.Attribute.CELLSPACING, cellspace)) {
            this.cellSpacingTextField.setText(cellspace);
        } else {
            this.cellSpacingTextField.setText("");
        }
        String cellpad = (String)attribs.getAttribute(HTML.Attribute.CELLPADDING);
        if (cellpad != null && this.attributes.containsAttribute(HTML.Attribute.CELLPADDING, cellpad)) {
            this.cellPaddingTextField.setText(cellpad);
        } else {
            this.cellPaddingTextField.setText("");
        }
        this.styleClassComboBox.setModel(new DefaultComboBoxModel(this.htmlPanel.getStyleClasses()));
        String styleClass = (String)attribs.getAttribute(HTML.Attribute.CLASS);
        if (styleClass != null && this.attributes.containsAttribute(HTML.Attribute.CLASS, styleClass)) {
            this.styleClassComboBox.setSelectedItem(styleClass);
        } else {
            this.styleClassComboBox.setSelectedIndex(-1);
        }
        this.styleClassComboBox.setRenderer(this.htmlPanel.getStyleClassRendererInstance());
        this.okButton.requestFocus();
        if (this.htmlPanel.isDisableTableBackgrounds()) {
            this.backgroundPictureCheckBox.setEnabled(false);
            this.browseBackgroundPictureButton.setEnabled(false);
        } else {
            this.backgroundPictureCheckBox.setEnabled(true);
            this.browseBackgroundPictureButton.setEnabled(true);
        }
    }

    public AttributeSet getNewAttributes() {
        String bordercolor;
        if (this.cancel) {
            return null;
        }
        SimpleAttributeSet newAttribs = new SimpleAttributeSet(this.attributes);
        this.tableCaption = this.tableCaptionTextArea.getText().trim();
        if (!this.alignmentCombo.getSelectedItem().equals("default")) {
            newAttribs.addAttribute(HTML.Attribute.ALIGN, this.alignmentCombo.getSelectedItem());
        } else {
            newAttribs.removeAttribute(HTML.Attribute.ALIGN);
        }
        if (!this.specifyWidthTextField.getText().equals("")) {
            String table_width = this.specifyWidthTextField.getText();
            if (this.widthPercentsRadioBtn.isSelected() && !table_width.endsWith("%")) {
                table_width = table_width + "%";
            }
            newAttribs.addAttribute(HTML.Attribute.WIDTH, table_width);
        } else {
            newAttribs.removeAttribute(HTML.Attribute.WIDTH);
        }
        if (!this.specifyHeightTextField.getText().equals("")) {
            String table_height = this.specifyHeightTextField.getText();
            if (this.heightPercentsRadioBtn.isSelected() && !table_height.endsWith("%")) {
                table_height = table_height + "%";
            }
            newAttribs.addAttribute(HTML.Attribute.HEIGHT, table_height);
        } else {
            newAttribs.removeAttribute(HTML.Attribute.HEIGHT);
        }
        String bgcolor = this.backgroundColorPreviewLabel.getText();
        if (bgcolor.length() == 8) {
            bgcolor = bgcolor.substring(2);
        }
        if (!bgcolor.equals("")) {
            newAttribs.addAttribute(HTML.Attribute.BGCOLOR, bgcolor);
            if (newAttribs.getAttribute(CSS.Attribute.BACKGROUND_COLOR) != null) {
                newAttribs.addAttribute(CSS.Attribute.BACKGROUND_COLOR, bgcolor);
            }
        } else {
            newAttribs.removeAttribute(HTML.Attribute.BGCOLOR);
            newAttribs.removeAttribute(CSS.Attribute.BACKGROUND_COLOR);
            newAttribs.removeAttribute(CSS.Attribute.BACKGROUND);
        }
        if ((bordercolor = this.borderColorPreviewLabel.getText()).length() == 8) {
            bordercolor = bordercolor.substring(2);
        }
        if (bordercolor.startsWith("#")) {
            bordercolor = bordercolor.substring(1);
        }
        if (!this.borderThicknessTextField.getText().equals("") && bordercolor.equals("")) {
            newAttribs.addAttribute(HTML.Attribute.BORDER, this.borderThicknessTextField.getText());
            newAttribs.removeAttribute("border");
        } else {
            newAttribs.removeAttribute(HTML.Attribute.BORDER);
        }
        if (!bordercolor.equals("")) {
            ((HTMLDocument)this.htmlPanel.getInternalJEditorPane().getDocument()).getStyleSheet().addCSSAttribute(newAttribs, CSS.Attribute.BORDER_COLOR, "#" + bordercolor);
            ((HTMLDocument)this.htmlPanel.getInternalJEditorPane().getDocument()).getStyleSheet().addCSSAttribute(newAttribs, CSS.Attribute.BORDER_STYLE, "solid");
            if (!this.borderThicknessTextField.getText().equals("") && !this.borderThicknessTextField.getText().equals("0")) {
                newAttribs.addAttribute(HTML.Attribute.BORDER, "0");
                ((HTMLDocument)this.htmlPanel.getInternalJEditorPane().getDocument()).getStyleSheet().addCSSAttribute(newAttribs, CSS.Attribute.BORDER_WIDTH, this.borderThicknessTextField.getText() + "px");
            } else {
                ((HTMLDocument)this.htmlPanel.getInternalJEditorPane().getDocument()).getStyleSheet().addCSSAttribute(newAttribs, CSS.Attribute.BORDER_WIDTH, "1px");
            }
        } else {
            newAttribs.removeAttribute(CSS.Attribute.BORDER_COLOR);
            newAttribs.removeAttribute(CSS.Attribute.BORDER_WIDTH);
            newAttribs.removeAttribute(CSS.Attribute.BORDER_LEFT_WIDTH);
            newAttribs.removeAttribute(CSS.Attribute.BORDER_RIGHT_WIDTH);
            newAttribs.removeAttribute(CSS.Attribute.BORDER_TOP_WIDTH);
            newAttribs.removeAttribute(CSS.Attribute.BORDER_BOTTOM_WIDTH);
            newAttribs.removeAttribute(CSS.Attribute.BORDER_STYLE);
        }
        if (!this.cellPaddingTextField.getText().equals("")) {
            newAttribs.addAttribute(HTML.Attribute.CELLPADDING, this.cellPaddingTextField.getText());
        } else {
            newAttribs.removeAttribute(HTML.Attribute.CELLPADDING);
        }
        if (!this.cellSpacingTextField.getText().equals("")) {
            newAttribs.addAttribute(HTML.Attribute.CELLSPACING, this.cellSpacingTextField.getText());
        } else {
            newAttribs.removeAttribute(HTML.Attribute.CELLSPACING);
        }
        if (!this.backgroundPictureTextField.getText().equals("") && this.backgroundPictureCheckBox.isSelected()) {
            newAttribs.addAttribute(HTML.Attribute.BACKGROUND, this.backgroundPictureTextField.getText());
        } else {
            newAttribs.removeAttribute(HTML.Attribute.BACKGROUND);
        }
        if (this.styleClassComboBox.getSelectedItem() != null) {
            newAttribs.addAttribute(HTML.Attribute.CLASS, this.styleClassComboBox.getSelectedItem());
        } else {
            newAttribs.removeAttribute(HTML.Attribute.CLASS);
        }
        return newAttribs;
    }

    public void initFileDialog(JFileChooser fileCh) {
        if (fileCh == null) {
            this.browseBackgroundPictureButton.setEnabled(false);
        } else {
            this.browseBackgroundPictureButton.setEnabled(true);
            if (this.htmlPanel.isDisableTableBackgrounds()) {
                this.browseBackgroundPictureButton.setEnabled(false);
            } else {
                this.browseBackgroundPictureButton.setEnabled(true);
            }
        }
        this.fileChooser = fileCh;
    }

    public void initRemoteFileDialog(RemoteFileDialog remoteFD) {
        if (remoteFD == null && this.fileChooser == null) {
            this.browseBackgroundPictureButton.setEnabled(false);
        } else {
            this.browseBackgroundPictureButton.setEnabled(true);
        }
        this.remoteFileDialog = remoteFD;
    }

    public void setHtmlPanel(HTMLEditor html_Panel) {
        this.htmlPanel = html_Panel;
    }
}

