/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import sferyx.administration.editors.ColorChooserDialog;
import sferyx.administration.editors.EditorHTMLDocument;
import sferyx.administration.editors.HTMLEditor;
import sferyx.administration.editors.NumericTextFieldKeyListener;
import sferyx.administration.editors.RemoteFileDialog;
import sferyx.administration.editors.SferyxUtilities;
import sferyx.administration.editors.extensions.BrowsableComponent;
import sferyx.administration.editors.filechooser.CustomFileChooser;

public class TableCellPropertiesDialog
extends JDialog {
    NumericTextFieldKeyListener numericListener = new NumericTextFieldKeyListener();
    boolean automaticBorderColor = false;
    boolean automaticBackgroundColor = false;
    BrowsableComponent imageBrowsable;
    private JTextField borderWidthTextField;
    private JTextField colsSpannedTextField;
    private JComboBox horizontalAlignmentCombo;
    private JButton browseBackgroundPictureButton;
    private JButton borderColorAutomatic;
    private JLabel backgroundColorLabel;
    private JSeparator bordersSeparator;
    private JRadioButton heightPixelsRadioBtn;
    private JSeparator backgroundSeparator;
    private JSeparator layoutSeparator;
    private JLabel backgroundLabel;
    private JButton selectBackgroundColorButton;
    private JTextField specifyHeightTextField;
    private JLabel layoutLabel;
    private JLabel horizontalAlignmentLabel;
    private JLabel widthLabel;
    private JPanel jPanel1;
    private JTextField backgroundPictureTextField;
    private JLabel colsSpannedLabel;
    private JRadioButton widthPercentsRadioBtn;
    private JLabel borderWidthLabel;
    private JComboBox styleClassComboBox;
    private JLabel styleClassLabel;
    private JComboBox verticalAlignmentCombo;
    private JTextField specifyWidthTextField;
    private ButtonGroup widthRadioBtnGroup;
    private JLabel borderColorLabel;
    private JLabel verticalAlignmentLabel;
    private JRadioButton widthPixelsRadioBtn;
    private JButton cancelButton;
    private JButton selectBorderColorButton;
    private JLabel heightLabel;
    private JSeparator jSeparator1;
    private JLabel rowsSpannedLabel;
    private JLabel bordersLabel;
    private JCheckBox backgroundPictureCheckBox;
    private JLabel borderColorPreviewLabel;
    private ButtonGroup heightRadioBtnGroup;
    private JLabel backgroundColorPreviewLabel;
    private JRadioButton heightPercentsRadioBtn;
    private JButton backgroundColorAutomatic;
    private JTextField rowsSpannedTextField;
    private JButton okButton;
    JFileChooser fileChooser;
    AttributeSet attributes;
    boolean cancel = false;
    HTMLEditor htmlPanel;
    RemoteFileDialog remoteFileDialog;

    public TableCellPropertiesDialog(Frame parent, boolean modal) {
        super(parent, true);
        this.initComponents();
        this.backgroundPictureTextField.setBackground(this.getBackground());
        this.selectBorderColorButton.setEnabled(true);
        this.borderColorPreviewLabel.setOpaque(true);
        this.colsSpannedTextField.addKeyListener(this.numericListener);
        this.rowsSpannedTextField.addKeyListener(this.numericListener);
        this.specifyWidthTextField.addKeyListener(this.numericListener);
        this.specifyHeightTextField.addKeyListener(this.numericListener);
    }

    public TableCellPropertiesDialog(Dialog parent, boolean modal) {
        super(parent, true);
        this.initComponents();
        this.backgroundPictureTextField.setBackground(this.getBackground());
        this.selectBorderColorButton.setEnabled(true);
        this.borderColorPreviewLabel.setOpaque(true);
        this.colsSpannedTextField.addKeyListener(this.numericListener);
        this.rowsSpannedTextField.addKeyListener(this.numericListener);
        this.specifyWidthTextField.addKeyListener(this.numericListener);
        this.specifyHeightTextField.addKeyListener(this.numericListener);
    }

    private void initComponents() {
        this.widthRadioBtnGroup = new ButtonGroup();
        this.heightRadioBtnGroup = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.layoutLabel = new JLabel();
        this.layoutSeparator = new JSeparator();
        this.verticalAlignmentLabel = new JLabel();
        this.verticalAlignmentCombo = new JComboBox();
        this.borderColorLabel = new JLabel();
        this.backgroundLabel = new JLabel();
        this.backgroundSeparator = new JSeparator();
        this.specifyWidthTextField = new JTextField();
        this.widthLabel = new JLabel();
        this.heightLabel = new JLabel();
        this.specifyHeightTextField = new JTextField();
        this.widthPixelsRadioBtn = new JRadioButton();
        this.widthPercentsRadioBtn = new JRadioButton();
        this.heightPercentsRadioBtn = new JRadioButton();
        this.heightPixelsRadioBtn = new JRadioButton();
        this.backgroundPictureCheckBox = new JCheckBox();
        this.rowsSpannedTextField = new JTextField();
        this.rowsSpannedLabel = new JLabel();
        this.colsSpannedTextField = new JTextField();
        this.colsSpannedLabel = new JLabel();
        this.bordersSeparator = new JSeparator();
        this.bordersLabel = new JLabel();
        this.selectBorderColorButton = new JButton();
        this.borderColorPreviewLabel = new JLabel();
        this.backgroundPictureTextField = new JTextField();
        this.browseBackgroundPictureButton = new JButton();
        this.backgroundColorLabel = new JLabel();
        this.backgroundColorPreviewLabel = new JLabel();
        this.selectBackgroundColorButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.horizontalAlignmentLabel = new JLabel();
        this.horizontalAlignmentCombo = new JComboBox();
        this.backgroundColorAutomatic = new JButton();
        this.styleClassLabel = new JLabel();
        this.styleClassComboBox = new JComboBox();
        this.borderColorAutomatic = new JButton();
        this.borderWidthTextField = new JTextField();
        this.borderWidthLabel = new JLabel();
        this.setTitle("Table Cell Properties");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                TableCellPropertiesDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(null);
        this.layoutLabel.setHorizontalAlignment(4);
        this.layoutLabel.setText("Layout");
        this.jPanel1.add(this.layoutLabel);
        this.layoutLabel.setBounds(10, 10, 120, 16);
        this.jPanel1.add(this.layoutSeparator);
        this.layoutSeparator.setBounds(140, 18, 320, 2);
        this.verticalAlignmentLabel.setHorizontalAlignment(4);
        this.verticalAlignmentLabel.setText("Vertical alignment:");
        this.jPanel1.add(this.verticalAlignmentLabel);
        this.verticalAlignmentLabel.setBounds(10, 70, 160, 16);
        this.verticalAlignmentCombo.setEditable(true);
        this.verticalAlignmentCombo.setFont(new Font("Dialog", 0, 11));
        this.verticalAlignmentCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"default", "top", "middle", "baseline", "bottom"}));
        this.jPanel1.add(this.verticalAlignmentCombo);
        this.verticalAlignmentCombo.setBounds(180, 70, 100, 20);
        this.borderColorLabel.setHorizontalAlignment(4);
        this.borderColorLabel.setText("Color:");
        this.jPanel1.add(this.borderColorLabel);
        this.borderColorLabel.setBounds(50, 190, 90, 16);
        this.backgroundLabel.setHorizontalAlignment(4);
        this.backgroundLabel.setText("Background");
        this.jPanel1.add(this.backgroundLabel);
        this.backgroundLabel.setBounds(10, 250, 110, 16);
        this.jPanel1.add(this.backgroundSeparator);
        this.backgroundSeparator.setBounds(130, 260, 340, 2);
        this.specifyWidthTextField.setFont(new Font("Dialog", 0, 11));
        this.jPanel1.add(this.specifyWidthTextField);
        this.specifyWidthTextField.setBounds(290, 50, 60, 19);
        this.widthLabel.setText("Width:");
        this.jPanel1.add(this.widthLabel);
        this.widthLabel.setBounds(290, 30, 70, 16);
        this.heightLabel.setText("Height:");
        this.jPanel1.add(this.heightLabel);
        this.heightLabel.setBounds(290, 80, 70, 16);
        this.specifyHeightTextField.setFont(new Font("Dialog", 0, 11));
        this.jPanel1.add(this.specifyHeightTextField);
        this.specifyHeightTextField.setBounds(290, 100, 60, 19);
        this.widthPixelsRadioBtn.setSelected(true);
        this.widthPixelsRadioBtn.setText("In pixels");
        this.widthRadioBtnGroup.add(this.widthPixelsRadioBtn);
        this.jPanel1.add(this.widthPixelsRadioBtn);
        this.widthPixelsRadioBtn.setBounds(360, 30, 130, 24);
        this.widthPercentsRadioBtn.setText("In percents");
        this.widthRadioBtnGroup.add(this.widthPercentsRadioBtn);
        this.jPanel1.add(this.widthPercentsRadioBtn);
        this.widthPercentsRadioBtn.setBounds(360, 50, 130, 24);
        this.heightPercentsRadioBtn.setText("In percents");
        this.heightRadioBtnGroup.add(this.heightPercentsRadioBtn);
        this.jPanel1.add(this.heightPercentsRadioBtn);
        this.heightPercentsRadioBtn.setBounds(360, 100, 130, 24);
        this.heightPixelsRadioBtn.setSelected(true);
        this.heightPixelsRadioBtn.setText("In pixels");
        this.heightRadioBtnGroup.add(this.heightPixelsRadioBtn);
        this.jPanel1.add(this.heightPixelsRadioBtn);
        this.heightPixelsRadioBtn.setBounds(360, 80, 130, 24);
        this.backgroundPictureCheckBox.setText("Use background picture");
        this.backgroundPictureCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                TableCellPropertiesDialog.this.backgroundPictureCheckBoxStateChanged(evt);
            }
        });
        this.jPanel1.add(this.backgroundPictureCheckBox);
        this.backgroundPictureCheckBox.setBounds(10, 310, 300, 24);
        this.rowsSpannedTextField.setFont(new Font("Dialog", 0, 11));
        this.jPanel1.add(this.rowsSpannedTextField);
        this.rowsSpannedTextField.setBounds(180, 100, 70, 19);
        this.rowsSpannedLabel.setHorizontalAlignment(4);
        this.rowsSpannedLabel.setText("Rows spanned::");
        this.jPanel1.add(this.rowsSpannedLabel);
        this.rowsSpannedLabel.setBounds(10, 100, 160, 16);
        this.colsSpannedTextField.setFont(new Font("Dialog", 0, 11));
        this.jPanel1.add(this.colsSpannedTextField);
        this.colsSpannedTextField.setBounds(180, 130, 70, 19);
        this.colsSpannedLabel.setHorizontalAlignment(4);
        this.colsSpannedLabel.setText("Cols spanned:");
        this.jPanel1.add(this.colsSpannedLabel);
        this.colsSpannedLabel.setBounds(10, 130, 160, 16);
        this.jPanel1.add(this.bordersSeparator);
        this.bordersSeparator.setBounds(130, 170, 340, 2);
        this.bordersLabel.setHorizontalAlignment(4);
        this.bordersLabel.setText("Borders");
        this.jPanel1.add(this.bordersLabel);
        this.bordersLabel.setBounds(10, 160, 110, 16);
        this.selectBorderColorButton.setText("Select..");
        this.selectBorderColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableCellPropertiesDialog.this.selectBorderColorButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.selectBorderColorButton);
        this.selectBorderColorButton.setBounds(230, 190, 110, 26);
        this.borderColorPreviewLabel.setHorizontalAlignment(0);
        this.jPanel1.add(this.borderColorPreviewLabel);
        this.borderColorPreviewLabel.setBounds(150, 190, 50, 20);
        this.backgroundPictureTextField.setFont(new Font("Dialog", 0, 11));
        this.backgroundPictureTextField.setEnabled(false);
        this.jPanel1.add(this.backgroundPictureTextField);
        this.backgroundPictureTextField.setBounds(10, 340, 280, 19);
        this.browseBackgroundPictureButton.setText("Browse..");
        this.browseBackgroundPictureButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableCellPropertiesDialog.this.browseBackgroundPictureButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.browseBackgroundPictureButton);
        this.browseBackgroundPictureButton.setBounds(300, 340, 120, 26);
        this.backgroundColorLabel.setText("Color:");
        this.jPanel1.add(this.backgroundColorLabel);
        this.backgroundColorLabel.setBounds(10, 280, 120, 16);
        this.backgroundColorPreviewLabel.setHorizontalAlignment(0);
        this.backgroundColorPreviewLabel.setOpaque(true);
        this.jPanel1.add(this.backgroundColorPreviewLabel);
        this.backgroundColorPreviewLabel.setBounds(150, 280, 70, 20);
        this.selectBackgroundColorButton.setText("Select..");
        this.selectBackgroundColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableCellPropertiesDialog.this.selectBackgroundColorButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.selectBackgroundColorButton);
        this.selectBackgroundColorButton.setBounds(230, 280, 110, 26);
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableCellPropertiesDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.okButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                TableCellPropertiesDialog.this.okButtonMousePressed(evt);
            }
        });
        this.jPanel1.add(this.okButton);
        this.okButton.setBounds(230, 430, 110, 26);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableCellPropertiesDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelButton);
        this.cancelButton.setBounds(350, 430, 120, 26);
        this.jPanel1.add(this.jSeparator1);
        this.jSeparator1.setBounds(10, 420, 460, 2);
        this.horizontalAlignmentLabel.setHorizontalAlignment(4);
        this.horizontalAlignmentLabel.setText("Horizontal alignment:");
        this.jPanel1.add(this.horizontalAlignmentLabel);
        this.horizontalAlignmentLabel.setBounds(10, 40, 160, 16);
        this.horizontalAlignmentCombo.setEditable(true);
        this.horizontalAlignmentCombo.setFont(new Font("Dialog", 0, 11));
        this.horizontalAlignmentCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"default", "left", "right", "center", "justify"}));
        this.jPanel1.add(this.horizontalAlignmentCombo);
        this.horizontalAlignmentCombo.setBounds(180, 40, 100, 20);
        this.backgroundColorAutomatic.setLabel("Automatic");
        this.backgroundColorAutomatic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableCellPropertiesDialog.this.backgroundColorAutomaticActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.backgroundColorAutomatic);
        this.backgroundColorAutomatic.setBounds(350, 280, 120, 26);
        this.styleClassLabel.setHorizontalAlignment(4);
        this.styleClassLabel.setText("Style:");
        this.jPanel1.add(this.styleClassLabel);
        this.styleClassLabel.setBounds(10, 380, 90, 16);
        this.styleClassComboBox.setEditable(true);
        this.styleClassComboBox.setVerifyInputWhenFocusTarget(false);
        this.styleClassComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableCellPropertiesDialog.this.styleClassComboBoxActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.styleClassComboBox);
        this.styleClassComboBox.setBounds(110, 380, 200, 20);
        this.borderColorAutomatic.setLabel("Automatic");
        this.borderColorAutomatic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableCellPropertiesDialog.this.borderColorAutomaticActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.borderColorAutomatic);
        this.borderColorAutomatic.setBounds(350, 190, 120, 26);
        this.jPanel1.add(this.borderWidthTextField);
        this.borderWidthTextField.setBounds(150, 220, 30, 20);
        this.borderWidthLabel.setHorizontalAlignment(4);
        this.borderWidthLabel.setText("Border width:");
        this.jPanel1.add(this.borderWidthLabel);
        this.borderWidthLabel.setBounds(20, 220, 120, 16);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void styleClassComboBoxActionPerformed(ActionEvent evt) {
    }

    private void borderColorAutomaticActionPerformed(ActionEvent evt) {
        this.automaticBorderColor = true;
        this.borderColorPreviewLabel.setText("");
        this.borderColorPreviewLabel.setOpaque(false);
        this.borderWidthTextField.setText("");
    }

    private void okButtonMousePressed(MouseEvent evt) {
        this.okButton.requestFocus();
    }

    private void backgroundColorAutomaticActionPerformed(ActionEvent evt) {
        this.automaticBackgroundColor = true;
        this.backgroundColorPreviewLabel.setText("");
        this.backgroundColorPreviewLabel.setBackground(this.getBackground());
    }

    public void setCustomImageBrowsable(BrowsableComponent browsable) {
        this.imageBrowsable = browsable;
        this.browseBackgroundPictureButton.setEnabled(true);
    }

    private void browseBackgroundPictureButtonActionPerformed(ActionEvent evt) {
        if (this.imageBrowsable != null) {
            this.imageBrowsable.show();
            if (this.imageBrowsable.isActionCancelled()) {
                return;
            }
            try {
                this.backgroundPictureTextField.setText(this.imageBrowsable.getResultingURL());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        if (this.fileChooser != null) {
            int returnVal;
            this.fileChooser.setDialogType(0);
            if (this.fileChooser instanceof CustomFileChooser) {
                ((CustomFileChooser)this.fileChooser).setImageFilter();
            }
            if ((returnVal = this.fileChooser.showOpenDialog(this)) == 0) {
                try {
                    this.backgroundPictureTextField.setText(this.htmlPanel.getRelativePath(this.fileChooser.getSelectedFile().toURL().toString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!this.backgroundPictureCheckBox.isSelected()) {
                    this.backgroundPictureCheckBox.doClick();
                }
            }
        } else if (this.remoteFileDialog != null) {
            try {
                this.remoteFileDialog.setVisible(true);
                String imageURL = this.remoteFileDialog.getSelectedFile();
                if (imageURL != null) {
                    this.backgroundPictureTextField.setText(this.htmlPanel.getRelativePath(imageURL));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void backgroundPictureCheckBoxStateChanged(ChangeEvent evt) {
        if (this.backgroundPictureCheckBox.isSelected()) {
            this.backgroundPictureTextField.setEnabled(true);
            this.backgroundPictureTextField.setBackground(Color.white);
        } else {
            this.backgroundPictureTextField.setEnabled(false);
            this.backgroundPictureTextField.setBackground(this.getBackground());
        }
    }

    private void selectBackgroundColorButtonActionPerformed(ActionEvent evt) {
        Color newColor;
        if (this.htmlPanel.colorChooserDialog == null) {
            this.htmlPanel.colorChooserDialog = SwingUtilities.windowForComponent(this) instanceof Frame ? new ColorChooserDialog((Frame)SwingUtilities.windowForComponent(this), true, this.htmlPanel.getTranslatedString("Choose Foreground Color")) : new ColorChooserDialog((Dialog)SwingUtilities.windowForComponent(this), true, this.htmlPanel.getTranslatedString("Choose Foreground Color"));
        }
        this.htmlPanel.colorChooserDialog.setTitle(this.htmlPanel.getTranslatedString("Choose Background Color"));
        if (this.backgroundColorPreviewLabel.isOpaque()) {
            this.htmlPanel.colorChooserDialog.setSelectedColor(this.backgroundColorPreviewLabel.getBackground());
        } else {
            this.htmlPanel.colorChooserDialog.setSelectedColor(null);
        }
        this.htmlPanel.translateContainer(this.htmlPanel.colorChooserDialog);
        this.htmlPanel.colorChooserDialog.setVisible(true);
        int result = this.htmlPanel.colorChooserDialog.getActionResult();
        ColorChooserDialog cfr_ignored_0 = this.htmlPanel.colorChooserDialog;
        if (result == ColorChooserDialog.OK_BUTTON && (newColor = this.htmlPanel.colorChooserDialog.getSelectedColor()) != null) {
            this.backgroundColorPreviewLabel.setBackground(newColor);
            this.backgroundColorPreviewLabel.setOpaque(true);
            this.backgroundColorPreviewLabel.setText(this.htmlPanel.colorToString(newColor));
        }
    }

    private void selectBorderColorButtonActionPerformed(ActionEvent evt) {
        if (this.htmlPanel.colorChooserDialog == null) {
            this.htmlPanel.colorChooserDialog = SwingUtilities.windowForComponent(this) instanceof Frame ? new ColorChooserDialog((Frame)SwingUtilities.windowForComponent(this), true, this.htmlPanel.getTranslatedString("Choose Foreground Color")) : new ColorChooserDialog((Dialog)SwingUtilities.windowForComponent(this), true, this.htmlPanel.getTranslatedString("Choose Foreground Color"));
        }
        this.htmlPanel.colorChooserDialog.setTitle(this.htmlPanel.getTranslatedString("Choose Border Color"));
        if (this.borderColorPreviewLabel.isOpaque()) {
            this.htmlPanel.colorChooserDialog.setSelectedColor(this.borderColorPreviewLabel.getBackground());
        } else {
            this.htmlPanel.colorChooserDialog.setSelectedColor(null);
        }
        this.htmlPanel.translateContainer(this.htmlPanel.colorChooserDialog);
        this.htmlPanel.colorChooserDialog.setVisible(true);
        int result = this.htmlPanel.colorChooserDialog.getActionResult();
        ColorChooserDialog cfr_ignored_0 = this.htmlPanel.colorChooserDialog;
        if (result == ColorChooserDialog.OK_BUTTON) {
            Color newColor = this.htmlPanel.colorChooserDialog.getSelectedColor();
            if (newColor == null) {
                return;
            }
            this.borderColorPreviewLabel.setBackground(newColor);
            this.borderColorPreviewLabel.setOpaque(true);
            this.borderColorPreviewLabel.setText(this.htmlPanel.colorToString(newColor));
            if (this.borderWidthTextField.getText().trim().equals("")) {
                this.borderWidthTextField.setText("1");
            }
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.cancel = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.cancel = false;
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.cancel = true;
        this.setVisible(false);
        this.dispose();
    }

    public void setVisible(boolean b) {
        if (b) {
            this.setSize(490, 500);
            this.setLocation((int)((double)this.getParent().getLocationOnScreen().x + this.getParent().getBounds().getWidth() / 2.0 - this.getBounds().getWidth() / 2.0), (int)((double)this.getParent().getLocationOnScreen().y + this.getParent().getBounds().getHeight() / 2.0 - this.getBounds().getHeight() / 2.0));
        }
        super.setVisible(b);
    }

    public void initDialogFields(AttributeSet attribs) {
        block47: {
            String bgColor;
            this.automaticBackgroundColor = false;
            this.automaticBorderColor = false;
            this.attributes = attribs;
            String backgroundPic = (String)attribs.getAttribute(HTML.Attribute.BACKGROUND);
            if (backgroundPic != null && this.attributes.containsAttribute(HTML.Attribute.BACKGROUND, backgroundPic)) {
                this.backgroundPictureTextField.setText(backgroundPic);
                if (!this.backgroundPictureCheckBox.isSelected()) {
                    this.backgroundPictureCheckBox.doClick();
                }
            } else {
                this.backgroundPictureTextField.setText("");
                if (this.backgroundPictureCheckBox.isSelected()) {
                    this.backgroundPictureCheckBox.doClick();
                }
            }
            if ((bgColor = (String)attribs.getAttribute(HTML.Attribute.BGCOLOR)) != null && this.attributes.containsAttribute(HTML.Attribute.BGCOLOR, bgColor)) {
                try {
                    this.backgroundColorPreviewLabel.setText(bgColor);
                    this.backgroundColorPreviewLabel.setBackground(this.htmlPanel.convertStringToColor(bgColor));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (bgColor == null && this.attributes.getAttribute(CSS.Attribute.BACKGROUND_COLOR) != null && this.attributes.containsAttribute(CSS.Attribute.BACKGROUND_COLOR, this.attributes.getAttribute(CSS.Attribute.BACKGROUND_COLOR))) {
                try {
                    bgColor = this.attributes.getAttribute(CSS.Attribute.BACKGROUND_COLOR).toString();
                    this.backgroundColorPreviewLabel.setText(bgColor);
                    this.backgroundColorPreviewLabel.setBackground(this.htmlPanel.convertStringToColor(bgColor));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.backgroundColorPreviewLabel.setText("");
                this.backgroundColorPreviewLabel.setBackground(this.getBackground());
            }
            Color borderColor = SferyxUtilities.getBorderColor(((EditorHTMLDocument)this.htmlPanel.getInternalJEditorPane().getDocument()).getTableCellElement(this.htmlPanel.getInternalJEditorPane().getCaretPosition()), attribs);
            if (borderColor != null) {
                try {
                    if (borderColor instanceof Color) {
                        this.borderColorPreviewLabel.setText("#" + borderColor.getRed() + "" + borderColor.getRed() + "" + borderColor.getGreen() + "" + borderColor.getGreen() + "" + borderColor.getBlue() + "" + borderColor.getBlue());
                        this.borderColorPreviewLabel.setBackground(borderColor);
                        this.borderColorPreviewLabel.setOpaque(true);
                        break block47;
                    }
                    this.borderColorPreviewLabel.setText(((Object)borderColor).toString());
                    this.borderColorPreviewLabel.setBackground(this.htmlPanel.convertStringToColor(((Object)borderColor).toString()));
                    this.borderColorPreviewLabel.setOpaque(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.borderColorPreviewLabel.setText("");
                this.borderColorPreviewLabel.setOpaque(false);
            }
        }
        String align = (String)attribs.getAttribute(HTML.Attribute.ALIGN);
        if (align != null && this.attributes.containsAttribute(HTML.Attribute.ALIGN, align)) {
            this.horizontalAlignmentCombo.setSelectedItem(align.toLowerCase());
        } else {
            this.horizontalAlignmentCombo.setSelectedItem("default");
        }
        String valign = (String)attribs.getAttribute(HTML.Attribute.VALIGN);
        if (valign != null && this.attributes.containsAttribute(HTML.Attribute.VALIGN, valign)) {
            this.verticalAlignmentCombo.setSelectedItem(valign.toLowerCase());
        } else {
            this.verticalAlignmentCombo.setSelectedItem("default");
        }
        String width = (String)attribs.getAttribute(HTML.Attribute.WIDTH);
        if (width != null && !width.equals("") && this.attributes.containsAttribute(HTML.Attribute.WIDTH, width)) {
            this.specifyWidthTextField.setText(width);
            if (width.endsWith("%")) {
                this.widthPercentsRadioBtn.setSelected(true);
            } else {
                this.widthPixelsRadioBtn.setSelected(true);
            }
        } else {
            this.specifyWidthTextField.setText("");
            this.widthPixelsRadioBtn.setSelected(true);
        }
        String height = (String)attribs.getAttribute(HTML.Attribute.HEIGHT);
        if (height != null && !height.equals("") && this.attributes.containsAttribute(HTML.Attribute.HEIGHT, height)) {
            this.specifyHeightTextField.setText(height);
            if (height.endsWith("%")) {
                this.heightPercentsRadioBtn.setSelected(true);
            } else {
                this.heightPixelsRadioBtn.setSelected(true);
            }
        } else {
            this.specifyHeightTextField.setText("");
            this.heightPixelsRadioBtn.setSelected(true);
        }
        String cellspace = (String)attribs.getAttribute(HTML.Attribute.ROWSPAN);
        if (cellspace != null && this.attributes.containsAttribute(HTML.Attribute.ROWSPAN, cellspace)) {
            this.rowsSpannedTextField.setText(cellspace);
        } else {
            this.rowsSpannedTextField.setText("");
        }
        String cellpad = (String)attribs.getAttribute(HTML.Attribute.COLSPAN);
        if (cellpad != null && this.attributes.containsAttribute(HTML.Attribute.COLSPAN, cellpad)) {
            this.colsSpannedTextField.setText(cellpad);
        } else {
            this.colsSpannedTextField.setText("");
        }
        this.styleClassComboBox.setModel(new DefaultComboBoxModel(this.htmlPanel.getStyleClasses()));
        String styleClass = (String)attribs.getAttribute(HTML.Attribute.CLASS);
        if (styleClass != null && this.attributes.containsAttribute(HTML.Attribute.CLASS, styleClass)) {
            this.styleClassComboBox.setSelectedItem(styleClass);
        } else {
            this.styleClassComboBox.setSelectedIndex(-1);
        }
        this.styleClassComboBox.setRenderer(this.htmlPanel.getStyleClassRendererInstance());
        if (this.attributes.getAttribute(CSS.Attribute.BORDER_BOTTOM_WIDTH) != null && this.attributes.getAttribute(CSS.Attribute.BORDER_TOP_WIDTH) != null && this.attributes.getAttribute(CSS.Attribute.BORDER_LEFT_WIDTH) != null && this.attributes.getAttribute(CSS.Attribute.BORDER_RIGHT_WIDTH) != null) {
            if (this.attributes.containsAttribute(CSS.Attribute.BORDER_BOTTOM_WIDTH, this.attributes.getAttribute(CSS.Attribute.BORDER_BOTTOM_WIDTH))) {
                this.borderWidthTextField.setText((int)SferyxUtilities.getNumberFromCSString(this.attributes.getAttribute(CSS.Attribute.BORDER_BOTTOM_WIDTH).toString()) + "");
            } else {
                this.borderWidthTextField.setText("");
            }
        } else if (this.attributes.getAttribute(CSS.Attribute.BORDER_WIDTH) != null) {
            if (this.attributes.containsAttribute(CSS.Attribute.BORDER_WIDTH, this.attributes.getAttribute(CSS.Attribute.BORDER_WIDTH))) {
                this.borderWidthTextField.setText((int)SferyxUtilities.getNumberFromCSString(this.attributes.getAttribute(CSS.Attribute.BORDER_WIDTH).toString()) + "");
            } else {
                this.borderWidthTextField.setText("");
            }
        } else if (SferyxUtilities.getBorderThiknessValue(attribs, CSS.Attribute.BORDER, ((EditorHTMLDocument)this.htmlPanel.getInternalJEditorPane().getDocument()).getTableCellElement(this.htmlPanel.getInternalJEditorPane().getCaretPosition())) > 0) {
            this.borderWidthTextField.setText(SferyxUtilities.getBorderThiknessValue(attribs, CSS.Attribute.BORDER, ((EditorHTMLDocument)this.htmlPanel.getInternalJEditorPane().getDocument()).getTableCellElement(this.htmlPanel.getInternalJEditorPane().getCaretPosition())) + "");
        } else {
            this.borderWidthTextField.setText("");
        }
        this.okButton.requestFocus();
        if (this.htmlPanel.isDisableTableBackgrounds()) {
            this.backgroundPictureCheckBox.setEnabled(false);
            this.browseBackgroundPictureButton.setEnabled(false);
        } else {
            this.backgroundPictureCheckBox.setEnabled(true);
            this.browseBackgroundPictureButton.setEnabled(true);
        }
    }

    public AttributeSet getNewAttributes() {
        String bordercolor;
        if (this.cancel) {
            return null;
        }
        SimpleAttributeSet newAttribs = new SimpleAttributeSet(this.attributes);
        if (!this.horizontalAlignmentCombo.getSelectedItem().equals("default")) {
            newAttribs.addAttribute(HTML.Attribute.ALIGN, this.horizontalAlignmentCombo.getSelectedItem());
        } else {
            newAttribs.removeAttribute(HTML.Attribute.ALIGN);
        }
        if (!this.verticalAlignmentCombo.getSelectedItem().equals("default")) {
            newAttribs.addAttribute(HTML.Attribute.VALIGN, this.verticalAlignmentCombo.getSelectedItem());
        } else {
            newAttribs.removeAttribute(HTML.Attribute.VALIGN);
        }
        if (!this.specifyWidthTextField.getText().equals("")) {
            String table_width = this.specifyWidthTextField.getText();
            if (this.widthPercentsRadioBtn.isSelected() && !table_width.endsWith("%")) {
                table_width = table_width + "%";
            }
            newAttribs.addAttribute(HTML.Attribute.WIDTH, table_width);
        } else {
            newAttribs.removeAttribute(HTML.Attribute.WIDTH);
        }
        if (!this.specifyHeightTextField.getText().equals("")) {
            String table_height = this.specifyHeightTextField.getText();
            if (this.heightPercentsRadioBtn.isSelected() && !table_height.endsWith("%")) {
                table_height = table_height + "%";
            }
            newAttribs.addAttribute(HTML.Attribute.HEIGHT, table_height);
        } else {
            newAttribs.removeAttribute(HTML.Attribute.HEIGHT);
        }
        String bgcolor = this.backgroundColorPreviewLabel.getText();
        if (bgcolor.length() == 8) {
            bgcolor = bgcolor.substring(2);
        }
        if (!bgcolor.equals("")) {
            newAttribs.addAttribute(HTML.Attribute.BGCOLOR, bgcolor);
            if (newAttribs.getAttribute(CSS.Attribute.BACKGROUND_COLOR) != null) {
                newAttribs.addAttribute(CSS.Attribute.BACKGROUND_COLOR, bgcolor);
            }
        } else {
            newAttribs.removeAttribute(HTML.Attribute.BGCOLOR);
            newAttribs.removeAttribute(CSS.Attribute.BACKGROUND_COLOR);
            newAttribs.removeAttribute(CSS.Attribute.BACKGROUND);
        }
        if ((bordercolor = this.borderColorPreviewLabel.getText()).length() == 8) {
            bordercolor = bordercolor.substring(2);
        }
        if (bordercolor.startsWith("#")) {
            bordercolor = bordercolor.substring(1);
        }
        int borderWidth = (int)SferyxUtilities.getNumberFromCSString(this.borderWidthTextField.getText());
        if (!bordercolor.equals("")) {
            newAttribs.removeAttribute(CSS.Attribute.BORDER_WIDTH);
            newAttribs.removeAttribute(CSS.Attribute.BORDER_LEFT_WIDTH);
            newAttribs.removeAttribute(CSS.Attribute.BORDER_RIGHT_WIDTH);
            newAttribs.removeAttribute(CSS.Attribute.BORDER_TOP_WIDTH);
            newAttribs.removeAttribute(CSS.Attribute.BORDER_BOTTOM_WIDTH);
            newAttribs.removeAttribute(CSS.Attribute.BORDER_STYLE);
            newAttribs.removeAttribute(CSS.Attribute.BORDER);
            newAttribs.removeAttribute(CSS.Attribute.BORDER_TOP);
            newAttribs.removeAttribute(CSS.Attribute.BORDER_BOTTOM);
            newAttribs.removeAttribute(CSS.Attribute.BORDER_LEFT);
            newAttribs.removeAttribute(CSS.Attribute.BORDER_RIGHT);
            ((HTMLDocument)this.htmlPanel.getInternalJEditorPane().getDocument()).getStyleSheet().addCSSAttribute(newAttribs, CSS.Attribute.BORDER_COLOR, "#" + bordercolor);
            ((HTMLDocument)this.htmlPanel.getInternalJEditorPane().getDocument()).getStyleSheet().addCSSAttribute(newAttribs, CSS.Attribute.BORDER_STYLE, "solid");
            if (borderWidth >= 0) {
                ((HTMLDocument)this.htmlPanel.getInternalJEditorPane().getDocument()).getStyleSheet().addCSSAttribute(newAttribs, CSS.Attribute.BORDER_WIDTH, borderWidth + "");
            } else if (borderWidth < 0) {
                newAttribs.removeAttribute(CSS.Attribute.BORDER_WIDTH);
                newAttribs.removeAttribute(CSS.Attribute.BORDER_LEFT_WIDTH);
                newAttribs.removeAttribute(CSS.Attribute.BORDER_RIGHT_WIDTH);
                newAttribs.removeAttribute(CSS.Attribute.BORDER_TOP_WIDTH);
                newAttribs.removeAttribute(CSS.Attribute.BORDER_BOTTOM_WIDTH);
                newAttribs.removeAttribute(CSS.Attribute.BORDER_STYLE);
                newAttribs.removeAttribute(CSS.Attribute.BORDER);
            }
        } else {
            newAttribs.removeAttribute(CSS.Attribute.BORDER_COLOR);
            if (borderWidth >= 0) {
                newAttribs.removeAttribute(CSS.Attribute.BORDER_WIDTH);
                newAttribs.removeAttribute(CSS.Attribute.BORDER_LEFT_WIDTH);
                newAttribs.removeAttribute(CSS.Attribute.BORDER_RIGHT_WIDTH);
                newAttribs.removeAttribute(CSS.Attribute.BORDER_TOP_WIDTH);
                newAttribs.removeAttribute(CSS.Attribute.BORDER_BOTTOM_WIDTH);
                newAttribs.removeAttribute(CSS.Attribute.BORDER_STYLE);
                newAttribs.removeAttribute(CSS.Attribute.BORDER);
                newAttribs.removeAttribute(CSS.Attribute.BORDER_TOP);
                newAttribs.removeAttribute(CSS.Attribute.BORDER_BOTTOM);
                newAttribs.removeAttribute(CSS.Attribute.BORDER_LEFT);
                newAttribs.removeAttribute(CSS.Attribute.BORDER_RIGHT);
                ((HTMLDocument)this.htmlPanel.getInternalJEditorPane().getDocument()).getStyleSheet().addCSSAttribute(newAttribs, CSS.Attribute.BORDER_WIDTH, borderWidth + "");
            } else if (borderWidth < 0) {
                newAttribs.removeAttribute(CSS.Attribute.BORDER_WIDTH);
                newAttribs.removeAttribute(CSS.Attribute.BORDER_LEFT_WIDTH);
                newAttribs.removeAttribute(CSS.Attribute.BORDER_RIGHT_WIDTH);
                newAttribs.removeAttribute(CSS.Attribute.BORDER_TOP_WIDTH);
                newAttribs.removeAttribute(CSS.Attribute.BORDER_BOTTOM_WIDTH);
                newAttribs.removeAttribute(CSS.Attribute.BORDER_STYLE);
                newAttribs.removeAttribute(CSS.Attribute.BORDER);
            }
        }
        if (!this.colsSpannedTextField.getText().equals("")) {
            newAttribs.addAttribute(HTML.Attribute.COLSPAN, this.colsSpannedTextField.getText());
        } else {
            newAttribs.removeAttribute(HTML.Attribute.COLSPAN);
        }
        if (!this.rowsSpannedTextField.getText().equals("")) {
            newAttribs.addAttribute(HTML.Attribute.ROWSPAN, this.rowsSpannedTextField.getText());
        } else {
            newAttribs.removeAttribute(HTML.Attribute.ROWSPAN);
        }
        if (!this.backgroundPictureTextField.getText().equals("") && this.backgroundPictureCheckBox.isSelected()) {
            newAttribs.addAttribute(HTML.Attribute.BACKGROUND, this.backgroundPictureTextField.getText());
        } else {
            newAttribs.removeAttribute(HTML.Attribute.BACKGROUND);
        }
        if (this.styleClassComboBox.getSelectedItem() != null && !((String)this.styleClassComboBox.getSelectedItem()).trim().equals("")) {
            newAttribs.addAttribute(HTML.Attribute.CLASS, this.styleClassComboBox.getSelectedItem());
        } else {
            newAttribs.removeAttribute(HTML.Attribute.CLASS);
        }
        return newAttribs;
    }

    public void initFileDialog(JFileChooser fileCh) {
        if (fileCh == null) {
            this.browseBackgroundPictureButton.setEnabled(false);
        } else {
            this.browseBackgroundPictureButton.setEnabled(true);
            if (this.htmlPanel.isDisableTableBackgrounds()) {
                this.browseBackgroundPictureButton.setEnabled(false);
            } else {
                this.browseBackgroundPictureButton.setEnabled(false);
            }
        }
        this.fileChooser = fileCh;
    }

    public void initRemoteFileDialog(RemoteFileDialog remoteFD) {
        if (remoteFD == null && this.fileChooser == null) {
            this.browseBackgroundPictureButton.setEnabled(false);
        } else {
            this.browseBackgroundPictureButton.setEnabled(true);
        }
        this.remoteFileDialog = remoteFD;
    }

    public void setHtmlPanel(HTMLEditor html_Panel) {
        this.htmlPanel = html_Panel;
    }
}

