/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Color;
import java.util.StringTokenizer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class SourceEditorDocument
extends DefaultStyledDocument {
    static MutableAttributeSet tagAttribs;
    static MutableAttributeSet valueAttribs;
    static MutableAttributeSet defaultAttr;
    static MutableAttributeSet scriptAttribs;
    static MutableAttributeSet commentAttr;
    boolean isTag = false;
    boolean isValue = false;
    boolean inscript = false;

    public SourceEditorDocument() {
        tagAttribs = new SimpleAttributeSet();
        StyleConstants.setForeground(tagAttribs, Color.blue);
        StyleConstants.setFontSize(tagAttribs, 13);
        defaultAttr = new SimpleAttributeSet();
        StyleConstants.setForeground(defaultAttr, Color.black);
        StyleConstants.setFontSize(defaultAttr, 11);
        valueAttribs = new SimpleAttributeSet();
        StyleConstants.setForeground(valueAttribs, Color.green.darker());
        StyleConstants.setFontSize(valueAttribs, 13);
        scriptAttribs = new SimpleAttributeSet();
        StyleConstants.setForeground(scriptAttribs, Color.red.darker());
        StyleConstants.setItalic(scriptAttribs, true);
        StyleConstants.setFontSize(scriptAttribs, 13);
    }

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(str, "<>\"", true);
        int strigLength = 0;
        int tagStringCount = 0;
        String lastTag = "";
        boolean lastWasScriptTag = false;
        while (st.hasMoreTokens()) {
            String currString = st.nextToken();
            currString = lastTag + currString;
            if (currString.equals("<") && st.hasMoreTokens()) {
                this.isTag = true;
                ++tagStringCount;
                lastTag = currString;
                continue;
            }
            lastTag = "";
            if (currString.equals("\"") && !this.inscript) {
                boolean bl = this.isValue = !this.isValue;
                if (!this.isValue) {
                    super.insertString(offs + strigLength, currString, valueAttribs);
                    strigLength += currString.length();
                    continue;
                }
            }
            if (currString.startsWith("<script") || currString.startsWith("<SCRIPT")) {
                this.inscript = true;
            } else if (currString.startsWith("</script") || currString.startsWith("</SCRIPT")) {
                this.inscript = false;
                super.insertString(offs + strigLength, currString, scriptAttribs);
                strigLength += currString.length();
                lastWasScriptTag = true;
                continue;
            }
            if (this.inscript) {
                super.insertString(offs + strigLength, currString, scriptAttribs);
            } else if (this.isTag && !this.isValue) {
                if (currString.equals(">")) {
                    this.isTag = false;
                    tagStringCount = 0;
                    if (lastWasScriptTag) {
                        super.insertString(offs + strigLength, currString, scriptAttribs);
                        strigLength += currString.length();
                        lastWasScriptTag = false;
                        continue;
                    }
                }
                if (this.inscript) {
                    super.insertString(offs + strigLength, currString, scriptAttribs);
                } else {
                    super.insertString(offs + strigLength, currString, tagAttribs);
                }
            } else if (this.isTag && this.isValue) {
                super.insertString(offs + strigLength, currString, valueAttribs);
            } else {
                super.insertString(offs + strigLength, currString, this.getCharacterElement(offs + strigLength).getAttributes());
            }
            strigLength += currString.length();
        }
    }
}

