/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Stack;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.tree.TreeNode;
import sferyx.administration.editors.CustomXMLTagsGrammarSpecification;
import sferyx.administration.editors.EditorHTMLDocument;
import sferyx.administration.editors.HTMLEditor;
import sferyx.administration.editors.XHTMLWriter;
import sferyx.administration.editors.adapters.GenericTagAdapter;

public class SimpleHTMLWriter
extends XHTMLWriter {
    Stack blockElementStack = new Stack();
    int startPos = 0;
    int endPos = 0;

    public SimpleHTMLWriter(Writer w, HTMLDocument doc) {
        this(w, doc, 0, doc.getLength());
    }

    public SimpleHTMLWriter(Writer writer, HTMLDocument doc, int pos, int len) {
        super(writer, doc, pos, len);
        this.startPos = pos;
        this.endPos = pos + len;
    }

    public void write() throws IOException, BadLocationException {
        ElementIterator it = this.getElementIterator();
        Element current = null;
        Element next = null;
        this.setCurrentLineLength(0);
        this.setCanWrapLines(false);
        boolean forcedBody = false;
        while ((next = it.next()) != null) {
            Element top;
            if (!this.inRange(next)) continue;
            if (current != null && current.getParentElement() == next.getParentElement() && current.getParentElement() == next.getParentElement() && (top = (Element)this.blockElementStack.peek()) == current) {
                this.blockElementStack.pop();
            }
            if (!next.isLeaf()) {
                this.blockElementStack.push(next);
            } else {
                this.emptyTag(next);
            }
            current = next;
        }
        this.closeOutUnwantedEmbeddedTags(null);
        while (!this.blockElementStack.empty()) {
            current = (Element)this.blockElementStack.pop();
            if (this.synthesizedElement(current)) continue;
        }
    }

    public void write(Element toWrite) throws IOException, BadLocationException {
        this.setCanWrapLines(false);
        if (this.matchNameAttribute(toWrite.getAttributes(), HTML.Tag.TEXTAREA)) {
            this.startTag(toWrite);
            this.endTag(toWrite);
        } else if (this.matchNameAttribute(toWrite.getAttributes(), HTML.Tag.SELECT)) {
            this.startTag(toWrite);
            this.endTag(toWrite);
        } else if (((AbstractDocument.AbstractElement)toWrite).isLeaf()) {
            this.emptyTag(toWrite);
        } else {
            this.startTag(toWrite);
            int n = ((AbstractDocument.AbstractElement)toWrite).getElementCount();
            for (int i = 0; i < n; ++i) {
                AbstractDocument.AbstractElement e = (AbstractDocument.AbstractElement)((AbstractDocument.AbstractElement)toWrite).getElement(i);
                this.write(e);
            }
            this.endTag(toWrite);
        }
    }

    public void writeElementContent(Element toWrite) throws IOException, BadLocationException {
        this.setCanWrapLines(false);
        if (((AbstractDocument.AbstractElement)toWrite).isLeaf()) {
            this.emptyTag(toWrite);
        } else {
            int n = ((AbstractDocument.AbstractElement)toWrite).getElementCount();
            for (int i = 0; i < n; ++i) {
                AbstractDocument.AbstractElement e = (AbstractDocument.AbstractElement)((AbstractDocument.AbstractElement)toWrite).getElement(i);
                this.write(e);
            }
        }
    }

    protected boolean inRange(Element next) {
        int startOffset = this.getStartOffset();
        int endOffset = this.getEndOffset();
        if (this.matchNameAttribute(next.getAttributes(), HTML.Tag.HTML) || this.matchNameAttribute(next.getAttributes(), HTML.Tag.BODY) || this.matchNameAttribute(next.getAttributes(), HTML.Tag.HEAD)) {
            return false;
        }
        return next.getStartOffset() >= startOffset && next.getStartOffset() < endOffset || startOffset >= next.getStartOffset() && startOffset < next.getEndOffset();
    }

    public boolean isReallyEmptyTag(Element elem) {
        try {
            AttributeSet attr = elem.getAttributes();
            String name = elem.getName();
            if (CustomXMLTagsGrammarSpecification.isTagRegistered(name) && CustomXMLTagsGrammarSpecification.isTagEmpty(name)) {
                return true;
            }
            AbstractDocument.AbstractElement parentElement = (AbstractDocument.AbstractElement)elem.getParentElement();
            Enumeration<TreeNode> children = parentElement.children();
            while (children.hasMoreElements()) {
                AbstractDocument.AbstractElement nextElem = (AbstractDocument.AbstractElement)children.nextElement();
                if (!name.equals(nextElem.getName()) || !nextElem.containsAttribute(HTML.Attribute.ENDTAG, "true")) continue;
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    protected void emptyTag(Element elem) throws BadLocationException, IOException {
        GenericTagAdapter adapter;
        AttributeSet attr;
        AttributeSet attribs = attr = elem.getAttributes();
        String classAttrib = (String)elem.getAttributes().getAttribute(HTML.Attribute.CLASS);
        String valueAttrib = (String)elem.getAttributes().getAttribute(HTML.Attribute.VALUE);
        if (classAttrib != null && classAttrib.equals("custom_tag") && this.matchNameAttribute(attribs, HTML.Tag.INPUT) && (adapter = (GenericTagAdapter)attribs.getAttribute("custom_tag_adapter")) != null) {
            String adapter_type = (String)elem.getAttributes().getAttribute("adapter_type");
            if (adapter != null) {
                HTMLEditor.statementsDecoding.put(elem.getAttributes().getAttribute(HTML.Attribute.VALUE), adapter.getGeneratedOutput());
            }
            this.closeOutUnwantedEmbeddedTags(attribs);
            this.writeEmbeddedTags(attribs);
            this.write(adapter.getGeneratedOutput());
            return;
        }
        HTML.Tag kind = (HTML.Tag)attr.getAttribute(StyleConstants.NameAttribute);
        if (kind instanceof HTML.UnknownTag && attr.getAttribute(HTML.Attribute.ENDTAG) == null && this.isReallyEmptyTag(elem)) {
            this.closeOutUnwantedEmbeddedTags(attr);
            this.writeEmbeddedTags(attr);
            this.write('<');
            this.write(elem.getName());
            this.writeAttributes(attr);
            this.write(' ');
            this.write('/');
            this.write('>');
        } else if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.IMG) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.BR) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.HR) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.LINK) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.META) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.INPUT) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.PARAM) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.BASE)) {
            this.indent();
            this.writeLineSeparator();
            this.closeOutUnwantedEmbeddedTags(attr);
            this.writeEmbeddedTags(attr);
            this.write('<');
            this.write(elem.getName());
            this.writeAttributes(attr);
            this.write(' ');
            this.write('/');
            this.write('>');
        } else {
            super.emptyTag(elem);
        }
    }

    public void writeEmbeddedTags(AttributeSet attr) throws IOException {
        AttributeSet spanSet = (AttributeSet)attr.getAttribute(HTML.Tag.SPAN);
        if (spanSet != null && spanSet.getAttribute(HTML.Attribute.ENDTAG) != null) {
            ((EditorHTMLDocument)this.getDocument()).lock();
            ((MutableAttributeSet)attr).removeAttribute(HTML.Tag.SPAN);
            ((EditorHTMLDocument)this.getDocument()).unlock();
        }
        super.writeEmbeddedTags(attr);
    }

    public void writeAttributes11(AttributeSet attr) throws IOException {
        AttributeSet convAttr = attr;
        if (HTMLEditor.isForcedCSSGeneration()) {
            convAttr = new SimpleAttributeSet();
            SimpleHTMLWriter.convertToHTML40(attr, (MutableAttributeSet)convAttr);
            Enumeration<?> names = convAttr.getAttributeNames();
            while (names.hasMoreElements()) {
                Object name = names.nextElement();
                if (name instanceof HTML.Tag || name instanceof StyleConstants || name == HTML.Attribute.ENDTAG) continue;
                this.write(" " + name + "=\"" + convAttr.getAttribute(name) + "\"");
            }
        } else {
            super.writeAttributes(convAttr);
        }
    }

    private static void convertToHTML40(AttributeSet from, MutableAttributeSet to) {
        Enumeration<?> keys = from.getAttributeNames();
        String value = "";
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (key instanceof CSS.Attribute) {
                if (key == CSS.Attribute.TEXT_ALIGN && from.getAttribute(HTML.Attribute.ALIGN) != null) continue;
                value = value + key + ":" + from.getAttribute(key) + ";";
                continue;
            }
            to.addAttribute(key, from.getAttribute(key));
        }
        if (value.length() > 0) {
            to.addAttribute(HTML.Attribute.STYLE, value);
        }
    }
}

