/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.SizeRequirements;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.html.BlockView;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.TreeNode;
import javax.swing.undo.UndoableEdit;
import sferyx.administration.editors.AlternativeCSSAttribute;
import sferyx.administration.editors.AttributeSetTranslator;
import sferyx.administration.editors.CSSLayoutViews;
import sferyx.administration.editors.ColumnLayoutHandler;
import sferyx.administration.editors.CustomBlockView;
import sferyx.administration.editors.CustomImageView;
import sferyx.administration.editors.CustomLayoutBoxView;
import sferyx.administration.editors.CustomParagraphView;
import sferyx.administration.editors.CustomTableCelView;
import sferyx.administration.editors.CustomTableView;
import sferyx.administration.editors.CustomXMLTagsGrammarSpecification;
import sferyx.administration.editors.EditorHTMLDocument;
import sferyx.administration.editors.HTMLEditor;
import sferyx.administration.editors.HiddenValue;
import sferyx.administration.editors.Row;
import sferyx.administration.editors.RowLayoutHandler;
import sferyx.administration.editors.SimpleHTMLWriter;
import sferyx.administration.editors.TableView;
import sferyx.administration.editors.TiledLayoutHandler;
import sferyx.administration.editors.XHTMLWriter;
import sferyx.javascript.engine.DocumentElement;

public class SferyxUtilities {
    static String jvm_version;
    static boolean isMac;
    static boolean jvm_older;
    static HTML.Tag[] blockElements;
    static HTML.Tag[] paragraphElements;
    private static final char[] ALPHABET;
    private static int[] toInt;
    static int resolution;
    static Color defaultBorderColorLower;
    static Color defaultBorderColorUpper;
    static float[] dotted_dash;
    static float[] dashed_dash;
    public static Color transparentColor;
    static HiddenValue[] mcssattr;
    static AlternativeCSSAttribute[] cssattr;
    static String[] additionStlyeDeclarations;

    public static String getJVMVersion() {
        return jvm_version;
    }

    public static boolean isMac() {
        return isMac;
    }

    public static boolean isJVMOlder() {
        return isMac;
    }

    public static void findNextOccuranceAndRepalce(String word, String replacement, JTextComponent textComponent, boolean matchCase) {
        int index = -1;
        int pos = -1;
        try {
            while (index == -1) {
                if (pos == -1) {
                    pos = 0;
                } else if (pos >= textComponent.getDocument().getEndPosition().getOffset()) {
                    return;
                }
                Element paragraph = Utilities.getParagraphElement(textComponent, pos);
                int start = paragraph.getStartOffset();
                int end = paragraph.getEndOffset();
                String text = textComponent.getText(start, end - start);
                index = matchCase ? text.indexOf(word, pos - start) : text.toLowerCase().indexOf(word.toLowerCase(), pos - start);
                if (index == -1) {
                    ++pos;
                    continue;
                }
                ((AbstractDocument)textComponent.getDocument()).replace(start + index, word.length(), replacement, null);
                pos = start + index + word.length();
                break;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public static boolean isBlockElement(Element elem) {
        for (int i = 0; i < blockElements.length; ++i) {
            if (blockElements[i] == (HTML.Tag)elem.getAttributes().getAttribute(StyleConstants.NameAttribute)) {
                return true;
            }
            if (!CustomXMLTagsGrammarSpecification.isTagRegistered(elem.getName()) || !CustomXMLTagsGrammarSpecification.isTagRenderingAsBlock(elem.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isParagraphElement(Element elem) {
        for (int i = 0; i < paragraphElements.length; ++i) {
            if (paragraphElements[i] != (HTML.Tag)elem.getAttributes().getAttribute(StyleConstants.NameAttribute)) continue;
            return true;
        }
        return false;
    }

    public static String printAttributeSet(AttributeSet as) {
        if (as == null) {
            return "";
        }
        String s = "";
        Enumeration<?> names = as.getAttributeNames();
        while (names.hasMoreElements()) {
            Object key = names.nextElement();
            Object value = as.getAttribute(key);
            if (value instanceof AttributeSet) {
                s = s + key + "=**AttributeSet** ";
                s = s + "\n==Inner Set==>" + SferyxUtilities.printAttributeSet((AttributeSet)value);
                s = s + "\n==Inner Set End==>";
                continue;
            }
            s = s + "\n" + key + "=" + value + " ";
        }
        return s;
    }

    public static View getViewForElement(Element elem, JEditorPane textComponent) {
        View rootView = textComponent.getUI().getRootView(textComponent);
        for (int i = 0; i < rootView.getViewCount(); ++i) {
            View view;
            View childView = rootView.getView(i);
            if (childView == null) {
                return null;
            }
            if (childView.getElement() == elem) {
                return childView;
            }
            if (childView.getViewCount() <= 0 || (view = SferyxUtilities.getViewForElement(childView, elem)) == null) continue;
            return view;
        }
        return null;
    }

    protected static View getViewForElement(View rootView, Element elem) {
        for (int i = 0; i < rootView.getViewCount(); ++i) {
            View view;
            View childView = rootView.getView(i);
            if (childView == null) continue;
            if (childView.getElement() == elem) {
                return childView;
            }
            if (childView.getViewCount() <= 0 || (view = SferyxUtilities.getViewForElement(childView, elem)) == null) continue;
            return view;
        }
        return null;
    }

    public static boolean isDisplayLikeInlineView(View view, StyleSheet styleSheet) {
        Style attribs = styleSheet.getRule((HTML.Tag)view.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute), view.getElement());
        if (attribs != null && SferyxUtilities.isDisplayLikeInlineView(attribs, styleSheet)) {
            return true;
        }
        if (SferyxUtilities.isDisplayLikeInlineView(view.getElement().getAttributes(), styleSheet)) {
            return true;
        }
        return SferyxUtilities.isDisplayLikeInlineView(view.getAttributes(), styleSheet);
    }

    public static boolean isDisplayLikeInlineView(AttributeSet attribs, StyleSheet styleSheet) {
        return attribs.getAttribute(CSS.Attribute.DISPLAY) != null && attribs.isDefined(CSS.Attribute.DISPLAY) && (attribs.getAttribute(CSS.Attribute.DISPLAY).toString().equalsIgnoreCase("inline") || attribs.getAttribute(CSS.Attribute.DISPLAY).toString().equalsIgnoreCase("inline-block"));
    }

    public static boolean isItAImageView(View view) {
        return SferyxUtilities.matchNameAttribute(view.getElement(), HTML.Tag.IMPLIED) && SferyxUtilities.matchNameAttribute((view = view.getView(0)).getElement(), HTML.Tag.IMPLIED) && view.getViewCount() > 0 && SferyxUtilities.matchNameAttribute(view.getView(0).getElement(), HTML.Tag.IMG);
    }

    public static boolean isFloatCenterView(AttributeSet attribs, StyleSheet styleSheet) {
        if (attribs.getAttribute(HTML.Attribute.ALIGN) != null && attribs.containsAttribute(HTML.Attribute.ALIGN, attribs.getAttribute(HTML.Attribute.ALIGN))) {
            return attribs.getAttribute(HTML.Attribute.ALIGN).toString().equalsIgnoreCase("center");
        }
        if (attribs.getAttribute(CSS.Attribute.TEXT_ALIGN) != null && attribs.containsAttribute(CSS.Attribute.TEXT_ALIGN, attribs.getAttribute(CSS.Attribute.TEXT_ALIGN))) {
            return attribs.getAttribute(CSS.Attribute.TEXT_ALIGN).toString().equalsIgnoreCase("center");
        }
        if (attribs.getAttribute(AlternativeCSSAttribute.MARGIN_LEFT) != null && attribs.getAttribute(AlternativeCSSAttribute.MARGIN_LEFT).equals("auto")) {
            return true;
        }
        if (SferyxUtilities.matchNameAttribute(attribs, HTML.Tag.CENTER)) {
            return true;
        }
        return SferyxUtilities.getStyleSheetCSSValueForElement(styleSheet, attribs, CSS.Attribute.FLOAT) != null && SferyxUtilities.getStyleSheetCSSValueForElement(styleSheet, attribs, CSS.Attribute.FLOAT).toString().equalsIgnoreCase("center");
    }

    public static boolean isViewNotVisible(View view, StyleSheet styleSheet) {
        AttributeSet attribs = view.getAttributes();
        Object displayAttr = attribs.getAttribute(CSS.Attribute.DISPLAY);
        if (displayAttr != null && attribs.isDefined(CSS.Attribute.DISPLAY) && displayAttr.toString().indexOf("none") != -1) {
            return true;
        }
        Object visAttr = attribs.getAttribute("visibility");
        if (visAttr != null && attribs.isDefined("visibility") && visAttr.toString().indexOf("hidden") != -1) {
            return true;
        }
        return view instanceof CustomLayoutBoxView && ((CustomLayoutBoxView)view).getHeightCSSValue() == 0.0f;
    }

    public static boolean isOverflowXHidden(View view, StyleSheet styleSheet) {
        AttributeSet attribs = view.getElement().getAttributes();
        if (SferyxUtilities.getStyleSheetCSSValueForElement(styleSheet, attribs, "overflow-x") != null && attribs.isDefined("overflow-x") && SferyxUtilities.getStyleSheetCSSValueForElement(styleSheet, attribs, "overflow-x").toString().indexOf("hidden") != -1) {
            return true;
        }
        attribs = view.getAttributes();
        return SferyxUtilities.getStyleSheetCSSValueForElement(styleSheet, attribs, "overflow-x") != null && attribs.isDefined("overflow-x") && SferyxUtilities.getStyleSheetCSSValueForElement(styleSheet, attribs, "overflow-x").toString().indexOf("hidden") != -1;
    }

    public static boolean isOverflowHidden(View view, StyleSheet styleSheet) {
        AttributeSet attribs = view.getElement().getAttributes();
        if (attribs.getAttribute("overflow") != null && attribs.isDefined("overflow") && attribs.getAttribute("overflow").toString().indexOf("hidden") != -1) {
            return true;
        }
        attribs = view.getAttributes();
        return attribs.getAttribute("overflow") != null && attribs.isDefined("overflow") && attribs.getAttribute("overflow").toString().indexOf("hidden") != -1;
    }

    public static boolean isClearLeftView(View view, StyleSheet styleSheet) {
        if (SferyxUtilities.isClearLeftView(view.getElement().getAttributes(), styleSheet)) {
            return true;
        }
        return SferyxUtilities.isClearLeftView(view.getAttributes(), styleSheet);
    }

    public static boolean isClearRightView(View view, StyleSheet styleSheet) {
        if (SferyxUtilities.isClearRightView(view.getElement().getAttributes(), styleSheet)) {
            return true;
        }
        return SferyxUtilities.isClearRightView(view.getAttributes(), styleSheet);
    }

    public static boolean isClearBothView(View view, StyleSheet styleSheet) {
        if (SferyxUtilities.isClearBothView(view.getElement().getAttributes(), styleSheet)) {
            return true;
        }
        return SferyxUtilities.isClearBothView(view.getAttributes(), styleSheet);
    }

    public static boolean isClearLeftView(AttributeSet attribs, StyleSheet styleSheet) {
        return SferyxUtilities.getStyleSheetCSSValueForElement(styleSheet, attribs, CSS.Attribute.CLEAR) != null && SferyxUtilities.getStyleSheetCSSValueForElement(styleSheet, attribs, CSS.Attribute.CLEAR).toString().indexOf("left") != -1;
    }

    public static boolean isAttributeSetEmpty(AttributeSet attribs) {
        Enumeration<?> allAttribs = attribs.getAttributeNames();
        while (allAttribs.hasMoreElements()) {
            Object nextElem = allAttribs.nextElement();
            if (nextElem == EditorHTMLDocument.sferyxInternalEmbeddedTagsCount || nextElem == EditorHTMLDocument.realClassName || nextElem == EditorHTMLDocument.realIDName) continue;
            return false;
        }
        return true;
    }

    public static boolean isClearRightView(AttributeSet attribs, StyleSheet styleSheet) {
        return SferyxUtilities.getStyleSheetCSSValueForElement(styleSheet, attribs, CSS.Attribute.CLEAR) != null && SferyxUtilities.getStyleSheetCSSValueForElement(styleSheet, attribs, CSS.Attribute.CLEAR).toString().indexOf("right") != -1;
    }

    public static boolean isClearBothView(AttributeSet attribs, StyleSheet styleSheet) {
        return attribs.getAttribute(CSS.Attribute.CLEAR) != null && attribs.isDefined(CSS.Attribute.CLEAR) && attribs.getAttribute(CSS.Attribute.CLEAR).toString().indexOf("both") != -1;
    }

    public static boolean isFloatLeftView(View view, StyleSheet styleSheet) {
        Style attribs = styleSheet.getRule((HTML.Tag)view.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute), view.getElement());
        if (attribs != null && SferyxUtilities.isFloatLeftView(attribs, styleSheet)) {
            return true;
        }
        if (SferyxUtilities.isFloatLeftView(view.getElement().getAttributes(), styleSheet)) {
            return true;
        }
        return SferyxUtilities.isFloatLeftView(view.getAttributes(), styleSheet);
    }

    public static boolean isFloatRightView(View view, StyleSheet styleSheet) {
        if (view instanceof CSSLayoutViews && ((CSSLayoutViews)((Object)view)).isAbsolutePositioning()) {
            return false;
        }
        if (SferyxUtilities.isFloatRightView(view.getElement().getAttributes(), styleSheet)) {
            return true;
        }
        return SferyxUtilities.isFloatRightView(view.getAttributes(), styleSheet);
    }

    public static boolean isFloatCenterView(View view, StyleSheet styleSheet) {
        if (SferyxUtilities.isFloatCenterView(view.getElement().getAttributes(), styleSheet)) {
            return true;
        }
        return SferyxUtilities.isFloatCenterView(view.getAttributes(), styleSheet);
    }

    public static boolean isFloatLeftView(AttributeSet attribs, StyleSheet styleSheet) {
        if ((SferyxUtilities.matchNameAttribute(attribs, HTML.Tag.TABLE) || SferyxUtilities.matchNameAttribute(attribs, HTML.Tag.IMG)) && attribs.getAttribute(HTML.Attribute.ALIGN) != null && attribs.containsAttribute(HTML.Attribute.ALIGN, attribs.getAttribute(HTML.Attribute.ALIGN))) {
            return attribs.getAttribute(HTML.Attribute.ALIGN).toString().indexOf("left") != -1;
        }
        if (SferyxUtilities.getStyleSheetCSSValueForElement(styleSheet, attribs, CSS.Attribute.DISPLAY) != null && SferyxUtilities.getStyleSheetCSSValueForElement(styleSheet, attribs, CSS.Attribute.DISPLAY).toString().indexOf("inline") != -1 && !SferyxUtilities.isFloatRightView(attribs, styleSheet) && !SferyxUtilities.isFloatCenterView(attribs, styleSheet)) {
            return true;
        }
        return SferyxUtilities.getStyleSheetCSSValueForElement(styleSheet, attribs, CSS.Attribute.FLOAT) != null && SferyxUtilities.getStyleSheetCSSValueForElement(styleSheet, attribs, CSS.Attribute.FLOAT).toString().indexOf("left") != -1;
    }

    public static boolean isFloatRightView(AttributeSet attribs, StyleSheet styleSheet) {
        String value;
        if (SferyxUtilities.matchNameAttribute(attribs, HTML.Tag.TABLE) && attribs.getAttribute(HTML.Attribute.ALIGN) != null && attribs.containsAttribute(HTML.Attribute.ALIGN, attribs.getAttribute(HTML.Attribute.ALIGN))) {
            return attribs.getAttribute(HTML.Attribute.ALIGN).toString().indexOf("right") != -1;
        }
        return SferyxUtilities.getStyleSheetCSSValueForElement(styleSheet, attribs, CSS.Attribute.FLOAT) != null && (value = SferyxUtilities.getStyleSheetCSSValueForElement(styleSheet, attribs, CSS.Attribute.FLOAT).toString()).toLowerCase().indexOf("right") != -1;
    }

    public static boolean isDisplayLikeBlockView(View view, StyleSheet styleSheet) {
        if (SferyxUtilities.isDisplayLikeBlockView(view.getElement().getAttributes(), styleSheet)) {
            return true;
        }
        return SferyxUtilities.isDisplayLikeBlockView(view.getAttributes(), styleSheet);
    }

    public static boolean isDisplayLikeBlockView(AttributeSet attribs, StyleSheet styleSheet) {
        return attribs.getAttribute(CSS.Attribute.DISPLAY) != null && attribs.isDefined(CSS.Attribute.DISPLAY) && attribs.getAttribute(CSS.Attribute.DISPLAY).toString().trim().equalsIgnoreCase("block");
    }

    public static boolean isDisplayLikeBlockView(Element attribs, StyleSheet styleSheet) {
        return SferyxUtilities.isDisplayLikeBlockView(attribs.getAttributes(), styleSheet);
    }

    public static JComponent getJavaFormItemComponent(DocumentElement elem, HTMLEditor htmlEditor) {
        return SferyxUtilities.getJavaFormItemComponent(elem.element, htmlEditor.getSelectedEditorComponent());
    }

    public static JComponent getJavaFormItemComponent(DocumentElement elem, JEditorPane htmlEditor) {
        return SferyxUtilities.getJavaFormItemComponent(elem.element, htmlEditor);
    }

    public static JComponent getJavaFormItemComponent(Element elem, JEditorPane htmlEditor) {
        View view = SferyxUtilities.getViewForElement(elem, htmlEditor);
        if (view instanceof ComponentView) {
            return (JComponent)((ComponentView)view).getComponent();
        }
        return null;
    }

    public static Element getElementForJavaFormItemComponent(JComponent component, HTMLEditor htmlEditor) {
        return SferyxUtilities.getElementForJavaFormItemComponent(component, htmlEditor.getSelectedEditorComponent());
    }

    public static Element getElementForJavaFormItemComponent(JComponent component, JEditorPane htmlEditor) {
        View view = SferyxUtilities.getViewForComponent(component, htmlEditor);
        if (view != null) {
            return view.getElement();
        }
        return null;
    }

    public static View getImageViewForPoint(JEditorPane textComponent, int x, int y) {
        try {
            View rootView = textComponent.getUI().getRootView(textComponent);
            for (int i = 0; i < rootView.getViewCount(); ++i) {
                View view;
                View childView = rootView.getView(i);
                if (childView instanceof CustomImageView && ((CustomImageView)childView).paintBounds.inside(x, y)) {
                    return childView;
                }
                if (childView.getViewCount() <= 0 || (view = SferyxUtilities.getImageViewForPoint(childView, x, y)) == null) continue;
                return view;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    protected static View getImageViewForPoint(View rootView, int x, int y) {
        for (int i = 0; i < rootView.getViewCount(); ++i) {
            View view;
            View childView = rootView.getView(i);
            if (childView instanceof CustomImageView && ((CustomImageView)childView).paintBounds.inside(x, y)) {
                return childView;
            }
            if (childView.getViewCount() <= 0 || (view = SferyxUtilities.getImageViewForPoint(childView, x, y)) == null) continue;
            return view;
        }
        return null;
    }

    public static View getViewForComponent(JComponent component, JEditorPane textComponent) {
        try {
            View rootView = textComponent.getUI().getRootView(textComponent);
            for (int i = 0; i < rootView.getViewCount(); ++i) {
                View view;
                View childView = rootView.getView(i);
                if (childView instanceof ComponentView) {
                    JComponent viewComponent = (JComponent)((ComponentView)childView).getComponent();
                    if (viewComponent == component) {
                        return childView;
                    }
                    if (viewComponent instanceof JScrollPane && ((JScrollPane)viewComponent).getViewport().getView() == component) {
                        return childView;
                    }
                }
                if (childView.getViewCount() <= 0 || (view = SferyxUtilities.getViewForComponent(childView, component)) == null) continue;
                return view;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    protected static View getViewForComponent(View rootView, JComponent component) {
        for (int i = 0; i < rootView.getViewCount(); ++i) {
            View view;
            View childView = rootView.getView(i);
            if (childView instanceof ComponentView) {
                JComponent viewComponent = (JComponent)((ComponentView)childView).getComponent();
                if (viewComponent == component) {
                    return childView;
                }
                if (viewComponent instanceof JScrollPane && ((JScrollPane)viewComponent).getViewport().getView() == component) {
                    return childView;
                }
            }
            if (childView.getViewCount() <= 0 || (view = SferyxUtilities.getViewForComponent(childView, component)) == null) continue;
            return view;
        }
        return null;
    }

    public static HTMLEditor getHostHTMLEditor(Container container) {
        HTMLEditor htmlEditor = null;
        Container parent = container;
        if (container == null) {
            return null;
        }
        while ((parent = parent.getParent()) != null) {
            if (parent instanceof HTMLEditor) {
                htmlEditor = (HTMLEditor)parent;
                return htmlEditor;
            }
            if (parent != null) continue;
            return null;
        }
        return null;
    }

    public static HTMLEditor getHostHTMLEditor(View view) {
        Container container = view.getContainer();
        HTMLEditor htmlEditor = null;
        Container parent = container;
        if (container == null) {
            return null;
        }
        while ((parent = parent.getParent()) != null) {
            if (parent instanceof HTMLEditor) {
                htmlEditor = (HTMLEditor)parent;
                return htmlEditor;
            }
            if (parent != null) continue;
            return null;
        }
        return null;
    }

    public static String replaceAllIfNotFollows(String content, String toReplace, String replaceWith, String ifNotFollows) {
        if (toReplace.equals(replaceWith) || toReplace.equals("")) {
            return content;
        }
        int foundIndex = 0;
        String resultLine = content;
        try {
            while (foundIndex != -1) {
                String followingString;
                int followsStringLength;
                int indexOfXHTMLTag = resultLine.indexOf(toReplace, foundIndex);
                if (indexOfXHTMLTag == -1) {
                    indexOfXHTMLTag = resultLine.indexOf(toReplace.toLowerCase(), foundIndex);
                }
                if (indexOfXHTMLTag == -1) {
                    indexOfXHTMLTag = resultLine.indexOf(toReplace.toUpperCase(), foundIndex);
                }
                if (indexOfXHTMLTag == -1) {
                    foundIndex = -1;
                    continue;
                }
                if (ifNotFollows != null && (followsStringLength = ifNotFollows.length()) <= resultLine.length() && (followingString = resultLine.substring(indexOfXHTMLTag + 1, indexOfXHTMLTag + 1 + followsStringLength)).equals(ifNotFollows)) {
                    foundIndex = indexOfXHTMLTag + 1;
                    continue;
                }
                String beforeTagLine = resultLine.substring(0, indexOfXHTMLTag);
                String afterTagLine = "";
                afterTagLine = resultLine.substring(indexOfXHTMLTag + toReplace.length());
                String newLine = beforeTagLine + replaceWith + afterTagLine;
                foundIndex = beforeTagLine.length() + replaceWith.length();
                resultLine = newLine;
            }
        }
        catch (Throwable thr) {
            // empty catch block
        }
        return resultLine;
    }

    public static String replaceAllIfFollows(String content, String toReplace, String replaceWith, String[] ifFollows) {
        if (toReplace.equals(replaceWith) || toReplace.equals("")) {
            return content;
        }
        int foundIndex = 0;
        String resultLine = content;
        try {
            while (foundIndex != -1) {
                int indexOfXHTMLTag = resultLine.indexOf(toReplace, foundIndex);
                if (indexOfXHTMLTag == -1) {
                    indexOfXHTMLTag = resultLine.indexOf(toReplace.toLowerCase(), foundIndex);
                }
                if (indexOfXHTMLTag == -1) {
                    indexOfXHTMLTag = resultLine.indexOf(toReplace.toUpperCase(), foundIndex);
                }
                if (indexOfXHTMLTag == -1) {
                    foundIndex = -1;
                    continue;
                }
                if (ifFollows != null) {
                    boolean follows = false;
                    for (int i = 0; i < ifFollows.length; ++i) {
                        String followingString;
                        int followsStringLength = ifFollows[i].length();
                        if (followsStringLength > resultLine.length() || !(followingString = resultLine.substring(indexOfXHTMLTag + toReplace.length(), indexOfXHTMLTag + toReplace.length() + followsStringLength)).equals(ifFollows[i])) continue;
                        follows = true;
                        break;
                    }
                    if (!follows) {
                        foundIndex = indexOfXHTMLTag + 1;
                        continue;
                    }
                }
                String beforeTagLine = resultLine.substring(0, indexOfXHTMLTag);
                String afterTagLine = "";
                afterTagLine = resultLine.substring(indexOfXHTMLTag + toReplace.length());
                String newLine = beforeTagLine + replaceWith + afterTagLine;
                foundIndex = beforeTagLine.length() + replaceWith.length();
                resultLine = newLine;
            }
        }
        catch (Throwable thr) {
            thr.printStackTrace();
        }
        return resultLine;
    }

    public static String replaceAll(String content, String toReplace, String replaceWith) {
        if (toReplace.equals(replaceWith) || toReplace.equals("")) {
            return content;
        }
        int foundIndex = 0;
        String resultLine = content;
        while (foundIndex != -1) {
            int indexOfXHTMLTag = resultLine.indexOf(toReplace, foundIndex);
            if (indexOfXHTMLTag == -1) {
                indexOfXHTMLTag = resultLine.indexOf(toReplace.toLowerCase(), foundIndex);
            }
            if (indexOfXHTMLTag == -1) {
                indexOfXHTMLTag = resultLine.indexOf(toReplace.toUpperCase(), foundIndex);
            }
            if (indexOfXHTMLTag == -1) {
                foundIndex = -1;
                continue;
            }
            String beforeTagLine = resultLine.substring(0, indexOfXHTMLTag);
            String afterTagLine = "";
            afterTagLine = resultLine.substring(indexOfXHTMLTag + toReplace.length());
            String newLine = beforeTagLine + replaceWith + afterTagLine;
            foundIndex = beforeTagLine.length() + replaceWith.length();
            resultLine = newLine;
        }
        return resultLine;
    }

    public static String replaceAllBlockCommentOccurances(String content, String replaceWith) {
        int foundIndex = 0;
        String resultLine = content;
        String toReplace = "/*";
        while (foundIndex != -1) {
            int indexOfXHTMLTag = resultLine.indexOf(toReplace, foundIndex);
            if (indexOfXHTMLTag == -1) {
                indexOfXHTMLTag = resultLine.indexOf(toReplace.toLowerCase(), foundIndex);
            }
            if (indexOfXHTMLTag == -1) {
                indexOfXHTMLTag = resultLine.indexOf(toReplace.toUpperCase(), foundIndex);
            }
            if (indexOfXHTMLTag == -1) {
                foundIndex = -1;
                continue;
            }
            String beforeTagLine = resultLine.substring(0, indexOfXHTMLTag);
            String afterTagLine = "";
            int indexOfEndOfTag = resultLine.indexOf("*/", indexOfXHTMLTag);
            afterTagLine = resultLine.substring(indexOfXHTMLTag + (indexOfEndOfTag - indexOfXHTMLTag) + 2);
            String newLine = beforeTagLine + replaceWith + afterTagLine;
            foundIndex = beforeTagLine.length() + replaceWith.length();
            resultLine = newLine;
        }
        resultLine = SferyxUtilities.replaceAll(resultLine, "max-width", "width");
        return resultLine;
    }

    public static String replaceAllStartTagOccurances(String content, String toReplace, String replaceWith) {
        if (toReplace.equals(replaceWith) || toReplace.equals("")) {
            return content;
        }
        content = SferyxUtilities.replaceAll(content, "<" + toReplace + ">", replaceWith);
        content = SferyxUtilities.replaceAllStartTagOccurances_(content, toReplace + " ", replaceWith);
        return content;
    }

    static String replaceAllStartTagOccurances_(String content, String toReplace, String replaceWith) {
        if (toReplace.equals(replaceWith) || toReplace.equals("")) {
            return content;
        }
        int foundIndex = 0;
        String resultLine = content;
        toReplace = "<" + toReplace;
        while (foundIndex != -1) {
            int indexOfXHTMLTag = resultLine.indexOf(toReplace, foundIndex);
            if (indexOfXHTMLTag == -1) {
                indexOfXHTMLTag = resultLine.indexOf(toReplace.toLowerCase(), foundIndex);
            }
            if (indexOfXHTMLTag == -1) {
                indexOfXHTMLTag = resultLine.indexOf(toReplace.toUpperCase(), foundIndex);
            }
            if (indexOfXHTMLTag == -1) {
                foundIndex = -1;
                continue;
            }
            String beforeTagLine = resultLine.substring(0, indexOfXHTMLTag);
            String afterTagLine = "";
            int indexOfEndOfTag = resultLine.indexOf(">", indexOfXHTMLTag);
            afterTagLine = resultLine.substring(indexOfXHTMLTag + (indexOfEndOfTag - indexOfXHTMLTag) + 1);
            String newLine = beforeTagLine + replaceWith + afterTagLine;
            foundIndex = beforeTagLine.length() + replaceWith.length();
            resultLine = newLine;
        }
        return resultLine;
    }

    public static String convertFromXHTMLtoHTML(String line) {
        boolean foundIndex = false;
        String resultLine = line;
        return resultLine;
    }

    public static String dumpDocumentElement(Element elem) {
        HTMLDocument htdoc = (HTMLDocument)elem.getDocument();
        int start = elem.getStartOffset();
        int end = elem.getEndOffset();
        StringWriter buf = new StringWriter();
        SimpleHTMLWriter htmlw = new SimpleHTMLWriter((Writer)buf, htdoc, start, end - start);
        try {
            htmlw.write(elem);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        String origHtml = buf.toString();
        return origHtml;
    }

    public static boolean isLayered(Element elem) {
        if (elem.getAttributes().getAttribute("position") != null && elem.getAttributes().getAttribute("position").equals("absolute")) {
            return true;
        }
        Style attr = ((HTMLDocument)elem.getDocument()).getStyleSheet().getRule((HTML.Tag)elem.getAttributes().getAttribute(StyleConstants.NameAttribute), elem);
        return attr != null && attr.getAttribute("position") != null && attr.getAttribute("position").equals("absolute");
    }

    public static void printStringArray(String[] array) {
        if (array == null) {
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            System.out.println("[" + i + "]=" + array[i]);
        }
    }

    public static boolean isRightToLeft(JEditorPane editor) {
        return SferyxUtilities.getBibiLevel(0, editor) == 1;
    }

    public static boolean isRightToLeft(HTMLDocument doc) {
        return SferyxUtilities.getBibiLevel(0, doc) == 1;
    }

    public static int getBibiLevel(int pos, HTMLDocument doc) {
        HTMLDocument htdoc = doc;
        Element bidiRoot = htdoc.getBidiRootElement();
        int index = bidiRoot.getElementIndex(pos);
        Element bidiElem = bidiRoot.getElement(index);
        AttributeSet bidiAttrs = bidiElem.getAttributes();
        return StyleConstants.getBidiLevel(bidiAttrs);
    }

    public static int getBibiLevel(int pos, JEditorPane editor) {
        HTMLDocument htdoc = (HTMLDocument)editor.getDocument();
        return SferyxUtilities.getBibiLevel(pos, htdoc);
    }

    public static boolean isLeftAlignedView(View view) {
        AttributeSet elementAttributes = view.getElement().getAttributes();
        try {
            Object align_attribute = elementAttributes.getAttribute(HTML.Attribute.ALIGN);
            Object name_attribute = elementAttributes.getAttribute(StyleConstants.NameAttribute);
            boolean isFloat = false;
            if (align_attribute == null && view.getAttributes().getAttribute(CSS.Attribute.FLOAT) != null) {
                align_attribute = view.getAttributes().getAttribute(CSS.Attribute.FLOAT).toString();
                isFloat = true;
            }
            return align_attribute != null && ((String)align_attribute).equalsIgnoreCase("left") && elementAttributes.containsAttribute(HTML.Attribute.ALIGN, "left") || align_attribute != null && isFloat && align_attribute.equals("left");
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean isRightAlignedView(View view) {
        AttributeSet elementAttributes = view.getElement().getAttributes();
        try {
            Object align_attribute = elementAttributes.getAttribute(HTML.Attribute.ALIGN);
            Object name_attribute = elementAttributes.getAttribute(StyleConstants.NameAttribute);
            boolean isFloat = false;
            if (align_attribute == null && view.getAttributes().getAttribute(CSS.Attribute.FLOAT) != null) {
                align_attribute = view.getAttributes().getAttribute(CSS.Attribute.FLOAT).toString();
                isFloat = true;
            }
            return align_attribute != null && ((String)align_attribute).equalsIgnoreCase("right") && elementAttributes.containsAttribute(HTML.Attribute.ALIGN, "right") || align_attribute != null && isFloat && align_attribute.equals("right");
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean isItARightImageView(View view) {
        if (view != null) {
            return false;
        }
        StyleSheet styleSheet = ((HTMLDocument)view.getElement().getDocument()).getStyleSheet();
        try {
            if (SferyxUtilities.matchNameAttribute(view.getElement(), HTML.Tag.IMPLIED) && view.getViewCount() > 0 && SferyxUtilities.matchNameAttribute((view = view.getView(0)).getElement(), HTML.Tag.IMPLIED) && view.getViewCount() > 1 && SferyxUtilities.matchNameAttribute(view.getView(1).getElement(), HTML.Tag.IMG)) {
                if (SferyxUtilities.matchNameAttribute(view.getView(1).getElement().getAttributes(), HTML.Tag.IMG) && view.getView(1).getElement().getAttributes().getAttribute(HTML.Attribute.ALIGN) != null && view.getView(1).getElement().getAttributes().containsAttribute(HTML.Attribute.ALIGN, view.getView(1).getElement().getAttributes().getAttribute(HTML.Attribute.ALIGN))) {
                    boolean result = view.getView(1).getElement().getAttributes().getAttribute(HTML.Attribute.ALIGN).toString().equalsIgnoreCase("right");
                    return result;
                }
                return view.getView(1).getAttributes().getAttribute(CSS.Attribute.FLOAT) != null && view.getView(1).getAttributes().getAttribute(CSS.Attribute.FLOAT).toString().equalsIgnoreCase("right");
            }
        }
        catch (Throwable thr) {
            thr.printStackTrace();
        }
        return false;
    }

    public static boolean isItALeftImageView(View view) {
        if (view != null) {
            return false;
        }
        StyleSheet styleSheet = ((HTMLDocument)view.getElement().getDocument()).getStyleSheet();
        try {
            if (SferyxUtilities.matchNameAttribute(view.getElement(), HTML.Tag.IMPLIED) && view.getViewCount() > 0) {
                if ((view = view.getView(0)) == null) {
                    return false;
                }
                if (SferyxUtilities.matchNameAttribute(view.getElement(), HTML.Tag.IMPLIED) && view.getViewCount() > 0 && SferyxUtilities.matchNameAttribute(view.getView(0).getElement(), HTML.Tag.IMG)) {
                    if (SferyxUtilities.matchNameAttribute(view.getView(0).getElement().getAttributes(), HTML.Tag.IMG) && view.getView(0).getElement().getAttributes().getAttribute(HTML.Attribute.ALIGN) != null && view.getView(0).getElement().getAttributes().containsAttribute(HTML.Attribute.ALIGN, view.getView(0).getElement().getAttributes().getAttribute(HTML.Attribute.ALIGN))) {
                        return view.getView(0).getElement().getAttributes().getAttribute(HTML.Attribute.ALIGN).toString().equalsIgnoreCase("left");
                    }
                    return view.getView(1).getAttributes().getAttribute(CSS.Attribute.FLOAT) != null && view.getView(1).getAttributes().getAttribute(CSS.Attribute.FLOAT).toString().equalsIgnoreCase("left");
                }
            }
        }
        catch (Throwable thr) {
            thr.printStackTrace();
        }
        return false;
    }

    public static boolean isItACommentView(View view) {
        try {
            if (SferyxUtilities.matchNameAttribute(view.getElement(), HTML.Tag.IMPLIED)) {
                int elementCount = view.getElement().getElementCount();
                int commentCount = 0;
                if (elementCount == 1 && (SferyxUtilities.matchNameAttribute(view.getElement().getElement(0), HTML.Tag.COMMENT) || SferyxUtilities.matchNameAttribute(view.getElement().getElement(0), HTML.Tag.SCRIPT))) {
                    return true;
                }
                if (elementCount <= 1) {
                    return false;
                }
                for (int i = 0; i < elementCount - 1; ++i) {
                    if (!SferyxUtilities.matchNameAttribute(view.getElement().getElement(i), HTML.Tag.COMMENT) && !SferyxUtilities.matchNameAttribute(view.getElement().getElement(i), HTML.Tag.SCRIPT)) {
                        return false;
                    }
                    ++commentCount;
                }
                if (commentCount == elementCount - 1) {
                    return true;
                }
            }
        }
        catch (Throwable thr) {
            thr.printStackTrace();
        }
        return false;
    }

    public static boolean matchNameAttribute(Element elem, HTML.Tag tag) {
        HTML.Tag name;
        AttributeSet attr = elem.getAttributes();
        Object o = attr.getAttribute(StyleConstants.NameAttribute);
        return o instanceof HTML.Tag && (name = (HTML.Tag)o) == tag;
    }

    public static boolean matchNameAttribute(AttributeSet attr, HTML.Tag tag) {
        HTML.Tag name;
        Object o = attr.getAttribute(StyleConstants.NameAttribute);
        return o instanceof HTML.Tag && (name = (HTML.Tag)o) == tag;
    }

    public static String writeEntireElementContent(Element elem, int start, int end) {
        String content = "";
        content = SferyxUtilities.dumpElementContent(elem, start, end - start);
        return content;
    }

    public static String writeInternalElementContent(Element elem, int start, int end) {
        String content = "";
        for (int i = 0; i < elem.getElementCount(); ++i) {
            Element currElement = elem.getElement(i);
            content = content + SferyxUtilities.dumpElementContent(elem.getElement(i), start, end - start);
        }
        return content;
    }

    public static final String encodeQuotedPrintable(String data) {
        byte[] b = null;
        try {
            b = data.getBytes("ISO8859_1");
        }
        catch (Exception ex) {
            b = data.getBytes();
        }
        int len = b.length;
        StringBuffer buffer = new StringBuffer(2 * len);
        StringBuffer line = new StringBuffer(240);
        StringBuffer white = new StringBuffer(80);
        for (int i = 0; i < len; ++i) {
            char c = (char)b[i];
            if (c == '\r' && i != len - 1 && b[i + 1] == 10) {
                SferyxUtilities.encodeEndOfLine(buffer, line, white);
                ++i;
                continue;
            }
            if (c == ' ' || c == '\t') {
                white.append(c);
                continue;
            }
            if (white.length() != 0) {
                line.append(white);
                white.setLength(0);
            }
            if (c >= '!' && c <= '~' && c != '=') {
                line.append(c);
                continue;
            }
            SferyxUtilities.appendHex(line, c);
        }
        if (line.length() != 0 || white.length() != 0) {
            SferyxUtilities.encodeEndOfLine(buffer, line, white);
        }
        return buffer.toString();
    }

    private static final void encodeEndOfLine(StringBuffer buffer, StringBuffer line, StringBuffer white) {
        int i;
        for (i = 0; i < white.length(); ++i) {
            SferyxUtilities.appendHex(line, white.charAt(i));
        }
        String s = line.toString();
        int len = s.length();
        boolean split = false;
        i = 0;
        while (i < len) {
            int j = i + 75;
            if (j == len - 1 || j > len) {
                j = len;
            }
            if (j > 2) {
                if (s.charAt(j - 1) == '=') {
                    --j;
                }
                if (s.charAt(j - 2) == '=') {
                    j -= 2;
                }
            }
            buffer.append(s.substring(i, j));
            if (j != len) {
                buffer.append('=');
            }
            buffer.append("\r\n");
            i = j;
        }
        line.setLength(0);
        white.setLength(0);
    }

    private static final void appendHex(StringBuffer line, int c) {
        line.append('=');
        line.append("0123456789ABCDEF".charAt((c &= 0xFF) >> 4));
        line.append("0123456789ABCDEF".charAt(c & 0xF));
    }

    public static String encodeBase64(byte[] buf) {
        int size = buf.length;
        char[] ar = new char[(size + 2) / 3 * 4];
        int a = 0;
        int i = 0;
        while (i < size) {
            byte b0 = buf[i++];
            byte b1 = i < size ? buf[i++] : (byte)0;
            byte b2 = i < size ? buf[i++] : (byte)0;
            int mask = 63;
            ar[a++] = ALPHABET[b0 >> 2 & mask];
            ar[a++] = ALPHABET[(b0 << 4 | (b1 & 0xFF) >> 4) & mask];
            ar[a++] = ALPHABET[(b1 << 2 | (b2 & 0xFF) >> 6) & mask];
            ar[a++] = ALPHABET[b2 & mask];
        }
        switch (size % 3) {
            case 1: {
                ar[--a] = 61;
            }
            case 2: {
                ar[--a] = 61;
            }
        }
        return new String(ar);
    }

    public static byte[] decodeBase64(String s) {
        if (s.indexOf("%") != -1) {
            s = URLDecoder.decode(s);
        }
        int delta = s.endsWith("==") ? 2 : (s.endsWith("=") ? 1 : 0);
        byte[] buffer = new byte[s.length() * 3 / 4 - delta];
        int mask = 255;
        int index = 0;
        for (int i = 0; i < s.length(); i += 4) {
            int c0 = toInt[s.charAt(i)];
            int c1 = toInt[s.charAt(i + 1)];
            buffer[index++] = (byte)((c0 << 2 | c1 >> 4) & mask);
            if (index >= buffer.length) {
                return buffer;
            }
            int c2 = toInt[s.charAt(i + 2)];
            buffer[index++] = (byte)((c1 << 4 | c2 >> 2) & mask);
            if (index >= buffer.length) {
                return buffer;
            }
            int c3 = toInt[s.charAt(i + 3)];
            buffer[index++] = (byte)((c2 << 6 | c3) & mask);
        }
        return buffer;
    }

    public static String dumpElementContent(Element elem, int start, int length) {
        HTMLDocument htdoc = (HTMLDocument)elem.getDocument();
        StringWriter buf = new StringWriter();
        XHTMLWriter htmlw = new XHTMLWriter((Writer)buf, htdoc, start, length);
        try {
            htmlw.writeElementContent(elem);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        String origHtml = buf.toString();
        return origHtml;
    }

    public static String writeInternalElementContent(Element elem) {
        String content = "";
        for (int i = 0; i < elem.getElementCount(); ++i) {
            content = content + SferyxUtilities.dumpElementContent(elem.getElement(i));
        }
        return content;
    }

    public static String dumpElementContent(Element elem) {
        HTMLDocument htdoc = (HTMLDocument)elem.getDocument();
        int start = elem.getStartOffset();
        int end = elem.getEndOffset();
        StringWriter buf = new StringWriter();
        SimpleHTMLWriter htmlw = new SimpleHTMLWriter((Writer)buf, htdoc, start, end - start);
        try {
            htmlw.writeElementContent(elem);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        String origHtml = buf.toString();
        return origHtml;
    }

    public static void insertElementAtIndex(Element parent, Element child, int index) {
        try {
            int elementCount = parent.getElementCount();
            Element[] newElementArray = new Element[elementCount + 1];
            Element[] oldElementArray = new Element[elementCount];
            Vector<Element> tempVec = new Vector<Element>();
            for (int i = 0; i < elementCount; ++i) {
                tempVec.addElement(parent.getElement(i));
                oldElementArray[i] = parent.getElement(i);
            }
            if (index < tempVec.size()) {
                tempVec.insertElementAt(child, index);
            } else {
                tempVec.addElement(child);
                index = elementCount;
            }
            newElementArray = tempVec.toArray(newElementArray);
            AbstractDocument.DefaultDocumentEvent dde = ((EditorHTMLDocument)parent.getDocument()).getDefautInsertEvent(parent);
            UndoableEdit u = ((EditorHTMLDocument)parent.getDocument()).getDocumentContent().insertString(parent.getEndOffset() + 1, "kojo supata");
            ((AbstractDocument.BranchElement)parent).replace(0, elementCount, newElementArray);
            dde.addEdit(new AbstractDocument.ElementEdit(parent, index, oldElementArray, newElementArray));
            if (u != null) {
                dde.addEdit(u);
            }
            dde.end();
            if (u != null) {
                ((EditorHTMLDocument)parent.getDocument()).fireUndoableEditUpdate(new UndoableEditEvent((EditorHTMLDocument)parent.getDocument(), dde));
            }
        }
        catch (Throwable thr) {
            thr.printStackTrace();
        }
    }

    public static void removeElement(Element parent, Element child) {
        try {
            int index = ((TreeNode)((Object)parent)).getIndex((TreeNode)((Object)child));
            int start = child.getStartOffset();
            int end = child.getEndOffset();
            SferyxUtilities.removeElements(parent, index, 1, start, end);
        }
        catch (Throwable thr) {
            thr.printStackTrace();
        }
    }

    public static void removeCellElement(Element parent, Element child) {
        if (parent.getElementCount() == 1 && SferyxUtilities.matchNameAttribute(parent, HTML.Tag.TABLE)) {
            block11: {
                EditorHTMLDocument htdoc = (EditorHTMLDocument)parent.getDocument();
                try {
                    try {
                        if (parent.getParentElement().getElementCount() <= 1) {
                            try {
                                htdoc.setInnerHTML(parent.getParentElement(), "<p></p>");
                            }
                            catch (Throwable thr) {}
                            break block11;
                        }
                        SferyxUtilities.removeCellElement(parent.getParentElement(), parent);
                    }
                    catch (Throwable thr) {
                        thr.printStackTrace();
                    }
                }
                catch (Throwable thr) {
                    // empty catch block
                }
            }
            return;
        }
        if (parent.getElementCount() == 1 && SferyxUtilities.matchNameAttribute(parent, HTML.Tag.TR)) {
            SferyxUtilities.removeCellElement(parent.getParentElement(), parent);
            return;
        }
        try {
            int index = ((TreeNode)((Object)parent)).getIndex((TreeNode)((Object)child));
            int start = child.getStartOffset();
            int end = child.getEndOffset();
            SferyxUtilities.removeElements(parent, index, 1);
        }
        catch (Throwable thr) {
            thr.printStackTrace();
        }
    }

    public static View getPreviousLayoutView(View fromView) {
        return SferyxUtilities.getPreviousLayoutView(SferyxUtilities.indexOfView(fromView), fromView.getParent());
    }

    public static View getPreviousLayoutView(int index, View parent) {
        if (index < 1) {
            return null;
        }
        for (int i = index - 1; i >= 0; --i) {
            View currentView = parent.getView(i);
            if (!(currentView instanceof CustomParagraphView) && !(currentView instanceof BlockView) && !(currentView instanceof TableView) || SferyxUtilities.isItACommentView(currentView) || currentView instanceof CustomBlockView && SferyxUtilities.isViewNotVisible(currentView, ((CustomBlockView)currentView).getStyleSheet()) || currentView instanceof CSSLayoutViews && ((CSSLayoutViews)((Object)currentView)).isAbsolutePositioning()) continue;
            return currentView;
        }
        return null;
    }

    public static int getTotalSpanBetween(int from, int to, View parent) {
        if (from < 1) {
            return 0;
        }
        int totalSpan = 0;
        for (int i = from - 1; i > to; --i) {
            View currentView = parent.getView(i);
            totalSpan = (int)((float)totalSpan + currentView.getPreferredSpan(1));
            if (!(currentView instanceof CSSLayoutViews)) continue;
            totalSpan += ((CSSLayoutViews)((Object)currentView)).getTopMargin() + ((CSSLayoutViews)((Object)currentView)).getBottomMargin();
        }
        return totalSpan;
    }

    public static View getPreviousFloatView(View fromView) {
        return SferyxUtilities.getPreviousFloatView(SferyxUtilities.indexOfView(fromView), fromView.getParent());
    }

    public static View getPreviousFloatView(int index, View parent) {
        if (index < 1) {
            return null;
        }
        for (int i = index - 1; i >= 0; --i) {
            View currentView = parent.getView(i);
            if (SferyxUtilities.isItACommentView(currentView)) continue;
            if (SferyxUtilities.isFloatLeftView(currentView, ((EditorHTMLDocument)currentView.getDocument()).getStyleSheet()) || SferyxUtilities.isFloatRightView(currentView, ((EditorHTMLDocument)currentView.getDocument()).getStyleSheet())) {
                return currentView;
            }
            if (!SferyxUtilities.isClearLeftView(currentView, ((EditorHTMLDocument)currentView.getDocument()).getStyleSheet()) && !SferyxUtilities.isClearBothView(currentView, ((EditorHTMLDocument)currentView.getDocument()).getStyleSheet()) && !SferyxUtilities.isClearRightView(currentView, ((EditorHTMLDocument)currentView.getDocument()).getStyleSheet())) continue;
            return null;
        }
        return null;
    }

    public static View getNextBoxLayoutView(int index, View parent) {
        if (index >= parent.getViewCount() - 1) {
            return null;
        }
        for (int i = index + 1; i < parent.getViewCount(); ++i) {
            View currentView = parent.getView(i);
            if (!(currentView instanceof CustomParagraphView) && !(currentView instanceof BlockView) && !(currentView instanceof TableView) || SferyxUtilities.isItACommentView(currentView) || currentView instanceof CustomBlockView && SferyxUtilities.isViewNotVisible(currentView, ((CustomBlockView)currentView).getStyleSheet()) || currentView instanceof CSSLayoutViews && ((CSSLayoutViews)((Object)currentView)).isAbsolutePositioning()) continue;
            return currentView;
        }
        return null;
    }

    public static View getNextLayoutView(int index, View parent) {
        if (index >= parent.getViewCount() - 1) {
            return null;
        }
        for (int i = index + 1; i < parent.getViewCount(); ++i) {
            View currentView = parent.getView(i);
            if (!(currentView instanceof BlockView) && !(currentView instanceof TableView) || SferyxUtilities.isItACommentView(currentView) || currentView instanceof CustomBlockView && SferyxUtilities.isViewNotVisible(currentView, ((CustomBlockView)currentView).getStyleSheet()) || currentView instanceof CSSLayoutViews && ((CSSLayoutViews)((Object)currentView)).isAbsolutePositioning()) continue;
            return currentView;
        }
        return null;
    }

    public static Element getPreviousElementFromSameParent(Element child) {
        int index = SferyxUtilities.getElementIndex(child);
        Element parent = child.getParentElement();
        if (index == 0) {
            return null;
        }
        return parent.getElement(index - 1);
    }

    public static Element getNextElementFromSameParent(Element child) {
        Element parent;
        int index = SferyxUtilities.getElementIndex(child);
        if (index == (parent = child.getParentElement()).getElementCount() - 1) {
            return null;
        }
        return parent.getElement(index + 1);
    }

    public static boolean isLastElementInParent(Element child) {
        return SferyxUtilities.getElementIndex(child) == child.getParentElement().getElementCount() - 1;
    }

    public static int getElementIndex(Element child) {
        int index = ((TreeNode)((Object)child.getParentElement())).getIndex((TreeNode)((Object)child));
        return index;
    }

    public static boolean isLastElementOfType(Element elem, HTML.Tag type) {
        Element parent = elem.getParentElement();
        int count = parent.getElementCount();
        int elementIndex = SferyxUtilities.getElementIndex(elem);
        if (elementIndex == count - 1) {
            return true;
        }
        for (int i = elementIndex + 1; i < count; ++i) {
            Element nextElement = parent.getElement(i);
            if (!SferyxUtilities.matchNameAttribute(nextElement, type)) continue;
            return false;
        }
        return true;
    }

    public static void removeListElements(Element parent, int startIndex, int count) throws BadLocationException {
        EditorHTMLDocument htdoc = (EditorHTMLDocument)parent.getDocument();
        SferyxUtilities.removeElements(parent, startIndex, count);
    }

    public static void removeElements(Element e, int index, int count) throws BadLocationException {
        if (index < 0) {
            return;
        }
        Element[] removed = new Element[count];
        Element[] added = new Element[]{};
        for (int counter = 0; counter < count; ++counter) {
            removed[counter] = e.getElement(counter + index);
        }
        int start = removed[0].getStartOffset();
        int end = removed[removed.length - 1].getEndOffset();
        if (end >= ((EditorHTMLDocument)e.getDocument()).getEndPosition().getOffset()) {
            end = ((EditorHTMLDocument)e.getDocument()).getEndPosition().getOffset() - 1;
        }
        AbstractDocument.DefaultDocumentEvent dde = ((EditorHTMLDocument)e.getDocument()).getDefautRemoveEvent(e);
        ((AbstractDocument.BranchElement)e).replace(index, removed.length, added);
        dde.addEdit(new AbstractDocument.ElementEdit(e, index, removed, added));
        UndoableEdit u = ((EditorHTMLDocument)e.getDocument()).getDocumentContent().remove(start, end - start);
        if (u != null) {
            dde.addEdit(u);
        }
        ((EditorHTMLDocument)e.getDocument()).postRemoveUpdate(dde);
        dde.end();
        ((EditorHTMLDocument)e.getDocument()).fireRemoveUpdate(dde);
        if (u != null) {
            ((EditorHTMLDocument)e.getDocument()).fireUndoableEditUpdate(new UndoableEditEvent((EditorHTMLDocument)e.getDocument(), dde));
        }
    }

    public static void removeElements(Element e, int index, int count, int start, int end) throws BadLocationException {
        UndoableEdit u;
        if (count + index > e.getElementCount()) {
            return;
        }
        Element[] removed = new Element[count];
        Element[] added = new Element[]{};
        for (int counter = 0; counter < count; ++counter) {
            removed[counter] = e.getElement(counter + index);
        }
        AbstractDocument.DefaultDocumentEvent dde = ((EditorHTMLDocument)e.getDocument()).getDefautRemoveEvent(e);
        ((AbstractDocument.BranchElement)e).replace(index, removed.length, added);
        dde.addEdit(new AbstractDocument.ElementEdit(e, index, removed, added));
        int length = end - start;
        if (start + end - start >= ((EditorHTMLDocument)e.getDocument()).getEndPosition().getOffset()) {
            length = ((EditorHTMLDocument)e.getDocument()).getEndPosition().getOffset() - start - 1;
        }
        if ((u = ((EditorHTMLDocument)e.getDocument()).getDocumentContent().remove(start, length)) != null) {
            // empty if block
        }
        ((EditorHTMLDocument)e.getDocument()).postRemoveUpdate(dde);
        dde.end();
        ((EditorHTMLDocument)e.getDocument()).fireRemoveUpdate(dde);
        if (u != null) {
            ((EditorHTMLDocument)e.getDocument()).fireUndoableEditUpdate(new UndoableEditEvent((EditorHTMLDocument)e.getDocument(), dde));
        }
    }

    public static int indexOfView(View v) {
        View parent = v.getParent();
        if (parent == null) {
            return -1;
        }
        int n = parent.getViewCount();
        for (int i = 0; i < n; ++i) {
            View currView = parent.getView(i);
            if (currView != v) continue;
            return i;
        }
        return -1;
    }

    public static Object getIgnoreCaseAttributeName(String attrName, AttributeSet attr) {
        Enumeration<?> allAttribs = attr.getAttributeNames();
        while (allAttribs.hasMoreElements()) {
            Object nextKey = allAttribs.nextElement();
            if (!(nextKey instanceof String) || !((String)nextKey).equalsIgnoreCase(attrName)) continue;
            return attr.getAttribute(nextKey);
        }
        return null;
    }

    public static String trimLeft(String string) {
        int st;
        int len = string.length();
        int count = string.length();
        int off = 0;
        char[] val = string.toCharArray();
        for (st = 0; st < len && val[off + st] <= ' '; ++st) {
        }
        return st > 0 || len < count ? string.substring(st, len) : string;
    }

    public static AttributeSet searchForAdditionalStyleDefinitions(String styleClass, StyleSheet styleSheet) {
        StyleSheet styles = styleSheet;
        SimpleAttributeSet sas = new SimpleAttributeSet();
        Enumeration<?> rules = styles.getStyleNames();
        while (rules.hasMoreElements()) {
            String name = (String)rules.nextElement();
            Style rule = styles.getStyle(name);
            if (rule.getName().indexOf("." + styleClass + " ") == -1 && rule.getName().indexOf("." + styleClass + ",") == -1 && !rule.getName().endsWith("." + styleClass)) continue;
            sas.addAttributes(rule);
        }
        return null;
    }

    public static float getStyleSheetCSSWidthForElement(StyleSheet styleSheet, AttributeSet attributes) {
        try {
            Object width_obj = SferyxUtilities.getStyleSheetCSSValueForElement(styleSheet, attributes, CSS.Attribute.WIDTH);
            if (width_obj != null) {
                float width = SferyxUtilities.getNumberFromCSString(width_obj.toString());
                return width;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1.0f;
    }

    public static float getStyleSheetCSSWidthForView(StyleSheet styleSheet, View view) {
        float width = -1.0f;
        if (width == -1.0f) {
            width = SferyxUtilities.getStyleSheetCSSWidthForElement(styleSheet, view.getAttributes());
        }
        return width;
    }

    public static Object getAttributeValueFromString(AttributeSet attr, String attributeName) {
        Enumeration<?> allAttribs = attr.getAttributeNames();
        while (allAttribs.hasMoreElements()) {
            Object nextAttrib = allAttribs.nextElement();
            if (!nextAttrib.toString().equalsIgnoreCase(attributeName)) continue;
            return attr.getAttribute(nextAttrib);
        }
        return null;
    }

    public static float getStyleSheetCSSHeightForView(StyleSheet styleSheet, View view) {
        float height = -1.0f;
        if (height == -1.0f) {
            height = SferyxUtilities.getStyleSheetCSSHeightForElement(styleSheet, view.getAttributes());
        }
        return height;
    }

    public static float getStyleSheetCSSHeightForElement(StyleSheet styleSheet, AttributeSet attributes) {
        try {
            Object height_obj = SferyxUtilities.getStyleSheetCSSValueForElement(styleSheet, attributes, CSS.Attribute.HEIGHT);
            if (height_obj != null) {
                float height = SferyxUtilities.getNumberFromCSString(height_obj.toString());
                return height;
            }
        }
        catch (Throwable thr) {
            thr.printStackTrace();
        }
        return -1.0f;
    }

    public static boolean getIsNumberFromCSStringAPercent(String value) {
        return value.indexOf("%") != -1 || value.indexOf("em") != -1;
    }

    public static int getScreenResolution() {
        return resolution;
    }

    public static float getNumberFromCSString(String value) {
        try {
            if (value.indexOf("px") != -1) {
                value = value.substring(0, value.indexOf("px"));
                double scale = (float)resolution / 72.0f;
                float result = Float.parseFloat(value);
                return result;
            }
            if (value.indexOf("pt") != -1) {
                value = value.substring(0, value.indexOf("pt"));
                double scale = (float)resolution / 72.0f;
                float result = Float.parseFloat(value);
                return (float)(scale * (double)result);
            }
            if (value.indexOf("in") != -1) {
                value = value.substring(0, value.indexOf("in"));
                float result = Float.parseFloat(value);
                return (float)resolution * result;
            }
            if (value.indexOf("cm") != -1) {
                value = value.substring(0, value.indexOf("cm"));
                float result = Float.parseFloat(value);
                return (float)((double)resolution * ((double)result / 2.54));
            }
            if (value.indexOf("%") != -1 || value.indexOf("em") != -1) {
                return -1.0f;
            }
            return Float.parseFloat(value);
        }
        catch (Throwable throwable) {
            return -1.0f;
        }
    }

    public static String colorToString(Color color) {
        String colorString = Integer.toHexString(color.getRGB());
        if (colorString.length() == 8) {
            colorString = colorString.substring(2);
        }
        return "#" + colorString;
    }

    public static float convertEmValue(String nextToken) {
        if ((nextToken = nextToken.trim()).endsWith("rem")) {
            float fl_value = Float.parseFloat(nextToken.substring(0, nextToken.indexOf("rem")));
            return fl_value;
        }
        if (nextToken.endsWith("em")) {
            float fl_value = Float.parseFloat(nextToken.substring(0, nextToken.indexOf("em")));
            return fl_value;
        }
        return -1.0f;
    }

    public static Object getStyleSheetCSSValueForElement(StyleSheet styleSheet, AttributeSet attribs, String attrib) {
        if (attribs == null) {
            return null;
        }
        if (attribs.getAttribute(attrib) != null && attribs.containsAttribute(attrib, attribs.getAttribute(attrib))) {
            return attribs.getAttribute(attrib);
        }
        return null;
    }

    public static Object getStyleSheetCSSValueForElement(StyleSheet styleSheet, AttributeSet attribs, CSS.Attribute attrib) {
        if (attribs == null) {
            return null;
        }
        if (attribs.getAttribute(attrib) != null && attribs.containsAttribute(attrib, attribs.getAttribute(attrib))) {
            return attribs.getAttribute(attrib);
        }
        return null;
    }

    public static Object getStyleSheetCSSValueForElement(Element elem, CSS.Attribute attrib) {
        AttributeSet elementAttributes = elem.getAttributes();
        if (elementAttributes.getAttribute(attrib) != null && elementAttributes.containsAttribute(attrib, elementAttributes.getAttribute(attrib))) {
            return elementAttributes.getAttribute(attrib);
        }
        return null;
    }

    public static Object getStyleSheetCSSValueForElement(Element elem, String attrib) {
        AttributeSet elementAttributes = elem.getAttributes();
        if (elementAttributes.getAttribute(attrib) != null && elementAttributes.containsAttribute(attrib, elementAttributes.getAttribute(attrib))) {
            return elementAttributes.getAttribute(attrib);
        }
        return null;
    }

    public static void convertSelectedCellsToList(HTMLEditor htmlEditor, JEditorPane html, String tag) {
        if (((EditorHTMLDocument)html.getDocument()).selectedCells.isEmpty()) {
            return;
        }
        Object[] cells = new Element[((EditorHTMLDocument)html.getDocument()).selectedCells.size()];
        ((EditorHTMLDocument)html.getDocument()).selectedCells.copyInto(cells);
        EditorHTMLDocument htdoc = (EditorHTMLDocument)html.getDocument();
        boolean inList = false;
        boolean listReset = false;
        htdoc.lock();
        for (int i = 0; i < cells.length; ++i) {
            String cellContents = "";
            for (int j = 0; j < cells[i].getElementCount(); ++j) {
                String elementContent;
                Element elem = cells[i].getElement(j);
                if (elem == null) continue;
                if (SferyxUtilities.matchNameAttribute(elem, HTML.Tag.P)) {
                    if (!inList) {
                        cellContents = cellContents + "<" + tag + ">";
                        inList = true;
                    }
                    elementContent = htmlEditor.dumpDocElement(elem);
                    elementContent = SferyxUtilities.replaceAll(elementContent, "<p", "<li");
                    elementContent = SferyxUtilities.replaceAll(elementContent, "</p>", "</li>");
                    cellContents = cellContents + elementContent;
                    continue;
                }
                if (SferyxUtilities.matchNameAttribute(elem, HTML.Tag.IMPLIED)) {
                    if (!inList) {
                        cellContents = cellContents + "<" + tag + ">";
                        inList = true;
                    }
                    elementContent = htmlEditor.dumpDocElement(elem);
                    cellContents = cellContents + "<li>" + elementContent + "</li>";
                    continue;
                }
                if (SferyxUtilities.matchNameAttribute(elem, HTML.Tag.UL) || SferyxUtilities.matchNameAttribute(elem, HTML.Tag.OL)) {
                    if (inList) {
                        cellContents = cellContents + "</" + tag + ">";
                        inList = false;
                    }
                    elementContent = htmlEditor.dumpDocElement(elem);
                    elementContent = SferyxUtilities.replaceAllStartTagOccurances(elementContent, "ul", "");
                    elementContent = SferyxUtilities.replaceAllStartTagOccurances(elementContent, "ol", "");
                    elementContent = SferyxUtilities.replaceAll(elementContent, "<li", "<P");
                    cellContents = cellContents + elementContent;
                    listReset = true;
                    continue;
                }
                if (inList) {
                    cellContents = cellContents + "</" + tag + ">";
                    inList = false;
                }
                elementContent = htmlEditor.dumpDocElement(elem);
                cellContents = cellContents + elementContent;
            }
            try {
                if (inList) {
                    cellContents = cellContents + "</" + tag + ">";
                    inList = false;
                }
                htdoc.unlock();
                htdoc.setInnerHTML((Element)cells[i], cellContents);
                htdoc.lock();
                continue;
            }
            catch (Throwable thr) {
                thr.printStackTrace();
            }
        }
        htdoc.unlock();
    }

    public static String trimRight(String string) {
        int len;
        int count = string.length();
        int st = 0;
        int off = 0;
        char[] val = string.toCharArray();
        for (len = string.length(); st < len && val[off + len - 1] <= ' '; --len) {
        }
        return st > 0 || len < count ? string.substring(st, len) : string;
    }

    public static View getGhostViewForTableElement(Element elem, JEditorPane container) {
        View rootView = container.getUI().getRootView(container);
        for (int i = 0; i < rootView.getViewCount(); ++i) {
            View view;
            View childView = rootView.getView(i);
            if (childView.getElement() == elem && childView instanceof CustomTableView) {
                return childView;
            }
            if (childView.getViewCount() <= 0 || (view = SferyxUtilities.getGhostViewForTableElement(childView, elem)) == null || !(view instanceof CustomTableView)) continue;
            return view;
        }
        return null;
    }

    public static View getGhostViewForTableElement(View rootView, Element elem) {
        for (int i = 0; i < rootView.getViewCount(); ++i) {
            View view;
            View childView = rootView.getView(i);
            if (childView.getElement() == elem && childView instanceof CustomTableView) {
                return childView;
            }
            if (childView.getViewCount() <= 0 || (view = SferyxUtilities.getGhostViewForTableElement(childView, elem)) == null || !(view instanceof CustomTableView)) continue;
            return view;
        }
        return null;
    }

    public static void paintViewBorder(View cellView, Rectangle childRect, Graphics g) {
        Rectangle clip = g.getClipRect();
        Rectangle clipRect = childRect;
        if (clip != null && childRect != null) {
            clipRect = childRect.intersection(clip);
        }
        if (clipRect != null) {
            g.setClip(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        }
        try {
            SferyxUtilities.paintViewBorder_(cellView, childRect, g);
        }
        catch (Throwable thr) {
            // empty catch block
        }
        g.setClip(clip);
    }

    public static void paintViewBorder_(View cellView, Rectangle childRect_, Graphics g) {
        Stroke stroke;
        Stroke origStroke;
        Object borderAttrib;
        Stroke stroke2;
        String style;
        Stroke origStroke2;
        AttributeSet table_attr;
        AttributeSet v_attr;
        int difference = 0;
        Rectangle childRect = new Rectangle(childRect_.x, childRect_.y, childRect_.width, childRect_.height);
        if (cellView instanceof CustomParagraphView) {
            // empty if block
        }
        if ((v_attr = cellView.getAttributes()).isDefined(CSS.Attribute.BORDER) && v_attr.getAttribute(CSS.Attribute.BORDER) != null && v_attr.containsAttribute(CSS.Attribute.BORDER, v_attr.getAttribute(CSS.Attribute.BORDER)) && v_attr.getAttribute(CSS.Attribute.BORDER).toString().indexOf("none") != -1 && v_attr.getAttribute(CSS.Attribute.BORDER_LEFT) == null && v_attr.getAttribute(CSS.Attribute.BORDER_RIGHT) == null && v_attr.getAttribute(CSS.Attribute.BORDER_TOP) == null && v_attr.getAttribute(CSS.Attribute.BORDER_BOTTOM) == null) {
            return;
        }
        boolean dontPaintDefaultBorder = false;
        if (cellView instanceof CustomTableCelView && (table_attr = cellView.getParent().getParent().getAttributes()).isDefined(CSS.Attribute.BORDER) && table_attr.getAttribute(CSS.Attribute.BORDER) != null && table_attr.containsAttribute(CSS.Attribute.BORDER, table_attr.getAttribute(CSS.Attribute.BORDER)) && table_attr.getAttribute(CSS.Attribute.BORDER).toString().indexOf("none") != -1) {
            dontPaintDefaultBorder = true;
        }
        int bottomBorderWidth = SferyxUtilities.getCellBottomBorderSize(cellView.getAttributes(), cellView.getElement());
        int topBorderWidth = SferyxUtilities.getCellTopBorderSize(cellView.getAttributes(), cellView.getElement());
        int rightBorderWidth = SferyxUtilities.getCellRightBorderSize(cellView.getAttributes(), cellView.getElement());
        int leftBorderWidth = SferyxUtilities.getCellLeftBorderSize(cellView.getAttributes(), cellView.getElement());
        String st = SferyxUtilities.getBottomBorderStyle(cellView.getAttributes());
        if (bottomBorderWidth < 0 && st != null && !st.trim().equals("") && !st.trim().equalsIgnoreCase("none")) {
            bottomBorderWidth = 2;
        }
        if (st != null && st.equalsIgnoreCase("none")) {
            bottomBorderWidth = 0;
        }
        if (bottomBorderWidth > 0) {
            origStroke2 = ((Graphics2D)g).getStroke();
            g.setColor(SferyxUtilities.getBottomBorderColor(cellView.getElement(), cellView.getAttributes()));
            style = SferyxUtilities.getBottomBorderStyle(cellView.getAttributes());
            stroke2 = origStroke2;
            stroke2 = SferyxUtilities.getBorderStroke(stroke2, bottomBorderWidth, style);
            ((Graphics2D)g).setStroke(stroke2);
            if (bottomBorderWidth < 2) {
                ((Graphics2D)g).drawLine(childRect.x, childRect.y - difference + childRect.height - bottomBorderWidth, childRect.x + childRect.width, childRect.y - difference + childRect.height - bottomBorderWidth);
            } else {
                ((Graphics2D)g).drawLine(childRect.x, childRect.y - difference + childRect.height - bottomBorderWidth / 2, childRect.x + childRect.width, childRect.y - difference + childRect.height - bottomBorderWidth / 2);
            }
            ((Graphics2D)g).setStroke(origStroke2);
        } else if (cellView instanceof CustomTableCelView || cellView instanceof TableView) {
            borderAttrib = null;
            borderAttrib = cellView instanceof CustomTableCelView ? cellView.getParent().getParent().getElement().getAttributes().getAttribute(HTML.Attribute.BORDER) : cellView.getElement().getAttributes().getAttribute(HTML.Attribute.BORDER);
            if (dontPaintDefaultBorder) {
                borderAttrib = null;
            }
            if (borderAttrib != null) {
                float number;
                if (!SferyxUtilities.isNumeric(borderAttrib.toString())) {
                    borderAttrib = "1";
                }
                if ((number = SferyxUtilities.getNumberFromCSString(borderAttrib.toString())) > 0.0f) {
                    if (cellView instanceof CustomTableCelView && number > 1.0f) {
                        number = 1.0f;
                    }
                    origStroke = ((Graphics2D)g).getStroke();
                    g.setColor(defaultBorderColorLower);
                    stroke = origStroke;
                    stroke = SferyxUtilities.getBorderStroke(stroke, (int)number, "solid");
                    ((Graphics2D)g).setStroke(stroke);
                    ((Graphics2D)g).drawLine(childRect.x, childRect.y - difference + childRect.height - 1, childRect.x + childRect.width - 1, childRect.y - difference + childRect.height - 1);
                    ((Graphics2D)g).setStroke(origStroke);
                }
            }
        }
        st = SferyxUtilities.getTopBorderStyle(cellView.getAttributes());
        if (topBorderWidth < 0 && st != null && !st.trim().equals("") && !st.trim().equalsIgnoreCase("none")) {
            topBorderWidth = 2;
        }
        if (st != null && st.equalsIgnoreCase("none")) {
            topBorderWidth = 0;
        }
        if (topBorderWidth > 0) {
            origStroke2 = ((Graphics2D)g).getStroke();
            g.setColor(SferyxUtilities.getTopBorderColor(cellView.getElement(), cellView.getAttributes()));
            style = SferyxUtilities.getTopBorderStyle(cellView.getAttributes());
            stroke2 = origStroke2;
            stroke2 = SferyxUtilities.getBorderStroke(stroke2, topBorderWidth, style);
            ((Graphics2D)g).setStroke(stroke2);
            if (topBorderWidth < 3 && style.equals("double")) {
                ((Graphics2D)g).drawLine(childRect.x, childRect.y - difference + topBorderWidth + 1, childRect.x + childRect.width, childRect.y - difference + topBorderWidth + 1);
            } else {
                ((Graphics2D)g).drawLine(childRect.x, childRect.y - difference + topBorderWidth / 2, childRect.x + childRect.width, childRect.y - difference + topBorderWidth / 2);
            }
            ((Graphics2D)g).setStroke(origStroke2);
        } else if (cellView instanceof CustomTableCelView || cellView instanceof TableView) {
            borderAttrib = null;
            borderAttrib = cellView instanceof CustomTableCelView ? cellView.getParent().getParent().getElement().getAttributes().getAttribute(HTML.Attribute.BORDER) : cellView.getElement().getAttributes().getAttribute(HTML.Attribute.BORDER);
            if (dontPaintDefaultBorder) {
                borderAttrib = null;
            }
            if (borderAttrib != null) {
                float number;
                if (!SferyxUtilities.isNumeric(borderAttrib.toString())) {
                    borderAttrib = "1";
                }
                if ((number = SferyxUtilities.getNumberFromCSString(borderAttrib.toString())) > 0.0f) {
                    if (cellView instanceof CustomTableCelView && number > 1.0f) {
                        number = 1.0f;
                    }
                    origStroke = ((Graphics2D)g).getStroke();
                    g.setColor(defaultBorderColorUpper);
                    stroke = origStroke;
                    stroke = SferyxUtilities.getBorderStroke(stroke, (int)number, "solid");
                    ((Graphics2D)g).setStroke(stroke);
                    ((Graphics2D)g).drawLine(childRect.x, childRect.y - difference, childRect.x + childRect.width - 1, childRect.y - difference);
                    ((Graphics2D)g).setStroke(origStroke);
                }
            }
        }
        st = SferyxUtilities.getRightBorderStyle(cellView.getAttributes());
        if (rightBorderWidth < 0 && st != null && !st.trim().equals("") && !st.trim().equalsIgnoreCase("none")) {
            rightBorderWidth = 2;
        }
        if (st != null && st.equalsIgnoreCase("none")) {
            rightBorderWidth = 0;
        }
        if (rightBorderWidth > 0) {
            origStroke2 = ((Graphics2D)g).getStroke();
            g.setColor(SferyxUtilities.getRightBorderColor(cellView.getElement(), cellView.getAttributes()));
            String style2 = SferyxUtilities.getRightBorderStyle(cellView.getAttributes());
            stroke2 = origStroke2;
            stroke2 = SferyxUtilities.getBorderStroke(stroke2, rightBorderWidth, style2);
            ((Graphics2D)g).setStroke(stroke2);
            if (rightBorderWidth < 2) {
                ((Graphics2D)g).drawLine(childRect.x + childRect.width - rightBorderWidth, childRect.y - difference, childRect.x + childRect.width - rightBorderWidth, childRect.y - difference + childRect.height);
            } else {
                ((Graphics2D)g).drawLine(childRect.x + childRect.width - rightBorderWidth / 2, childRect.y - difference, childRect.x + childRect.width - rightBorderWidth / 2, childRect.y - difference + childRect.height);
            }
            ((Graphics2D)g).setStroke(origStroke2);
        } else if (cellView instanceof CustomTableCelView || cellView instanceof TableView) {
            borderAttrib = null;
            borderAttrib = cellView instanceof CustomTableCelView ? cellView.getParent().getParent().getElement().getAttributes().getAttribute(HTML.Attribute.BORDER) : cellView.getElement().getAttributes().getAttribute(HTML.Attribute.BORDER);
            if (dontPaintDefaultBorder) {
                borderAttrib = null;
            }
            if (borderAttrib != null) {
                float number;
                if (!SferyxUtilities.isNumeric(borderAttrib.toString())) {
                    borderAttrib = "1";
                }
                if ((number = SferyxUtilities.getNumberFromCSString(borderAttrib.toString())) > 0.0f) {
                    if (cellView instanceof CustomTableCelView && number > 1.0f) {
                        number = 1.0f;
                    }
                    origStroke = ((Graphics2D)g).getStroke();
                    g.setColor(defaultBorderColorLower);
                    stroke = origStroke;
                    stroke = SferyxUtilities.getBorderStroke(stroke, (int)number, "solid");
                    ((Graphics2D)g).setStroke(stroke);
                    ((Graphics2D)g).drawLine(childRect.x + childRect.width - 1, childRect.y - difference, childRect.x + childRect.width - 1, childRect.y - difference + childRect.height);
                    ((Graphics2D)g).setStroke(origStroke);
                }
            }
        }
        st = SferyxUtilities.getLeftBorderStyle(cellView.getAttributes());
        if (leftBorderWidth < 0 && st != null && !st.trim().equals("") && !st.trim().equalsIgnoreCase("none")) {
            leftBorderWidth = 2;
        }
        if (st != null && st.equalsIgnoreCase("none")) {
            leftBorderWidth = 0;
        }
        if (leftBorderWidth > 0) {
            String style3 = SferyxUtilities.getLeftBorderStyle(cellView.getAttributes());
            Stroke origStroke3 = ((Graphics2D)g).getStroke();
            g.setColor(SferyxUtilities.getLeftBorderColor(cellView.getElement(), cellView.getAttributes()));
            stroke2 = origStroke3;
            stroke2 = SferyxUtilities.getBorderStroke(stroke2, leftBorderWidth, style3);
            ((Graphics2D)g).setStroke(stroke2);
            ((Graphics2D)g).drawLine(childRect.x + leftBorderWidth / 2, childRect.y - difference, childRect.x + leftBorderWidth / 2, childRect.y - difference + childRect.height);
            ((Graphics2D)g).setStroke(origStroke3);
        } else if (cellView instanceof CustomTableCelView || cellView instanceof TableView) {
            borderAttrib = null;
            borderAttrib = cellView instanceof CustomTableCelView ? cellView.getParent().getParent().getElement().getAttributes().getAttribute(HTML.Attribute.BORDER) : cellView.getElement().getAttributes().getAttribute(HTML.Attribute.BORDER);
            if (dontPaintDefaultBorder) {
                borderAttrib = null;
            }
            if (borderAttrib != null) {
                float number;
                if (!SferyxUtilities.isNumeric(borderAttrib.toString())) {
                    borderAttrib = "1";
                }
                if ((number = SferyxUtilities.getNumberFromCSString(borderAttrib.toString())) > 0.0f) {
                    if (cellView instanceof CustomTableCelView && number > 1.0f) {
                        number = 1.0f;
                    }
                    origStroke = ((Graphics2D)g).getStroke();
                    g.setColor(defaultBorderColorUpper);
                    stroke = origStroke;
                    stroke = SferyxUtilities.getBorderStroke(stroke, (int)number, "solid");
                    ((Graphics2D)g).setStroke(stroke);
                    ((Graphics2D)g).drawLine(childRect.x, childRect.y - difference, childRect.x, childRect.y - difference + childRect.height);
                    ((Graphics2D)g).setStroke(origStroke);
                }
            }
        }
    }

    public static boolean isNumeric(String pad) {
        if (pad != null) {
            for (int i = 0; i < pad.length(); ++i) {
                if (Character.isDigit(pad.charAt(i)) || pad.charAt(i) == '.') continue;
                return false;
            }
        }
        return true;
    }

    public static Stroke getBorderStroke(Stroke stroke, float borderWidth, String style) {
        if (style.equals("dashed")) {
            stroke = new BasicStroke(borderWidth, 0, 0, 1.0f, dashed_dash, 0.0f);
        } else if (style.equals("dotted")) {
            stroke = new BasicStroke(borderWidth, 0, 0, 1.0f, dotted_dash, 0.0f);
        } else if (style.equals("double")) {
            class CompositeStroke
            implements Stroke {
                private Stroke stroke1;
                private Stroke stroke2;

                public CompositeStroke(Stroke stroke1, Stroke stroke2) {
                    this.stroke1 = stroke1;
                    this.stroke2 = stroke2;
                }

                public Shape createStrokedShape(Shape shape) {
                    Shape s = this.stroke2.createStrokedShape(this.stroke1.createStrokedShape(shape));
                    return s;
                }
            }
            stroke = new CompositeStroke(new BasicStroke(borderWidth), new BasicStroke(borderWidth / 2.0f));
            stroke = borderWidth < 2.0f ? new CompositeStroke(new BasicStroke(borderWidth + 1.0f), new BasicStroke(borderWidth)) : new CompositeStroke(new BasicStroke(borderWidth), new BasicStroke(borderWidth / 2.0f));
        } else {
            stroke = new BasicStroke(borderWidth);
        }
        return stroke;
    }

    public static Color getBorderColor(Element elem, AttributeSet attribs) {
        CSS.Attribute attribute_class = attribs.getAttribute(CSS.Attribute.BORDER_COLOR) != null && !attribs.getAttribute(CSS.Attribute.BORDER_COLOR).toString().equalsIgnoreCase("Silver") ? CSS.Attribute.BORDER_COLOR : (attribs.getAttribute(CSS.Attribute.BORDER) != null ? CSS.Attribute.BORDER : CSS.Attribute.BORDER);
        return SferyxUtilities.getColor(elem, attribs, attribute_class);
    }

    public static Color getTopBorderColor(Element elem, AttributeSet attribs) {
        String styleValue;
        Object attribute_class;
        Color color;
        if (attribs.getAttribute("border-top-color") != null && attribs.isDefined("border-top-color") && (color = SferyxUtilities.getColor(elem, attribs, attribute_class = "border-top-color")) != transparentColor) {
            return color;
        }
        if (attribs.getAttribute(CSS.Attribute.BORDER_TOP) != null && attribs.isDefined(CSS.Attribute.BORDER_TOP) && (color = SferyxUtilities.getColor(elem, attribs, attribute_class = CSS.Attribute.BORDER_TOP)) != transparentColor) {
            return color;
        }
        attribute_class = attribs.getAttribute(CSS.Attribute.BORDER_COLOR) != null && !attribs.getAttribute(CSS.Attribute.BORDER_COLOR).toString().equalsIgnoreCase("Silver") && attribs.isDefined(CSS.Attribute.BORDER_COLOR) ? CSS.Attribute.BORDER_COLOR : (attribs.getAttribute(CSS.Attribute.BORDER) != null && attribs.isDefined(CSS.Attribute.BORDER) ? CSS.Attribute.BORDER : CSS.Attribute.BORDER);
        color = SferyxUtilities.getColor(elem, attribs, attribute_class);
        if (color == transparentColor && (styleValue = SferyxUtilities.getTopBorderStyle(attribs)) != null && styleValue.indexOf("none") == -1) {
            return Color.black;
        }
        return color;
    }

    public static Color getBottomBorderColor(Element elem, AttributeSet attribs) {
        String styleValue;
        Object attribute_class;
        Color color;
        if (attribs.getAttribute("border-bottom-color") != null && attribs.isDefined("border-bottom-color") && (color = SferyxUtilities.getColor(elem, attribs, attribute_class = "border-bottom-color")) != transparentColor) {
            return color;
        }
        if (attribs.getAttribute(CSS.Attribute.BORDER_BOTTOM) != null && attribs.isDefined(CSS.Attribute.BORDER_BOTTOM) && (color = SferyxUtilities.getColor(elem, attribs, attribute_class = CSS.Attribute.BORDER_BOTTOM)) != transparentColor) {
            return color;
        }
        attribute_class = attribs.getAttribute(CSS.Attribute.BORDER_COLOR) != null && !attribs.getAttribute(CSS.Attribute.BORDER_COLOR).toString().equalsIgnoreCase("Silver") && attribs.isDefined(CSS.Attribute.BORDER_COLOR) ? CSS.Attribute.BORDER_COLOR : (attribs.getAttribute(CSS.Attribute.BORDER) != null && attribs.isDefined(CSS.Attribute.BORDER) ? CSS.Attribute.BORDER : CSS.Attribute.BORDER);
        color = SferyxUtilities.getColor(elem, attribs, attribute_class);
        if (color == transparentColor && (styleValue = SferyxUtilities.getBottomBorderStyle(attribs)) != null && styleValue.indexOf("none") == -1) {
            return Color.black;
        }
        return color;
    }

    public static Color getRightBorderColor(Element elem, AttributeSet attribs) {
        String styleValue;
        Object attribute_class;
        Color color;
        if (attribs.getAttribute("border-right-color") != null && attribs.isDefined("border-right-color") && (color = SferyxUtilities.getColor(elem, attribs, attribute_class = "border-right-color")) != transparentColor) {
            return color;
        }
        if (attribs.getAttribute(CSS.Attribute.BORDER_RIGHT) != null && attribs.isDefined(CSS.Attribute.BORDER_RIGHT) && (color = SferyxUtilities.getColor(elem, attribs, attribute_class = CSS.Attribute.BORDER_RIGHT)) != transparentColor) {
            return color;
        }
        attribute_class = attribs.getAttribute(CSS.Attribute.BORDER_COLOR) != null && !attribs.getAttribute(CSS.Attribute.BORDER_COLOR).toString().equalsIgnoreCase("Silver") && attribs.isDefined(CSS.Attribute.BORDER_COLOR) ? CSS.Attribute.BORDER_COLOR : (attribs.getAttribute(CSS.Attribute.BORDER) != null && attribs.isDefined(CSS.Attribute.BORDER) ? CSS.Attribute.BORDER : CSS.Attribute.BORDER);
        color = SferyxUtilities.getColor(elem, attribs, attribute_class);
        if (color == transparentColor && (styleValue = SferyxUtilities.getRightBorderStyle(attribs)) != null && styleValue.indexOf("none") == -1) {
            return Color.black;
        }
        return color;
    }

    public static Color getLeftBorderColor(Element elem, AttributeSet attribs) {
        String styleValue;
        Object attribute_class;
        Color color;
        if (attribs.getAttribute("border-left-color") != null && attribs.isDefined("border-left-color") && (color = SferyxUtilities.getColor(elem, attribs, attribute_class = "border-left-color")) != transparentColor) {
            return color;
        }
        if (attribs.getAttribute(CSS.Attribute.BORDER_LEFT) != null && attribs.isDefined(CSS.Attribute.BORDER_LEFT) && (color = SferyxUtilities.getColor(elem, attribs, attribute_class = CSS.Attribute.BORDER_LEFT)) != transparentColor) {
            return color;
        }
        attribute_class = attribs.getAttribute(CSS.Attribute.BORDER_COLOR) != null && !attribs.getAttribute(CSS.Attribute.BORDER_COLOR).toString().equalsIgnoreCase("Silver") && attribs.isDefined(CSS.Attribute.BORDER_COLOR) ? CSS.Attribute.BORDER_COLOR : (attribs.getAttribute(CSS.Attribute.BORDER) != null && attribs.isDefined(CSS.Attribute.BORDER) ? CSS.Attribute.BORDER : CSS.Attribute.BORDER);
        color = SferyxUtilities.getColor(elem, attribs, attribute_class);
        if (color == transparentColor && (styleValue = SferyxUtilities.getLeftBorderStyle(attribs)) != null && styleValue.indexOf("none") == -1) {
            return Color.black;
        }
        return color;
    }

    public static Color getColor(Element elem, AttributeSet attribs, Object attribute_class) {
        if (attribs.getAttribute(attribute_class) != null) {
            String wholeAttributeString = attribs.getAttribute(attribute_class).toString();
            if (attribute_class == CSS.Attribute.BORDER_COLOR) {
                if (wholeAttributeString != null && wholeAttributeString.indexOf("windowtext") != -1) {
                    return Color.black;
                }
                return ((HTMLDocument)elem.getDocument()).getStyleSheet().stringToColor(wholeAttributeString);
            }
            if (wholeAttributeString.indexOf("rgb(") != -1) {
                int start = wholeAttributeString.indexOf("rgb(");
                int end = wholeAttributeString.indexOf(")", start);
                return ((HTMLDocument)elem.getDocument()).getStyleSheet().stringToColor(wholeAttributeString.substring(start, end + 1));
            }
            StringTokenizer st = new StringTokenizer(wholeAttributeString);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.startsWith("#")) {
                    return ((HTMLDocument)elem.getDocument()).getStyleSheet().stringToColor(token);
                }
                if (token.equalsIgnoreCase("Black")) {
                    return ((HTMLDocument)elem.getDocument()).getStyleSheet().stringToColor("000000");
                }
                if (token.equalsIgnoreCase("Silver")) {
                    return ((HTMLDocument)elem.getDocument()).getStyleSheet().stringToColor("C0C0C0");
                }
                if (token.equalsIgnoreCase("Gray")) {
                    return ((HTMLDocument)elem.getDocument()).getStyleSheet().stringToColor("808080");
                }
                if (token.equalsIgnoreCase("White")) {
                    return ((HTMLDocument)elem.getDocument()).getStyleSheet().stringToColor("FFFFFF");
                }
                if (token.equalsIgnoreCase("Maroon")) {
                    return ((HTMLDocument)elem.getDocument()).getStyleSheet().stringToColor("800000");
                }
                if (token.equalsIgnoreCase("Red")) {
                    return ((HTMLDocument)elem.getDocument()).getStyleSheet().stringToColor("FF0000");
                }
                if (token.equalsIgnoreCase("Purple")) {
                    return ((HTMLDocument)elem.getDocument()).getStyleSheet().stringToColor("800080");
                }
                if (token.equalsIgnoreCase("Fuchsia")) {
                    return ((HTMLDocument)elem.getDocument()).getStyleSheet().stringToColor("FF00FF");
                }
                if (token.equalsIgnoreCase("Green")) {
                    return ((HTMLDocument)elem.getDocument()).getStyleSheet().stringToColor("008000");
                }
                if (token.equalsIgnoreCase("Lime")) {
                    return ((HTMLDocument)elem.getDocument()).getStyleSheet().stringToColor("00FF00");
                }
                if (token.equalsIgnoreCase("Olive")) {
                    return ((HTMLDocument)elem.getDocument()).getStyleSheet().stringToColor("808000");
                }
                if (token.equalsIgnoreCase("Yellow")) {
                    return ((HTMLDocument)elem.getDocument()).getStyleSheet().stringToColor("FFFF00");
                }
                if (token.equalsIgnoreCase("Navy")) {
                    return ((HTMLDocument)elem.getDocument()).getStyleSheet().stringToColor("000080");
                }
                if (token.equalsIgnoreCase("Blue")) {
                    return ((HTMLDocument)elem.getDocument()).getStyleSheet().stringToColor("0000FF");
                }
                if (token.equalsIgnoreCase("Teal")) {
                    return ((HTMLDocument)elem.getDocument()).getStyleSheet().stringToColor("008080");
                }
                if (token.equalsIgnoreCase("Aqua")) {
                    return ((HTMLDocument)elem.getDocument()).getStyleSheet().stringToColor("00FFFF");
                }
                if (token.equalsIgnoreCase("Orange")) {
                    return ((HTMLDocument)elem.getDocument()).getStyleSheet().stringToColor("FFA500");
                }
                if (!token.equalsIgnoreCase("windowtext")) continue;
                return ((HTMLDocument)elem.getDocument()).getStyleSheet().stringToColor("000000");
            }
            if (wholeAttributeString.indexOf("none") == -1) {
                return Color.black;
            }
            String styleValue = SferyxUtilities.getBorderStlyeValue(attribs, CSS.Attribute.BORDER_STYLE);
            if (styleValue != null && styleValue.indexOf("none") == -1) {
                return Color.black;
            }
            return transparentColor;
        }
        String styleValue = SferyxUtilities.getBorderStlyeValue(attribs, CSS.Attribute.BORDER_STYLE);
        if (styleValue != null && styleValue.indexOf("none") == -1) {
            return Color.black;
        }
        return transparentColor;
    }

    public static String getTopBorderStyle(AttributeSet attribs) {
        Object attribute_class = attribs.getAttribute("border-top-style") != null && attribs.isDefined("border-top-style") ? "border-top-style" : (attribs.getAttribute(CSS.Attribute.BORDER_TOP) != null && attribs.isDefined(CSS.Attribute.BORDER_TOP) ? CSS.Attribute.BORDER_TOP : (attribs.getAttribute(CSS.Attribute.BORDER_STYLE) != null && attribs.isDefined(CSS.Attribute.BORDER_STYLE) ? CSS.Attribute.BORDER_STYLE : CSS.Attribute.BORDER));
        return SferyxUtilities.getBorderStlyeValue(attribs, attribute_class);
    }

    public static String getBottomBorderStyle(AttributeSet attribs) {
        Object attribute_class = attribs.getAttribute("border-bottom-style") != null && attribs.isDefined("border-bottom-style") ? "border-bottom-style" : (attribs.getAttribute(CSS.Attribute.BORDER_BOTTOM) != null && attribs.isDefined(CSS.Attribute.BORDER_BOTTOM) ? CSS.Attribute.BORDER_BOTTOM : (attribs.getAttribute(CSS.Attribute.BORDER_STYLE) != null && attribs.isDefined(CSS.Attribute.BORDER_STYLE) ? CSS.Attribute.BORDER_STYLE : CSS.Attribute.BORDER));
        return SferyxUtilities.getBorderStlyeValue(attribs, attribute_class);
    }

    public static String getLeftBorderStyle(AttributeSet attribs) {
        Object attribute_class = attribs.getAttribute("border-left-style") != null && attribs.isDefined("border-left-style") ? "border-left-style" : (attribs.getAttribute(CSS.Attribute.BORDER_LEFT) != null && attribs.isDefined(CSS.Attribute.BORDER_LEFT) ? CSS.Attribute.BORDER_LEFT : (attribs.getAttribute(CSS.Attribute.BORDER_STYLE) != null && attribs.isDefined(CSS.Attribute.BORDER_STYLE) ? CSS.Attribute.BORDER_STYLE : CSS.Attribute.BORDER));
        return SferyxUtilities.getBorderStlyeValue(attribs, attribute_class);
    }

    public static String getRightBorderStyle(AttributeSet attribs) {
        Object attribute_class = attribs.getAttribute("border-right-style") != null && attribs.isDefined("border-right-style") ? "border-right-style" : (attribs.getAttribute(CSS.Attribute.BORDER_RIGHT) != null && attribs.isDefined(CSS.Attribute.BORDER_RIGHT) ? CSS.Attribute.BORDER_RIGHT : (attribs.getAttribute(CSS.Attribute.BORDER_STYLE) != null && attribs.isDefined(CSS.Attribute.BORDER_STYLE) ? CSS.Attribute.BORDER_STYLE : CSS.Attribute.BORDER));
        return SferyxUtilities.getBorderStlyeValue(attribs, attribute_class);
    }

    public static String getBorderStlyeValue(AttributeSet attribs, Object attribute_class) {
        if (attribs.getAttribute(attribute_class) == null) {
            return "none";
        }
        String border_width_str = attribs.getAttribute(attribute_class).toString();
        if (border_width_str.indexOf("none") != -1) {
            return "none";
        }
        if (border_width_str.indexOf("hidden") != -1) {
            return "hidden";
        }
        if (border_width_str.indexOf("dotted") != -1) {
            return "dotted";
        }
        if (border_width_str.indexOf("dashed") != -1) {
            return "dashed";
        }
        if (border_width_str.indexOf("solid") != -1) {
            return "solid";
        }
        if (border_width_str.indexOf("double") != -1) {
            return "double";
        }
        if (border_width_str.indexOf("groove") != -1) {
            return "groove";
        }
        if (border_width_str.indexOf("ridge") != -1) {
            return "ridge";
        }
        if (border_width_str.indexOf("inset") != -1) {
            return "inset";
        }
        if (border_width_str.indexOf("outset") != -1) {
            return "outset";
        }
        return "solid";
    }

    public static int getCellTopBorderSize(AttributeSet attribs, Element elem) {
        CSS.Attribute attribute_class = attribs.getAttribute(CSS.Attribute.BORDER_TOP_WIDTH) != null && attribs.isDefined(CSS.Attribute.BORDER_TOP_WIDTH) ? CSS.Attribute.BORDER_TOP_WIDTH : (attribs.getAttribute(CSS.Attribute.BORDER_TOP) != null && attribs.isDefined(CSS.Attribute.BORDER_TOP) ? CSS.Attribute.BORDER_TOP : (attribs.getAttribute(CSS.Attribute.BORDER_WIDTH) != null && attribs.isDefined(CSS.Attribute.BORDER_WIDTH) ? CSS.Attribute.BORDER_WIDTH : CSS.Attribute.BORDER));
        int thikness = SferyxUtilities.getBorderThiknessValue(attribs, attribute_class, elem);
        if (thikness <= 0 && (attribute_class == CSS.Attribute.BORDER_TOP_WIDTH || attribute_class == CSS.Attribute.BORDER_TOP)) {
            return SferyxUtilities.getBorderThiknessValue(attribs, CSS.Attribute.BORDER, elem);
        }
        return thikness;
    }

    public static int getCellRightBorderSize(AttributeSet attribs, Element elem) {
        CSS.Attribute attribute_class = attribs.getAttribute(CSS.Attribute.BORDER_RIGHT_WIDTH) != null && attribs.isDefined(CSS.Attribute.BORDER_RIGHT_WIDTH) ? CSS.Attribute.BORDER_RIGHT_WIDTH : (attribs.getAttribute(CSS.Attribute.BORDER_RIGHT) != null && attribs.isDefined(CSS.Attribute.BORDER_RIGHT) ? CSS.Attribute.BORDER_RIGHT : (attribs.getAttribute(CSS.Attribute.BORDER_WIDTH) != null && attribs.isDefined(CSS.Attribute.BORDER_WIDTH) ? CSS.Attribute.BORDER_WIDTH : CSS.Attribute.BORDER));
        int thikness = SferyxUtilities.getBorderThiknessValue(attribs, attribute_class, elem);
        if (thikness <= 0 && (attribute_class == CSS.Attribute.BORDER_RIGHT_WIDTH || attribute_class == CSS.Attribute.BORDER_RIGHT)) {
            return SferyxUtilities.getBorderThiknessValue(attribs, CSS.Attribute.BORDER, elem);
        }
        return thikness;
    }

    public static int getCellLeftBorderSize(AttributeSet attribs, Element elem) {
        CSS.Attribute attribute_class = attribs.getAttribute(CSS.Attribute.BORDER_LEFT_WIDTH) != null && attribs.isDefined(CSS.Attribute.BORDER_LEFT_WIDTH) ? CSS.Attribute.BORDER_LEFT_WIDTH : (attribs.getAttribute(CSS.Attribute.BORDER_LEFT) != null && attribs.isDefined(CSS.Attribute.BORDER_LEFT) ? CSS.Attribute.BORDER_LEFT : (attribs.getAttribute(CSS.Attribute.BORDER_WIDTH) != null && attribs.isDefined(CSS.Attribute.BORDER_WIDTH) ? CSS.Attribute.BORDER_WIDTH : CSS.Attribute.BORDER));
        int thikness = SferyxUtilities.getBorderThiknessValue(attribs, attribute_class, elem);
        if (thikness <= 0 && (attribute_class == CSS.Attribute.BORDER_LEFT_WIDTH || attribute_class == CSS.Attribute.BORDER_LEFT)) {
            return SferyxUtilities.getBorderThiknessValue(attribs, CSS.Attribute.BORDER, elem);
        }
        return thikness;
    }

    public static int getBorderThiknessValue(AttributeSet attribs, Object attribute_class, Element elem) {
        if (attribs == null || attribute_class == null) {
            return 0;
        }
        if (attribs.getAttribute(attribute_class) == null) {
            return 0;
        }
        if (attribs != null && attribute_class != null && !attribs.containsAttribute(attribute_class, attribs.getAttribute(attribute_class))) {
            return 0;
        }
        Object css_border_width = null;
        if (css_border_width == null) {
            css_border_width = attribs.getAttribute(attribute_class);
        }
        if (css_border_width == null) {
            return -1;
        }
        String border_width_str = css_border_width.toString();
        if (border_width_str.indexOf("pt") != -1) {
            if ((border_width_str = border_width_str.substring(0, border_width_str.indexOf("pt")).trim()).indexOf(" ") != -1) {
                int indexOfSpace = border_width_str.lastIndexOf(" ");
                border_width_str = border_width_str.substring(indexOfSpace).trim();
            }
            try {
                float borderSizeFloat = Float.parseFloat(border_width_str);
                int borderSize = Math.round(borderSizeFloat);
                return borderSize;
            }
            catch (Throwable thr) {}
        } else if (border_width_str.indexOf("px") != -1) {
            if ((border_width_str = border_width_str.substring(0, border_width_str.indexOf("px")).trim()).indexOf(" ") != -1) {
                int indexOfSpace = border_width_str.lastIndexOf(" ");
                border_width_str = border_width_str.substring(indexOfSpace).trim();
            }
            try {
                float borderSizeFloat = Float.parseFloat(border_width_str);
                int borderSize = Math.round(borderSizeFloat);
                return borderSize;
            }
            catch (Throwable thr) {}
        } else {
            if (border_width_str.indexOf("thin") != -1) {
                return 2;
            }
            if (border_width_str.indexOf("medium") != -1) {
                return 5;
            }
            if (border_width_str.indexOf("thick") != -1) {
                return 10;
            }
            if (border_width_str.indexOf("solid") != -1) {
                return 4;
            }
        }
        try {
            if (!SferyxUtilities.isNumeric(border_width_str)) {
                return 1;
            }
            float intValueFloat = Float.parseFloat(border_width_str);
            int intValue = Math.round(intValueFloat);
            return intValue;
        }
        catch (Throwable thr) {
            return 0;
        }
    }

    public static int getCellBottomBorderSize(AttributeSet attribs, Element elem) {
        CSS.Attribute attribute_class = attribs.getAttribute(CSS.Attribute.BORDER_BOTTOM_WIDTH) != null && attribs.isDefined(CSS.Attribute.BORDER_BOTTOM_WIDTH) ? CSS.Attribute.BORDER_BOTTOM_WIDTH : (attribs.getAttribute(CSS.Attribute.BORDER_BOTTOM) != null && attribs.isDefined(CSS.Attribute.BORDER_BOTTOM) ? CSS.Attribute.BORDER_BOTTOM : (attribs.getAttribute(CSS.Attribute.BORDER_WIDTH) != null && attribs.isDefined(CSS.Attribute.BORDER_WIDTH) ? CSS.Attribute.BORDER_WIDTH : CSS.Attribute.BORDER));
        int thikness = SferyxUtilities.getBorderThiknessValue(attribs, attribute_class, elem);
        if (thikness <= 0 && (attribute_class == CSS.Attribute.BORDER_BOTTOM_WIDTH || attribute_class == CSS.Attribute.BORDER_BOTTOM)) {
            return SferyxUtilities.getBorderThiknessValue(attribs, CSS.Attribute.BORDER, elem);
        }
        return thikness;
    }

    public static String getURLFromStyleDeclaration(String declaration) {
        if (declaration != null && declaration.toLowerCase().indexOf("url(") != -1) {
            int start = declaration.toLowerCase().indexOf("url(");
            int end = declaration.indexOf(")", start);
            declaration = declaration.substring(start, end + 1);
            return declaration;
        }
        return declaration;
    }

    public static String convertStyleDeclarationtoURL(String declaration) {
        if (declaration.indexOf("url(") != -1) {
            try {
                if (declaration.indexOf("\"") != -1) {
                    declaration = declaration.substring(declaration.indexOf("\""), declaration.lastIndexOf("\""));
                    return declaration;
                }
                if (declaration.indexOf("'") != -1) {
                    declaration = declaration.substring(declaration.indexOf("'"), declaration.lastIndexOf("'"));
                    return declaration;
                }
                declaration = declaration.substring(declaration.indexOf("url(") + 4, declaration.lastIndexOf(")"));
                return declaration;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return declaration;
    }

    public static Element getSelectedTableElement(Vector selectedTableCells) {
        if (!selectedTableCells.isEmpty()) {
            Element firstCell = (Element)selectedTableCells.elementAt(0);
            EditorHTMLDocument doc = (EditorHTMLDocument)firstCell.getDocument();
            return doc.getTableElement(firstCell.getStartOffset());
        }
        return null;
    }

    public static String dumpSelectedTableCells(Vector selectedTableCells) {
        String selectedCellsString = "";
        Element tableElement = SferyxUtilities.getSelectedTableElement(selectedTableCells);
        if (tableElement != null) {
            try {
                for (int i = 0; i < tableElement.getElementCount(); ++i) {
                    Element childElement = tableElement.getElement(i);
                    boolean addedTR = false;
                    if (!childElement.getAttributes().getAttribute(StyleConstants.NameAttribute).equals(HTML.Tag.TR)) continue;
                    for (int j = 0; j < childElement.getElementCount(); ++j) {
                        Element cellElement = childElement.getElement(j);
                        if (!selectedTableCells.contains(cellElement)) continue;
                        if (!addedTR) {
                            selectedCellsString = selectedCellsString + "<tr>";
                            addedTR = true;
                        }
                        selectedCellsString = selectedCellsString + SferyxUtilities.dumpDocumentElement(cellElement);
                    }
                    if (!addedTR) continue;
                    selectedCellsString = selectedCellsString + "</tr>";
                    addedTR = false;
                }
            }
            catch (Throwable thr) {
                // empty catch block
            }
        }
        AttributeSet attribs = tableElement.getAttributes();
        AttributeSetTranslator ast = new AttributeSetTranslator();
        AttributeSet attr = ast.convertToHTML(attribs, ast.oConvAttr);
        String attributeString = "";
        Enumeration<?> names = attr.getAttributeNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            if (name == StyleConstants.NameAttribute) continue;
            attributeString = attributeString + " " + name + "=\"" + attr.getAttribute(name) + "\"";
        }
        return "<table " + attributeString + ">" + selectedCellsString + "</table>";
    }

    public static String getStartTagStringWithoutAttribute(Element elem, Object attrib) {
        AttributeSet attribs = elem.getAttributes();
        AttributeSetTranslator ast = new AttributeSetTranslator();
        ast.convertToHTML40(attribs, ast.oConvAttr);
        MutableAttributeSet attr = ast.oConvAttr;
        String attributeString = "";
        Enumeration<?> names = attr.getAttributeNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            if (name.equals(attrib) || name == StyleConstants.NameAttribute || name == EditorHTMLDocument.sferyxInternalEmbeddedTagsCount || name == EditorHTMLDocument.realClassName || name == EditorHTMLDocument.realIDName) continue;
            if (name == HTML.Attribute.CLASS && elem.getAttributes().getAttribute(EditorHTMLDocument.realClassName) != null) {
                attributeString = attributeString + " " + name + "=\"" + attr.getAttribute(EditorHTMLDocument.realClassName) + "\"";
                continue;
            }
            if (name == HTML.Attribute.ID && elem.getAttributes().getAttribute(EditorHTMLDocument.realIDName) != null) {
                attributeString = attributeString + " " + name + "=\"" + attr.getAttribute(EditorHTMLDocument.realIDName) + "\"";
                continue;
            }
            attributeString = attributeString + " " + name + "=\"" + attr.getAttribute(name) + "\"";
        }
        return "<" + elem.getName() + " " + attributeString + ">";
    }

    public static String getStartTagString(Element elem) {
        AttributeSet attribs = elem.getAttributes();
        AttributeSetTranslator ast = new AttributeSetTranslator();
        ast.convertToHTML40(attribs, ast.oConvAttr);
        MutableAttributeSet attr = ast.oConvAttr;
        String attributeString = "";
        Enumeration<?> names = attr.getAttributeNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            if (name == StyleConstants.NameAttribute || name == EditorHTMLDocument.sferyxInternalEmbeddedTagsCount || name == EditorHTMLDocument.realClassName || name == EditorHTMLDocument.realIDName) continue;
            if (name == HTML.Attribute.CLASS && elem.getAttributes().getAttribute(EditorHTMLDocument.realClassName) != null) {
                attributeString = attributeString + " " + name + "=\"" + attr.getAttribute(EditorHTMLDocument.realClassName) + "\"";
                continue;
            }
            if (name == HTML.Attribute.ID && elem.getAttributes().getAttribute(EditorHTMLDocument.realIDName) != null) {
                attributeString = attributeString + " " + name + "=\"" + attr.getAttribute(EditorHTMLDocument.realIDName) + "\"";
                continue;
            }
            attributeString = attributeString + " " + name + "=\"" + attr.getAttribute(name) + "\"";
        }
        return "<" + elem.getName() + " " + attributeString + ">";
    }

    public static String getStartTagStringWithoutSomeAttributes(Element elem, Object[] skippedAttrbiutes) {
        AttributeSet attribs = elem.getAttributes();
        AttributeSetTranslator ast = new AttributeSetTranslator();
        AttributeSet attr = ast.convertToHTML(attribs, ast.oConvAttr);
        String attributeString = "";
        Vector<Object> skip = new Vector<Object>();
        if (skippedAttrbiutes != null) {
            for (int i = 0; i < skippedAttrbiutes.length; ++i) {
                skip.addElement(skippedAttrbiutes[i]);
            }
        }
        Enumeration<?> names = attr.getAttributeNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            if (name == StyleConstants.NameAttribute || name == EditorHTMLDocument.sferyxInternalEmbeddedTagsCount || name == EditorHTMLDocument.realClassName || name == EditorHTMLDocument.realIDName) continue;
            if (name == HTML.Attribute.CLASS && elem.getAttributes().getAttribute(EditorHTMLDocument.realClassName) != null) {
                attributeString = attributeString + " " + name + "=\"" + attr.getAttribute(EditorHTMLDocument.realClassName) + "\"";
                continue;
            }
            if (name == HTML.Attribute.ID && elem.getAttributes().getAttribute(EditorHTMLDocument.realIDName) != null) {
                attributeString = attributeString + " " + name + "=\"" + attr.getAttribute(EditorHTMLDocument.realIDName) + "\"";
                continue;
            }
            if (skip.contains(name)) continue;
            attributeString = attributeString + " " + name + "=\"" + attr.getAttribute(name) + "\"";
        }
        return "<" + elem.getName() + " " + attributeString + ">";
    }

    public static int getNestedTablesDepth(int offset, EditorHTMLDocument htdoc) {
        Element topTableElement = htdoc.getTableElement(offset);
        if (topTableElement == null) {
            return 0;
        }
        int tableCount = 1;
        Element e = topTableElement.getParentElement();
        while ((e = e.getParentElement()) != null) {
            if (!SferyxUtilities.matchNameAttribute(e, HTML.Tag.TABLE)) continue;
            ++tableCount;
        }
        return tableCount;
    }

    public static int getAbsolutePositioningReferenceOffsetX(View v) {
        int offset = 0;
        View refParent = SferyxUtilities.getAbsolutePositioningReferenceParent(v);
        View parent = v.getParent();
        if (v.getElement().isLeaf()) {
            parent = SferyxUtilities.getParentParagraph(v);
        }
        while (parent != refParent) {
            if (parent.getParent() != null && parent.getParent() instanceof CustomLayoutBoxView) {
                offset += ((CustomLayoutBoxView)parent.getParent()).getOffset(0, SferyxUtilities.indexOfView(parent));
                if (parent instanceof CustomLayoutBoxView) {
                    offset += ((CustomLayoutBoxView)parent).getLeftPadding();
                } else if (parent instanceof CustomParagraphView) {
                    offset += ((CustomParagraphView)parent).getLeftPadding();
                }
            }
            if ((parent = parent.getParent()) != null) continue;
        }
        if (refParent != null && refParent instanceof CSSLayoutViews) {
            if (refParent instanceof CustomLayoutBoxView) {
                offset += ((CustomLayoutBoxView)refParent).getLeftPadding();
            } else if (refParent instanceof CustomParagraphView) {
                offset += ((CustomParagraphView)refParent).getLeftPadding();
            }
        }
        return offset;
    }

    public static int getAbsolutePositioningReferenceOffsetX_(View v) {
        int offset = 0;
        View parent = null;
        if (v.getElement().isLeaf()) {
            parent = SferyxUtilities.getParentParagraph(v);
        } else {
            if (!(v.getParent() instanceof CSSLayoutViews)) {
                return offset;
            }
            parent = v.getParent();
        }
        if (parent.getParent() instanceof CustomLayoutBoxView) {
            // empty if block
        }
        if (parent instanceof CustomLayoutBoxView) {
            offset += ((CustomLayoutBoxView)parent).getLeftInset();
        }
        if (((CSSLayoutViews)((Object)parent)).isAbsolutePositioning() || ((CSSLayoutViews)((Object)parent)).isRelativePositioning()) {
            return offset;
        }
        do {
            if (!(parent.getParent() instanceof CSSLayoutViews)) {
                return offset;
            }
            if (parent.getParent() == null) {
                return offset;
            }
            if (parent.getParent() instanceof CustomLayoutBoxView) {
                offset += ((CustomLayoutBoxView)parent.getParent()).getOffset(0, SferyxUtilities.indexOfView(parent));
            }
            if ((parent = parent.getParent()) != null) continue;
            return offset;
        } while (!((CSSLayoutViews)((Object)parent)).isAbsolutePositioning() && !((CSSLayoutViews)((Object)parent)).isRelativePositioning());
        return offset;
    }

    public static int getAbsolutePositioningReferenceOffset(View v) {
        int offset = 0;
        View refParent = SferyxUtilities.getAbsolutePositioningReferenceParent(v);
        View parent = v.getParent();
        if (v.getElement().isLeaf()) {
            parent = SferyxUtilities.getParentParagraph(v);
        }
        while (parent != refParent) {
            if (parent.getParent() != null && parent.getParent() instanceof CustomLayoutBoxView) {
                offset += ((CustomLayoutBoxView)parent.getParent()).getOffset(1, SferyxUtilities.indexOfView(parent));
                if (parent instanceof CustomLayoutBoxView) {
                    offset += ((CustomLayoutBoxView)parent).getTopPadding();
                } else if (parent instanceof CustomParagraphView) {
                    offset += ((CustomParagraphView)parent).getTopPadding();
                }
            }
            if ((parent = parent.getParent()) != null) continue;
        }
        if (refParent != null && refParent instanceof CSSLayoutViews) {
            if (refParent instanceof CustomLayoutBoxView) {
                offset += ((CustomLayoutBoxView)refParent).getTopPadding();
            } else if (refParent instanceof CustomParagraphView) {
                offset += ((CustomParagraphView)refParent).getTopPadding();
            }
        }
        return offset;
    }

    public static int getAbsolutePositioningReferenceOffset_(View v) {
        int offset = 0;
        View parent = null;
        if (v.getElement().isLeaf()) {
            parent = SferyxUtilities.getParentParagraph(v);
        } else {
            if (!(v.getParent() instanceof CSSLayoutViews)) {
                return offset;
            }
            parent = v.getParent();
        }
        if (parent.getParent() instanceof CustomLayoutBoxView) {
            // empty if block
        }
        if (parent instanceof CustomLayoutBoxView) {
            offset += ((CustomLayoutBoxView)parent).getTopPadding();
        }
        if (((CSSLayoutViews)((Object)parent)).isAbsolutePositioning() || ((CSSLayoutViews)((Object)parent)).isRelativePositioning()) {
            if (parent.getParent() instanceof CustomLayoutBoxView) {
                // empty if block
            }
            return offset;
        }
        do {
            if (!(parent.getParent() instanceof CSSLayoutViews)) {
                return offset;
            }
            if (parent.getParent() == null) {
                return offset;
            }
            if (parent.getParent() instanceof CustomLayoutBoxView) {
                offset += ((CustomLayoutBoxView)parent.getParent()).getOffset(1, SferyxUtilities.indexOfView(parent));
                offset += ((CustomLayoutBoxView)parent.getParent()).getTopPadding();
            }
            if ((parent = parent.getParent()) != null) continue;
            return offset;
        } while (!((CSSLayoutViews)((Object)parent)).isAbsolutePositioning() && !((CSSLayoutViews)((Object)parent)).isRelativePositioning());
        return offset;
    }

    public static int getX(View view) {
        AttributeSet elementAttributes = view.getElement().getAttributes();
        if (elementAttributes.getAttribute("left") != null && elementAttributes.isDefined("left")) {
            String value = (String)elementAttributes.getAttribute("left");
            if (value != null && value.indexOf("%") != -1) {
                value = value.trim();
                value = value.substring(0, value.indexOf("%"));
                float numValue = Float.parseFloat(value);
                int parentSpan = 0;
                if (view.getParent().getParent() instanceof CustomLayoutBoxView) {
                    parentSpan = ((CustomLayoutBoxView)view.getParent().getParent()).getSpan(0, SferyxUtilities.indexOfView(view.getParent()));
                } else if (view.getParent().getParent() instanceof CustomParagraphView) {
                    parentSpan = ((CustomParagraphView)view.getParent().getParent()).getSpan(0, SferyxUtilities.indexOfView(view.getParent()));
                }
                return (int)(numValue * (float)parentSpan / 100.0f);
            }
            return (int)SferyxUtilities.getNumberFromCSString(value);
        }
        if (elementAttributes.getAttribute("right") != null && elementAttributes.isDefined("right")) {
            String value = (String)elementAttributes.getAttribute("right");
            int parentSpan = 0;
            int span = 0;
            if (view.getParent() instanceof CustomLayoutBoxView) {
                span = ((CustomLayoutBoxView)view.getParent()).getSpan(0, SferyxUtilities.indexOfView(view));
            } else if (view.getParent() instanceof Row) {
                span = ((Row)view.getParent()).getSpan(0, SferyxUtilities.indexOfView(view));
            }
            if (value != null && value.indexOf("%") != -1) {
                value = value.trim();
                value = value.substring(0, value.indexOf("%"));
                float numValue = Float.parseFloat(value);
                if (view.getParent().getParent() instanceof CustomLayoutBoxView) {
                    parentSpan = ((CustomLayoutBoxView)view.getParent().getParent()).getSpan(0, SferyxUtilities.indexOfView(view.getParent()));
                } else if (view.getParent().getParent() instanceof CustomParagraphView) {
                    parentSpan = ((CustomParagraphView)view.getParent().getParent()).getSpan(0, SferyxUtilities.indexOfView(view.getParent()));
                }
                return -((int)(numValue * (float)parentSpan / 100.0f));
            }
            return -((int)SferyxUtilities.getNumberFromCSString(value));
        }
        AttributeSet viewAttributes = view.getAttributes();
        if (viewAttributes.getAttribute("left") != null && viewAttributes.isDefined("left")) {
            String value = (String)viewAttributes.getAttribute("left");
            if (value != null && value.indexOf("%") != -1) {
                value = value.trim();
                value = value.substring(0, value.indexOf("%"));
                float numValue = Float.parseFloat(value);
                int parentSpan = 0;
                if (view.getParent().getParent() instanceof CustomLayoutBoxView) {
                    parentSpan = ((CustomLayoutBoxView)view.getParent().getParent()).getSpan(0, SferyxUtilities.indexOfView(view.getParent()));
                } else if (view.getParent().getParent() instanceof CustomParagraphView) {
                    parentSpan = ((CustomParagraphView)view.getParent().getParent()).getSpan(0, SferyxUtilities.indexOfView(view.getParent()));
                }
                return (int)(numValue * (float)parentSpan / 100.0f);
            }
            return (int)SferyxUtilities.getNumberFromCSString(value);
        }
        if (viewAttributes.getAttribute("right") != null && viewAttributes.isDefined("right")) {
            String value = (String)viewAttributes.getAttribute("right");
            int parentSpan = 0;
            int span = 0;
            if (view.getParent() instanceof CustomLayoutBoxView) {
                span = ((CustomLayoutBoxView)view.getParent()).getSpan(0, SferyxUtilities.indexOfView(view));
            } else if (view.getParent() instanceof Row) {
                span = ((Row)view.getParent()).getSpan(0, SferyxUtilities.indexOfView(view));
            }
            if (value != null && value.indexOf("%") != -1) {
                value = value.trim();
                value = value.substring(0, value.indexOf("%"));
                float numValue = Float.parseFloat(value);
                if (view.getParent().getParent() instanceof CustomLayoutBoxView) {
                    parentSpan = ((CustomLayoutBoxView)view.getParent().getParent()).getSpan(0, SferyxUtilities.indexOfView(view.getParent()));
                } else if (view.getParent().getParent() instanceof CustomParagraphView) {
                    parentSpan = ((CustomParagraphView)view.getParent().getParent()).getSpan(0, SferyxUtilities.indexOfView(view.getParent()));
                }
                return -((int)(numValue * (float)parentSpan / 100.0f));
            }
            return -((int)SferyxUtilities.getNumberFromCSString(value));
        }
        return 0;
    }

    public static int getY(View view) {
        try {
            AttributeSet elementAttributes = view.getElement().getAttributes();
            if (elementAttributes.getAttribute("top") != null && elementAttributes.isDefined("top")) {
                String value = (String)elementAttributes.getAttribute("top");
                if (value != null && value.indexOf("%") != -1) {
                    value = value.trim();
                    value = value.substring(0, value.indexOf("%"));
                    float numValue = Float.parseFloat(value);
                    int parentSpan = 0;
                    if (view.getParent().getParent() instanceof CustomLayoutBoxView) {
                        parentSpan = ((CustomLayoutBoxView)view.getParent().getParent()).getSpan(1, SferyxUtilities.indexOfView(view.getParent()));
                    } else if (view.getParent().getParent() instanceof CustomParagraphView) {
                        parentSpan = ((CustomParagraphView)view.getParent().getParent()).getSpan(1, SferyxUtilities.indexOfView(view.getParent()));
                    }
                    return (int)(numValue * (float)parentSpan / 100.0f);
                }
                return (int)SferyxUtilities.getNumberFromCSString((String)elementAttributes.getAttribute("top"));
            }
            if (elementAttributes.getAttribute("bottom") != null && elementAttributes.isDefined("bottom")) {
                int span = 0;
                if (view.getParent() instanceof CustomLayoutBoxView) {
                    span = ((CustomLayoutBoxView)view.getParent()).getSpan(1, SferyxUtilities.indexOfView(view));
                } else if (view.getParent() instanceof Row) {
                    span = ((Row)view.getParent()).getSpan(1, SferyxUtilities.indexOfView(view));
                }
                String value = (String)elementAttributes.getAttribute("bottom");
                if (value != null && value.indexOf("%") != -1) {
                    value = value.trim();
                    value = value.substring(0, value.indexOf("%"));
                    float numValue = Float.parseFloat(value);
                    int parentSpan = 0;
                    if (view.getParent().getParent() instanceof CustomLayoutBoxView) {
                        parentSpan = ((CustomLayoutBoxView)view.getParent().getParent()).getSpan(1, SferyxUtilities.indexOfView(view.getParent()));
                    } else if (view.getParent().getParent() instanceof CustomParagraphView) {
                        parentSpan = ((CustomParagraphView)view.getParent().getParent()).getSpan(1, SferyxUtilities.indexOfView(view.getParent()));
                    }
                    return -((int)(numValue * (float)parentSpan / 100.0f));
                }
                return -((int)SferyxUtilities.getNumberFromCSString((String)elementAttributes.getAttribute("bottom")));
            }
        }
        catch (Throwable thr) {
            // empty catch block
        }
        try {
            AttributeSet viewAttributes = view.getAttributes();
            if (viewAttributes.getAttribute("top") != null && viewAttributes.isDefined("top")) {
                String value = (String)viewAttributes.getAttribute("top");
                if (value != null && value.indexOf("%") != -1) {
                    value = value.trim();
                    value = value.substring(0, value.indexOf("%"));
                    float numValue = Float.parseFloat(value);
                    int parentSpan = 0;
                    if (view.getParent().getParent() instanceof CustomLayoutBoxView) {
                        parentSpan = ((CustomLayoutBoxView)view.getParent().getParent()).getSpan(1, SferyxUtilities.indexOfView(view.getParent()));
                    } else if (view.getParent().getParent() instanceof CustomParagraphView) {
                        parentSpan = ((CustomParagraphView)view.getParent().getParent()).getSpan(1, SferyxUtilities.indexOfView(view.getParent()));
                    }
                    return (int)(numValue * (float)parentSpan / 100.0f);
                }
                return (int)SferyxUtilities.getNumberFromCSString((String)viewAttributes.getAttribute("top"));
            }
            if (viewAttributes.getAttribute("bottom") != null && viewAttributes.isDefined("bottom")) {
                String value = (String)viewAttributes.getAttribute("bottom");
                int span = ((CustomLayoutBoxView)view.getParent()).getSpan(1, SferyxUtilities.indexOfView(view));
                if (value != null && value.indexOf("%") != -1) {
                    value = value.trim();
                    value = value.substring(0, value.indexOf("%"));
                    float numValue = Float.parseFloat(value);
                    int parentSpan = 0;
                    if (view.getParent().getParent() instanceof CustomLayoutBoxView) {
                        parentSpan = ((CustomLayoutBoxView)view.getParent().getParent()).getSpan(1, SferyxUtilities.indexOfView(view.getParent()));
                    } else if (view.getParent().getParent() instanceof CustomParagraphView) {
                        parentSpan = ((CustomParagraphView)view.getParent().getParent()).getSpan(1, SferyxUtilities.indexOfView(view.getParent()));
                    }
                    return -((int)(numValue * (float)parentSpan / 100.0f));
                }
                return -((int)SferyxUtilities.getNumberFromCSString((String)viewAttributes.getAttribute("bottom")));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    public static boolean isDefinedAbsoluteX(View view) {
        AttributeSet elementAttributes = view.getElement().getAttributes();
        if (elementAttributes.getAttribute("left") != null && elementAttributes.isDefined("left")) {
            return true;
        }
        if (elementAttributes.getAttribute("right") != null && elementAttributes.isDefined("right")) {
            return true;
        }
        AttributeSet viewAttributes = view.getAttributes();
        if (viewAttributes.getAttribute("left") != null && viewAttributes.isDefined("left")) {
            return true;
        }
        return viewAttributes.getAttribute("right") != null && viewAttributes.isDefined("right");
    }

    public static boolean isDefinedAbsoluteY(View view) {
        AttributeSet elementAttributes = view.getElement().getAttributes();
        if (elementAttributes.getAttribute("top") != null && elementAttributes.isDefined("top")) {
            return true;
        }
        if (elementAttributes.getAttribute("bottom") != null && elementAttributes.isDefined("bottom")) {
            return true;
        }
        AttributeSet viewAttributes = view.getAttributes();
        if (viewAttributes.getAttribute("top") != null && viewAttributes.isDefined("top")) {
            return true;
        }
        return viewAttributes.getAttribute("bottom") != null && viewAttributes.isDefined("bottom");
    }

    public static int getAbsoluteX(View view) {
        try {
            AttributeSet elementAttributes;
            View referenceParent = SferyxUtilities.getAbsolutePositioningReferenceParent(view);
            int additionalOffset = 0;
            int referenceParentSpan = 0;
            if (view instanceof CSSLayoutViews && ((CSSLayoutViews)((Object)view)).isAbsolutePositioning()) {
                if (!referenceParent.getElement().getName().equalsIgnoreCase("html")) {
                    View parentOfreferenceParent = referenceParent.getParent();
                    if (parentOfreferenceParent != null && parentOfreferenceParent instanceof CustomLayoutBoxView) {
                        additionalOffset -= SferyxUtilities.getAbsolutePositioningReferenceOffsetX(view);
                        referenceParentSpan = ((CustomLayoutBoxView)parentOfreferenceParent).getSpan(0, SferyxUtilities.indexOfView(referenceParent));
                    }
                } else if (referenceParent.getContainer() != null) {
                    referenceParentSpan = ((JEditorPane)referenceParent.getContainer()).getVisibleRect().width;
                }
            }
            if ((elementAttributes = view.getElement().getAttributes()).getAttribute("left") != null && elementAttributes.isDefined("left")) {
                String value = (String)elementAttributes.getAttribute("left");
                if (value != null && value.indexOf("%") != -1) {
                    value = value.trim();
                    value = value.substring(0, value.indexOf("%"));
                    float numValue = Float.parseFloat(value);
                    int parentSpan = 0;
                    if (view.getParent().getParent() instanceof CustomLayoutBoxView) {
                        parentSpan = referenceParentSpan;
                    } else if (view.getParent().getParent() instanceof CustomParagraphView) {
                        parentSpan = referenceParentSpan;
                    }
                    return additionalOffset + (int)(numValue * (float)parentSpan / 100.0f);
                }
                return additionalOffset + (int)SferyxUtilities.getNumberFromCSString(value);
            }
            if (elementAttributes.getAttribute("right") != null && elementAttributes.isDefined("right")) {
                String value = (String)elementAttributes.getAttribute("right");
                int span = 0;
                if (view.getParent() instanceof CustomLayoutBoxView) {
                    span = ((CustomLayoutBoxView)view.getParent()).getSpan(0, SferyxUtilities.indexOfView(view));
                } else if (view.getParent() instanceof Row) {
                    span = ((Row)view.getParent()).getSpan(0, SferyxUtilities.indexOfView(view));
                }
                if (value != null && value.indexOf("%") != -1) {
                    value = value.trim();
                    value = value.substring(0, value.indexOf("%"));
                    float numValue = Float.parseFloat(value);
                    int parentSpan = 0;
                    if (view.getParent().getParent() instanceof CustomLayoutBoxView) {
                        parentSpan = referenceParentSpan;
                    } else if (view.getParent().getParent() instanceof CustomParagraphView) {
                        parentSpan = referenceParentSpan;
                    }
                    return additionalOffset + referenceParentSpan - span - (int)(numValue * (float)parentSpan / 100.0f);
                }
                return additionalOffset + referenceParentSpan - span - (int)SferyxUtilities.getNumberFromCSString(value);
            }
            AttributeSet viewAttributes = view.getAttributes();
            if (viewAttributes.getAttribute("left") != null && viewAttributes.isDefined("left")) {
                String value = (String)viewAttributes.getAttribute("left");
                if (value != null && value.indexOf("%") != -1) {
                    value = value.trim();
                    value = value.substring(0, value.indexOf("%"));
                    float numValue = Float.parseFloat(value);
                    int parentSpan = 0;
                    if (view.getParent().getParent() instanceof CustomLayoutBoxView) {
                        parentSpan = referenceParentSpan;
                    } else if (view.getParent().getParent() instanceof CustomParagraphView) {
                        parentSpan = referenceParentSpan;
                    }
                    return additionalOffset + (int)(numValue * (float)parentSpan / 100.0f);
                }
                return additionalOffset + (int)SferyxUtilities.getNumberFromCSString(value);
            }
            if (viewAttributes.getAttribute("right") != null && viewAttributes.isDefined("right")) {
                String value = (String)viewAttributes.getAttribute("right");
                int span = 0;
                if (view.getParent() instanceof CustomLayoutBoxView) {
                    span = ((CustomLayoutBoxView)view.getParent()).getSpan(0, SferyxUtilities.indexOfView(view));
                } else if (view.getParent() instanceof Row) {
                    span = ((Row)view.getParent()).getSpan(0, SferyxUtilities.indexOfView(view));
                }
                if (value != null && value.indexOf("%") != -1) {
                    value = value.trim();
                    value = value.substring(0, value.indexOf("%"));
                    float numValue = Float.parseFloat(value);
                    int parentSpan = 0;
                    if (view.getParent().getParent() instanceof CustomLayoutBoxView) {
                        parentSpan = referenceParentSpan;
                    } else if (view.getParent().getParent() instanceof CustomParagraphView) {
                        parentSpan = referenceParentSpan;
                    }
                    return additionalOffset + referenceParentSpan - span - (int)(numValue * (float)parentSpan / 100.0f);
                }
                return additionalOffset + referenceParentSpan - span - (int)SferyxUtilities.getNumberFromCSString(value);
            }
        }
        catch (Throwable thr) {
            thr.printStackTrace();
        }
        return 0;
    }

    public static int getAbsoluteY(View view) {
        View referenceParent = SferyxUtilities.getAbsolutePositioningReferenceParent(view);
        int additionalOffset = 0;
        int referenceParentSpan = 0;
        if (view instanceof CSSLayoutViews && ((CSSLayoutViews)((Object)view)).isAbsolutePositioning()) {
            if (!referenceParent.getElement().getName().equalsIgnoreCase("html")) {
                View parentOfreferenceParent = referenceParent.getParent();
                if (parentOfreferenceParent != null && parentOfreferenceParent instanceof CustomLayoutBoxView) {
                    additionalOffset -= SferyxUtilities.getAbsolutePositioningReferenceOffset(view);
                    referenceParentSpan = ((CustomLayoutBoxView)parentOfreferenceParent).getSpan(1, SferyxUtilities.indexOfView(referenceParent));
                }
            } else {
                if (referenceParent.getContainer() != null) {
                    referenceParentSpan = ((JEditorPane)referenceParent.getContainer()).getVisibleRect().height;
                }
                additionalOffset -= SferyxUtilities.getAbsolutePositioningReferenceOffset(view);
            }
        }
        try {
            AttributeSet elementAttributes = view.getElement().getAttributes();
            if (elementAttributes.getAttribute("top") != null && elementAttributes.isDefined("top")) {
                String value = (String)elementAttributes.getAttribute("top");
                if (value != null && value.indexOf("%") != -1) {
                    value = value.trim();
                    value = value.substring(0, value.indexOf("%"));
                    float numValue = Float.parseFloat(value);
                    int parentSpan = 0;
                    if (view.getParent().getParent() instanceof CustomLayoutBoxView) {
                        parentSpan = referenceParentSpan;
                    } else if (view.getParent().getParent() instanceof CustomParagraphView) {
                        parentSpan = referenceParentSpan;
                    }
                    return additionalOffset + (int)(numValue * (float)parentSpan / 100.0f);
                }
                return additionalOffset + (int)SferyxUtilities.getNumberFromCSString((String)elementAttributes.getAttribute("top"));
            }
            if (elementAttributes.getAttribute("bottom") != null && elementAttributes.isDefined("bottom")) {
                int span = 0;
                if (view.getParent() instanceof CustomLayoutBoxView) {
                    span = ((CustomLayoutBoxView)view.getParent()).getSpan(1, SferyxUtilities.indexOfView(view));
                } else if (view.getParent() instanceof Row) {
                    span = ((Row)view.getParent()).getSpan(1, SferyxUtilities.indexOfView(view));
                }
                String value = (String)elementAttributes.getAttribute("bottom");
                if (value != null && value.indexOf("%") != -1) {
                    value = value.trim();
                    value = value.substring(0, value.indexOf("%"));
                    float numValue = Float.parseFloat(value);
                    int parentSpan = 0;
                    if (view.getParent().getParent() instanceof CustomLayoutBoxView) {
                        parentSpan = referenceParentSpan;
                    } else if (view.getParent().getParent() instanceof CustomParagraphView) {
                        parentSpan = referenceParentSpan;
                    }
                    return additionalOffset + referenceParentSpan - span - (int)(numValue * (float)parentSpan / 100.0f);
                }
                return additionalOffset + referenceParentSpan - span - (int)SferyxUtilities.getNumberFromCSString((String)elementAttributes.getAttribute("bottom"));
            }
        }
        catch (Throwable thr) {
            // empty catch block
        }
        try {
            AttributeSet viewAttributes = view.getAttributes();
            if (viewAttributes.getAttribute("top") != null && viewAttributes.isDefined("top")) {
                String value = (String)viewAttributes.getAttribute("top");
                if (value != null && value.indexOf("%") != -1) {
                    value = value.trim();
                    value = value.substring(0, value.indexOf("%"));
                    float numValue = Float.parseFloat(value);
                    int parentSpan = 0;
                    if (view.getParent().getParent() instanceof CustomLayoutBoxView) {
                        parentSpan = referenceParentSpan;
                    } else if (view.getParent().getParent() instanceof CustomParagraphView) {
                        parentSpan = referenceParentSpan;
                    }
                    return additionalOffset + (int)(numValue * (float)parentSpan / 100.0f);
                }
                return additionalOffset + (int)SferyxUtilities.getNumberFromCSString((String)viewAttributes.getAttribute("top"));
            }
            if (viewAttributes.getAttribute("bottom") != null && viewAttributes.isDefined("bottom")) {
                String value = (String)viewAttributes.getAttribute("bottom");
                int span = ((CustomLayoutBoxView)view.getParent()).getSpan(1, SferyxUtilities.indexOfView(view));
                if (value != null && value.indexOf("%") != -1) {
                    value = value.trim();
                    value = value.substring(0, value.indexOf("%"));
                    float numValue = Float.parseFloat(value);
                    int parentSpan = 0;
                    if (view.getParent().getParent() instanceof CustomLayoutBoxView) {
                        parentSpan = referenceParentSpan;
                    } else if (view.getParent().getParent() instanceof CustomParagraphView) {
                        parentSpan = referenceParentSpan;
                    }
                    return additionalOffset + referenceParentSpan - span - (int)(numValue * (float)parentSpan / 100.0f);
                }
                return additionalOffset + referenceParentSpan - span - (int)SferyxUtilities.getNumberFromCSString((String)viewAttributes.getAttribute("bottom"));
            }
        }
        catch (Throwable thr) {
            // empty catch block
        }
        return additionalOffset;
    }

    public static boolean isLeftMarginAuto(View view) {
        boolean leftMargin = false;
        CSS.Attribute standardKey = CSS.Attribute.MARGIN_LEFT;
        HiddenValue alternativeKey = HiddenValue.MARGIN_LEFT;
        AttributeSet viewAttributes = view.getAttributes();
        AttributeSet attribs = view.getElement().getAttributes();
        String emMargin = null;
        if (attribs.getAttribute(alternativeKey) != null && attribs.containsAttribute(alternativeKey, attribs.getAttribute(alternativeKey)) && (emMargin = (String)attribs.getAttribute(alternativeKey)) != null && emMargin.indexOf("auto") != -1) {
            return true;
        }
        if (viewAttributes.getAttribute(alternativeKey) != null && viewAttributes.containsAttribute(alternativeKey, viewAttributes.getAttribute(alternativeKey)) && (emMargin = (String)viewAttributes.getAttribute(alternativeKey)) != null && emMargin.indexOf("auto") != -1) {
            return true;
        }
        AttributeSet complexAtt = null;
        if (emMargin == null) {
            complexAtt = SferyxUtilities.getMarginValueFromComplexAtribute(attribs);
            if (complexAtt != null) {
                emMargin = (String)complexAtt.getAttribute(alternativeKey);
            }
            if (emMargin != null && emMargin.indexOf("auto") != -1) {
                return true;
            }
        }
        if (emMargin == null) {
            complexAtt = SferyxUtilities.getMarginValueFromComplexAtribute(viewAttributes);
            if (complexAtt != null) {
                emMargin = (String)complexAtt.getAttribute(alternativeKey);
            }
            if (emMargin != null && emMargin.indexOf("auto") != -1) {
                return true;
            }
        }
        return false;
    }

    public static int getLeftMargin(View view) {
        return SferyxUtilities.getMargin(view, CSS.Attribute.MARGIN_LEFT, HiddenValue.MARGIN_LEFT);
    }

    public static int getRightMargin(View view) {
        return SferyxUtilities.getMargin(view, CSS.Attribute.MARGIN_RIGHT, HiddenValue.MARGIN_RIGHT);
    }

    public static int getTopMargin(View view) {
        return SferyxUtilities.getMargin(view, CSS.Attribute.MARGIN_TOP, HiddenValue.MARGIN_TOP);
    }

    public static int getBottomMargin(View view) {
        int margin = SferyxUtilities.getMargin(view, CSS.Attribute.MARGIN_BOTTOM, HiddenValue.MARGIN_BOTTOM);
        return margin;
    }

    public static int getMargin(View view, Object standardKey, Object alternativeKey) {
        String margin;
        Object left_margin;
        int leftMargin = 0;
        AttributeSet viewAttributes = view.getAttributes();
        Element elem = view.getElement();
        AttributeSet attribs = null;
        String emMargin = null;
        if (emMargin == null) {
            Object emMarginViewObject = viewAttributes.getAttribute(alternativeKey);
            if (emMargin == null && emMarginViewObject != null && viewAttributes.containsAttribute(alternativeKey, emMarginViewObject)) {
                emMargin = (String)emMarginViewObject;
                attribs = viewAttributes;
            }
        }
        AttributeSet complexAtt = null;
        if (emMargin != null && emMargin.indexOf("%") == -1 && emMargin.indexOf("em") == -1) {
            if ((emMargin = SferyxUtilities.replaceAll(emMargin, "!important", "")).equalsIgnoreCase("auto")) {
                return 0;
            }
            leftMargin = (int)SferyxUtilities.getNumberFromCSString(emMargin);
            if (leftMargin != -1) {
                return leftMargin;
            }
        }
        if (emMargin != null && emMargin.indexOf("%") == -1 && emMargin.indexOf("em") == -1) {
            if ((emMargin = SferyxUtilities.replaceAll(emMargin, "!important", "")).equalsIgnoreCase("auto")) {
                return 0;
            }
            leftMargin = (int)SferyxUtilities.getNumberFromCSString(emMargin);
            if (leftMargin != -1) {
                return leftMargin;
            }
        }
        if (emMargin != null && emMargin.indexOf("%") == -1 && emMargin.indexOf("em") == -1) {
            if ((emMargin = SferyxUtilities.replaceAll(emMargin, "!important", "")).equalsIgnoreCase("auto")) {
                return 0;
            }
            leftMargin = (int)SferyxUtilities.getNumberFromCSString(emMargin);
            if (leftMargin != -1) {
                return leftMargin;
            }
        }
        if (emMargin != null && emMargin.indexOf("%") != -1) {
            emMargin = SferyxUtilities.replaceAll(emMargin, "!important", "");
            if (view.getParent().getParent() != null && view.getParent().getParent() instanceof CustomLayoutBoxView) {
                float span = ((CustomLayoutBoxView)view.getParent().getParent()).getSpan(0, SferyxUtilities.indexOfView(view.getParent()));
                float percent = Float.parseFloat(emMargin.substring(0, emMargin.indexOf("%")).trim());
                return (int)(percent * span / 100.0f);
            }
            if (elem.getName().equalsIgnoreCase("body")) {
                float span = ((CustomLayoutBoxView)view.getParent()).getSpan(0, SferyxUtilities.indexOfView(view));
                float percent = Float.parseFloat(emMargin.substring(0, emMargin.indexOf("%")).trim());
                return (int)(percent * span / 100.0f);
            }
        }
        if (emMargin != null && (attribs != null && attribs.isDefined(alternativeKey) || complexAtt != null && complexAtt.isDefined(alternativeKey)) && emMargin != null) {
            if (emMargin.equalsIgnoreCase("auto")) {
                return 0;
            }
            float emValue = SferyxUtilities.convertEmValue(emMargin = SferyxUtilities.replaceAll(emMargin, "!important", ""));
            if (emValue != -1.0f) {
                Font font = ((EditorHTMLDocument)elem.getDocument()).getStyleSheet().getFont(viewAttributes);
                int result = (int)((float)font.getSize() * emValue);
                return result;
            }
        }
        if ((left_margin = viewAttributes.getAttribute(standardKey)) != null && viewAttributes.isDefined(standardKey) && viewAttributes.containsAttribute(standardKey, left_margin) && (leftMargin = (int)SferyxUtilities.getNumberFromCSString(margin = left_margin.toString())) != -1) {
            return leftMargin;
        }
        return 0;
    }

    public static AttributeSet getMarginValueFromComplexAtribute(AttributeSet viewAttribs) {
        Object valueObj = viewAttribs.getAttribute(AlternativeCSSAttribute.MARGIN);
        if (valueObj == null) {
            return null;
        }
        if (!viewAttribs.containsAttribute(AlternativeCSSAttribute.MARGIN, valueObj)) {
            return null;
        }
        SimpleAttributeSet attr = new SimpleAttributeSet();
        String value = valueObj.toString();
        value = value.trim();
        boolean isImportant = false;
        if (value.indexOf("!important") != -1) {
            value = SferyxUtilities.replaceAll(value, "!important", "");
            isImportant = true;
        }
        StringTokenizer st = new StringTokenizer(value, " ");
        int i = 0;
        int tokenCount = st.countTokens();
        if (tokenCount > 4) {
            tokenCount = 4;
        }
        while (st.hasMoreTokens() && i < mcssattr.length) {
            String nextToken = st.nextToken();
            nextToken = nextToken.trim();
            if (tokenCount == 4) {
                attr.addAttribute(mcssattr[i], nextToken);
                if (isImportant) {
                    attr.addAttribute(mcssattr[i].toString().toLowerCase() + "-important", nextToken);
                }
                ++i;
                continue;
            }
            if (tokenCount == 2) {
                attr.addAttribute(mcssattr[0], nextToken);
                if (isImportant) {
                    attr.addAttribute(mcssattr[0].toString().toLowerCase() + "-important", nextToken);
                }
                attr.addAttribute(mcssattr[2], nextToken);
                if (isImportant) {
                    attr.addAttribute(mcssattr[2].toString().toLowerCase() + "-important", nextToken);
                }
                nextToken = st.nextToken();
                attr.addAttribute(mcssattr[1], nextToken);
                if (isImportant) {
                    attr.addAttribute(mcssattr[1].toString().toLowerCase() + "-important", nextToken);
                }
                attr.addAttribute(mcssattr[3], nextToken);
                if (!isImportant) break;
                attr.addAttribute(mcssattr[3].toString().toLowerCase() + "-important", nextToken);
                break;
            }
            if (tokenCount == 1) {
                attr.addAttribute(mcssattr[0], nextToken);
                if (isImportant) {
                    attr.addAttribute(mcssattr[0].toString().toLowerCase() + "-important", nextToken);
                }
                attr.addAttribute(mcssattr[1], nextToken);
                if (isImportant) {
                    attr.addAttribute(mcssattr[1].toString().toLowerCase() + "-important", nextToken);
                }
                attr.addAttribute(mcssattr[2], nextToken);
                if (isImportant) {
                    attr.addAttribute(mcssattr[2].toString().toLowerCase() + "-important", nextToken);
                }
                attr.addAttribute(mcssattr[3], nextToken);
                if (!isImportant) break;
                attr.addAttribute(mcssattr[3].toString().toLowerCase() + "-important", nextToken);
                break;
            }
            if (tokenCount != 3) continue;
            attr.addAttribute(mcssattr[0], nextToken);
            if (isImportant) {
                attr.addAttribute(mcssattr[0].toString().toLowerCase() + "-important", nextToken);
            }
            nextToken = st.nextToken();
            attr.addAttribute(mcssattr[1], nextToken);
            if (isImportant) {
                attr.addAttribute(mcssattr[1].toString().toLowerCase() + "-important", nextToken);
            }
            attr.addAttribute(mcssattr[3], nextToken);
            if (isImportant) {
                attr.addAttribute(mcssattr[3].toString().toLowerCase() + "-important", nextToken);
            }
            nextToken = st.nextToken();
            attr.addAttribute(mcssattr[2], nextToken);
            if (!isImportant) break;
            attr.addAttribute(mcssattr[2].toString().toLowerCase() + "-important", nextToken);
            break;
        }
        return attr;
    }

    public static int getLeftPadding(View view) {
        return SferyxUtilities.getPadding(view, CSS.Attribute.PADDING_LEFT, HiddenValue.PADDING_LEFT);
    }

    public static int getRightPadding(View view) {
        return SferyxUtilities.getPadding(view, CSS.Attribute.PADDING_RIGHT, HiddenValue.PADDING_RIGHT);
    }

    public static int getTopPadding(View view) {
        return SferyxUtilities.getPadding(view, CSS.Attribute.PADDING_TOP, HiddenValue.PADDING_TOP);
    }

    public static int getBottomPadding(View view) {
        return SferyxUtilities.getPadding(view, CSS.Attribute.PADDING_BOTTOM, HiddenValue.PADDING_BOTTOM);
    }

    public static int getPadding(View view, Object standardKey, Object alternativeKey) {
        String margin;
        float emValue;
        int leftMargin = 0;
        AttributeSet viewAttributes = view.getAttributes();
        Element elem = view.getElement();
        AttributeSet attribs = null;
        String emMargin = null;
        AttributeSet complexAtt = null;
        if (emMargin == null) {
            Object emMarginViewObject = viewAttributes.getAttribute(alternativeKey);
            if (emMargin == null && emMarginViewObject != null && viewAttributes.containsAttribute(alternativeKey, emMarginViewObject)) {
                emMargin = (String)emMarginViewObject;
                attribs = viewAttributes;
            }
        }
        if (emMargin == null) {
            if (viewAttributes.isDefined(AlternativeCSSAttribute.PADDING)) {
                complexAtt = SferyxUtilities.getPaddingValueFromComplexAtribute(viewAttributes);
            }
            if (complexAtt != null && complexAtt.getAttribute(alternativeKey) != null && complexAtt.containsAttribute(alternativeKey, complexAtt.getAttribute(alternativeKey))) {
                emMargin = (String)complexAtt.getAttribute(alternativeKey);
                attribs = viewAttributes;
            }
        }
        if (emMargin != null && emMargin.indexOf("%") == -1 && emMargin.indexOf("em") == -1 && (leftMargin = (int)SferyxUtilities.getNumberFromCSString(emMargin = SferyxUtilities.replaceAll(emMargin, "!important", ""))) != -1) {
            return leftMargin;
        }
        if (emMargin != null && emMargin.indexOf("%") != -1) {
            emMargin = SferyxUtilities.replaceAll(emMargin, "!important", "");
            if (view.getParent().getParent() != null && view.getParent().getParent() instanceof CustomLayoutBoxView) {
                float span = ((CustomLayoutBoxView)view.getParent().getParent()).getSpan(0, SferyxUtilities.indexOfView(view.getParent()));
                float percent = Float.parseFloat(emMargin.substring(0, emMargin.indexOf("%")).trim());
                return (int)(percent * span / 100.0f);
            }
            if (elem.getName().equalsIgnoreCase("body")) {
                float span = ((CustomLayoutBoxView)view.getParent()).getSpan(0, SferyxUtilities.indexOfView(view));
                float percent = Float.parseFloat(emMargin.substring(0, emMargin.indexOf("%")).trim());
                return (int)(percent * span / 100.0f);
            }
        }
        if (emMargin != null && (attribs != null && attribs.isDefined(alternativeKey) || complexAtt != null && complexAtt.isDefined(alternativeKey)) && emMargin != null && (emValue = SferyxUtilities.convertEmValue(emMargin = SferyxUtilities.replaceAll(emMargin, "!important", ""))) != -1.0f) {
            Font font = ((EditorHTMLDocument)elem.getDocument()).getStyleSheet().getFont(viewAttributes);
            int result = (int)((float)font.getSize() * emValue);
            return result;
        }
        Object left_margin = viewAttributes.getAttribute(standardKey);
        if (left_margin != null && viewAttributes.isDefined(standardKey) && viewAttributes.containsAttribute(standardKey, left_margin) && (leftMargin = (int)SferyxUtilities.getNumberFromCSString(margin = left_margin.toString())) != -1) {
            return leftMargin;
        }
        return 0;
    }

    public static AttributeSet getPaddingValueFromComplexAtribute(AttributeSet viewAttribs) {
        Object valueObj = viewAttribs.getAttribute(AlternativeCSSAttribute.PADDING);
        if (valueObj == null) {
            return null;
        }
        if (!viewAttribs.containsAttribute(AlternativeCSSAttribute.PADDING, valueObj)) {
            return null;
        }
        String value = valueObj.toString();
        value = value.trim();
        boolean isImportant = false;
        if (value.indexOf("!important") != -1) {
            value = SferyxUtilities.replaceAll(value, "!important", "");
            isImportant = true;
        }
        StringTokenizer st = new StringTokenizer(value, " ");
        SimpleAttributeSet attr = new SimpleAttributeSet();
        int i = 0;
        int tokenCount = st.countTokens();
        if (tokenCount > 4) {
            tokenCount = 4;
        }
        while (st.hasMoreTokens() && i < cssattr.length) {
            String nextToken = st.nextToken();
            nextToken = nextToken.trim();
            if (tokenCount == 4) {
                attr.addAttribute(cssattr[i], nextToken);
                if (isImportant) {
                    attr.addAttribute(cssattr[i].toString().toLowerCase() + "-important", nextToken);
                }
                ++i;
                continue;
            }
            if (tokenCount == 2) {
                attr.addAttribute(cssattr[0], nextToken);
                if (isImportant) {
                    attr.addAttribute(cssattr[0].toString().toLowerCase() + "-important", nextToken);
                }
                attr.addAttribute(cssattr[2], nextToken);
                if (isImportant) {
                    attr.addAttribute(cssattr[2].toString().toLowerCase() + "-important", nextToken);
                }
                nextToken = st.nextToken();
                attr.addAttribute(cssattr[1], nextToken);
                if (isImportant) {
                    attr.addAttribute(cssattr[1].toString().toLowerCase() + "-important", nextToken);
                }
                attr.addAttribute(cssattr[3], nextToken);
                if (!isImportant) break;
                attr.addAttribute(cssattr[3].toString().toLowerCase() + "-important", nextToken);
                break;
            }
            if (tokenCount == 1) {
                attr.addAttribute(cssattr[0], nextToken);
                if (isImportant) {
                    attr.addAttribute(cssattr[0].toString().toLowerCase() + "-important", nextToken);
                }
                attr.addAttribute(cssattr[1], nextToken);
                if (isImportant) {
                    attr.addAttribute(cssattr[1].toString().toLowerCase() + "-important", nextToken);
                }
                attr.addAttribute(cssattr[2], nextToken);
                if (isImportant) {
                    attr.addAttribute(cssattr[2].toString().toLowerCase() + "-important", nextToken);
                }
                attr.addAttribute(cssattr[3], nextToken);
                if (!isImportant) break;
                attr.addAttribute(cssattr[3].toString().toLowerCase() + "-important", nextToken);
                break;
            }
            if (tokenCount != 3) continue;
            attr.addAttribute(cssattr[0], nextToken);
            if (isImportant) {
                attr.addAttribute(cssattr[0].toString().toLowerCase() + "-important", nextToken);
            }
            nextToken = st.nextToken();
            attr.addAttribute(cssattr[1], nextToken);
            if (isImportant) {
                attr.addAttribute(cssattr[1].toString().toLowerCase() + "-important", nextToken);
            }
            attr.addAttribute(cssattr[3], nextToken);
            if (isImportant) {
                attr.addAttribute(cssattr[3].toString().toLowerCase() + "-important", nextToken);
            }
            nextToken = st.nextToken();
            attr.addAttribute(cssattr[2], nextToken);
            if (!isImportant) break;
            attr.addAttribute(cssattr[2].toString().toLowerCase() + "-important", nextToken);
            break;
        }
        return attr;
    }

    public static View getParentParagraph(View view) {
        if (view instanceof CustomParagraphView) {
            return view;
        }
        if (view.getParent() instanceof CustomParagraphView) {
            return view.getParent();
        }
        View parent = view.getParent();
        while (parent != null && (parent = parent.getParent()) != null) {
            if (parent == null || !(parent instanceof CustomParagraphView)) continue;
            return parent;
        }
        return null;
    }

    public static View getAbsolutePositioningReferenceParent(View v) {
        View bodyView = SferyxUtilities.getViewForElement(((EditorHTMLDocument)v.getElement().getDocument()).getBodyElement(), (JEditorPane)v.getContainer());
        bodyView = bodyView.getParent();
        View parent = null;
        if (v.getElement().isLeaf()) {
            parent = SferyxUtilities.getParentParagraph(v);
        } else {
            if (!(v.getParent() instanceof CSSLayoutViews)) {
                return bodyView;
            }
            parent = v.getParent();
        }
        if (((CSSLayoutViews)((Object)parent)).isAbsolutePositioning() || ((CSSLayoutViews)((Object)parent)).isRelativePositioning()) {
            return parent;
        }
        do {
            if (!(parent.getParent() instanceof CSSLayoutViews)) {
                return bodyView;
            }
            if ((parent = parent.getParent()) != null) continue;
            return bodyView;
        } while (!((CSSLayoutViews)((Object)parent)).isAbsolutePositioning() && !((CSSLayoutViews)((Object)parent)).isRelativePositioning());
        return parent;
    }

    public static int getNestedDivsDepth(int offset, EditorHTMLDocument htdoc) {
        Element topDivElement = htdoc.getDivElement(offset);
        if (topDivElement == null) {
            return 0;
        }
        int divCount = 1;
        Element e = topDivElement.getParentElement();
        if (SferyxUtilities.matchNameAttribute(e, HTML.Tag.DIV)) {
            ++divCount;
        }
        while ((e = e.getParentElement()) != null) {
            if (!SferyxUtilities.matchNameAttribute(e, HTML.Tag.DIV)) continue;
            ++divCount;
        }
        return divCount;
    }

    public static String getElementString(Element elem) {
        String elemName = elem.getName();
        if (elem.isLeaf()) {
            if (elemName.equals("content")) {
                elemName = "";
            }
            String allKeys = "";
            AttributeSet a = elem.getAttributes();
            int biggest = 0;
            Enumeration<?> keys = a.getAttributeNames();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                if (!(key instanceof HTML.Tag) || key == HTML.Tag.FONT || key == HTML.Tag.B || key == HTML.Tag.I || key == HTML.Tag.U) continue;
                String keyName = key.toString();
                String ID = "";
                String CLASS = "";
                int order = 0;
                Object o = a.getAttribute((HTML.Tag)key);
                if (o != null && o instanceof AttributeSet) {
                    AttributeSet attr = (AttributeSet)o;
                    if (attr.getAttribute(HTML.Attribute.ID) != null) {
                        ID = "#" + attr.getAttribute(HTML.Attribute.ID);
                    } else if (attr.getAttribute(HTML.Attribute.CLASS) != null) {
                        CLASS = "." + attr.getAttribute(HTML.Attribute.CLASS);
                    }
                    if (attr.getAttribute(EditorHTMLDocument.sferyxInternalEmbeddedTagsCount) != null) {
                        order = (Integer)attr.getAttribute(EditorHTMLDocument.sferyxInternalEmbeddedTagsCount);
                    }
                }
                if (key == HTML.Tag.A && a.getAttribute(HTML.Tag.A) != null && ((AttributeSet)a.getAttribute(HTML.Tag.A)).getAttribute(HTML.Attribute.HREF) == null && ID.equals("") && CLASS.equals("")) continue;
                keyName = keyName + ID + CLASS;
                allKeys = !allKeys.equals("") ? (order < biggest ? keyName + " " + allKeys : allKeys + " " + keyName) : allKeys + keyName;
                if (biggest >= order) continue;
                biggest = order;
            }
            if (!allKeys.equals("") && !elemName.equals("")) {
                return allKeys + " " + elemName;
            }
            if (!allKeys.equals("") && elemName.equals("")) {
                return allKeys;
            }
        }
        if (elemName.equals("p-implied")) {
            elemName = "";
        }
        String nameAndID = elemName;
        if (elem.getAttributes().getAttribute(HTML.Attribute.ID) != null && elem.getAttributes().isDefined(HTML.Attribute.ID)) {
            nameAndID = elemName = elemName + "#" + elem.getAttributes().getAttribute(HTML.Attribute.ID);
        }
        if (elem.getAttributes().getAttribute(HTML.Attribute.CLASS) != null && elem.getAttributes().isDefined(HTML.Attribute.CLASS)) {
            String clasS = elem.getAttributes().getAttribute(HTML.Attribute.CLASS).toString();
            StringTokenizer str = new StringTokenizer(clasS);
            int count = 0;
            while (str.hasMoreTokens()) {
                if (count > 0) {
                    elemName = elemName + " ";
                }
                String nextToken = str.nextToken();
                elemName = elemName + "." + nextToken;
                ++count;
            }
        }
        return elemName;
    }

    public static String getSelectorStringForElement(Element elem) {
        String selector = SferyxUtilities.getElementString(elem);
        Element e = elem.getParentElement();
        if (e == null) {
            return selector;
        }
        selector = SferyxUtilities.getElementString(e) + " " + selector;
        while ((e = e.getParentElement()) != null) {
            selector = SferyxUtilities.getElementString(e) + " " + selector;
        }
        return selector;
    }

    public static void removeEqualAttributes(MutableAttributeSet from, AttributeSet removeSet) {
    }

    public static int getSelectorScore(String selector) {
        if (selector == null || selector.length() == 0) {
            return 0;
        }
        if (!(selector = selector.trim()).startsWith("html") && !selector.startsWith("body")) {
            selector = "body " + selector;
        }
        int b = 0;
        int c = 0;
        int d = 0;
        int e = 0;
        String prevChar = "";
        for (int i = 0; i < selector.length(); ++i) {
            char charAt = selector.charAt(i);
            if (charAt == '#') {
                ++b;
            } else if (charAt == ':') {
                ++c;
            } else if (charAt == '.') {
                ++d;
            } else if ((prevChar.equals(" ") || prevChar.equals("")) && charAt != ' ') {
                ++e;
            }
            prevChar = "" + charAt;
        }
        if (!selector.equals("body") && !selector.equals("html") && b == 0 && c == 0 && d == 0 && e == 0 && selector.indexOf(" ") == -1) {
            ++e;
        }
        String score = "1" + b + "" + c + "" + d + "" + e;
        int scoreInt = Integer.parseInt(score);
        return scoreInt;
    }

    public static String getElementStringWithoutClass(Element elem) {
        String elemName = elem.getName();
        if (elem.isLeaf()) {
            if (elemName.equals("content")) {
                elemName = "";
            }
            String allKeys = "";
            AttributeSet a = elem.getAttributes();
            Enumeration<?> keys = a.getAttributeNames();
            int biggest = 0;
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                if (!(key instanceof HTML.Tag)) continue;
                String keyName = key.toString();
                String ID = "";
                String CLASS = "";
                Object o = a.getAttribute((HTML.Tag)key);
                int order = 0;
                if (o != null && o instanceof AttributeSet) {
                    AttributeSet attr = (AttributeSet)o;
                    if (attr.getAttribute(HTML.Attribute.ID) != null) {
                        ID = "#" + attr.getAttribute(HTML.Attribute.ID);
                    } else if (attr.getAttribute(HTML.Attribute.CLASS) != null) {
                        CLASS = "." + attr.getAttribute(HTML.Attribute.CLASS);
                    }
                    if (attr.getAttribute(EditorHTMLDocument.sferyxInternalEmbeddedTagsCount) != null) {
                        order = (Integer)attr.getAttribute(EditorHTMLDocument.sferyxInternalEmbeddedTagsCount);
                    }
                }
                if (key == HTML.Tag.A && a.getAttribute(HTML.Tag.A) != null && ((AttributeSet)a.getAttribute(HTML.Tag.A)).getAttribute(HTML.Attribute.HREF) == null && ID.equals("") && CLASS.equals("")) continue;
                keyName = keyName + ID + CLASS;
                allKeys = !allKeys.equals("") ? (order < biggest ? keyName + " " + allKeys : allKeys + " " + keyName) : allKeys + keyName;
                if (biggest >= order) continue;
                biggest = order;
            }
            if (!allKeys.equals("") && !elemName.equals("")) {
                return allKeys + " " + elemName;
            }
            if (!allKeys.equals("") && elemName.equals("")) {
                return allKeys;
            }
        }
        if (elemName.equals("p-implied")) {
            elemName = "";
        }
        if (elem.getAttributes().getAttribute(HTML.Attribute.ID) != null && elem.getAttributes().isDefined(HTML.Attribute.ID)) {
            elemName = elemName + "#" + elem.getAttributes().getAttribute(HTML.Attribute.ID);
        }
        return elemName;
    }

    public static String getSelectorStringForElementWithoutClass(Element elem) {
        String selector = SferyxUtilities.getElementStringWithoutClass(elem);
        Element e = elem.getParentElement();
        if (e == null) {
            return selector;
        }
        selector = SferyxUtilities.getElementString(e) + " " + selector;
        while ((e = e.getParentElement()) != null) {
            selector = SferyxUtilities.getElementString(e) + " " + selector;
        }
        return selector;
    }

    public static String getElementStringWithoutID(Element elem) {
        String elemName = elem.getName();
        if (elem.isLeaf()) {
            if (elemName.equals("content")) {
                elemName = "";
            }
            String allKeys = "";
            AttributeSet a = elem.getAttributes();
            Enumeration<?> keys = a.getAttributeNames();
            int biggest = 0;
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                if (!(key instanceof HTML.Tag)) continue;
                String keyName = key.toString();
                String ID = "";
                String CLASS = "";
                Object o = a.getAttribute((HTML.Tag)key);
                int order = 0;
                if (key == HTML.Tag.FONT || key == HTML.Tag.B || key == HTML.Tag.I || key == HTML.Tag.U) continue;
                if (o != null && o instanceof AttributeSet) {
                    AttributeSet attr = (AttributeSet)o;
                    if (attr.getAttribute(HTML.Attribute.ID) != null) {
                        ID = "";
                    } else if (attr.getAttribute(HTML.Attribute.CLASS) != null) {
                        CLASS = "." + attr.getAttribute(HTML.Attribute.CLASS);
                    }
                    if (attr.getAttribute(EditorHTMLDocument.sferyxInternalEmbeddedTagsCount) != null) {
                        order = (Integer)attr.getAttribute(EditorHTMLDocument.sferyxInternalEmbeddedTagsCount);
                    }
                }
                if (key == HTML.Tag.A && a.getAttribute(HTML.Tag.A) != null && ((AttributeSet)a.getAttribute(HTML.Tag.A)).getAttribute(HTML.Attribute.HREF) == null && ID.equals("") && CLASS.equals("")) continue;
                keyName = keyName + ID + CLASS;
                allKeys = !allKeys.equals("") ? (order < biggest ? keyName + " " + allKeys : allKeys + " " + keyName) : allKeys + keyName;
                if (biggest >= order) continue;
                biggest = order;
            }
            if (!allKeys.equals("") && !elemName.equals("")) {
                return allKeys + " " + elemName;
            }
            if (!allKeys.equals("") && elemName.equals("")) {
                return allKeys;
            }
        }
        if (elemName.equals("p-implied")) {
            elemName = "";
        }
        String nameAndID = elemName;
        if (elem.getAttributes().getAttribute(HTML.Attribute.ID) == null || elem.getAttributes().isDefined(HTML.Attribute.ID)) {
            // empty if block
        }
        if (elem.getAttributes().getAttribute(HTML.Attribute.CLASS) != null && elem.getAttributes().isDefined(HTML.Attribute.CLASS)) {
            String clasS = elem.getAttributes().getAttribute(HTML.Attribute.CLASS).toString();
            StringTokenizer str = new StringTokenizer(clasS);
            int count = 0;
            while (str.hasMoreTokens()) {
                if (count > 0) {
                    elemName = elemName + " ";
                }
                String nextToken = str.nextToken();
                elemName = elemName + "." + nextToken;
                ++count;
            }
        }
        return elemName;
    }

    public static String getElementStringWithoutClassAndID(Element elem) {
        String elemName = elem.getName();
        if (elem.isLeaf()) {
            if (elemName.equals("content")) {
                elemName = "";
            }
            String allKeys = "";
            AttributeSet a = elem.getAttributes();
            Enumeration<?> keys = a.getAttributeNames();
            int biggest = 0;
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                if (!(key instanceof HTML.Tag)) continue;
                String keyName = key.toString();
                String ID = "";
                String CLASS = "";
                Object o = a.getAttribute((HTML.Tag)key);
                int order = 0;
                if (key == HTML.Tag.FONT || key == HTML.Tag.B || key == HTML.Tag.I || key == HTML.Tag.U) continue;
                if (o != null && o instanceof AttributeSet) {
                    AttributeSet attr = (AttributeSet)o;
                    if (attr.getAttribute(HTML.Attribute.ID) != null) {
                        ID = "";
                    } else if (attr.getAttribute(HTML.Attribute.CLASS) != null) {
                        CLASS = "." + attr.getAttribute(HTML.Attribute.CLASS);
                    }
                    if (attr.getAttribute(EditorHTMLDocument.sferyxInternalEmbeddedTagsCount) != null) {
                        order = (Integer)attr.getAttribute(EditorHTMLDocument.sferyxInternalEmbeddedTagsCount);
                    }
                }
                if (key == HTML.Tag.A && a.getAttribute(HTML.Tag.A) != null && ((AttributeSet)a.getAttribute(HTML.Tag.A)).getAttribute(HTML.Attribute.HREF) == null && ID.equals("") && CLASS.equals("")) continue;
                keyName = keyName + ID + CLASS;
                allKeys = !allKeys.equals("") ? (order < biggest ? keyName + " " + allKeys : allKeys + " " + keyName) : allKeys + keyName;
                if (biggest >= order) continue;
                biggest = order;
            }
            if (!allKeys.equals("") && !elemName.equals("")) {
                return allKeys + " " + elemName;
            }
            if (!allKeys.equals("") && elemName.equals("")) {
                return allKeys;
            }
        }
        if (elemName.equals("p-implied")) {
            elemName = "";
        }
        if (elem.getAttributes().getAttribute(HTML.Attribute.ID) == null || elem.getAttributes().isDefined(HTML.Attribute.ID)) {
            // empty if block
        }
        return elemName;
    }

    public static String getSelectorStringForElementWithoutClassAndID(Element elem) {
        String selector = SferyxUtilities.getElementStringWithoutClassAndID(elem);
        Element e = elem.getParentElement();
        if (e == null) {
            return selector;
        }
        selector = SferyxUtilities.getElementStringWithoutID(e) + " " + selector;
        while ((e = e.getParentElement()) != null) {
            selector = SferyxUtilities.getElementStringWithoutID(e) + " " + selector;
        }
        return selector;
    }

    public static String purgeOuterBody(String sourceText) {
        try {
            int indexOfEndTagBody;
            int indexOfBody = sourceText.indexOf("<body");
            int indexOfBodyEnd = -1;
            if (indexOfBody == -1) {
                indexOfBody = sourceText.indexOf("<BODY");
            }
            if (indexOfBody != -1) {
                indexOfBodyEnd = sourceText.indexOf(">", indexOfBody);
            }
            if ((indexOfEndTagBody = sourceText.indexOf("</body>")) == -1) {
                indexOfEndTagBody = sourceText.indexOf("</BODY>");
            }
            if (indexOfBodyEnd != -1 && indexOfEndTagBody != -1) {
                sourceText = sourceText.substring(indexOfBodyEnd + 1, indexOfEndTagBody);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sourceText;
    }

    public static String purgeOuterTables(String content, int offset, EditorHTMLDocument htdoc) {
        int nestedTablesDepth = SferyxUtilities.getNestedTablesDepth(offset, htdoc);
        if (nestedTablesDepth == 0) {
            return content;
        }
        for (int i = 0; i < nestedTablesDepth; ++i) {
            int indexOfTable = content.indexOf("<td");
            if (indexOfTable == -1 || content.lastIndexOf("</td>") == -1) continue;
            content = content.substring(content.indexOf(">", indexOfTable) + 1, content.lastIndexOf("</td>"));
        }
        return content;
    }

    public static boolean isAdditionStyleDefinition(Object key) {
        if (key == null) {
            return false;
        }
        if (key.toString() == null) {
            return false;
        }
        for (int i = 0; i < additionStlyeDeclarations.length; ++i) {
            if (!key.equals(additionStlyeDeclarations[i])) continue;
            return true;
        }
        return false;
    }

    static boolean isContainingUnkownStyleDefs(String decl) {
        try {
            decl = decl.toLowerCase();
            StringTokenizer st = new StringTokenizer(decl, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                StringTokenizer st1 = new StringTokenizer(token, ":");
                if (st1.countTokens() < 2) continue;
                String name = st1.nextToken();
                String value = st1.nextToken();
                if (!SferyxUtilities.isAdditionStyleDefinition(name = name.trim())) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }

    static void extractUnkownStyleDefs(String decl, StyleSheet styleSheet, String selectorName, boolean fromImport) {
        try {
            decl = decl.toLowerCase();
            boolean ahead = false;
            for (int i = 0; i < additionStlyeDeclarations.length; ++i) {
                if (decl.indexOf(additionStlyeDeclarations[i]) == -1) continue;
                ahead = true;
                break;
            }
            if (!ahead) {
                return;
            }
            Style rule = styleSheet.getStyle(selectorName.toLowerCase());
            if (rule == null) {
                rule = styleSheet.getStyle(selectorName);
            }
            if (rule == null) {
                rule = styleSheet.addStyle(selectorName, null);
            }
            if (rule == null) {
                return;
            }
            StringTokenizer st = new StringTokenizer(decl, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                StringTokenizer st1 = new StringTokenizer(token, ":");
                if (st1.countTokens() < 2) continue;
                String name = st1.nextToken();
                String value = st1.nextToken();
                for (int i = 0; i < additionStlyeDeclarations.length; ++i) {
                    if (!(name = name.trim()).equals(additionStlyeDeclarations[i])) continue;
                    value = value.trim();
                    rule.addAttribute(name, SferyxUtilities.replaceAll(value, "!important", ""));
                    if (value.indexOf("!important") == -1) continue;
                    rule.addAttribute(name + "-important", SferyxUtilities.replaceAll(value, "!important", ""));
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void processAdditionalCSSDirectives(String rule, StyleSheet styles) {
        StringTokenizer st = new StringTokenizer(rule, "{}", true);
        boolean inDecl = false;
        boolean ruleIsAsterix = false;
        String ruleName = "";
        String lastToken = "";
        boolean inMedia = false;
        boolean inScreenMedia = false;
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken();
            if (nextToken.equals("{") && lastToken.indexOf("@media") == -1) {
                inDecl = true;
                lastToken = nextToken;
                continue;
            }
            if (nextToken.equals("}") && inDecl) {
                inDecl = false;
                lastToken = nextToken;
                continue;
            }
            if (lastToken.indexOf("@media") != -1 && nextToken.equals("{") && (lastToken.indexOf("screen") != -1 || lastToken.indexOf("all") != -1)) {
                inMedia = true;
                inScreenMedia = true;
                lastToken = nextToken;
                continue;
            }
            if (lastToken.indexOf("@media") != -1 && nextToken.equals("{")) {
                inMedia = true;
                lastToken = nextToken;
                continue;
            }
            if (nextToken.equals("}") && !inDecl && inMedia) {
                inMedia = false;
                lastToken = nextToken;
                continue;
            }
            if (!inDecl) {
                ruleName = nextToken.trim();
            } else if (inDecl) {
                String currentRule = nextToken;
                try {
                    if (!inMedia || inScreenMedia) {
                        SferyxUtilities.extractUnkownStyleDefs(currentRule, styles, ruleName, false);
                    }
                }
                catch (Throwable thr) {
                    thr.printStackTrace();
                }
            }
            lastToken = nextToken;
        }
    }

    public static void processAsteriscDirective(String rule, StyleSheet styles) {
        StringTokenizer st = new StringTokenizer(rule, "{}", true);
        boolean inDecl = false;
        boolean ruleIsAsterix = false;
        String ruleName = "";
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken();
            if (nextToken.equals("{")) {
                inDecl = true;
                continue;
            }
            if (nextToken.equals("}")) {
                inDecl = false;
                continue;
            }
            if (!inDecl && nextToken.trim().startsWith("*")) {
                ruleIsAsterix = true;
                ruleName = nextToken.trim();
                continue;
            }
            if (!inDecl) {
                ruleIsAsterix = false;
                continue;
            }
            if (!inDecl) continue;
            if (ruleIsAsterix) {
                String currentRule;
                if (ruleName.equals("*")) {
                    currentRule = nextToken;
                    try {
                        styles.loadRules(new StringReader("p, div, body{" + currentRule + "}"), styles.getBase());
                    }
                    catch (Throwable thr) {}
                } else if (ruleName.startsWith("*")) {
                    currentRule = nextToken;
                    String newName = ruleName.substring(1);
                    try {
                        styles.loadRules(new StringReader(newName.toLowerCase() + "{" + currentRule + "}"), styles.getBase());
                    }
                    catch (Throwable thr) {
                        // empty catch block
                    }
                }
            }
            ruleIsAsterix = false;
        }
    }

    public static AttributeSet mergeAttributeSets(MutableAttributeSet source, MutableAttributeSet target, StyleSheet styles, HTML.Tag tag) {
        if (tag != null) {
            Style tagStyle = styles.getStyle(tag.toString());
            if (tagStyle != null) {
                Enumeration<?> rules = source.getAttributeNames();
                while (rules.hasMoreElements()) {
                    Object name = rules.nextElement();
                    if (tagStyle.isDefined(name)) continue;
                    target.addAttribute(name, source.getAttribute(name));
                }
            } else {
                target.addAttributes(source);
            }
        }
        return target;
    }

    public static String purgeOuterDivs(String content, int startoffset, int endoffset, EditorHTMLDocument htdoc) {
        int nestedTablesDepthStart = SferyxUtilities.getNestedDivsDepth(startoffset, htdoc);
        int nestedTablesDepthEnd = SferyxUtilities.getNestedDivsDepth(endoffset, htdoc);
        int nestedTablesDepth = 0;
        Element divElemStart = htdoc.getDivElement(startoffset);
        Element divElemEnd = htdoc.getDivElement(endoffset);
        nestedTablesDepth = Math.min(nestedTablesDepthStart, nestedTablesDepthEnd);
        if (nestedTablesDepthStart != nestedTablesDepthEnd && divElemStart != divElemEnd) {
            --nestedTablesDepth;
        }
        if (nestedTablesDepth <= 0) {
            return content;
        }
        for (int i = 0; i < nestedTablesDepth; ++i) {
            int indexOfTable = content.indexOf("<div");
            if (indexOfTable == -1 || content.lastIndexOf("</div>") == -1 || indexOfTable >= content.lastIndexOf("</div>")) continue;
            content = content.substring(content.indexOf(">", indexOfTable) + 1, content.lastIndexOf("</div>"));
        }
        return content;
    }

    static RowLayoutHandler getRowLayoutHandlerInstance(TableView view) {
        return new RowLayoutHandler(view);
    }

    static ColumnLayoutHandler getColumnLayoutHandlerInstance(TableView view) {
        return new ColumnLayoutHandler(view);
    }

    static void calculateTiledLayout(TiledLayoutHandler iter, int targetSpan) {
        int adjustmentLevel;
        int i;
        long preferred = 0L;
        long currentPreferred = 0L;
        int lastMargin = 0;
        int collapsed = 0;
        int n = iter.getCount();
        int adjustmentWeightsCount = 2;
        long[] gain = new long[adjustmentWeightsCount];
        long[] loss = new long[adjustmentWeightsCount];
        for (i = 0; i < adjustmentWeightsCount; ++i) {
            loss[i] = 0L;
            gain[i] = 0L;
        }
        for (i = 0; i < n; ++i) {
            iter.setIndex(i);
            int margin0 = lastMargin;
            int margin1 = (int)iter.getLeadingCollapseSpan();
            iter.setOffset(Math.max(margin0, margin1));
            if (iter.getOffset() != 0) {
                iter.setOffset(iter.getOffset() - margin0);
                collapsed += iter.getOffset();
            }
            currentPreferred = (long)iter.getPreferredSpan(targetSpan);
            iter.setSpan((int)currentPreferred);
            preferred += currentPreferred;
            int n2 = iter.getAdjustmentWeight();
            gain[n2] = gain[n2] + ((long)iter.getMaximumSpan(targetSpan) - currentPreferred);
            int n3 = iter.getAdjustmentWeight();
            loss[n3] = loss[n3] + (currentPreferred - (long)iter.getMinimumSpan(targetSpan));
            lastMargin = (int)iter.getTrailingCollapseSpan();
        }
        for (i = 1; i < adjustmentWeightsCount; ++i) {
            int n4 = i;
            gain[n4] = gain[n4] + gain[i - 1];
            int n5 = i;
            loss[n5] = loss[n5] + loss[i - 1];
        }
        int allocated = targetSpan - collapsed;
        long desiredAdjustment = (long)allocated - preferred;
        long[] adjustmentsArray = desiredAdjustment > 0L ? gain : loss;
        desiredAdjustment = Math.abs(desiredAdjustment);
        for (adjustmentLevel = 0; adjustmentLevel <= 1 && adjustmentsArray[adjustmentLevel] < desiredAdjustment; ++adjustmentLevel) {
        }
        float adjustmentFactor = 0.0f;
        if (adjustmentLevel <= 1 && (desiredAdjustment -= adjustmentLevel > 0 ? adjustmentsArray[adjustmentLevel - 1] : 0L) != 0L) {
            float maximumAdjustment = adjustmentsArray[adjustmentLevel] - (adjustmentLevel > 0 ? adjustmentsArray[adjustmentLevel - 1] : 0L);
            adjustmentFactor = (float)desiredAdjustment / maximumAdjustment;
        }
        int totalOffset = 0;
        for (int i2 = 0; i2 < n; ++i2) {
            iter.setIndex(i2);
            iter.setOffset(iter.getOffset() + totalOffset);
            if (i2 == n - 1) {
                iter.setSpan(targetSpan - totalOffset);
                continue;
            }
            if (iter.getAdjustmentWeight() < adjustmentLevel) {
                iter.setSpan((int)((long)allocated > preferred ? Math.floor(iter.getMaximumSpan(targetSpan)) : Math.ceil(iter.getMinimumSpan(targetSpan))));
            } else if (iter.getAdjustmentWeight() == adjustmentLevel) {
                int availableSpan = (long)allocated > preferred ? (int)iter.getMaximumSpan(targetSpan) - iter.getSpan() : iter.getSpan() - (int)iter.getMinimumSpan(targetSpan);
                int adj = (int)Math.floor(adjustmentFactor * (float)availableSpan);
                iter.setSpan(iter.getSpan() + ((long)allocated > preferred ? adj : -adj));
            }
            totalOffset = (int)Math.min((long)totalOffset + (long)iter.getSpan(), Integer.MAX_VALUE);
        }
    }

    static SizeRequirements calculateTiledRequirements(TiledLayoutHandler iter, SizeRequirements r) {
        long minimum = 0L;
        long maximum = 0L;
        long preferred = 0L;
        int lastMargin = 0;
        int collapsed = 0;
        int n = iter.getCount();
        for (int i = 0; i < n; ++i) {
            iter.setIndex(i);
            int margin0 = lastMargin;
            int margin1 = (int)iter.getLeadingCollapseSpan();
            int offset = Math.max(margin0, margin1);
            if (offset != 0) {
                collapsed += offset - margin0;
            }
            preferred += (long)((int)iter.getPreferredSpan(0.0f));
            minimum = (long)((float)minimum + iter.getMinimumSpan(0.0f));
            maximum = (long)((float)maximum + iter.getMaximumSpan(0.0f));
            lastMargin = (int)iter.getTrailingCollapseSpan();
        }
        minimum -= (long)collapsed;
        preferred -= (long)collapsed;
        maximum -= (long)collapsed;
        if (r == null) {
            r = new SizeRequirements();
        }
        r.minimum = minimum > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)minimum;
        r.preferred = preferred > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)preferred;
        r.maximum = maximum > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)maximum;
        return r;
    }

    static {
        isMac = false;
        jvm_older = false;
        String ver = null;
        String os = null;
        try {
            jvm_version = ver = System.getProperty("java.version");
            os = System.getProperty("os.name");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (os != null && os.toLowerCase().startsWith("mac")) {
            isMac = true;
        }
        if (ver != null && ver.startsWith("1.3")) {
            jvm_older = true;
        }
        blockElements = new HTML.Tag[]{HTML.Tag.BLOCKQUOTE, HTML.Tag.BODY, HTML.Tag.CAPTION, HTML.Tag.CENTER, HTML.Tag.DD, HTML.Tag.DIR, HTML.Tag.DIV, HTML.Tag.DL, HTML.Tag.FORM, HTML.Tag.FRAMESET, HTML.Tag.HTML, HTML.Tag.LI, HTML.Tag.OL, HTML.Tag.TABLE, HTML.Tag.TD, HTML.Tag.TR, HTML.Tag.UL};
        paragraphElements = new HTML.Tag[]{HTML.Tag.P, HTML.Tag.H1, HTML.Tag.H2, HTML.Tag.H3, HTML.Tag.H4, HTML.Tag.H5, HTML.Tag.H6, HTML.Tag.IMPLIED, HTML.Tag.DT};
        ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        toInt = new int[128];
        for (int i = 0; i < ALPHABET.length; ++i) {
            SferyxUtilities.toInt[SferyxUtilities.ALPHABET[i]] = i;
        }
        resolution = 96;
        try {
            resolution = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        defaultBorderColorLower = new Color(211, 211, 211);
        defaultBorderColorUpper = defaultBorderColorLower.darker();
        dotted_dash = new float[]{2.0f};
        dashed_dash = new float[]{7.0f};
        transparentColor = new Color(1.0f, 1.0f, 1.0f, 0.0f);
        mcssattr = new HiddenValue[]{HiddenValue.MARGIN_TOP, HiddenValue.MARGIN_RIGHT, HiddenValue.MARGIN_BOTTOM, HiddenValue.MARGIN_LEFT};
        cssattr = new AlternativeCSSAttribute[]{AlternativeCSSAttribute.PADDING_TOP, AlternativeCSSAttribute.PADDING_RIGHT, AlternativeCSSAttribute.PADDING_BOTTOM, AlternativeCSSAttribute.PADDING_LEFT};
        additionStlyeDeclarations = new String[]{"animation", "animation-name", "animation-duration", "animation-timing-function", "animation-delay", "animation-iteration-count", "animation-direction", "animation-play-state", "background", "background-attachment", "background-color", "background-image", "background-position", "background-repeat", "background-clip", "background-origin", "background-size", "border", "border-bottom", "border-bottom-color", "border-bottom-style", "border-bottom-width", "border-color", "border-left", "border-left-color", "border-left-style", "border-left-width", "border-right", "border-right-color", "border-right-style", "border-right-width", "border-style", "border-top", "border-top-color", "border-top-style", "border-top-width", "border-width", "outline", "outline-color", "outline-style", "outline-width", "border-bottom-left-radius", "border-bottom-right-radius", "border-image", "border-image-outset", "border-image-repeat", "border-image-slice", "border-image-source", "border-image-width", "border-radius", "border-top-left-radius", "border-top-right-radius", "box-decoration-break", "box-shadow", "overflow-x", "overflow-y", "overflow-style", "rotation", "rotation-point", "color-profile", "opacity", "rendering-intent", "bookmark-label", "bookmark-level", "bookmark-target", "float-offset", "hyphenate-after", "hyphenate-before", "hyphenate-character", "hyphenate-lines", "hyphenate-resource", "hyphens", "image-resolution", "marks", "string-set", "max-height", "max-width", "min-height", "min-width", "box-align", "box-direction", "box-flex", "box-flex-group", "box-lines", "box-ordinal-group", "box-orient", "box-pack", "font", "font-family", "font-size", "font-style", "font-variant", "font-weight", "@font-face", "font-size-adjust", "font-stretch", "content", "counter-increment", "counter-reset", "quotes", "crop", "move-to", "page-policy", "grid-columns", "grid-rows", "target", "target-name", "target-new", "target-position", "alignment-adjust", "alignment-baseline", "baseline-shift", "dominant-baseline", "drop-initial-after-adjust", "drop-initial-after-align", "drop-initial-before-adjust", "drop-initial-before-align", "drop-initial-size", "drop-initial-value", "inline-box-align", "line-stacking", "line-stacking-ruby", "line-stacking-shift", "line-stacking-strategy", "text-height", "list-style", "list-style-image", "list-style-position", "list-style-type", "margin", "margin-bottom", "margin-left", "margin-right", "margin-top", "marquee-direction", "marquee-play-count", "marquee-speed", "marquee-style", "column-count", "column-fill", "column-gap", "column-rule", "column-rule-color", "column-rule-style", "column-rule-width", "column-span", "column-width", "columns", "padding", "padding-bottom", "padding-left", "padding-right", "padding-top", "fit", "fit-position", "image-orientation", "page", "size", "bottom", "clear", "clip", "cursor", "display", "float", "left", "overflow", "position", "right", "top", "visibility", "z-index", "orphans", "page-break-after", "page-break-before", "page-break-inside", "widows", "ruby-align", "ruby-overhang", "ruby-position", "ruby-span", "mark", "mark-after", "mark-before", "phonemes", "rest", "rest-after", "rest-before", "voice-balance", "voice-duration", "voice-pitch", "voice-pitch-range", "voice-rate", "voice-stress", "voice-volume", "border-collapse", "border-spacing", "caption-side", "empty-cells", "table-layout", "color", "direction", "letter-spacing", "line-height", "text-align", "text-decoration", "text-indent", "text-transform", "unicode-bidi", "vertical-align", "white-space", "word-spacing", "hanging-punctuation", "punctuation-trim", "text-align-last", "text-justify", "text-outline", "text-overflow", "text-shadow", "text-wrap", "word-break", "word-wrap", "transform", "transform-origin", "transform-style", "perspective", "perspective-origin", "backface-visibility", "transition", "transition-property", "transition-duration", "transition-timing-function", "transition-delay", "appearance", "box-sizing", "icon", "nav-down", "nav-index", "nav-left", "nav-right", "nav-up", "outline-offset", "resize"};
    }
}

