/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;

class SequentialAttributeSet
implements AttributeSet,
Serializable {
    private AttributeSet[] attrs;

    public SequentialAttributeSet(AttributeSet[] attrs) {
        this.attrs = attrs;
    }

    protected SequentialAttributeSet() {
    }

    protected void setAttributes(AttributeSet[] attrs) {
        this.attrs = attrs;
    }

    public AttributeSet[] getAttributes() {
        return this.attrs;
    }

    public void insertAttributeSetAt(AttributeSet as, int index) {
        int numAttrs = this.attrs.length;
        AttributeSet[] newAttrs = new AttributeSet[numAttrs + 1];
        if (index < numAttrs) {
            if (index > 0) {
                System.arraycopy(this.attrs, 0, newAttrs, 0, index);
                System.arraycopy(this.attrs, index, newAttrs, index + 1, numAttrs - index);
            } else {
                System.arraycopy(this.attrs, 0, newAttrs, 1, numAttrs);
            }
        } else {
            System.arraycopy(this.attrs, 0, newAttrs, 0, numAttrs);
        }
        newAttrs[index] = as;
        this.attrs = newAttrs;
    }

    protected void removeAttributeSetAt(int index) {
        int numAttrs = this.attrs.length;
        AttributeSet[] newAttrs = new AttributeSet[numAttrs - 1];
        if (numAttrs > 0) {
            if (index == 0) {
                System.arraycopy(this.attrs, 1, newAttrs, 0, numAttrs - 1);
            } else if (index < numAttrs - 1) {
                System.arraycopy(this.attrs, 0, newAttrs, 0, index);
                System.arraycopy(this.attrs, index + 1, newAttrs, index, numAttrs - index - 1);
            } else {
                System.arraycopy(this.attrs, 0, newAttrs, 0, numAttrs - 1);
            }
        }
        this.attrs = newAttrs;
    }

    public int getAttributeCount() {
        AttributeSet[] as = this.getAttributes();
        int n = 0;
        for (int i = 0; i < as.length; ++i) {
            n += as[i].getAttributeCount();
        }
        return n;
    }

    public boolean isDefined(Object key) {
        AttributeSet[] as = this.getAttributes();
        for (int i = 0; i < as.length; ++i) {
            if (!as[i].isDefined(key)) continue;
            return true;
        }
        return false;
    }

    public boolean isEqual(AttributeSet attr) {
        return this.getAttributeCount() == attr.getAttributeCount() && this.containsAttributes(attr);
    }

    public AttributeSet copyAttributes() {
        AttributeSet[] as = this.getAttributes();
        SimpleAttributeSet a = new SimpleAttributeSet();
        boolean n = false;
        for (int i = as.length - 1; i >= 0; --i) {
            a.addAttributes(as[i]);
        }
        return a;
    }

    public Object getAttribute(Object key) {
        AttributeSet[] as = this.getAttributes();
        int n = as.length;
        for (int i = 0; i < n; ++i) {
            Object o = as[i].getAttribute(key);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    public Enumeration getAttributeNames() {
        return new SequentialAttributeSetNameEnumeration();
    }

    public boolean containsAttribute(Object name, Object value) {
        return value.equals(this.getAttribute(name));
    }

    public boolean containsAttributes(AttributeSet attrs) {
        boolean result = true;
        Enumeration<?> names = attrs.getAttributeNames();
        while (result && names.hasMoreElements()) {
            Object name = names.nextElement();
            result = attrs.getAttribute(name).equals(this.getAttribute(name));
        }
        return result;
    }

    public AttributeSet getResolveParent() {
        return null;
    }

    private class SequentialAttributeSetNameEnumeration
    implements Enumeration {
        private int attrIndex;
        private Enumeration currentEnum;

        SequentialAttributeSetNameEnumeration() {
            this.updateEnum();
        }

        public boolean hasMoreElements() {
            if (this.currentEnum == null) {
                return false;
            }
            return this.currentEnum.hasMoreElements();
        }

        public Object nextElement() {
            if (this.currentEnum == null) {
                throw new NoSuchElementException("No more names");
            }
            Object retObject = this.currentEnum.nextElement();
            if (!this.currentEnum.hasMoreElements()) {
                this.updateEnum();
            }
            return retObject;
        }

        void updateEnum() {
            AttributeSet[] as = SequentialAttributeSet.this.getAttributes();
            this.currentEnum = null;
            while (this.currentEnum == null && this.attrIndex < as.length) {
                this.currentEnum = as[this.attrIndex++].getAttributeNames();
                if (this.currentEnum.hasMoreElements()) continue;
                this.currentEnum = null;
            }
        }
    }
}

