/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.border.BevelBorder;
import sferyx.administration.editors.CustomEditorPane;
import sferyx.administration.editors.EditorHTMLDocument;
import sferyx.administration.editors.HTMLEditor;

public class Ruler
extends JComponent
implements ComponentListener,
MouseMotionListener,
MouseListener {
    public static final int INCH = Toolkit.getDefaultToolkit().getScreenResolution();
    public static final int PIXEL = Toolkit.getDefaultToolkit().getScreenResolution();
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int SIZE = 20;
    public int orientation;
    public boolean isMetric;
    public boolean isPixel;
    private int increment;
    private int units;
    HTMLEditor htmlEditor;
    int startDrag = -1;
    int difference = -1;
    int currentMark = 0;
    boolean draggingRight = false;
    boolean draggingLeft = false;
    int currentRightMark = 0;
    int minDistance = 0;

    public Ruler(int o, boolean m) {
        this.orientation = o;
        this.isPixel = m;
        this.setIncrementAndUnits();
        this.setBorder(new BevelBorder(1));
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public void setIsMetric(boolean isMetric) {
        this.isMetric = isMetric;
        this.isPixel = !isMetric;
        this.setIncrementAndUnits();
        this.repaint();
    }

    public void setIsPixel(boolean isPixel) {
        this.isPixel = isPixel;
        this.isMetric = !isPixel;
        this.setIncrementAndUnits();
        this.repaint();
    }

    private void setIncrementAndUnits() {
        if (this.isMetric) {
            this.increment = this.units = (int)((double)INCH / 2.54);
        } else if (this.isPixel) {
            this.units = (int)((double)INCH / (double)INCH);
            this.increment = 50;
        } else {
            this.units = INCH;
            this.increment = this.units / 2;
        }
    }

    public boolean isMetric() {
        return this.isMetric;
    }

    public boolean isPixel() {
        return this.isPixel;
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setPreferredHeight(int ph) {
        this.setPreferredSize(new Dimension(20, ph));
    }

    public void setPreferredWidth(int pw) {
        this.setPreferredSize(new Dimension(pw, 20));
    }

    protected void paintComponent(Graphics g) {
        Rectangle drawHere = g.getClipBounds();
        if (drawHere == null) {
            drawHere = this.getBounds();
        }
        g.setColor(new Color(220, 220, 220));
        g.fillRect(drawHere.x, drawHere.y, drawHere.width, drawHere.height);
        g.setFont(new Font("SansSerif", 0, 9));
        g.setColor(Color.black);
        int end = 0;
        int start = 0;
        int tickLength = 0;
        String text = null;
        if (this.orientation == 0) {
            start = drawHere.x / this.increment * this.increment;
            end = ((drawHere.x + drawHere.width) / this.increment + 1) * this.increment;
        } else {
            start = drawHere.y / this.increment * this.increment;
            end = ((drawHere.y + drawHere.height) / this.increment + 1) * this.increment;
        }
        int textWidth = 0;
        if (start == 0) {
            text = Integer.toString(0) + (this.isMetric ? " cm" : " in");
            if (this.isPixel) {
                text = Integer.toString(0) + " px";
            }
            textWidth = g.getFontMetrics().stringWidth(text);
            tickLength = 5;
            if (this.orientation == 0) {
                g.drawLine(0, 19, 0, 20 - tickLength - 1);
                g.drawString(text, 2, 20 - tickLength - 3);
            } else {
                g.drawLine(19, 0, 20 - tickLength - 1, 0);
                g.drawString(text, 20 - tickLength - textWidth - 1, 10);
            }
            text = null;
            start = this.increment;
            tickLength = 0;
        }
        for (int i = start; i < end; i += this.increment) {
            int x;
            if (i % this.units == 0) {
                tickLength = 5;
                text = Integer.toString(i / this.units);
                textWidth = g.getFontMetrics().stringWidth(text);
            } else {
                tickLength = 3;
                text = null;
                tickLength = 0;
            }
            if (text != null) {
                textWidth = g.getFontMetrics().stringWidth(text);
            }
            if (tickLength == 0) continue;
            if (this.orientation == 0) {
                x = i;
                if (this.htmlEditor != null && ((CustomEditorPane)this.htmlEditor.getInternalJEditorPane()).scale > 1.0) {
                    x = (int)((double)x * ((CustomEditorPane)this.htmlEditor.getInternalJEditorPane()).scale);
                }
                g.drawLine(x, 19, x, 20 - tickLength - 1);
                if (text == null) continue;
                g.drawString(text, x - textWidth / 2, 20 - tickLength - 3);
                continue;
            }
            x = i;
            if (this.htmlEditor != null && ((CustomEditorPane)this.htmlEditor.getInternalJEditorPane()).scale > 1.0) {
                x = (int)((double)x * ((CustomEditorPane)this.htmlEditor.getInternalJEditorPane()).scale);
            }
            g.drawLine(19, x, 20 - tickLength - 1, x);
            Font f = g.getFont();
            Graphics2D g2d = (Graphics2D)g;
            int degrees = -90;
            AffineTransform at = AffineTransform.getRotateInstance(Math.toRadians(degrees));
            g2d.setFont(g2d.getFont().deriveFont(at));
            if (text != null) {
                g.drawString(text, 20 - tickLength - 3, x + textWidth / 2);
            }
            g.setFont(f);
        }
        if (this.orientation == 0) {
            g.setColor(new Color(250, 250, 250));
            g.fill3DRect(this.currentMark - 5, 0, 10, 16, true);
        }
        if (this.orientation == 0) {
            g.setColor(new Color(250, 250, 250));
            g.fill3DRect(this.currentRightMark - 5, 0, 10, 16, true);
        }
    }

    public void componentResized(ComponentEvent e) {
        Component source = (Component)e.getSource();
        if (this.orientation == 0) {
            this.htmlEditor.updateRulerMargins((EditorHTMLDocument)this.htmlEditor.getInternalJEditorPane().getDocument());
            this.setPreferredWidth(source.getWidth());
        } else {
            this.setPreferredHeight(source.getHeight());
        }
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (this.htmlEditor != null && this.isEnabled() && this.draggingRight) {
            if (e.getX() >= this.currentMark + this.minDistance) {
                this.htmlEditor.moveHorizontalRuler(e.getX());
                this.setCurrentRightMark(e.getX());
                this.repaint();
            }
            return;
        }
        if (this.htmlEditor != null && this.isEnabled() && this.draggingLeft && e.getX() <= this.currentRightMark - this.minDistance && e.getX() > 0) {
            this.htmlEditor.moveHorizontalRuler(e.getX());
            this.setCurrentMark(e.getX());
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.startDrag = e.getX();
        if (this.currentRightMark - 5 < e.getX() && e.getX() < this.currentRightMark + 5) {
            this.draggingRight = true;
            this.draggingLeft = false;
        } else if (this.currentMark - 5 < e.getX() && e.getX() < this.currentMark + 5) {
            this.draggingLeft = true;
            this.draggingRight = false;
        } else {
            this.draggingLeft = false;
            this.draggingRight = false;
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.htmlEditor != null && this.isEnabled() && this.draggingRight) {
            if (e.getX() >= this.currentMark + this.minDistance) {
                this.difference = e.getX() - this.startDrag;
                if (this.htmlEditor != null && ((CustomEditorPane)this.htmlEditor.getInternalJEditorPane()).scale > 1.0) {
                    this.difference = (int)((double)this.difference / ((CustomEditorPane)this.htmlEditor.getInternalJEditorPane()).scale);
                }
                this.htmlEditor.increaseRightMargin(-this.difference);
                this.htmlEditor.hideHorizontalRuler();
            } else {
                this.difference = this.currentMark + this.minDistance - this.startDrag + 1;
                if (this.htmlEditor != null && ((CustomEditorPane)this.htmlEditor.getInternalJEditorPane()).scale > 1.0) {
                    this.difference = (int)((double)this.difference / ((CustomEditorPane)this.htmlEditor.getInternalJEditorPane()).scale);
                }
                this.htmlEditor.increaseRightMargin(-this.difference);
                this.htmlEditor.hideHorizontalRuler();
            }
            return;
        }
        if (this.htmlEditor != null && this.isEnabled() && this.draggingLeft) {
            if (e.getX() <= this.currentRightMark - this.minDistance) {
                this.difference = e.getX() - this.startDrag;
                if (this.htmlEditor != null && ((CustomEditorPane)this.htmlEditor.getInternalJEditorPane()).scale > 1.0) {
                    this.difference = (int)((double)this.difference / ((CustomEditorPane)this.htmlEditor.getInternalJEditorPane()).scale);
                }
                this.htmlEditor.increaseIndent(this.difference);
                this.htmlEditor.hideHorizontalRuler();
            } else {
                this.difference = this.currentRightMark - this.minDistance - this.startDrag - 1;
                if (this.htmlEditor != null && ((CustomEditorPane)this.htmlEditor.getInternalJEditorPane()).scale > 1.0) {
                    this.difference = (int)((double)this.difference / ((CustomEditorPane)this.htmlEditor.getInternalJEditorPane()).scale);
                }
                this.htmlEditor.increaseIndent(this.difference);
                this.htmlEditor.hideHorizontalRuler();
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void setCurrentMark(int mark) {
        this.currentMark = mark;
    }

    public void setCurrentRightMark(int mark) {
        this.currentRightMark = mark;
    }

    public void setMinimumDistance(int minDistance) {
        this.minDistance = minDistance;
    }
}

