/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import javax.swing.text.View;
import sferyx.administration.editors.CustomTableRowView;
import sferyx.administration.editors.TableView;
import sferyx.administration.editors.TiledLayoutHandler;

class RowLayoutHandler
extends TiledLayoutHandler {
    TableView tv;
    private int row;
    private int[] adjustments;
    private int[] offsets;
    private int[] spans;

    RowLayoutHandler(TableView tv_) {
        this.tv = tv_;
    }

    void updateAdjustments() {
        int axis = 1;
        if (this.tv.multiRowCells) {
            int n = this.tv.getRowCount();
            this.adjustments = new int[n];
            for (int i = 0; i < n; ++i) {
                CustomTableRowView rv = this.tv.getRow(i);
                if (!rv.multiRowCells) continue;
                int ncells = rv.getViewCount();
                for (int j = 0; j < ncells; ++j) {
                    View v = rv.getView(j);
                    int nrows = this.tv.getRowsOccupied(v);
                    if (nrows <= 1) continue;
                    int spanNeeded = (int)v.getPreferredSpan(axis);
                    this.adjustMultiRowSpan(spanNeeded, nrows, i);
                }
            }
        } else {
            this.adjustments = null;
        }
    }

    void adjustMultiRowSpan(int spanNeeded, int nrows, int rowIndex) {
        if (rowIndex + nrows > this.getCount() && (nrows = this.getCount() - rowIndex) < 1) {
            return;
        }
        int span = 0;
        for (int i = 0; i < nrows; ++i) {
            CustomTableRowView rv = this.tv.getRow(rowIndex + i);
            span = (int)((float)span + rv.getPreferredSpan(1));
        }
        if (spanNeeded > span) {
            int adjust = spanNeeded - span;
            int rowAdjust = adjust / nrows;
            int firstAdjust = rowAdjust + (adjust - rowAdjust * nrows);
            CustomTableRowView rv = this.tv.getRow(rowIndex);
            this.adjustments[rowIndex] = Math.max(this.adjustments[rowIndex], firstAdjust);
            for (int i = 1; i < nrows; ++i) {
                this.adjustments[rowIndex + i] = Math.max(this.adjustments[rowIndex + i], rowAdjust);
            }
        }
    }

    void setLayoutArrays(int[] offsets_, int[] spans_) {
        this.offsets = offsets_;
        this.spans = spans_;
    }

    void setOffset(int offs) {
        CustomTableRowView rv = this.tv.getRow(this.row);
        if (rv != null) {
            this.offsets[rv.viewIndex] = offs;
        }
    }

    int getOffset() {
        CustomTableRowView rv = this.tv.getRow(this.row);
        if (rv != null) {
            return this.offsets[rv.viewIndex];
        }
        return 0;
    }

    void setSpan(int span) {
        CustomTableRowView rv = this.tv.getRow(this.row);
        if (rv != null) {
            this.spans[rv.viewIndex] = span;
        }
    }

    int getSpan() {
        CustomTableRowView rv = this.tv.getRow(this.row);
        if (rv != null) {
            return this.spans[rv.viewIndex];
        }
        return 0;
    }

    int getCount() {
        return this.tv.rows.size();
    }

    void setIndex(int i) {
        this.row = i;
    }

    float getMinimumSpan(float parentSpan) {
        return this.getPreferredSpan(parentSpan);
    }

    float getPreferredSpan(float parentSpan) {
        CustomTableRowView rv = this.tv.getRow(this.row);
        if (rv != null) {
            int adjust = this.adjustments != null ? this.adjustments[this.row] : 0;
            return rv.getPreferredSpan(this.tv.getAxis()) + (float)(adjust += 2 * this.tv.cellSpacing);
        }
        return 0.0f;
    }

    float getMaximumSpan(float parentSpan) {
        return this.getPreferredSpan(parentSpan);
    }

    float getLeadingCollapseSpan() {
        return this.tv.cellSpacing;
    }

    float getTrailingCollapseSpan() {
        return this.tv.cellSpacing;
    }

    int getAdjustmentWeight() {
        return 0;
    }
}

