/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Vector;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import sferyx.administration.editors.CSSLayoutViews;
import sferyx.administration.editors.CustomBRView;
import sferyx.administration.editors.CustomImageView;
import sferyx.administration.editors.CustomParagraphView;
import sferyx.administration.editors.RubyTag;
import sferyx.administration.editors.SferyxUtilities;

public class Row
extends BoxView {
    int justification;
    short leftInset = 0;
    short rightInset = 0;
    int[] offsets_X = new int[0];
    int[] offsets_Y = new int[0];
    int[] spans_X = new int[0];
    int[] spans_Y = new int[0];
    boolean done = false;
    AttributeSet attr = null;
    int start = 0;
    int end = 0;
    int parentSpan = 0;
    int realImageDimension;
    int realSpan;
    int biggestRTSpan;
    int biggestRubySpan;
    Rectangle tempRect;
    Rectangle rowRect;
    int basicViewShift = 0;
    View imageView;
    int currentLeftOffset = 0;
    int currentRightOffset = 0;
    boolean thisRowContainsAlignedImages = false;
    boolean thisRowContainsNormalImages = false;
    Vector leftViews = new Vector();
    Vector rightViews = new Vector();
    Vector normalViews = new Vector();

    Row(Element elem) {
        super(elem, 0);
    }

    public void layout(int width, int height) {
        if (this.isLastInParent() && this.getViewCount() > 1) {
            this.findImageChildView();
        }
        this.fracturize();
        super.layout(width, height);
    }

    protected void loadChildren(ViewFactory f) {
    }

    public short getTopInset() {
        return super.getTopInset();
    }

    public short getBottomInset() {
        AttributeSet viewAttribute = this.getAttributes();
        try {
            Object lineHeight;
            if (viewAttribute.getAttribute(CSS.Attribute.LINE_HEIGHT) != null && viewAttribute.isDefined(CSS.Attribute.LINE_HEIGHT) && viewAttribute.containsAttribute(CSS.Attribute.LINE_HEIGHT, viewAttribute.getAttribute(CSS.Attribute.LINE_HEIGHT)) && (lineHeight = viewAttribute.getAttribute(CSS.Attribute.LINE_HEIGHT)) != null) {
                SizeRequirements minorRequest = this.calculateMinorAxisRequirements(1, null);
                double lineSpacing = 0.0;
                if (!lineHeight.toString().equalsIgnoreCase("normal")) {
                    lineSpacing = SferyxUtilities.getNumberFromCSString(lineHeight.toString());
                }
                if (lineHeight.toString().indexOf("px") != -1 || lineHeight.toString().indexOf("pt") != -1) {
                    if (lineSpacing > 0.0 && !this.thisRowContainsNormalImages) {
                        float inset = (short)((double)(super.getBottomInset() + (minorRequest != null ? -minorRequest.preferred : 0)) + lineSpacing);
                        if (inset < 0.0f && -1.0f * inset >= (float)minorRequest.preferred) {
                            return super.getBottomInset();
                        }
                        return (short)inset;
                    }
                } else if (lineHeight.toString().indexOf("%") == -1 && lineSpacing > 0.0) {
                    return (short)((double)(minorRequest != null ? minorRequest.preferred : 0) * (lineSpacing - 1.0));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return super.getBottomInset();
    }

    public void setLeftInsetAndUpdate(short leftInset) {
        this.leftInset = leftInset;
    }

    public void setRightInsetAndUpdate(short rightInset) {
        this.rightInset = rightInset;
    }

    public short getLeftInset() {
        short additionalShift = 0;
        if (this.isFirstInParent()) {
            Object additionalCSSShift = this.getAttributes().getAttribute(CSS.Attribute.TEXT_INDENT);
            if (additionalCSSShift == null && this.getViewCount() > 0) {
                additionalCSSShift = this.getView(0).getAttributes().getAttribute(CSS.Attribute.TEXT_INDENT);
            }
            if (additionalCSSShift != null) {
                try {
                    additionalShift = (short)SferyxUtilities.getNumberFromCSString(additionalCSSShift.toString());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return additionalShift;
    }

    public short getRightInset() {
        return super.getRightInset();
    }

    public void setInsets(short x, short y, short x1, short y1) {
        super.setInsets(x, y, x1, y1);
    }

    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.changedUpdate(e, a, f);
    }

    public AttributeSet getAttributes() {
        View p = this.getParent();
        this.attr = p != null ? p.getAttributes() : null;
        return this.attr;
    }

    public float getAlignment(int axis) {
        try {
            if (axis == 0) {
                this.justification = (int)((CustomParagraphView)this.getParent()).getJustification();
                switch (this.justification) {
                    case 0: 
                    case 3: {
                        return 0.0f;
                    }
                    case 2: {
                        return 1.0f;
                    }
                    case 1: {
                        return 0.5f;
                    }
                }
            }
            return super.getAlignment(axis);
        }
        catch (Throwable throwable) {
            return 0.0f;
        }
    }

    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        if (a == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle r = a.getBounds();
        View v = this.getViewAtPosition(pos, r);
        if (v != null && !v.getElement().isLeaf()) {
            return super.modelToView(pos, a, b);
        }
        r = a.getBounds();
        int height = r.height;
        int y = r.y;
        Shape loc = super.modelToView(pos, a, b);
        if (loc != null) {
            r = loc.getBounds();
        }
        r.height = height;
        r.y = y;
        return r;
    }

    public int getStartOffset() {
        int offs = Integer.MAX_VALUE;
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            View v = this.getView(i);
            if (v == null) continue;
            offs = Math.min(offs, v.getStartOffset());
        }
        return offs;
    }

    public int getEndOffset() {
        int offs = 0;
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            View v = this.getView(i);
            if (v == null) continue;
            offs = Math.max(offs, v.getEndOffset());
        }
        return offs;
    }

    private void fracturize() {
        int i;
        boolean justifiedAlignment;
        if (this.getAttributes() == null) {
            return;
        }
        boolean bl = justifiedAlignment = ((CustomParagraphView)this.getParent()).getJustification() == 3.0f;
        if (!justifiedAlignment) {
            return;
        }
        if (this.getParent() != null && this.getParent().getViewCount() == 1) {
            return;
        }
        int startOffset = this.getStartOffset();
        int endOffset = this.getEndOffset();
        String content = "";
        try {
            content = this.getDocument().getText(startOffset, endOffset - startOffset);
        }
        catch (Exception e) {
            // empty catch block
        }
        int whiteSpaceCount = Row.getWhiteSpaceCount(content);
        if (whiteSpaceCount < 1) {
            return;
        }
        int[] whiteSpaceOffsets = Row.getWhiteSpaceOffsets(content, startOffset);
        int currentSpaceIndex = 0;
        int viewCount = this.getViewCount();
        Vector views = new Vector();
        View[] children = new View[viewCount];
        for (i = 0; i < viewCount; ++i) {
            children[i] = this.getView(i);
        }
        for (i = 0; i < this.getViewCount(); ++i) {
            View child = this.getView(i);
            if (child.getStartOffset() >= whiteSpaceOffsets[currentSpaceIndex] || child.getEndOffset() <= whiteSpaceOffsets[currentSpaceIndex]) continue;
            View first = child.createFragment(child.getStartOffset(), whiteSpaceOffsets[currentSpaceIndex]);
            View second = child.createFragment(whiteSpaceOffsets[currentSpaceIndex], child.getEndOffset());
            View[] repl = new View[]{first, second};
            if (first != child && second != child) {
                this.replace(i, 1, repl);
            }
            if (++currentSpaceIndex >= whiteSpaceOffsets.length) break;
        }
        int childCnt = this.getViewCount();
    }

    private static int getWhiteSpaceCount(String content) {
        int result = 0;
        int index = content.indexOf(32);
        while (index >= 0) {
            ++result;
            index = content.indexOf(32, index + 1);
        }
        return result;
    }

    private static int[] getWhiteSpaceOffsets(String content, int shift) {
        int cnt = Row.getWhiteSpaceCount(content);
        int[] result = new int[cnt];
        int counter = 0;
        int index = content.indexOf(32);
        while (index >= 0) {
            result[counter] = index + shift;
            ++counter;
            index = content.indexOf(32, index + 1);
        }
        return result;
    }

    int getPreviousRubySpan(int rtIndex, int[] spans) {
        int totalSpan = 0;
        boolean outOfRT = false;
        for (int i = rtIndex - 1; i >= 0; --i) {
            View v = this.getView(i);
            if (v != null && v.getElement().getAttributes().getAttribute(RubyTag.Ruby) != null && v != null && v.getElement().getAttributes().getAttribute(RubyTag.RT) != null) {
                return totalSpan;
            }
            if (v != null && v.getElement().getAttributes().getAttribute(RubyTag.Ruby) != null) {
                totalSpan += spans[i];
                continue;
            }
            return totalSpan;
        }
        return totalSpan;
    }

    protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        block21: {
            try {
                boolean justifiedAlignment;
                long minimum = 0L;
                long maximum = 0L;
                long preferred = 0L;
                int n = this.getViewCount();
                float[] min = new float[n];
                float[] max = new float[n];
                for (int i = 0; i < n; ++i) {
                    View v = this.getView(i);
                    spans[i] = (int)v.getPreferredSpan(axis);
                    preferred += (long)spans[i];
                    min[i] = v.getMinimumSpan(axis);
                    max[i] = v.getMaximumSpan(axis);
                    minimum = (long)((float)minimum + min[i]);
                    maximum = (long)((float)maximum + max[i]);
                }
                long desiredAdjustment = (long)targetSpan - preferred;
                float adjustmentFactor = 0.0f;
                if (desiredAdjustment != 0L) {
                    float maximumAdjustment;
                    float f = maximumAdjustment = desiredAdjustment > 0L ? (float)(maximum - preferred) : (float)(preferred - minimum);
                    if (maximumAdjustment == 0.0f) {
                        adjustmentFactor = 0.0f;
                    } else {
                        adjustmentFactor = (float)desiredAdjustment / maximumAdjustment;
                        adjustmentFactor = Math.min(adjustmentFactor, 1.0f);
                        adjustmentFactor = Math.max(adjustmentFactor, -1.0f);
                    }
                }
                int totalOffset = 0;
                boolean currentRTSpan = false;
                boolean currentRubySpan = false;
                int currentRubyIndex = -1;
                int currentRTIndex = -1;
                int rightViewsSpan = 0;
                for (int i = 0; i < n; ++i) {
                    View v = this.getView(i);
                    offsets[i] = totalOffset;
                    int availableSpan = adjustmentFactor > 0.0f ? (int)max[i] - spans[i] : spans[i] - (int)min[i];
                    float adjF = adjustmentFactor * (float)availableSpan;
                    adjF = adjF < 0.0f ? (adjF -= 0.5f) : (adjF += 0.5f);
                    int adj = (int)adjF;
                    int n2 = i;
                    spans[n2] = spans[n2] + adj;
                    totalOffset = (int)Math.min((long)totalOffset + (long)spans[i], Integer.MAX_VALUE);
                    if (this.isRightAlignedView(v)) {
                        offsets[i] = this.parentSpan - spans[i] - rightViewsSpan - this.rightInset;
                        rightViewsSpan += spans[i];
                    }
                    if (!(v instanceof CSSLayoutViews) || !((CSSLayoutViews)((Object)v)).isAbsolutePositioning() || !SferyxUtilities.isDefinedAbsoluteX(v)) continue;
                    offsets[i] = ((CSSLayoutViews)((Object)v)).getAbsoluteX();
                }
                boolean bl = justifiedAlignment = ((CustomParagraphView)this.getParent()).getJustification() == 3.0f;
                if (!justifiedAlignment) break block21;
                AttributeSet attr = this.getAttributes();
                if (attr == null) {
                    return;
                }
                if (axis != 0) {
                    return;
                }
                int cnt = offsets.length;
                int span = 0;
                for (int i = 0; i < cnt; ++i) {
                    span += spans[i];
                    if (!(this.getView(i) instanceof CustomBRView)) continue;
                    return;
                }
                if (this.getParent().getViewCount() == 1) {
                    return;
                }
                if (this.isLastRowInParagraph()) {
                    return;
                }
                int startOffset = this.getStartOffset();
                int len = this.getEndOffset() - startOffset;
                String context = "";
                try {
                    context = this.getElement().getDocument().getText(startOffset, len);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                int spaceCount = Row.getWhiteSpaceCount(context) - 1;
                if (spaceCount < 0) {
                    spaceCount = 0;
                }
                int leftInset = this.getLeftInset() + ((CustomParagraphView)this.getParent()).getLeftInset();
                int rightInset = this.getRightInset() + ((CustomParagraphView)this.getParent()).getRightInset();
                if (rightInset < 0) {
                    rightInset = 0;
                }
                int pixelsToAdd = 0;
                if (((CustomParagraphView)this.getParent()).getFlowSpan(SferyxUtilities.indexOfView(this)) == ((BoxView)this.getParent()).getWidth()) {
                    pixelsToAdd = ((BoxView)this.getParent()).getWidth() - span - leftInset - rightInset;
                }
                if (SferyxUtilities.indexOfView(this) == 1) {
                    int firstLineIndent = (int)StyleConstants.getFirstLineIndent(this.getAttributes());
                    pixelsToAdd -= firstLineIndent;
                }
                int[] spaces = this.getWhiteSpaces(pixelsToAdd, spaceCount);
                int j = 0;
                int shift = 0;
                for (int i = 1; i < cnt; ++i) {
                    View v = this.getView(i);
                    int n3 = i;
                    offsets[n3] = offsets[n3] + shift;
                    if (!this.containsWhiteSpace(v) || i == cnt - 1) continue;
                    if (j < spaces.length) {
                        int n4 = i;
                        offsets[n4] = offsets[n4] + spaces[j];
                        int n5 = i - 1;
                        spans[n5] = spans[n5] + spaces[j];
                        shift += spaces[j];
                    }
                    ++j;
                }
            }
            catch (Throwable thr) {
                // empty catch block
            }
        }
        this.offsets_X = offsets;
        this.spans_X = spans;
    }

    protected int[] getWhiteSpaces(int space, int cnt) {
        int[] result = new int[cnt];
        if (cnt == 0) {
            return result;
        }
        int base = space / cnt;
        int rst = space % cnt;
        for (int i = 0; i < cnt; ++i) {
            result[i] = base;
            if (rst <= 0) continue;
            int n = i;
            result[n] = result[n] + 1;
            --rst;
        }
        return result;
    }

    protected boolean containsWhiteSpace(View v) {
        int startOffset = v.getStartOffset();
        int len = v.getEndOffset() - startOffset;
        try {
            String text = v.getDocument().getText(startOffset, len);
            return text.indexOf(32) >= 0;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        this.baselineLayout(targetSpan, axis, offsets, spans);
        for (int i = 0; i < this.getViewCount(); ++i) {
            View v = this.getView(i);
            if (v instanceof CSSLayoutViews && ((CSSLayoutViews)((Object)v)).isAbsolutePositioning()) {
                if (!SferyxUtilities.isDefinedAbsoluteY(v)) continue;
                offsets[i] = ((CSSLayoutViews)((Object)v)).getAbsoluteY();
                continue;
            }
            if (!this.isLeftAlignedView(v) && !this.isRightAlignedView(v)) continue;
            offsets[i] = offsets[i] - targetSpan;
        }
        this.offsets_Y = offsets;
        this.spans_Y = spans;
    }

    protected void baselineLayout(int targetSpan, int axis, int[] offsets, int[] spans) {
        int totalBelow = (int)((float)targetSpan * this.getAlignment(axis));
        int totalAbove = targetSpan - totalBelow;
        int n = this.getViewCount();
        int previousSpan = 0;
        int rubySpan = -1;
        boolean rubyRTFound = false;
        for (int i = 0; i < n; ++i) {
            View v = this.getView(i);
            float align = v.getAlignment(axis);
            if (this.isLeftAlignedView(v) || this.isRightAlignedView(v)) {
                align = 0.0f;
            }
            int span = (int)v.getPreferredSpan(axis);
            int below = (int)((float)span * align);
            int above = span - below;
            if (span > targetSpan) {
                if ((int)v.getMinimumSpan(axis) < span) {
                    below = totalBelow;
                    above = totalAbove;
                } else if (v.getResizeWeight(axis) > 0 && v.getMaximumSpan(axis) != (float)span) {
                    // empty if block
                }
            } else if (span < targetSpan && (int)v.getMaximumSpan(axis) > span) {
                below = totalBelow;
                above = totalAbove;
            }
            offsets[i] = totalBelow - below;
            spans[i] = below + above;
            previousSpan = span;
        }
    }

    protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
        SizeRequirements sr = this.baselineRequirements(axis, r);
        return sr;
    }

    protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements r) {
        float min = 0.0f;
        float pref = 0.0f;
        float max = 0.0f;
        int n = this.getViewCount();
        boolean totalRubySpan = false;
        boolean totalRTSpan = false;
        boolean totalRubyMinSpan = false;
        boolean totalMinRTSpan = false;
        boolean totalRubyMaxSpan = false;
        boolean totalMaxRTSpan = false;
        for (int i = 0; i < n; ++i) {
            View v = this.getView(i);
            if (v == null) continue;
            min += v.getMinimumSpan(axis);
            pref += v.getPreferredSpan(axis);
            max += v.getMaximumSpan(axis);
        }
        if (totalRTSpan > totalRubySpan) {
            pref += (float)totalRTSpan;
            min += (float)totalMinRTSpan;
            max += (float)totalMaxRTSpan;
        } else {
            pref += (float)totalRubySpan;
            min += (float)totalRubyMinSpan;
            max += (float)totalRubyMaxSpan;
        }
        if (r == null) {
            r = new SizeRequirements();
        }
        r.alignment = 0.5f;
        r.minimum = (int)min;
        r.preferred = (int)pref;
        r.maximum = (int)max;
        return r;
    }

    boolean isFirstInParent() {
        View parent = this.getParent();
        if (parent == null) {
            return false;
        }
        View firstView = parent.getView(0);
        return firstView == this;
    }

    boolean isLastRowInParagraph() {
        View parent = this.getParent();
        if (parent == null) {
            return false;
        }
        int n = parent.getViewCount();
        View lastView = parent.getView(n - 1);
        return lastView == this;
    }

    boolean isLastInParent() {
        int n;
        View parent = this.getParent();
        View lastView = parent.getView((n = parent.getViewCount()) - 1);
        return lastView == this;
    }

    float getSuperiorImageExcess() {
        CustomParagraphView parent = (CustomParagraphView)this.getParent();
        int n = parent.getViewCount();
        int myOffset = parent.getOffset(1, parent.indexOfView(this));
        float totalImageExcess = 0.0f;
        int i = 0;
        float totalSpan = 0.0f;
        for (i = 0; i < n; ++i) {
            Row currRow = (Row)parent.getView(i);
            float imageExcess = currRow.getImageExcess();
            if (currRow != this) {
                totalImageExcess += imageExcess;
                totalSpan += currRow.getPreferredSpan(1);
            }
            if (currRow == this) break;
        }
        return totalImageExcess -= totalSpan;
    }

    float getUpperParagraphsImageExcess() {
        CustomParagraphView parentParagraph = (CustomParagraphView)this.getParent();
        View parentView = parentParagraph.getParent();
        int n = parentView.getViewCount();
        float superiorParagraphsImageExcess = 0.0f;
        int i = 0;
        for (i = 0; i < n; ++i) {
            View view = parentView.getView(i);
            if (!(view instanceof CustomParagraphView)) continue;
            CustomParagraphView currParagraph = (CustomParagraphView)view;
            superiorParagraphsImageExcess += this.getSuperiorParagraphImageExcess(currParagraph);
        }
        return superiorParagraphsImageExcess;
    }

    float getSuperiorParagraphImageExcess(CustomParagraphView currParagraph) {
        Row currRow;
        CustomParagraphView parent = currParagraph;
        int n = parent.getViewCount();
        float totalImageExcess = 0.0f;
        int i = 0;
        int totalSpan = 0;
        for (i = 0; i < n && (currRow = (Row)parent.getView(i)) != this; ++i) {
            float imageExcess = currRow.realImageDimension;
            totalImageExcess += imageExcess;
            totalSpan = (int)((float)totalSpan + currRow.getPreferredSpan(1));
        }
        return totalImageExcess -= (float)totalSpan;
    }

    public int getSpan(int axis, int childIndex) {
        if (childIndex > this.getViewCount() - 1 || childIndex < 0) {
            return 0;
        }
        return super.getSpan(axis, childIndex);
    }

    float getImageExcess() {
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            View currView = this.getView(i);
            if (!this.isLeftAlignedView(currView) && !this.isRightAlignedView(currView)) continue;
            float span = currView.getPreferredSpan(1);
            return span;
        }
        return 0.0f;
    }

    protected SizeRequirements baselineRequirements(int axis, SizeRequirements r) {
        int totalAbove = 0;
        int totalBelow = 0;
        int resizeWeight = 0;
        int n = this.getViewCount();
        this.biggestRTSpan = 0;
        this.biggestRubySpan = 0;
        for (int i = 0; i < n; ++i) {
            View v = this.getView(i);
            int span = (int)v.getPreferredSpan(axis);
            try {
                if (axis == 1) {
                    String content;
                    int startO = v.getStartOffset();
                    int endO = v.getEndOffset();
                    if (endO == startO + 1 && (content = v.getElement().getDocument().getText(startO, endO - startO)) != null && content.equals("\n") && i > 0) {
                        span = 0;
                    }
                }
            }
            catch (Throwable thr) {
                // empty catch block
            }
            int below = (int)(v.getAlignment(axis) * (float)span);
            int above = span - below;
            if (!this.isRightAlignedView(v)) {
                this.realSpan = span;
            }
            if (v instanceof CustomImageView && axis == 1 && (this.isLeftAlignedView(v) || this.isRightAlignedView(v))) {
                this.realImageDimension = span;
                if (!this.isRightAlignedView(v)) {
                    this.realSpan = 0;
                }
                above = 1;
                below = 1;
                span = 1;
            }
            totalAbove = Math.max(above, totalAbove);
            totalBelow = Math.max(below, totalBelow);
            resizeWeight += v.getResizeWeight(axis);
        }
        if (totalBelow < this.biggestRTSpan + this.biggestRubySpan) {
            totalBelow = this.biggestRTSpan + this.biggestRubySpan;
        }
        if (r == null) {
            r = new SizeRequirements();
        }
        r.preferred = totalAbove + totalBelow;
        if (resizeWeight != 0) {
            r.maximum = Integer.MAX_VALUE;
            r.minimum = 0;
        } else {
            r.maximum = r.preferred;
            r.minimum = r.preferred;
        }
        r.alignment = r.preferred > 0 ? (float)totalBelow / (float)r.preferred : 0.5f;
        return r;
    }

    public float getMinimumSpan(int axis) {
        if (!this.isVisible()) {
            return 0.0f;
        }
        float span = super.getMinimumSpan(axis);
        return span;
    }

    public float getMaximumSpan(int axis) {
        if (!this.isVisible()) {
            return 0.0f;
        }
        float span = super.getMaximumSpan(axis);
        return span;
    }

    public float getPreferredSpan(int axis) {
        if (!this.isVisible()) {
            return 0.0f;
        }
        float span = super.getPreferredSpan(axis);
        return span;
    }

    protected View getViewAtPoint(int x, int y, Rectangle alloc) {
        for (int i = 0; i < this.getViewCount(); ++i) {
            int curr_span_X = this.getSpan(0, i);
            int curr_span_Y = this.getSpan(1, i);
            int curr_offset_X = this.getOffset(0, i);
            int curr_offset_Y = this.getOffset(1, i);
            int higherIndex = -1;
            if (x > alloc.x + curr_offset_X && x < alloc.x + curr_offset_X + curr_span_X && y > alloc.y + curr_offset_Y && y < alloc.y + curr_offset_Y + curr_span_Y) {
                higherIndex = i;
            }
            if (higherIndex != -1) {
                this.childAllocation(higherIndex, alloc);
                return this.getView(higherIndex);
            }
            if (x > curr_offset_X && x < curr_offset_X + curr_span_X && y > alloc.y + curr_offset_Y && y < alloc.y + curr_offset_Y + curr_span_Y) {
                higherIndex = i;
            }
            if (higherIndex == -1) continue;
            this.childAllocation(higherIndex, alloc);
            return this.getView(higherIndex);
        }
        return super.getViewAtPoint(x, y, alloc);
    }

    protected int getViewIndexAtPosition(int pos) {
        if (pos < this.getStartOffset() || pos >= this.getEndOffset()) {
            return -1;
        }
        for (int counter = this.getViewCount() - 1; counter >= 0; --counter) {
            View v = this.getView(counter);
            if (pos < v.getStartOffset() || pos >= v.getEndOffset()) continue;
            return counter;
        }
        return -1;
    }

    public boolean isVisible() {
        return true;
    }

    public void paint(Graphics g, Shape allocation) {
        this.rowRect = (Rectangle)allocation;
        if (!this.isVisible()) {
            return;
        }
        Rectangle alloc = allocation instanceof Rectangle ? (Rectangle)allocation : allocation.getBounds();
        int n = this.getViewCount();
        int x = alloc.x + this.getLeftInset();
        int y = alloc.y + this.getTopInset();
        Rectangle clip = g.getClipBounds();
        boolean totalRightViewsOffset = false;
        boolean totalLeftViewsOffset = false;
        if (this.tempRect == null) {
            this.tempRect = new Rectangle();
        }
        for (int i = 0; i < n; ++i) {
            this.tempRect.x = x + this.getOffset(0, i);
            this.tempRect.y = y + this.getOffset(1, i);
            View child = this.getView(i);
            if (this.isRightAlignedView(child) || this.isLeftAlignedView(child)) {
                if ((double)this.getAlignment(0) != 0.5 || this.isLeftAlignedView(child)) {
                    // empty if block
                }
                this.tempRect.width = (int)child.getPreferredSpan(0);
                this.tempRect.height = (int)child.getPreferredSpan(1);
            } else {
                this.tempRect.width = this.getSpan(0, i);
                this.tempRect.height = this.getSpan(1, i);
            }
            if (child instanceof CSSLayoutViews && ((CSSLayoutViews)((Object)child)).isAbsolutePositioning()) {
                Rectangle a = (Rectangle)this.getChildAllocation(i, allocation);
                this.paintChild(g, a, i);
                continue;
            }
            if (this.tempRect == null || !this.tempRect.intersects(clip)) continue;
            this.paintChild(g, this.tempRect, i);
        }
        if (this.isLastRowInParagraph() && this.isShowParagraphsEnabled()) {
            g.drawString("\u00b6", ((Rectangle)allocation).x + ((Rectangle)allocation).width, ((Rectangle)allocation).y + ((Rectangle)allocation).height - 5);
        }
    }

    protected void paintChild1(Graphics g, Rectangle alloc, int index) {
        try {
            View child = this.getView(index);
            View view = child.getParent().getParent();
            if (this.isRightAlignedView(child)) {
                int parentWidth = ((BoxView)view).getWidth();
                int parentWidth_ = ((BoxView)view).getWidth();
                Rectangle parentAllocation = ((CustomParagraphView)view).myAllocation;
                alloc.x = parentAllocation.x + parentWidth_ - alloc.x;
                alloc.y = this.rowRect.y;
            } else if (this.isLeftAlignedView(child)) {
                alloc.y = this.rowRect.y;
            }
            child.paint(g, alloc);
            if (child.getAttributes() != null && child.getAttributes().getAttribute(CSS.Attribute.TEXT_DECORATION) != null && child.getAttributes().getAttribute(CSS.Attribute.TEXT_DECORATION).toString().equalsIgnoreCase("overline")) {
                Rectangle ca = (Rectangle)this.getChildAllocation(index, alloc);
                g.setColor(StyleConstants.getForeground(child.getAttributes()));
                g.drawLine(alloc.x, ca.y - this.getOffset(1, index), alloc.x + ca.width, ca.y - this.getOffset(1, index));
            }
        }
        catch (Throwable exc) {
            // empty catch block
        }
    }

    boolean isLeftAlignedParagraph(AbstractDocument.AbstractElement elem) {
        return elem.getAttributes().getAttribute(CSS.Attribute.TEXT_ALIGN) == null || elem.getAttributes().getAttribute(CSS.Attribute.TEXT_ALIGN).toString().equalsIgnoreCase("left");
    }

    public int getOffset(int axis, int index) {
        if (index > this.getViewCount() - 1 || index < 0) {
            return 0;
        }
        return super.getOffset(axis, index);
    }

    int getOffsetDifference(int currentOffset) {
        try {
            View view = this.getParent();
            int parentWidth = ((BoxView)view).getWidth();
            int maxWidth = 0;
            int offsetDifference = 0;
            for (int i = 0; i < view.getViewCount(); ++i) {
                View currView = view.getView(i);
                int span = ((CustomParagraphView)view).getSpan(0, i);
                if (!(currView instanceof Row) || currView == this) continue;
                if (maxWidth == 0 && ((Row)currView).rightInset != 0) {
                    maxWidth = span - ((Row)currView).rightInset;
                    continue;
                }
                if (maxWidth >= span || ((Row)currView).rightInset == 0) continue;
                maxWidth = span - ((Row)currView).rightInset;
            }
            if (maxWidth != 0) {
                offsetDifference = maxWidth;
                return offsetDifference;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return currentOffset;
    }

    boolean isShowParagraphsEnabled() {
        return SferyxUtilities.getHostHTMLEditor(this) != null && SferyxUtilities.getHostHTMLEditor(this).isShowParagraphsEnabled();
    }

    public Shape getChildAllocation1(int index, Shape a) {
        try {
            View child = this.getView(index);
            if (this.isRightAlignedView(child)) {
                Rectangle parentAllocation;
                Rectangle rect = (Rectangle)super.getChildAllocation(index, a);
                if (this.getParent() != null && (parentAllocation = ((CustomParagraphView)this.getParent()).myAllocation) != null) {
                    rect.x = parentAllocation.width - rect.width;
                }
                return rect;
            }
            return super.getChildAllocation(index, a);
        }
        catch (Throwable thr) {
            thr.printStackTrace();
            return super.getChildAllocation(index, a);
        }
    }

    public int getCurrentLeftOffset() {
        return this.currentLeftOffset;
    }

    public int getCurrentRightOffset() {
        return this.currentRightOffset;
    }

    View findImageChildView() {
        if (!((CustomParagraphView)this.getParent()).containsImages) {
            return null;
        }
        try {
            this.leftViews.removeAllElements();
            this.rightViews.removeAllElements();
            this.normalViews.removeAllElements();
            Object biggestView = null;
            boolean currentViewIndex = false;
            int endCurrentViewIndex = this.getViewCount() - 1;
            int n = this.getViewCount();
            boolean canContinue = false;
            this.currentRightOffset = 0;
            this.currentLeftOffset = 0;
            for (int i = 0; i < n; ++i) {
                View currentView = this.getView(i);
                if (this.isLeftAlignedView(currentView)) {
                    canContinue = true;
                    this.leftViews.add(currentView);
                    this.currentLeftOffset += (int)currentView.getPreferredSpan(0);
                    this.thisRowContainsAlignedImages = true;
                    ((CustomParagraphView)this.getParent()).containsAlignedImages = true;
                    continue;
                }
                if (this.isRightAlignedView(currentView)) {
                    canContinue = true;
                    this.rightViews.add(currentView);
                    this.currentRightOffset += (int)currentView.getPreferredSpan(0);
                    this.thisRowContainsAlignedImages = true;
                    ((CustomParagraphView)this.getParent()).containsAlignedImages = true;
                    continue;
                }
                if (SferyxUtilities.matchNameAttribute(currentView.getElement(), HTML.Tag.IMG)) {
                    this.thisRowContainsNormalImages = true;
                }
                this.normalViews.add(currentView);
            }
            if (!canContinue) {
                return null;
            }
            this.thisRowContainsAlignedImages = true;
            Object[] orderedViews = new View[n];
            Vector allViews = new Vector();
            allViews.addAll(this.leftViews);
            allViews.addAll(this.normalViews);
            allViews.addAll(this.rightViews);
            allViews.copyInto(orderedViews);
            boolean indexChanged = false;
            for (int i = 0; i < n; ++i) {
                Object currentView = orderedViews[i];
                if (SferyxUtilities.indexOfView((View)currentView) == i) continue;
                indexChanged = true;
            }
            if (!indexChanged) {
                return null;
            }
            this.replace(0, n, (View[])orderedViews);
            ((CustomParagraphView)this.getParent()).containsAlignedImages = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    View findImageChildView_new() {
        this.currentLeftOffset = 0;
        this.currentRightOffset = 0;
        View biggestView = null;
        int currentViewIndex = 0;
        int endCurrentViewIndex = this.getViewCount() - 1;
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            View c_v = this.getView(i);
            if (!(c_v instanceof CustomImageView)) continue;
            if (this.isLeftAlignedView(c_v)) {
                if (i != currentViewIndex) {
                    this.remove(i);
                    this.insert(currentViewIndex, c_v);
                    ++currentViewIndex;
                    this.currentLeftOffset += (int)c_v.getPreferredSpan(0);
                } else {
                    this.currentLeftOffset += (int)c_v.getPreferredSpan(0);
                    ++currentViewIndex;
                }
                if (c_v != null) {
                    if (biggestView != null && biggestView.getPreferredSpan(1) < c_v.getPreferredSpan(1)) {
                        biggestView = c_v;
                        this.imageView = c_v;
                    } else if (biggestView == null) {
                        biggestView = c_v;
                        this.imageView = c_v;
                    }
                }
                ((CustomParagraphView)this.getParent()).containsAlignedImages = true;
                continue;
            }
            if (!this.isRightAlignedView(c_v)) continue;
            this.append(c_v);
            this.remove(i);
            if (c_v != null) {
                if (biggestView != null && biggestView.getPreferredSpan(1) < c_v.getPreferredSpan(1)) {
                    biggestView = c_v;
                    this.imageView = c_v;
                } else if (biggestView == null) {
                    biggestView = c_v;
                    this.imageView = c_v;
                }
            }
            ((CustomParagraphView)this.getParent()).containsAlignedImages = true;
        }
        return biggestView;
    }

    public boolean isInTheEnd(int index) {
        int n = this.getViewCount();
        for (int i = index; i < n; ++i) {
            View c_v = this.getView(i);
            if (this.isRightAlignedView(c_v)) continue;
            return false;
        }
        return true;
    }

    public boolean isLeftAlignedView(View view) {
        if (!((CustomParagraphView)this.getParent()).containsImages) {
            return false;
        }
        if (!SferyxUtilities.matchNameAttribute(view.getElement().getAttributes(), HTML.Tag.IMG)) {
            return false;
        }
        if (this.getViewCount() == 1) {
            return false;
        }
        float viewPrefSpan = view.getPreferredSpan(0);
        try {
            BoxView boxParent = (BoxView)this.getParent().getParent();
            View nextLayoutView = SferyxUtilities.getNextBoxLayoutView(SferyxUtilities.indexOfView(this.getParent()), boxParent);
            if (viewPrefSpan >= (float)boxParent.getWidth()) {
                return false;
            }
            if (boxParent.getViewCount() - 1 > SferyxUtilities.indexOfView(this.getParent()) && (float)boxParent.getWidth() - viewPrefSpan < boxParent.getView(SferyxUtilities.indexOfView(this.getParent()) + 1).getMinimumSpan(0)) {
                return false;
            }
        }
        catch (Throwable thr) {
            // empty catch block
        }
        if (viewPrefSpan >= (float)this.parentSpan && this.getParent().getViewCount() > 1) {
            return false;
        }
        if (SferyxUtilities.isFloatLeftView(view, ((HTMLDocument)this.getElement().getDocument()).getStyleSheet())) {
            return true;
        }
        try {
            AttributeSet elementAttributes = view.getElement().getAttributes();
            Object align_attribute = elementAttributes.getAttribute(HTML.Attribute.ALIGN);
            Object name_attribute = elementAttributes.getAttribute(StyleConstants.NameAttribute);
            boolean isFloat = false;
            if (align_attribute == null && view.getAttributes().getAttribute(CSS.Attribute.FLOAT) != null) {
                align_attribute = view.getAttributes().getAttribute(CSS.Attribute.FLOAT).toString();
                isFloat = true;
            }
            return align_attribute != null && ((String)align_attribute).equalsIgnoreCase("left") && elementAttributes.containsAttribute(HTML.Attribute.ALIGN, "left") || align_attribute != null && isFloat && align_attribute.equals("left");
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean isRightAlignedView(View view) {
        if (!((CustomParagraphView)this.getParent()).containsImages) {
            return false;
        }
        if (!SferyxUtilities.matchNameAttribute(view.getElement().getAttributes(), HTML.Tag.IMG)) {
            return false;
        }
        if (this.getViewCount() == 1) {
            return false;
        }
        float viewPrefSpan = view.getPreferredSpan(0);
        try {
            BoxView boxParent = (BoxView)this.getParent().getParent();
            View nextLayoutView = SferyxUtilities.getNextBoxLayoutView(SferyxUtilities.indexOfView(this.getParent()), boxParent);
            if (viewPrefSpan >= (float)boxParent.getWidth()) {
                return false;
            }
            if (boxParent.getViewCount() - 1 > SferyxUtilities.indexOfView(this.getParent()) && (float)boxParent.getWidth() - viewPrefSpan < boxParent.getView(SferyxUtilities.indexOfView(this.getParent()) + 1).getMinimumSpan(0)) {
                return false;
            }
        }
        catch (Throwable thr) {
            // empty catch block
        }
        if (viewPrefSpan >= (float)this.parentSpan && this.getParent().getViewCount() > 1) {
            return false;
        }
        if (SferyxUtilities.isFloatRightView(view, ((HTMLDocument)this.getElement().getDocument()).getStyleSheet())) {
            return true;
        }
        try {
            AttributeSet elementAttributes = view.getElement().getAttributes();
            Object align_attribute = elementAttributes.getAttribute(HTML.Attribute.ALIGN);
            Object name_attribute = elementAttributes.getAttribute(StyleConstants.NameAttribute);
            boolean isFloat = false;
            if (align_attribute == null && view.getAttributes().getAttribute(CSS.Attribute.FLOAT) != null) {
                align_attribute = view.getAttributes().getAttribute(CSS.Attribute.FLOAT).toString();
                isFloat = true;
            }
            return align_attribute != null && ((String)align_attribute).equalsIgnoreCase("right") && elementAttributes.containsAttribute(HTML.Attribute.ALIGN, "right") || align_attribute != null && isFloat && align_attribute.equals("right");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }
}

