/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class RemoteFileDialog
extends JDialog
implements ActionListener,
FocusListener {
    String absoluteDocumentTranslationURL;
    String selectedFile;
    boolean cancel = false;
    private JScrollPane browseScrollPane;
    private JPanel buttonPanel;
    private JLabel dimensionLabel;
    private JButton okButton;
    private JPanel ToolbarPanel;
    private JLabel fileNameLabel;
    private JEditorPane fileBrowser;
    private JButton cancelButton;
    private JLabel lastModLabel;

    public RemoteFileDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setSize(600, 250);
    }

    private void initComponents() {
        this.browseScrollPane = new JScrollPane();
        this.fileBrowser = new JEditorPane();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.ToolbarPanel = new JPanel();
        this.fileNameLabel = new JLabel();
        this.dimensionLabel = new JLabel();
        this.lastModLabel = new JLabel();
        this.setTitle("Remote File Browser");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                RemoteFileDialog.this.closeDialog(evt);
            }
        });
        this.fileBrowser.addContainerListener(new ContainerAdapter(){

            public void componentAdded(ContainerEvent evt) {
                RemoteFileDialog.this.fileBrowserComponentAdded(evt);
            }
        });
        this.fileBrowser.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                RemoteFileDialog.this.fileBrowserHyperlinkUpdate(evt);
            }
        });
        this.browseScrollPane.setViewportView(this.fileBrowser);
        this.getContentPane().add((Component)this.browseScrollPane, "Center");
        this.okButton.setText("Ok");
        this.okButton.setPreferredSize(new Dimension(100, 23));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RemoteFileDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setPreferredSize(new Dimension(100, 23));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RemoteFileDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.ToolbarPanel.setLayout(new GridLayout(1, 3));
        this.fileNameLabel.setHorizontalAlignment(0);
        this.fileNameLabel.setText("File Name");
        this.fileNameLabel.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.fileNameLabel.setMaximumSize(new Dimension(52, 20));
        this.fileNameLabel.setPreferredSize(new Dimension(100, 20));
        this.ToolbarPanel.add(this.fileNameLabel);
        this.dimensionLabel.setHorizontalAlignment(4);
        this.dimensionLabel.setText("Dimension");
        this.dimensionLabel.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.dimensionLabel.setPreferredSize(new Dimension(50, 20));
        this.ToolbarPanel.add(this.dimensionLabel);
        this.lastModLabel.setHorizontalAlignment(0);
        this.lastModLabel.setText("Last Modified");
        this.lastModLabel.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.ToolbarPanel.add(this.lastModLabel);
        this.getContentPane().add((Component)this.ToolbarPanel, "North");
        this.pack();
    }

    private void fileBrowserComponentAdded(ContainerEvent evt) {
        try {
            Container c = (Container)evt.getChild();
            Component comp = c.getComponent(0);
            if (!(comp instanceof JRadioButton) && comp instanceof JButton) {
                ((JButton)comp).setContentAreaFilled(false);
                ((JButton)comp).setBackground(SystemColor.textHighlight);
                ((JButton)comp).setBorderPainted(false);
                ((JButton)comp).setFocusPainted(false);
                ((JButton)comp).setFont(new Font("arial", 0, 12));
                ((JButton)comp).addActionListener(this);
                ((JButton)comp).addFocusListener(this);
                ((JButton)comp).setMargin(new Insets(0, 0, 0, 0));
                String label = ((JButton)comp).getText();
                ((JButton)comp).setActionCommand(label);
                int index = label.lastIndexOf("/");
                if (index != -1 && !label.equals("/")) {
                    ((JButton)comp).setText(label.substring(index + 1));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fileBrowserHyperlinkUpdate(HyperlinkEvent evt) {
        HTMLDocument doc = (HTMLDocument)this.fileBrowser.getDocument();
        if (!(evt instanceof HTMLFrameHyperlinkEvent) && evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                this.fileBrowser.setPage(evt.getURL());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.cancel = true;
        this.setVisible(false);
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.cancel = false;
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void setBrowseLocation(String browseLocation) {
        try {
            this.fileBrowser.setEditable(false);
            this.fileBrowser.setContentType("text/html");
            URL browseURL = new URL(browseLocation);
            this.fileBrowser.setPage(browseURL);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Error opening remote browsing - " + ex.getMessage(), "Error", 0);
        }
    }

    public void setAbsoluteTranslationURL(String absoluteDocumentTranslationURL) {
        this.absoluteDocumentTranslationURL = absoluteDocumentTranslationURL;
    }

    public void setVisible(boolean b) {
        if (b) {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            int xPos = (int)d.getWidth() / 2 - this.getWidth() / 2;
            int yPos = (int)d.getHeight() / 2 - this.getHeight() / 2;
            this.setLocation(xPos, yPos);
        }
        super.setVisible(b);
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public String getSelectedFile() {
        if (this.cancel) {
            return null;
        }
        if (this.absoluteDocumentTranslationURL != null) {
            return this.absoluteDocumentTranslationURL + this.selectedFile;
        }
        return this.selectedFile;
    }

    public void focusGained(FocusEvent focusEvent) {
        JButton button = (JButton)focusEvent.getSource();
        button.setContentAreaFilled(true);
        button.setForeground(SystemColor.textHighlightText);
        this.selectedFile = button.getActionCommand();
    }

    public void focusLost(FocusEvent focusEvent) {
        JButton button = (JButton)focusEvent.getSource();
        button.setContentAreaFilled(false);
        button.setForeground(Color.black);
    }
}

