/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import sferyx.administration.editors.AlternativeCSSAttribute;
import sferyx.administration.editors.ColorChooserDialog;
import sferyx.administration.editors.HTMLEditor;
import sferyx.administration.editors.SferyxUtilities;

public class ParagraphPropertiesDialog
extends JDialog {
    private JTextField borderWidthTextField;
    private JButton automaticBorderColorButton;
    private JTextField lineSpacingTextField;
    private JTextField bottomMarginTextField;
    private JTextField topMarginTextField;
    private JButton selectBackgroundColorButton;
    private JLabel bottomMarginLabel;
    private JLabel leftMArginLabel;
    private JPanel mainPanel;
    private JTextField indentFirstLineTextField;
    private JPanel backgroundPanel;
    private JComboBox styleClassComboBox;
    private JLabel borderWidthLabel;
    private JTextField rightMarginTextField;
    private JLabel styleClassLabel;
    private JLabel rightMarginLabel;
    private JLabel indentFirstLineLabel;
    private JLabel borderColorLabel;
    private JTextField leftMarginTextField;
    private JButton cancelButton;
    private JButton selectBorderColorButton;
    private JLabel borderPreviewLabel;
    private JLabel colorLabel;
    private JLabel topMarginLabel;
    private JLabel backgroundPreviewLabel;
    private JLabel lineSpacingLabel;
    private JPanel spacingPanel;
    private JPanel buttonsPanel;
    private JButton automaticBackgroundColorButton;
    private JButton okButton;
    AttributeSet attributes;
    boolean cancel = false;
    HTMLDocument doc;
    HTMLEditor htmlPanel;

    public ParagraphPropertiesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setResizable(false);
    }

    public ParagraphPropertiesDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setResizable(false);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.spacingPanel = new JPanel();
        this.bottomMarginLabel = new JLabel();
        this.bottomMarginTextField = new JTextField();
        this.indentFirstLineLabel = new JLabel();
        this.leftMarginTextField = new JTextField();
        this.rightMarginLabel = new JLabel();
        this.rightMarginTextField = new JTextField();
        this.topMarginLabel = new JLabel();
        this.topMarginTextField = new JTextField();
        this.leftMArginLabel = new JLabel();
        this.indentFirstLineTextField = new JTextField();
        this.lineSpacingLabel = new JLabel();
        this.lineSpacingTextField = new JTextField();
        this.backgroundPanel = new JPanel();
        this.selectBackgroundColorButton = new JButton();
        this.automaticBackgroundColorButton = new JButton();
        this.colorLabel = new JLabel();
        this.backgroundPreviewLabel = new JLabel();
        this.borderColorLabel = new JLabel();
        this.borderPreviewLabel = new JLabel();
        this.selectBorderColorButton = new JButton();
        this.automaticBorderColorButton = new JButton();
        this.borderWidthLabel = new JLabel();
        this.borderWidthTextField = new JTextField();
        this.styleClassLabel = new JLabel();
        this.styleClassComboBox = new JComboBox();
        this.buttonsPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setTitle("Paragraph Properties");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ParagraphPropertiesDialog.this.closeDialog(evt);
            }
        });
        this.mainPanel.setLayout(null);
        this.spacingPanel.setLayout(null);
        this.spacingPanel.setBorder(new TitledBorder("Indentation & Spacing"));
        this.bottomMarginLabel.setHorizontalAlignment(4);
        this.bottomMarginLabel.setText("Bottom margin");
        this.spacingPanel.add(this.bottomMarginLabel);
        this.bottomMarginLabel.setBounds(10, 110, 100, 16);
        this.bottomMarginTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParagraphPropertiesDialog.this.bottomMarginTextFieldActionPerformed(evt);
            }
        });
        this.spacingPanel.add(this.bottomMarginTextField);
        this.bottomMarginTextField.setBounds(120, 110, 60, 20);
        this.indentFirstLineLabel.setHorizontalAlignment(4);
        this.indentFirstLineLabel.setText("Indent first line");
        this.spacingPanel.add(this.indentFirstLineLabel);
        this.indentFirstLineLabel.setBounds(180, 80, 130, 16);
        this.leftMarginTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParagraphPropertiesDialog.this.leftMarginTextFieldActionPerformed(evt);
            }
        });
        this.spacingPanel.add(this.leftMarginTextField);
        this.leftMarginTextField.setBounds(120, 20, 60, 20);
        this.rightMarginLabel.setHorizontalAlignment(4);
        this.rightMarginLabel.setText("Right margin");
        this.spacingPanel.add(this.rightMarginLabel);
        this.rightMarginLabel.setBounds(10, 50, 100, 16);
        this.spacingPanel.add(this.rightMarginTextField);
        this.rightMarginTextField.setBounds(120, 50, 60, 20);
        this.topMarginLabel.setHorizontalAlignment(4);
        this.topMarginLabel.setText("Top margin");
        this.spacingPanel.add(this.topMarginLabel);
        this.topMarginLabel.setBounds(10, 80, 100, 16);
        this.spacingPanel.add(this.topMarginTextField);
        this.topMarginTextField.setBounds(120, 80, 60, 20);
        this.leftMArginLabel.setHorizontalAlignment(4);
        this.leftMArginLabel.setText("Left margin");
        this.spacingPanel.add(this.leftMArginLabel);
        this.leftMArginLabel.setBounds(10, 20, 100, 16);
        this.spacingPanel.add(this.indentFirstLineTextField);
        this.indentFirstLineTextField.setBounds(320, 80, 60, 20);
        this.lineSpacingLabel.setHorizontalAlignment(4);
        this.lineSpacingLabel.setText("Line spacing");
        this.spacingPanel.add(this.lineSpacingLabel);
        this.lineSpacingLabel.setBounds(200, 50, 110, 16);
        this.spacingPanel.add(this.lineSpacingTextField);
        this.lineSpacingTextField.setBounds(320, 50, 60, 20);
        this.mainPanel.add(this.spacingPanel);
        this.spacingPanel.setBounds(10, 10, 410, 140);
        this.backgroundPanel.setLayout(null);
        this.backgroundPanel.setBorder(new TitledBorder("Borders & Background"));
        this.selectBackgroundColorButton.setText("Select");
        this.selectBackgroundColorButton.setMargin(new Insets(0, 0, 0, 0));
        this.selectBackgroundColorButton.setPreferredSize(new Dimension(80, 26));
        this.selectBackgroundColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParagraphPropertiesDialog.this.selectBackgroundColorButtonActionPerformed(evt);
            }
        });
        this.backgroundPanel.add(this.selectBackgroundColorButton);
        this.selectBackgroundColorButton.setBounds(190, 30, 100, 26);
        this.automaticBackgroundColorButton.setText("Automatic");
        this.automaticBackgroundColorButton.setMargin(new Insets(0, 0, 0, 0));
        this.automaticBackgroundColorButton.setPreferredSize(new Dimension(80, 26));
        this.automaticBackgroundColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParagraphPropertiesDialog.this.automaticBackgroundColorButtonActionPerformed(evt);
            }
        });
        this.backgroundPanel.add(this.automaticBackgroundColorButton);
        this.automaticBackgroundColorButton.setBounds(300, 30, 100, 26);
        this.colorLabel.setHorizontalAlignment(4);
        this.colorLabel.setText("Background color:");
        this.backgroundPanel.add(this.colorLabel);
        this.colorLabel.setBounds(-10, 30, 140, 16);
        this.backgroundPanel.add(this.backgroundPreviewLabel);
        this.backgroundPreviewLabel.setBounds(140, 30, 50, 20);
        this.borderColorLabel.setHorizontalAlignment(4);
        this.borderColorLabel.setText("Border color:");
        this.backgroundPanel.add(this.borderColorLabel);
        this.borderColorLabel.setBounds(10, 70, 120, 16);
        this.backgroundPanel.add(this.borderPreviewLabel);
        this.borderPreviewLabel.setBounds(140, 70, 50, 20);
        this.selectBorderColorButton.setText("Select");
        this.selectBorderColorButton.setMargin(new Insets(0, 0, 0, 0));
        this.selectBorderColorButton.setPreferredSize(new Dimension(80, 26));
        this.selectBorderColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParagraphPropertiesDialog.this.selectBorderColorButtonActionPerformed(evt);
            }
        });
        this.backgroundPanel.add(this.selectBorderColorButton);
        this.selectBorderColorButton.setBounds(190, 70, 100, 26);
        this.automaticBorderColorButton.setText("Automatic");
        this.automaticBorderColorButton.setMargin(new Insets(0, 0, 0, 0));
        this.automaticBorderColorButton.setPreferredSize(new Dimension(80, 26));
        this.automaticBorderColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParagraphPropertiesDialog.this.automaticBorderColorButtonActionPerformed(evt);
            }
        });
        this.backgroundPanel.add(this.automaticBorderColorButton);
        this.automaticBorderColorButton.setBounds(300, 70, 100, 26);
        this.borderWidthLabel.setHorizontalAlignment(4);
        this.borderWidthLabel.setText("Border width:");
        this.backgroundPanel.add(this.borderWidthLabel);
        this.borderWidthLabel.setBounds(10, 110, 120, 16);
        this.borderWidthTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParagraphPropertiesDialog.this.borderWidthTextFieldActionPerformed(evt);
            }
        });
        this.backgroundPanel.add(this.borderWidthTextField);
        this.borderWidthTextField.setBounds(203, 110, 70, 20);
        this.mainPanel.add(this.backgroundPanel);
        this.backgroundPanel.setBounds(10, 150, 410, 150);
        this.styleClassLabel.setHorizontalAlignment(4);
        this.styleClassLabel.setText("Style:");
        this.mainPanel.add(this.styleClassLabel);
        this.styleClassLabel.setBounds(10, 310, 90, 16);
        this.styleClassComboBox.setEditable(true);
        this.styleClassComboBox.setVerifyInputWhenFocusTarget(false);
        this.mainPanel.add(this.styleClassComboBox);
        this.styleClassComboBox.setBounds(110, 310, 180, 20);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.buttonsPanel.setLayout(new FlowLayout(2));
        this.okButton.setText("Ok");
        this.okButton.setMargin(new Insets(0, 0, 0, 0));
        this.okButton.setPreferredSize(new Dimension(120, 26));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParagraphPropertiesDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonsPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMargin(new Insets(0, 0, 0, 0));
        this.cancelButton.setPreferredSize(new Dimension(120, 26));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParagraphPropertiesDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonsPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonsPanel, "South");
        this.pack();
    }

    private void borderWidthTextFieldActionPerformed(ActionEvent evt) {
    }

    private void automaticBorderColorButtonActionPerformed(ActionEvent evt) {
        this.borderPreviewLabel.setText("");
        this.borderPreviewLabel.setOpaque(false);
        this.borderWidthTextField.setText("");
    }

    private void selectBorderColorButtonActionPerformed(ActionEvent evt) {
        if (this.htmlPanel.colorChooserDialog == null) {
            this.htmlPanel.colorChooserDialog = SwingUtilities.windowForComponent(this) instanceof Frame ? new ColorChooserDialog((Frame)SwingUtilities.windowForComponent(this), true, this.htmlPanel.getTranslatedString("Choose Foreground Color")) : new ColorChooserDialog((Dialog)SwingUtilities.windowForComponent(this), true, this.htmlPanel.getTranslatedString("Choose Foreground Color"));
        }
        this.htmlPanel.colorChooserDialog.setTitle(this.htmlPanel.getTranslatedString("Choose Border Color"));
        if (this.borderPreviewLabel.isOpaque()) {
            this.htmlPanel.colorChooserDialog.setSelectedColor(this.borderPreviewLabel.getBackground());
        } else {
            this.htmlPanel.colorChooserDialog.setSelectedColor(null);
        }
        this.htmlPanel.translateContainer(this.htmlPanel.colorChooserDialog);
        this.htmlPanel.colorChooserDialog.setVisible(true);
        int result = this.htmlPanel.colorChooserDialog.getActionResult();
        ColorChooserDialog cfr_ignored_0 = this.htmlPanel.colorChooserDialog;
        if (result == ColorChooserDialog.OK_BUTTON) {
            Color newColor = this.htmlPanel.colorChooserDialog.getSelectedColor();
            if (newColor == null) {
                return;
            }
            this.borderPreviewLabel.setBackground(newColor);
            this.borderPreviewLabel.setOpaque(true);
            this.borderPreviewLabel.setText(Integer.toHexString(newColor.getRGB()));
            if (this.borderWidthTextField.getText().trim().equals("")) {
                this.borderWidthTextField.setText("1");
            }
        }
    }

    private void leftMarginTextFieldActionPerformed(ActionEvent evt) {
    }

    private void bottomMarginTextFieldActionPerformed(ActionEvent evt) {
    }

    private void automaticBackgroundColorButtonActionPerformed(ActionEvent evt) {
        this.backgroundPreviewLabel.setText("");
        this.backgroundPreviewLabel.setOpaque(false);
    }

    private void selectBackgroundColorButtonActionPerformed(ActionEvent evt) {
        if (this.htmlPanel.colorChooserDialog == null) {
            this.htmlPanel.colorChooserDialog = SwingUtilities.windowForComponent(this) instanceof Frame ? new ColorChooserDialog((Frame)SwingUtilities.windowForComponent(this), true, this.htmlPanel.getTranslatedString("Choose Foreground Color")) : new ColorChooserDialog((Dialog)SwingUtilities.windowForComponent(this), true, this.htmlPanel.getTranslatedString("Choose Foreground Color"));
        }
        this.htmlPanel.colorChooserDialog.setTitle(this.htmlPanel.getTranslatedString("Choose Background Color"));
        if (this.backgroundPreviewLabel.isOpaque()) {
            this.htmlPanel.colorChooserDialog.setSelectedColor(this.backgroundPreviewLabel.getBackground());
        } else {
            this.htmlPanel.colorChooserDialog.setSelectedColor(null);
        }
        this.htmlPanel.translateContainer(this.htmlPanel.colorChooserDialog);
        this.htmlPanel.colorChooserDialog.setVisible(true);
        int result = this.htmlPanel.colorChooserDialog.getActionResult();
        ColorChooserDialog cfr_ignored_0 = this.htmlPanel.colorChooserDialog;
        if (result == ColorChooserDialog.OK_BUTTON) {
            Color newColor = this.htmlPanel.colorChooserDialog.getSelectedColor();
            if (newColor == null) {
                return;
            }
            this.backgroundPreviewLabel.setBackground(newColor);
            this.backgroundPreviewLabel.setOpaque(true);
            this.backgroundPreviewLabel.setText(Integer.toHexString(newColor.getRGB()));
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.cancel = true;
        this.setVisible(false);
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.cancel = false;
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new ParagraphPropertiesDialog((Frame)new JFrame(), true).setVisible(true);
    }

    public void setVisible(boolean b) {
        this.setSize(440, 440);
        if (b) {
            this.setLocation((int)((double)this.getParent().getLocationOnScreen().x + this.getParent().getBounds().getWidth() / 2.0 - this.getBounds().getWidth() / 2.0), (int)((double)this.getParent().getLocationOnScreen().y + this.getParent().getBounds().getHeight() / 2.0 - this.getBounds().getHeight() / 2.0));
        }
        super.setVisible(b);
    }

    public void initDialogFields(AttributeSet attribs) {
        this.attributes = attribs;
        Object margin_left = attribs.getAttribute(CSS.Attribute.MARGIN_LEFT);
        if (margin_left != null && this.attributes.containsAttribute(CSS.Attribute.MARGIN_LEFT, margin_left)) {
            this.leftMarginTextField.setText(margin_left.toString());
        } else if (attribs.getAttribute(AlternativeCSSAttribute.MARGIN_LEFT) != null && this.attributes.containsAttribute(AlternativeCSSAttribute.MARGIN_LEFT, attribs.getAttribute(AlternativeCSSAttribute.MARGIN_LEFT))) {
            this.leftMarginTextField.setText(attribs.getAttribute(AlternativeCSSAttribute.MARGIN_LEFT).toString());
        } else {
            this.leftMarginTextField.setText("");
        }
        Object margin_right = attribs.getAttribute(CSS.Attribute.MARGIN_RIGHT);
        if (margin_right != null && this.attributes.containsAttribute(CSS.Attribute.MARGIN_RIGHT, margin_right)) {
            this.rightMarginTextField.setText(margin_right.toString());
        } else if (attribs.getAttribute(AlternativeCSSAttribute.MARGIN_RIGHT) != null && this.attributes.containsAttribute(AlternativeCSSAttribute.MARGIN_RIGHT, attribs.getAttribute(AlternativeCSSAttribute.MARGIN_RIGHT))) {
            this.rightMarginTextField.setText(attribs.getAttribute(AlternativeCSSAttribute.MARGIN_RIGHT).toString());
        } else {
            this.rightMarginTextField.setText("");
        }
        Object margin_top = attribs.getAttribute(CSS.Attribute.MARGIN_TOP);
        if (margin_top != null && this.attributes.containsAttribute(CSS.Attribute.MARGIN_TOP, margin_top)) {
            this.topMarginTextField.setText(margin_top.toString());
        } else if (attribs.getAttribute(AlternativeCSSAttribute.MARGIN_TOP) != null && this.attributes.containsAttribute(AlternativeCSSAttribute.MARGIN_TOP, attribs.getAttribute(AlternativeCSSAttribute.MARGIN_TOP))) {
            this.topMarginTextField.setText(attribs.getAttribute(AlternativeCSSAttribute.MARGIN_TOP).toString());
        } else {
            this.topMarginTextField.setText("");
        }
        Object margin_bottom = attribs.getAttribute(CSS.Attribute.MARGIN_BOTTOM);
        if (margin_bottom != null && this.attributes.containsAttribute(CSS.Attribute.MARGIN_BOTTOM, margin_bottom)) {
            this.bottomMarginTextField.setText(margin_bottom.toString());
        } else if (attribs.getAttribute(AlternativeCSSAttribute.MARGIN_BOTTOM) != null && this.attributes.containsAttribute(AlternativeCSSAttribute.MARGIN_BOTTOM, attribs.getAttribute(AlternativeCSSAttribute.MARGIN_BOTTOM))) {
            this.bottomMarginTextField.setText(attribs.getAttribute(AlternativeCSSAttribute.MARGIN_BOTTOM).toString());
        } else {
            this.bottomMarginTextField.setText("");
        }
        Object line_spacing = attribs.getAttribute(CSS.Attribute.LINE_HEIGHT);
        if (line_spacing != null && this.attributes.containsAttribute(CSS.Attribute.LINE_HEIGHT, line_spacing)) {
            this.lineSpacingTextField.setText(line_spacing.toString());
        } else {
            this.lineSpacingTextField.setText("");
        }
        Object text_indent = attribs.getAttribute(CSS.Attribute.TEXT_INDENT);
        if (text_indent != null && this.attributes.containsAttribute(CSS.Attribute.TEXT_INDENT, text_indent)) {
            this.indentFirstLineTextField.setText(text_indent.toString());
        } else {
            this.indentFirstLineTextField.setText("");
        }
        Object bgColor = attribs.getAttribute(CSS.Attribute.BACKGROUND_COLOR);
        if (bgColor != null && this.attributes.containsAttribute(CSS.Attribute.BACKGROUND_COLOR, bgColor)) {
            try {
                this.backgroundPreviewLabel.setText(bgColor.toString());
                this.backgroundPreviewLabel.setBackground(this.htmlPanel.convertStringToColor(bgColor.toString()));
                this.backgroundPreviewLabel.setOpaque(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.backgroundPreviewLabel.setText("");
            this.backgroundPreviewLabel.setOpaque(false);
        }
        Object borderColor = attribs.getAttribute(CSS.Attribute.BORDER_COLOR);
        if (borderColor != null && this.attributes.containsAttribute(CSS.Attribute.BORDER_COLOR, borderColor)) {
            try {
                this.borderPreviewLabel.setText(borderColor.toString());
                this.borderPreviewLabel.setBackground(this.htmlPanel.convertStringToColor(borderColor.toString()));
                this.borderPreviewLabel.setOpaque(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.borderPreviewLabel.setText("");
            this.borderPreviewLabel.setOpaque(false);
        }
        this.styleClassComboBox.setModel(new DefaultComboBoxModel(this.htmlPanel.getStyleClasses()));
        String styleClass = (String)attribs.getAttribute(HTML.Attribute.CLASS);
        if (styleClass != null && this.attributes.containsAttribute(HTML.Attribute.CLASS, styleClass)) {
            this.styleClassComboBox.setSelectedItem(styleClass);
        } else {
            this.styleClassComboBox.setSelectedIndex(-1);
        }
        this.styleClassComboBox.setRenderer(this.htmlPanel.getStyleClassRendererInstance());
        if (this.attributes.getAttribute(CSS.Attribute.BORDER_BOTTOM_WIDTH) != null && this.attributes.getAttribute(CSS.Attribute.BORDER_TOP_WIDTH) != null && this.attributes.getAttribute(CSS.Attribute.BORDER_LEFT_WIDTH) != null && this.attributes.getAttribute(CSS.Attribute.BORDER_RIGHT_WIDTH) != null) {
            if (this.attributes.containsAttribute(CSS.Attribute.BORDER_BOTTOM_WIDTH, this.attributes.getAttribute(CSS.Attribute.BORDER_BOTTOM_WIDTH))) {
                this.borderWidthTextField.setText((int)SferyxUtilities.getNumberFromCSString(this.attributes.getAttribute(CSS.Attribute.BORDER_BOTTOM_WIDTH).toString()) + "");
            } else {
                this.borderWidthTextField.setText("");
            }
        } else if (this.attributes.getAttribute(CSS.Attribute.BORDER_WIDTH) != null) {
            if (this.attributes.containsAttribute(CSS.Attribute.BORDER_WIDTH, this.attributes.getAttribute(CSS.Attribute.BORDER_WIDTH))) {
                this.borderWidthTextField.setText((int)SferyxUtilities.getNumberFromCSString(this.attributes.getAttribute(CSS.Attribute.BORDER_WIDTH).toString()) + "");
            } else {
                this.borderWidthTextField.setText("");
            }
        } else {
            this.borderWidthTextField.setText("");
        }
        this.okButton.requestFocus();
    }

    public AttributeSet getNewAttributes() {
        if (this.cancel) {
            return null;
        }
        SimpleAttributeSet newAttribs = new SimpleAttributeSet(this.attributes);
        if (!this.leftMarginTextField.getText().equals("")) {
            newAttribs.removeAttribute(CSS.Attribute.MARGIN_LEFT);
            try {
                this.doc.getStyleSheet().addCSSAttribute(newAttribs, CSS.Attribute.MARGIN_LEFT, Float.parseFloat(this.leftMarginTextField.getText()) + "px");
            }
            catch (Throwable thr) {
                this.doc.getStyleSheet().addCSSAttribute(newAttribs, CSS.Attribute.MARGIN_LEFT, this.leftMarginTextField.getText());
            }
        } else {
            newAttribs.removeAttribute(CSS.Attribute.MARGIN_LEFT);
        }
        if (!this.rightMarginTextField.getText().equals("")) {
            newAttribs.removeAttribute(CSS.Attribute.MARGIN_RIGHT);
            try {
                this.doc.getStyleSheet().addCSSAttribute(newAttribs, CSS.Attribute.MARGIN_RIGHT, Float.parseFloat(this.rightMarginTextField.getText()) + "px");
            }
            catch (Throwable thr) {
                this.doc.getStyleSheet().addCSSAttribute(newAttribs, CSS.Attribute.MARGIN_RIGHT, this.rightMarginTextField.getText());
            }
        } else {
            newAttribs.removeAttribute(CSS.Attribute.MARGIN_RIGHT);
        }
        if (!this.topMarginTextField.getText().equals("")) {
            newAttribs.removeAttribute(CSS.Attribute.MARGIN_TOP);
            try {
                this.doc.getStyleSheet().addCSSAttribute(newAttribs, CSS.Attribute.MARGIN_TOP, Float.parseFloat(this.topMarginTextField.getText()) + "px");
            }
            catch (Throwable thr) {
                this.doc.getStyleSheet().addCSSAttribute(newAttribs, CSS.Attribute.MARGIN_TOP, this.topMarginTextField.getText());
            }
        } else {
            newAttribs.removeAttribute(CSS.Attribute.MARGIN_TOP);
        }
        if (!this.bottomMarginTextField.getText().equals("")) {
            newAttribs.removeAttribute(CSS.Attribute.MARGIN_BOTTOM);
            try {
                this.doc.getStyleSheet().addCSSAttribute(newAttribs, CSS.Attribute.MARGIN_BOTTOM, Float.parseFloat(this.bottomMarginTextField.getText()) + "px");
            }
            catch (Throwable thr) {
                this.doc.getStyleSheet().addCSSAttribute(newAttribs, CSS.Attribute.MARGIN_BOTTOM, this.bottomMarginTextField.getText());
            }
        } else {
            newAttribs.removeAttribute(CSS.Attribute.MARGIN_BOTTOM);
        }
        if (!this.lineSpacingTextField.getText().trim().equals("")) {
            this.doc.getStyleSheet().addCSSAttribute(newAttribs, CSS.Attribute.LINE_HEIGHT, this.lineSpacingTextField.getText());
        } else {
            newAttribs.removeAttribute(CSS.Attribute.LINE_HEIGHT);
        }
        if (!this.indentFirstLineTextField.getText().equals("")) {
            newAttribs.removeAttribute(CSS.Attribute.TEXT_INDENT);
            try {
                newAttribs.addAttribute(CSS.Attribute.TEXT_INDENT, Float.parseFloat(this.indentFirstLineTextField.getText()) + "px");
            }
            catch (Throwable thr) {
                newAttribs.addAttribute(CSS.Attribute.TEXT_INDENT, this.indentFirstLineTextField.getText());
            }
        } else {
            newAttribs.removeAttribute(CSS.Attribute.TEXT_INDENT);
        }
        String bgcolor = this.backgroundPreviewLabel.getText();
        if (bgcolor.length() == 8) {
            bgcolor = bgcolor.substring(2);
        }
        if (!bgcolor.equals("")) {
            newAttribs.removeAttribute(CSS.Attribute.BACKGROUND_COLOR);
            StyleConstants.setBackground(newAttribs, this.backgroundPreviewLabel.getBackground());
        } else {
            newAttribs.removeAttribute(CSS.Attribute.BACKGROUND_COLOR);
        }
        String bordercolor = this.borderPreviewLabel.getText();
        if (bordercolor.length() == 8) {
            bordercolor = bordercolor.substring(2);
        }
        if (bordercolor.startsWith("#")) {
            bordercolor = bordercolor.substring(1);
        }
        int borderWidth = (int)SferyxUtilities.getNumberFromCSString(this.borderWidthTextField.getText());
        if (!bordercolor.equals("")) {
            ((HTMLDocument)this.htmlPanel.getInternalJEditorPane().getDocument()).getStyleSheet().addCSSAttribute(newAttribs, CSS.Attribute.BORDER_COLOR, "#" + bordercolor);
            ((HTMLDocument)this.htmlPanel.getInternalJEditorPane().getDocument()).getStyleSheet().addCSSAttribute(newAttribs, CSS.Attribute.BORDER_STYLE, "solid");
            if (borderWidth >= 0) {
                ((HTMLDocument)this.htmlPanel.getInternalJEditorPane().getDocument()).getStyleSheet().addCSSAttribute(newAttribs, CSS.Attribute.BORDER_WIDTH, borderWidth + "");
            } else if (borderWidth < 0) {
                newAttribs.removeAttribute(CSS.Attribute.BORDER_WIDTH);
                newAttribs.removeAttribute(CSS.Attribute.BORDER_LEFT_WIDTH);
                newAttribs.removeAttribute(CSS.Attribute.BORDER_RIGHT_WIDTH);
                newAttribs.removeAttribute(CSS.Attribute.BORDER_TOP_WIDTH);
                newAttribs.removeAttribute(CSS.Attribute.BORDER_BOTTOM_WIDTH);
                newAttribs.removeAttribute(CSS.Attribute.BORDER_STYLE);
            }
        } else {
            newAttribs.removeAttribute(CSS.Attribute.BORDER_COLOR);
            if (borderWidth > 0) {
                ((HTMLDocument)this.htmlPanel.getInternalJEditorPane().getDocument()).getStyleSheet().addCSSAttribute(newAttribs, CSS.Attribute.BORDER_WIDTH, borderWidth + "");
            } else if (borderWidth <= 0) {
                newAttribs.removeAttribute(CSS.Attribute.BORDER_WIDTH);
                newAttribs.removeAttribute(CSS.Attribute.BORDER_LEFT_WIDTH);
                newAttribs.removeAttribute(CSS.Attribute.BORDER_RIGHT_WIDTH);
                newAttribs.removeAttribute(CSS.Attribute.BORDER_TOP_WIDTH);
                newAttribs.removeAttribute(CSS.Attribute.BORDER_BOTTOM_WIDTH);
                newAttribs.removeAttribute(CSS.Attribute.BORDER_STYLE);
            }
        }
        if (this.styleClassComboBox.getSelectedItem() != null && !((String)this.styleClassComboBox.getSelectedItem()).trim().equals("")) {
            newAttribs.addAttribute(HTML.Attribute.CLASS, this.styleClassComboBox.getSelectedItem());
        } else {
            newAttribs.removeAttribute(HTML.Attribute.CLASS);
        }
        return newAttribs;
    }

    public void setDocument(HTMLDocument doc) {
        this.doc = doc;
    }

    public void setHtmlPanel(HTMLEditor html_Panel) {
        this.htmlPanel = html_Panel;
    }
}

