/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import sferyx.administration.editors.HTMLEditor;

public class ListPropertiesDialog
extends JDialog
implements ChangeListener {
    HTMLEditor htmlPanel;
    boolean cancel = false;
    AttributeSet attributes;
    BevelBorder selectionBorder = new BevelBorder(1, Color.blue, Color.blue);
    BevelBorder defaultBorder = new BevelBorder(1);
    private JButton OkButton;
    private JToggleButton plainBulletToggleButton;
    private JComboBox styleClassComboBox;
    private JLabel jLabel1;
    private JPanel buttonsPanel;
    private JToggleButton numbersToggleButton;
    private JTextField startsAtTextField;
    private JPanel mainPanel;
    private JLabel styleClassLabel;
    private JToggleButton romanSmallToggleButton;
    private JToggleButton circleToggleButton;
    private JButton CancelButton;
    private JPanel startsAtPanel;
    private ButtonGroup listTypeButtonGroup;
    private JToggleButton lettersToggleButton;
    private JToggleButton romanToggleButton;
    private JToggleButton squareToggleButton;
    private JToggleButton lettersSmallToggleButton;

    public ListPropertiesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.addListener();
    }

    void addListener() {
        this.plainBulletToggleButton.addChangeListener(this);
        this.numbersToggleButton.addChangeListener(this);
        this.romanSmallToggleButton.addChangeListener(this);
        this.circleToggleButton.addChangeListener(this);
        this.lettersToggleButton.addChangeListener(this);
        this.romanToggleButton.addChangeListener(this);
        this.squareToggleButton.addChangeListener(this);
        this.lettersSmallToggleButton.addChangeListener(this);
    }

    public ListPropertiesDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.addListener();
    }

    private void initComponents() {
        this.listTypeButtonGroup = new ButtonGroup();
        this.mainPanel = new JPanel();
        this.plainBulletToggleButton = new JToggleButton();
        this.circleToggleButton = new JToggleButton();
        this.squareToggleButton = new JToggleButton();
        this.numbersToggleButton = new JToggleButton();
        this.romanToggleButton = new JToggleButton();
        this.romanSmallToggleButton = new JToggleButton();
        this.lettersToggleButton = new JToggleButton();
        this.lettersSmallToggleButton = new JToggleButton();
        this.startsAtPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.startsAtTextField = new JTextField();
        this.buttonsPanel = new JPanel();
        this.OkButton = new JButton();
        this.CancelButton = new JButton();
        this.styleClassLabel = new JLabel();
        this.styleClassComboBox = new JComboBox();
        this.setTitle("List Properties Dialog");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ListPropertiesDialog.this.closeDialog(evt);
            }
        });
        this.mainPanel.setLayout(new GridLayout(3, 3, 10, 10));
        this.mainPanel.setBorder(new TitledBorder("List type"));
        this.plainBulletToggleButton.setBackground(new Color(255, 255, 255));
        this.plainBulletToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/sferyx/administration/editors/icons/list-plain-bullets.gif")));
        this.listTypeButtonGroup.add(this.plainBulletToggleButton);
        this.plainBulletToggleButton.setActionCommand("plain");
        this.plainBulletToggleButton.setBorder(new BevelBorder(1));
        this.plainBulletToggleButton.setContentAreaFilled(false);
        this.plainBulletToggleButton.setFocusPainted(false);
        this.plainBulletToggleButton.setHorizontalTextPosition(0);
        this.plainBulletToggleButton.setMargin(new Insets(2, 0, 2, 0));
        this.mainPanel.add(this.plainBulletToggleButton);
        this.circleToggleButton.setBackground(new Color(255, 255, 255));
        this.circleToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/sferyx/administration/editors/icons/list-circle-bullets.gif")));
        this.listTypeButtonGroup.add(this.circleToggleButton);
        this.circleToggleButton.setActionCommand("circle");
        this.circleToggleButton.setBorder(new BevelBorder(1));
        this.circleToggleButton.setContentAreaFilled(false);
        this.circleToggleButton.setFocusPainted(false);
        this.circleToggleButton.setHorizontalTextPosition(0);
        this.circleToggleButton.setMargin(new Insets(2, 0, 2, 0));
        this.mainPanel.add(this.circleToggleButton);
        this.squareToggleButton.setBackground(new Color(255, 255, 255));
        this.squareToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/sferyx/administration/editors/icons/list-square-bullets.gif")));
        this.listTypeButtonGroup.add(this.squareToggleButton);
        this.squareToggleButton.setActionCommand("square");
        this.squareToggleButton.setBorder(new BevelBorder(1));
        this.squareToggleButton.setContentAreaFilled(false);
        this.squareToggleButton.setFocusPainted(false);
        this.squareToggleButton.setHorizontalTextPosition(0);
        this.squareToggleButton.setMargin(new Insets(2, 0, 2, 0));
        this.mainPanel.add(this.squareToggleButton);
        this.numbersToggleButton.setBackground(new Color(255, 255, 255));
        this.numbersToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/sferyx/administration/editors/icons/list-numbered.gif")));
        this.listTypeButtonGroup.add(this.numbersToggleButton);
        this.numbersToggleButton.setActionCommand("numbers");
        this.numbersToggleButton.setBorder(new BevelBorder(1));
        this.numbersToggleButton.setContentAreaFilled(false);
        this.numbersToggleButton.setFocusPainted(false);
        this.numbersToggleButton.setHorizontalTextPosition(0);
        this.numbersToggleButton.setMargin(new Insets(2, 0, 2, 0));
        this.mainPanel.add(this.numbersToggleButton);
        this.romanToggleButton.setBackground(new Color(255, 255, 255));
        this.romanToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/sferyx/administration/editors/icons/list-roman.gif")));
        this.listTypeButtonGroup.add(this.romanToggleButton);
        this.romanToggleButton.setActionCommand("I");
        this.romanToggleButton.setBorder(new BevelBorder(1));
        this.romanToggleButton.setContentAreaFilled(false);
        this.romanToggleButton.setFocusPainted(false);
        this.romanToggleButton.setHorizontalTextPosition(0);
        this.romanToggleButton.setMargin(new Insets(2, 0, 2, 0));
        this.mainPanel.add(this.romanToggleButton);
        this.romanSmallToggleButton.setBackground(new Color(255, 255, 255));
        this.romanSmallToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/sferyx/administration/editors/icons/list-roman-small.gif")));
        this.listTypeButtonGroup.add(this.romanSmallToggleButton);
        this.romanSmallToggleButton.setActionCommand("i");
        this.romanSmallToggleButton.setBorder(new BevelBorder(1));
        this.romanSmallToggleButton.setContentAreaFilled(false);
        this.romanSmallToggleButton.setFocusPainted(false);
        this.romanSmallToggleButton.setHorizontalTextPosition(0);
        this.romanSmallToggleButton.setMargin(new Insets(2, 0, 2, 0));
        this.mainPanel.add(this.romanSmallToggleButton);
        this.lettersToggleButton.setBackground(new Color(255, 255, 255));
        this.lettersToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/sferyx/administration/editors/icons/list-letters.gif")));
        this.listTypeButtonGroup.add(this.lettersToggleButton);
        this.lettersToggleButton.setActionCommand("A");
        this.lettersToggleButton.setBorder(new BevelBorder(1));
        this.lettersToggleButton.setContentAreaFilled(false);
        this.lettersToggleButton.setFocusPainted(false);
        this.lettersToggleButton.setHorizontalTextPosition(0);
        this.lettersToggleButton.setMargin(new Insets(2, 0, 2, 0));
        this.mainPanel.add(this.lettersToggleButton);
        this.lettersSmallToggleButton.setBackground(new Color(255, 255, 255));
        this.lettersSmallToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/sferyx/administration/editors/icons/list-letters-small.gif")));
        this.listTypeButtonGroup.add(this.lettersSmallToggleButton);
        this.lettersSmallToggleButton.setActionCommand("a");
        this.lettersSmallToggleButton.setBorder(new BevelBorder(1));
        this.lettersSmallToggleButton.setContentAreaFilled(false);
        this.lettersSmallToggleButton.setFocusPainted(false);
        this.lettersSmallToggleButton.setHorizontalTextPosition(0);
        this.lettersSmallToggleButton.setMargin(new Insets(2, 0, 2, 0));
        this.mainPanel.add(this.lettersSmallToggleButton);
        this.startsAtPanel.setLayout(null);
        this.startsAtPanel.setBorder(new BevelBorder(1));
        this.jLabel1.setText("Starts at:");
        this.startsAtPanel.add(this.jLabel1);
        this.jLabel1.setBounds(10, 30, 60, 16);
        this.startsAtPanel.add(this.startsAtTextField);
        this.startsAtTextField.setBounds(10, 47, 60, 26);
        this.mainPanel.add(this.startsAtPanel);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.buttonsPanel.setLayout(null);
        this.buttonsPanel.setPreferredSize(new Dimension(215, 70));
        this.OkButton.setText("Ok");
        this.OkButton.setPreferredSize(new Dimension(100, 26));
        this.OkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListPropertiesDialog.this.OkButtonActionPerformed(evt);
            }
        });
        this.buttonsPanel.add(this.OkButton);
        this.OkButton.setBounds(100, 40, 100, 26);
        this.CancelButton.setText("Cancel");
        this.CancelButton.setMaximumSize(new Dimension(1000, 26));
        this.CancelButton.setMinimumSize(new Dimension(200, 26));
        this.CancelButton.setPreferredSize(new Dimension(100, 26));
        this.CancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListPropertiesDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.buttonsPanel.add(this.CancelButton);
        this.CancelButton.setBounds(210, 40, 100, 26);
        this.styleClassLabel.setText("Style:");
        this.buttonsPanel.add(this.styleClassLabel);
        this.styleClassLabel.setBounds(10, 10, 60, 16);
        this.styleClassComboBox.setEditable(true);
        this.styleClassComboBox.setVerifyInputWhenFocusTarget(false);
        this.buttonsPanel.add(this.styleClassComboBox);
        this.styleClassComboBox.setBounds(70, 10, 210, 20);
        this.getContentPane().add((Component)this.buttonsPanel, "South");
        this.pack();
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.cancel = true;
        this.setVisible(false);
        this.dispose();
    }

    private void OkButtonActionPerformed(ActionEvent evt) {
        this.cancel = false;
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new ListPropertiesDialog((Frame)new JFrame(), true).show();
    }

    public void setVisible(boolean b) {
        if (b) {
            this.setSize(330, 410);
            this.setLocation((int)((double)this.getParent().getLocationOnScreen().x + this.getParent().getBounds().getWidth() / 2.0 - this.getBounds().getWidth() / 2.0), (int)((double)this.getParent().getLocationOnScreen().y + this.getParent().getBounds().getHeight() / 2.0 - this.getBounds().getHeight() / 2.0));
        }
        super.setVisible(b);
    }

    public void initDialogFields(AttributeSet attribs) {
        this.attributes = attribs;
        String type = (String)attribs.getAttribute(HTML.Attribute.TYPE);
        HTML.Tag listType = (HTML.Tag)attribs.getAttribute(StyleConstants.NameAttribute);
        if (listType == HTML.Tag.OL) {
            if (type == null) {
                this.numbersToggleButton.setSelected(true);
            } else if (type != null && this.attributes.containsAttribute(HTML.Attribute.TYPE, type)) {
                if (type.equals("i")) {
                    this.romanSmallToggleButton.setSelected(true);
                }
                if (type.equals("I")) {
                    this.romanToggleButton.setSelected(true);
                }
                if (type.equals("a")) {
                    this.lettersSmallToggleButton.setSelected(true);
                }
                if (type.equals("A")) {
                    this.lettersToggleButton.setSelected(true);
                }
            }
        } else if (listType == HTML.Tag.UL) {
            if (type == null) {
                this.plainBulletToggleButton.setSelected(true);
            } else if (type != null && this.attributes.containsAttribute(HTML.Attribute.TYPE, type)) {
                if (type.equals("i")) {
                    this.romanSmallToggleButton.setSelected(true);
                }
                if (type.equals("I")) {
                    this.romanToggleButton.setSelected(true);
                }
                if (type.equals("a")) {
                    this.lettersSmallToggleButton.setSelected(true);
                }
                if (type.equals("A")) {
                    this.lettersToggleButton.setSelected(true);
                }
                if (type.equals("circle")) {
                    this.circleToggleButton.setSelected(true);
                }
                if (type.equals("square")) {
                    this.squareToggleButton.setSelected(true);
                }
            }
        }
        String start = (String)attribs.getAttribute(HTML.Attribute.START);
        if (start != null) {
            this.startsAtTextField.setText(start);
        }
        this.styleClassComboBox.setModel(new DefaultComboBoxModel(this.htmlPanel.getStyleClasses()));
        String styleClass = (String)attribs.getAttribute(HTML.Attribute.CLASS);
        if (styleClass != null && this.attributes.containsAttribute(HTML.Attribute.CLASS, styleClass)) {
            this.styleClassComboBox.setSelectedItem(styleClass);
        } else {
            this.styleClassComboBox.setSelectedIndex(-1);
        }
        this.styleClassComboBox.setRenderer(this.htmlPanel.getStyleClassRendererInstance());
    }

    public AttributeSet getNewAttributes() {
        if (this.cancel) {
            return null;
        }
        SimpleAttributeSet newAttribs = new SimpleAttributeSet(this.attributes);
        JToggleButton.ToggleButtonModel model = (JToggleButton.ToggleButtonModel)this.listTypeButtonGroup.getSelection();
        String type = model.getActionCommand();
        if (type == null) {
            return newAttribs;
        }
        HTML.Tag listType = (HTML.Tag)this.attributes.getAttribute(StyleConstants.NameAttribute);
        if (type.equals("plain")) {
            newAttribs.addAttribute(StyleConstants.NameAttribute, HTML.Tag.UL);
            newAttribs.removeAttribute(HTML.Attribute.TYPE);
        } else if (type.equals("numbers")) {
            newAttribs.addAttribute(StyleConstants.NameAttribute, HTML.Tag.OL);
            newAttribs.removeAttribute(HTML.Attribute.TYPE);
        } else {
            newAttribs.addAttribute(HTML.Attribute.TYPE, type);
        }
        String startsAt = this.startsAtTextField.getText();
        if (!startsAt.equals("")) {
            newAttribs.addAttribute(HTML.Attribute.START, startsAt);
        } else {
            newAttribs.removeAttribute(HTML.Attribute.START);
        }
        if (this.styleClassComboBox.getSelectedItem() != null && !((String)this.styleClassComboBox.getSelectedItem()).trim().equals("")) {
            newAttribs.addAttribute(HTML.Attribute.CLASS, this.styleClassComboBox.getSelectedItem());
        } else {
            newAttribs.removeAttribute(HTML.Attribute.CLASS);
        }
        return newAttribs;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object source = changeEvent.getSource();
        if (!(source instanceof JToggleButton)) {
            return;
        }
        JToggleButton toggleButton = (JToggleButton)source;
        if (toggleButton.isSelected()) {
            toggleButton.setBorder(this.selectionBorder);
        } else {
            toggleButton.setBorder(this.defaultBorder);
        }
    }

    public void setHtmlPanel(HTMLEditor html_Panel) {
        this.htmlPanel = html_Panel;
    }
}

