/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import sferyx.administration.editors.HTMLEditor;
import sferyx.administration.editors.XHTMLWriter;

public class InternalHTMLWriter
extends XHTMLWriter {
    public InternalHTMLWriter(Writer w, HTMLDocument doc, int pos, int len) {
        super(w, doc, pos, len);
    }

    public void writeAttributes(AttributeSet attr) throws IOException {
        AttributeSet convAttr = attr;
        if (HTMLEditor.isForcedCSSGeneration()) {
            convAttr = new SimpleAttributeSet();
            InternalHTMLWriter.convertToHTML40(attr, (MutableAttributeSet)convAttr);
            Enumeration<?> names = convAttr.getAttributeNames();
            while (names.hasMoreElements()) {
                Object name = names.nextElement();
                if (name instanceof HTML.Tag || name instanceof StyleConstants || name == HTML.Attribute.ENDTAG) continue;
                this.write(" " + name + "=\"" + convAttr.getAttribute(name) + "\"");
            }
        } else {
            super.writeAttributes(convAttr);
        }
    }

    protected void writeLineSeparator() throws IOException {
        if (this.inPre) {
            super.writeLineSeparator();
        }
    }

    protected void indent() throws IOException {
    }

    private static void convertToHTML40(AttributeSet from, MutableAttributeSet to) {
        Enumeration<?> keys = from.getAttributeNames();
        String value = "";
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (key instanceof CSS.Attribute) {
                if (key == CSS.Attribute.TEXT_ALIGN && from.getAttribute(HTML.Attribute.ALIGN) != null) continue;
                value = value + key + ":" + from.getAttribute(key) + ";";
                continue;
            }
            to.addAttribute(key, from.getAttribute(key));
        }
        if (value.length() > 0) {
            to.addAttribute(HTML.Attribute.STYLE, value);
        }
    }

    private void convertToExtendedAttributesMode(AttributeSet from, MutableAttributeSet to) {
        Enumeration<?> keys = from.getAttributeNames();
        String value = "";
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (key instanceof CSS.Attribute) {
                value = value + " " + key + "=" + from.getAttribute(key) + ";";
                continue;
            }
            Object i_value = from.getAttribute(key);
            if (key == HTML.Attribute.SIZE) {
                to.removeAttribute(CSS.Attribute.FONT_SIZE);
                to.addAttribute(CSS.Attribute.FONT_SIZE, ((HTMLDocument)this.getDocument()).getStyleSheet().getPointSize("" + i_value) + "pt");
                to.addAttribute(key, i_value);
                continue;
            }
            if (key == HTML.Attribute.FACE) {
                to.removeAttribute(CSS.Attribute.FONT_FAMILY);
                to.addAttribute(CSS.Attribute.FONT_FAMILY, i_value);
                to.addAttribute(key, i_value);
                continue;
            }
            if (key == HTML.Attribute.BORDER) {
                to.removeAttribute("cellborder");
                to.addAttribute("cellborder", i_value);
                to.addAttribute(key, i_value);
                continue;
            }
            if (key == HTML.Attribute.CELLSPACING) {
                to.removeAttribute("cellmargin");
                to.addAttribute("cellmargin", i_value);
                to.addAttribute(key, i_value);
                continue;
            }
            if (key.equals("font-size") || key.equals("font-family") || key.equals("cellmargin") || key.equals("cellborder")) continue;
            to.addAttribute(key, i_value);
        }
        if (value.length() > 0) {
            to.addAttribute(HTML.Attribute.STYLE, value);
        }
    }
}

