/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTMLEditorKit;
import sferyx.administration.editors.HTMLEditor;

public class InsertSymbolDialog
extends JDialog
implements ListCellRenderer {
    HTMLEditor htmlEditor;
    int selectedUnicode = -1;
    JLabel rendererLabel = new JLabel();
    Font currentSelectedFont;
    private JTable charsTable;
    private JLabel charTypeLabel;
    private JLabel selectedCharLabel;
    private JLabel previewLabel;
    private JLabel unicodeLabel;
    private JButton insertButton;
    private JPanel previewPanel;
    private JScrollPane charsTableScrollPane;
    private JButton closeButton;
    private JComboBox allFontsComboBox;
    static /* synthetic */ Class class$java$lang$Character;

    public InsertSymbolDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.charsTable.setColumnSelectionAllowed(false);
        this.previewLabel.setVisible(false);
        this.getLayeredPane().add((Component)this.previewLabel, JLayeredPane.POPUP_LAYER);
        this.allFontsComboBox.setRenderer(this);
        this.allFontsComboBoxItemStateChanged(null);
    }

    public InsertSymbolDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.charsTable.setColumnSelectionAllowed(false);
        this.previewLabel.setVisible(false);
        this.getLayeredPane().add((Component)this.previewLabel, JLayeredPane.POPUP_LAYER);
        this.allFontsComboBox.setRenderer(this);
        this.allFontsComboBoxItemStateChanged(null);
    }

    private void initComponents() {
        this.charTypeLabel = new JLabel();
        this.allFontsComboBox = new JComboBox();
        this.charsTableScrollPane = new JScrollPane();
        this.charsTable = new JTable();
        this.closeButton = new JButton();
        this.insertButton = new JButton();
        this.previewLabel = new JLabel();
        this.previewPanel = new JPanel();
        this.unicodeLabel = new JLabel();
        this.selectedCharLabel = new JLabel();
        this.getContentPane().setLayout(null);
        this.setTitle("Insert Symbol");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                InsertSymbolDialog.this.closeDialog(evt);
            }
        });
        this.charTypeLabel.setHorizontalAlignment(4);
        this.charTypeLabel.setText("Character type:");
        this.getContentPane().add(this.charTypeLabel);
        this.charTypeLabel.setBounds(10, 20, 150, 16);
        this.allFontsComboBox.setModel(new DefaultComboBoxModel<String>(HTMLEditor.fontNames));
        this.allFontsComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                InsertSymbolDialog.this.allFontsComboBoxItemStateChanged(evt);
            }
        });
        this.getContentPane().add(this.allFontsComboBox);
        this.allFontsComboBox.setBounds(170, 20, 270, 25);
        this.charsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Title 1", "Title 2", "Title 3", "Title 4", "Title 5", "Title 6", "Title 7", "Title 8", "Title 9", "Title 10", "Title 11", "Title 12", "Title 13", "Title 14", "Title 15", "Title 16", "Title 17", "Title 18", "Title 19", "Title 20"}){
            Class[] types = new Class[]{class$java$lang$Character == null ? (class$java$lang$Character = InsertSymbolDialog.class$("java.lang.Character")) : class$java$lang$Character, class$java$lang$Character == null ? (class$java$lang$Character = InsertSymbolDialog.class$("java.lang.Character")) : class$java$lang$Character, class$java$lang$Character == null ? (class$java$lang$Character = InsertSymbolDialog.class$("java.lang.Character")) : class$java$lang$Character, class$java$lang$Character == null ? (class$java$lang$Character = InsertSymbolDialog.class$("java.lang.Character")) : class$java$lang$Character, class$java$lang$Character == null ? (class$java$lang$Character = InsertSymbolDialog.class$("java.lang.Character")) : class$java$lang$Character, class$java$lang$Character == null ? (class$java$lang$Character = InsertSymbolDialog.class$("java.lang.Character")) : class$java$lang$Character, class$java$lang$Character == null ? (class$java$lang$Character = InsertSymbolDialog.class$("java.lang.Character")) : class$java$lang$Character, class$java$lang$Character == null ? (class$java$lang$Character = InsertSymbolDialog.class$("java.lang.Character")) : class$java$lang$Character, class$java$lang$Character == null ? (class$java$lang$Character = InsertSymbolDialog.class$("java.lang.Character")) : class$java$lang$Character, class$java$lang$Character == null ? (class$java$lang$Character = InsertSymbolDialog.class$("java.lang.Character")) : class$java$lang$Character, class$java$lang$Character == null ? (class$java$lang$Character = InsertSymbolDialog.class$("java.lang.Character")) : class$java$lang$Character, class$java$lang$Character == null ? (class$java$lang$Character = InsertSymbolDialog.class$("java.lang.Character")) : class$java$lang$Character, class$java$lang$Character == null ? (class$java$lang$Character = InsertSymbolDialog.class$("java.lang.Character")) : class$java$lang$Character, class$java$lang$Character == null ? (class$java$lang$Character = InsertSymbolDialog.class$("java.lang.Character")) : class$java$lang$Character, class$java$lang$Character == null ? (class$java$lang$Character = InsertSymbolDialog.class$("java.lang.Character")) : class$java$lang$Character, class$java$lang$Character == null ? (class$java$lang$Character = InsertSymbolDialog.class$("java.lang.Character")) : class$java$lang$Character, class$java$lang$Character == null ? (class$java$lang$Character = InsertSymbolDialog.class$("java.lang.Character")) : class$java$lang$Character, class$java$lang$Character == null ? (class$java$lang$Character = InsertSymbolDialog.class$("java.lang.Character")) : class$java$lang$Character, class$java$lang$Character == null ? (class$java$lang$Character = InsertSymbolDialog.class$("java.lang.Character")) : class$java$lang$Character, class$java$lang$Character == null ? (class$java$lang$Character = InsertSymbolDialog.class$("java.lang.Character")) : class$java$lang$Character};
            boolean[] canEdit = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.charsTable.setCellSelectionEnabled(true);
        this.charsTable.setRowSelectionAllowed(false);
        this.charsTable.setTableHeader(null);
        this.charsTable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                InsertSymbolDialog.this.charsTableKeyReleased(evt);
            }

            public void keyTyped(KeyEvent evt) {
                InsertSymbolDialog.this.charsTableKeyTyped(evt);
            }
        });
        this.charsTable.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent evt) {
                InsertSymbolDialog.this.charsTableMouseExited(evt);
            }

            public void mousePressed(MouseEvent evt) {
                InsertSymbolDialog.this.charsTableMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                InsertSymbolDialog.this.charsTableMouseReleased(evt);
            }
        });
        this.charsTable.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                InsertSymbolDialog.this.charsTableMouseDragged(evt);
            }

            public void mouseMoved(MouseEvent evt) {
                InsertSymbolDialog.this.charsTableMouseMoved(evt);
            }
        });
        this.charsTableScrollPane.setViewportView(this.charsTable);
        this.getContentPane().add(this.charsTableScrollPane);
        this.charsTableScrollPane.setBounds(10, 50, 430, 240);
        this.closeButton.setText("Close");
        this.closeButton.setMargin(new Insets(2, 0, 2, 0));
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InsertSymbolDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.closeButton);
        this.closeButton.setBounds(360, 330, 75, 26);
        this.insertButton.setText("Insert Symbol");
        this.insertButton.setMargin(new Insets(2, 4, 2, 0));
        this.insertButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InsertSymbolDialog.this.insertButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.insertButton);
        this.insertButton.setBounds(240, 330, 110, 26);
        this.previewLabel.setBackground(new Color(0, 51, 153));
        this.previewLabel.setForeground(new Color(255, 255, 255));
        this.previewLabel.setHorizontalAlignment(0);
        this.previewLabel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.previewLabel.setHorizontalTextPosition(0);
        this.previewLabel.setOpaque(true);
        this.getContentPane().add(this.previewLabel);
        this.previewLabel.setBounds(390, 290, 70, 50);
        this.previewPanel.setLayout(null);
        this.previewPanel.setBorder(new TitledBorder("Selection properties:"));
        this.previewPanel.setOpaque(false);
        this.unicodeLabel.setText("Unicode:");
        this.previewPanel.add(this.unicodeLabel);
        this.unicodeLabel.setBounds(10, 20, 100, 20);
        this.previewPanel.add(this.selectedCharLabel);
        this.selectedCharLabel.setBounds(130, 20, 80, 30);
        this.getContentPane().add(this.previewPanel);
        this.previewPanel.setBounds(10, 300, 220, 60);
        this.pack();
    }

    private void charsTableKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 27) {
            this.previewLabel.setVisible(false);
        }
    }

    private void charsTableKeyTyped(KeyEvent evt) {
    }

    private void charsTableMouseExited(MouseEvent evt) {
    }

    private void charsTableMouseMoved(MouseEvent evt) {
    }

    private void charsTableMouseReleased(MouseEvent evt) {
    }

    private void charsTableMousePressed(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        this.moveLabel(x, y);
    }

    private void charsTableMouseDragged(MouseEvent evt) {
    }

    private void allFontsComboBoxItemStateChanged(ItemEvent evt) {
        this.allFontsComboBoxItemStateChanged_();
        if (HTMLEditor.isMac) {
            class Table
            implements Runnable {
                Table() {
                }

                public void run() {
                    InsertSymbolDialog.this.toFront();
                }
            }
            SwingUtilities.invokeLater(new Table());
        }
    }

    private void allFontsComboBoxItemStateChanged_() {
        Font selectedFont;
        this.charsTable.clearSelection();
        this.previewLabel.setVisible(false);
        DefaultTableModel tableModel = (DefaultTableModel)this.charsTable.getModel();
        tableModel.setRowCount(0);
        this.currentSelectedFont = selectedFont = new Font((String)this.allFontsComboBox.getSelectedItem(), 0, 13);
        this.charsTable.setFont(this.currentSelectedFont);
        this.previewLabel.setFont(selectedFont.deriveFont(24.0f));
        this.selectedCharLabel.setFont(selectedFont.deriveFont(24.0f));
        int glyphsNum = selectedFont.getNumGlyphs();
        int columnCount = 0;
        Object[] rowData = new Character[20];
        for (int i = 0; i < 66000; ++i) {
            Character.UnicodeBlock charBlock;
            if (HTMLEditor.isMac && ((charBlock = Character.UnicodeBlock.of((char)i)) != null && (charBlock == Character.UnicodeBlock.HIRAGANA || charBlock == Character.UnicodeBlock.KATAKANA || charBlock == Character.UnicodeBlock.CJK_COMPATIBILITY || charBlock == Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS || charBlock == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || charBlock == Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT || charBlock == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || charBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || charBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A) || charBlock != null && charBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || charBlock != null && charBlock == Character.UnicodeBlock.CJK_COMPATIBILITY || charBlock != null && charBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || charBlock != null && charBlock == Character.UnicodeBlock.HIRAGANA || charBlock != null && charBlock == Character.UnicodeBlock.KATAKANA || charBlock != null && charBlock == Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO || charBlock != null && charBlock == Character.UnicodeBlock.HANGUL_JAMO || charBlock != null && charBlock == Character.UnicodeBlock.HANGUL_SYLLABLES || charBlock != null && charBlock == Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS || charBlock != null && charBlock == Character.UnicodeBlock.KANNADA || charBlock != null && charBlock == Character.UnicodeBlock.KANGXI_RADICALS || charBlock != null && charBlock == Character.UnicodeBlock.KANBUN || charBlock != null && charBlock == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || charBlock != null && charBlock == Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT || charBlock != null && charBlock == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || charBlock != null && charBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || charBlock == null) || !selectedFont.canDisplay((char)i)) continue;
            rowData[columnCount] = new Character((char)i);
            if (++columnCount != 20) continue;
            tableModel.addRow(rowData);
            Thread.currentThread();
            Thread.yield();
            this.charsTable.repaint();
            columnCount = 0;
            rowData = new Character[20];
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void insertButtonActionPerformed(ActionEvent evt) {
        this.htmlEditor.insertSymbol(this.selectedUnicode, this.currentSelectedFont);
        this.setVisible(false);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
    }

    public void setVisible(boolean b) {
        this.setSize(460, 400);
        if (b) {
            this.charsTable.clearSelection();
            this.previewLabel.setVisible(false);
            this.setLocation((int)((double)this.getParent().getLocationOnScreen().x + this.getParent().getBounds().getWidth() / 2.0 - this.getBounds().getWidth() / 2.0), (int)((double)this.getParent().getLocationOnScreen().y + this.getParent().getBounds().getHeight() / 2.0 - this.getBounds().getHeight() / 2.0));
        }
        super.setVisible(b);
    }

    public void moveLabel(int x, int y) {
        DefaultTableModel tableModel = (DefaultTableModel)this.charsTable.getModel();
        int row = this.charsTable.getSelectedRow();
        int column = this.charsTable.getSelectedColumn();
        Character sel_char = (Character)tableModel.getValueAt(row, column);
        char selChar = sel_char.charValue();
        this.previewLabel.setText("" + selChar);
        this.selectedCharLabel.setText("" + selChar);
        Point point = SwingUtilities.convertPoint(this.charsTable, x - 10, y - 10, this);
        this.previewLabel.setLocation(point);
        this.previewLabel.setVisible(true);
        this.unicodeLabel.setText("Unicode: U+" + selChar);
        this.selectedUnicode = selChar;
    }

    public void setHTMLEditor(HTMLEditor htmlEditor) {
        this.htmlEditor = htmlEditor;
        MutableAttributeSet attr = (MutableAttributeSet)((HTMLEditorKit)htmlEditor.getInternalJEditorPane().getEditorKit()).getInputAttributes().copyAttributes();
        String fontFamily = StyleConstants.getFontFamily(attr);
        if (fontFamily == null || fontFamily.equalsIgnoreCase("monospaced")) {
            fontFamily = "Times New Roman";
        }
        int itemCount = this.allFontsComboBox.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            if (!((String)this.allFontsComboBox.getItemAt(i)).equalsIgnoreCase(fontFamily)) continue;
            this.allFontsComboBox.setSelectedIndex(i);
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.rendererLabel.setText((String)value);
        this.rendererLabel.setOpaque(true);
        this.rendererLabel.setBackground(isSelected ? SystemColor.textHighlight : Color.white);
        this.rendererLabel.setForeground(isSelected ? Color.white : Color.black);
        return this.rendererLabel;
    }

    public static void main(String[] args) {
        new InsertSymbolDialog((Frame)new JFrame(), true).show();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

