/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import sferyx.administration.editors.extensions.BrowsableComponent;

public class InsertImageLocationDialog
extends JDialog {
    BrowsableComponent browsable;
    JFileChooser fileChooser;
    boolean cancel = false;
    private JTextField locationTextField;
    private JButton cancelButton;
    private JLabel jLabel1;
    private JButton browseButton;
    private JButton okButton;

    public InsertImageLocationDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public InsertImageLocationDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.locationTextField = new JTextField();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jLabel1 = new JLabel();
        this.browseButton = new JButton();
        this.getContentPane().setLayout(null);
        this.setTitle("Insert Image Location");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                InsertImageLocationDialog.this.closeDialog(evt);
            }
        });
        this.locationTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InsertImageLocationDialog.this.locationTextFieldActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.locationTextField);
        this.locationTextField.setBounds(140, 30, 290, 20);
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InsertImageLocationDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.okButton);
        this.okButton.setBounds(50, 60, 120, 26);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InsertImageLocationDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.cancelButton);
        this.cancelButton.setBounds(180, 60, 120, 26);
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("Image URL:");
        this.getContentPane().add(this.jLabel1);
        this.jLabel1.setBounds(10, 30, 120, 16);
        this.browseButton.setText("Browse");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InsertImageLocationDialog.this.browseButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.browseButton);
        this.browseButton.setBounds(310, 60, 120, 26);
        this.pack();
    }

    public void setCustomBrowsable(BrowsableComponent browsable) {
        this.browsable = browsable;
        if (browsable != null) {
            this.browseButton.setEnabled(true);
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        if (this.browsable != null) {
            this.browsable.show();
            if (this.browsable.isActionCancelled()) {
                return;
            }
            try {
                this.locationTextField.setText(this.browsable.getResultingURL());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        this.fileChooser.setDialogType(0);
        int returnVal = this.fileChooser.showOpenDialog(this.getParent());
        if (returnVal == 0) {
            try {
                this.locationTextField.setText(this.fileChooser.getSelectedFile().toURL().toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.cancel = false;
            this.setVisible(false);
        }
    }

    private void locationTextFieldActionPerformed(ActionEvent evt) {
        this.cancel = false;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.cancel = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.cancel = false;
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.cancel = true;
        this.setVisible(false);
        this.dispose();
    }

    public void setVisible(boolean b) {
        if (b) {
            this.setLocation((int)((double)this.getParent().getLocationOnScreen().x + this.getParent().getBounds().getWidth() / 2.0 - this.getBounds().getWidth() / 2.0), (int)((double)this.getParent().getLocationOnScreen().y + this.getParent().getBounds().getHeight() / 2.0 - this.getBounds().getHeight() / 2.0));
        }
        super.setVisible(b);
        if (b) {
            this.locationTextField.requestFocus();
        }
    }

    public String getDocumentLocation() {
        if (!this.cancel) {
            return this.locationTextField.getText();
        }
        return null;
    }

    public void clearLocation() {
        this.locationTextField.setText("");
    }

    public void initFileDialog(JFileChooser fileCh) {
        if (fileCh == null) {
            this.browseButton.setEnabled(false);
        } else {
            this.browseButton.setEnabled(true);
        }
        this.fileChooser = fileCh;
    }
}

