/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import sferyx.administration.editors.HTMLEditor;
import sferyx.administration.editors.RemoteFileDialog;
import sferyx.administration.editors.extensions.BrowsableComponent;
import sferyx.administration.editors.filechooser.CustomFileChooser;

public class ImagePropertiesDialog
extends JDialog {
    BrowsableComponent imageBrowsable;
    BrowsableComponent hyperlinkBrowsable;
    private JComboBox alignmentCombo;
    private JLabel layoutLabel1;
    private JRadioButton heightPixelsRadioBtn;
    private JSeparator layoutSeparator;
    private JTextField borderThicknessTextField;
    private JLabel horizontalSpacingLabel;
    private JTextField pictureScr;
    private JTextField specifyHeightTextField;
    private JPanel jPanel1;
    private JLabel widthLabel;
    private JLabel borderThicknessLabel;
    private JSeparator sizeSeparator;
    private JLabel altTextLabel;
    private JRadioButton widthPercentsRadioBtn;
    private JSeparator jSeparator11;
    private JComboBox styleClassComboBox;
    private JButton defaultHyperlinkBrowseButton1;
    private JLabel styleClassLabel;
    private JPanel jPanel2;
    private JTextField defaultHyperlinkTextField;
    private JTextField specifyWidthTextField;
    private ButtonGroup widthRadioBtnGroup;
    private JLabel alignmentLabel1;
    private JRadioButton widthPixelsRadioBtn;
    private JButton pictureSrcBrowseButton;
    private JButton cancelButton;
    private JLabel heightLabel;
    private JTextField verticalSpacingTextField;
    private JSeparator jSeparator1;
    private JLabel defaultHyperlinkLabel;
    private JTabbedPane mainTabPane;
    private JLabel pictureSrcLabel1;
    private ButtonGroup heightRadioBtnGroup;
    private JLabel sizeLabel;
    private JLabel alignmentLabel11;
    private JTextField altTextTextField;
    private JRadioButton heightPercentsRadioBtn;
    private JCheckBox sizeCheckBox;
    private JPanel generalTabBasePanel;
    private JPanel appearanceTabBasePanel;
    private JTextField horizontalSpacingTextField;
    private JButton okButton;
    JFileChooser fileChooser;
    AttributeSet attributes;
    boolean cancel = false;
    HTMLEditor htmlPanel;
    RemoteFileDialog remoteFileDialog;
    RemoteFileDialog linksRemoteFileDialog;

    public ImagePropertiesDialog(Frame parent, boolean modal) {
        super(parent, true);
        this.initComponents();
        this.specifyHeightTextField.setBackground(this.getBackground());
        this.specifyWidthTextField.setBackground(this.getBackground());
    }

    public ImagePropertiesDialog(Dialog parent, boolean modal) {
        super(parent, true);
        this.initComponents();
        this.specifyHeightTextField.setBackground(this.getBackground());
        this.specifyWidthTextField.setBackground(this.getBackground());
    }

    private void initComponents() {
        this.widthRadioBtnGroup = new ButtonGroup();
        this.heightRadioBtnGroup = new ButtonGroup();
        this.mainTabPane = new JTabbedPane();
        this.generalTabBasePanel = new JPanel();
        this.defaultHyperlinkTextField = new JTextField();
        this.defaultHyperlinkLabel = new JLabel();
        this.pictureScr = new JTextField();
        this.pictureSrcBrowseButton = new JButton();
        this.pictureSrcLabel1 = new JLabel();
        this.altTextTextField = new JTextField();
        this.altTextLabel = new JLabel();
        this.defaultHyperlinkBrowseButton1 = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jSeparator11 = new JSeparator();
        this.jPanel2 = new JPanel();
        this.styleClassLabel = new JLabel();
        this.styleClassComboBox = new JComboBox();
        this.appearanceTabBasePanel = new JPanel();
        this.sizeLabel = new JLabel();
        this.sizeSeparator = new JSeparator();
        this.layoutSeparator = new JSeparator();
        this.borderThicknessLabel = new JLabel();
        this.layoutLabel1 = new JLabel();
        this.alignmentLabel1 = new JLabel();
        this.alignmentCombo = new JComboBox();
        this.verticalSpacingTextField = new JTextField();
        this.alignmentLabel11 = new JLabel();
        this.horizontalSpacingLabel = new JLabel();
        this.borderThicknessTextField = new JTextField();
        this.horizontalSpacingTextField = new JTextField();
        this.sizeCheckBox = new JCheckBox();
        this.specifyHeightTextField = new JTextField();
        this.specifyWidthTextField = new JTextField();
        this.heightLabel = new JLabel();
        this.widthLabel = new JLabel();
        this.heightPercentsRadioBtn = new JRadioButton();
        this.widthPixelsRadioBtn = new JRadioButton();
        this.heightPixelsRadioBtn = new JRadioButton();
        this.widthPercentsRadioBtn = new JRadioButton();
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setTitle("Picture Properties");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ImagePropertiesDialog.this.closeDialog(evt);
            }
        });
        this.generalTabBasePanel.setLayout(null);
        this.defaultHyperlinkTextField.setFont(new Font("Dialog", 0, 11));
        this.defaultHyperlinkTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImagePropertiesDialog.this.defaultHyperlinkTextFieldActionPerformed(evt);
            }
        });
        this.generalTabBasePanel.add(this.defaultHyperlinkTextField);
        this.defaultHyperlinkTextField.setBounds(20, 170, 240, 20);
        this.defaultHyperlinkLabel.setText("Default hyperlink");
        this.generalTabBasePanel.add(this.defaultHyperlinkLabel);
        this.defaultHyperlinkLabel.setBounds(20, 150, 160, 16);
        this.pictureScr.setFont(new Font("Dialog", 0, 11));
        this.generalTabBasePanel.add(this.pictureScr);
        this.pictureScr.setBounds(20, 40, 240, 20);
        this.pictureSrcBrowseButton.setText("Browse..");
        this.pictureSrcBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImagePropertiesDialog.this.pictureSrcBrowseButtonActionPerformed(evt);
            }
        });
        this.generalTabBasePanel.add(this.pictureSrcBrowseButton);
        this.pictureSrcBrowseButton.setBounds(270, 40, 120, 26);
        this.pictureSrcLabel1.setText("Picture source");
        this.generalTabBasePanel.add(this.pictureSrcLabel1);
        this.pictureSrcLabel1.setBounds(20, 20, 170, 16);
        this.altTextTextField.setFont(new Font("Dialog", 0, 11));
        this.generalTabBasePanel.add(this.altTextTextField);
        this.altTextTextField.setBounds(20, 120, 340, 20);
        this.altTextLabel.setText("Alternative text");
        this.generalTabBasePanel.add(this.altTextLabel);
        this.altTextLabel.setBounds(20, 100, 160, 16);
        this.defaultHyperlinkBrowseButton1.setText("Browse..");
        this.defaultHyperlinkBrowseButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImagePropertiesDialog.this.defaultHyperlinkBrowseButton1ActionPerformed(evt);
            }
        });
        this.generalTabBasePanel.add(this.defaultHyperlinkBrowseButton1);
        this.defaultHyperlinkBrowseButton1.setBounds(270, 170, 120, 26);
        this.generalTabBasePanel.add(this.jSeparator1);
        this.jSeparator1.setBounds(180, 112, 180, 2);
        this.generalTabBasePanel.add(this.jSeparator11);
        this.jSeparator11.setBounds(180, 155, 180, 2);
        this.generalTabBasePanel.add(this.jPanel2);
        this.jPanel2.setBounds(130, 240, 10, 10);
        this.styleClassLabel.setHorizontalAlignment(4);
        this.styleClassLabel.setText("Style:");
        this.generalTabBasePanel.add(this.styleClassLabel);
        this.styleClassLabel.setBounds(20, 210, 90, 20);
        this.styleClassComboBox.setEditable(true);
        this.styleClassComboBox.setFocusCycleRoot(true);
        this.styleClassComboBox.setVerifyInputWhenFocusTarget(false);
        this.generalTabBasePanel.add(this.styleClassComboBox);
        this.styleClassComboBox.setBounds(120, 210, 120, 20);
        this.mainTabPane.addTab("General", this.generalTabBasePanel);
        this.appearanceTabBasePanel.setLayout(null);
        this.sizeLabel.setHorizontalAlignment(4);
        this.sizeLabel.setText("Size");
        this.appearanceTabBasePanel.add(this.sizeLabel);
        this.sizeLabel.setBounds(0, 110, 60, 16);
        this.appearanceTabBasePanel.add(this.sizeSeparator);
        this.sizeSeparator.setBounds(80, 120, 250, 2);
        this.appearanceTabBasePanel.add(this.layoutSeparator);
        this.layoutSeparator.setBounds(80, 20, 250, 2);
        this.borderThicknessLabel.setHorizontalAlignment(4);
        this.borderThicknessLabel.setText("Border thickness:");
        this.appearanceTabBasePanel.add(this.borderThicknessLabel);
        this.borderThicknessLabel.setBounds(10, 70, 160, 16);
        this.layoutLabel1.setHorizontalAlignment(4);
        this.layoutLabel1.setText("Layout");
        this.appearanceTabBasePanel.add(this.layoutLabel1);
        this.layoutLabel1.setBounds(8, 10, 60, 16);
        this.alignmentLabel1.setHorizontalAlignment(4);
        this.alignmentLabel1.setText("Vertical spacing:");
        this.appearanceTabBasePanel.add(this.alignmentLabel1);
        this.alignmentLabel1.setBounds(220, 70, 160, 16);
        this.alignmentCombo.setEditable(true);
        this.alignmentCombo.setFont(new Font("Dialog", 0, 11));
        this.alignmentCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Default", "left", "right", "top", "texttop", "middle", "absmiddle", "baseline", "bottom", "absbottom"}));
        this.appearanceTabBasePanel.add(this.alignmentCombo);
        this.alignmentCombo.setBounds(120, 40, 80, 20);
        this.verticalSpacingTextField.setFont(new Font("Dialog", 0, 11));
        this.verticalSpacingTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImagePropertiesDialog.this.verticalSpacingTextFieldActionPerformed(evt);
            }
        });
        this.appearanceTabBasePanel.add(this.verticalSpacingTextField);
        this.verticalSpacingTextField.setBounds(390, 70, 20, 19);
        this.alignmentLabel11.setHorizontalAlignment(4);
        this.alignmentLabel11.setText("Alignment:");
        this.appearanceTabBasePanel.add(this.alignmentLabel11);
        this.alignmentLabel11.setBounds(0, 40, 110, 16);
        this.horizontalSpacingLabel.setHorizontalAlignment(4);
        this.horizontalSpacingLabel.setText("Horizontal spacing:");
        this.appearanceTabBasePanel.add(this.horizontalSpacingLabel);
        this.horizontalSpacingLabel.setBounds(220, 40, 160, 16);
        this.borderThicknessTextField.setFont(new Font("Dialog", 0, 11));
        this.borderThicknessTextField.setText("0");
        this.appearanceTabBasePanel.add(this.borderThicknessTextField);
        this.borderThicknessTextField.setBounds(180, 70, 20, 19);
        this.horizontalSpacingTextField.setFont(new Font("Dialog", 0, 11));
        this.appearanceTabBasePanel.add(this.horizontalSpacingTextField);
        this.horizontalSpacingTextField.setBounds(390, 40, 20, 19);
        this.sizeCheckBox.setText("Specify Size");
        this.sizeCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImagePropertiesDialog.this.sizeCheckBoxActionPerformed(evt);
            }
        });
        this.sizeCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ImagePropertiesDialog.this.sizeCheckBoxStateChanged(evt);
            }
        });
        this.appearanceTabBasePanel.add(this.sizeCheckBox);
        this.sizeCheckBox.setBounds(10, 150, 160, 24);
        this.specifyHeightTextField.setFont(new Font("Dialog", 0, 11));
        this.specifyHeightTextField.setEnabled(false);
        this.appearanceTabBasePanel.add(this.specifyHeightTextField);
        this.specifyHeightTextField.setBounds(290, 150, 70, 19);
        this.specifyWidthTextField.setFont(new Font("Dialog", 0, 11));
        this.specifyWidthTextField.setEnabled(false);
        this.appearanceTabBasePanel.add(this.specifyWidthTextField);
        this.specifyWidthTextField.setBounds(180, 150, 70, 19);
        this.heightLabel.setText("Height:");
        this.appearanceTabBasePanel.add(this.heightLabel);
        this.heightLabel.setBounds(290, 130, 80, 16);
        this.widthLabel.setText("Width:");
        this.appearanceTabBasePanel.add(this.widthLabel);
        this.widthLabel.setBounds(180, 130, 70, 16);
        this.heightPercentsRadioBtn.setText("In percents");
        this.heightRadioBtnGroup.add(this.heightPercentsRadioBtn);
        this.heightPercentsRadioBtn.setEnabled(false);
        this.heightPercentsRadioBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImagePropertiesDialog.this.heightPercentsRadioBtnActionPerformed(evt);
            }
        });
        this.appearanceTabBasePanel.add(this.heightPercentsRadioBtn);
        this.heightPercentsRadioBtn.setBounds(290, 190, 104, 24);
        this.widthPixelsRadioBtn.setSelected(true);
        this.widthPixelsRadioBtn.setText("In pixels");
        this.widthRadioBtnGroup.add(this.widthPixelsRadioBtn);
        this.widthPixelsRadioBtn.setEnabled(false);
        this.appearanceTabBasePanel.add(this.widthPixelsRadioBtn);
        this.widthPixelsRadioBtn.setBounds(180, 170, 110, 24);
        this.heightPixelsRadioBtn.setSelected(true);
        this.heightPixelsRadioBtn.setText("In pixels");
        this.heightRadioBtnGroup.add(this.heightPixelsRadioBtn);
        this.heightPixelsRadioBtn.setEnabled(false);
        this.appearanceTabBasePanel.add(this.heightPixelsRadioBtn);
        this.heightPixelsRadioBtn.setBounds(290, 170, 104, 24);
        this.widthPercentsRadioBtn.setText("In percents");
        this.widthRadioBtnGroup.add(this.widthPercentsRadioBtn);
        this.widthPercentsRadioBtn.setEnabled(false);
        this.appearanceTabBasePanel.add(this.widthPercentsRadioBtn);
        this.widthPercentsRadioBtn.setBounds(180, 190, 110, 24);
        this.mainTabPane.addTab("Appearance", this.appearanceTabBasePanel);
        this.getContentPane().add((Component)this.mainTabPane, "Center");
        this.jPanel1.setLayout(new FlowLayout(2));
        this.okButton.setText("Ok");
        this.okButton.setPreferredSize(new Dimension(120, 24));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImagePropertiesDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.okButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                ImagePropertiesDialog.this.okButtonMousePressed(evt);
            }
        });
        this.jPanel1.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setPreferredSize(new Dimension(120, 24));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImagePropertiesDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelButton);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.pack();
    }

    private void okButtonMousePressed(MouseEvent evt) {
        this.okButton.requestFocus();
    }

    private void sizeCheckBoxStateChanged(ChangeEvent evt) {
        if (evt.getSource() == this.sizeCheckBox) {
            this.specifyWidthTextField.setEnabled(this.sizeCheckBox.isSelected());
            this.specifyHeightTextField.setEnabled(this.sizeCheckBox.isSelected());
            if (!this.sizeCheckBox.isSelected()) {
                this.specifyHeightTextField.setBackground(this.getBackground());
                this.specifyWidthTextField.setBackground(this.getBackground());
            } else {
                this.specifyHeightTextField.setBackground(Color.white);
                this.specifyWidthTextField.setBackground(Color.white);
            }
            this.widthPixelsRadioBtn.setEnabled(this.sizeCheckBox.isSelected());
            this.widthPercentsRadioBtn.setEnabled(this.sizeCheckBox.isSelected());
            this.heightPixelsRadioBtn.setEnabled(this.sizeCheckBox.isSelected());
            this.heightPercentsRadioBtn.setEnabled(this.sizeCheckBox.isSelected());
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.cancel = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.cancel = false;
        this.setVisible(false);
        this.dispose();
    }

    public void setCustomImageBrowsable(BrowsableComponent browsable) {
        this.imageBrowsable = browsable;
        this.pictureSrcBrowseButton.setEnabled(true);
    }

    public void setCustomHyperlinkBrowsable(BrowsableComponent browsable) {
        this.hyperlinkBrowsable = browsable;
        this.defaultHyperlinkBrowseButton1.setEnabled(true);
    }

    private void defaultHyperlinkBrowseButton1ActionPerformed(ActionEvent evt) {
        if (this.hyperlinkBrowsable != null) {
            this.hyperlinkBrowsable.show();
            if (this.hyperlinkBrowsable.isActionCancelled()) {
                return;
            }
            try {
                this.defaultHyperlinkTextField.setText(this.hyperlinkBrowsable.getResultingURL());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        if (this.fileChooser != null) {
            int returnVal;
            this.fileChooser.setDialogType(0);
            if (this.fileChooser instanceof CustomFileChooser) {
                ((CustomFileChooser)this.fileChooser).resetFilter();
            }
            if ((returnVal = this.fileChooser.showOpenDialog(this)) == 0) {
                try {
                    this.defaultHyperlinkTextField.setText(this.htmlPanel.getRelativePath(this.fileChooser.getSelectedFile().toURL().toString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (this.linksRemoteFileDialog != null) {
            try {
                this.linksRemoteFileDialog.setVisible(true);
                String hyperlinkURL = this.linksRemoteFileDialog.getSelectedFile();
                if (hyperlinkURL != null) {
                    this.defaultHyperlinkTextField.setText(this.htmlPanel.getRelativePath(hyperlinkURL));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void pictureSrcBrowseButtonActionPerformed(ActionEvent evt) {
        if (this.imageBrowsable != null) {
            this.imageBrowsable.show();
            if (this.imageBrowsable.isActionCancelled()) {
                return;
            }
            try {
                this.pictureScr.setText(this.imageBrowsable.getResultingURL());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        if (this.fileChooser != null) {
            int returnVal;
            this.fileChooser.setDialogType(0);
            if (this.fileChooser instanceof CustomFileChooser) {
                ((CustomFileChooser)this.fileChooser).setImageFilter();
            }
            if ((returnVal = this.fileChooser.showOpenDialog(this)) == 0) {
                try {
                    this.pictureScr.setText(this.htmlPanel.getRelativePath(this.fileChooser.getSelectedFile().toURL().toString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (this.remoteFileDialog != null) {
            try {
                this.remoteFileDialog.setVisible(true);
                String imageURL = this.remoteFileDialog.getSelectedFile();
                if (imageURL != null) {
                    this.pictureScr.setText(this.htmlPanel.getRelativePath(imageURL));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void sizeCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void heightPercentsRadioBtnActionPerformed(ActionEvent evt) {
    }

    private void verticalSpacingTextFieldActionPerformed(ActionEvent evt) {
    }

    private void defaultHyperlinkTextFieldActionPerformed(ActionEvent evt) {
    }

    private void closeDialog(WindowEvent evt) {
        this.cancel = true;
        this.setVisible(false);
    }

    public void setVisible(boolean b) {
        this.setSize(430, 350);
        if (b) {
            this.setLocation((int)((double)this.getParent().getLocationOnScreen().x + this.getParent().getBounds().getWidth() / 2.0 - this.getBounds().getWidth() / 2.0), (int)((double)this.getParent().getLocationOnScreen().y + this.getParent().getBounds().getHeight() / 2.0 - this.getBounds().getHeight() / 2.0));
        }
        super.setVisible(b);
    }

    public void initDialogFields(AttributeSet attribs) {
        this.attributes = attribs;
        String src = (String)attribs.getAttribute(HTML.Attribute.SRC);
        if (src != null && this.attributes.containsAttribute(HTML.Attribute.SRC, src)) {
            this.pictureScr.setText(src);
        } else {
            this.pictureScr.setText("");
        }
        SimpleAttributeSet href = (SimpleAttributeSet)attribs.getAttribute(HTML.Tag.A);
        if (href != null && this.attributes.containsAttribute(HTML.Tag.A, href)) {
            this.defaultHyperlinkTextField.setText((String)href.getAttribute(HTML.Attribute.HREF));
        } else {
            this.defaultHyperlinkTextField.setText("");
        }
        String altText = (String)attribs.getAttribute(HTML.Attribute.ALT);
        if (altText != null && this.attributes.containsAttribute(HTML.Attribute.ALT, altText)) {
            this.altTextTextField.setText(altText);
        } else {
            this.altTextTextField.setText("");
        }
        String align = (String)attribs.getAttribute(HTML.Attribute.ALIGN);
        if (align != null && this.attributes.containsAttribute(HTML.Attribute.ALIGN, align)) {
            this.alignmentCombo.setSelectedItem(align.toLowerCase());
        } else {
            this.alignmentCombo.setSelectedItem("default");
        }
        String border = (String)attribs.getAttribute(HTML.Attribute.BORDER);
        if (border != null && this.attributes.containsAttribute(HTML.Attribute.BORDER, border)) {
            this.borderThicknessTextField.setText(border);
        } else {
            this.borderThicknessTextField.setText("");
        }
        String width = (String)attribs.getAttribute(HTML.Attribute.WIDTH);
        if (width != null && !width.equals("") && this.attributes.containsAttribute(HTML.Attribute.WIDTH, width)) {
            this.specifyWidthTextField.setText(width);
            this.sizeCheckBox.setSelected(true);
        } else {
            this.specifyWidthTextField.setText("");
            this.sizeCheckBox.setSelected(false);
        }
        String height = (String)attribs.getAttribute(HTML.Attribute.HEIGHT);
        if (height != null && !height.equals("") && this.attributes.containsAttribute(HTML.Attribute.HEIGHT, height)) {
            this.specifyHeightTextField.setText(height);
            this.sizeCheckBox.setSelected(true);
        } else {
            this.specifyHeightTextField.setText("");
            this.sizeCheckBox.setSelected(false);
        }
        String vspace = (String)attribs.getAttribute(HTML.Attribute.VSPACE);
        if (vspace != null && this.attributes.containsAttribute(HTML.Attribute.VSPACE, vspace)) {
            this.verticalSpacingTextField.setText(vspace);
        } else {
            this.verticalSpacingTextField.setText("");
        }
        String hspace = (String)attribs.getAttribute(HTML.Attribute.HSPACE);
        if (hspace != null && this.attributes.containsAttribute(HTML.Attribute.HSPACE, hspace)) {
            this.horizontalSpacingTextField.setText(hspace);
        } else {
            this.horizontalSpacingTextField.setText("");
        }
        this.styleClassComboBox.setModel(new DefaultComboBoxModel(this.htmlPanel.getStyleClasses()));
        String styleClass = (String)attribs.getAttribute(HTML.Attribute.CLASS);
        if (styleClass != null && this.attributes.containsAttribute(HTML.Attribute.CLASS, styleClass)) {
            this.styleClassComboBox.setSelectedItem(styleClass);
        } else {
            this.styleClassComboBox.setSelectedIndex(-1);
        }
        this.styleClassComboBox.setRenderer(this.htmlPanel.getStyleClassRendererInstance());
        this.okButton.requestFocus();
    }

    public AttributeSet getNewAttributes() {
        if (this.cancel) {
            return null;
        }
        SimpleAttributeSet newAttribs = new SimpleAttributeSet(this.attributes);
        newAttribs.addAttribute(HTML.Attribute.BORDER, this.borderThicknessTextField.getText());
        if (!((String)this.alignmentCombo.getSelectedItem()).equalsIgnoreCase("default")) {
            newAttribs.addAttribute(HTML.Attribute.ALIGN, this.alignmentCombo.getSelectedItem());
        } else {
            newAttribs.removeAttribute(HTML.Attribute.ALIGN);
        }
        if (this.sizeCheckBox.isSelected() && !this.specifyWidthTextField.getText().equals("")) {
            String table_width = this.specifyWidthTextField.getText();
            if (this.widthPercentsRadioBtn.isSelected() && !table_width.endsWith("%")) {
                table_width = table_width + "%";
            }
            newAttribs.addAttribute(HTML.Attribute.WIDTH, table_width);
        } else {
            newAttribs.removeAttribute(HTML.Attribute.WIDTH);
        }
        if (this.sizeCheckBox.isSelected() && !this.specifyHeightTextField.getText().equals("")) {
            String table_height = this.specifyHeightTextField.getText();
            if (this.heightPercentsRadioBtn.isSelected() && !table_height.endsWith("%")) {
                table_height = table_height + "%";
            }
            newAttribs.addAttribute(HTML.Attribute.HEIGHT, table_height);
        } else {
            newAttribs.removeAttribute(HTML.Attribute.HEIGHT);
        }
        if (!this.altTextTextField.getText().equals("")) {
            newAttribs.addAttribute(HTML.Attribute.ALT, this.altTextTextField.getText());
        } else {
            newAttribs.removeAttribute(HTML.Attribute.ALT);
        }
        if (!this.verticalSpacingTextField.getText().equals("")) {
            newAttribs.addAttribute(HTML.Attribute.VSPACE, this.verticalSpacingTextField.getText());
        } else {
            newAttribs.removeAttribute(HTML.Attribute.VSPACE);
        }
        if (!this.horizontalSpacingTextField.getText().equals("")) {
            newAttribs.addAttribute(HTML.Attribute.HSPACE, this.horizontalSpacingTextField.getText());
        } else {
            newAttribs.removeAttribute(HTML.Attribute.HSPACE);
        }
        if (!this.pictureScr.getText().equals("")) {
            newAttribs.addAttribute(HTML.Attribute.SRC, this.pictureScr.getText());
        } else {
            newAttribs.removeAttribute(HTML.Attribute.SRC);
        }
        if (this.defaultHyperlinkTextField.getText() != null && !this.defaultHyperlinkTextField.getText().equals("")) {
            MutableAttributeSet hrefSet = (MutableAttributeSet)this.attributes.getAttribute(HTML.Tag.A);
            if (hrefSet == null) {
                hrefSet = new SimpleAttributeSet();
            }
            hrefSet.addAttribute(HTML.Attribute.HREF, this.defaultHyperlinkTextField.getText());
            newAttribs.addAttribute(HTML.Tag.A, hrefSet);
        } else {
            newAttribs.removeAttribute(HTML.Tag.A);
        }
        if (this.styleClassComboBox.getSelectedItem() != null && !this.styleClassComboBox.getSelectedItem().equals("")) {
            newAttribs.addAttribute(HTML.Attribute.CLASS, this.styleClassComboBox.getSelectedItem());
        } else {
            newAttribs.removeAttribute(HTML.Attribute.CLASS);
        }
        return newAttribs;
    }

    public void initFileDialog(JFileChooser fileCh) {
        if (fileCh == null) {
            this.pictureSrcBrowseButton.setEnabled(false);
            this.defaultHyperlinkBrowseButton1.setEnabled(false);
        } else {
            this.pictureSrcBrowseButton.setEnabled(true);
            this.defaultHyperlinkBrowseButton1.setEnabled(true);
        }
        this.fileChooser = fileCh;
    }

    public void initRemoteFileDialog(RemoteFileDialog remoteFD) {
        if (remoteFD == null && this.fileChooser == null) {
            this.pictureSrcBrowseButton.setEnabled(false);
            this.defaultHyperlinkBrowseButton1.setEnabled(false);
        } else {
            this.pictureSrcBrowseButton.setEnabled(true);
            this.defaultHyperlinkBrowseButton1.setEnabled(true);
        }
        this.remoteFileDialog = remoteFD;
    }

    public void initLinksRemoteFileDialog(RemoteFileDialog remoteFD) {
        if (remoteFD == null && this.fileChooser == null) {
            this.pictureSrcBrowseButton.setEnabled(false);
            this.defaultHyperlinkBrowseButton1.setEnabled(false);
        } else {
            this.pictureSrcBrowseButton.setEnabled(true);
            this.defaultHyperlinkBrowseButton1.setEnabled(true);
        }
        this.linksRemoteFileDialog = remoteFD;
    }

    public void setHtmlPanel(HTMLEditor html_Panel) {
        this.htmlPanel = html_Panel;
    }

    public void selectTabbedPaneIndex(int index) {
        this.mainTabPane.setSelectedIndex(index);
    }
}

