/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import sferyx.administration.editors.HTMLEditor;
import sferyx.administration.editors.RemoteFileDialog;
import sferyx.administration.editors.extensions.BrowsableComponent;
import sferyx.administration.editors.filechooser.CustomFileChooser;

public class HyperlinkPropertiesDialog
extends JDialog
implements ItemListener {
    BrowsableComponent browsable;
    private JSeparator layoutSeparator;
    private JTextField urlTextField;
    private JComboBox styleClassComboBox;
    private JLabel bookmarkLabel;
    private JSeparator buttonsSeparator;
    private JLabel hyperlinkPropertiesLabel;
    private JButton okButton;
    private JLabel styleClassLabel;
    private JButton cancelButton;
    private JButton browseButton;
    private JLabel urlLabel;
    private JComboBox bookmarkComboBox;
    private JPanel jPanel1;
    private JLabel targetFrameLabel;
    private JComboBox targetFrameComboBox;
    JFileChooser fileChooser;
    AttributeSet attributes;
    boolean cancel = false;
    HTMLEditor htmlPanel;
    RemoteFileDialog remoteFileDialog;

    public HyperlinkPropertiesDialog(Frame parent, boolean modal) {
        super(parent, true);
        this.initComponents();
        this.bookmarkComboBox.addItemListener(this);
    }

    public HyperlinkPropertiesDialog(Dialog parent, boolean modal) {
        super(parent, true);
        this.initComponents();
        this.bookmarkComboBox.addItemListener(this);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.hyperlinkPropertiesLabel = new JLabel();
        this.layoutSeparator = new JSeparator();
        this.targetFrameLabel = new JLabel();
        this.targetFrameComboBox = new JComboBox();
        this.urlTextField = new JTextField();
        this.browseButton = new JButton();
        this.cancelButton = new JButton();
        this.buttonsSeparator = new JSeparator();
        this.urlLabel = new JLabel();
        this.bookmarkLabel = new JLabel();
        this.bookmarkComboBox = new JComboBox();
        this.okButton = new JButton();
        this.styleClassComboBox = new JComboBox();
        this.styleClassLabel = new JLabel();
        this.setTitle("Hyperlink Properties");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                HyperlinkPropertiesDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(null);
        this.hyperlinkPropertiesLabel.setText("Hyperlink Properties");
        this.hyperlinkPropertiesLabel.setHorizontalAlignment(4);
        this.jPanel1.add(this.hyperlinkPropertiesLabel);
        this.hyperlinkPropertiesLabel.setBounds(0, 10, 180, 15);
        this.jPanel1.add(this.layoutSeparator);
        this.layoutSeparator.setBounds(190, 18, 230, 2);
        this.targetFrameLabel.setText("Target frame:");
        this.jPanel1.add(this.targetFrameLabel);
        this.targetFrameLabel.setBounds(230, 100, 90, 15);
        this.targetFrameComboBox.setEditable(true);
        this.targetFrameComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"", "_self", "_top", "_blank", "_parent"}));
        this.targetFrameComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HyperlinkPropertiesDialog.this.targetFrameComboBoxActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.targetFrameComboBox);
        this.targetFrameComboBox.setBounds(320, 100, 100, 20);
        this.jPanel1.add(this.urlTextField);
        this.urlTextField.setBounds(80, 57, 210, 25);
        this.browseButton.setText("Browse");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HyperlinkPropertiesDialog.this.browseButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.browseButton);
        this.browseButton.setBounds(320, 57, 100, 25);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HyperlinkPropertiesDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelButton);
        this.cancelButton.setBounds(300, 200, 120, 25);
        this.jPanel1.add(this.buttonsSeparator);
        this.buttonsSeparator.setBounds(20, 180, 400, 2);
        this.urlLabel.setText("URL:");
        this.jPanel1.add(this.urlLabel);
        this.urlLabel.setBounds(20, 60, 50, 15);
        this.bookmarkLabel.setText("Bookmark:");
        this.jPanel1.add(this.bookmarkLabel);
        this.bookmarkLabel.setBounds(20, 100, 80, 15);
        this.bookmarkComboBox.setEditable(true);
        this.jPanel1.add(this.bookmarkComboBox);
        this.bookmarkComboBox.setBounds(100, 100, 100, 20);
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HyperlinkPropertiesDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.okButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                HyperlinkPropertiesDialog.this.okButtonMousePressed(evt);
            }
        });
        this.jPanel1.add(this.okButton);
        this.okButton.setBounds(170, 200, 120, 25);
        this.styleClassComboBox.setEditable(true);
        this.styleClassComboBox.setVerifyInputWhenFocusTarget(false);
        this.jPanel1.add(this.styleClassComboBox);
        this.styleClassComboBox.setBounds(100, 130, 100, 20);
        this.styleClassLabel.setText("Style:");
        this.jPanel1.add(this.styleClassLabel);
        this.styleClassLabel.setBounds(20, 130, 60, 16);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void okButtonMousePressed(MouseEvent evt) {
        this.okButton.requestFocus();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.cancel = false;
        this.setVisible(false);
        this.dispose();
    }

    private void targetFrameComboBoxActionPerformed(ActionEvent evt) {
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.cancel = true;
        this.dispose();
    }

    public void setCustomBrowsable(BrowsableComponent browsable) {
        this.browsable = browsable;
        if (browsable != null) {
            this.browseButton.setEnabled(true);
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        if (this.browsable != null) {
            this.browsable.show();
            if (this.browsable.isActionCancelled()) {
                return;
            }
            try {
                this.urlTextField.setText(this.browsable.getResultingURL());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        if (this.fileChooser != null) {
            int returnVal;
            this.fileChooser.setDialogType(0);
            if (this.fileChooser instanceof CustomFileChooser) {
                ((CustomFileChooser)this.fileChooser).resetFilter();
            }
            if ((returnVal = this.fileChooser.showOpenDialog(this)) == 0) {
                try {
                    this.urlTextField.setText(this.htmlPanel.getRelativePath(this.fileChooser.getSelectedFile().toURL().toString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (this.remoteFileDialog != null) {
            try {
                this.remoteFileDialog.setVisible(true);
                String imageURL = this.remoteFileDialog.getSelectedFile();
                if (imageURL != null) {
                    this.urlTextField.setText(imageURL);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.cancel = true;
        this.setVisible(false);
        this.dispose();
    }

    public void setVisible(boolean b) {
        this.setSize(440, 270);
        if (b) {
            this.setLocation((int)((double)this.getParent().getLocationOnScreen().x + this.getParent().getBounds().getWidth() / 2.0 - this.getBounds().getWidth() / 2.0), (int)((double)this.getParent().getLocationOnScreen().y + this.getParent().getBounds().getHeight() / 2.0 - this.getBounds().getHeight() / 2.0));
        }
        super.setVisible(b);
        if (b) {
            this.urlTextField.requestFocus();
        }
    }

    public void initDialogFields(AttributeSet attribs) {
        this.attributes = attribs;
        SimpleAttributeSet href = (SimpleAttributeSet)attribs.getAttribute(HTML.Tag.A);
        if (href != null) {
            String hyperlinkURL = (String)href.getAttribute(HTML.Attribute.HREF);
            if (hyperlinkURL != null && href.containsAttribute(HTML.Attribute.HREF, hyperlinkURL)) {
                this.urlTextField.setText(hyperlinkURL);
            } else {
                this.urlTextField.setText("");
            }
        } else {
            this.urlTextField.setText("");
        }
        if (href != null) {
            String targetFrame = (String)href.getAttribute(HTML.Attribute.TARGET);
            if (targetFrame != null && href.containsAttribute(HTML.Attribute.TARGET, targetFrame)) {
                this.targetFrameComboBox.setSelectedItem(targetFrame.toLowerCase());
            } else {
                this.targetFrameComboBox.setSelectedItem("");
            }
        } else {
            this.targetFrameComboBox.setSelectedItem("");
        }
        this.styleClassComboBox.setModel(new DefaultComboBoxModel(this.htmlPanel.getStyleClasses()));
        if (href != null) {
            String styleClass = (String)href.getAttribute(HTML.Attribute.CLASS);
            if (styleClass != null && href.containsAttribute(HTML.Attribute.CLASS, styleClass)) {
                this.styleClassComboBox.setSelectedItem(styleClass);
            } else {
                this.styleClassComboBox.setSelectedIndex(-1);
            }
        } else {
            this.styleClassComboBox.setSelectedIndex(-1);
        }
        this.styleClassComboBox.setRenderer(this.htmlPanel.getStyleClassRendererInstance());
        this.okButton.requestFocus();
    }

    public AttributeSet getNewAttributes() {
        if (this.cancel) {
            return null;
        }
        SimpleAttributeSet newAttribs = new SimpleAttributeSet();
        SimpleAttributeSet hrefSet = new SimpleAttributeSet();
        if (this.attributes.getAttribute(HTML.Tag.A) != null) {
            Enumeration<?> enum_ = ((AttributeSet)this.attributes.getAttribute(HTML.Tag.A)).getAttributeNames();
            while (enum_.hasMoreElements()) {
                Object value;
                Object name = enum_.nextElement();
                if (name == StyleConstants.ModelAttribute || name == StyleConstants.NameAttribute || (value = ((AttributeSet)this.attributes.getAttribute(HTML.Tag.A)).getAttribute(name)) == null || name == null) continue;
                hrefSet.addAttribute(name, value);
            }
        }
        if (this.styleClassComboBox.getSelectedItem() != null && !this.styleClassComboBox.getSelectedItem().equals("")) {
            hrefSet.addAttribute(HTML.Attribute.CLASS, this.styleClassComboBox.getSelectedItem());
        } else {
            hrefSet.removeAttribute(HTML.Attribute.CLASS);
        }
        if (!this.urlTextField.getText().trim().equals("") && this.urlTextField.getText() != null) {
            hrefSet.addAttribute(HTML.Attribute.HREF, this.urlTextField.getText());
            newAttribs.addAttribute(HTML.Tag.A, hrefSet);
            if (!this.targetFrameComboBox.getSelectedItem().equals("") && this.targetFrameComboBox.getSelectedItem() != null) {
                hrefSet.addAttribute(HTML.Attribute.TARGET, this.targetFrameComboBox.getSelectedItem());
            } else {
                hrefSet.removeAttribute(HTML.Attribute.TARGET);
            }
        } else {
            newAttribs.removeAttribute(HTML.Tag.A);
        }
        return newAttribs;
    }

    public void initFileDialog(JFileChooser fileCh) {
        if (fileCh == null) {
            this.browseButton.setEnabled(false);
        } else {
            this.browseButton.setEnabled(true);
        }
        this.fileChooser = fileCh;
    }

    public void initRemoteFileDialog(RemoteFileDialog remoteFD) {
        if (remoteFD == null && this.fileChooser == null) {
            this.browseButton.setEnabled(false);
        } else {
            this.browseButton.setEnabled(true);
        }
        this.remoteFileDialog = remoteFD;
    }

    public void setBookmarks(Vector bookmarks) {
        try {
            if (bookmarks != null && bookmarks.elementAt(0) != null && !bookmarks.elementAt(0).equals("")) {
                bookmarks.insertElementAt("", 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bookmarkComboBox.setModel(new DefaultComboBoxModel(bookmarks));
    }

    public void setHtmlPanel(HTMLEditor html_Panel) {
        this.htmlPanel = html_Panel;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.bookmarkComboBox && this.bookmarkComboBox.getSelectedItem() != null && !((String)this.bookmarkComboBox.getSelectedItem()).trim().equals("")) {
            this.urlTextField.setText("#" + (String)this.bookmarkComboBox.getSelectedItem());
        }
    }
}

