/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.util.StringTokenizer;

public class HTMLFilter {
    String filteredContent;
    boolean fontIsProhibited = false;
    boolean tableIsProhibited = true;

    public HTMLFilter(String content) {
        this.filterContent(content);
    }

    public HTMLFilter(String content, boolean fontProhibited, boolean tableProhibited) {
        this.setFontIsProhibited(fontProhibited);
        this.setTableIsProhibited(tableProhibited);
        this.filterContent(content);
    }

    public void filterContent(String content) {
        StringBuffer filteredContentBuffer = new StringBuffer();
        StringTokenizer st = new StringTokenizer(content, "<>", true);
        boolean inTag = false;
        boolean skipping = false;
        boolean skipClose = false;
        String previousTag = "";
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("<")) {
                inTag = true;
            } else if (token.equals(">")) {
                if (skipping) {
                    skipClose = true;
                    skipping = false;
                }
                inTag = false;
            }
            if (inTag && this.isProhibitedTag(token.toLowerCase())) {
                skipping = true;
                previousTag = "";
                continue;
            }
            if (token.equals("<")) {
                previousTag = "<";
                continue;
            }
            if (!skipClose) {
                filteredContentBuffer.append(previousTag + token);
                previousTag = "";
            }
            skipClose = false;
        }
        this.filteredContent = filteredContentBuffer.toString();
    }

    public String getFilteredContent() {
        return this.filteredContent;
    }

    boolean isProhibitedTag(String tag) {
        if (this.tableIsProhibited) {
            if (tag.startsWith("table") || tag.startsWith("/table")) {
                return true;
            }
            if (tag.startsWith("tr") || tag.startsWith("/tr")) {
                return true;
            }
            if (tag.startsWith("th") || tag.startsWith("/th")) {
                return true;
            }
            if (tag.startsWith("td") || tag.startsWith("/td")) {
                return true;
            }
        }
        if (tag.startsWith("form") || tag.startsWith("/form")) {
            return true;
        }
        if (tag.startsWith("script") || tag.startsWith("/script")) {
            return true;
        }
        if (tag.startsWith("body") || tag.startsWith("/body")) {
            return true;
        }
        if (tag.startsWith("html") || tag.startsWith("/html")) {
            return true;
        }
        if (tag.startsWith("head") || tag.startsWith("/head")) {
            return true;
        }
        if (tag.startsWith("body") || tag.startsWith("/body")) {
            return true;
        }
        if (tag.startsWith("link")) {
            return true;
        }
        if (tag.startsWith("!--")) {
            return true;
        }
        if (tag.startsWith("noscript") || tag.startsWith("/noscript")) {
            return true;
        }
        if (tag.startsWith("title") || tag.startsWith("/title")) {
            return true;
        }
        if (tag.startsWith("o:") || tag.startsWith("/o:")) {
            return true;
        }
        if (tag.startsWith("style") || tag.startsWith("/style")) {
            return true;
        }
        if (tag.startsWith("!doctype")) {
            return true;
        }
        return this.fontIsProhibited && (tag.startsWith("font") || tag.startsWith("/font"));
    }

    public void setFontIsProhibited(boolean fontIsProhibited) {
        this.fontIsProhibited = fontIsProhibited;
    }

    public void setTableIsProhibited(boolean tableIsProhibited) {
        this.tableIsProhibited = tableIsProhibited;
    }
}

