/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.FileOutputStream;
import java.net.URL;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.html.StyleSheet;
import oracle.forms.ui.BeanManager;
import oracle.forms.ui.CustomEvent;
import oracle.forms.ui.CustomListener;
import oracle.forms.ui.VBean;
import sferyx.administration.editors.HTMLEditor;

public class HTMLEditorOracleBean
extends Container
implements ActionListener,
MouseListener,
MouseMotionListener,
FocusListener,
DocumentListener,
KeyListener {
    boolean customEventsDispatchingEnabled = false;
    String customEventsMask = null;
    String keyEventMask = "";
    Applet applet;
    VBean listener;
    BeanManager bm;
    HTMLEditor htmlEditor;

    public int getFOXMLContentLenght() {
        return this.htmlEditor.getFOXMLContentLenght();
    }

    public String getFOXMLContentPortion(int offset, int length) {
        return this.htmlEditor.getFOXMLContentPortion(offset, length);
    }

    public String getFOXMLContent() {
        return this.htmlEditor.getFOXMLContent();
    }

    public void setWrapTextInHTMLSourcePane(boolean wrap) {
        this.htmlEditor.setMSWordStyleTables(wrap);
    }

    public void setMSWordStyleTables(boolean MSWordStyleTables) {
        this.htmlEditor.setMSWordStyleTables(MSWordStyleTables);
    }

    public boolean isMSWordStyleTables() {
        return this.htmlEditor.isMSWordStyleTables();
    }

    public void setDisableToolbarItems(String toolbarItemNames) {
        this.htmlEditor.setDisableToolbarItems(toolbarItemNames);
    }

    public void setEnableToolbarItems(String toolbarItemNames) {
        this.htmlEditor.setEnableToolbarItems(toolbarItemNames);
    }

    public void setEnabled(boolean enabled) {
        this.htmlEditor.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.htmlEditor.isEnabled();
    }

    public void addNotify() {
        super.addNotify();
        this.getParent().addFocusListener(this);
    }

    public void removeNotify() {
        block5: {
            if (this.getParent() != null) {
                this.getParent().removeFocusListener(this);
            }
            try {
                if (this.bm == null || this.listener == null) break block5;
                try {
                    this.bm.setHandler(null);
                }
                catch (Throwable thr) {
                    // empty catch block
                }
                this.bm.removeCustomListener((CustomListener)this.listener.getHandler());
                this.bm = null;
                this.listener = null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.removeNotify();
    }

    public HTMLEditorOracleBean() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.setLayout(new BorderLayout());
        this.htmlEditor = new HTMLEditor(true, true, true, true, true, true);
        try {
            this.htmlEditor.getEditingToolBar().setFloatable(false);
            this.htmlEditor.getFormattingToolBar().setFloatable(false);
        }
        catch (Throwable thr) {
            // empty catch block
        }
        this.htmlEditor.addDocumentListener(this);
        this.htmlEditor.getInternalJEditorPane().addMouseListener(this);
        this.htmlEditor.getInternalJEditorPane().addFocusListener(this);
        this.htmlEditor.getInternalJEditorPane().addMouseMotionListener(this);
        this.htmlEditor.getInternalJEditorPane().addKeyListener(this);
        try {
            if (this.htmlEditor.getMenuBar() != null) {
                SwingUtilities.getUIActionMap(this.htmlEditor.getMenuBar()).remove("takeFocus");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.add(this.htmlEditor);
        HTMLEditorOracleBean hTMLEditorOracleBean = this;
        System.out.println("Sferyx JSyndrome HTMLEditorOracleBean started -> v. " + hTMLEditorOracleBean.htmlEditor.getEditorVersion());
    }

    public void setEnableCustomEventDispatching(boolean customEventsDispatchingEnabled) {
        this.customEventsDispatchingEnabled = customEventsDispatchingEnabled;
    }

    public boolean isEnableCustomEventDispatching() {
        return this.customEventsDispatchingEnabled;
    }

    public void setCustomEventDispatchingMask(String eventMask) {
        this.customEventsMask = eventMask;
    }

    public void resetCustomEventDispatchingMask() {
        this.customEventsMask = null;
    }

    public void mouseReleased(MouseEvent me) {
        this.dispatchOracleFormsEvent("mouseReleased", me);
    }

    public void mousePressed(MouseEvent me) {
        this.dispatchOracleFormsEvent("mousePressed", me);
    }

    public void mouseExited(MouseEvent me) {
        this.dispatchOracleFormsEvent("mouseExited", me);
    }

    public void mouseEntered(MouseEvent me) {
        this.dispatchOracleFormsEvent("mouseEntered", me);
    }

    public void mouseClicked(MouseEvent me) {
        this.dispatchOracleFormsEvent("mouseClicked", me);
    }

    public void mouseMoved(MouseEvent me) {
        this.dispatchOracleFormsEvent("mouseMoved", me);
    }

    public void mouseDragged(MouseEvent me) {
        this.dispatchOracleFormsEvent("mouseDragged", me);
    }

    public void focusGained(FocusEvent fe) {
        if (fe.getSource() == this.getParent()) {
            this.requestFocus();
        }
        this.dispatchOracleFormsEvent("focusGained", fe);
    }

    public void focusLost(FocusEvent fe) {
        this.dispatchOracleFormsEvent("focusLost", fe);
    }

    public void removeUpdate(DocumentEvent de) {
        try {
            class SetContentThread
            implements Runnable {
                DocumentEvent de;

                SetContentThread(DocumentEvent de) {
                    this.de = de;
                }

                public void run() {
                    HTMLEditorOracleBean.this.dispatchOracleFormsEvent("removeUpdate", this.de);
                }
            }
            SetContentThread setContentThr = new SetContentThread(de);
            SwingUtilities.invokeLater(setContentThr);
        }
        catch (Throwable thr) {
            this.dispatchOracleFormsEvent("removeUpdate", de);
        }
    }

    public void insertUpdate(DocumentEvent de) {
        try {
            class SetContentThread
            implements Runnable {
                DocumentEvent de;

                SetContentThread(DocumentEvent de) {
                    this.de = de;
                }

                public void run() {
                    HTMLEditorOracleBean.this.dispatchOracleFormsEvent("insertUpdate", this.de);
                }
            }
            SetContentThread setContentThr = new SetContentThread(de);
            SwingUtilities.invokeLater(setContentThr);
        }
        catch (Throwable thr) {
            this.dispatchOracleFormsEvent("insertUpdate", de);
        }
    }

    public void changedUpdate(DocumentEvent de) {
        try {
            class SetContentThread
            implements Runnable {
                DocumentEvent de;

                SetContentThread(DocumentEvent de) {
                    this.de = de;
                }

                public void run() {
                    HTMLEditorOracleBean.this.dispatchOracleFormsEvent("changedUpdate", this.de);
                }
            }
            SetContentThread setContentThr = new SetContentThread(de);
            SwingUtilities.invokeLater(setContentThr);
        }
        catch (Throwable thr) {
            this.dispatchOracleFormsEvent("changedUpdate", de);
        }
    }

    public String selectCurrentWord() {
        if (this.htmlEditor != null) {
            return this.htmlEditor.selectCurrentWord();
        }
        return null;
    }

    public void createEmptyDocument() {
        if (this.htmlEditor != null) {
            this.htmlEditor.setContent("");
        }
    }

    public void replaceCurrentWord(String replaceWith) {
        if (this.htmlEditor != null) {
            this.htmlEditor.replaceCurrentWord(replaceWith);
        }
    }

    public void setEnableActionEventMaskForUIItems(String uiItemNames, boolean discardDefaultActions) {
        if (uiItemNames == null) {
            return;
        }
        if (this.htmlEditor != null) {
            this.htmlEditor.addActionListenerForUIItems(uiItemNames, this, discardDefaultActions);
        }
    }

    public void actionPerformed(ActionEvent ae) {
        this.dispatchOracleFormsEvent("actionEvent", ae);
    }

    public void resetKeyEventMask() {
        this.keyEventMask = "";
    }

    public void removeRegisteredKeyStrokeFromEditor(int keyCode, boolean shiftDown, boolean altDown, boolean ctrlDown, boolean metaDown, boolean altGraphDown) {
        if (this.htmlEditor != null) {
            KeyStroke ks;
            int keyMask = 0;
            if (shiftDown) {
                keyMask |= 1;
            }
            if (altDown) {
                keyMask |= 8;
            }
            if (ctrlDown) {
                keyMask |= 2;
            }
            if (metaDown) {
                keyMask |= 4;
            }
            if (altGraphDown) {
                keyMask |= 0x20;
            }
            if ((ks = KeyStroke.getKeyStroke(keyCode, keyMask)) != null) {
                this.htmlEditor.getInternalJEditorPane().getKeymap().removeKeyStrokeBinding(ks);
            }
        }
    }

    public void addKeyToKeyEventMask(int keyCode, boolean shiftDown, boolean altDown, boolean ctrlDown, boolean metaDown, boolean altGraphDown) {
        this.keyEventMask = this.keyEventMask + ";" + keyCode + "+" + shiftDown + "+" + altDown + "+" + ctrlDown + "+" + metaDown + "+" + altGraphDown + ";";
    }

    public void keyTyped(KeyEvent ke) {
        if (this.keyEventMask != null && !this.keyEventMask.equals("")) {
            return;
        }
        this.dispatchOracleFormsEvent("keyTyped", ke);
    }

    public void keyPressed(KeyEvent ke) {
        if (this.keyEventMask != null && !this.keyEventMask.equals("")) {
            String keyEventString = ";" + ke.getKeyCode();
            keyEventString = keyEventString + "+" + ((ke.getModifiers() & 1) == 1);
            keyEventString = keyEventString + "+" + ((ke.getModifiers() & 8) == 8);
            keyEventString = keyEventString + "+" + ((ke.getModifiers() & 2) == 2);
            keyEventString = keyEventString + "+" + ((ke.getModifiers() & 4) == 4);
            keyEventString = keyEventString + "+" + ((ke.getModifiers() & 0x20) == 32);
            if (this.keyEventMask.indexOf(keyEventString = keyEventString + ";") == -1) {
                return;
            }
        }
        this.dispatchOracleFormsEvent("keyPressed", ke);
    }

    public void keyReleased(KeyEvent ke) {
        if (this.keyEventMask != null && !this.keyEventMask.equals("")) {
            return;
        }
        this.dispatchOracleFormsEvent("keyReleased", ke);
    }

    void findListener() {
        block4: {
            Container parent = this.getParent();
            try {
                if (parent == null) break block4;
                if (parent instanceof VBean) {
                    this.listener = (VBean)parent;
                    return;
                }
                while (parent != null) {
                    if (!((parent = parent.getParent()) instanceof VBean)) continue;
                    this.listener = (VBean)parent;
                    break;
                }
            }
            catch (Throwable thr) {
                thr.printStackTrace();
            }
        }
    }

    public void dispatchOracleFormsEvent(String name, Object event) {
        block17: {
            try {
                if (this.listener == null && this.customEventsDispatchingEnabled) {
                    this.findListener();
                }
                if (this.listener == null || !this.customEventsDispatchingEnabled || event == null) break block17;
                String eventStr = event.toString();
                if (eventStr.length() > 500) {
                    eventStr = eventStr.substring(0, 500);
                }
                if (this.customEventsMask != null) {
                    if (this.customEventsMask.toLowerCase().indexOf(name.toLowerCase()) == -1) break block17;
                    try {
                        if (this.bm == null) {
                            this.listener.dispatchCustomEvent(new CustomEvent((Object)this, name + "==>" + eventStr));
                            break block17;
                        }
                        this.bm.dispatchCustomEvent(new CustomEvent((Object)this, name + "==>" + eventStr));
                    }
                    catch (Throwable thrr) {
                        try {
                            if (this.bm == null) {
                                this.bm = new BeanManager();
                                this.bm.setHandler(this.listener.getHandler());
                                this.bm.addCustomListener((CustomListener)this.listener.getHandler());
                            }
                            this.bm.dispatchCustomEvent(new CustomEvent((Object)this, name + "==>" + eventStr));
                            break block17;
                        }
                        catch (Throwable thr) {}
                    }
                    break block17;
                }
                try {
                    if (this.bm == null) {
                        this.listener.dispatchCustomEvent(new CustomEvent((Object)this, name + "==>" + eventStr));
                        break block17;
                    }
                    this.bm.dispatchCustomEvent(new CustomEvent((Object)this, name + "==>" + eventStr));
                }
                catch (Throwable thrr) {
                    try {
                        if (this.bm == null) {
                            this.bm = new BeanManager();
                            this.bm.setHandler(this.listener.getHandler());
                            this.bm.addCustomListener((CustomListener)this.listener.getHandler());
                        }
                        this.bm.dispatchCustomEvent(new CustomEvent((Object)this, name + "==>" + eventStr));
                    }
                    catch (Throwable thr) {}
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setStyleSheetRules(String styleSheet) {
        if (this.htmlEditor != null && styleSheet != null) {
            this.htmlEditor.loadStyleSheetRules(styleSheet);
        }
    }

    public void setLTROrientation() {
        this.htmlEditor.setLTROrientation();
    }

    public void setRTLOrientation() {
        this.htmlEditor.setRTLOrientation();
    }

    public void setBrowsingInPreviewEnabled(boolean enabled) {
        this.htmlEditor.setBrowsingInPreviewEnabled(enabled);
    }

    public boolean isBrowsingInPreviewEnabled() {
        return this.htmlEditor.isBrowsingInPreviewEnabled();
    }

    public void setQuickPrint(boolean quickPrint_) {
        if (this.htmlEditor != null) {
            this.htmlEditor.setQuickPrint(quickPrint_);
        }
    }

    public void setLocalFileBrowsingDisabled(boolean disabled) {
        this.htmlEditor.setLocalFileBrowsingDisabled(disabled);
    }

    public boolean isLocalFileBrowsingDisabled() {
        return this.htmlEditor.isLocalFileBrowsingDisabled();
    }

    public void setEmbedAllImagesInsideTheDocument(boolean embed) {
        this.htmlEditor.setEmbedAllImagesInsideTheDocument(embed);
    }

    public boolean isEmbedAllImagesInsideTheDocument() {
        return this.htmlEditor.isEmbedAllImagesInsideTheDocument();
    }

    public void setFastEditForLargeTextFiles(boolean enabled) {
        if (this.htmlEditor != null) {
            this.htmlEditor.setFastEditForLargeTextFiles(enabled);
        }
    }

    public void setUsePixelsForFontSizeListCombo(boolean usePixelsForFontSizeCombo_) {
        if (this.htmlEditor != null) {
            this.htmlEditor.setUsePixelsForFontSizeListCombo(usePixelsForFontSizeCombo_);
        }
    }

    public void setForcedSpanGeneration(boolean cssgen_) {
        if (this.htmlEditor != null) {
            HTMLEditor.setForcedSpanGeneration(cssgen_);
        }
    }

    public void setCaretPosition(int position) {
        this.htmlEditor.getSelectedEditorComponent().setCaretPosition(position);
    }

    public int getCaretPosition() {
        return this.htmlEditor.getSelectedEditorComponent().getCaretPosition();
    }

    public void setSelection(int start, int end) {
        this.htmlEditor.getSelectedEditorComponent().select(start, end);
    }

    public int getSelectionStart() {
        return this.htmlEditor.getSelectedEditorComponent().getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.htmlEditor.getSelectedEditorComponent().getSelectionEnd();
    }

    public void setContent(String htmlContent) {
        if (this.htmlEditor != null) {
            this.htmlEditor.setContent(htmlContent);
        }
    }

    public void setContent_(String htmlContent) {
        if (this.htmlEditor != null) {
            this.htmlEditor.setContent_(htmlContent);
        }
    }

    public void insertContent(String htmlContent) {
        if (this.htmlEditor != null) {
            this.htmlEditor.insertContent(htmlContent);
        }
    }

    public void insertContent_(String htmlContent) {
        if (this.htmlEditor != null) {
            this.htmlEditor.insertContent_(htmlContent);
        }
    }

    public void insertPlainText(String htmlContent) {
        if (this.htmlEditor != null) {
            this.htmlEditor.insertPlainText(htmlContent);
        }
    }

    public void setRemovedToolbarItems(String itemList) {
        if (this.htmlEditor != null) {
            this.htmlEditor.setRemovedToolbarItems(itemList);
        }
    }

    public void setRemovedMenuItems(String itemList) {
        if (this.htmlEditor != null) {
            this.htmlEditor.setRemovedMenuItems(itemList);
        }
    }

    public boolean isCaretPlacedInAReadOnlySection() {
        return this.htmlEditor.checkReadonlySections();
    }

    public void setDisableIndentingAndLineBreaks(boolean _disableIndentingAndLineBreaks) {
        if (this.htmlEditor != null) {
            this.htmlEditor.setDisableIndentingAndLineBreaks(_disableIndentingAndLineBreaks);
        }
    }

    public void setRemovedMenus(String itemList) {
        if (this.htmlEditor != null) {
            this.htmlEditor.setRemovedMenus(itemList);
        }
    }

    public void setRemovedPopupMenuItems(String itemList) {
        if (this.htmlEditor != null) {
            this.htmlEditor.setRemovedPopupMenuItems(itemList);
        }
    }

    public void setStatusBarVisible(boolean visible) {
        if (this.htmlEditor != null) {
            this.htmlEditor.setStatusBarVisible(visible);
        }
    }

    public void setPopupMenuVisible(boolean visible) {
        if (this.htmlEditor != null) {
            this.htmlEditor.setPopupMenuVisible(visible);
        }
    }

    public String getContent() {
        if (this.htmlEditor != null) {
            return this.htmlEditor.getContent();
        }
        return "";
    }

    public String getPlainText() {
        if (this.htmlEditor != null) {
            return this.htmlEditor.getPlainText();
        }
        return "";
    }

    public void setTransferFocusInside(boolean transfer) {
        this.requestFocus();
    }

    public void setTransferFocusOutside(boolean transfer) {
        this.transferFocus();
    }

    public void transferFocus() {
        if (this.htmlEditor != null) {
            this.htmlEditor.transferFocus();
        }
    }

    public void requestFocus() {
        if (this.htmlEditor != null) {
            this.htmlEditor.getSelectedEditorComponent().grabFocus();
            this.htmlEditor.getSelectedEditorComponent().getCaret().setVisible(true);
        }
    }

    public boolean isShowRulers() {
        return this.htmlEditor.isShowRulers();
    }

    public void setShowRulers(boolean show) {
        if (this.htmlEditor != null) {
            this.htmlEditor.setShowRulers(show);
        }
    }

    public void setForceCSSOutput(boolean force) {
        if (this.htmlEditor != null) {
            this.htmlEditor.setForceCSSOutput(force);
        }
    }

    public void setToolBarVisible(boolean visible) {
        if (this.htmlEditor != null) {
            this.htmlEditor.setToolBarVisible(visible);
        }
    }

    public String getBodyContent() {
        if (this.htmlEditor != null) {
            return this.htmlEditor.getBodyContent();
        }
        return "";
    }

    public void insertImage(String imageURL) {
        if (this.htmlEditor != null) {
            this.htmlEditor.insertImage(imageURL);
        }
    }

    public void insertLink(String linkURL) {
        if (this.htmlEditor != null) {
            this.htmlEditor.insertLink(linkURL);
        }
    }

    public void setDefaultCharset(String encoding) {
        if (this.htmlEditor != null) {
            this.htmlEditor.setDefaultCharset(encoding);
        }
    }

    public void setUploadContentAsMultipartFormData(boolean uploadContentAsMultipartFormData) {
        this.htmlEditor.setUploadContentAsMultipartFormData(uploadContentAsMultipartFormData);
    }

    public void setUploadedObjectsTranslationPath(String uploadedObjectsTranslationPath) {
        this.htmlEditor.setUploadedObjectsTranslationPath(uploadedObjectsTranslationPath);
    }

    public boolean uploadMultipartContent(String saveLocation, boolean entireFile) {
        return this.htmlEditor.uploadMultipartContent(saveLocation, entireFile);
    }

    public void setPublishContentUsingWebDAV(boolean publishContentUsingWebDAV_) {
        this.htmlEditor.setPublishContentUsingWebDAV(publishContentUsingWebDAV_);
    }

    public void setGenerateUniqueImageFilenames(boolean generateUniqueImageFilenames_) {
        this.htmlEditor.setGenerateUniqueImageFilenames(generateUniqueImageFilenames_);
    }

    public void saveToLocation(String saveLocation, boolean entireFile) {
        this.htmlEditor.saveToLocation(saveLocation, entireFile);
    }

    public void setGlobalReplacementFontFamilyOnPaste(String replacementFontFamily) {
        this.htmlEditor.setGlobalReplacementFontFamilyOnPaste(replacementFontFamily);
    }

    public void setDontConvertCharacters(boolean convert) {
        this.htmlEditor.setDontConvertCharacters(convert);
    }

    public void exportAsPDF() {
        if (this.htmlEditor != null) {
            this.htmlEditor.exportAsPDF();
        }
    }

    public void setDocumentLenghtLimit(int limit, String warningMessage) {
        this.htmlEditor.setDocumentLenghtLimit(limit, warningMessage);
    }

    public void setDocumentLenghtLimitIsForPlainText(boolean limitForPlainText) {
        this.htmlEditor.setDocumentLenghtLimitIsForPlainText(limitForPlainText);
    }

    public void resetDocumentLenghtLimit() {
        this.htmlEditor.resetDocumentLenghtLimit();
    }

    public boolean isDocumentLenghtLimitIsForPlainText() {
        return this.htmlEditor.isDocumentLenghtLimitIsForPlainText();
    }

    public int getDocumentSizeLimit() {
        return this.htmlEditor.getDocumentSizeLimit();
    }

    public void setMaxFileUploadSize(String maxFileUploadSize) {
        this.htmlEditor.setMaxFileUploadSize(maxFileUploadSize);
    }

    public void openRTFFile(String fileURL) {
        try {
            this.htmlEditor.openRTFFile(new URL(fileURL));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void openLocation(String location) {
        if (this.htmlEditor != null) {
            this.htmlEditor.openLocation(location);
        }
    }

    public void setPreviewModeOnly(boolean previewModeOnly) {
        this.htmlEditor.setPreviewModeOnly(previewModeOnly);
    }

    public void openContentBuffer() {
        this.htmlEditor.openContentBuffer();
    }

    public void appendContentToContentBuffer(String content) {
        this.htmlEditor.appendContentToContentBuffer(content);
    }

    public void closeBufferAndInsert() {
        this.htmlEditor.closeBufferAndInsert();
    }

    public int getBodyContentLength() {
        return this.htmlEditor.getBodyContentLenght();
    }

    public int getBodyContentLenght() {
        return this.htmlEditor.getBodyContentLenght();
    }

    public int getContentLength() {
        return this.htmlEditor.getContentLenght();
    }

    public int getContentLenght() {
        return this.htmlEditor.getContentLenght();
    }

    public int getMultipartMimeMessageContentLength() {
        return this.htmlEditor.getContentAsMultipartMimeMessage().length();
    }

    public String getMultipartMimeMessageContentPortion(int offset, int length) {
        return this.htmlEditor.getContentAsMultipartMimeMessage().substring(offset, offset + length);
    }

    public boolean writeContentAsMultipartMessageToFile(String fileName) {
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            this.htmlEditor.writeContentAsMultipartMimeMessageToStream(fos);
            fos.close();
        }
        catch (Throwable thr) {
            thr.printStackTrace();
            return false;
        }
        return true;
    }

    public String getContentAsMultipartMimeMessage() {
        return this.htmlEditor.getContentAsMultipartMimeMessage();
    }

    public String getBodyContentPortion(int offset, int length) {
        return this.htmlEditor.getBodyContentPortion(offset, length);
    }

    public String getContentPortion(int offset, int length) {
        return this.htmlEditor.getContentPortion(offset, length);
    }

    public void closeBufferAndInsertAtCaretPosition() {
        this.htmlEditor.closeBufferAndInsertAtCaretPosition();
    }

    public int getPlainTextContentLength() {
        return this.htmlEditor.getPlainTextContentLenght();
    }

    public int getPlainTextContentLenght() {
        return this.htmlEditor.getPlainTextContentLenght();
    }

    public String getPlainTextContentPortion(int offset, int length) {
        return this.htmlEditor.getPlainTextContentPortion(offset, length);
    }

    public void setSourceEditorVisible(boolean visible) {
        this.htmlEditor.setSourceEditorVisible(visible);
    }

    public void setPreviewVisible(boolean visible) {
        this.htmlEditor.setPreviewVisible(visible);
    }

    public void setMainMenuVisible(boolean visible) {
        this.htmlEditor.setMainMenuVisible(visible);
    }

    public void setFormattingToolbarVisible(boolean visible) {
        this.htmlEditor.setFormattingToolbarVisible(visible);
    }

    public void setShortcutToolbarVisible(boolean visible) {
        this.htmlEditor.setShortcutToolbarVisible(visible);
    }

    public boolean isDocumentEdited() {
        return this.htmlEditor.isDocumentEdited();
    }

    public void setPreferredPasteOperation(int preferredPasteOperation) {
        this.htmlEditor.setPreferredPasteOperation(preferredPasteOperation);
    }

    public int getPreferredPasteOperation() {
        return this.htmlEditor.getPreferredPasteOperation();
    }

    public void loadExternalStyleSheet(String externalStyleSheetLocation) {
        this.htmlEditor.loadExternalStyleSheet(externalStyleSheetLocation);
    }

    public String getBodyUnicodeContent() {
        return this.htmlEditor.getBodyUnicodeContent();
    }

    public void setSourceCodeModeOnly(boolean sourceCodeModeOnly) {
        this.htmlEditor.setSourceCodeModeOnly(sourceCodeModeOnly);
    }

    public void setShowBodyContentOnlyInSource(String _showBodyContentOnlyInSource) {
        this.htmlEditor.setShowBodyContentOnlyInSource(_showBodyContentOnlyInSource);
    }

    public String getEditorVersion() {
        HTMLEditorOracleBean hTMLEditorOracleBean = this;
        return hTMLEditorOracleBean.htmlEditor.getEditorVersion();
    }

    public String getEditorState() {
        int state = this.htmlEditor.getEditorState();
        if (state == 0) {
            return "VISUAL_EDITOR";
        }
        if (state == 1) {
            return "SOURCE_EDITOR";
        }
        return "PAGE_PREVIEW";
    }

    public String getExternalStyleSheetLocation() {
        return this.htmlEditor.getExternalStyleSheetLocation();
    }

    public void loadExternalStyleSheet(StyleSheet styleSheet, String styleSheetURL) {
        this.htmlEditor.loadExternalStyleSheet(styleSheet, styleSheetURL);
    }

    public void loadInterfaceLanguageFile(String fileURL) {
        this.htmlEditor.loadInterfaceLanguageFile(fileURL);
    }

    public void setExternalStyleSheetLocation(String externalStyleSheetLocation) {
        this.htmlEditor.setExternalStyleSheetLocation(externalStyleSheetLocation);
    }

    public void loadStyleSheetRules(String styleSheet) {
        this.htmlEditor.loadStyleSheetRules(styleSheet);
    }

    public void setRestrictedHeadingList(String headingList) {
        this.htmlEditor.setRestrictedHeadingList(headingList);
    }

    public void setRestrictedFontList(String fontList) {
        this.htmlEditor.setRestrictedFontList(fontList);
    }

    public void setRestrictedFontSizesList(String fontList) {
        this.htmlEditor.setRestrictedFontSizesList(fontList);
    }

    public void setDefaultInitialFont(String initialFont) {
        this.htmlEditor.setDefaultInitialFont(initialFont);
    }

    public void setDefaultInitialFontSize(String fontSize) {
        this.htmlEditor.setDefaultInitialFontSize(fontSize);
    }

    public void setWrapNewLineIntoBR(boolean wrap) {
        this.htmlEditor.wrapNewLineIntoBR(wrap);
    }

    public void setSingleParagraphSpacing(boolean wrap) {
        this.htmlEditor.setSingleParagraphSpacing(wrap);
    }

    public String getContentAccessibleForScreenReaders() {
        return this.htmlEditor.getContentAccessibleForScreenReaders();
    }

    public String getBodyContentAccessibleForScreenReaders() {
        return this.htmlEditor.getBodyContentAccessibleForScreenReaders();
    }

    public void resetDocumentEdited() {
        this.htmlEditor.resetDocumentEdited();
    }

    public void setPDFExportOutputEncoding(String encoding) {
        this.htmlEditor.setPDFExportOutputEncoding(encoding);
    }

    public void setFlowToolbarLayout() {
        this.htmlEditor.setFlowToolbarLayout();
    }

    public void setFlowToolbarLayout(boolean flowLayout) {
        if (flowLayout) {
            this.htmlEditor.setFlowToolbarLayout();
        }
    }

    public HTMLEditor getHTMLEditorInstance() {
        return this.htmlEditor;
    }

    public void start() {
    }
}

