/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.html.CSS;
import javax.swing.text.html.StyleSheet;
import sferyx.administration.editors.HTMLEditor;
import sferyx.administration.editors.SferyxUtilities;

public class HTMLCleaner {
    StringBuffer content;
    StringBuffer lowerCaseContent;
    StyleSheet internalStyleSheet;
    Hashtable styleDefinitions = new Hashtable();
    String replacementFontFamily = null;
    StringBuffer styleBuffer;
    boolean discardStyles = false;

    public String cleanHTML(String htmlString) {
        if (HTMLEditor.jvm_older) {
            this.content = new StringBuffer(htmlString);
            this.lowerCaseContent = new StringBuffer(htmlString.toLowerCase());
            String result = this.extractStyleSheetOlder(htmlString);
            result = SferyxUtilities.replaceAll(result, "<o:p>", "");
            result = SferyxUtilities.replaceAll(result, "</o:p>", "");
            result = SferyxUtilities.replaceAll(result, "<tbody>", "");
            result = SferyxUtilities.replaceAll(result, "</tbody>", "");
            result = SferyxUtilities.replaceAll(result, "<span", "<font");
            if ((result = SferyxUtilities.replaceAll(result, "</span>", "</font>")).indexOf("<v:imagedata ") != -1 && result.indexOf("<img ") == -1) {
                result = SferyxUtilities.replaceAll(result, "<v:imagedata ", "<img ");
            }
            return result;
        }
        try {
            this.content = new StringBuffer(htmlString);
            this.lowerCaseContent = new StringBuffer(htmlString.toLowerCase());
            this.extractStyleSheet();
            this.clearOPTags();
            this.clearTBody();
            this.clearFragments();
            if (this.content.indexOf("<v:imagedata ") != -1 && this.content.indexOf("<img ") == -1) {
                this.replaceAll(this.content, "<v:imagedata ", "<img ");
            }
            if (this.discardStyles) {
                this.content = this.discardAllStyleInformation();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this.content.toString();
    }

    void clearOPTags() {
        this.replaceAll(this.content, "<o:p>", "");
        this.replaceAll(this.content, "</o:p>", "");
    }

    void convertSpanTags() {
        this.replaceAll(this.content, "<span", "<font");
        this.replaceAll(this.content, "</span>", "</font>");
    }

    void clearTBody() {
        this.replaceAll(this.content, "<tbody>", "");
        this.replaceAll(this.content, "</tbody>", "");
    }

    void clearFragments() {
    }

    void replaceAll(StringBuffer content, String toReplace, String replaceWith) {
        if (HTMLEditor.jvm_older) {
            String result = SferyxUtilities.replaceAll(content.toString(), toReplace, replaceWith);
            content = new StringBuffer(result);
            this.lowerCaseContent = new StringBuffer(result.toLowerCase());
            return;
        }
        int foundIndex = 0;
        StringBuffer resultLine = this.lowerCaseContent;
        while (foundIndex != -1) {
            int indexOfXHTMLTag = resultLine.indexOf(toReplace, foundIndex);
            if (indexOfXHTMLTag == -1) {
                indexOfXHTMLTag = resultLine.indexOf(toReplace.toLowerCase(), foundIndex);
            }
            if (indexOfXHTMLTag == -1) {
                indexOfXHTMLTag = resultLine.indexOf(toReplace.toUpperCase(), foundIndex);
            }
            if (indexOfXHTMLTag == -1) {
                foundIndex = -1;
                continue;
            }
            resultLine.replace(indexOfXHTMLTag, indexOfXHTMLTag + toReplace.length(), replaceWith);
            content.replace(indexOfXHTMLTag, indexOfXHTMLTag + toReplace.length(), replaceWith);
        }
    }

    void replaceAllIfFollows(StringBuffer content, String toReplace, String replaceWith, String[] ifFollows) {
        if (HTMLEditor.jvm_older) {
            String result = SferyxUtilities.replaceAllIfFollows(content.toString(), toReplace, replaceWith, ifFollows);
            content = new StringBuffer(result);
            this.lowerCaseContent = new StringBuffer(result.toLowerCase());
            return;
        }
        int foundIndex = 0;
        StringBuffer resultLine = this.lowerCaseContent;
        while (foundIndex != -1) {
            int indexOfXHTMLTag = resultLine.indexOf(toReplace, foundIndex);
            if (indexOfXHTMLTag == -1) {
                indexOfXHTMLTag = resultLine.indexOf(toReplace.toLowerCase(), foundIndex);
            }
            if (indexOfXHTMLTag == -1) {
                indexOfXHTMLTag = resultLine.indexOf(toReplace.toUpperCase(), foundIndex);
            }
            if (indexOfXHTMLTag == -1) {
                foundIndex = -1;
                continue;
            }
            if (ifFollows != null) {
                boolean follows = false;
                for (int i = 0; i < ifFollows.length; ++i) {
                    String followingString;
                    int followsStringLength = ifFollows[i].length();
                    if (followsStringLength > resultLine.length() || !(followingString = resultLine.substring(indexOfXHTMLTag + toReplace.length(), indexOfXHTMLTag + toReplace.length() + followsStringLength)).equals(ifFollows[i])) continue;
                    follows = true;
                    break;
                }
                if (!follows) {
                    foundIndex = indexOfXHTMLTag + 1;
                    continue;
                }
            }
            resultLine.replace(indexOfXHTMLTag, indexOfXHTMLTag + toReplace.length(), replaceWith);
            content.replace(indexOfXHTMLTag, indexOfXHTMLTag + toReplace.length(), replaceWith);
            foundIndex = indexOfXHTMLTag + toReplace.length();
        }
    }

    String extractStyleSheetOlder(String content) {
        try {
            int styleStart = content.indexOf("<style");
            int styleEnd = content.indexOf("</style>");
            if (styleStart == -1 || styleEnd == -1) {
                return content;
            }
            while (styleStart != -1) {
                String styleContent = content.substring(styleStart, styleEnd + 8);
                this.internalStyleSheet = new StyleSheet(){

                    public void addCSSAttribute(MutableAttributeSet attr, CSS.Attribute key, String value) {
                        System.out.println("adding attrbiute:" + key + " value:" + value);
                        if (HTMLEditor.jvm_version.startsWith("1.7") && key != null && key.toString().toLowerCase().startsWith("border")) {
                            attr.addAttribute(key, value);
                            return;
                        }
                    }
                };
                this.internalStyleSheet.addRule(styleContent);
                content = this.getStyleClassesOlder(content);
                styleStart = content.indexOf("<style", styleEnd);
                styleEnd = content.indexOf("</style>", styleStart);
            }
        }
        catch (Throwable except) {
            except.printStackTrace();
        }
        return content;
    }

    void extractStyleSheet() {
        if (HTMLEditor.jvm_older) {
            String result = this.extractStyleSheetOlder(this.content.toString());
            this.content = new StringBuffer(result);
            return;
        }
        try {
            int styleStart = this.content.indexOf("<style");
            int styleEnd = this.content.indexOf("</style>");
            if (styleStart == -1 || styleEnd == -1) {
                return;
            }
            while (styleStart != -1) {
                String styleContent = this.content.substring(styleStart, styleEnd + 8);
                this.internalStyleSheet = new StyleSheet(){

                    public void addCSSAttribute(MutableAttributeSet attr, CSS.Attribute key, String value) {
                        attr.addAttribute(key, value);
                    }
                };
                this.internalStyleSheet.addRule(styleContent);
                this.getStyleClasses();
                styleStart = this.content.indexOf("<style", styleEnd);
                styleEnd = this.content.indexOf("</style>", styleStart);
            }
        }
        catch (Throwable except) {
            except.printStackTrace();
        }
    }

    public String getStyleClassesOlder(String content) {
        Vector<String> styleClasses = new Vector<String>();
        StyleSheet styles = this.internalStyleSheet;
        String styleString = "";
        Enumeration<?> rules = styles.getStyleNames();
        this.styleBuffer = new StringBuffer();
        this.writeStyle("*", styles.getStyle("*"), false);
        String ampersandString = this.styleBuffer.toString();
        ampersandString = ampersandString == null ? "" : ampersandString + ";";
        while (rules.hasMoreElements()) {
            String name = (String)rules.nextElement();
            this.styleBuffer = new StringBuffer();
            this.writeStyle(name, styles.getStyle(name), false);
            String styleDefinition = "style='" + this.styleBuffer.toString() + "'";
            if (name.indexOf(".") != -1) {
                name = name.substring(name.indexOf(".") + 1);
            }
            this.styleDefinitions.put(name, styleDefinition);
            if (name.equals("default")) continue;
            styleClasses.addElement(name);
        }
        content = this.replaceClassesWithStylesOlder(content);
        return content;
    }

    public Vector getStyleClasses() {
        Vector<String> styleClasses = new Vector<String>();
        StyleSheet styles = this.internalStyleSheet;
        String styleString = "";
        Enumeration<?> rules = styles.getStyleNames();
        this.styleBuffer = new StringBuffer();
        this.writeStyle("*", styles.getStyle("*"), false);
        String ampersandString = this.styleBuffer.toString();
        if (ampersandString == null) {
            ampersandString = "";
        } else if (!ampersandString.trim().equals("")) {
            ampersandString = ampersandString + ";";
        }
        while (rules.hasMoreElements()) {
            String name = (String)rules.nextElement();
            this.styleBuffer = new StringBuffer();
            this.writeStyle(name, styles.getStyle(name), false);
            String styleDefinition = "style='" + ampersandString + this.styleBuffer.toString() + "'";
            if (name.indexOf(".") != -1) {
                name = name.substring(name.indexOf(".") + 1);
            }
            this.styleDefinitions.put(name, styleDefinition);
            if (name.equals("default")) continue;
            styleClasses.addElement(name);
        }
        this.replaceClassesWithStyles();
        return styleClasses;
    }

    void replaceClassesWithStyles() {
        Enumeration enum_ = this.styleDefinitions.keys();
        StringBuffer lowerCaseBuffer = new StringBuffer(this.content.toString().toLowerCase());
        while (enum_.hasMoreElements()) {
            String currentSearchedClass = (String)enum_.nextElement();
            String currentStyleDef = (String)this.styleDefinitions.get(currentSearchedClass);
            if (!this.discardStyles) {
                this.replaceAllIfFollows(this.content, "class=" + currentSearchedClass, currentStyleDef, new String[]{" ", ">"});
                this.replaceAllIfFollows(this.content, "<" + currentSearchedClass, "<" + currentSearchedClass + " " + currentStyleDef, new String[]{" ", ">"});
                this.replaceAll(this.content, "class=\"" + currentSearchedClass + "\"", currentStyleDef);
                this.replaceAll(this.content, "'\"", "'");
                continue;
            }
            this.replaceAll(this.content, "class=" + currentSearchedClass, "");
            this.replaceAll(this.content, "' style='", "");
        }
    }

    String replaceClassesWithStylesOlder(String content) {
        Enumeration enum_ = this.styleDefinitions.keys();
        StringBuffer lowerCaseBuffer = new StringBuffer(content.toString().toLowerCase());
        while (enum_.hasMoreElements()) {
            String currentSearchedClass = (String)enum_.nextElement();
            String currentStyleDef = (String)this.styleDefinitions.get(currentSearchedClass);
            if (!this.discardStyles) {
                content = SferyxUtilities.replaceAllIfFollows(content, "class=" + currentSearchedClass, currentStyleDef, new String[]{" ", ">"});
                content = SferyxUtilities.replaceAllIfFollows(content, "<" + currentSearchedClass, "<" + currentSearchedClass + " " + currentStyleDef, new String[]{" ", ">"});
                content = SferyxUtilities.replaceAll(content, "' style='", "; ");
                content = SferyxUtilities.replaceAllIfFollows(content, "class=\"" + currentSearchedClass, currentStyleDef, new String[]{" ", ">", "\""});
                content = SferyxUtilities.replaceAll(content, "'\"", "'");
                continue;
            }
            content = SferyxUtilities.replaceAll(content, "class=" + currentSearchedClass, "");
            content = SferyxUtilities.replaceAll(content, "' style='", "");
        }
        return content;
    }

    boolean writeStyle(String name, Style style, boolean outputStyle) {
        Enumeration<?> attributes;
        boolean didOutputStyle = false;
        if (style == null) {
            return false;
        }
        if (this.replacementFontFamily != null) {
            style.addAttribute(CSS.Attribute.FONT_FAMILY, this.replacementFontFamily);
        }
        if ((attributes = style.getAttributeNames()) != null) {
            block0: while (attributes.hasMoreElements()) {
                Object attribute = attributes.nextElement();
                if (!(attribute instanceof CSS.Attribute)) continue;
                String value = style.getAttribute(attribute).toString();
                if (attribute == CSS.Attribute.MARGIN) {
                    value = value.trim();
                    StringTokenizer st = new StringTokenizer(value, " ");
                    int i = 0;
                    CSS.Attribute[] cssattr = new CSS.Attribute[]{CSS.Attribute.MARGIN_TOP, CSS.Attribute.MARGIN_RIGHT, CSS.Attribute.MARGIN_BOTTOM, CSS.Attribute.MARGIN_LEFT};
                    int tokenCount = st.countTokens();
                    if (tokenCount > 4) {
                        tokenCount = 4;
                    }
                    this.write(";");
                    while (st.hasMoreTokens() && i < cssattr.length) {
                        String nextToken = st.nextToken();
                        if (tokenCount == 4) {
                            this.write(cssattr[i] + "");
                            this.write(": ");
                            this.write(nextToken);
                            this.write(";");
                            ++i;
                            continue;
                        }
                        if (tokenCount == 2) {
                            this.write(cssattr[0] + "");
                            this.write(": ");
                            this.write(nextToken);
                            this.write(";");
                            this.write(cssattr[2] + "");
                            this.write(": ");
                            this.write(nextToken);
                            this.write(";");
                            nextToken = st.nextToken();
                            this.write(cssattr[1] + "");
                            this.write(": ");
                            this.write(nextToken);
                            this.write(";");
                            this.write(cssattr[3] + "");
                            this.write(": ");
                            this.write(nextToken);
                            this.write(";");
                            continue block0;
                        }
                        if (tokenCount == 1) {
                            this.write(cssattr[0] + "");
                            this.write(": ");
                            this.write(nextToken);
                            this.write(";");
                            this.write(cssattr[1] + "");
                            this.write(": ");
                            this.write(nextToken);
                            this.write(";");
                            this.write(cssattr[2] + "");
                            this.write(": ");
                            this.write(nextToken);
                            this.write(";");
                            this.write(cssattr[3] + "");
                            this.write(": ");
                            this.write(nextToken);
                            this.write(";");
                            continue block0;
                        }
                        if (tokenCount != 3) continue;
                        this.write(cssattr[0] + "");
                        this.write(": ");
                        this.write(nextToken);
                        this.write(";");
                        nextToken = st.nextToken();
                        this.write(cssattr[1] + "");
                        this.write(": ");
                        this.write(nextToken);
                        this.write(";");
                        this.write(cssattr[3] + "");
                        this.write(": ");
                        this.write(nextToken);
                        this.write(";");
                        nextToken = st.nextToken();
                        this.write(cssattr[2] + "");
                        this.write(": ");
                        this.write(nextToken);
                        this.write(";");
                        continue block0;
                    }
                    continue;
                }
                if (value == null) continue;
                if (!outputStyle) {
                    outputStyle = true;
                }
                if (!didOutputStyle) {
                    didOutputStyle = true;
                } else if (this.styleBuffer != null && this.styleBuffer.length() > 0 && this.styleBuffer.charAt(this.styleBuffer.length() - 1) != ';') {
                    this.write(";");
                }
                this.write(attribute.toString());
                this.write(": ");
                this.write(value);
            }
        }
        if (didOutputStyle) {
            // empty if block
        }
        return didOutputStyle;
    }

    void write(String output) {
        this.styleBuffer.append(output);
    }

    public void setDiscardStyleInfo(boolean discardStyles) {
        this.discardStyles = discardStyles;
    }

    public static void main(String[] args) {
        HTMLCleaner htmlClean = new HTMLCleaner();
        String cleanedString = htmlClean.cleanHTML("<o:p>kojo e goliam<tbody> pirliak</tbody><o:p>he-he koje");
    }

    public StringBuffer discardAllStyleInformation() {
        int foundIndex = 0;
        StringBuffer resultLine = this.content;
        String toReplace = " style=\"";
        String endToReplace = "\"";
        String replaceWith = "";
        if (resultLine.indexOf(" style='") != -1) {
            toReplace = " style='";
            endToReplace = "'";
        }
        while (foundIndex != -1) {
            int indexOfXHTMLTag = resultLine.indexOf(toReplace, foundIndex);
            if (indexOfXHTMLTag == -1) {
                indexOfXHTMLTag = resultLine.indexOf(toReplace.toLowerCase(), foundIndex);
            }
            if (indexOfXHTMLTag == -1) {
                indexOfXHTMLTag = resultLine.indexOf(toReplace.toUpperCase(), foundIndex);
            }
            if (indexOfXHTMLTag == -1) {
                foundIndex = -1;
                continue;
            }
            int indexOfEndXHTMLTag = resultLine.indexOf(endToReplace, indexOfXHTMLTag + 8);
            resultLine.replace(indexOfXHTMLTag, indexOfEndXHTMLTag + 1, replaceWith);
        }
        return resultLine;
    }
}

