/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class FontChooser
extends JDialog {
    boolean frameSizeAdjusted = false;
    JPanel JPanel1 = new JPanel();
    JCheckBox BoldCheck = new JCheckBox();
    JCheckBox ItalicCheck = new JCheckBox();
    JLabel Preview = new JLabel();
    JLabel JLabel2 = new JLabel();
    JLabel JLabel3 = new JLabel();
    JLabel JLabel4 = new JLabel();
    JScrollPane JScrollPane1 = new JScrollPane();
    JList Fonts;
    JScrollPane JScrollPane2 = new JScrollPane();
    JList Sizes;
    JButton OkButton = new JButton();
    JButton CancelButton = new JButton();
    JButton ColorButton = new JButton();
    TitledBorder titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(), "");
    BevelBorder bevelBorder1 = new BevelBorder(0);
    BevelBorder bevelBorder2 = new BevelBorder(0);
    BevelBorder bevelBorder3 = new BevelBorder(0);
    CompoundBorder compoundBorder1 = new CompoundBorder();
    EtchedBorder etchedBorder1 = new EtchedBorder();
    JSeparator jSeparator1 = new JSeparator();
    JLabel previewLabel = new JLabel("Preview");
    JLabel colorPreviewLabel = new JLabel("");
    JLabel colorPreviewLabelText = new JLabel("Foreground Color:");
    boolean cancel = false;
    AttributeSet attributes;
    private static String[] dfSizes = new String[]{"8", "9", "10", "11", "12", "13", "14", "16", "18", "20", "24", "28", "32", "36", "48", "72"};

    public FontChooser(Frame parent) {
        this(parent, new Font("TimesRoman", 0, 10), true);
    }

    public FontChooser(Frame parent, Font initial, boolean modal) {
        super(parent, modal);
        this.setTitle("Font Chooser");
        this.getContentPane().setLayout(null);
        this.setSize(400, 300);
        this.setVisible(false);
        this.JPanel1.setLayout(null);
        this.getContentPane().add(this.JPanel1);
        this.JPanel1.setBounds(8, 8, 392, 290);
        this.BoldCheck.setText("Bold");
        this.JPanel1.add(this.BoldCheck);
        this.BoldCheck.setBounds(280, 52, 82, 21);
        this.ItalicCheck.setText("Italic");
        this.JPanel1.add(this.ItalicCheck);
        this.ItalicCheck.setFont(new Font("Dialog", 2, 11));
        this.ItalicCheck.setBounds(280, 32, 64, 20);
        this.JPanel1.add(this.colorPreviewLabelText);
        this.colorPreviewLabelText.setBounds(280, 72, 100, 17);
        this.colorPreviewLabelText.setFont(new Font("Dialog", 0, 11));
        this.JPanel1.add(this.colorPreviewLabel);
        this.colorPreviewLabel.setBounds(280, 95, 15, 15);
        this.colorPreviewLabel.setOpaque(true);
        this.JPanel1.add(this.ColorButton);
        this.ColorButton.setBounds(305, 92, 75, 20);
        this.Preview.setHorizontalTextPosition(0);
        this.Preview.setHorizontalAlignment(0);
        this.Preview.setText("AaBbYyGgLlJj");
        this.Preview.setFont(initial);
        this.Preview.setBorder(this.etchedBorder1);
        this.JPanel1.add(this.Preview);
        this.Preview.setOpaque(true);
        this.Preview.setForeground(Color.black);
        this.Preview.setBackground(Color.white);
        this.Preview.setBounds(10, 140, 370, 100);
        this.JLabel2.setText("Font Name:");
        this.JPanel1.add(this.JLabel2);
        this.JLabel2.setForeground(Color.black);
        this.JLabel2.setFont(new Font("Dialog", 0, 11));
        this.JLabel2.setBounds(10, 10, 102, 17);
        this.JLabel3.setText("Size:");
        this.JPanel1.add(this.JLabel3);
        this.JLabel3.setForeground(Color.black);
        this.JLabel3.setFont(new Font("Dialog", 0, 11));
        this.JLabel3.setBounds(220, 10, 52, 19);
        this.JLabel4.setText("Style:");
        this.JPanel1.add(this.JLabel4);
        this.JLabel4.setForeground(Color.black);
        this.JLabel4.setFont(new Font("Dialog", 0, 11));
        this.JLabel4.setBounds(280, 10, 52, 19);
        this.JPanel1.add(this.JScrollPane1);
        this.JScrollPane1.setBounds(10, 32, 200, 82);
        this.Fonts = new JList<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        this.Fonts.setBorder(this.bevelBorder2);
        this.JScrollPane1.getViewport().add(this.Fonts);
        this.Fonts.setBounds(0, 0, 95, 79);
        this.JPanel1.add(this.JScrollPane2);
        this.JScrollPane2.setBounds(220, 32, 51, 82);
        this.Sizes = new JList<String>(dfSizes);
        this.Sizes.setBorder(this.bevelBorder1);
        this.JScrollPane2.getViewport().add(this.Sizes);
        this.Sizes.setBounds(0, 0, 48, 79);
        this.OkButton.setText("Ok");
        this.ColorButton.setText("Select Color");
        this.CancelButton.setText("Cancel");
        this.JPanel1.add(this.OkButton);
        this.JPanel1.add(this.CancelButton);
        this.OkButton.setFont(new Font("Dialog", 0, 11));
        this.OkButton.setBounds(210, 250, 80, 25);
        this.ColorButton.setFont(new Font("Dialog", 0, 11));
        this.CancelButton.setFont(new Font("Dialog", 0, 11));
        this.CancelButton.setBounds(300, 250, 80, 25);
        this.titledBorder1.setTitleFont(new Font("Dialog", 0, 11));
        this.titledBorder1.setTitle("Font Chooser");
        this.titledBorder1.setTitleColor(Color.black);
        SymListSelection lSymListSelection = new SymListSelection();
        this.Fonts.addListSelectionListener(lSymListSelection);
        this.Sizes.addListSelectionListener(lSymListSelection);
        SymItem lSymItem = new SymItem();
        this.BoldCheck.addItemListener(lSymItem);
        this.ItalicCheck.addItemListener(lSymItem);
        SymAction lSymAction = new SymAction();
        this.OkButton.addActionListener(lSymAction);
        this.ColorButton.addActionListener(lSymAction);
        this.CancelButton.addActionListener(lSymAction);
        this.JPanel1.add(this.jSeparator1);
        this.jSeparator1.setBounds(60, 130, 320, 2);
        this.JPanel1.add(this.previewLabel);
        this.previewLabel.setBounds(10, 120, 50, 20);
    }

    public FontChooser() {
        this((Frame)null);
    }

    public FontChooser(String sTitle) {
        this();
        this.setTitle(sTitle);
    }

    public void setVisible(boolean b) {
        if (b) {
            this.setLocation((int)(this.getParent().getBounds().getX() + this.getParent().getBounds().getWidth() / 2.0 - this.getBounds().getWidth() / 2.0), (int)(this.getParent().getBounds().getY() + this.getParent().getBounds().getHeight() / 2.0 - this.getBounds().getHeight() / 2.0));
        }
        super.setVisible(b);
    }

    public static void main(String[] args) {
        new FontChooser().setVisible(true);
    }

    public void addNotify() {
        Dimension size = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + size.width, insets.top + insets.bottom + size.height);
    }

    void Fonts_valueChanged(ListSelectionEvent event) {
        this.Fonts_valueChanged_Interaction1(event);
    }

    void Fonts_valueChanged_Interaction1(ListSelectionEvent event) {
        try {
            this.Preview.setFont(new Font((String)this.Fonts.getSelectedValue(), this.Preview.getFont().getStyle(), this.Preview.getFont().getSize()));
            this.Preview.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void Sizes_valueChanged(ListSelectionEvent event) {
        this.Sizes_valueChanged_Interaction1(event);
    }

    void Sizes_valueChanged_Interaction1(ListSelectionEvent event) {
        try {
            this.Preview.setFont(new Font(this.Preview.getFont().getName(), this.Preview.getFont().getStyle(), Integer.parseInt((String)this.Sizes.getSelectedValue())));
            this.Preview.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void BoldCheck_itemStateChanged(ItemEvent event) {
        this.BoldCheck_itemStateChanged_Interaction1(event);
    }

    void BoldCheck_itemStateChanged_Interaction1(ItemEvent event) {
        try {
            int style = 0;
            if (this.ItalicCheck.isSelected() && this.BoldCheck.isSelected()) {
                style = 3;
            } else if (!this.ItalicCheck.isSelected() && this.BoldCheck.isSelected()) {
                style = 1;
            } else if (!this.ItalicCheck.isSelected() && !this.BoldCheck.isSelected()) {
                style = 0;
            } else if (this.ItalicCheck.isSelected() && !this.BoldCheck.isSelected()) {
                style = 2;
            }
            this.Preview.setFont(new Font(this.Preview.getFont().getName(), style, this.Preview.getFont().getSize()));
            this.Preview.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void ItalicCheck_itemStateChanged(ItemEvent event) {
        this.ItalicCheck_itemStateChanged_Interaction1(event);
    }

    void ItalicCheck_itemStateChanged_Interaction1(ItemEvent event) {
        try {
            int style = 0;
            if (this.ItalicCheck.isSelected() && this.BoldCheck.isSelected()) {
                style = 3;
            } else if (!this.ItalicCheck.isSelected() && this.BoldCheck.isSelected()) {
                style = 1;
            } else if (!this.ItalicCheck.isSelected() && !this.BoldCheck.isSelected()) {
                style = 0;
            } else if (this.ItalicCheck.isSelected() && !this.BoldCheck.isSelected()) {
                style = 2;
            }
            this.Preview.setFont(new Font(this.Preview.getFont().getName(), style, this.Preview.getFont().getSize()));
            this.Preview.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void OkButton_actionPerformed(ActionEvent event) {
        this.OkButton_actionPerformed_Interaction1(event);
    }

    void OkButton_actionPerformed_Interaction1(ActionEvent event) {
        try {
            this.cancel = false;
            this.setVisible(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void CancelButton_actionPerformed(ActionEvent event) {
        this.cancel = true;
        this.setVisible(false);
    }

    void ColorButton_actionPerformed(ActionEvent event) {
        Color newColor = JColorChooser.showDialog(this, "Choose Foreground Color", this.colorPreviewLabel.getBackground());
        if (newColor == null) {
            return;
        }
        this.colorPreviewLabel.setBackground(newColor);
        this.Preview.setForeground(newColor);
    }

    public void initFontProperties(AttributeSet attribs) {
        this.attributes = attribs;
        if (attribs != null) {
            String fontFamily = StyleConstants.getFontFamily(attribs);
            int fontSize = StyleConstants.getFontSize(attribs);
            Color foreground = StyleConstants.getForeground(attribs);
            boolean bold = StyleConstants.isBold(attribs);
            boolean italic = StyleConstants.isItalic(attribs);
            int style = 0;
            if (bold && italic) {
                style = 3;
            } else if (bold) {
                style = 1;
            } else if (italic) {
                style = 2;
            }
            this.Preview.setFont(new Font(fontFamily, style, fontSize));
            this.Preview.setForeground(foreground);
            this.colorPreviewLabel.setBackground(foreground);
            this.Fonts.setSelectedValue(fontFamily, true);
            this.Sizes.setSelectedValue(String.valueOf(fontSize), true);
            this.BoldCheck.setSelected(bold);
            this.ItalicCheck.setSelected(italic);
        }
    }

    public static Font getSelectedFont(Component target, AttributeSet attribs) {
        FontChooser fontChooser = new FontChooser((Frame)SwingUtilities.windowForComponent(target));
        fontChooser.initFontProperties(attribs);
        fontChooser.setVisible(true);
        Font r = fontChooser.getSelectedFont();
        fontChooser.dispose();
        return r;
    }

    public static AttributeSet getNewAttributes(Component target, AttributeSet attribs) {
        FontChooser fontChooser = new FontChooser((Frame)SwingUtilities.windowForComponent(target));
        fontChooser.initFontProperties(attribs);
        fontChooser.setVisible(true);
        AttributeSet attrib = fontChooser.getAttributes();
        fontChooser.dispose();
        return attrib;
    }

    public AttributeSet getAttributes() {
        if (this.cancel) {
            return null;
        }
        if (this.attributes == null) {
            return null;
        }
        SimpleAttributeSet newAttribs = new SimpleAttributeSet(this.attributes);
        Font font = this.Preview.getFont();
        Color color = this.Preview.getForeground();
        StyleConstants.setFontFamily(newAttribs, font.getFamily());
        StyleConstants.setFontSize(newAttribs, font.getSize());
        StyleConstants.setForeground(newAttribs, color);
        StyleConstants.setItalic(newAttribs, font.isItalic());
        StyleConstants.setBold(newAttribs, font.isBold());
        newAttribs.addAttribute("InternalFont", font);
        return newAttribs;
    }

    public Font getSelectedFont() {
        if (this.cancel) {
            return null;
        }
        return this.Preview.getFont();
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == FontChooser.this.OkButton) {
                FontChooser.this.OkButton_actionPerformed(event);
            }
            if (object == FontChooser.this.CancelButton) {
                FontChooser.this.CancelButton_actionPerformed(event);
            }
            if (object == FontChooser.this.ColorButton) {
                FontChooser.this.ColorButton_actionPerformed(event);
            }
        }
    }

    class SymItem
    implements ItemListener {
        SymItem() {
        }

        public void itemStateChanged(ItemEvent event) {
            Object object = event.getSource();
            if (object == FontChooser.this.BoldCheck) {
                FontChooser.this.BoldCheck_itemStateChanged(event);
            } else if (object == FontChooser.this.ItalicCheck) {
                FontChooser.this.ItalicCheck_itemStateChanged(event);
            }
        }
    }

    class SymListSelection
    implements ListSelectionListener {
        SymListSelection() {
        }

        public void valueChanged(ListSelectionEvent event) {
            Object object = event.getSource();
            if (object == FontChooser.this.Fonts) {
                FontChooser.this.Fonts_valueChanged(event);
            } else if (object == FontChooser.this.Sizes) {
                FontChooser.this.Sizes_valueChanged(event);
            }
        }
    }
}

