/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Element;
import sferyx.administration.editors.CustomBlockView;
import sferyx.administration.editors.CustomParagraphView;
import sferyx.administration.editors.EditorHTMLDocument;

public class FoldingView
extends CustomBlockView {
    int collapsedSpan = 50;
    boolean expanded = false;
    static Font tagsFont = new Font("Arial", 1, 11);
    short foldingSignOffset = (short)20;
    public int foldingSignX = 0;
    public int foldingSignY = 0;
    public int foldingSignWidth = 0;
    public int foldingSignHeight = 0;

    public FoldingView(Element elem, int axis) {
        super(elem, axis);
        if (elem.getAttributes().getAttribute("initialstate") != null && elem.getAttributes().isDefined("initialstate")) {
            String state = elem.getAttributes().getAttribute("initialstate").toString();
            if (state.equals("expanded")) {
                this.setExpanded(true);
            } else if (state.equals("collapsed")) {
                this.setExpanded(false);
            }
        }
    }

    public float getMaximumSpan(int axis) {
        if (this.expanded) {
            return super.getMaximumSpan(axis);
        }
        if (axis == 1 && !this.expanded) {
            return this.collapsedSpan;
        }
        return super.getMaximumSpan(axis);
    }

    public float getPreferredSpan(int axis) {
        if (this.expanded) {
            return super.getPreferredSpan(axis);
        }
        if (axis == 1 && !this.expanded) {
            return this.collapsedSpan;
        }
        return super.getPreferredSpan(axis);
    }

    public float getMinimumSpan(int axis) {
        if (this.expanded) {
            return super.getMinimumSpan(axis);
        }
        if (axis == 1 && !this.expanded) {
            return this.collapsedSpan;
        }
        return super.getMinimumSpan(axis);
    }

    int getMaxSpan(int fromIndex, int toIndex, int[] spans, int[] offsets) {
        if (this.expanded) {
            return super.getMaxSpan(fromIndex, toIndex, spans, offsets);
        }
        int viewCount = this.getViewCount();
        if (viewCount > 0) {
            if (this.getView(0) instanceof CustomParagraphView) {
                this.collapsedSpan = (int)this.getView(0).getView(0).getPreferredSpan(1);
                this.collapsedSpan += ((CustomParagraphView)this.getView(0)).getTopMargin();
            } else {
                this.collapsedSpan = 30;
            }
        }
        this.collapsedSpan += this.getTopInset();
        return this.collapsedSpan;
    }

    public short getLeftInset() {
        short origInset = super.getLeftInset();
        return (short)(origInset + this.foldingSignOffset);
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
        ((EditorHTMLDocument)this.getDocument()).lock();
        if (expanded) {
            ((AbstractDocument.AbstractElement)this.getElement()).addAttribute("initialstate", "expanded");
        } else {
            ((AbstractDocument.AbstractElement)this.getElement()).addAttribute("initialstate", "collapsed");
        }
        ((EditorHTMLDocument)this.getDocument()).unlock();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void paint(Graphics g, Shape allocation) {
        Rectangle alloc = allocation instanceof Rectangle ? (Rectangle)allocation : allocation.getBounds();
        this.foldingSignX = alloc.x;
        this.foldingSignY = alloc.y;
        this.foldingSignWidth = g.getFontMetrics().stringWidth("[+]");
        this.foldingSignHeight = g.getFontMetrics().getHeight();
        if (!this.expanded) {
            alloc.height = this.collapsedSpan;
            Rectangle clip = (Rectangle)g.getClip();
            g.setClip(alloc);
            super.paint(g, alloc);
            g.setClip(clip);
        } else {
            super.paint(g, alloc);
        }
        g.setFont(tagsFont);
        g.setColor(Color.lightGray);
        if (this.expanded) {
            g.drawString("[-]", alloc.x, alloc.y + g.getFontMetrics().getHeight());
        } else {
            g.drawString("[+]", alloc.x, alloc.y + g.getFontMetrics().getHeight());
        }
        g.drawLine(alloc.x + this.foldingSignOffset / 3, alloc.y + g.getFontMetrics().getHeight() + 2, alloc.x + this.foldingSignOffset / 3, alloc.y + alloc.height);
        g.drawLine(alloc.x + this.foldingSignOffset / 3, alloc.y + alloc.height, alloc.x + this.foldingSignOffset / 3 + 5, alloc.y + alloc.height);
    }
}

