/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLWriter;
import javax.swing.text.html.Option;
import sferyx.administration.editors.AlternativeCSSAttribute;
import sferyx.administration.editors.AttributeSetTranslator;
import sferyx.administration.editors.CustomImageView;
import sferyx.administration.editors.CustomXMLTagsGrammarSpecification;
import sferyx.administration.editors.EditorHTMLDocument;
import sferyx.administration.editors.HTMLEditor;
import sferyx.administration.editors.HiddenValue;
import sferyx.administration.editors.SferyxUtilities;
import sferyx.administration.editors.adapters.GenericTagAdapter;

public class FOXMLWriter
extends HTMLWriter {
    boolean dontGenerateAnythingAfterEndPosition = false;
    int pos;
    int length;
    JEditorPane currentEditor = null;
    boolean disableContentLines = false;
    Vector customTags = new Vector();
    AttributeSetTranslator translator = new AttributeSetTranslator();
    private Vector tagValues = new Vector(10);
    private Vector tags = new Vector(10);
    private Vector tagsToRemove = new Vector(10);
    static String[] additionStlyeDeclarations = new String[]{"animation", "animation-name", "animation-duration", "animation-timing-function", "width", "height", "animation-delay", "animation-iteration-count", "animation-direction", "animation-play-state", "background-clip", "background-origin", "background-size", "border-bottom-color", "border-bottom-style", "border-left-color", "border-left-style", "border-right-color", "border-right-style", "border-top-color", "border-top-style", "outline", "outline-color", "outline-style", "outline-width", "border-bottom-left-radius", "border-bottom-right-radius", "border-image", "border-image-outset", "border-image-repeat", "border-image-slice", "border-image-source", "border-image-width", "border-radius", "border-top-left-radius", "border-top-right-radius", "box-decoration-break", "box-shadow", "overflow-x", "overflow-y", "overflow-style", "rotation", "rotation-point", "color-profile", "opacity", "rendering-intent", "bookmark-label", "bookmark-level", "bookmark-target", "float-offset", "hyphenate-after", "hyphenate-before", "hyphenate-character", "hyphenate-lines", "hyphenate-resource", "hyphens", "image-resolution", "marks", "string-set", "max-height", "max-width", "min-height", "min-width", "box-align", "box-direction", "box-flex", "box-flex-group", "box-lines", "box-ordinal-group", "box-orient", "box-pack", "@font-face", "font-size-adjust", "font-stretch", "content", "counter-increment", "counter-reset", "quotes", "crop", "move-to", "page-policy", "grid-columns", "grid-rows", "target", "target-name", "target-new", "target-position", "alignment-adjust", "alignment-baseline", "baseline-shift", "dominant-baseline", "drop-initial-after-adjust", "drop-initial-after-align", "drop-initial-before-adjust", "drop-initial-before-align", "drop-initial-size", "drop-initial-value", "inline-box-align", "line-stacking", "line-stacking-ruby", "line-stacking-shift", "line-stacking-strategy", "text-height", "marquee-direction", "marquee-play-count", "marquee-speed", "marquee-style", "column-count", "column-fill", "column-gap", "column-rule", "column-rule-color", "column-rule-style", "column-rule-width", "column-span", "column-width", "columns", "fit", "fit-position", "image-orientation", "page", "size", "bottom", "clip", "cursor", "left", "overflow", "position", "right", "top", "visibility", "z-index", "orphans", "page-break-after", "page-break-before", "page-break-inside", "widows", "ruby-align", "ruby-overhang", "ruby-position", "ruby-span", "mark", "mark-after", "mark-before", "phonemes", "rest", "rest-after", "rest-before", "voice-balance", "voice-duration", "voice-pitch", "voice-pitch-range", "voice-rate", "voice-stress", "voice-volume", "border-collapse", "empty-cells", "table-layout", "direction", "unicode-bidi", "hanging-punctuation", "punctuation-trim", "text-align-last", "text-justify", "text-outline", "text-overflow", "text-shadow", "text-wrap", "word-break", "word-wrap", "transform", "transform-origin", "transform-style", "perspective", "perspective-origin", "backface-visibility", "transition", "transition-property", "transition-duration", "transition-timing-function", "transition-delay", "appearance", "box-sizing", "icon", "nav-down", "nav-index", "nav-left", "nav-right", "nav-up", "outline-offset", "resize"};
    String lastEncodedImage = null;
    public boolean writeStrictXHTMLAttributes = false;
    static boolean forceCSSOutput = false;
    boolean diabledLineBreaks = false;
    boolean ouputNewLine = true;
    boolean inTD = false;
    boolean disableInTable = false;
    static boolean disableAutomaticNBSP = false;
    boolean inPre = false;
    private char[] tempChars;
    private Segment segment;
    boolean replaceEntities = false;
    boolean newlineOutputed = false;
    boolean inTextArea = false;
    int preEndOffset;

    public FOXMLWriter(Writer w, HTMLDocument doc) {
        this(w, doc, 0, doc.getLength());
        this.translator.doc = doc;
    }

    public FOXMLWriter(Writer writer, HTMLDocument doc, int pos, int len) {
        super(writer, doc, pos, len);
        this.pos = pos;
        this.length = len;
        this.translator.doc = doc;
    }

    public boolean isReallyEmptyTag(Element elem) {
        try {
            AttributeSet attr = elem.getAttributes();
            String name = elem.getName();
            if (CustomXMLTagsGrammarSpecification.isTagRegistered(name) && CustomXMLTagsGrammarSpecification.isTagEmpty(name)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    protected void emptyTag(Element elem) throws BadLocationException, IOException {
        GenericTagAdapter adapter;
        if (elem.getName().equalsIgnoreCase("col")) {
            return;
        }
        AttributeSet attribs = elem.getAttributes();
        if (this.matchNameAttribute(attribs, HTML.Tag.TITLE)) {
            return;
        }
        String classAttrib = (String)elem.getAttributes().getAttribute(HTML.Attribute.CLASS);
        String valueAttrib = (String)elem.getAttributes().getAttribute(HTML.Attribute.VALUE);
        if (classAttrib != null && classAttrib.equals("custom_tag") && this.matchNameAttribute(attribs, HTML.Tag.INPUT) && (adapter = (GenericTagAdapter)attribs.getAttribute("custom_tag_adapter")) != null) {
            String adapter_type = (String)elem.getAttributes().getAttribute("adapter_type");
            if (adapter != null) {
                HTMLEditor.statementsDecoding.put(elem.getAttributes().getAttribute(HTML.Attribute.VALUE), adapter.getGeneratedOutput());
            }
            this.closeOutUnwantedEmbeddedTags(attribs);
            this.writeEmbeddedTags(attribs);
            this.write(adapter.getGeneratedOutput());
            return;
        }
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.SCRIPT) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.COMMENT) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.META)) {
            return;
        }
        AttributeSet attr = elem.getAttributes();
        if (!(attr.getAttribute(StyleConstants.NameAttribute) instanceof HTML.Tag)) {
            return;
        }
        HTML.Tag kind = (HTML.Tag)attr.getAttribute(StyleConstants.NameAttribute);
        if (kind instanceof HTML.UnknownTag && attr.getAttribute(HTML.Attribute.ENDTAG) == null && this.isReallyEmptyTag(elem)) {
            this.closeOutUnwantedEmbeddedTags(attr);
            this.writeEmbeddedTags(attr);
            this.write('<');
            this.write(elem.getName());
            this.writeAttributes(attr);
            this.write(' ');
            this.write('/');
            this.write('>');
        } else if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.BR)) {
            this.write("\n<fo:block>&#160;</fo:block>\n");
        } else if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.IMG) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.HR) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.LINK) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.META) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.INPUT) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.PARAM) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.BASE)) {
            if (!this.inPre) {
                this.indent();
                this.writeLineSeparator();
            }
            this.closeOutUnwantedEmbeddedTags(attr);
            this.writeEmbeddedTags(attr);
            this.write('<');
            this.write(elem.getName());
            if (!this.matchNameAttribute(elem.getAttributes(), HTML.Tag.BR)) {
                View view;
                if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.IMG) && this.currentEditor != null && (view = SferyxUtilities.getViewForElement(elem, this.currentEditor)) != null && view instanceof CustomImageView) {
                    this.lastEncodedImage = ((CustomImageView)view).getBase64EncodedImage();
                }
                this.writeAttributes(attr);
                this.lastEncodedImage = null;
            }
            this.write(' ');
            this.write('/');
            this.write('>');
        } else {
            if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.CONTENT)) {
                this.disableContentLines = true;
            }
            super.emptyTag(elem);
            if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.CONTENT)) {
                this.disableContentLines = false;
            }
        }
    }

    protected boolean synthesizedElement(Element elem) {
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.IMPLIED)) {
            return true;
        }
        return elem.getAttributes().getAttribute("fictional") != null;
    }

    public void writeEmbeddedTags(AttributeSet attr) throws IOException {
        try {
            this.translator.oConvAttr = new SimpleAttributeSet();
            attr = this.translator.convertToHTML40(attr, this.translator.oConvAttr);
            Vector<Object> orderedEmbeddedTags = new Vector<Object>();
            Enumeration<?> names_ = attr.getAttributeNames();
            Object lastObject = null;
            int lastIndex = -1;
            int lastOrderInt = -1;
            boolean font = false;
            while (names_.hasMoreElements()) {
                Object name = names_.nextElement();
                if (name instanceof HTML.Tag && name != HTML.Tag.IMPLIED && name != HTML.Tag.FONT) {
                    AttributeSet tagAtrribs = (AttributeSet)attr.getAttribute(name);
                    if (tagAtrribs == null) continue;
                    Integer order = (Integer)tagAtrribs.getAttribute(EditorHTMLDocument.sferyxInternalEmbeddedTagsCount);
                    orderedEmbeddedTags.addElement(name);
                    continue;
                }
                if (name != HTML.Tag.FONT || attr.getAttribute(name) == null || HTMLEditor.isForcedSpanGeneration()) continue;
                font = true;
            }
            if (font) {
                orderedEmbeddedTags.addElement(HTML.Tag.FONT);
            }
            for (int i = 0; i < orderedEmbeddedTags.size(); ++i) {
                HTML.Tag tag;
                Object tagAtrribs;
                Object name = orderedEmbeddedTags.elementAt(i);
                if (!(name instanceof HTML.Tag) || name == HTML.Tag.IMPLIED || (tagAtrribs = attr.getAttribute(tag = (HTML.Tag)name)) != null && tagAtrribs instanceof AttributeSet && ((AttributeSet)tagAtrribs).getAttribute("fictional") != null) continue;
                Object o = attr.getAttribute(tag);
                if (tag == HTML.Tag.FORM || this.tags.contains(tag) || tag == HTML.Tag.SUB || tag == HTML.Tag.SUP || tag == HTML.Tag.U || tag == HTML.Tag.I) continue;
                this.write('<');
                this.write("fo:inline");
                if (o != null && o instanceof AttributeSet && ((AttributeSet)o).getAttribute(HTML.Attribute.ENDTAG) == null) {
                    this.writeAttributes((AttributeSet)o);
                }
                this.write('>');
                this.tags.addElement(tag);
                this.tagValues.addElement(o);
                this.customTags.addElement(tag);
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    protected void closeOutUnwantedEmbeddedTags(AttributeSet attr) throws IOException {
        HTML.Tag t;
        this.tagsToRemove.removeAllElements();
        attr = this.translator.convertToHTML(attr, null);
        int firstIndex = -1;
        int size = this.tags.size();
        for (int i = size - 1; i >= 0; --i) {
            t = (HTML.Tag)this.tags.elementAt(i);
            Object tValue = this.tagValues.elementAt(i);
            if (attr != null && !this.noMatchForTagInAttributes(attr, t, tValue)) continue;
            firstIndex = i;
            this.tagsToRemove.addElement(t);
        }
        if (firstIndex != -1) {
            int i;
            boolean removeAll = size - firstIndex == this.tagsToRemove.size();
            for (i = size - 1; i >= firstIndex; --i) {
                t = (HTML.Tag)this.tags.elementAt(i);
                if (removeAll || this.tagsToRemove.contains(t)) {
                    this.tags.removeElementAt(i);
                    this.tagValues.removeElementAt(i);
                }
                this.write('<');
                this.write('/');
                this.write("fo:inline");
                this.write('>');
            }
            size = this.tags.size();
            for (i = firstIndex; i < size; ++i) {
                t = (HTML.Tag)this.tags.elementAt(i);
                this.write('<');
                this.write("fo:inline");
                Object o = this.tagValues.elementAt(i);
                if (o != null && o instanceof AttributeSet) {
                    this.writeAttributes((AttributeSet)o);
                }
                this.write('>');
            }
        }
    }

    public void writeEmbeddedTags_orign(AttributeSet attr) throws IOException {
        try {
            attr = this.translator.convertToHTML(attr, this.translator.oConvAttr);
            Vector<Object> orderedEmbeddedTags = new Vector<Object>();
            Enumeration<?> names_ = attr.getAttributeNames();
            Object lastObject = null;
            int lastIndex = -1;
            int lastOrderInt = -1;
            boolean font = false;
            while (names_.hasMoreElements()) {
                Object name = names_.nextElement();
                if (name instanceof HTML.Tag && name != HTML.Tag.IMPLIED && name != HTML.Tag.FONT) {
                    AttributeSet tagAtrribs = (AttributeSet)attr.getAttribute(name);
                    if (tagAtrribs == null) continue;
                    Integer order = (Integer)tagAtrribs.getAttribute(EditorHTMLDocument.sferyxInternalEmbeddedTagsCount);
                    orderedEmbeddedTags.addElement(name);
                    continue;
                }
                if (name != HTML.Tag.FONT || attr.getAttribute(name) == null || HTMLEditor.isForcedSpanGeneration()) continue;
                font = true;
            }
            if (font) {
                orderedEmbeddedTags.addElement(HTML.Tag.FONT);
            }
            for (int i = 0; i < orderedEmbeddedTags.size(); ++i) {
                HTML.Tag tag;
                Object tagAtrribs;
                Object name = orderedEmbeddedTags.elementAt(i);
                if (!(name instanceof HTML.Tag) || name == HTML.Tag.IMPLIED || (tagAtrribs = attr.getAttribute(tag = (HTML.Tag)name)) != null && tagAtrribs instanceof AttributeSet && ((AttributeSet)tagAtrribs).getAttribute("fictional") != null) continue;
                Object o = attr.getAttribute(tag);
                if (tag == HTML.Tag.FORM || this.tags.contains(tag)) continue;
                this.write('<');
                this.write(tag.toString());
                if (o != null && o instanceof AttributeSet && ((AttributeSet)o).getAttribute(HTML.Attribute.ENDTAG) == null) {
                    this.writeAttributes((AttributeSet)o);
                }
                this.write('>');
                this.tags.addElement(tag);
                this.tagValues.addElement(o);
                this.customTags.addElement(tag);
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    protected void closeCustomTags(AttributeSet attr) throws IOException {
        for (int i = this.customTags.size() - 1; i > -1; --i) {
            this.write('<');
            this.write('/');
            this.write(this.customTags.elementAt(i).toString());
            this.write('>');
        }
        this.customTags.removeAllElements();
    }

    public static boolean isAdditionStyleDefinition(Object key) {
        for (int i = 0; i < additionStlyeDeclarations.length; ++i) {
            if (key == null || !key.equals(additionStlyeDeclarations[i])) continue;
            return true;
        }
        return false;
    }

    public void writeAttributes(AttributeSet attr) throws IOException {
        if (attr.getAttribute(HTML.Attribute.ENDTAG) != null) {
            return;
        }
        AttributeSet convAttr = attr.copyAttributes();
        Enumeration<?> names = convAttr.getAttributeNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            if (name instanceof CSS.Attribute || name instanceof AlternativeCSSAttribute) {
                if (name instanceof HiddenValue || name instanceof CSS.Attribute && convAttr.getAttribute(AlternativeCSSAttribute.convertCSSAttribute((CSS.Attribute)name)) != null || name instanceof CSS.Attribute && convAttr.getAttribute(name.toString()) != null || name instanceof CSS.Attribute && name == CSS.Attribute.WIDTH && convAttr.getAttribute(HTML.Attribute.WIDTH) != null || name instanceof CSS.Attribute && name == CSS.Attribute.HEIGHT && convAttr.getAttribute(HTML.Attribute.HEIGHT) != null) continue;
                if (name == CSS.Attribute.VERTICAL_ALIGN) {
                    if (convAttr.getAttribute(name).toString().equalsIgnoreCase("sup")) {
                        this.write(" " + name + "=\"" + "super" + "\"");
                        continue;
                    }
                    this.write(" " + name + "=\"" + convAttr.getAttribute(name) + "\"");
                    continue;
                }
                if (name == CSS.Attribute.BACKGROUND) {
                    this.write(" background-color=\"" + convAttr.getAttribute(name) + "\"");
                    continue;
                }
                if (name == CSS.Attribute.LIST_STYLE_IMAGE) continue;
                this.write(" " + name + "=\"" + convAttr.getAttribute(name) + "\"");
                continue;
            }
            if (name instanceof HTML.Attribute && name != HTML.Attribute.STYLE) {
                if (name == HTML.Attribute.BGCOLOR) {
                    this.write(" background-color=\"" + convAttr.getAttribute(name) + "\"");
                    continue;
                }
                if (name == HTML.Attribute.WIDTH) {
                    if (!(convAttr.getAttribute(name).toString().endsWith("%") || convAttr.getAttribute(name).toString().endsWith("pt") || convAttr.getAttribute(name).toString().endsWith("px") || convAttr.getAttribute(name).toString().endsWith("em") || convAttr.getAttribute(name).toString().endsWith("cm") || convAttr.getAttribute(name).toString().endsWith("mm"))) {
                        this.write(" width=\"" + convAttr.getAttribute(name) + "px\"");
                        continue;
                    }
                    this.write(" width=\"" + convAttr.getAttribute(name) + "\"");
                    continue;
                }
                if (name == HTML.Attribute.HEIGHT) {
                    if (!(convAttr.getAttribute(name).toString().endsWith("%") || convAttr.getAttribute(name).toString().endsWith("pt") || convAttr.getAttribute(name).toString().endsWith("px") || convAttr.getAttribute(name).toString().endsWith("em") || convAttr.getAttribute(name).toString().endsWith("cm") || convAttr.getAttribute(name).toString().endsWith("mm"))) {
                        this.write(" height=\"" + convAttr.getAttribute(name) + "px\"");
                        continue;
                    }
                    this.write(" height=\"" + convAttr.getAttribute(name) + "\"");
                    continue;
                }
                if (name == HTML.Attribute.COLSPAN) {
                    this.write(" number-columns-spanned=\"" + convAttr.getAttribute(name) + "\"");
                    continue;
                }
                if (name == HTML.Attribute.ROWSPAN) {
                    this.write(" number-rows-spanned=\"" + convAttr.getAttribute(name) + "\"");
                    continue;
                }
                if (name == HTML.Attribute.ALIGN) {
                    this.write(" text-align=\"" + convAttr.getAttribute(name) + "\"");
                    continue;
                }
                if (name != HTML.Attribute.VALIGN) continue;
                String attrValue = convAttr.getAttribute(name).toString();
                if (attrValue.equalsIgnoreCase("top")) {
                    this.write(" display-align=\"before\"");
                    continue;
                }
                if (attrValue.equalsIgnoreCase("bottom")) {
                    this.write(" display-align=\"after\"");
                    continue;
                }
                if (attrValue.equalsIgnoreCase("middle")) {
                    this.write(" display-align=\"center\"");
                    continue;
                }
                this.write(" display-align=\"before\"");
                continue;
            }
            if (name != HTML.Attribute.STYLE) continue;
            AttributeSet styleAttr = ((HTMLDocument)this.getDocument()).getStyleSheet().getDeclaration(convAttr.getAttribute(name).toString());
            this.writeAttributes(styleAttr);
        }
    }

    public void writeAttributes_orig_orig(AttributeSet attr) throws IOException {
        if (attr.getAttribute(HTML.Attribute.ENDTAG) != null) {
            return;
        }
        AttributeSet convAttr = attr.copyAttributes();
        convAttr = this.translator.convertToHTML(convAttr, null);
        SimpleAttributeSet sas = new SimpleAttributeSet(convAttr);
        if (HTMLEditor.isForcedCSSGeneration()) {
            Enumeration<?> names = convAttr.getAttributeNames();
            while (names.hasMoreElements()) {
                Object name = names.nextElement();
                if (name instanceof HTML.Tag || name instanceof StyleConstants || name == HTML.Attribute.ENDTAG || name == EditorHTMLDocument.sferyxInternalEmbeddedTagsCount || name == EditorHTMLDocument.realClassName || name == EditorHTMLDocument.realIDName) continue;
                if (name == HTML.Attribute.CLASS && convAttr.getAttribute(EditorHTMLDocument.realClassName) != null && convAttr.isDefined(EditorHTMLDocument.realClassName)) {
                    this.write(" " + name + "=\"" + convAttr.getAttribute(EditorHTMLDocument.realClassName) + "\"");
                    continue;
                }
                if (name == HTML.Attribute.ID && convAttr.getAttribute(EditorHTMLDocument.realIDName) != null && convAttr.isDefined(EditorHTMLDocument.realIDName)) {
                    this.write(" " + name + "=\"" + convAttr.getAttribute(EditorHTMLDocument.realIDName) + "\"");
                    continue;
                }
                if (this.matchNameAttribute(attr, HTML.Tag.INPUT) && name == HTML.Attribute.VALUE && convAttr.getAttribute(name) != null) {
                    String value = sas.getAttribute(name).toString();
                    value = SferyxUtilities.replaceAll(value, "&", "&amp;");
                    value = SferyxUtilities.replaceAll(value, "\"", "&quot;");
                    this.write(" " + name + "=\"" + value + "\"");
                    continue;
                }
                if (name instanceof CSS.Attribute || FOXMLWriter.isAdditionStyleDefinition(name)) continue;
                this.write(" " + name + "=\"" + convAttr.getAttribute(name) + "\"");
            }
        } else {
            if (this.matchNameAttribute(attr, HTML.Tag.INPUT) && sas.getAttribute(HTML.Attribute.VALUE) != null) {
                String value = sas.getAttribute(HTML.Attribute.VALUE).toString();
                value = SferyxUtilities.replaceAll(value, "\"", "&quot;");
                sas.addAttribute(HTML.Attribute.VALUE, value);
            }
            sas.removeAttribute(EditorHTMLDocument.sferyxInternalEmbeddedTagsCount);
            sas.removeAttribute(EditorHTMLDocument.realClassName);
            sas.removeAttribute(EditorHTMLDocument.realIDName);
            super.writeAttributes(sas);
        }
    }

    public void writeAttributes1(AttributeSet attr) throws IOException {
        if (attr.getAttribute(HTML.Attribute.ENDTAG) != null) {
            return;
        }
        AttributeSet convAttr = attr.copyAttributes();
        SimpleAttributeSet sas = new SimpleAttributeSet(convAttr);
        if (HTMLEditor.isForcedCSSGeneration()) {
            convAttr = new SimpleAttributeSet();
            FOXMLWriter.convertToHTML40(attr, (MutableAttributeSet)convAttr);
            Enumeration<?> names = convAttr.getAttributeNames();
            while (names.hasMoreElements()) {
                Object name = names.nextElement();
                if (name instanceof HTML.Tag || name instanceof StyleConstants || name == HTML.Attribute.ENDTAG || name == EditorHTMLDocument.sferyxInternalEmbeddedTagsCount || name == EditorHTMLDocument.realClassName || name == EditorHTMLDocument.realIDName) continue;
                if (name == HTML.Attribute.CLASS && convAttr.getAttribute(EditorHTMLDocument.realClassName) != null && convAttr.isDefined(EditorHTMLDocument.realClassName)) {
                    this.write(" " + name + "=\"" + convAttr.getAttribute(EditorHTMLDocument.realClassName) + "\"");
                    continue;
                }
                if (name == HTML.Attribute.ID && convAttr.getAttribute(EditorHTMLDocument.realIDName) != null && convAttr.isDefined(EditorHTMLDocument.realIDName)) {
                    this.write(" " + name + "=\"" + convAttr.getAttribute(EditorHTMLDocument.realIDName) + "\"");
                    continue;
                }
                this.write(" " + name + "=\"" + convAttr.getAttribute(name) + "\"");
            }
        } else {
            sas.removeAttribute(EditorHTMLDocument.sferyxInternalEmbeddedTagsCount);
            sas.removeAttribute(EditorHTMLDocument.realClassName);
            sas.removeAttribute(EditorHTMLDocument.realIDName);
            super.writeAttributes(sas);
        }
    }

    public void writeAttributes_orig(AttributeSet attr) throws IOException {
        if (attr.getAttribute(HTML.Attribute.ENDTAG) != null) {
            return;
        }
        AttributeSet convAttr = attr.copyAttributes();
        SimpleAttributeSet sas = new SimpleAttributeSet(convAttr);
        if (HTMLEditor.isForcedCSSGeneration()) {
            convAttr = new SimpleAttributeSet();
            FOXMLWriter.convertToHTML40(attr, (MutableAttributeSet)convAttr);
            Enumeration<?> names = convAttr.getAttributeNames();
            while (names.hasMoreElements()) {
                Object name = names.nextElement();
                if (name instanceof HTML.Tag || name instanceof StyleConstants || name == HTML.Attribute.ENDTAG || name == EditorHTMLDocument.sferyxInternalEmbeddedTagsCount || name == EditorHTMLDocument.realClassName || name == EditorHTMLDocument.realIDName) continue;
                if (name == HTML.Attribute.CLASS && convAttr.getAttribute(EditorHTMLDocument.realClassName) != null && convAttr.isDefined(EditorHTMLDocument.realClassName)) {
                    this.write(" " + name + "=\"" + convAttr.getAttribute(EditorHTMLDocument.realClassName) + "\"");
                    continue;
                }
                if (name == HTML.Attribute.ID && convAttr.getAttribute(EditorHTMLDocument.realIDName) != null && convAttr.isDefined(EditorHTMLDocument.realIDName)) {
                    this.write(" " + name + "=\"" + convAttr.getAttribute(EditorHTMLDocument.realIDName) + "\"");
                    continue;
                }
                if (this.matchNameAttribute(attr, HTML.Tag.INPUT) && name == HTML.Attribute.VALUE && convAttr.getAttribute(name) != null) {
                    String value = sas.getAttribute(name).toString();
                    value = SferyxUtilities.replaceAll(value, "&", "&amp;");
                    value = SferyxUtilities.replaceAll(value, "\"", "&quot;");
                    this.write(" " + name + "=\"" + value + "\"");
                    continue;
                }
                this.write(" " + name + "=\"" + convAttr.getAttribute(name) + "\"");
            }
        } else {
            if (this.matchNameAttribute(attr, HTML.Tag.INPUT) && sas.getAttribute(HTML.Attribute.VALUE) != null) {
                String value = sas.getAttribute(HTML.Attribute.VALUE).toString();
                value = SferyxUtilities.replaceAll(value, "\"", "&quot;");
                sas.addAttribute(HTML.Attribute.VALUE, value);
            }
            sas.removeAttribute(EditorHTMLDocument.sferyxInternalEmbeddedTagsCount);
            sas.removeAttribute(EditorHTMLDocument.realClassName);
            sas.removeAttribute(EditorHTMLDocument.realIDName);
            super.writeAttributes(sas);
        }
    }

    private static void convertToHTML40(AttributeSet from, MutableAttributeSet to) {
        Object key;
        Enumeration<?> keys = from.getAttributeNames();
        String value = "";
        while (keys.hasMoreElements()) {
            key = keys.nextElement();
            if (key != CSS.Attribute.BORDER && key != CSS.Attribute.PADDING && key != CSS.Attribute.MARGIN || from.getAttribute(key) == null || from.getAttribute(key).toString() == null) continue;
            value = value + key + ":" + from.getAttribute(key) + ";";
        }
        keys = from.getAttributeNames();
        while (keys.hasMoreElements()) {
            key = keys.nextElement();
            if (key == CSS.Attribute.BORDER || key == CSS.Attribute.PADDING || key == CSS.Attribute.MARGIN || key instanceof HiddenValue || key instanceof String && ((String)key).endsWith("-important")) continue;
            if (key instanceof CSS.Attribute || key instanceof AlternativeCSSAttribute || SferyxUtilities.isAdditionStyleDefinition(key)) {
                if (key == CSS.Attribute.TEXT_ALIGN && from.isDefined(HTML.Attribute.ALIGN) && !forceCSSOutput || from.getAttribute(key) == null || from.getAttribute(key).toString() == null) continue;
                if (from.getAttribute(HTML.Tag.SPAN) != null) {
                    AttributeSet as = (AttributeSet)from.getAttribute(HTML.Tag.SPAN);
                    if (as.getAttribute(key) != null && as.getAttribute(key).equals(from.getAttribute(key))) continue;
                    value = value + key + ":" + from.getAttribute(key) + ";";
                    continue;
                }
                value = value + key + ":" + from.getAttribute(key) + ";";
                continue;
            }
            if (forceCSSOutput) {
                if (key instanceof HTML.Attribute) {
                    if (key == HTML.Attribute.BORDER) {
                        to.addAttribute(key, from.getAttribute(key));
                    } else if (key == HTML.Attribute.WIDTH) {
                        if (from.getAttribute(CSS.Attribute.WIDTH) == null) {
                            value = value + "width:" + from.getAttribute(key) + ";";
                        }
                    } else if (key == HTML.Attribute.HEIGHT) {
                        value = value + "height:" + from.getAttribute(key) + ";";
                    } else if (key == HTML.Attribute.BGCOLOR) {
                        value = value + "background-color:" + from.getAttribute(key) + ";";
                    } else if (key == HTML.Attribute.BACKGROUND) {
                        value = value + "background-image:" + from.getAttribute(key) + ";";
                    } else if (key == HTML.Attribute.ALIGN && !SferyxUtilities.matchNameAttribute(from, HTML.Tag.TABLE) && !from.isDefined(CSS.Attribute.TEXT_ALIGN)) {
                        value = value + "text-align:" + from.getAttribute(key) + ";";
                    }
                    to.addAttribute(key, from.getAttribute(key));
                    continue;
                }
                if (key instanceof String && (key.toString().equalsIgnoreCase("width") || key.toString().equalsIgnoreCase("height")) || FOXMLWriter.isAdditionStyleDefinition(key)) continue;
                to.addAttribute(key, from.getAttribute(key));
                continue;
            }
            if (key instanceof String && (key.toString().equalsIgnoreCase("width") || key.toString().equalsIgnoreCase("height")) || FOXMLWriter.isAdditionStyleDefinition(key)) continue;
            to.addAttribute(key, from.getAttribute(key));
        }
        if (value.length() > 0) {
            to.addAttribute(HTML.Attribute.STYLE, value);
        }
    }

    private void convertToExtendedAttributesMode(AttributeSet from, MutableAttributeSet to) {
        Enumeration<?> keys = from.getAttributeNames();
        String value = "";
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (key instanceof CSS.Attribute) {
                value = value + " " + key + ":" + from.getAttribute(key) + ";";
                continue;
            }
            Object i_value = from.getAttribute(key);
            if (key == HTML.Attribute.SIZE) {
                to.removeAttribute(CSS.Attribute.FONT_SIZE);
                value = value + " font-size:" + ((HTMLDocument)this.getDocument()).getStyleSheet().getPointSize("" + i_value) + "pt" + ";";
                continue;
            }
            if (key == HTML.Attribute.FACE) {
                to.removeAttribute(CSS.Attribute.FONT_FAMILY);
                value = value + " font-family:" + i_value + ";";
                continue;
            }
            if (key == HTML.Attribute.COLOR) {
                to.removeAttribute(CSS.Attribute.COLOR);
                value = value + " color:" + i_value + ";";
                continue;
            }
            if (key == HTML.Attribute.BORDER) {
                to.removeAttribute("cellborder");
                to.addAttribute("cellborder", i_value);
                to.addAttribute(key, i_value);
                continue;
            }
            if (key == HTML.Attribute.CELLSPACING) {
                to.removeAttribute("cellmargin");
                to.addAttribute("cellmargin", i_value);
                to.addAttribute(key, i_value);
                continue;
            }
            if (key.equals("font-size") || key.equals("font-family") || key.equals("cellmargin") || key.equals("cellborder")) continue;
            to.addAttribute(key, i_value);
        }
        if (value.length() > 0) {
            to.addAttribute(HTML.Attribute.STYLE, value);
        }
    }

    public void disableIndentingAndLineBreaks(boolean disable) {
        this.diabledLineBreaks = disable;
    }

    public boolean isDisableIndentingAndLineBreaks() {
        return HTMLEditor.disableIndentingAndLineBreaks;
    }

    protected boolean getCanWrapLines() {
        if (this.isDisableIndentingAndLineBreaks()) {
            return false;
        }
        return super.getCanWrapLines();
    }

    protected void writeLineSeparator() throws IOException {
        if (this.disableInTable) {
            return;
        }
        if (!this.inPre && this.disableContentLines) {
            return;
        }
        try {
            if (!this.isDisableIndentingAndLineBreaks()) {
                super.writeLineSeparator();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void indent() throws IOException {
        if (this.disableInTable) {
            return;
        }
        if (this.disableContentLines) {
            return;
        }
        try {
            if (!this.isDisableIndentingAndLineBreaks()) {
                super.indent();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void startTag(Element elem) throws IOException, BadLocationException {
        if (this.disableInTable && !this.matchNameAttribute(elem.getAttributes(), HTML.Tag.IMPLIED)) {
            this.disableInTable = false;
        }
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.TEXTAREA)) {
            String extraChar = "";
            if (!this.isDisableIndentingAndLineBreaks()) {
                extraChar = "\n";
            }
            this.write(extraChar + "<textarea ");
            this.writeAttributes(elem.getAttributes());
            this.write(">" + extraChar);
            Document formFieldValue = (Document)elem.getAttributes().getAttribute(StyleConstants.ModelAttribute);
            if (formFieldValue != null) {
                this.write(formFieldValue.getText(0, formFieldValue.getLength()));
            }
            return;
        }
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.PRE)) {
            this.inPre = true;
        }
        this.closeOutUnwantedEmbeddedTags(elem.getAttributes());
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.BODY)) {
            this.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.write("\n<fo:root xmlns:fo=\"http://www.w3.org/1999/XSL/Format\">");
            this.write("\n<fo:layout-master-set>");
            this.write("\n<fo:simple-page-master master-name=\"A4\">");
            this.write("\n<fo:region-body />");
            this.write("\n</fo:simple-page-master>");
            this.write("\n</fo:layout-master-set>");
            this.write("\n<fo:page-sequence master-reference=\"A4\">");
            this.write("\n<fo:flow flow-name=\"xsl-region-body\">");
            this.write("\n<fo:block>\n");
            return;
        }
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.TABLE)) {
            this.disableIndentingAndLineBreaks(false);
            AttributeSet attr = elem.getAttributes();
            this.write("<fo:table ");
            this.writeAttributes(attr);
            this.write(">\n");
            this.write("<fo:table-body>\n");
            return;
        }
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.TD) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.TH)) {
            AttributeSet attr = elem.getAttributes();
            this.write("\n<fo:table-cell padding-start=\"3pt\" padding-end=\"3pt\" padding-before=\"3pt\" padding-after=\"3pt\" ");
            this.writeAttributes(attr);
            this.write(">\n");
            this.write("<fo:block>\n");
            return;
        }
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.TR)) {
            AttributeSet attr = elem.getAttributes();
            this.write('<');
            this.write("fo:table-row");
            this.writeAttributes(attr);
            this.write(">\n");
            return;
        }
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.P) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.DIV) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.H1) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.H2) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.H3) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.H4) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.H5) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.H6) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.CENTER)) {
            View view = SferyxUtilities.getViewForElement(elem, this.currentEditor);
            AttributeSet attr = null;
            attr = view != null ? view.getAttributes() : elem.getAttributes();
            this.write('<');
            this.write("fo:block");
            this.writeAttributes(attr);
            this.write('>');
            return;
        }
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.UL) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.OL)) {
            AttributeSet attr = elem.getAttributes();
            this.write('<');
            this.write("fo:list-block provisional-distance-between-starts=\"0.2cm\" provisional-label-separation=\"0.5cm\" space-after=\"12pt\" start-indent=\"1cm\"");
            this.writeAttributes(attr);
            this.write(">\n");
            return;
        }
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.LI)) {
            AttributeSet attr = elem.getAttributes();
            this.write('<');
            this.write("fo:list-item");
            this.writeAttributes(attr);
            this.write(">\n");
            this.write("<fo:list-item-label end-indent=\"label-end()\">\n");
            this.write("<fo:block>\u00e2\u20ac\u00a2</fo:block>\n");
            this.write("</fo:list-item-label>\n");
            this.write("<fo:list-item-body start-indent=\"body-start()\">\n");
            this.write("<fo:block>\n");
            return;
        }
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.BODY)) {
            Object maps = ((EditorHTMLDocument)this.getDocument()).getProperty("__MAP__");
            ((EditorHTMLDocument)this.getDocument()).putProperty("__MAP__", null);
            super.startTag(elem);
            this.writeImageMaps();
            ((EditorHTMLDocument)this.getDocument()).putProperty("__MAP__", maps);
        } else {
            if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.HEAD) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.HTML)) {
                return;
            }
            super.startTag(elem);
        }
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.BODY)) {
            // empty if block
        }
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.P) && elem.getEndOffset() - elem.getStartOffset() <= 1 && !disableAutomaticNBSP) {
            this.write("&#160;");
        }
    }

    public void writeImageMaps() {
        Hashtable maps = ((EditorHTMLDocument)this.getDocument()).allMaps;
        Enumeration mapsEnum = maps.keys();
        while (mapsEnum.hasMoreElements()) {
            EditorHTMLDocument.CustomMap currentMap = (EditorHTMLDocument.CustomMap)maps.get(mapsEnum.nextElement());
            try {
                this.write(currentMap.toString());
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    protected void endTag(Element elem) throws IOException {
        if (this.dontGenerateAnythingAfterEndPosition && elem.getEndOffset() >= this.pos + this.length) {
            return;
        }
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.TEXTAREA)) {
            String extraChar = "";
            if (!this.isDisableIndentingAndLineBreaks()) {
                extraChar = "\n";
            }
            this.write(extraChar + "</textarea>" + extraChar);
            return;
        }
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.PRE)) {
            this.closeOutUnwantedEmbeddedTags(elem.getAttributes());
            super.endTag(elem);
            this.inPre = false;
            return;
        }
        this.closeOutUnwantedEmbeddedTags(elem.getAttributes());
        if (!this.matchNameAttribute(elem.getAttributes(), HTML.Tag.TR) && !this.matchNameAttribute(elem.getAttributes(), HTML.Tag.TABLE) || !this.inPre) {
            // empty if block
        }
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.BODY)) {
            this.write("</fo:block>");
            this.write("\n</fo:flow>");
            this.write("\n</fo:page-sequence>");
            this.write("\n</fo:root>");
            return;
        }
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.HEAD) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.HTML)) {
            return;
        }
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.P) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.LI)) {
            this.writeLineSeparator();
        }
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.P) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.DIV) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.H1) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.H2) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.H3) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.H4) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.H5) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.H6) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.CENTER)) {
            this.write("</fo:block>");
            this.disableIndentingAndLineBreaks(false);
            if (!this.inPre) {
                this.writeLineSeparator();
            }
            return;
        }
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.LI)) {
            this.write("</fo:block>");
            this.write("\n</fo:list-item-body>");
            this.write("\n</fo:list-item>");
            return;
        }
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.UL) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.OL)) {
            this.write("\n</fo:list-block>");
            return;
        }
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.TABLE)) {
            this.write("</fo:table-body>");
            this.write("\n</fo:table>");
            return;
        }
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.TR)) {
            this.write("</fo:table-row>");
            return;
        }
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.TD) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.TH)) {
            this.write("\n</fo:block>");
            this.write("\n</fo:table-cell>");
            return;
        }
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.BODY)) {
            this.write("</body>");
            this.writeLineSeparator();
        } else if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.HTML)) {
            this.write("</html>");
        } else {
            super.endTag(elem);
        }
        if ((this.matchNameAttribute(elem.getAttributes(), HTML.Tag.TR) || this.matchNameAttribute(elem.getAttributes(), HTML.Tag.TABLE)) && !this.inPre) {
            this.disableIndentingAndLineBreaks(false);
        }
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.TD) && !this.inPre) {
            this.disableIndentingAndLineBreaks(false);
            if (this.disableInTable) {
                this.disableInTable = false;
            }
            this.writeLineSeparator();
        }
        if (!this.inPre) {
            // empty if block
        }
    }

    public void write(String str) throws IOException {
        if (HTMLEditor.isForcedSpanGeneration()) {
            if (str.endsWith("=\"#DEFAULT\"")) {
                str = str.substring(0, str.indexOf("=\"#DEFAULT\""));
            }
            super.write(str);
        } else {
            if (str.startsWith(" href=\"") && this.writeStrictXHTMLAttributes) {
                str = SferyxUtilities.replaceAllIfNotFollows(str, "&", "&amp;", "amp;");
            }
            if (str.endsWith("=\"#DEFAULT\"")) {
                str = str.substring(0, str.indexOf("=\"#DEFAULT\""));
            }
            super.write(str);
        }
    }

    protected void writeOption(Option option) throws IOException {
        this.indent();
        this.write('<');
        this.write("option");
        Object value = option.getAttributes().getAttribute(HTML.Attribute.VALUE);
        if (value != null) {
            this.write(" value=\"" + value + "\"");
        }
        if (option.isSelected() && (option.getAttributes().getAttribute(HTML.Attribute.SELECTED) == null || !option.getAttributes().getAttribute(HTML.Attribute.SELECTED).equals(Boolean.FALSE)) || option.getAttributes().getAttribute(HTML.Attribute.SELECTED) != null && option.getAttributes().getAttribute(HTML.Attribute.SELECTED).equals(Boolean.TRUE)) {
            this.write(" selected=\"selected\"");
        }
        this.write('>');
        if (option.getLabel() != null) {
            this.write(option.getLabel());
        }
        this.write("</option>");
        this.writeLineSeparator();
    }

    private boolean noMatchForTagInAttributes(AttributeSet attr, HTML.Tag t, Object tagValue) {
        if (attr.getAttribute("CR") == Boolean.TRUE && this.inPre) {
            return false;
        }
        if (attr.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.IMPLIED && this.inPre) {
            return false;
        }
        if (attr != null && attr.isDefined(t)) {
            Object newValue = attr.getAttribute(t);
            if (tagValue == null ? newValue == null : newValue != null && tagValue.equals(newValue)) {
                return false;
            }
        }
        return true;
    }

    public void writeElementContent(Element toWrite) throws IOException, BadLocationException {
        this.setCanWrapLines(false);
        if (((AbstractDocument.AbstractElement)toWrite).isLeaf()) {
            this.emptyTag(toWrite);
        } else {
            int n = ((AbstractDocument.AbstractElement)toWrite).getElementCount();
            for (int i = 0; i < n; ++i) {
                AbstractDocument.AbstractElement e = (AbstractDocument.AbstractElement)((AbstractDocument.AbstractElement)toWrite).getElement(i);
                this.write(e);
            }
        }
    }

    public void writeElementContent_old(Element toWrite) throws IOException, BadLocationException {
        this.setCanWrapLines(false);
        if (((AbstractDocument.AbstractElement)toWrite).isLeaf()) {
            this.emptyTag(toWrite);
        } else {
            int startOffset = toWrite.getStartOffset();
            int endOffset = toWrite.getEndOffset();
            if (startOffset >= this.pos && endOffset <= this.pos + this.length) {
                this.startTag(toWrite);
            }
            int n = ((AbstractDocument.AbstractElement)toWrite).getElementCount();
            for (int i = 0; i < n; ++i) {
                AbstractDocument.AbstractElement e = (AbstractDocument.AbstractElement)((AbstractDocument.AbstractElement)toWrite).getElement(i);
                int startOffset_ = e.getStartOffset();
                int endOffset_ = e.getEndOffset();
                if (endOffset_ > this.pos + this.length || startOffset_ < this.pos) continue;
                this.write(e);
            }
            if (endOffset <= this.pos + this.length && startOffset >= this.pos) {
                this.endTag(toWrite);
            }
        }
    }

    protected void comment(Element elem) throws BadLocationException, IOException {
        AttributeSet as = elem.getAttributes();
        if (this.matchNameAttribute(as, HTML.Tag.COMMENT)) {
            Object comment = as.getAttribute(HTML.Attribute.COMMENT);
            if (comment instanceof String) {
                this.writeComment((String)comment);
            } else {
                this.writeComment(null);
            }
        }
    }

    void writeComment(String string) throws IOException {
        if (string != null) {
            this.getWriter().write(string.toCharArray(), 0, string.toCharArray().length);
            this.setCurrentLineLength(this.getCurrentLineLength() + string.toCharArray().length);
        }
    }

    public void write(Element toWrite) throws IOException, BadLocationException {
        this.setCanWrapLines(false);
        if (this.matchNameAttribute(toWrite.getAttributes(), HTML.Tag.TEXTAREA)) {
            this.startTag(toWrite);
            this.endTag(toWrite);
        } else if (this.matchNameAttribute(toWrite.getAttributes(), HTML.Tag.SELECT)) {
            this.startTag(toWrite);
            this.endTag(toWrite);
        } else if (((AbstractDocument.AbstractElement)toWrite).isLeaf()) {
            int startOffset = toWrite.getStartOffset();
            int endOffset = toWrite.getEndOffset();
            if (startOffset >= this.pos && startOffset <= this.pos + this.length || endOffset >= this.pos && endOffset <= this.pos + this.length) {
                this.emptyTag(toWrite);
            }
        } else {
            int startOffset = toWrite.getStartOffset();
            int endOffset = toWrite.getEndOffset();
            if (startOffset >= this.pos && startOffset <= this.pos + this.length || endOffset >= this.pos && endOffset <= this.pos + this.length) {
                this.startTag(toWrite);
            }
            int n = ((AbstractDocument.AbstractElement)toWrite).getElementCount();
            for (int i = 0; i < n; ++i) {
                AbstractDocument.AbstractElement e = (AbstractDocument.AbstractElement)((AbstractDocument.AbstractElement)toWrite).getElement(i);
                this.write(e);
            }
            if (startOffset >= this.pos && startOffset <= this.pos + this.length || endOffset >= this.pos && endOffset <= this.pos + this.length) {
                this.endTag(toWrite);
            }
        }
    }

    private int indexOf(char[] chars, char sChar, int startIndex, int endIndex) {
        while (startIndex < endIndex) {
            if (chars[startIndex] == sChar) {
                return startIndex;
            }
            ++startIndex;
        }
        return -1;
    }

    protected void write(char[] chars, int startIndex, int length) throws IOException {
        if (!this.getCanWrapLines()) {
            super.write(chars, startIndex, length);
        } else {
            int lastIndex = startIndex;
            int endIndex = startIndex + length;
            int lineLength = this.getCurrentLineLength();
            int maxLength = this.getLineLength();
            while (lastIndex < endIndex) {
                int newlineIndex = this.indexOf(chars, '\n', lastIndex, endIndex);
                boolean needsNewline = false;
                boolean forceNewLine = false;
                lineLength = this.getCurrentLineLength();
                if (newlineIndex != -1 && lineLength + (newlineIndex - lastIndex) < maxLength) {
                    if (newlineIndex > lastIndex) {
                        this.output(chars, lastIndex, newlineIndex - lastIndex);
                    }
                    lastIndex = newlineIndex + 1;
                    forceNewLine = true;
                } else if (newlineIndex == -1 && lineLength + (endIndex - lastIndex) < maxLength) {
                    if (endIndex > lastIndex) {
                        this.output(chars, lastIndex, endIndex - lastIndex);
                    }
                    lastIndex = endIndex;
                } else {
                    int counter;
                    int breakPoint = -1;
                    int maxBreak = Math.min(endIndex - lastIndex, maxLength - lineLength - 1);
                    for (counter = 0; counter < maxBreak; ++counter) {
                        if (!Character.isWhitespace(chars[counter + lastIndex])) continue;
                        breakPoint = counter;
                    }
                    if (breakPoint != -1) {
                        this.output(chars, lastIndex, (breakPoint += lastIndex + 1) - lastIndex);
                        lastIndex = breakPoint;
                        needsNewline = true;
                    } else {
                        counter = Math.max(0, maxBreak);
                        maxBreak = endIndex - lastIndex;
                        while (counter < maxBreak) {
                            if (Character.isWhitespace(chars[counter + lastIndex])) {
                                breakPoint = counter;
                                break;
                            }
                            ++counter;
                        }
                        if (breakPoint == -1) {
                            this.output(chars, lastIndex, endIndex - lastIndex);
                            breakPoint = endIndex;
                        } else if (chars[breakPoint += lastIndex] == '\n') {
                            this.output(chars, lastIndex, breakPoint++ - lastIndex);
                            forceNewLine = true;
                        } else {
                            this.output(chars, lastIndex, ++breakPoint - lastIndex);
                            needsNewline = true;
                        }
                        lastIndex = breakPoint;
                    }
                }
                if (!forceNewLine && !needsNewline && lastIndex >= endIndex) continue;
                this.writeLineSeparator();
                if (lastIndex >= endIndex && forceNewLine) continue;
                this.indent();
            }
        }
    }

    protected boolean inRange(Element next) {
        if (next.getEndOffset() == this.getEndOffset() + 1 && next.getEndOffset() == next.getStartOffset() + 1 && disableAutomaticNBSP) {
            return true;
        }
        if (next.getEndOffset() == this.getEndOffset() + 1 && next.getEndOffset() == next.getStartOffset() + 1) {
            return true;
        }
        return super.inRange(next);
    }

    protected void output(char[] chars, int start, int length) throws IOException {
        if (!this.replaceEntities) {
            super.output(chars, start, length);
            return;
        }
        int last = start;
        length += start;
        block3: for (int counter = start; counter < length; ++counter) {
            switch (chars[counter]) {
                case '\t': 
                case '\n': 
                case '\r': {
                    continue block3;
                }
                default: {
                    if (chars[counter] >= ' ' && chars[counter] <= '\u007f') continue block3;
                    if (counter > last) {
                        super.output(chars, last, counter - last);
                    }
                    last = counter + 1;
                    this.output("&#");
                    this.output(String.valueOf((int)chars[counter]));
                    this.output(";");
                }
            }
        }
        if (last < length) {
            super.output(chars, last, length - last);
        }
    }

    void output(String string) throws IOException {
        int length = string.length();
        if (this.tempChars == null || this.tempChars.length < length) {
            this.tempChars = new char[length];
        }
        string.getChars(0, length, this.tempChars, 0);
        super.output(this.tempChars, 0, length);
    }

    protected void textAreaContent(AttributeSet attr) throws BadLocationException, IOException {
        Document doc = (Document)attr.getAttribute(StyleConstants.ModelAttribute);
        if (doc != null && doc.getLength() > 0) {
            if (this.segment == null) {
                this.segment = new Segment();
            }
            doc.getText(0, doc.getLength(), this.segment);
            if (this.segment.count > 0) {
                this.inTextArea = true;
                this.incrIndent();
                this.indent();
                this.setCanWrapLines(true);
                this.replaceEntities = true;
                this.write(this.segment.array, this.segment.offset, this.segment.count);
                this.replaceEntities = false;
                this.setCanWrapLines(false);
                this.writeLineSeparator();
                this.inTextArea = false;
                this.decrIndent();
            }
        }
    }

    protected void text(Element elem) throws BadLocationException, IOException {
        int end;
        int start = Math.max(this.getStartOffset(), elem.getStartOffset());
        if (start < (end = Math.min(this.getEndOffset(), elem.getEndOffset()))) {
            if (this.segment == null) {
                this.segment = new Segment();
            }
            this.getDocument().getText(start, end - start, this.segment);
            this.newlineOutputed = false;
            if (this.segment.count > 0) {
                if (this.segment.array[this.segment.offset + this.segment.count - 1] == '\n') {
                    this.newlineOutputed = true;
                }
                if (this.inPre && end == this.preEndOffset) {
                    if (this.segment.count > 1) {
                        --this.segment.count;
                    } else {
                        return;
                    }
                }
                this.replaceEntities = true;
                this.setCanWrapLines(!this.inPre);
                this.write(this.segment.array, this.segment.offset, this.segment.count);
                this.setCanWrapLines(false);
                this.replaceEntities = false;
            }
        }
    }
}

