/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Color;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.CSS;
import javax.swing.text.html.StyleSheet;
import sferyx.administration.editors.AlternativeCSSAttribute;
import sferyx.administration.editors.HTMLEditor;
import sferyx.administration.editors.HiddenValue;
import sferyx.administration.editors.SferyxUtilities;

class ExternalCustomStyleSheet
extends StyleSheet {
    URL currentImportURL = null;
    static int[] sizeMap_ = new int[]{8, 10, 12, 14, 18, 24, 36};

    ExternalCustomStyleSheet() {
    }

    String colorToString(Color color) {
        String colorString = Integer.toHexString(color.getRGB());
        if (colorString.length() == 8) {
            colorString = colorString.substring(2);
        }
        return "#" + colorString;
    }

    public void addCSSAttribute(MutableAttributeSet attr, CSS.Attribute key, String value) {
        float number;
        float number2;
        if (HTMLEditor.jvm_version.startsWith("1.7") && key != null && key.toString().toLowerCase().startsWith("border")) {
            attr.addAttribute(key, value);
            return;
        }
        if ((key == CSS.Attribute.FONT || key == CSS.Attribute.FONT_SIZE || key == CSS.Attribute.FONT_FAMILY) && value.indexOf("inherit") != -1) {
            return;
        }
        if (key == CSS.Attribute.TEXT_ALIGN && value != null && value.equalsIgnoreCase("general")) {
            return;
        }
        if (key == CSS.Attribute.PADDING_RIGHT) {
            attr.addAttribute(AlternativeCSSAttribute.PADDING_RIGHT, value);
            attr.addAttribute(HiddenValue.PADDING_RIGHT, value);
            if (value.indexOf("!important") != -1) {
                attr.addAttribute("padding_right-important", SferyxUtilities.replaceAll(value, "!important", ""));
            }
            return;
        }
        if (key == CSS.Attribute.WIDTH && (number2 = SferyxUtilities.getNumberFromCSString(value)) == -1.0f) {
            attr.addAttribute(AlternativeCSSAttribute.WIDTH, value);
            return;
        }
        if (key == CSS.Attribute.HEIGHT && (number2 = SferyxUtilities.getNumberFromCSString(value)) == -1.0f) {
            attr.addAttribute(AlternativeCSSAttribute.HEIGHT, value);
            return;
        }
        if (key == CSS.Attribute.PADDING_LEFT) {
            attr.addAttribute(AlternativeCSSAttribute.PADDING_LEFT, value);
            attr.addAttribute(HiddenValue.PADDING_LEFT, value);
            if (value.indexOf("!important") != -1) {
                attr.addAttribute("margin_left-important", SferyxUtilities.replaceAll(value, "!important", ""));
            }
            return;
        }
        if (key == CSS.Attribute.PADDING_TOP) {
            attr.addAttribute(AlternativeCSSAttribute.PADDING_TOP, value);
            attr.addAttribute(HiddenValue.PADDING_TOP, value);
            if (value.indexOf("!important") != -1) {
                attr.addAttribute("margin_top-important", SferyxUtilities.replaceAll(value, "!important", ""));
            }
            return;
        }
        if (key == CSS.Attribute.PADDING_BOTTOM) {
            attr.addAttribute(AlternativeCSSAttribute.PADDING_BOTTOM, value);
            attr.addAttribute(HiddenValue.PADDING_BOTTOM, value);
            if (value.indexOf("!important") != -1) {
                attr.addAttribute("margin_bottom-important", SferyxUtilities.replaceAll(value, "!important", ""));
            }
            return;
        }
        if (key == CSS.Attribute.MARGIN_RIGHT) {
            attr.addAttribute(AlternativeCSSAttribute.MARGIN_RIGHT, value);
            attr.addAttribute(HiddenValue.MARGIN_RIGHT, value);
            if (value.indexOf("!important") != -1) {
                attr.addAttribute("margin_right-important", SferyxUtilities.replaceAll(value, "!important", ""));
            }
            return;
        }
        if (key == CSS.Attribute.MARGIN_LEFT) {
            attr.addAttribute(AlternativeCSSAttribute.MARGIN_LEFT, value);
            attr.addAttribute(HiddenValue.MARGIN_LEFT, value);
            if (value.indexOf("!important") != -1) {
                attr.addAttribute("margin_left-important", SferyxUtilities.replaceAll(value, "!important", ""));
            }
            return;
        }
        if (key == CSS.Attribute.MARGIN_TOP) {
            attr.addAttribute(AlternativeCSSAttribute.MARGIN_TOP, value);
            attr.addAttribute(HiddenValue.MARGIN_TOP, value);
            if (value.indexOf("!important") != -1) {
                attr.addAttribute("margin_top-important", SferyxUtilities.replaceAll(value, "!important", ""));
            }
            return;
        }
        if (key == CSS.Attribute.MARGIN_BOTTOM) {
            attr.addAttribute(AlternativeCSSAttribute.MARGIN_BOTTOM, value);
            attr.addAttribute(HiddenValue.MARGIN_BOTTOM, value);
            if (value.indexOf("!important") != -1) {
                attr.addAttribute("margin_bottom-important", SferyxUtilities.replaceAll(value, "!important", ""));
            }
            return;
        }
        if (key == CSS.Attribute.MARGIN) {
            value = value.trim();
            attr.addAttribute(AlternativeCSSAttribute.MARGIN, value);
            boolean isImportant = false;
            if (value.indexOf("!important") != -1) {
                value = SferyxUtilities.replaceAll(value, "!important", "");
                isImportant = true;
            }
            StringTokenizer st = new StringTokenizer(value, " ");
            HiddenValue[] cssattr = new HiddenValue[]{HiddenValue.MARGIN_TOP, HiddenValue.MARGIN_RIGHT, HiddenValue.MARGIN_BOTTOM, HiddenValue.MARGIN_LEFT};
            int i = 0;
            int tokenCount = st.countTokens();
            if (tokenCount > 4) {
                tokenCount = 4;
            }
            while (st.hasMoreTokens() && i < cssattr.length) {
                String nextToken = st.nextToken();
                if (tokenCount == 4) {
                    attr.addAttribute(cssattr[i], nextToken);
                    if (isImportant) {
                        attr.addAttribute(cssattr[i].toString().toLowerCase() + "-important", nextToken);
                    }
                    ++i;
                    continue;
                }
                if (tokenCount == 2) {
                    attr.addAttribute(cssattr[0], nextToken);
                    if (isImportant) {
                        attr.addAttribute(cssattr[0].toString().toLowerCase() + "-important", nextToken);
                    }
                    attr.addAttribute(cssattr[2], nextToken);
                    if (isImportant) {
                        attr.addAttribute(cssattr[2].toString().toLowerCase() + "-important", nextToken);
                    }
                    nextToken = st.nextToken();
                    attr.addAttribute(cssattr[1], nextToken);
                    if (isImportant) {
                        attr.addAttribute(cssattr[1].toString().toLowerCase() + "-important", nextToken);
                    }
                    attr.addAttribute(cssattr[3], nextToken);
                    if (!isImportant) break;
                    attr.addAttribute(cssattr[3].toString().toLowerCase() + "-important", nextToken);
                    break;
                }
                if (tokenCount == 1) {
                    attr.addAttribute(cssattr[0], nextToken);
                    if (isImportant) {
                        attr.addAttribute(cssattr[0].toString().toLowerCase() + "-important", nextToken);
                    }
                    attr.addAttribute(cssattr[1], nextToken);
                    if (isImportant) {
                        attr.addAttribute(cssattr[1].toString().toLowerCase() + "-important", nextToken);
                    }
                    attr.addAttribute(cssattr[2], nextToken);
                    if (isImportant) {
                        attr.addAttribute(cssattr[2].toString().toLowerCase() + "-important", nextToken);
                    }
                    attr.addAttribute(cssattr[3], nextToken);
                    if (!isImportant) break;
                    attr.addAttribute(cssattr[3].toString().toLowerCase() + "-important", nextToken);
                    break;
                }
                if (tokenCount != 3) continue;
                attr.addAttribute(cssattr[0], nextToken);
                if (isImportant) {
                    attr.addAttribute(cssattr[0].toString().toLowerCase() + "-important", nextToken);
                }
                nextToken = st.nextToken();
                attr.addAttribute(cssattr[1], nextToken);
                if (isImportant) {
                    attr.addAttribute(cssattr[1].toString().toLowerCase() + "-important", nextToken);
                }
                attr.addAttribute(cssattr[3], nextToken);
                if (isImportant) {
                    attr.addAttribute(cssattr[3].toString().toLowerCase() + "-important", nextToken);
                }
                nextToken = st.nextToken();
                attr.addAttribute(cssattr[2], nextToken);
                if (!isImportant) break;
                attr.addAttribute(cssattr[2].toString().toLowerCase() + "-important", nextToken);
                break;
            }
            return;
        }
        if (key == CSS.Attribute.BACKGROUND) {
            String urlToken;
            String originalValue = value;
            if (value.indexOf("url(") != -1 && !(urlToken = SferyxUtilities.convertStyleDeclarationtoURL(value)).startsWith("data:")) {
                try {
                    URL url = null;
                    url = this.currentImportURL != null ? new URL(this.currentImportURL, urlToken) : new URL(this.getBase(), urlToken);
                    value = value.substring(0, value.indexOf("url(") + 4) + url.toString() + ")" + value.substring(value.indexOf(")", value.indexOf("url(")) + 1);
                }
                catch (Throwable thr) {
                    // empty catch block
                }
            }
            attr.addAttribute(HiddenValue.BACKGROUND, value);
            attr.addAttribute(key, originalValue);
            return;
        }
        if (key == CSS.Attribute.BACKGROUND_IMAGE) {
            // empty if block
        }
        if (HTMLEditor.jvm_version != null && HTMLEditor.jvm_version.startsWith("1.7") && key != null && key.toString().toLowerCase().startsWith("border")) {
            attr.addAttribute(key, value);
            return;
        }
        if (key == CSS.Attribute.HEIGHT) {
            boolean important = false;
            if (value.indexOf("!important") != -1) {
                important = true;
            }
            if ((number = SferyxUtilities.getNumberFromCSString(value)) != -1.0f) {
                super.addCSSAttribute(attr, key, value);
                if (important) {
                    attr.addAttribute("height-important", number + "");
                }
                return;
            }
        }
        if (key == CSS.Attribute.PADDING_TOP) {
            boolean important = false;
            if (value.indexOf("!important") != -1) {
                important = true;
            }
            if ((number = SferyxUtilities.getNumberFromCSString(value)) != -1.0f) {
                super.addCSSAttribute(attr, key, number + "");
                if (important) {
                    attr.addAttribute("padding_top-important", number + "");
                }
                return;
            }
        }
        if (key == CSS.Attribute.BACKGROUND_POSITION) {
            super.addCSSAttribute(attr, key, value);
            if (value.indexOf("!important") != -1) {
                attr.addAttribute("background_position-important", value);
            }
        }
        if (value.indexOf("!important") != -1) {
            // empty if block
        }
        if (value.trim().equalsIgnoreCase("auto") && key == CSS.Attribute.WIDTH) {
            return;
        }
        if (key == CSS.Attribute.WIDTH && (number = SferyxUtilities.getNumberFromCSString(value)) != -1.0f) {
            super.addCSSAttribute(attr, key, value);
            if (value.indexOf("!important") != -1) {
                attr.addAttribute("width-important", number + "");
            }
            return;
        }
        if (value.trim().indexOf("!important") != -1 && (key == CSS.Attribute.PADDING_BOTTOM || key == CSS.Attribute.PADDING_TOP || key == CSS.Attribute.PADDING_RIGHT || key == CSS.Attribute.PADDING_LEFT)) {
            attr.addAttribute(AlternativeCSSAttribute.convertCSSAttribute(key), value);
            return;
        }
        if (value.trim().equalsIgnoreCase("auto") && (key == CSS.Attribute.MARGIN_LEFT || key == CSS.Attribute.MARGIN_RIGHT)) {
            attr.addAttribute(AlternativeCSSAttribute.convertCSSAttribute(key), value);
            return;
        }
        if (!(value.trim().indexOf("%") == -1 && value.trim().indexOf("em") == -1 || key != CSS.Attribute.MARGIN_LEFT && key != CSS.Attribute.MARGIN_RIGHT && key != CSS.Attribute.MARGIN_TOP && key != CSS.Attribute.MARGIN_BOTTOM && key != CSS.Attribute.PADDING_RIGHT && key != CSS.Attribute.PADDING_LEFT && key != CSS.Attribute.PADDING_TOP && key != CSS.Attribute.PADDING_BOTTOM)) {
            attr.addAttribute(AlternativeCSSAttribute.convertCSSAttribute(key), value);
            return;
        }
        if (value.trim().indexOf("!important") != -1 && (key == CSS.Attribute.MARGIN_BOTTOM || key == CSS.Attribute.MARGIN_TOP || key == CSS.Attribute.MARGIN_RIGHT || key == CSS.Attribute.MARGIN_LEFT)) {
            attr.addAttribute(AlternativeCSSAttribute.convertCSSAttribute(key), value);
            return;
        }
        try {
            if (value.equalsIgnoreCase("orange") && (key == CSS.Attribute.BACKGROUND_COLOR || key == CSS.Attribute.COLOR)) {
                value = "#FFA500";
            }
            if (key == CSS.Attribute.LIST_STYLE) {
                StringTokenizer st = new StringTokenizer(value, " ");
                while (st.hasMoreTokens()) {
                    String nextToken = st.nextToken();
                    if (nextToken.toLowerCase().startsWith("url(")) {
                        super.addCSSAttribute(attr, CSS.Attribute.LIST_STYLE_IMAGE, nextToken);
                        continue;
                    }
                    if (!nextToken.toLowerCase().equals("none") && !nextToken.toLowerCase().equals("disc") && !nextToken.toLowerCase().equals("circle") && !nextToken.toLowerCase().equals("square") && !nextToken.toLowerCase().equals("decimal") && !nextToken.toLowerCase().equals("lower-roman") && !nextToken.toLowerCase().equals("upper-roman") && !nextToken.toLowerCase().equals("lower-alpha") && !nextToken.toLowerCase().equals("upper-alpha") && !nextToken.toLowerCase().equals("lower-latin") && !nextToken.toLowerCase().equals("upper-latin") && !nextToken.toLowerCase().equals("lower-greek")) continue;
                    super.addCSSAttribute(attr, CSS.Attribute.LIST_STYLE_TYPE, nextToken);
                }
                return;
            }
            if (key == CSS.Attribute.PADDING) {
                value = value.trim();
                attr.addAttribute(key, value);
                boolean isImportant = false;
                if (value.indexOf("!important") != -1) {
                    value = SferyxUtilities.replaceAll(value, "!important", "");
                    isImportant = true;
                }
                StringTokenizer st = new StringTokenizer(value, " ");
                HiddenValue[] cssattr = new HiddenValue[]{HiddenValue.PADDING_TOP, HiddenValue.PADDING_RIGHT, HiddenValue.PADDING_BOTTOM, HiddenValue.PADDING_LEFT};
                int i = 0;
                int tokenCount = st.countTokens();
                if (tokenCount > 4) {
                    tokenCount = 4;
                }
                while (st.hasMoreTokens() && i < cssattr.length) {
                    String nextToken = st.nextToken();
                    nextToken = nextToken.trim();
                    if (tokenCount == 4) {
                        attr.addAttribute(cssattr[i], nextToken);
                        if (isImportant) {
                            attr.addAttribute(cssattr[i].toString().toLowerCase() + "-important", nextToken);
                        }
                        ++i;
                        continue;
                    }
                    if (tokenCount == 2) {
                        attr.addAttribute(cssattr[0], nextToken);
                        if (isImportant) {
                            attr.addAttribute(cssattr[0].toString().toLowerCase() + "-important", nextToken);
                        }
                        attr.addAttribute(cssattr[2], nextToken);
                        if (isImportant) {
                            attr.addAttribute(cssattr[2].toString().toLowerCase() + "-important", nextToken);
                        }
                        nextToken = st.nextToken();
                        attr.addAttribute(cssattr[1], nextToken);
                        if (isImportant) {
                            attr.addAttribute(cssattr[1].toString().toLowerCase() + "-important", nextToken);
                        }
                        attr.addAttribute(cssattr[3], nextToken);
                        if (!isImportant) break;
                        attr.addAttribute(cssattr[3].toString().toLowerCase() + "-important", nextToken);
                        break;
                    }
                    if (tokenCount == 1) {
                        attr.addAttribute(cssattr[0], nextToken);
                        if (isImportant) {
                            attr.addAttribute(cssattr[0].toString().toLowerCase() + "-important", nextToken);
                        }
                        attr.addAttribute(cssattr[1], nextToken);
                        if (isImportant) {
                            attr.addAttribute(cssattr[1].toString().toLowerCase() + "-important", nextToken);
                        }
                        attr.addAttribute(cssattr[2], nextToken);
                        if (isImportant) {
                            attr.addAttribute(cssattr[2].toString().toLowerCase() + "-important", nextToken);
                        }
                        attr.addAttribute(cssattr[3], nextToken);
                        if (!isImportant) break;
                        attr.addAttribute(cssattr[3].toString().toLowerCase() + "-important", nextToken);
                        break;
                    }
                    if (tokenCount != 3) continue;
                    attr.addAttribute(cssattr[0], nextToken);
                    if (isImportant) {
                        attr.addAttribute(cssattr[0].toString().toLowerCase() + "-important", nextToken);
                    }
                    nextToken = st.nextToken();
                    attr.addAttribute(cssattr[1], nextToken);
                    if (isImportant) {
                        attr.addAttribute(cssattr[1].toString().toLowerCase() + "-important", nextToken);
                    }
                    attr.addAttribute(cssattr[3], nextToken);
                    if (isImportant) {
                        attr.addAttribute(cssattr[3].toString().toLowerCase() + "-important", nextToken);
                    }
                    nextToken = st.nextToken();
                    attr.addAttribute(cssattr[2], nextToken);
                    if (!isImportant) break;
                    attr.addAttribute(cssattr[2].toString().toLowerCase() + "-important", nextToken);
                    break;
                }
                return;
            }
            if (key == CSS.Attribute.PADDING) {
                value = value.trim();
                boolean isImportant = false;
                if (value.indexOf("!important") != -1) {
                    value = SferyxUtilities.replaceAll(value, "!important", "");
                    isImportant = true;
                }
                StringTokenizer st = new StringTokenizer(value, " ");
                CSS.Attribute[] cssattr = new CSS.Attribute[]{CSS.Attribute.PADDING_TOP, CSS.Attribute.PADDING_RIGHT, CSS.Attribute.PADDING_BOTTOM, CSS.Attribute.PADDING_LEFT};
                int i = 0;
                int tokenCount = st.countTokens();
                if (tokenCount > 4) {
                    tokenCount = 4;
                }
                while (st.hasMoreTokens() && i < cssattr.length) {
                    String nextToken = st.nextToken();
                    nextToken = nextToken.trim();
                    if (tokenCount == 4) {
                        this.addCSSAttribute(attr, cssattr[i], nextToken);
                        if (isImportant) {
                            attr.addAttribute(cssattr[i].toString().toLowerCase() + "-important", nextToken);
                        }
                        ++i;
                        continue;
                    }
                    if (tokenCount == 2) {
                        this.addCSSAttribute(attr, cssattr[0], nextToken);
                        if (isImportant) {
                            attr.addAttribute(cssattr[0].toString().toLowerCase() + "-important", nextToken);
                        }
                        this.addCSSAttribute(attr, cssattr[2], nextToken);
                        if (isImportant) {
                            attr.addAttribute(cssattr[2].toString().toLowerCase() + "-important", nextToken);
                        }
                        nextToken = st.nextToken();
                        this.addCSSAttribute(attr, cssattr[1], nextToken);
                        if (isImportant) {
                            attr.addAttribute(cssattr[1].toString().toLowerCase() + "-important", nextToken);
                        }
                        this.addCSSAttribute(attr, cssattr[3], nextToken);
                        if (!isImportant) continue;
                        attr.addAttribute(cssattr[3].toString().toLowerCase() + "-important", nextToken);
                        continue;
                    }
                    if (tokenCount == 1) {
                        this.addCSSAttribute(attr, cssattr[0], nextToken);
                        if (isImportant) {
                            attr.addAttribute(cssattr[0].toString().toLowerCase() + "-important", nextToken);
                        }
                        this.addCSSAttribute(attr, cssattr[1], nextToken);
                        if (isImportant) {
                            attr.addAttribute(cssattr[1].toString().toLowerCase() + "-important", nextToken);
                        }
                        this.addCSSAttribute(attr, cssattr[2], nextToken);
                        if (isImportant) {
                            attr.addAttribute(cssattr[2].toString().toLowerCase() + "-important", nextToken);
                        }
                        this.addCSSAttribute(attr, cssattr[3], nextToken);
                        if (!isImportant) continue;
                        attr.addAttribute(cssattr[3].toString().toLowerCase() + "-important", nextToken);
                        continue;
                    }
                    if (tokenCount != 3) continue;
                    this.addCSSAttribute(attr, cssattr[0], nextToken);
                    if (isImportant) {
                        attr.addAttribute(cssattr[0].toString().toLowerCase() + "-important", nextToken);
                    }
                    nextToken = st.nextToken();
                    this.addCSSAttribute(attr, cssattr[1], nextToken);
                    if (isImportant) {
                        attr.addAttribute(cssattr[1].toString().toLowerCase() + "-important", nextToken);
                    }
                    this.addCSSAttribute(attr, cssattr[3], nextToken);
                    if (isImportant) {
                        attr.addAttribute(cssattr[3].toString().toLowerCase() + "-important", nextToken);
                    }
                    nextToken = st.nextToken();
                    this.addCSSAttribute(attr, cssattr[2], nextToken);
                    if (!isImportant) continue;
                    attr.addAttribute(cssattr[2].toString().toLowerCase() + "-important", nextToken);
                }
                return;
            }
            if (key == CSS.Attribute.MARGIN) {
                value = value.trim();
                boolean isImportant = false;
                if (value.indexOf("!important") != -1) {
                    value = SferyxUtilities.replaceAll(value, "!important", "");
                    isImportant = true;
                }
                StringTokenizer st = new StringTokenizer(value, " ");
                CSS.Attribute[] cssattr = new CSS.Attribute[]{CSS.Attribute.MARGIN_TOP, CSS.Attribute.MARGIN_RIGHT, CSS.Attribute.MARGIN_BOTTOM, CSS.Attribute.MARGIN_LEFT};
                int i = 0;
                int tokenCount = st.countTokens();
                if (tokenCount > 4) {
                    tokenCount = 4;
                }
                while (st.hasMoreTokens() && i < cssattr.length) {
                    String nextToken = st.nextToken();
                    if (tokenCount == 4) {
                        this.addCSSAttribute(attr, cssattr[i], nextToken);
                        if (isImportant) {
                            attr.addAttribute(cssattr[i].toString().toLowerCase() + "-important", nextToken);
                        }
                        ++i;
                        continue;
                    }
                    if (tokenCount == 2) {
                        this.addCSSAttribute(attr, cssattr[0], nextToken);
                        if (isImportant) {
                            attr.addAttribute(cssattr[0].toString().toLowerCase() + "-important", nextToken);
                        }
                        this.addCSSAttribute(attr, cssattr[2], nextToken);
                        if (isImportant) {
                            attr.addAttribute(cssattr[2].toString().toLowerCase() + "-important", nextToken);
                        }
                        nextToken = st.nextToken();
                        this.addCSSAttribute(attr, cssattr[1], nextToken);
                        if (isImportant) {
                            attr.addAttribute(cssattr[1].toString().toLowerCase() + "-important", nextToken);
                        }
                        this.addCSSAttribute(attr, cssattr[3], nextToken);
                        if (!isImportant) continue;
                        attr.addAttribute(cssattr[3].toString().toLowerCase() + "-important", nextToken);
                        continue;
                    }
                    if (tokenCount == 1) {
                        this.addCSSAttribute(attr, cssattr[0], nextToken);
                        if (isImportant) {
                            attr.addAttribute(cssattr[0].toString().toLowerCase() + "-important", nextToken);
                        }
                        this.addCSSAttribute(attr, cssattr[1], nextToken);
                        if (isImportant) {
                            attr.addAttribute(cssattr[1].toString().toLowerCase() + "-important", nextToken);
                        }
                        this.addCSSAttribute(attr, cssattr[2], nextToken);
                        if (isImportant) {
                            attr.addAttribute(cssattr[2].toString().toLowerCase() + "-important", nextToken);
                        }
                        this.addCSSAttribute(attr, cssattr[3], nextToken);
                        if (!isImportant) continue;
                        attr.addAttribute(cssattr[3].toString().toLowerCase() + "-important", nextToken);
                        continue;
                    }
                    if (tokenCount != 3) continue;
                    this.addCSSAttribute(attr, cssattr[0], nextToken);
                    if (isImportant) {
                        attr.addAttribute(cssattr[0].toString().toLowerCase() + "-important", nextToken);
                    }
                    nextToken = st.nextToken();
                    this.addCSSAttribute(attr, cssattr[1], nextToken);
                    if (isImportant) {
                        attr.addAttribute(cssattr[1].toString().toLowerCase() + "-important", nextToken);
                    }
                    this.addCSSAttribute(attr, cssattr[3], nextToken);
                    if (isImportant) {
                        attr.addAttribute(cssattr[3].toString().toLowerCase() + "-important", nextToken);
                    }
                    nextToken = st.nextToken();
                    this.addCSSAttribute(attr, cssattr[2], nextToken);
                    if (!isImportant) continue;
                    attr.addAttribute(cssattr[2].toString().toLowerCase() + "-important", nextToken);
                }
                return;
            }
            if (value != null && value.indexOf("!important") != -1) {
                value = SferyxUtilities.replaceAll(value, "!important", "");
                if (key == CSS.Attribute.COLOR) {
                    super.addCSSAttribute(attr, key, this.colorToString(this.stringToColor(value)));
                    attr.addAttribute("color-important", this.colorToString(this.stringToColor(value)));
                    return;
                }
                if (key == CSS.Attribute.FONT) {
                    super.addCSSAttribute(attr, key, value);
                    attr.addAttribute("font-important", value);
                    return;
                }
                if (key == CSS.Attribute.FONT_SIZE) {
                    super.addCSSAttribute(attr, key, value);
                    attr.addAttribute("font_size-important", value);
                    return;
                }
                if (key == CSS.Attribute.FONT_FAMILY) {
                    super.addCSSAttribute(attr, key, value);
                    attr.addAttribute("font_family-important", value);
                    return;
                }
                if (key == CSS.Attribute.BACKGROUND_POSITION) {
                    super.addCSSAttribute(attr, key, value);
                    attr.addAttribute("background_position-important", value);
                }
                if (key == CSS.Attribute.BACKGROUND_REPEAT) {
                    super.addCSSAttribute(attr, key, value);
                    attr.addAttribute("background_repeat-important", value);
                }
                if (key == CSS.Attribute.DISPLAY) {
                    super.addCSSAttribute(attr, key, value);
                    attr.addAttribute("display-important", value);
                }
            }
            if (key == CSS.Attribute.BACKGROUND_IMAGE || key == CSS.Attribute.BACKGROUND) {
                if (value.toLowerCase().indexOf("url(") != -1) {
                    String urlToken = SferyxUtilities.convertStyleDeclarationtoURL(value);
                    if (this.currentImportURL != null) {
                        URL url = new URL(this.currentImportURL, urlToken);
                        value = SferyxUtilities.replaceAll(value, urlToken, url.toString());
                    } else {
                        URL url = new URL(this.getBase(), urlToken);
                        value = SferyxUtilities.replaceAll(value, urlToken, url.toString());
                    }
                }
                if (key == CSS.Attribute.BACKGROUND_IMAGE) {
                    attr.addAttribute(AlternativeCSSAttribute.BACKGROUND_IMAGE, value);
                    return;
                }
            }
            if (key == CSS.Attribute.BACKGROUND_POSITION) {
                if (value != null && value.indexOf("-") != -1) {
                    attr.addAttribute("background-position", value);
                }
                return;
            }
            if (key == CSS.Attribute.BACKGROUND) {
                StringTokenizer st = new StringTokenizer(value, " ");
                while (st.hasMoreTokens()) {
                    String nextToken = st.nextToken();
                    if (nextToken.toLowerCase().startsWith("url(") || nextToken.toLowerCase().startsWith("none")) {
                        String imageURL = nextToken.substring(4, nextToken.length() - 1);
                        URL url = new URL(this.getBase(), imageURL);
                        continue;
                    }
                    if (nextToken.toLowerCase().startsWith("#") || nextToken.toLowerCase().equals("repeat") || nextToken.toLowerCase().equals("repeat-x") || nextToken.toLowerCase().equals("repeat-y") || nextToken.toLowerCase().equals("no-repeat")) continue;
                    if (nextToken.toLowerCase().equals("top") || nextToken.toLowerCase().equals("center") || nextToken.toLowerCase().equals("right") || nextToken.toLowerCase().equals("left") || nextToken.toLowerCase().equals("bottom") || nextToken.toLowerCase().equals("left") || nextToken.toLowerCase().endsWith("%") || nextToken.toLowerCase().endsWith("px")) {
                        if (!st.hasMoreTokens()) continue;
                        attr.addAttribute("background-position", nextToken + " " + st.nextToken());
                        break;
                    }
                    if (!nextToken.toLowerCase().equals("scroll") && !nextToken.toLowerCase().equals("fixed")) continue;
                }
            }
            super.addCSSAttribute(attr, key, value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static int getIndexOfSize(float pt) {
        for (int i = 0; i < sizeMap_.length; ++i) {
            if (!(pt <= (float)sizeMap_[i])) continue;
            return i + 1;
        }
        return sizeMap_.length;
    }

    public float getPointSize(String size) {
        int baseFontSize = 4;
        if (size != null) {
            int absSize;
            if (size.startsWith("+")) {
                int relSize = Integer.valueOf(size.substring(1));
                return this.getPointSize(baseFontSize + relSize);
            }
            if (size.startsWith("-")) {
                int relSize = -Integer.valueOf(size.substring(1)).intValue();
                return this.getPointSize(baseFontSize + relSize);
            }
            try {
                size = size.trim();
                size = SferyxUtilities.replaceAll(size, "\"", "");
                absSize = Integer.valueOf(size);
            }
            catch (Throwable thr) {
                absSize = 2;
            }
            return this.getPointSize(absSize);
        }
        return 0.0f;
    }

    public float getPointSize(int index) {
        if (--index < 0) {
            return sizeMap_[0];
        }
        if (index > sizeMap_.length - 1) {
            return sizeMap_[sizeMap_.length - 1];
        }
        return sizeMap_[index];
    }
}

