/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.AbstractListModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import sferyx.administration.editors.ColorChooserDialog;
import sferyx.administration.editors.EditorHTMLDocument;
import sferyx.administration.editors.HTMLEditor;

public class ExtendedFontChooser
extends JDialog
implements ListCellRenderer {
    boolean final_underline = false;
    boolean final_strike = false;
    boolean final_sub = false;
    boolean final_super = false;
    boolean init = false;
    boolean adjusting = false;
    JEditorPane editorPane;
    boolean cancel = false;
    MutableAttributeSet attributes;
    JLabel rendererLabel = new JLabel();
    Font currentSelectedFont;
    HTMLEditor htmlPanel;
    private JList fontSizeList;
    private JScrollPane fontSizeScrollPane;
    private JSeparator decorationSeparator;
    private JSeparator previewSeparator;
    private JCheckBox striketroughCheckBox;
    private JList fontStyleList;
    private JLabel decorarionsLabel;
    private JButton selectColorButton;
    private JLabel previewLabel;
    private JComboBox styleClassComboBox;
    private JLabel styleClassLabel;
    private JScrollPane fontStyleScrollPane;
    private JLabel fontSizeLabel;
    private JCheckBox subScriptCheckBox;
    private JButton OkButton;
    private JLabel colorLabel;
    private JTextPane previewTextPane;
    private JCheckBox underlineCheckBox;
    private JLabel colorPreviewLabel;
    private JList fontList;
    private JLabel fontsLabel;
    private JLabel fontStyleLabel;
    private JButton CancelButton;
    private JCheckBox superScriptCheckBox;
    private JScrollPane fontListScrollPane;

    public ExtendedFontChooser(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.fontList.setCellRenderer(this);
        this.previewTextPane.setContentType("text/html");
        this.previewTextPane.setText("AbBbCcDd");
        this.setResizable(false);
        ((DefaultComboBoxModel)this.fontList.getModel()).insertElementAt("Default", 0);
    }

    public ExtendedFontChooser(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.fontList.setCellRenderer(this);
        this.previewTextPane.setContentType("text/html");
        this.previewTextPane.setText("AbBbCcDd");
        this.setResizable(false);
        ((DefaultComboBoxModel)this.fontList.getModel()).insertElementAt("Default", 0);
    }

    private void initComponents() {
        this.fontsLabel = new JLabel();
        this.fontStyleScrollPane = new JScrollPane();
        this.fontStyleList = new JList();
        this.fontListScrollPane = new JScrollPane();
        this.fontList = new JList();
        this.fontSizeScrollPane = new JScrollPane();
        this.fontSizeList = new JList();
        this.fontStyleLabel = new JLabel();
        this.fontSizeLabel = new JLabel();
        this.colorLabel = new JLabel();
        this.colorPreviewLabel = new JLabel();
        this.selectColorButton = new JButton();
        this.decorationSeparator = new JSeparator();
        this.decorarionsLabel = new JLabel();
        this.underlineCheckBox = new JCheckBox();
        this.striketroughCheckBox = new JCheckBox();
        this.previewLabel = new JLabel();
        this.previewSeparator = new JSeparator();
        this.previewTextPane = new JTextPane();
        this.OkButton = new JButton();
        this.CancelButton = new JButton();
        this.superScriptCheckBox = new JCheckBox();
        this.subScriptCheckBox = new JCheckBox();
        this.styleClassComboBox = new JComboBox();
        this.styleClassLabel = new JLabel();
        this.getContentPane().setLayout(null);
        this.setTitle("Font Properties");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ExtendedFontChooser.this.closeDialog(evt);
            }
        });
        this.fontsLabel.setText("Font:");
        this.getContentPane().add(this.fontsLabel);
        this.fontsLabel.setBounds(10, 10, 150, 16);
        this.fontStyleList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Regular", "Bold", "Italic", "Bold & Italic"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.fontStyleList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ExtendedFontChooser.this.fontStyleListValueChanged(evt);
            }
        });
        this.fontStyleScrollPane.setViewportView(this.fontStyleList);
        this.getContentPane().add(this.fontStyleScrollPane);
        this.fontStyleScrollPane.setBounds(180, 30, 110, 130);
        this.fontListScrollPane.setEnabled(false);
        this.fontList.setBackground(new Color(255, 255, 255));
        this.fontList.setModel(new DefaultComboBoxModel<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()));
        this.fontList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ExtendedFontChooser.this.fontListValueChanged(evt);
            }
        });
        this.fontListScrollPane.setViewportView(this.fontList);
        this.getContentPane().add(this.fontListScrollPane);
        this.fontListScrollPane.setBounds(10, 30, 160, 130);
        this.fontSizeList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Default", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "22", "24", "26", "28", "30", "36", "48", "72"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.fontSizeList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ExtendedFontChooser.this.fontSizeListValueChanged(evt);
            }
        });
        this.fontSizeScrollPane.setViewportView(this.fontSizeList);
        this.getContentPane().add(this.fontSizeScrollPane);
        this.fontSizeScrollPane.setBounds(300, 30, 110, 130);
        this.fontStyleLabel.setText("Font style:");
        this.getContentPane().add(this.fontStyleLabel);
        this.fontStyleLabel.setBounds(180, 10, 110, 16);
        this.fontSizeLabel.setText("Font size:");
        this.getContentPane().add(this.fontSizeLabel);
        this.fontSizeLabel.setBounds(300, 10, 100, 16);
        this.colorLabel.setHorizontalAlignment(4);
        this.colorLabel.setText("Color:");
        this.getContentPane().add(this.colorLabel);
        this.colorLabel.setBounds(10, 180, 100, 16);
        this.colorPreviewLabel.setBackground(new Color(0, 0, 0));
        this.colorPreviewLabel.setOpaque(true);
        this.getContentPane().add(this.colorPreviewLabel);
        this.colorPreviewLabel.setBounds(130, 180, 20, 20);
        this.selectColorButton.setText("Select...");
        this.selectColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtendedFontChooser.this.selectColorButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.selectColorButton);
        this.selectColorButton.setBounds(160, 180, 90, 26);
        this.getContentPane().add(this.decorationSeparator);
        this.decorationSeparator.setBounds(120, 217, 300, 2);
        this.decorarionsLabel.setHorizontalAlignment(4);
        this.decorarionsLabel.setText("Decoration");
        this.getContentPane().add(this.decorarionsLabel);
        this.decorarionsLabel.setBounds(10, 210, 100, 16);
        this.underlineCheckBox.setText("Underline");
        this.underlineCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ExtendedFontChooser.this.underlineCheckBoxItemStateChanged(evt);
            }
        });
        this.getContentPane().add(this.underlineCheckBox);
        this.underlineCheckBox.setBounds(60, 230, 170, 24);
        this.striketroughCheckBox.setText("Strikethrough");
        this.striketroughCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ExtendedFontChooser.this.striketroughCheckBoxItemStateChanged(evt);
            }
        });
        this.getContentPane().add(this.striketroughCheckBox);
        this.striketroughCheckBox.setBounds(60, 250, 170, 24);
        this.previewLabel.setHorizontalAlignment(4);
        this.previewLabel.setText("Preview");
        this.getContentPane().add(this.previewLabel);
        this.previewLabel.setBounds(10, 280, 100, 16);
        this.getContentPane().add(this.previewSeparator);
        this.previewSeparator.setBounds(120, 289, 300, 2);
        this.previewTextPane.setBorder(new BevelBorder(1));
        this.previewTextPane.setEditable(false);
        this.previewTextPane.setText("AbBbCcDd");
        this.previewTextPane.setStyledDocument(new HTMLDocument());
        this.getContentPane().add(this.previewTextPane);
        this.previewTextPane.setBounds(40, 300, 350, 70);
        this.OkButton.setText("Ok");
        this.OkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtendedFontChooser.this.OkButtonActionPerformed(evt);
            }
        });
        this.OkButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                ExtendedFontChooser.this.OkButtonMousePressed(evt);
            }
        });
        this.getContentPane().add(this.OkButton);
        this.OkButton.setBounds(160, 420, 120, 26);
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtendedFontChooser.this.CancelButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.CancelButton);
        this.CancelButton.setBounds(287, 420, 120, 26);
        this.superScriptCheckBox.setText("Superscript");
        this.superScriptCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ExtendedFontChooser.this.superScriptCheckBoxItemStateChanged(evt);
            }
        });
        this.getContentPane().add(this.superScriptCheckBox);
        this.superScriptCheckBox.setBounds(230, 230, 180, 24);
        this.subScriptCheckBox.setText("Subscript");
        this.subScriptCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ExtendedFontChooser.this.subScriptCheckBoxItemStateChanged(evt);
            }
        });
        this.getContentPane().add(this.subScriptCheckBox);
        this.subScriptCheckBox.setBounds(230, 250, 180, 24);
        this.styleClassComboBox.setEditable(true);
        this.styleClassComboBox.setVerifyInputWhenFocusTarget(false);
        this.getContentPane().add(this.styleClassComboBox);
        this.styleClassComboBox.setBounds(110, 380, 160, 20);
        this.styleClassLabel.setHorizontalAlignment(4);
        this.styleClassLabel.setText("Style:");
        this.getContentPane().add(this.styleClassLabel);
        this.styleClassLabel.setBounds(10, 380, 90, 16);
        this.pack();
    }

    private void OkButtonMousePressed(MouseEvent evt) {
        this.OkButton.requestFocus();
    }

    private void striketroughCheckBoxItemStateChanged(ItemEvent evt) {
        boolean selected = this.striketroughCheckBox.isSelected();
        if (!this.init) {
            this.final_strike = true;
        }
        if (selected) {
            this.setStrikeThrough(this.attributes, true);
        } else {
            this.setStrikeThrough(this.attributes, false);
        }
        if (!this.adjusting) {
            this.adjusting = true;
        }
        this.adjusting = false;
        this.updatePreview();
    }

    private void subScriptCheckBoxItemStateChanged(ItemEvent evt) {
        boolean selected = this.subScriptCheckBox.isSelected();
        if (!this.init) {
            this.final_sub = true;
        }
        if (selected) {
            StyleConstants.setSubscript(this.attributes, true);
        } else {
            StyleConstants.setSubscript(this.attributes, false);
        }
        if (!this.adjusting) {
            this.adjusting = true;
            if (this.superScriptCheckBox.isSelected()) {
                this.superScriptCheckBox.setSelected(false);
            }
        }
        this.adjusting = false;
        this.updatePreview();
    }

    private void superScriptCheckBoxItemStateChanged(ItemEvent evt) {
        boolean selected = this.superScriptCheckBox.isSelected();
        if (!this.init) {
            this.final_super = true;
        }
        if (selected) {
            StyleConstants.setSuperscript(this.attributes, true);
        } else {
            StyleConstants.setSuperscript(this.attributes, false);
        }
        if (!this.adjusting) {
            this.adjusting = true;
            if (this.subScriptCheckBox.isSelected()) {
                this.subScriptCheckBox.setSelected(false);
            }
        }
        this.adjusting = false;
        this.updatePreview();
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.cancel = true;
        this.setVisible(false);
        this.dispose();
    }

    private void OkButtonActionPerformed(ActionEvent evt) {
        this.cancel = false;
        this.setVisible(false);
        this.dispose();
    }

    private void underlineCheckBoxItemStateChanged(ItemEvent evt) {
        boolean selected = this.underlineCheckBox.isSelected();
        if (!this.init) {
            this.final_underline = true;
        }
        if (selected) {
            this.setUnderline(this.attributes, true);
        } else {
            this.setUnderline(this.attributes, false);
        }
        if (!this.adjusting) {
            this.adjusting = true;
        }
        this.adjusting = false;
        this.updatePreview();
    }

    void setUnderline(MutableAttributeSet attr, boolean underline) {
        EditorHTMLDocument htdoc = (EditorHTMLDocument)this.htmlPanel.getInternalJEditorPane().getDocument();
        MutableAttributeSet sas = attr;
        String style = "";
        if (underline) {
            style = "underline";
            if (StyleConstants.isStrikeThrough(attr)) {
                style = "line-through underline";
            }
            htdoc.getStyleSheet().addCSSAttribute(sas, CSS.Attribute.TEXT_DECORATION, style);
            StyleConstants.setUnderline(sas, underline);
        } else {
            style = "none";
            if (StyleConstants.isStrikeThrough(attr)) {
                style = "line-through";
                StyleConstants.setUnderline(sas, underline);
                StyleConstants.setStrikeThrough(sas, true);
            } else {
                StyleConstants.setUnderline(sas, underline);
                style = "none";
            }
            htdoc.getStyleSheet().addCSSAttribute(sas, CSS.Attribute.TEXT_DECORATION, style);
        }
    }

    void setStrikeThrough(MutableAttributeSet attr, boolean strike) {
        EditorHTMLDocument htdoc = (EditorHTMLDocument)this.htmlPanel.getInternalJEditorPane().getDocument();
        MutableAttributeSet sas = attr;
        String style = "";
        if (strike) {
            style = "line-through";
            if (StyleConstants.isUnderline(attr)) {
                style = "line-through underline";
            }
            htdoc.getStyleSheet().addCSSAttribute(sas, CSS.Attribute.TEXT_DECORATION, style);
            StyleConstants.setStrikeThrough(sas, strike);
        } else {
            style = "none";
            if (StyleConstants.isUnderline(attr)) {
                style = "underline";
                StyleConstants.setStrikeThrough(sas, strike);
                StyleConstants.setUnderline(sas, true);
            } else {
                StyleConstants.setStrikeThrough(sas, strike);
                style = "none";
            }
            htdoc.getStyleSheet().addCSSAttribute(sas, CSS.Attribute.TEXT_DECORATION, style);
        }
    }

    private void fontSizeListValueChanged(ListSelectionEvent evt) {
        if (this.init) {
            return;
        }
        int selectedIndex = this.fontSizeList.getSelectedIndex();
        int fontSize = Integer.parseInt((String)this.fontSizeList.getSelectedValue());
        ((HTMLDocument)this.editorPane.getDocument()).getStyleSheet().addCSSAttribute(this.attributes, CSS.Attribute.FONT_SIZE, fontSize + "pt");
        this.updatePreview();
    }

    private void fontStyleListValueChanged(ListSelectionEvent evt) {
        if (this.init) {
            return;
        }
        String selectedValue = (String)this.fontStyleList.getSelectedValue();
        if (selectedValue.equals("Bold")) {
            StyleConstants.setBold(this.attributes, true);
            StyleConstants.setItalic(this.attributes, false);
        } else if (selectedValue.equals("Italic")) {
            StyleConstants.setItalic(this.attributes, true);
            StyleConstants.setBold(this.attributes, false);
        } else if (selectedValue.equals("Bold & Italic")) {
            StyleConstants.setItalic(this.attributes, true);
            StyleConstants.setBold(this.attributes, true);
        } else {
            StyleConstants.setBold(this.attributes, false);
            StyleConstants.setItalic(this.attributes, false);
        }
        this.updatePreview();
    }

    private void fontListValueChanged(ListSelectionEvent evt) {
        if (this.init) {
            return;
        }
        StyleConstants.setFontFamily(this.attributes, (String)this.fontList.getSelectedValue());
        this.updatePreview();
    }

    private void selectColorButtonActionPerformed(ActionEvent evt) {
        if (this.htmlPanel.colorChooserDialog == null) {
            this.htmlPanel.colorChooserDialog = SwingUtilities.windowForComponent(this) instanceof Frame ? new ColorChooserDialog((Frame)SwingUtilities.windowForComponent(this), true, this.htmlPanel.getTranslatedString("Choose Foreground Color")) : new ColorChooserDialog((Dialog)SwingUtilities.windowForComponent(this), true, this.htmlPanel.getTranslatedString("Choose Foreground Color"));
        }
        this.htmlPanel.colorChooserDialog.setTitle(this.htmlPanel.getTranslatedString("Choose Background Color"));
        if (this.colorPreviewLabel.isOpaque()) {
            this.htmlPanel.colorChooserDialog.setSelectedColor(this.colorPreviewLabel.getBackground());
        } else {
            this.htmlPanel.colorChooserDialog.setSelectedColor(null);
        }
        this.htmlPanel.translateContainer(this.htmlPanel.colorChooserDialog);
        this.htmlPanel.colorChooserDialog.setVisible(true);
        int result = this.htmlPanel.colorChooserDialog.getActionResult();
        ColorChooserDialog cfr_ignored_0 = this.htmlPanel.colorChooserDialog;
        if (result == ColorChooserDialog.OK_BUTTON) {
            Color newColor = this.htmlPanel.colorChooserDialog.getSelectedColor();
            if (newColor == null) {
                return;
            }
            StyleConstants.setForeground(this.attributes, newColor);
            this.colorPreviewLabel.setBackground(newColor);
            this.updatePreview();
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.cancel = true;
        this.setVisible(false);
        this.dispose();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.rendererLabel.setText(this.htmlPanel.getTranslatedString((String)value));
        this.rendererLabel.setOpaque(true);
        this.rendererLabel.setBackground(isSelected ? SystemColor.textHighlight : list.getBackground());
        this.rendererLabel.setForeground(isSelected ? Color.white : Color.black);
        return this.rendererLabel;
    }

    public void initFontProperties(AttributeSet attribs) {
        this.init = true;
        this.previewTextPane.setText("AbBbCcDd");
        this.final_underline = false;
        this.final_strike = false;
        this.final_sub = false;
        this.final_super = false;
        try {
            Enumeration<?> enum_ = attribs.getAttributeNames();
            int fontSize = -1;
            String fontFamily = null;
            boolean bold = false;
            boolean italic = false;
            boolean strikethrough = false;
            boolean underline = false;
            boolean superscript = false;
            boolean subscript = false;
            Color foreground = Color.black;
            this.fontSizeList.setSelectedIndex(0);
            this.fontList.setSelectedIndex(0);
            this.fontList.ensureIndexIsVisible(0);
            this.fontSizeList.ensureIndexIsVisible(0);
            this.attributes = new SimpleAttributeSet();
            while (enum_.hasMoreElements()) {
                Object name = enum_.nextElement();
                Object value = attribs.getAttribute(name);
                String nameString = name.toString();
                String valueString = value.toString();
                if (nameString.equals("font-size")) {
                    try {
                        fontSize = ((HTMLDocument)this.htmlPanel.getInternalJEditorPane().getDocument()).getStyleSheet().getFont(attribs).getSize();
                        ((HTMLDocument)this.editorPane.getDocument()).getStyleSheet().addCSSAttribute(this.attributes, CSS.Attribute.FONT_SIZE, (int)((double)fontSize / 1.33) + "pt");
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                }
                if (nameString.equals("font-family")) {
                    fontFamily = valueString;
                    StyleConstants.setFontFamily(this.attributes, fontFamily);
                }
                if (nameString.equals("font-weight") && valueString.equals("bold")) {
                    bold = true;
                    StyleConstants.setBold(this.attributes, true);
                }
                if (nameString.equals("font-style") && valueString.equals("italic")) {
                    italic = true;
                    StyleConstants.setItalic(this.attributes, true);
                }
                if (nameString.equals("color")) {
                    foreground = this.convertStringToColor(valueString);
                    StyleConstants.setForeground(this.attributes, foreground);
                }
                if (nameString.equals("underline") && valueString.equals("true")) {
                    underline = true;
                    this.underlineCheckBox.setSelected(true);
                    StyleConstants.setUnderline(this.attributes, true);
                }
                if (nameString.equals("strikethrough") && valueString.equals("true")) {
                    strikethrough = true;
                    this.striketroughCheckBox.setSelected(true);
                    StyleConstants.setStrikeThrough(this.attributes, true);
                }
                if (nameString.equals("text-decoration")) {
                    if (valueString.indexOf("line-through") != -1) {
                        strikethrough = true;
                        StyleConstants.setStrikeThrough(this.attributes, true);
                        this.striketroughCheckBox.setSelected(true);
                    }
                    if (valueString.indexOf("underline") != -1) {
                        underline = true;
                        this.underlineCheckBox.setSelected(true);
                        StyleConstants.setUnderline(this.attributes, true);
                    }
                    if (underline && strikethrough) {
                        String style = "line-through underline";
                        EditorHTMLDocument htdoc = (EditorHTMLDocument)this.htmlPanel.getInternalJEditorPane().getDocument();
                        htdoc.getStyleSheet().addCSSAttribute(this.attributes, CSS.Attribute.TEXT_DECORATION, style);
                    }
                }
                if (nameString.equals("superscript") && valueString.equals("true")) {
                    superscript = true;
                    this.superScriptCheckBox.setSelected(true);
                    StyleConstants.setSuperscript(this.attributes, true);
                }
                if (nameString.equals("subscript") && valueString.equals("true")) {
                    subscript = true;
                    this.subScriptCheckBox.setSelected(true);
                    StyleConstants.setSubscript(this.attributes, true);
                }
                if (!nameString.equals("vertical-align")) continue;
                if (valueString.equals("sub")) {
                    subscript = true;
                    StyleConstants.setSubscript(this.attributes, true);
                    this.subScriptCheckBox.setSelected(true);
                    continue;
                }
                if (!valueString.equals("super")) continue;
                superscript = true;
                StyleConstants.setSuperscript(this.attributes, true);
                this.superScriptCheckBox.setSelected(true);
            }
            Font incomingFont = new Font(fontFamily, 0, 1);
            this.colorPreviewLabel.setBackground(foreground);
            this.fontList.setSelectedValue(fontFamily, true);
            if (this.fontList.getSelectedIndex() >= 0) {
                this.fontList.ensureIndexIsVisible(this.fontList.getSelectedIndex());
            }
            if (fontSize != -1) {
                this.fontSizeList.setSelectedValue((int)((double)fontSize / 1.33) + "", true);
                if (this.fontSizeList.getSelectedIndex() >= 0) {
                    this.fontSizeList.ensureIndexIsVisible(this.fontSizeList.getSelectedIndex());
                }
            }
            if (bold & italic) {
                this.fontStyleList.setSelectedValue("Bold & Italic", true);
            } else if (bold) {
                this.fontStyleList.setSelectedValue("Bold", true);
            } else if (italic) {
                this.fontStyleList.setSelectedValue("Italic", true);
            } else {
                this.fontStyleList.setSelectedValue("Regular", true);
            }
            if (!subscript) {
                this.subScriptCheckBox.setSelected(false);
            }
            if (!superscript) {
                this.superScriptCheckBox.setSelected(false);
            }
            if (!strikethrough) {
                this.striketroughCheckBox.setSelected(false);
            }
            if (!underline) {
                this.underlineCheckBox.setSelected(false);
            }
            this.updatePreview();
            this.styleClassComboBox.setModel(new DefaultComboBoxModel(this.htmlPanel.getStyleClasses()));
            AttributeSet fontAttribute = (AttributeSet)attribs.getAttribute(HTML.Tag.SPAN);
            if (fontAttribute != null) {
                String styleClass = (String)fontAttribute.getAttribute(HTML.Attribute.CLASS);
                if (styleClass != null && fontAttribute.containsAttribute(HTML.Attribute.CLASS, styleClass)) {
                    this.styleClassComboBox.setSelectedItem(styleClass);
                } else {
                    this.styleClassComboBox.setSelectedIndex(-1);
                }
            } else {
                this.styleClassComboBox.setSelectedIndex(-1);
            }
            this.styleClassComboBox.setRenderer(this.htmlPanel.getStyleClassRendererInstance());
            this.OkButton.requestFocus();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        this.init = false;
        this.htmlPanel.createGenericListRenderer(this.fontStyleList);
        this.htmlPanel.createGenericListRenderer(this.fontSizeList);
    }

    public void updatePreview() {
        HTMLDocument doc = (HTMLDocument)this.previewTextPane.getDocument();
        SimpleAttributeSet as = new SimpleAttributeSet(this.attributes);
        as.removeAttribute(StyleConstants.Underline);
        as.removeAttribute(StyleConstants.StrikeThrough);
        doc.setCharacterAttributes(0, doc.getLength(), as, false);
    }

    public int getIndexForFontSize(int fontSize) {
        int index = 2;
        index = fontSize;
        if (index < 0) {
            index = -1;
        } else if (index > 6) {
            index = 6;
        }
        return index;
    }

    public AttributeSet getNewAttributes() {
        if (this.cancel) {
            return null;
        }
        this.attributes.removeAttribute(StyleConstants.Superscript);
        this.attributes.removeAttribute(StyleConstants.Subscript);
        boolean subscript = this.subScriptCheckBox.isSelected();
        boolean superscript = this.superScriptCheckBox.isSelected();
        if (subscript) {
            if (this.final_sub) {
                StyleConstants.setSubscript(this.attributes, subscript);
            }
        } else if (superscript) {
            if (this.final_super) {
                StyleConstants.setSuperscript(this.attributes, superscript);
            }
        } else {
            if (this.final_sub) {
                StyleConstants.setSubscript(this.attributes, subscript);
            }
            if (this.final_super) {
                StyleConstants.setSuperscript(this.attributes, superscript);
            }
        }
        if (this.styleClassComboBox.getSelectedItem() != null) {
            this.attributes.addAttribute(HTML.Attribute.CLASS, this.styleClassComboBox.getSelectedItem());
        } else {
            this.attributes.removeAttribute(HTML.Attribute.CLASS);
        }
        return this.attributes;
    }

    public Color convertStringToColor(String string) {
        return ((HTMLDocument)this.editorPane.getDocument()).getStyleSheet().stringToColor(string);
    }

    public void setEditorPane(JEditorPane editorPane) {
        this.editorPane = editorPane;
    }

    public void setVisible(boolean b) {
        if (b) {
            this.setSize(430, 490);
            this.setLocation((int)((double)this.getParent().getLocationOnScreen().x + this.getParent().getBounds().getWidth() / 2.0 - this.getBounds().getWidth() / 2.0), (int)((double)this.getParent().getLocationOnScreen().y + this.getParent().getBounds().getHeight() / 2.0 - this.getBounds().getHeight() / 2.0));
        }
        super.setVisible(b);
    }

    public static void main(String[] args) {
        new ExtendedFontChooser((Frame)new JFrame(), true).show();
    }
}

