/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import sferyx.administration.editors.HTMLEditor;
import sferyx.common.PluggableComponent;

public class EquationEditorDialog
extends JDialog {
    String lastContent;
    boolean editorNotLoaded = false;
    File imageFile;
    File mathMLFile;
    AttributeSet attributes;
    boolean cancel = false;
    Component editorComponent;
    HTMLEditor htmlEditor;
    private JPanel centralPanel;
    private JPanel southPanel;
    private JButton okButton;
    private JButton cancelButton;

    public EquationEditorDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.loadEquationEditor();
    }

    public EquationEditorDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.loadEquationEditor();
    }

    public EquationEditorDialog(Frame parent, boolean modal, HTMLEditor htmleditor) {
        super(parent, modal);
        this.htmlEditor = htmleditor;
        this.initComponents();
        this.loadEquationEditor();
    }

    public EquationEditorDialog(Dialog parent, boolean modal, HTMLEditor htmleditor) {
        super(parent, modal);
        this.htmlEditor = htmleditor;
        this.initComponents();
        this.loadEquationEditor();
    }

    private void initComponents() {
        this.centralPanel = new JPanel();
        this.southPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setTitle("Equation Editor");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                EquationEditorDialog.this.closeDialog(evt);
            }
        });
        this.centralPanel.setLayout(new BorderLayout());
        this.centralPanel.setBorder(new TitledBorder("Edit Equation"));
        this.getContentPane().add((Component)this.centralPanel, "Center");
        this.okButton.setText("Ok");
        this.okButton.setPreferredSize(new Dimension(100, 26));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EquationEditorDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.southPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setPreferredSize(new Dimension(100, 26));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EquationEditorDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.southPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.southPanel, "South");
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.cancel = true;
        this.lastContent = null;
        this.dispose();
        this.cancel = true;
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.cancel = false;
        if (this.editorNotLoaded) {
            return;
        }
        this.lastContent = (String)((PluggableComponent)((Object)this.editorComponent)).getContent();
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.cancel = true;
        this.lastContent = null;
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
    }

    public String getImageString() {
        if (this.cancel) {
            return null;
        }
        try {
            String content = (String)((PluggableComponent)((Object)this.editorComponent)).getContent();
            this.saveImage();
            String imageFileURL = this.imageFile.toURL().toString();
            return "<img src=\"" + imageFileURL + "\" mathmlcontent=\"" + URLEncoder.encode(content) + "\">";
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public void saveImage() throws Exception {
        Image image = ((PluggableComponent)((Object)this.editorComponent)).getImage();
        short width_ = (short)image.getWidth(null);
        short height_ = (short)image.getHeight(null);
        this.imageFile = File.createTempFile("equation", ".png");
        this.imageFile.deleteOnExit();
        FileOutputStream output = new FileOutputStream(this.imageFile);
        BufferedOutputStream out = new BufferedOutputStream(output);
        String ver = System.getProperty("java.version");
        if (ver != null && ver.startsWith("1.3")) {
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
            encoder.encode((BufferedImage)image);
            out.close();
        } else {
            ImageIO.write((RenderedImage)((BufferedImage)image), "PNG", out);
            output.close();
        }
    }

    public void saveMathMLFile() throws Exception {
        String mathMLString = (String)((PluggableComponent)((Object)this.editorComponent)).getContent();
        this.mathMLFile = File.createTempFile("equation", ".mml");
        this.mathMLFile.deleteOnExit();
        FileOutputStream output = new FileOutputStream(this.mathMLFile);
        BufferedOutputStream out = new BufferedOutputStream(output);
        out.write(mathMLString.getBytes());
        out.close();
    }

    public void insertIntoHTMLEditor(String imageString) {
        if (this.htmlEditor != null) {
            this.htmlEditor.insertImageString(imageString);
        }
    }

    public void setHTMLEditor(HTMLEditor htmlEditor) {
        this.htmlEditor = htmlEditor;
    }

    public void initDialogFields(AttributeSet attribs) {
        if (attribs.getAttribute("mathmlcontent") != null) {
            ((PluggableComponent)((Object)this.editorComponent)).setContent(URLDecoder.decode((String)attribs.getAttribute("mathmlcontent")));
        }
    }

    public void setMathMLContent(String content) {
        ((PluggableComponent)((Object)this.editorComponent)).setContent(content);
    }

    public String getMathMLContent() {
        return this.lastContent;
    }

    public void loadEquationEditor() {
        try {
            Class<?> editorClass = Class.forName("sferyx.math.equationeditor.EquationEditor");
            this.editorComponent = (Component)editorClass.newInstance();
            ((PluggableComponent)((Object)this.editorComponent)).setMainMenuVisible(false);
            this.centralPanel.add(this.editorComponent, "Center");
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.editorNotLoaded = true;
            JOptionPane.showMessageDialog(null, "Unable to load equation editor - " + e.getMessage(), "Error", 0);
        }
    }

    public void setVisible(boolean b) {
        if (b) {
            this.setSize(700, 470);
            this.setLocation((int)((double)this.getParent().getLocationOnScreen().x + Math.abs(this.getParent().getBounds().getWidth() / 2.0 - this.getBounds().getWidth() / 2.0)), (int)((double)this.getParent().getLocationOnScreen().y + Math.abs(this.getParent().getBounds().getHeight() / 2.0 - this.getBounds().getHeight() / 2.0)));
        }
        super.setVisible(b);
    }
}

