/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.html.BlockView;
import javax.swing.text.html.CSS;

public class EnhancedBlockView
extends BlockView {
    Rectangle tempRect = new Rectangle();

    public EnhancedBlockView(Element elem, int axis) {
        super(elem, axis);
    }

    public void paint(Graphics g, Shape allocation) {
        Rectangle alloc = allocation instanceof Rectangle ? (Rectangle)allocation : allocation.getBounds();
        int n = this.getViewCount();
        int x = alloc.x + this.getLeftInset();
        int y = alloc.y + this.getTopInset();
        Rectangle clip = g.getClipBounds();
        for (int i = 0; i < n; ++i) {
            this.tempRect.x = x + this.getOffset(0, i);
            this.tempRect.y = y + this.getOffset(1, i);
            this.tempRect.width = this.getSpan(0, i);
            this.tempRect.height = this.getSpan(1, i);
            if (!this.tempRect.intersects(clip)) continue;
            this.paintChild(g, this.tempRect, i);
        }
    }

    protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements r) {
        float min = 0.0f;
        float pref = 0.0f;
        float max = 0.0f;
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            View v = this.getView(i);
            min += v.getMinimumSpan(axis);
            pref += v.getPreferredSpan(axis);
            max += v.getMaximumSpan(axis);
        }
        if (r == null) {
            r = new SizeRequirements();
        }
        r.alignment = 0.5f;
        r.minimum = (int)min;
        r.preferred = (int)pref;
        r.maximum = (int)max;
        return r;
    }

    protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
        int min = 0;
        long pref = 0L;
        int max = Integer.MAX_VALUE;
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            View v = this.getView(i);
            min = Math.max((int)v.getMinimumSpan(axis), min);
            pref = Math.max((long)((int)v.getPreferredSpan(axis)), pref);
            max = Math.max((int)v.getMaximumSpan(axis), max);
        }
        if (r == null) {
            r = new SizeRequirements();
            r.alignment = 0.5f;
        }
        r.preferred = (int)pref;
        r.minimum = min;
        r.maximum = max;
        return r;
    }

    public int getResizeWeight(int axis) {
        return 1;
    }

    protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        int n = this.getViewCount();
        CSS.Attribute key = axis == 0 ? CSS.Attribute.WIDTH : CSS.Attribute.HEIGHT;
        for (int i = 0; i < n; ++i) {
            View v = this.getView(i);
            int min = (int)v.getMinimumSpan(axis);
            int max = (int)v.getMaximumSpan(axis);
            if (max < targetSpan) {
                float align = v.getAlignment(axis);
                offsets[i] = (int)((float)(targetSpan - max) * align);
                spans[i] = max;
                continue;
            }
            offsets[i] = 0;
            spans[i] = Math.max(min, targetSpan);
        }
    }

    protected void layoutSuperMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans, int i, View v) {
        long minimum = 0L;
        long maximum = 0L;
        long preferred = 0L;
        int n = this.getViewCount();
        spans[i] = (int)v.getPreferredSpan(axis);
        minimum = (long)((float)minimum + v.getMinimumSpan(axis));
        maximum = (long)((float)maximum + v.getMaximumSpan(axis));
        long desiredAdjustment = (long)targetSpan - (preferred += (long)spans[i]);
        float adjustmentFactor = 0.0f;
        if (desiredAdjustment != 0L) {
            float maximumAdjustment;
            float f = maximumAdjustment = desiredAdjustment > 0L ? (float)(maximum - preferred) : (float)(preferred - minimum);
            if (maximumAdjustment == 0.0f) {
                adjustmentFactor = 0.0f;
            } else {
                adjustmentFactor = (float)desiredAdjustment / maximumAdjustment;
                adjustmentFactor = Math.min(adjustmentFactor, 1.0f);
                adjustmentFactor = Math.max(adjustmentFactor, -1.0f);
            }
        }
        boolean totalOffset = false;
    }
}

