/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.TreeNode;
import sferyx.administration.editors.CustomXMLTagsGrammarSpecification;
import sferyx.administration.editors.EditorGapContent;
import sferyx.administration.editors.FoldingView;
import sferyx.administration.editors.HTMLEditor;
import sferyx.administration.editors.HeavyAttributeUndoableEdit;
import sferyx.administration.editors.RubyTag;
import sferyx.administration.editors.SferyxUtilities;
import sferyx.administration.editors.extensions.ElementEditabilityEvaluator;
import sferyx.administration.editors.parser.ParserDelegator;

public class EditorHTMLDocument
extends HTMLDocument {
    String replacementFontFamily = null;
    boolean loading = false;
    public static final Object realClassName = new Object();
    public static final Object realIDName = new Object();
    public Vector selectedCells = new Vector();
    static Hashtable extendedEntityMap = new Hashtable();
    boolean discardAllProprietaryTags = false;
    URL dragResolvePath = null;
    Hashtable allMaps = new Hashtable();
    CustomMap currentMap;
    Stroke mapStroke = new BasicStroke(2.0f);
    Vector externalStyles = new Vector();
    public static final Object sferyxInternalEmbeddedTagsCount;
    int embeddedTagsCount = 0;
    ElementEditabilityEvaluator elementEvaluator = null;

    public EditorHTMLDocument() {
        this((AbstractDocument.Content)new EditorGapContent(4096), new StyleSheet());
        this.buffer = new ElementBuffer((Element)this.createDefaultRoot());
        this.disableImageCache();
    }

    public EditorHTMLDocument(AbstractDocument.Content c, StyleSheet styles) {
        super(c, styles);
        this.buffer = new ElementBuffer((Element)this.createDefaultRoot());
        this.disableImageCache();
    }

    public EditorHTMLDocument(StyleSheet styles) {
        this((AbstractDocument.Content)new EditorGapContent(4096), styles);
        this.buffer = new ElementBuffer((Element)this.createDefaultRoot());
        this.disableImageCache();
    }

    public boolean isLeftToRightDoc(int p0, int p1) {
        int index;
        if (!this.getProperty("i18n").equals(Boolean.TRUE)) {
            return true;
        }
        Element bidiRoot = this.getBidiRootElement();
        Element bidiElem = bidiRoot.getElement(index = bidiRoot.getElementIndex(p0));
        if (bidiElem.getEndOffset() >= p1) {
            AttributeSet bidiAttrs = bidiElem.getAttributes();
            return StyleConstants.getBidiLevel(bidiAttrs) % 2 == 0;
        }
        return true;
    }

    public void disableImageCache() {
    }

    void initI18Entry() {
        Hashtable<Object, Object> properties = this.getDocumentProperties();
        if (properties == null) {
            properties = new Hashtable<Object, Object>();
        }
        ((Dictionary)properties).put("i18n", new Boolean(false));
        this.setDocumentProperties(properties);
    }

    public Element createBranchElement(Element parent, AttributeSet a) {
        return super.createBranchElement(parent, a);
    }

    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        String prev;
        if (offset > this.getBodyElement().getStartOffset() && offset < this.getBodyElement().getEndOffset() && str != null && str.equals(" ") && ((prev = this.getText(offset - 1, 1)).equals(" ") || prev.equals("\u00a0"))) {
            super.insertString(offset, "\u00a0", a);
            return;
        }
        if (offset > this.getBodyElement().getStartOffset() && offset < this.getBodyElement().getEndOffset() && a != null && StyleConstants.getFontFamily(a) != null && StyleConstants.getFontFamily(a).equalsIgnoreCase("symbol") && str.length() == 1 && extendedEntityMap.get("Symbol-" + str.charAt(0)) != null) {
            String symbol = "" + (char)Integer.parseInt((String)extendedEntityMap.get("Symbol-" + str.charAt(0)));
            super.insertString(offset, symbol, a);
            return;
        }
        super.insertString(offset, str, a);
    }

    public void insert(int offset, DefaultStyledDocument.ElementSpec[] data) throws BadLocationException {
        super.insert(offset, data);
    }

    public CustomMap insertNewMap() {
        String mapName = "SferyxMap_" + System.currentTimeMillis();
        SimpleAttributeSet sas = new SimpleAttributeSet();
        sas.addAttribute(HTML.Attribute.NAME, mapName);
        CustomMap newMap = new CustomMap(sas);
        this.allMaps.put("#" + mapName, newMap);
        return newMap;
    }

    public HTMLEditorKit.ParserCallback getReader(int pos) {
        Object desc = this.getProperty("stream");
        if (desc instanceof URL) {
            this.setBase((URL)desc);
        }
        return new EditorHTMLReader(pos);
    }

    public HTMLEditorKit.ParserCallback getReader(int pos, int popDepth, int pushDepth, HTML.Tag insertTag) {
        Object desc = this.getProperty("stream");
        if (desc instanceof URL) {
            this.setBase((URL)desc);
        }
        return new EditorHTMLReader(pos, popDepth, pushDepth, insertTag);
    }

    public AbstractDocument.DefaultDocumentEvent getDefautInsertEvent(Element elem) {
        int offset = elem.getStartOffset();
        int end = elem.getEndOffset();
        int length = end - offset;
        return new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.INSERT);
    }

    public AbstractDocument.DefaultDocumentEvent getDefautRemoveEvent(Element elem) {
        int offset = elem.getStartOffset();
        int end = elem.getEndOffset();
        int length = end - offset;
        return new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.REMOVE);
    }

    public void fireInsertUpdate(AbstractDocument.DefaultDocumentEvent dde) {
        super.fireInsertUpdate(dde);
    }

    public void fireRemoveUpdate(AbstractDocument.DefaultDocumentEvent dde) {
        super.fireRemoveUpdate(dde);
    }

    public void postRemoveUpdate(AbstractDocument.DefaultDocumentEvent dde) {
        super.postRemoveUpdate(dde);
    }

    public AbstractDocument.DefaultDocumentEvent getDefautEvent(Element elem) {
        int offset = elem.getStartOffset();
        int end = elem.getEndOffset();
        int length = end - offset;
        AbstractDocument.DefaultDocumentEvent event = new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.CHANGE);
        return event;
    }

    public void fireUndoableEditUpdate(UndoableEditEvent e) {
        super.fireUndoableEditUpdate(e);
    }

    public void fireChangedUpdate(AbstractDocument.DefaultDocumentEvent changes) {
        super.fireChangedUpdate(changes);
    }

    public Element getCharacterElement(int pos) {
        return super.getCharacterElement(pos);
    }

    public HTMLDocument.HTMLReader.BlockAction getNewBlockAction() {
        return new EditorHTMLReader(0).getBlockAction();
    }

    public HTMLEditorKit.Parser getParser() {
        HTMLEditorKit.Parser parser = super.getParser();
        return parser;
    }

    public Element getBodyElement() {
        Element root = this.getRootElements()[0];
        if (root == null) {
            return null;
        }
        for (int i = 0; i < root.getElementCount(); ++i) {
            Element e = root.getElement(i);
            if (!this.matchNameAttribute(e, HTML.Tag.BODY)) continue;
            return e;
        }
        return null;
    }

    public Element getHeadElement() {
        Element root = this.getRootElements()[0];
        if (root == null) {
            return null;
        }
        for (int i = 0; i < root.getElementCount(); ++i) {
            Element e = root.getElement(i);
            if (!this.matchNameAttribute(e, HTML.Tag.HEAD)) continue;
            return e;
        }
        return null;
    }

    public Element getCharsetElement() {
        Element head = this.getHeadElement();
        if (head == null) {
            return null;
        }
        Element impliedParagraph = head.getElement(0);
        if (impliedParagraph == null) {
            return null;
        }
        for (int i = 0; i < impliedParagraph.getElementCount(); ++i) {
            AttributeSet attribs;
            String httpequiv;
            Element e = impliedParagraph.getElement(i);
            if (!this.matchNameAttribute(e, HTML.Tag.META) || (httpequiv = (String)(attribs = e.getAttributes()).getAttribute(HTML.Attribute.HTTPEQUIV)) == null || !httpequiv.equalsIgnoreCase("Content-Type")) continue;
            String content = (String)attribs.getAttribute(HTML.Attribute.CONTENT);
            return e;
        }
        return null;
    }

    public Element[] getTitleElement() {
        Element head = this.getHeadElement();
        Element[] titleElement = new Element[2];
        int k = 0;
        if (head == null) {
            return null;
        }
        Element impliedParagraph = head.getElement(0);
        if (impliedParagraph == null) {
            return null;
        }
        for (int i = 0; i < impliedParagraph.getElementCount(); ++i) {
            Element e = impliedParagraph.getElement(i);
            if (!this.matchNameAttribute(e, HTML.Tag.TITLE)) continue;
            titleElement[k] = e;
            if (k == 1) break;
            ++k;
        }
        if (k > 0) {
            return titleElement;
        }
        return null;
    }

    protected void create(DefaultStyledDocument.ElementSpec[] data) {
        super.create(data);
    }

    public AbstractDocument.Content getDocContent() {
        return super.getContent();
    }

    public void setElementEditabilityEvaluator(ElementEditabilityEvaluator eee) {
        this.elementEvaluator = eee;
    }

    void setDiscardAllProprietaryTags(boolean discard) {
        this.discardAllProprietaryTags = discard;
        if (this.getParser() != null && this.getParser() instanceof ParserDelegator) {
            ((ParserDelegator)this.getParser()).discardAllProprietaryTags = discard;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setElementAttributes(Element elem, AttributeSet s, boolean replace) {
        try {
            this.lock();
            int offset = elem.getStartOffset();
            int end = elem.getEndOffset();
            int length = end - offset;
            AbstractDocument.DefaultDocumentEvent changes = new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.CHANGE);
            AttributeSet sCopy = s.copyAttributes();
            boolean hasRuns = false;
            MutableAttributeSet attr = (MutableAttributeSet)elem.getAttributes();
            changes.addEdit(new HeavyAttributeUndoableEdit(elem, sCopy, replace));
            if (replace) {
                attr.removeAttributes(attr);
            }
            attr.addAttributes(s);
            ((AbstractDocument.AbstractElement)elem).addAttributes(attr);
            changes.end();
            this.fireChangedUpdate(changes);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttributeFromElements(int offset, int length, Object attribute) {
        try {
            Element run;
            this.lock();
            AbstractDocument.DefaultDocumentEvent changes = new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.CHANGE);
            this.buffer.change(offset, length, changes);
            int lastEnd = Integer.MAX_VALUE;
            int pos = offset;
            while (pos < offset + length && pos != (lastEnd = (run = this.getCharacterElement(pos)).getEndOffset())) {
                SimpleAttributeSet attr = new SimpleAttributeSet(run.getAttributes().copyAttributes());
                attr.removeAttribute(attribute);
                changes.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(run, attr, true));
                ((AbstractDocument.AbstractElement)run).removeAttributes(run.getAttributes());
                ((AbstractDocument.AbstractElement)run).addAttributes(attr);
                pos = lastEnd;
            }
            changes.end();
            this.fireChangedUpdate(changes);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFixedFontFamilyAttribute(int offset, int length, String fontFamily) {
        try {
            Element run;
            this.lock();
            AbstractDocument.DefaultDocumentEvent changes = new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.CHANGE);
            this.buffer.change(offset, length, changes);
            int lastEnd = Integer.MAX_VALUE;
            int pos = offset;
            while (pos < offset + length && pos != (lastEnd = (run = this.getCharacterElement(pos)).getEndOffset())) {
                MutableAttributeSet fontAttr;
                MutableAttributeSet attr = (MutableAttributeSet)run.getAttributes();
                boolean older = false;
                try {
                    String ver = System.getProperty("java.version");
                    if (ver != null && ver.startsWith("1.3")) {
                        older = true;
                    }
                }
                catch (Throwable thorw) {
                    // empty catch block
                }
                if (older && (fontAttr = (MutableAttributeSet)attr.getAttribute(HTML.Tag.FONT)) != null) {
                    MutableAttributeSet copy = (MutableAttributeSet)fontAttr.copyAttributes();
                    attr.removeAttribute(HTML.Tag.FONT);
                    copy.removeAttribute(StyleConstants.NameAttribute);
                    attr.addAttributes(copy);
                }
                StyleConstants.setFontFamily(attr, fontFamily);
                pos = lastEnd;
            }
            changes.end();
            this.fireChangedUpdate(changes);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFixedFontStyleSizeAttribute(int offset, int length, int fontSize) {
        try {
            Element run;
            this.lock();
            AbstractDocument.DefaultDocumentEvent changes = new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.CHANGE);
            this.buffer.change(offset, length, changes);
            int lastEnd = Integer.MAX_VALUE;
            int pos = offset;
            while (pos < offset + length && pos != (lastEnd = (run = this.getCharacterElement(pos)).getEndOffset())) {
                MutableAttributeSet sas;
                MutableAttributeSet attr = (MutableAttributeSet)run.getAttributes();
                boolean older = false;
                try {
                    String ver = System.getProperty("java.version");
                    if (ver != null && ver.startsWith("1.3")) {
                        older = true;
                    }
                }
                catch (Throwable thorw) {
                    // empty catch block
                }
                MutableAttributeSet fontAttr = (MutableAttributeSet)attr.getAttribute(HTML.Tag.FONT);
                if (fontAttr != null) {
                    MutableAttributeSet copy = (MutableAttributeSet)fontAttr.copyAttributes();
                    attr.removeAttribute(HTML.Tag.FONT);
                    copy.removeAttribute(StyleConstants.NameAttribute);
                    attr.addAttributes(copy);
                }
                if ((sas = (MutableAttributeSet)attr.getAttribute(HTML.Attribute.STYLE)) == null) {
                    sas = new SimpleAttributeSet();
                }
                this.getStyleSheet().addCSSAttribute(sas, CSS.Attribute.FONT_SIZE, fontSize + "pt");
                changes.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(run, sas, false));
                attr.addAttribute(HTML.Tag.SPAN, sas);
                pos = lastEnd;
            }
            changes.end();
            this.fireChangedUpdate(changes);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
        }
        catch (Throwable thr) {
            thr.printStackTrace();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFixedFontSizeAttribute(int offset, int length, String fontSize) {
        try {
            Element run;
            this.lock();
            AbstractDocument.DefaultDocumentEvent changes = new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.CHANGE);
            this.buffer.change(offset, length, changes);
            int lastEnd = Integer.MAX_VALUE;
            int pos = offset;
            while (pos < offset + length && pos != (lastEnd = (run = this.getCharacterElement(pos)).getEndOffset())) {
                MutableAttributeSet foAttr;
                MutableAttributeSet spanAttr;
                MutableAttributeSet attr = (MutableAttributeSet)run.getAttributes();
                boolean older = false;
                try {
                    String ver = System.getProperty("java.version");
                    if (ver != null && ver.startsWith("1.3")) {
                        older = true;
                    }
                }
                catch (Throwable thorw) {
                    // empty catch block
                }
                MutableAttributeSet fontAttr = (MutableAttributeSet)attr.getAttribute(HTML.Tag.FONT);
                if (fontAttr != null) {
                    MutableAttributeSet copy = (MutableAttributeSet)fontAttr.copyAttributes();
                    attr.removeAttribute(HTML.Tag.FONT);
                    copy.removeAttribute(StyleConstants.NameAttribute);
                    attr.addAttributes(copy);
                }
                if ((spanAttr = (MutableAttributeSet)attr.getAttribute(HTML.Tag.SPAN)) != null) {
                    spanAttr.removeAttribute(StyleConstants.FontSize);
                    spanAttr.removeAttribute(CSS.Attribute.FONT_SIZE);
                }
                if ((foAttr = (MutableAttributeSet)attr.getAttribute(HTML.Tag.FONT)) != null) {
                    foAttr.removeAttribute(StyleConstants.FontSize);
                    foAttr.removeAttribute(CSS.Attribute.FONT_SIZE);
                }
                attr.removeAttribute(StyleConstants.FontSize);
                try {
                    this.getStyleSheet().addCSSAttribute(attr, CSS.Attribute.FONT_SIZE, fontSize);
                }
                catch (Throwable thr) {
                    thr.printStackTrace();
                }
                pos = lastEnd;
            }
            changes.end();
            this.fireChangedUpdate(changes);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseFixedFontSizeAttribute(int offset, int length, int fontSize) {
        try {
            Element run;
            this.lock();
            AbstractDocument.DefaultDocumentEvent changes = new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.CHANGE);
            this.buffer.change(offset, length, changes);
            int lastEnd = Integer.MAX_VALUE;
            int pos = offset;
            while (pos < offset + length && pos != (lastEnd = (run = this.getCharacterElement(pos)).getEndOffset())) {
                MutableAttributeSet foAttr;
                MutableAttributeSet spanAttr;
                MutableAttributeSet attr = (MutableAttributeSet)run.getAttributes();
                boolean older = false;
                try {
                    String ver = System.getProperty("java.version");
                    if (ver != null && ver.startsWith("1.3")) {
                        older = true;
                    }
                }
                catch (Throwable thorw) {
                    // empty catch block
                }
                int size = this.getStyleSheet().getFont(attr).getSize();
                SimpleAttributeSet sas = new SimpleAttributeSet();
                try {
                    this.getStyleSheet().addCSSAttribute(sas, CSS.Attribute.FONT_SIZE, size + fontSize + "");
                    changes.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(run, sas, false));
                }
                catch (Throwable thr) {
                    thr.printStackTrace();
                }
                MutableAttributeSet fontAttr = (MutableAttributeSet)attr.getAttribute(HTML.Tag.FONT);
                if (fontAttr != null) {
                    MutableAttributeSet copy = (MutableAttributeSet)fontAttr.copyAttributes();
                    attr.removeAttribute(HTML.Tag.FONT);
                    copy.removeAttribute(StyleConstants.NameAttribute);
                    attr.addAttributes(copy);
                }
                if ((spanAttr = (MutableAttributeSet)attr.getAttribute(HTML.Tag.SPAN)) != null) {
                    spanAttr.removeAttribute(StyleConstants.FontSize);
                    spanAttr.removeAttribute(CSS.Attribute.FONT_SIZE);
                }
                if ((foAttr = (MutableAttributeSet)attr.getAttribute(HTML.Tag.FONT)) != null) {
                    foAttr.removeAttribute(StyleConstants.FontSize);
                    foAttr.removeAttribute(CSS.Attribute.FONT_SIZE);
                }
                attr.removeAttribute(StyleConstants.FontSize);
                attr.addAttributes(sas);
                pos = lastEnd;
            }
            changes.end();
            this.fireChangedUpdate(changes);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decreaseFixedFontSizeAttribute(int offset, int length, int fontSize) {
        try {
            Element run;
            this.lock();
            AbstractDocument.DefaultDocumentEvent changes = new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.CHANGE);
            this.buffer.change(offset, length, changes);
            int lastEnd = Integer.MAX_VALUE;
            int pos = offset;
            while (pos < offset + length && pos != (lastEnd = (run = this.getCharacterElement(pos)).getEndOffset())) {
                MutableAttributeSet foAttr;
                MutableAttributeSet spanAttr;
                MutableAttributeSet attr = (MutableAttributeSet)run.getAttributes();
                boolean older = false;
                try {
                    String ver = System.getProperty("java.version");
                    if (ver != null && ver.startsWith("1.3")) {
                        older = true;
                    }
                }
                catch (Throwable thorw) {
                    // empty catch block
                }
                int size = this.getStyleSheet().getFont(attr).getSize();
                SimpleAttributeSet sas = new SimpleAttributeSet();
                try {
                    if (size > 8) {
                        this.getStyleSheet().addCSSAttribute(sas, CSS.Attribute.FONT_SIZE, size - fontSize + "");
                    } else {
                        this.getStyleSheet().addCSSAttribute(sas, CSS.Attribute.FONT_SIZE, size + "");
                    }
                    changes.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(run, sas, false));
                }
                catch (Throwable thr) {
                    thr.printStackTrace();
                }
                MutableAttributeSet fontAttr = (MutableAttributeSet)attr.getAttribute(HTML.Tag.FONT);
                if (fontAttr != null) {
                    MutableAttributeSet copy = (MutableAttributeSet)fontAttr.copyAttributes();
                    attr.removeAttribute(HTML.Tag.FONT);
                    copy.removeAttribute(StyleConstants.NameAttribute);
                    attr.addAttributes(copy);
                }
                if ((spanAttr = (MutableAttributeSet)attr.getAttribute(HTML.Tag.SPAN)) != null) {
                    spanAttr.removeAttribute(StyleConstants.FontSize);
                    spanAttr.removeAttribute(CSS.Attribute.FONT_SIZE);
                }
                if ((foAttr = (MutableAttributeSet)attr.getAttribute(HTML.Tag.FONT)) != null) {
                    foAttr.removeAttribute(StyleConstants.FontSize);
                    foAttr.removeAttribute(CSS.Attribute.FONT_SIZE);
                }
                attr.removeAttribute(StyleConstants.FontSize);
                attr.addAttributes(sas);
                pos = lastEnd;
            }
            changes.end();
            this.fireChangedUpdate(changes);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFixedFontSizeAttribute(int offset, int length, int fontSize) {
        try {
            Element run;
            this.lock();
            AbstractDocument.DefaultDocumentEvent changes = new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.CHANGE);
            this.buffer.change(offset, length, changes);
            int lastEnd = Integer.MAX_VALUE;
            int pos = offset;
            while (pos < offset + length && pos != (lastEnd = (run = this.getCharacterElement(pos)).getEndOffset())) {
                MutableAttributeSet fontAttr;
                MutableAttributeSet attr = (MutableAttributeSet)run.getAttributes();
                boolean older = false;
                try {
                    String ver = System.getProperty("java.version");
                    if (ver != null && ver.startsWith("1.3")) {
                        older = true;
                    }
                }
                catch (Throwable thorw) {
                    // empty catch block
                }
                if (older && (fontAttr = (MutableAttributeSet)attr.getAttribute(HTML.Tag.FONT)) != null) {
                    MutableAttributeSet copy = (MutableAttributeSet)fontAttr.copyAttributes();
                    attr.removeAttribute(HTML.Tag.FONT);
                    copy.removeAttribute(StyleConstants.NameAttribute);
                    attr.addAttributes(copy);
                }
                StyleConstants.setFontSize(attr, fontSize);
                pos = lastEnd;
            }
            changes.end();
            this.fireChangedUpdate(changes);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
        }
        finally {
            this.unlock();
        }
    }

    public String printAttributeSet(MutableAttributeSet as) {
        String s = "";
        Enumeration<?> names = as.getAttributeNames();
        while (names.hasMoreElements()) {
            Object key = names.nextElement();
            Object value = as.getAttribute(key);
            if (value instanceof AttributeSet) {
                s = s + key + "=**AttributeSet** ";
                s = s + "\n==Inner Set==>" + this.printAttributeSet((MutableAttributeSet)value);
                continue;
            }
            s = s + key + "=" + value + " ";
        }
        return s;
    }

    public int getIndexForFontSize(int fontSize) {
        int index = 3;
        if (fontSize < 10) {
            index = 1;
        } else if (10 <= fontSize && fontSize < 12) {
            index = 2;
        } else if (12 <= fontSize && fontSize < 14) {
            index = 3;
        } else if (14 <= fontSize && fontSize < 18) {
            index = 4;
        } else if (18 <= fontSize && fontSize < 24) {
            index = 5;
        } else if (24 <= fontSize && fontSize < 36) {
            index = 6;
        } else if (36 <= fontSize) {
            index = 7;
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFixedColorAttribute(int offset, int length, Object attribute, Object value) {
        try {
            Element run;
            this.lock();
            AbstractDocument.DefaultDocumentEvent changes = new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.CHANGE);
            this.buffer.change(offset, length, changes);
            int lastEnd = Integer.MAX_VALUE;
            int pos = offset;
            while (pos < offset + length && pos != (lastEnd = (run = this.getCharacterElement(pos)).getEndOffset())) {
                MutableAttributeSet attr = (MutableAttributeSet)run.getAttributes();
                MutableAttributeSet fontAttr = (MutableAttributeSet)attr.getAttribute(HTML.Tag.FONT);
                if (fontAttr != null) {
                    MutableAttributeSet copy = (MutableAttributeSet)fontAttr.copyAttributes();
                    attr.removeAttribute(HTML.Tag.FONT);
                    copy.removeAttribute(StyleConstants.NameAttribute);
                    attr.addAttributes(copy);
                    if (fontAttr.getAttribute(HTML.Attribute.CLASS) != null) {
                        SimpleAttributeSet attribs_ = new SimpleAttributeSet();
                        attribs_.addAttribute("class", fontAttr.getAttribute(HTML.Attribute.CLASS));
                        attr.addAttributes(attribs_);
                    }
                }
                SimpleAttributeSet sas = new SimpleAttributeSet();
                StyleConstants.setForeground(sas, (Color)value);
                changes.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(run, sas, false));
                attr.addAttributes(sas);
                pos = lastEnd;
            }
            changes.end();
            this.fireChangedUpdate(changes);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetFixedBoldAttribute(int offset, int length) {
        try {
            Element run;
            this.lock();
            AbstractDocument.DefaultDocumentEvent changes = new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.CHANGE);
            this.buffer.change(offset, length, changes);
            int lastEnd = Integer.MAX_VALUE;
            int pos = offset;
            while (pos < offset + length && pos != (lastEnd = (run = this.getCharacterElement(pos)).getEndOffset())) {
                MutableAttributeSet attr = (MutableAttributeSet)run.getAttributes();
                SimpleAttributeSet sas = new SimpleAttributeSet(attr.copyAttributes());
                sas.removeAttribute(CSS.Attribute.FONT_WEIGHT);
                sas.removeAttribute(HTML.Tag.B);
                if (sas.getAttribute(HTML.Tag.SPAN) != null) {
                    ((MutableAttributeSet)sas.getAttribute(HTML.Tag.SPAN)).removeAttribute(CSS.Attribute.FONT_WEIGHT);
                    if (((MutableAttributeSet)sas.getAttribute(HTML.Tag.SPAN)).getAttributeCount() == 0 || ((MutableAttributeSet)sas.getAttribute(HTML.Tag.SPAN)).getAttributeCount() == 1 && ((MutableAttributeSet)sas.getAttribute(HTML.Tag.SPAN)).getAttribute(sferyxInternalEmbeddedTagsCount) != null) {
                        sas.removeAttribute(HTML.Tag.SPAN);
                    }
                }
                if (sas.getAttribute(HTML.Tag.FONT) != null) {
                    ((MutableAttributeSet)sas.getAttribute(HTML.Tag.FONT)).removeAttribute(CSS.Attribute.FONT_WEIGHT);
                    if (((MutableAttributeSet)sas.getAttribute(HTML.Tag.FONT)).getAttributeCount() == 0) {
                        sas.removeAttribute(HTML.Tag.FONT);
                    }
                }
                changes.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(run, sas, false));
                attr.removeAttributes(attr);
                attr.addAttributes(sas);
                pos = lastEnd;
            }
            changes.end();
            this.fireChangedUpdate(changes);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetFixedColorAttribute(int offset, int length) {
        try {
            Element run;
            this.lock();
            AbstractDocument.DefaultDocumentEvent changes = new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.CHANGE);
            this.buffer.change(offset, length, changes);
            int lastEnd = Integer.MAX_VALUE;
            int pos = offset;
            while (pos < offset + length && pos != (lastEnd = (run = this.getCharacterElement(pos)).getEndOffset())) {
                MutableAttributeSet attr = (MutableAttributeSet)run.getAttributes();
                SimpleAttributeSet sas = new SimpleAttributeSet(attr.copyAttributes());
                sas.removeAttribute(CSS.Attribute.COLOR);
                sas.removeAttribute(StyleConstants.Foreground);
                if (sas.getAttribute(HTML.Tag.SPAN) != null) {
                    ((MutableAttributeSet)sas.getAttribute(HTML.Tag.SPAN)).removeAttribute(CSS.Attribute.COLOR);
                    ((MutableAttributeSet)sas.getAttribute(HTML.Tag.SPAN)).removeAttribute(StyleConstants.Foreground);
                    if (((MutableAttributeSet)sas.getAttribute(HTML.Tag.SPAN)).getAttributeCount() == 0 || ((MutableAttributeSet)sas.getAttribute(HTML.Tag.SPAN)).getAttributeCount() == 1 && ((MutableAttributeSet)sas.getAttribute(HTML.Tag.SPAN)).getAttribute(sferyxInternalEmbeddedTagsCount) != null) {
                        sas.removeAttribute(HTML.Tag.SPAN);
                    }
                }
                if (sas.getAttribute(HTML.Tag.FONT) != null) {
                    ((MutableAttributeSet)sas.getAttribute(HTML.Tag.FONT)).removeAttribute(CSS.Attribute.COLOR);
                    ((MutableAttributeSet)sas.getAttribute(HTML.Tag.FONT)).removeAttribute(HTML.Attribute.COLOR);
                    ((MutableAttributeSet)sas.getAttribute(HTML.Tag.FONT)).removeAttribute(HTML.Attribute.COLOR);
                    ((MutableAttributeSet)sas.getAttribute(HTML.Tag.FONT)).removeAttribute(StyleConstants.Foreground);
                    if (((MutableAttributeSet)sas.getAttribute(HTML.Tag.FONT)).getAttributeCount() == 0 || ((MutableAttributeSet)sas.getAttribute(HTML.Tag.FONT)).getAttributeCount() == 1 && ((MutableAttributeSet)sas.getAttribute(HTML.Tag.FONT)).getAttribute(sferyxInternalEmbeddedTagsCount) != null) {
                        sas.removeAttribute(HTML.Tag.FONT);
                    }
                }
                changes.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(run, sas, false));
                attr.removeAttributes(attr);
                attr.addAttributes(sas);
                pos = lastEnd;
            }
            changes.end();
            this.fireChangedUpdate(changes);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetFixedBackgroundColorAttribute(int offset, int length) {
        try {
            Element run;
            this.lock();
            AbstractDocument.DefaultDocumentEvent changes = new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.CHANGE);
            this.buffer.change(offset, length, changes);
            int lastEnd = Integer.MAX_VALUE;
            int pos = offset;
            while (pos < offset + length && pos != (lastEnd = (run = this.getCharacterElement(pos)).getEndOffset())) {
                MutableAttributeSet attr = (MutableAttributeSet)run.getAttributes();
                SimpleAttributeSet sas = new SimpleAttributeSet(attr.copyAttributes());
                sas.removeAttribute(CSS.Attribute.BACKGROUND_COLOR);
                sas.removeAttribute(StyleConstants.Background);
                if (sas.getAttribute(HTML.Tag.SPAN) != null) {
                    ((MutableAttributeSet)sas.getAttribute(HTML.Tag.SPAN)).removeAttribute(CSS.Attribute.BACKGROUND_COLOR);
                    ((MutableAttributeSet)sas.getAttribute(HTML.Tag.SPAN)).removeAttribute(StyleConstants.Background);
                    if (((MutableAttributeSet)sas.getAttribute(HTML.Tag.SPAN)).getAttributeCount() == 0 || ((MutableAttributeSet)sas.getAttribute(HTML.Tag.SPAN)).getAttributeCount() == 1 && ((MutableAttributeSet)sas.getAttribute(HTML.Tag.SPAN)).getAttribute(sferyxInternalEmbeddedTagsCount) != null) {
                        sas.removeAttribute(HTML.Tag.SPAN);
                    }
                }
                if (sas.getAttribute(HTML.Tag.FONT) != null) {
                    ((MutableAttributeSet)sas.getAttribute(HTML.Tag.FONT)).removeAttribute(CSS.Attribute.BACKGROUND_COLOR);
                    ((MutableAttributeSet)sas.getAttribute(HTML.Tag.FONT)).removeAttribute(StyleConstants.Background);
                    if (((MutableAttributeSet)sas.getAttribute(HTML.Tag.FONT)).getAttributeCount() == 0) {
                        sas.removeAttribute(HTML.Tag.FONT);
                    }
                }
                changes.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(run, sas, false));
                attr.removeAttributes(attr);
                attr.addAttributes(sas);
                pos = lastEnd;
            }
            changes.end();
            this.fireChangedUpdate(changes);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFixedBackgroundColorAttribute(int offset, int length, Object attribute, Object value) {
        try {
            Element run;
            this.lock();
            AbstractDocument.DefaultDocumentEvent changes = new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.CHANGE);
            this.buffer.change(offset, length, changes);
            int lastEnd = Integer.MAX_VALUE;
            int pos = offset;
            while (pos < offset + length && pos != (lastEnd = (run = this.getCharacterElement(pos)).getEndOffset())) {
                MutableAttributeSet attr = (MutableAttributeSet)run.getAttributes();
                MutableAttributeSet fontAttr = (MutableAttributeSet)attr.getAttribute(HTML.Tag.FONT);
                if (fontAttr != null) {
                    MutableAttributeSet copy = (MutableAttributeSet)fontAttr.copyAttributes();
                    attr.removeAttribute(HTML.Tag.FONT);
                    copy.removeAttribute(StyleConstants.NameAttribute);
                    attr.addAttributes(copy);
                    if (fontAttr.getAttribute(HTML.Attribute.CLASS) != null) {
                        SimpleAttributeSet attribs_ = new SimpleAttributeSet();
                        attribs_.addAttribute("class", fontAttr.getAttribute(HTML.Attribute.CLASS));
                        attr.addAttributes(attribs_);
                    }
                }
                SimpleAttributeSet sas = new SimpleAttributeSet();
                sas.addAttribute(CSS.Attribute.BACKGROUND_COLOR, this.colorToString((Color)value));
                if (attr.getAttribute(CSS.Attribute.BACKGROUND) != null && attr.isDefined(CSS.Attribute.BACKGROUND)) {
                    sas.addAttribute(CSS.Attribute.BACKGROUND, this.colorToString((Color)value));
                }
                changes.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(run, sas, false));
                attr.addAttribute(CSS.Attribute.BACKGROUND_COLOR, this.colorToString((Color)value));
                if (attr.getAttribute(CSS.Attribute.BACKGROUND) != null && attr.isDefined(CSS.Attribute.BACKGROUND)) {
                    attr.addAttribute(CSS.Attribute.BACKGROUND, this.colorToString((Color)value));
                }
                pos = lastEnd;
            }
            changes.end();
            this.fireChangedUpdate(changes);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
        }
        finally {
            this.unlock();
        }
    }

    String colorToString(Color color) {
        String colorString = Integer.toHexString(color.getRGB());
        if (colorString.length() == 8) {
            colorString = colorString.substring(2);
        }
        return "#" + colorString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFixedUnderlineAttribute(int offset, int length, boolean value) {
        try {
            Element run;
            this.lock();
            AbstractDocument.DefaultDocumentEvent changes = new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.CHANGE);
            this.buffer.change(offset, length, changes);
            int lastEnd = Integer.MAX_VALUE;
            int pos = offset;
            while (pos < offset + length && pos != (lastEnd = (run = this.getCharacterElement(pos)).getEndOffset())) {
                MutableAttributeSet attr = (MutableAttributeSet)run.getAttributes();
                StyleConstants.setUnderline(attr, value);
                pos = lastEnd;
            }
            changes.end();
            this.fireChangedUpdate(changes);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFixedStrikethroughAttribute(int offset, int length, boolean value) {
        try {
            Element run;
            this.lock();
            AbstractDocument.DefaultDocumentEvent changes = new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.CHANGE);
            this.buffer.change(offset, length, changes);
            int lastEnd = Integer.MAX_VALUE;
            int pos = offset;
            while (pos < offset + length && pos != (lastEnd = (run = this.getCharacterElement(pos)).getEndOffset())) {
                MutableAttributeSet attr = (MutableAttributeSet)run.getAttributes();
                StyleConstants.setStrikeThrough(attr, value);
                pos = lastEnd;
            }
            changes.end();
            this.fireChangedUpdate(changes);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFixedSuperscriptAttribute(int offset, int length, boolean value) {
        try {
            Element run;
            this.lock();
            AbstractDocument.DefaultDocumentEvent changes = new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.CHANGE);
            this.buffer.change(offset, length, changes);
            int lastEnd = Integer.MAX_VALUE;
            int pos = offset;
            while (pos < offset + length && pos != (lastEnd = (run = this.getCharacterElement(pos)).getEndOffset())) {
                MutableAttributeSet attr = (MutableAttributeSet)run.getAttributes();
                StyleConstants.setSuperscript(attr, value);
                pos = lastEnd;
            }
            changes.end();
            this.fireChangedUpdate(changes);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFixedSubscriptAttribute(int offset, int length, boolean value) {
        try {
            Element run;
            this.lock();
            AbstractDocument.DefaultDocumentEvent changes = new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.CHANGE);
            this.buffer.change(offset, length, changes);
            int lastEnd = Integer.MAX_VALUE;
            int pos = offset;
            while (pos < offset + length && pos != (lastEnd = (run = this.getCharacterElement(pos)).getEndOffset())) {
                MutableAttributeSet attr = (MutableAttributeSet)run.getAttributes();
                StyleConstants.setSubscript(attr, value);
                pos = lastEnd;
            }
            changes.end();
            this.fireChangedUpdate(changes);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFontSizeAttribute(int offset, int length) {
        try {
            Element run;
            this.lock();
            AbstractDocument.DefaultDocumentEvent changes = new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.CHANGE);
            this.buffer.change(offset, length, changes);
            int lastEnd = Integer.MAX_VALUE;
            int pos = offset;
            while (pos < offset + length && pos != (lastEnd = (run = this.getCharacterElement(pos)).getEndOffset())) {
                MutableAttributeSet attr = (MutableAttributeSet)run.getAttributes();
                attr.removeAttribute(StyleConstants.FontSize);
                attr.removeAttribute(CSS.Attribute.FONT_SIZE);
                if (attr.getAttribute(HTML.Tag.SPAN) != null && (((MutableAttributeSet)attr.getAttribute(HTML.Tag.SPAN)).getAttributeCount() == 0 || ((MutableAttributeSet)attr.getAttribute(HTML.Tag.SPAN)).getAttributeCount() == 1 && ((MutableAttributeSet)attr.getAttribute(HTML.Tag.SPAN)).getAttribute(sferyxInternalEmbeddedTagsCount) != null)) {
                    attr.removeAttribute(HTML.Tag.SPAN);
                }
                pos = lastEnd;
            }
            changes.end();
            this.fireChangedUpdate(changes);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFontAttribute(int offset, int length) {
        try {
            Element run;
            this.lock();
            AbstractDocument.DefaultDocumentEvent changes = new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.CHANGE);
            this.buffer.change(offset, length, changes);
            int lastEnd = Integer.MAX_VALUE;
            int pos = offset;
            while (pos < offset + length && pos != (lastEnd = (run = this.getCharacterElement(pos)).getEndOffset())) {
                MutableAttributeSet attr = (MutableAttributeSet)run.getAttributes();
                attr.removeAttribute(StyleConstants.FontFamily);
                attr.removeAttribute(CSS.Attribute.FONT_FAMILY);
                if (attr.getAttribute(HTML.Tag.SPAN) != null && (((MutableAttributeSet)attr.getAttribute(HTML.Tag.SPAN)).getAttributeCount() == 0 || ((MutableAttributeSet)attr.getAttribute(HTML.Tag.SPAN)).getAttributeCount() == 1 && ((MutableAttributeSet)attr.getAttribute(HTML.Tag.SPAN)).getAttribute(sferyxInternalEmbeddedTagsCount) != null)) {
                    attr.removeAttribute(HTML.Tag.SPAN);
                }
                pos = lastEnd;
            }
            changes.end();
            this.fireChangedUpdate(changes);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnchorAttribute(int offset, int length) {
        try {
            Element run;
            this.lock();
            AbstractDocument.DefaultDocumentEvent changes = new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.CHANGE);
            this.buffer.change(offset, length, changes);
            int lastEnd = Integer.MAX_VALUE;
            int pos = offset;
            while (pos < offset + length && pos != (lastEnd = (run = this.getCharacterElement(pos)).getEndOffset())) {
                MutableAttributeSet attr = (MutableAttributeSet)run.getAttributes();
                attr.removeAttribute(HTML.Tag.A);
                pos = lastEnd;
            }
            changes.end();
            this.fireChangedUpdate(changes);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFixedBoldAttribute(int offset, int length, boolean value) {
        try {
            Element run;
            this.lock();
            AbstractDocument.DefaultDocumentEvent changes = new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.CHANGE);
            this.buffer.change(offset, length, changes);
            int lastEnd = Integer.MAX_VALUE;
            int pos = offset;
            while (pos < offset + length && pos != (lastEnd = (run = this.getCharacterElement(pos)).getEndOffset())) {
                MutableAttributeSet attr = (MutableAttributeSet)run.getAttributes();
                StyleConstants.setBold(attr, value);
                pos = lastEnd;
            }
            changes.end();
            this.fireChangedUpdate(changes);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFixedItalicAttribute(int offset, int length, boolean value) {
        try {
            Element run;
            this.lock();
            AbstractDocument.DefaultDocumentEvent changes = new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.CHANGE);
            this.buffer.change(offset, length, changes);
            int lastEnd = Integer.MAX_VALUE;
            int pos = offset;
            while (pos < offset + length && pos != (lastEnd = (run = this.getCharacterElement(pos)).getEndOffset())) {
                MutableAttributeSet attr = (MutableAttributeSet)run.getAttributes();
                StyleConstants.setItalic(attr, value);
                pos = lastEnd;
            }
            changes.end();
            this.fireChangedUpdate(changes);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
        }
        finally {
            this.unlock();
        }
    }

    public Dictionary getDocumentProperties() {
        Dictionary<Object, Object> documentProperties = super.getDocumentProperties();
        if (documentProperties == null) {
            documentProperties = new Hashtable<Object, Object>(2);
        }
        if (documentProperties.get("title") == null) {
            documentProperties.put("title", "");
        }
        return documentProperties;
    }

    public Element verifyReadonlySectionElement(int pos, String readonly) {
        Element e;
        if (this.elementEvaluator != null && this.elementEvaluator.isElementReadonly(e)) {
            return e;
        }
        for (e = this.getCharacterElement(pos); !this.matchReadOnlyAttribute(e, readonly) && e != null; e = e.getParentElement()) {
        }
        return e;
    }

    public boolean matchReadOnlyAttribute(Element elem, String value) {
        if (elem == null) {
            return false;
        }
        AttributeSet attr = elem.getAttributes();
        String stringValue = (String)attr.getAttribute("readonly");
        if (stringValue == null) {
            stringValue = (String)attr.getAttribute("READONLY");
        }
        if (stringValue == null) {
            AttributeSet spanAttr = (AttributeSet)attr.getAttribute(HTML.Tag.SPAN);
            if (spanAttr == null) {
                spanAttr = (AttributeSet)attr.getAttribute(HTML.Tag.FONT);
            }
            if (spanAttr != null && (stringValue = (String)spanAttr.getAttribute("readonly")) == null) {
                stringValue = (String)spanAttr.getAttribute("readonly");
            }
            if (stringValue == null && (spanAttr = (AttributeSet)attr.getAttribute(HTML.Tag.A)) != null && (stringValue = (String)spanAttr.getAttribute("readonly")) == null) {
                stringValue = (String)spanAttr.getAttribute("readonly");
            }
        } else {
            return stringValue.equals(value) && attr.containsAttribute("readonly", value);
        }
        if (stringValue == null) {
            return false;
        }
        return stringValue.equals(value);
    }

    public Element getTableCellElementForTable(Element tableElement, int pos) {
        Element e;
        if (tableElement == null) {
            return null;
        }
        for (e = this.getTableCellElement(pos); e != null && this.getTableForElement(e) != tableElement; e = e.getParentElement()) {
        }
        return e;
    }

    public Element getTableForElement(Element element) {
        Element e;
        for (e = element; !this.matchNameAttribute(e, HTML.Tag.TABLE) && e != null; e = e.getParentElement()) {
        }
        return e;
    }

    public Element getTableCellElement(int pos) {
        Element e;
        for (e = this.getCharacterElement(pos); !this.matchNameAttribute(e, HTML.Tag.TD) && !this.matchNameAttribute(e, HTML.Tag.TH) && e != null; e = e.getParentElement()) {
        }
        return e;
    }

    public Element getTableRowElement(int pos) {
        Element e;
        for (e = this.getCharacterElement(pos); !this.matchNameAttribute(e, HTML.Tag.TR) && e != null; e = e.getParentElement()) {
        }
        return e;
    }

    public View getClickedFoldingView(int pos, int clickX, int clickY, JEditorPane comp) {
        for (Element e = this.getCharacterElement(pos); e != null && comp != null; e = e.getParentElement()) {
            Rectangle foldingTargetRect;
            View parView = SferyxUtilities.getViewForElement(e, comp);
            if (!(parView instanceof FoldingView) || !(foldingTargetRect = new Rectangle(((FoldingView)parView).foldingSignX, ((FoldingView)parView).foldingSignY, ((FoldingView)parView).foldingSignWidth, ((FoldingView)parView).foldingSignHeight)).contains(clickX, clickY)) continue;
            return parView;
        }
        return null;
    }

    public Element getDivElement(int pos) {
        Element e;
        for (e = this.getCharacterElement(pos); !this.matchNameAttribute(e, HTML.Tag.DIV) && e != null; e = e.getParentElement()) {
        }
        return e;
    }

    public Element getTableElement(int pos) {
        Element e;
        for (e = this.getCharacterElement(pos); !this.matchNameAttribute(e, HTML.Tag.TABLE) && e != null; e = e.getParentElement()) {
        }
        return e;
    }

    public Element getImageElement(int pos) {
        Element e = this.getCharacterElement(pos);
        if (this.matchNameAttribute(e, HTML.Tag.IMG)) {
            return e;
        }
        return null;
    }

    public Element getObjectElement(int pos) {
        Element e = this.getCharacterElement(pos);
        if (this.matchNameAttribute(e, HTML.Tag.OBJECT)) {
            return e;
        }
        if (this.matchNameAttribute(e, HTML.Tag.APPLET)) {
            return e;
        }
        return null;
    }

    public Element getHTMLParagraphElement(int pos) {
        Element e;
        for (e = this.getParagraphElement(pos); !this.matchNameAttribute(e, HTML.Tag.P) && e != null; e = e.getParentElement()) {
        }
        return e;
    }

    public Element getPreElement(int pos) {
        Element e;
        for (e = this.getCharacterElement(pos); !this.matchNameAttribute(e, HTML.Tag.PRE) && e != null; e = e.getParentElement()) {
        }
        return e;
    }

    public Element getFormElement(int pos) {
        Element e;
        for (e = this.getCharacterElement(pos); !this.matchNameAttribute(e, HTML.Tag.FORM) && e != null; e = e.getParentElement()) {
        }
        return e;
    }

    public Element getTopListItemElement(int pos) {
        Element e1 = this.getUnorderedListItemElement(pos);
        Element e2 = this.getOrderedListItemElement(pos);
        if (e1 != null && e2 != null) {
            if (e1.getStartOffset() < e2.getStartOffset()) {
                return e2;
            }
            return e1;
        }
        if (e1 != null) {
            return e1;
        }
        return e2;
    }

    public Element getTopListElement(int pos) {
        Element e1 = this.getUnorderedListElement(pos);
        Element e2 = this.getOrderedListElement(pos);
        if (e1 != null && e2 != null) {
            if (e1.getStartOffset() < e2.getStartOffset()) {
                return e2;
            }
            return e1;
        }
        if (e1 != null) {
            return e1;
        }
        return e2;
    }

    public Element getElementOfType(HTML.Tag tag, int pos) {
        Element e;
        for (e = this.getCharacterElement(pos); !this.matchNameAttribute(e, tag) && e != null; e = e.getParentElement()) {
        }
        return e;
    }

    public Element getUnorderedListElement(int pos) {
        Element e;
        for (e = this.getCharacterElement(pos); !this.matchNameAttribute(e, HTML.Tag.UL) && e != null; e = e.getParentElement()) {
        }
        return e;
    }

    public Element getOrderedListElement(int pos) {
        Element e;
        for (e = this.getCharacterElement(pos); !this.matchNameAttribute(e, HTML.Tag.OL) && e != null; e = e.getParentElement()) {
        }
        return e;
    }

    public Element getOrderedListItemElement(int pos) {
        Element e;
        for (e = this.getCharacterElement(pos); !this.matchNameAttribute(e, HTML.Tag.LI) && e != null; e = e.getParentElement()) {
        }
        return e;
    }

    public Element getUnorderedListItemElement(int pos) {
        Element e;
        for (e = this.getCharacterElement(pos); !this.matchNameAttribute(e, HTML.Tag.LI) && e != null; e = e.getParentElement()) {
        }
        return e;
    }

    public boolean matchNameAttribute(Element elem, HTML.Tag tag) {
        HTML.Tag name;
        if (elem == null) {
            return false;
        }
        AttributeSet attr = elem.getAttributes();
        Object o = attr.getAttribute(StyleConstants.NameAttribute);
        return o instanceof HTML.Tag && (name = (HTML.Tag)o) == tag;
    }

    public Element createLeafElement(Element parent, AttributeSet a, int p0, int p1) {
        if (this.replacementFontFamily != null && a != null && a instanceof MutableAttributeSet) {
            this.getStyleSheet().addCSSAttribute((MutableAttributeSet)a, CSS.Attribute.FONT_FAMILY, this.replacementFontFamily);
        }
        return super.createLeafElement(parent, a, p0, p1);
    }

    public void insertHTMLAtPosition(String html, int offset) throws BadLocationException, IOException {
        HTMLEditorKit.Parser parser;
        if (html != null && (parser = this.getParser()) != null) {
            EditorHTMLReader reader = new EditorHTMLReader(offset);
            parser.parse(new StringReader(html), reader, true);
            reader.flush();
        }
    }

    public void insertAfterEndForPaste(Element elem, String htmlText) throws BadLocationException, IOException {
        Element parent;
        if (elem != null && (parent = elem.getParentElement()) != null) {
            int offset = elem.getEndOffset();
            if (offset > this.getLength()) {
                --offset;
            } else if (elem.isLeaf() && this.getText(offset - 1, 1).charAt(0) == '\n') {
                --offset;
            }
            this.insertHTMLForPaste(parent, offset, htmlText, false);
        }
    }

    public void insertHTMLForPaste(Element parent, int offset, String html, boolean wantsTrailingNewline) throws BadLocationException, IOException {
        HTMLEditorKit.Parser parser;
        if (parent != null && html != null && (parser = this.getParser()) != null) {
            int lastOffset = Math.max(0, offset - 1);
            Element charElement = this.getCharacterElement(lastOffset);
            Element commonParent = parent;
            int pop = 0;
            int push = 0;
            if (parent.getStartOffset() > lastOffset) {
                while (commonParent != null && commonParent.getStartOffset() > lastOffset) {
                    commonParent = commonParent.getParentElement();
                    ++push;
                }
                if (commonParent == null) {
                    throw new BadLocationException("No common parent", offset);
                }
            }
            while (charElement != null && charElement != commonParent) {
                ++pop;
                charElement = charElement.getParentElement();
            }
            if (charElement != null) {
                if (SferyxUtilities.matchNameAttribute(parent, HTML.Tag.IMPLIED)) {
                    // empty if block
                }
                EditorHTMLReader reader = new EditorHTMLReader(offset, 0, 0, HTML.Tag.BR);
                reader.pasting = true;
                parser.parse(new StringReader(html), reader, true);
                reader.flush();
            }
        }
    }

    public void insertHTMLInternally(Element parent, int offset, String html, boolean wantsTrailingNewline) throws BadLocationException, IOException {
        HTMLEditorKit.Parser parser;
        if (parent != null && html != null && (parser = this.getParser()) != null) {
            int lastOffset = Math.max(0, offset - 1);
            Element charElement = this.getCharacterElement(lastOffset);
            Element commonParent = parent;
            int pop = 0;
            int push = 0;
            if (parent.getStartOffset() > lastOffset) {
                while (commonParent != null && commonParent.getStartOffset() > lastOffset) {
                    commonParent = commonParent.getParentElement();
                    ++push;
                }
                if (commonParent == null) {
                    throw new BadLocationException("No common parent", offset);
                }
            }
            while (charElement != null && charElement != commonParent) {
                ++pop;
                charElement = charElement.getParentElement();
            }
            if (charElement != null) {
                HTMLDocument.HTMLReader reader = new HTMLDocument.HTMLReader(this, offset, pop - 1, push, null);
                try {
                    Field f = reader.getClass().getDeclaredField("insertAfterImplied");
                    f.setAccessible(true);
                    f.set(reader, new Boolean(false));
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
                parser.parse(new StringReader(html), reader, true);
                reader.flush();
            }
        }
    }

    public AbstractDocument.Content getDocumentContent() {
        return this.getContent();
    }

    void internalremove(int offset, int length) throws BadLocationException {
        super.remove(offset, length);
    }

    public void insertUpdate(AbstractDocument.DefaultDocumentEvent e, AttributeSet a) {
        super.insertUpdate(e, a);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void remove(int offset, int length) throws BadLocationException {
        String dotChar;
        int element_case;
        block74: {
            AbstractDocument.DefaultDocumentEvent changes;
            if (length == 1 && this.verifyReadonlySectionElement(offset, "true") != null) {
                return;
            }
            try {
                Element endParent;
                Element endParagraph;
                if (length > 1 && (endParagraph = this.getParagraphElement(offset + length)) != null && endParagraph.getEndOffset() == offset + length + 1 && !SferyxUtilities.matchNameAttribute(endParent = endParagraph.getParentElement(), HTML.Tag.BODY)) {
                    if (endParent != null && endParent.getEndOffset() == offset + length + 1 && endParent.getStartOffset() > offset) {
                        ++length;
                    }
                    if (endParent != null && endParent.getEndOffset() == this.getBodyElement().getEndOffset()) {
                        try {
                            this.insertBeforeEnd(this.getBodyElement(), "<p></p>");
                        }
                        catch (Throwable thr) {
                            thr.printStackTrace();
                        }
                    }
                }
            }
            catch (Throwable thr) {
                // empty catch block
            }
            if (this.getTableCellElement(offset) != null && length == 1 && this.getTableCellElement(offset).getEndOffset() == offset + 1) {
                if (length != 1) return;
                if (this.getParagraphElement(offset) == null) return;
                if (this.getParagraphElement(offset).getParentElement().getElementCount() != 1) return;
                try {
                    Element paragraph = this.getParagraphElement(offset);
                    if (paragraph == null) return;
                    if (!SferyxUtilities.matchNameAttribute(paragraph, HTML.Tag.P)) return;
                    if (paragraph.getStartOffset() + 1 != paragraph.getEndOffset()) return;
                    this.lock();
                    AbstractDocument.DefaultDocumentEvent changes_ = new AbstractDocument.DefaultDocumentEvent(this, offset, 1, DocumentEvent.EventType.CHANGE);
                    this.buffer.change(offset, 1, changes_);
                    changes_.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(paragraph, paragraph.getAttributes().copyAttributes(), true));
                    changes_.end();
                    this.fireChangedUpdate(changes_);
                    this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes_));
                    this.unlock();
                    this.lock();
                    ((AbstractDocument.AbstractElement)paragraph).addAttribute(StyleConstants.NameAttribute, HTML.Tag.IMPLIED);
                    this.unlock();
                    return;
                }
                catch (Throwable thr) {
                    // empty catch block
                }
                return;
            }
            element_case = 0;
            Element elem = this.getParagraphElement(offset);
            Element nextElement = SferyxUtilities.getNextElementFromSameParent(elem);
            dotChar = this.getText(offset, 1);
            try {
                if (elem.getStartOffset() + 1 == elem.getEndOffset() && dotChar.charAt(0) == '\n' && nextElement != null) {
                    this.lock();
                    changes = new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.CHANGE);
                    this.buffer.change(offset, length, changes);
                    changes.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(elem, elem.getAttributes().copyAttributes(), true));
                    changes.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(elem, nextElement.getAttributes().copyAttributes(), true));
                    changes.end();
                    this.fireChangedUpdate(changes);
                    this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
                    this.unlock();
                    this.lock();
                    ((AbstractDocument.AbstractElement)elem).removeAttributes(((AbstractDocument.AbstractElement)elem).getAttributes());
                    ((AbstractDocument.AbstractElement)elem).addAttributes(((AbstractDocument.AbstractElement)nextElement).getAttributes());
                    this.unlock();
                }
            }
            catch (Throwable thr) {
                // empty catch block
            }
            if (elem.getStartOffset() + 1 != elem.getEndOffset() && dotChar.charAt(0) == '\n' && nextElement != null && !this.canJoin(elem, nextElement)) {
                element_case = 1;
                if (SferyxUtilities.isBlockElement(elem) != SferyxUtilities.isBlockElement(nextElement) && !SferyxUtilities.matchNameAttribute(nextElement, HTML.Tag.UL)) {
                    if (!SferyxUtilities.matchNameAttribute(nextElement, HTML.Tag.OL)) return;
                }
                this.lock();
                changes = new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.CHANGE);
                this.buffer.change(offset, length, changes);
                changes.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(nextElement, nextElement.getAttributes().copyAttributes(), true));
                changes.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(nextElement, elem.getAttributes().copyAttributes(), true));
                changes.end();
                this.fireChangedUpdate(changes);
                this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
                this.unlock();
                this.lock();
                ((AbstractDocument.AbstractElement)nextElement).removeAttributes(((AbstractDocument.AbstractElement)nextElement).getAttributes());
                ((AbstractDocument.AbstractElement)nextElement).addAttributes(((AbstractDocument.AbstractElement)elem).getAttributes());
                this.unlock();
            } else if (elem.getStartOffset() + 1 != elem.getEndOffset() && dotChar.charAt(0) == '\n' && nextElement == null && !this.canJoin(elem, nextElement)) {
                element_case = 2;
                Element parentElement = elem.getParentElement();
                Element nextParent = SferyxUtilities.getNextElementFromSameParent(parentElement);
                if (elem.getStartOffset() + 1 == elem.getEndOffset()) return;
                if (dotChar.charAt(0) != '\n') return;
                if (nextParent == null) return;
                if (!SferyxUtilities.isBlockElement(parentElement)) return;
                if (!SferyxUtilities.isBlockElement(nextParent)) return;
                Element firstElementNextParent = nextParent.getElement(0);
                if (firstElementNextParent != null && SferyxUtilities.isBlockElement(firstElementNextParent)) {
                    return;
                }
                this.lock();
                AbstractDocument.DefaultDocumentEvent changes2 = new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.CHANGE);
                this.buffer.change(offset, length, changes2);
                changes2.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(nextParent, nextParent.getAttributes().copyAttributes(), true));
                changes2.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(nextParent, parentElement.getAttributes().copyAttributes(), true));
                changes2.end();
                this.fireChangedUpdate(changes2);
                this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes2));
                this.unlock();
                try {
                    this.lock();
                    ((AbstractDocument.AbstractElement)nextParent).removeAttributes(((AbstractDocument.AbstractElement)nextParent).getAttributes());
                    ((AbstractDocument.AbstractElement)nextParent).addAttributes(((AbstractDocument.AbstractElement)parentElement).getAttributes());
                    this.unlock();
                }
                catch (Throwable thr) {
                    thr.printStackTrace();
                }
                this.lock();
                AbstractDocument.DefaultDocumentEvent changes_ = new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.CHANGE);
                this.buffer.change(offset, length, changes_);
                changes_.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(firstElementNextParent, firstElementNextParent.getAttributes().copyAttributes(), true));
                changes_.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(firstElementNextParent, elem.getAttributes().copyAttributes(), true));
                changes_.end();
                this.fireChangedUpdate(changes_);
                this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes_));
                this.unlock();
                this.lock();
                ((AbstractDocument.AbstractElement)firstElementNextParent).removeAttributes(((AbstractDocument.AbstractElement)firstElementNextParent).getAttributes());
                ((AbstractDocument.AbstractElement)firstElementNextParent).addAttributes(((AbstractDocument.AbstractElement)elem).getAttributes());
                this.unlock();
            } else if (nextElement != null && SferyxUtilities.matchNameAttribute(nextElement, HTML.Tag.TABLE) && dotChar.charAt(0) == '\n') {
                element_case = 4;
                if (elem.getStartOffset() + 1 != elem.getEndOffset() && length == 1) {
                    return;
                }
            } else if (elem.getStartOffset() + 1 != elem.getEndOffset() && dotChar.charAt(0) == '\n' && elem.getName() == nextElement.getName() && HTMLEditor.jvm_version.startsWith("1.3") && elem.getAttributes() != nextElement.getAttributes()) {
                this.lock();
                changes = new AbstractDocument.DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.CHANGE);
                this.buffer.change(offset, length, changes);
                changes.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(nextElement, nextElement.getAttributes().copyAttributes(), true));
                changes.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(nextElement, elem.getAttributes().copyAttributes(), true));
                changes.end();
                this.fireChangedUpdate(changes);
                this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
                this.unlock();
                this.lock();
                ((AbstractDocument.AbstractElement)nextElement).removeAttributes(((AbstractDocument.AbstractElement)nextElement).getAttributes());
                ((AbstractDocument.AbstractElement)nextElement).addAttributes(((AbstractDocument.AbstractElement)elem).getAttributes());
                this.unlock();
            }
            try {
                AbstractDocument.AbstractElement cellElement;
                if (this.getBodyElement() != null) {
                    if (offset < this.getBodyElement().getStartOffset()) return;
                }
                if (offset == this.getBodyElement().getStartOffset() && this.getBodyElement().getEndOffset() - this.getBodyElement().getStartOffset() == 1) {
                    return;
                }
                if (this.getBodyElement() == null) {
                    return;
                }
                if (this.elementEvaluator != null ? this.elementEvaluator.isElementReadonly(this.getCharacterElement(offset)) && !this.elementEvaluator.isElementDeletable(this.getCharacterElement(offset)) : this.verifyReadonlySectionElement(offset, "true") != null) {
                    return;
                }
                if (HTMLEditor.preserveComments) {
                    try {
                        AbstractDocument.AbstractElement currElement = (AbstractDocument.AbstractElement)this.getCharacterElement(offset);
                        if (offset == -1) {
                            return;
                        }
                        if (offset > this.getLength()) return;
                        if (offset + length > this.getLength()) {
                            return;
                        }
                        if (this.matchNameAttribute(currElement, HTML.Tag.COMMENT) || this.matchNameAttribute(currElement, HTML.Tag.SCRIPT) || currElement.getAttributes().getAttribute(StyleConstants.NameAttribute) instanceof HTML.UnknownTag) {
                            int newOffset = offset;
                            if (HTMLEditor.delKeyUsed) {
                                newOffset = currElement.getEndOffset();
                                if (newOffset == offset) {
                                    ++newOffset;
                                }
                            } else {
                                newOffset = currElement.getStartOffset();
                                if (newOffset == offset) {
                                    --newOffset;
                                }
                            }
                            this.remove(newOffset, length);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        return;
                    }
                }
                if (HTMLEditor.mergingCells) {
                    this.removeSelectedTableCells();
                    return;
                }
                if (!this.selectedCells.isEmpty() && !HTMLEditor.delKeyUsed) {
                    AbstractDocument.BranchElement allTableElement = (AbstractDocument.BranchElement)this.getTableElement(offset);
                    if (allTableElement == null && (AbstractDocument.BranchElement)this.getTableElement(offset + length) == null) {
                        super.remove(offset, length);
                        return;
                    }
                    if (allTableElement == null && (AbstractDocument.BranchElement)this.getTableElement(offset + length) != null) {
                        return;
                    }
                    Element startRowElement = this.getTableRowElement(offset);
                    Element endRowElement = this.getTableRowElement(offset + length);
                    int lowestIndex = allTableElement.getIndex((TreeNode)((Object)startRowElement));
                    int highestIndex = allTableElement.getIndex((TreeNode)((Object)endRowElement));
                    for (int i = this.selectedCells.size() - 1; i >= 0; --i) {
                        Element currentRowElement = ((Element)this.selectedCells.elementAt(i)).getParentElement();
                        int currentRowIndex = allTableElement.getIndex((TreeNode)((Object)currentRowElement));
                        if (currentRowIndex < lowestIndex || lowestIndex == -1) {
                            lowestIndex = currentRowIndex;
                            startRowElement = currentRowElement;
                        }
                        if (currentRowIndex <= highestIndex && highestIndex != -1) continue;
                        highestIndex = currentRowIndex;
                        endRowElement = currentRowElement;
                    }
                    if (startRowElement == endRowElement && startRowElement != null) {
                        try {
                            int newOffset = startRowElement.getStartOffset();
                            int endOffset = startRowElement.getEndOffset();
                            int newLenght = endOffset - newOffset;
                            int selCellsNum = this.selectedCells.size();
                            if (selCellsNum != ((AbstractDocument.BranchElement)startRowElement).getElementCount()) return;
                            super.remove(newOffset, newLenght);
                            return;
                        }
                        catch (Exception exc) {
                            exc.printStackTrace();
                        }
                        return;
                    }
                    if (startRowElement != endRowElement && startRowElement != null && endRowElement != null) {
                        try {
                            AbstractDocument.BranchElement tableElement = (AbstractDocument.BranchElement)this.getTableElement(offset);
                            int startRowIndex = tableElement.getIndex((TreeNode)((Object)startRowElement));
                            int endRowIndex = tableElement.getIndex((TreeNode)((Object)endRowElement));
                            int allCellsForRows = 0;
                            for (int i = startRowIndex; i <= endRowIndex; ++i) {
                                AbstractDocument.BranchElement currentRowElement = (AbstractDocument.BranchElement)tableElement.getElement(i);
                                allCellsForRows += currentRowElement.getElementCount();
                            }
                            int selCellsNum = this.selectedCells.size();
                            if (allCellsForRows == selCellsNum) {
                                int newOffset = startRowElement.getStartOffset();
                                int newLenght = endRowElement.getEndOffset() - newOffset;
                                super.remove(newOffset, newLenght);
                                return;
                            }
                            boolean sameColumn = true;
                            int firstCellIndex = -1;
                            for (int i = selCellsNum - 1; i >= 0; --i) {
                                Element currentCell = (Element)this.selectedCells.elementAt(i);
                                AbstractDocument.BranchElement currentRowElement = (AbstractDocument.BranchElement)currentCell.getParentElement();
                                int currCellIndex = currentRowElement.getIndex((TreeNode)((Object)currentCell));
                                if (firstCellIndex == -1) {
                                    firstCellIndex = currCellIndex;
                                    continue;
                                }
                                if (firstCellIndex == currCellIndex) continue;
                                return;
                            }
                            if (!sameColumn) return;
                        }
                        catch (Exception exc) {
                            // empty catch block
                        }
                        return;
                    }
                }
                if ((cellElement = (AbstractDocument.AbstractElement)this.getTableCellElement(offset)) == null) break block74;
                int cellElementEndOffset = cellElement.getEndOffset();
                int cellElementStartOffset = cellElement.getStartOffset();
                int endRemovePosition = offset + length;
                if (cellElementEndOffset != endRemovePosition && cellElementStartOffset != endRemovePosition) break block74;
                Element currentElement = this.getCharacterElement(offset);
                if (this.matchNameAttribute(currentElement, HTML.Tag.IMG)) {
                    try {
                        this.setOuterHTML(currentElement, "&nbsp;");
                        return;
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                    return;
                }
                try {
                    AbstractDocument.DefaultDocumentEvent changes_;
                    if (this.getContent().getString(offset, length).charAt(0) != '\n') {
                        if (this.getUnorderedListItemElement(cellElementEndOffset - 1) != null || this.getOrderedListItemElement(cellElementEndOffset - 1) != null) {
                            this.insertBeforeEnd(cellElement, "<p></p>");
                            super.remove(offset, cellElementEndOffset - offset);
                            Element paragraph = this.getParagraphElement(offset);
                            if (paragraph == null) return;
                            if (!SferyxUtilities.matchNameAttribute(paragraph, HTML.Tag.P)) return;
                            if (paragraph.getStartOffset() + 1 != paragraph.getEndOffset()) return;
                            this.lock();
                            changes_ = new AbstractDocument.DefaultDocumentEvent(this, offset, 1, DocumentEvent.EventType.CHANGE);
                            this.buffer.change(offset, 1, changes_);
                            changes_.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(paragraph, paragraph.getAttributes().copyAttributes(), true));
                            changes_.end();
                            this.fireChangedUpdate(changes_);
                            this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes_));
                            this.unlock();
                            this.lock();
                            ((AbstractDocument.AbstractElement)paragraph).addAttribute(StyleConstants.NameAttribute, HTML.Tag.IMPLIED);
                            this.unlock();
                            return;
                        } else {
                            super.remove(offset, cellElementEndOffset - 1 - offset);
                        }
                        return;
                    } else {
                        if (length != 1) return;
                        if (this.getParagraphElement(offset) == null) return;
                        try {
                            Element paragraph = this.getParagraphElement(offset);
                            if (paragraph == null) return;
                            if (!SferyxUtilities.matchNameAttribute(paragraph, HTML.Tag.P)) return;
                            if (paragraph.getStartOffset() + 1 != paragraph.getEndOffset()) return;
                            this.lock();
                            changes_ = new AbstractDocument.DefaultDocumentEvent(this, offset, 1, DocumentEvent.EventType.CHANGE);
                            this.buffer.change(offset, 1, changes_);
                            changes_.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(paragraph, paragraph.getAttributes().copyAttributes(), true));
                            changes_.end();
                            this.fireChangedUpdate(changes_);
                            this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes_));
                            this.unlock();
                            this.lock();
                            ((AbstractDocument.AbstractElement)paragraph).addAttribute(StyleConstants.NameAttribute, HTML.Tag.IMPLIED);
                            this.unlock();
                            return;
                        }
                        catch (Throwable thr) {}
                    }
                    return;
                }
                catch (Throwable exc) {
                    exc.printStackTrace();
                }
                return;
            }
            catch (Throwable thr) {
                thr.printStackTrace();
            }
        }
        super.remove(offset, length);
        if (element_case != 0 && element_case != 1 && element_case != 3 && element_case != 4 && dotChar.charAt(0) == '\n' && offset < this.getBodyElement().getEndOffset() - 1) {
            SimpleAttributeSet sas = new SimpleAttributeSet();
            sas.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
            sas.addAttribute("CR", "true");
            this.insertString(offset, "\n", sas);
            super.remove(offset, 1);
        }
        if (length > 1 && offset > 0 && this.getTopListItemElement(offset) == null) {
            Element paragraphElement = this.getParagraphElement(offset - 1);
            Element nextParagraphElement = this.getParagraphElement(offset);
            if (nextParagraphElement != null && offset != nextParagraphElement.getStartOffset() && paragraphElement != null && paragraphElement.getEndOffset() - paragraphElement.getStartOffset() > 0 && offset == paragraphElement.getEndOffset() && this.getText(offset, 1).charAt(0) != '\n') {
                SimpleAttributeSet sas = new SimpleAttributeSet();
                sas.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
                sas.addAttribute("CR", "true");
                this.insertString(offset, "\n", sas);
            }
        }
        if (length != 1) return;
        if (this.getParagraphElement(offset) == null) return;
        if (this.getParagraphElement(offset).getParentElement().getElementCount() != 1) return;
        try {
            Element paragraph = this.getParagraphElement(offset);
            if (paragraph == null) return;
            if (!SferyxUtilities.matchNameAttribute(paragraph, HTML.Tag.P)) return;
            if (paragraph.getStartOffset() + 1 != paragraph.getEndOffset()) return;
            this.lock();
            AbstractDocument.DefaultDocumentEvent changes_ = new AbstractDocument.DefaultDocumentEvent(this, offset, 1, DocumentEvent.EventType.CHANGE);
            this.buffer.change(offset, 1, changes_);
            changes_.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(paragraph, paragraph.getAttributes().copyAttributes(), true));
            changes_.end();
            this.fireChangedUpdate(changes_);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes_));
            this.unlock();
            this.lock();
            ((AbstractDocument.AbstractElement)paragraph).addAttribute(StyleConstants.NameAttribute, HTML.Tag.IMPLIED);
            this.unlock();
            return;
        }
        catch (Throwable thr) {
            // empty catch block
        }
    }

    public void removeSelectedTableCells() {
        this.lock();
        Hashtable<AbstractDocument.BranchElement, Integer> rowsToCells = new Hashtable<AbstractDocument.BranchElement, Integer>();
        Vector<AbstractDocument.BranchElement> rowsToBeRemoved = new Vector<AbstractDocument.BranchElement>();
        int selCellsNum = this.selectedCells.size();
        AbstractDocument.AbstractElement tableElement = null;
        for (int i = selCellsNum - 1; i >= 0; --i) {
            Integer cellNum;
            Element currentCell = (Element)this.selectedCells.elementAt(i);
            AbstractDocument.BranchElement currentRowElement = (AbstractDocument.BranchElement)currentCell.getParentElement();
            if (tableElement == null) {
                tableElement = (AbstractDocument.BranchElement)currentRowElement.getParentElement();
            }
            cellNum = (cellNum = (Integer)rowsToCells.get(currentRowElement)) == null ? new Integer(1) : new Integer(cellNum + 1);
            rowsToCells.put(currentRowElement, cellNum);
            int changeOffset = currentCell.getStartOffset();
            int changeLength = currentCell.getEndOffset() - currentCell.getStartOffset();
        }
        Enumeration rowsEnum = rowsToCells.keys();
        while (rowsEnum.hasMoreElements()) {
            AbstractDocument.BranchElement currentRowElement = (AbstractDocument.BranchElement)rowsEnum.nextElement();
            int removedChildCount = (Integer)rowsToCells.get(currentRowElement);
            int oldChildCount = currentRowElement.getElementCount();
            int newChildrenArrayLength = oldChildCount - removedChildCount;
            if (newChildrenArrayLength > 0) {
                Element[] newChildren = new Element[newChildrenArrayLength];
                int newElementsIndex = 0;
                for (int i = 0; i < oldChildCount; ++i) {
                    Element currentChild = currentRowElement.getElement(i);
                    if (this.selectedCells.contains(currentChild)) continue;
                    if (newElementsIndex < newChildrenArrayLength) {
                        newChildren[newElementsIndex] = currentChild;
                    }
                    ++newElementsIndex;
                }
                currentRowElement.replace(0, oldChildCount, newChildren);
                continue;
            }
            rowsToBeRemoved.addElement(currentRowElement);
        }
        if (tableElement != null && rowsToBeRemoved.size() == tableElement.getChildCount()) {
            try {
                this.unlock();
                super.remove(((AbstractDocument.BranchElement)tableElement).getStartOffset(), ((AbstractDocument.BranchElement)tableElement).getEndOffset() - ((AbstractDocument.BranchElement)tableElement).getStartOffset());
                this.selectedCells.removeAllElements();
                return;
            }
            catch (Throwable exc) {
                this.selectedCells.removeAllElements();
                try {
                    this.setOuterHTML(tableElement, "<p>&nbsp;</p>");
                }
                catch (Exception except) {
                    // empty catch block
                }
                this.unlock();
                return;
            }
        }
        if (rowsToBeRemoved.size() > 0) {
            Vector<Element> newTableElementsVector = new Vector<Element>();
            int oldTableChildCount = ((AbstractDocument.BranchElement)tableElement).getElementCount();
            for (int i = 0; i < oldTableChildCount; ++i) {
                Element currentRowChild = ((AbstractDocument.BranchElement)tableElement).getElement(i);
                if (rowsToBeRemoved.contains(currentRowChild)) continue;
                newTableElementsVector.addElement(currentRowChild);
            }
            Element[] newRowChildren = new Element[newTableElementsVector.size()];
            newTableElementsVector.toArray(newRowChildren);
            ((AbstractDocument.BranchElement)tableElement).replace(0, oldTableChildCount, newRowChildren);
        }
        this.selectedCells.removeAllElements();
        this.unlock();
    }

    public void read_lock() {
        try {
            this.readLock();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void read_unlock() {
        try {
            this.readUnlock();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void lock() {
        try {
            this.writeLock();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unlock() {
        try {
            this.writeUnlock();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void getText(int offset, int length, Segment txt) {
        try {
            if (length < 0) {
                return;
            }
            super.getText(offset, length, txt);
        }
        catch (Throwable thrown) {
            // empty catch block
        }
    }

    void checkJoin(int offset, int length) {
        try {
            Element parent = this.getParagraphElement(offset).getParentElement();
            Element left = this.getParagraphElement(offset);
            Element right = this.getParagraphElement(offset + length);
            this.lock();
            Element newElem = this.joinElements(parent, left, right, left.getEndOffset(), right.getStartOffset());
            int elemCount = parent.getElementCount() - 1;
            if (elemCount <= 0) {
                elemCount = 1;
            }
            if (newElem != null) {
                int i;
                Element[] elems = new Element[elemCount];
                int count = 0;
                for (i = 0; i < elems.length; ++i) {
                    Element currElement = parent.getElement(count);
                    if (currElement == left) {
                        elems[i] = newElem;
                        ++count;
                    } else {
                        elems[i] = currElement;
                    }
                    ++count;
                }
                for (i = 0; i < elems.length; ++i) {
                }
                ((AbstractDocument.BranchElement)parent).replace(0, parent.getElementCount(), elems);
                ((AbstractDocument.AbstractElement)parent).dump(System.out, 0);
            }
            this.unlock();
        }
        catch (Throwable thr) {
            thr.printStackTrace();
        }
    }

    Element joinElements(Element p, Element left, Element right, int rmOffs0, int rmOffs1) {
        if (left.isLeaf() && right.isLeaf()) {
            return this.createLeafElement(p, left.getAttributes(), left.getStartOffset(), right.getEndOffset());
        }
        if (!left.isLeaf() && !right.isLeaf()) {
            int i;
            Element to = this.createBranchElement(p, left.getAttributes());
            int ljIndex = left.getElementIndex(left.getEndOffset());
            int rjIndex = right.getElementIndex(right.getStartOffset());
            Element lj = left.getElement(ljIndex);
            Element rj = right.getElement(rjIndex);
            Vector<Element> children = new Vector<Element>();
            for (i = 0; i < left.getElementCount(); ++i) {
                children.addElement(this.clone(to, left.getElement(i)));
            }
            for (i = 0; i < right.getElementCount(); ++i) {
                children.addElement(this.clone(to, right.getElement(i)));
            }
            Object[] c = new Element[children.size()];
            children.copyInto(c);
            ((AbstractDocument.BranchElement)to).replace(0, 0, (Element[])c);
            ((AbstractDocument.AbstractElement)to).dump(System.out, 0);
            return to;
        }
        throw new Error("No support to join leaf element with non-leaf element");
    }

    public Element clone(Element parent, Element clonee) {
        if (clonee.isLeaf()) {
            return this.createLeafElement(parent, clonee.getAttributes(), clonee.getStartOffset(), clonee.getEndOffset());
        }
        Element e = this.createBranchElement(parent, clonee.getAttributes());
        int n = clonee.getElementCount();
        Element[] children = new Element[n];
        for (int i = 0; i < n; ++i) {
            children[i] = this.clone(e, clonee.getElement(i));
        }
        ((AbstractDocument.BranchElement)e).replace(0, 0, children);
        return e;
    }

    boolean canJoin(Element e0, Element e1) {
        boolean leaf1;
        if (e0 == null || e1 == null) {
            return false;
        }
        String name0 = e0.getName();
        String name1 = e1.getName();
        boolean leaf0 = e0.isLeaf();
        if (leaf0 != (leaf1 = e1.isLeaf())) {
            return false;
        }
        if (leaf0) {
            return e0.getAttributes().isEqual(e1.getAttributes());
        }
        if (name0 != null) {
            return name0.equals(name1);
        }
        if (name1 != null) {
            return name1.equals(name0);
        }
        return true;
    }

    Element cloneAsNecessary(Element parent, Element clonee, int rmOffs0, int rmOffs1) {
        if (clonee.isLeaf()) {
            return this.createLeafElement(parent, clonee.getAttributes(), clonee.getStartOffset(), clonee.getEndOffset());
        }
        Element e = this.createBranchElement(parent, clonee.getAttributes());
        int n = clonee.getElementCount();
        ArrayList<Element> childrenList = new ArrayList<Element>(n);
        for (int i = 0; i < n; ++i) {
            Element elem = clonee.getElement(i);
            if (elem.getStartOffset() >= rmOffs0 && elem.getEndOffset() <= rmOffs1) continue;
            childrenList.add(this.cloneAsNecessary(e, elem, rmOffs0, rmOffs1));
        }
        Element[] children = new Element[childrenList.size()];
        children = childrenList.toArray(children);
        ((AbstractDocument.BranchElement)e).replace(0, 0, children);
        return e;
    }

    static {
        extendedEntityMap.put("Symbol-A", "913");
        extendedEntityMap.put("Symbol-a", "945");
        extendedEntityMap.put("Symbol-B", "914");
        extendedEntityMap.put("Symbol-b", "946");
        extendedEntityMap.put("Symbol-C", "935");
        extendedEntityMap.put("Symbol-c", "967");
        extendedEntityMap.put("Symbol-D", "916");
        extendedEntityMap.put("Symbol-d", "948");
        extendedEntityMap.put("Symbol-E", "917");
        extendedEntityMap.put("Symbol-e", "949");
        extendedEntityMap.put("Symbol-H", "919");
        extendedEntityMap.put("Symbol-h", "951");
        extendedEntityMap.put("Symbol-G", "915");
        extendedEntityMap.put("Symbol-g", "947");
        extendedEntityMap.put("Symbol-I", "921");
        extendedEntityMap.put("Symbol-i", "953");
        extendedEntityMap.put("Symbol-K", "922");
        extendedEntityMap.put("Symbol-k", "954");
        extendedEntityMap.put("Symbol-L", "923");
        extendedEntityMap.put("Symbol-l", "955");
        extendedEntityMap.put("Symbol-M", "924");
        extendedEntityMap.put("Symbol-m", "956");
        extendedEntityMap.put("Symbol-N", "925");
        extendedEntityMap.put("Symbol-n", "957");
        extendedEntityMap.put("Symbol-W", "937");
        extendedEntityMap.put("Symbol-w", "969");
        extendedEntityMap.put("Symbol-O", "927");
        extendedEntityMap.put("Symbol-o", "959");
        extendedEntityMap.put("Symbol-F", "934");
        extendedEntityMap.put("Symbol-f", "966");
        extendedEntityMap.put("Symbol-P", "928");
        extendedEntityMap.put("Symbol-p", "960");
        extendedEntityMap.put("Symbol-v", "982");
        extendedEntityMap.put("Symbol-Y", "936");
        extendedEntityMap.put("Symbol-y", "968");
        extendedEntityMap.put("Symbol-R", "929");
        extendedEntityMap.put("Symbol-r", "961");
        extendedEntityMap.put("Symbol-S", "931");
        extendedEntityMap.put("Symbol-s", "963");
        extendedEntityMap.put("Symbol-V", "962");
        extendedEntityMap.put("Symbol-T", "932");
        extendedEntityMap.put("Symbol-t", "964");
        extendedEntityMap.put("Symbol-Q", "920");
        extendedEntityMap.put("Symbol-q", "952");
        extendedEntityMap.put("Symbol-J", "977");
        extendedEntityMap.put("Symbol-161", "978");
        extendedEntityMap.put("Symbol-U", "933");
        extendedEntityMap.put("Symbol-u", "965");
        extendedEntityMap.put("Symbol-X", "926");
        extendedEntityMap.put("Symbol-x", "958");
        extendedEntityMap.put("Symbol-Z", "918");
        extendedEntityMap.put("Symbol-z", "950");
        extendedEntityMap.put("Symbol-j", "981");
        sferyxInternalEmbeddedTagsCount = new Object();
    }

    public class ElementBuffer
    extends DefaultStyledDocument.ElementBuffer
    implements Serializable {
        Element root;
        transient int pos;
        transient int offset;
        transient int length;
        transient int endOffset;
        transient Vector changes;
        transient Stack path;
        transient boolean insertOp;
        transient boolean recreateLeafs;
        transient ElemChanges[] insertPath;
        transient boolean createdFracture;
        transient Element fracturedParent;
        transient Element fracturedChild;
        transient boolean offsetLastIndex;
        transient boolean offsetLastIndexOnReplace;

        public ElementBuffer(Element root) {
            super(EditorHTMLDocument.this, root);
            this.root = root;
            this.changes = new Vector();
            this.path = new Stack();
        }

        public Element getRootElement() {
            return this.root;
        }

        public void insert(int offset, int length, DefaultStyledDocument.ElementSpec[] data, AbstractDocument.DefaultDocumentEvent de) {
            if (length == 0) {
                return;
            }
            this.insertOp = true;
            this.beginEdits(offset, length);
            this.insertUpdate(data);
            this.endEdits(de);
            this.insertOp = false;
        }

        void create(int length, DefaultStyledDocument.ElementSpec[] data, AbstractDocument.DefaultDocumentEvent de) {
            this.insertOp = true;
            this.beginEdits(this.offset, length);
            Element elem = this.root;
            int index = elem.getElementIndex(0);
            while (!elem.isLeaf()) {
                Element child = elem.getElement(index);
                this.push(elem, index);
                elem = child;
                index = elem.getElementIndex(0);
            }
            ElemChanges ec = (ElemChanges)this.path.peek();
            Element child = ec.parent.getElement(ec.index);
            ec.added.addElement(EditorHTMLDocument.this.createLeafElement(ec.parent, child.getAttributes(), EditorHTMLDocument.this.getLength(), child.getEndOffset()));
            ec.removed.addElement(child);
            while (this.path.size() > 1) {
                this.pop();
            }
            int n = data.length;
            AttributeSet newAttrs = null;
            if (n > 0 && data[0].getType() == 1) {
                newAttrs = data[0].getAttributes();
            }
            if (newAttrs == null) {
                newAttrs = SimpleAttributeSet.EMPTY;
            }
            MutableAttributeSet attr = (MutableAttributeSet)this.root.getAttributes();
            de.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(this.root, newAttrs, true));
            attr.removeAttributes(attr);
            attr.addAttributes(newAttrs);
            for (int i = 1; i < n; ++i) {
                this.insertElement(data[i]);
            }
            while (this.path.size() != 0) {
                this.pop();
            }
            this.endEdits(de);
            this.insertOp = false;
        }

        public void remove(int offset, int length, AbstractDocument.DefaultDocumentEvent de) {
            this.beginEdits(offset, length);
            this.removeUpdate();
            this.endEdits(de);
        }

        public void change(int offset, int length, AbstractDocument.DefaultDocumentEvent de) {
            this.beginEdits(offset, length);
            this.changeUpdate();
            this.endEdits(de);
        }

        protected void insertUpdate(DefaultStyledDocument.ElementSpec[] data) {
            ElemChanges change;
            int counter;
            int i;
            Element elem = this.root;
            int index = elem.getElementIndex(this.offset);
            while (!elem.isLeaf()) {
                Element child = elem.getElement(index);
                this.push(elem, child.isLeaf() ? index : index + 1);
                elem = child;
                index = elem.getElementIndex(this.offset);
            }
            this.insertPath = new ElemChanges[this.path.size()];
            this.path.copyInto(this.insertPath);
            this.createdFracture = false;
            this.recreateLeafs = false;
            if (data[0].getType() == 3) {
                this.insertFirstContent(data);
                this.pos += data[0].getLength();
                i = 1;
            } else {
                this.fractureDeepestLeaf(data);
                i = 0;
            }
            int n = data.length;
            while (i < n) {
                this.insertElement(data[i]);
                ++i;
            }
            if (!this.createdFracture) {
                this.fracture(-1);
            }
            while (this.path.size() != 0) {
                this.pop();
            }
            if (this.offsetLastIndex && this.offsetLastIndexOnReplace) {
                ++this.insertPath[this.insertPath.length - 1].index;
            }
            for (counter = this.insertPath.length - 1; counter >= 0; --counter) {
                change = this.insertPath[counter];
                if (change.parent == this.fracturedParent) {
                    change.added.addElement(this.fracturedChild);
                }
                if (change.added.size() <= 0 && change.removed.size() <= 0 || this.changes.contains(change)) continue;
                this.changes.addElement(change);
            }
            if (this.offset == 0 && this.fracturedParent != null && data[0].getType() == 2) {
                for (counter = 0; counter < data.length && data[counter].getType() == 2; ++counter) {
                }
                change = this.insertPath[this.insertPath.length - counter - 1];
                change.removed.insertElementAt(change.parent.getElement(--change.index), 0);
            }
        }

        protected void removeUpdate() {
            this.removeElements(this.root, this.offset, this.offset + this.length);
        }

        protected void changeUpdate() {
            boolean didEnd = this.split(this.offset, this.length);
            if (!didEnd) {
                while (this.path.size() != 0) {
                    this.pop();
                }
                this.split(this.offset + this.length, 0);
            }
            while (this.path.size() != 0) {
                this.pop();
            }
        }

        boolean split(int offs, int len) {
            boolean splitEnd = false;
            Element e = this.root;
            int index = e.getElementIndex(offs);
            while (!e.isLeaf()) {
                this.push(e, index);
                e = e.getElement(index);
                index = e.getElementIndex(offs);
            }
            ElemChanges ec = (ElemChanges)this.path.peek();
            Element child = ec.parent.getElement(ec.index);
            if (child.getStartOffset() < offs && offs < child.getEndOffset()) {
                int index0;
                int index1 = index0 = ec.index;
                if (offs + len < ec.parent.getEndOffset() && len != 0) {
                    index1 = ec.parent.getElementIndex(offs + len);
                    if (index1 == index0) {
                        ec.removed.addElement(child);
                        e = EditorHTMLDocument.this.createLeafElement(ec.parent, child.getAttributes(), child.getStartOffset(), offs);
                        ec.added.addElement(e);
                        e = EditorHTMLDocument.this.createLeafElement(ec.parent, child.getAttributes(), offs, offs + len);
                        ec.added.addElement(e);
                        e = EditorHTMLDocument.this.createLeafElement(ec.parent, child.getAttributes(), offs + len, child.getEndOffset());
                        ec.added.addElement(e);
                        return true;
                    }
                    child = ec.parent.getElement(index1);
                    if (offs + len == child.getStartOffset()) {
                        index1 = index0;
                    }
                    splitEnd = true;
                }
                this.pos = offs;
                child = ec.parent.getElement(index0);
                ec.removed.addElement(child);
                e = EditorHTMLDocument.this.createLeafElement(ec.parent, child.getAttributes(), child.getStartOffset(), this.pos);
                ec.added.addElement(e);
                e = EditorHTMLDocument.this.createLeafElement(ec.parent, child.getAttributes(), this.pos, child.getEndOffset());
                ec.added.addElement(e);
                for (int i = index0 + 1; i < index1; ++i) {
                    child = ec.parent.getElement(i);
                    ec.removed.addElement(child);
                    ec.added.addElement(child);
                }
                if (index1 != index0) {
                    child = ec.parent.getElement(index1);
                    this.pos = offs + len;
                    ec.removed.addElement(child);
                    e = EditorHTMLDocument.this.createLeafElement(ec.parent, child.getAttributes(), child.getStartOffset(), this.pos);
                    ec.added.addElement(e);
                    e = EditorHTMLDocument.this.createLeafElement(ec.parent, child.getAttributes(), this.pos, child.getEndOffset());
                    ec.added.addElement(e);
                }
            }
            return splitEnd;
        }

        void endEdits(AbstractDocument.DefaultDocumentEvent de) {
            int n = this.changes.size();
            for (int i = 0; i < n; ++i) {
                ElemChanges ec = (ElemChanges)this.changes.elementAt(i);
                Object[] removed = new Element[ec.removed.size()];
                ec.removed.copyInto(removed);
                Object[] added = new Element[ec.added.size()];
                ec.added.copyInto(added);
                int index = ec.index;
                ((AbstractDocument.BranchElement)ec.parent).replace(index, removed.length, (Element[])added);
                AbstractDocument.ElementEdit ee = new AbstractDocument.ElementEdit((AbstractDocument.BranchElement)ec.parent, index, (Element[])removed, (Element[])added);
                de.addEdit(ee);
            }
            this.changes.removeAllElements();
            this.path.removeAllElements();
        }

        void beginEdits(int offset, int length) {
            this.offset = offset;
            this.length = length;
            this.endOffset = offset + length;
            this.pos = offset;
            if (this.changes == null) {
                this.changes = new Vector();
            } else {
                this.changes.removeAllElements();
            }
            if (this.path == null) {
                this.path = new Stack();
            } else {
                this.path.removeAllElements();
            }
            this.fracturedParent = null;
            this.fracturedChild = null;
            this.offsetLastIndexOnReplace = false;
            this.offsetLastIndex = false;
        }

        void push(Element e, int index, boolean isFracture) {
            ElemChanges ec = new ElemChanges(e, index, isFracture);
            this.path.push(ec);
        }

        void push(Element e, int index) {
            this.push(e, index, false);
        }

        void pop() {
            Element e;
            ElemChanges ec = (ElemChanges)this.path.peek();
            this.path.pop();
            if (ec.added.size() > 0 || ec.removed.size() > 0) {
                this.changes.addElement(ec);
            } else if (!this.path.isEmpty() && (e = ec.parent).getElementCount() == 0) {
                ec = (ElemChanges)this.path.peek();
                ec.added.removeElement(e);
            }
        }

        void advance(int n) {
            this.pos += n;
        }

        void insertElement(DefaultStyledDocument.ElementSpec es) {
            ElemChanges ec = (ElemChanges)this.path.peek();
            block0 : switch (es.getType()) {
                case 1: {
                    switch (es.getDirection()) {
                        case 5: {
                            Element parent = ec.parent.getElement(ec.index);
                            if (parent.isLeaf()) {
                                if (ec.index + 1 < ec.parent.getElementCount()) {
                                    parent = ec.parent.getElement(ec.index + 1);
                                } else {
                                    throw new Error("Join next to leaf");
                                }
                            }
                            this.push(parent, 0, true);
                            break block0;
                        }
                        case 7: {
                            if (!this.createdFracture) {
                                this.fracture(this.path.size() - 1);
                            }
                            if (!ec.isFracture) {
                                this.push(this.fracturedChild, 0, true);
                                break block0;
                            }
                            this.push(ec.parent.getElement(0), 0, true);
                            break block0;
                        }
                    }
                    Element belem = EditorHTMLDocument.this.createBranchElement(ec.parent, es.getAttributes());
                    ec.added.addElement(belem);
                    this.push(belem, 0);
                    break;
                }
                case 2: {
                    this.pop();
                    break;
                }
                case 3: {
                    int len = es.getLength();
                    if (es.getDirection() != 5) {
                        Element leaf = EditorHTMLDocument.this.createLeafElement(ec.parent, es.getAttributes(), this.pos, this.pos + len);
                        ec.added.addElement(leaf);
                    } else if (!ec.isFracture) {
                        Element first = null;
                        if (this.insertPath != null) {
                            for (int counter = this.insertPath.length - 1; counter >= 0; --counter) {
                                if (this.insertPath[counter] != ec) continue;
                                if (counter == this.insertPath.length - 1) break;
                                first = ec.parent.getElement(ec.index);
                                break;
                            }
                        }
                        if (first == null) {
                            first = ec.parent.getElement(ec.index + 1);
                        }
                        Element leaf = EditorHTMLDocument.this.createLeafElement(ec.parent, first.getAttributes(), this.pos, first.getEndOffset());
                        ec.added.addElement(leaf);
                        ec.removed.addElement(first);
                    } else {
                        Element first = ec.parent.getElement(0);
                        Element leaf = EditorHTMLDocument.this.createLeafElement(ec.parent, first.getAttributes(), this.pos, first.getEndOffset());
                        ec.added.addElement(leaf);
                        ec.removed.addElement(first);
                    }
                    this.pos += len;
                }
            }
        }

        boolean removeElements(Element elem, int rmOffs0, int rmOffs1) {
            if (!elem.isLeaf()) {
                int index0 = elem.getElementIndex(rmOffs0);
                int index1 = elem.getElementIndex(rmOffs1);
                this.push(elem, index0);
                ElemChanges ec = (ElemChanges)this.path.peek();
                if (index0 == index1) {
                    Element child0 = elem.getElement(index0);
                    if (rmOffs0 <= child0.getStartOffset() && rmOffs1 >= child0.getEndOffset()) {
                        ec.removed.addElement(child0);
                    } else if (this.removeElements(child0, rmOffs0, rmOffs1)) {
                        ec.removed.addElement(child0);
                    }
                } else {
                    boolean containsOffs1;
                    Element child0 = elem.getElement(index0);
                    Element child1 = elem.getElement(index1);
                    boolean bl = containsOffs1 = rmOffs1 < elem.getEndOffset();
                    if (containsOffs1 && this.canJoin(child0, child1)) {
                        for (int i = index0; i <= index1; ++i) {
                            ec.removed.addElement(elem.getElement(i));
                        }
                        Element e = this.join(elem, child0, child1, rmOffs0, rmOffs1);
                        ec.added.addElement(e);
                    } else {
                        int rmIndex0 = index0 + 1;
                        int rmIndex1 = index1 - 1;
                        if (child0.getStartOffset() == rmOffs0 || index0 == 0 && child0.getStartOffset() > rmOffs0 && child0.getEndOffset() <= rmOffs1) {
                            child0 = null;
                            rmIndex0 = index0;
                        }
                        if (!containsOffs1) {
                            child1 = null;
                            ++rmIndex1;
                        } else if (child1.getStartOffset() == rmOffs1) {
                            child1 = null;
                        }
                        if (rmIndex0 <= rmIndex1) {
                            ec.index = rmIndex0;
                        }
                        for (int i = rmIndex0; i <= rmIndex1; ++i) {
                            ec.removed.addElement(elem.getElement(i));
                        }
                        if (child0 != null && this.removeElements(child0, rmOffs0, rmOffs1)) {
                            ec.removed.insertElementAt(child0, 0);
                            ec.index = index0;
                        }
                        if (child1 != null && this.removeElements(child1, rmOffs0, rmOffs1)) {
                            ec.removed.addElement(child1);
                        }
                    }
                }
                this.pop();
                if (elem.getElementCount() == ec.removed.size() - ec.added.size()) {
                    return true;
                }
            }
            return false;
        }

        boolean canJoin(Element e0, Element e1) {
            if (e1 != null && e0 != null && e0.getName() != null && e1.getName() != null && e1.getName().equals("li") && e0.getName().equals("li") && (e0.getElement(e0.getElementCount() - 1).getName().equals("ol") || e0.getElement(e0.getElementCount() - 1).getName().equals("ul"))) {
                return false;
            }
            return this.canJoin_(e0, e1);
        }

        boolean canJoin_(Element e0, Element e1) {
            boolean leaf1;
            if (e0 == null || e1 == null) {
                return false;
            }
            boolean leaf0 = e0.isLeaf();
            if (leaf0 != (leaf1 = e1.isLeaf())) {
                return false;
            }
            if (leaf0) {
                return e0.getAttributes().isEqual(e1.getAttributes());
            }
            String name0 = e0.getName();
            String name1 = e1.getName();
            if (name0 != null) {
                return name0.equals(name1);
            }
            if (name1 != null) {
                return name1.equals(name0);
            }
            return true;
        }

        Element join(Element p, Element left, Element right, int rmOffs0, int rmOffs1) {
            if (left.isLeaf() && right.isLeaf()) {
                return EditorHTMLDocument.this.createLeafElement(p, left.getAttributes(), left.getStartOffset(), right.getEndOffset());
            }
            if (!left.isLeaf() && !right.isLeaf()) {
                int i;
                Element rj;
                Element to = EditorHTMLDocument.this.createBranchElement(p, left.getAttributes());
                int ljIndex = left.getElementIndex(rmOffs0);
                int rjIndex = right.getElementIndex(rmOffs1);
                Element lj = left.getElement(ljIndex);
                if (lj.getStartOffset() >= rmOffs0) {
                    lj = null;
                }
                if ((rj = right.getElement(rjIndex)).getStartOffset() == rmOffs1) {
                    rj = null;
                }
                Vector<Element> children = new Vector<Element>();
                for (int i2 = 0; i2 < ljIndex; ++i2) {
                    children.addElement(this.clone(to, left.getElement(i2)));
                }
                if (this.canJoin(lj, rj)) {
                    Element e = this.join(to, lj, rj, rmOffs0, rmOffs1);
                    children.addElement(e);
                } else {
                    if (lj != null) {
                        children.addElement(this.cloneAsNecessary(to, lj, rmOffs0, rmOffs1));
                    }
                    if (rj != null) {
                        children.addElement(this.cloneAsNecessary(to, rj, rmOffs0, rmOffs1));
                    }
                }
                int n = right.getElementCount();
                int n2 = i = rj == null ? rjIndex : rjIndex + 1;
                while (i < n) {
                    children.addElement(this.clone(to, right.getElement(i)));
                    ++i;
                }
                Object[] c = new Element[children.size()];
                children.copyInto(c);
                ((AbstractDocument.BranchElement)to).replace(0, 0, (Element[])c);
                return to;
            }
            throw new Error("No support to join leaf element with non-leaf element");
        }

        public Element clone(Element parent, Element clonee) {
            if (clonee.isLeaf()) {
                return EditorHTMLDocument.this.createLeafElement(parent, clonee.getAttributes(), clonee.getStartOffset(), clonee.getEndOffset());
            }
            Element e = EditorHTMLDocument.this.createBranchElement(parent, clonee.getAttributes());
            int n = clonee.getElementCount();
            Element[] children = new Element[n];
            for (int i = 0; i < n; ++i) {
                children[i] = this.clone(e, clonee.getElement(i));
            }
            ((AbstractDocument.BranchElement)e).replace(0, 0, children);
            return e;
        }

        Element cloneAsNecessary(Element parent, Element clonee, int rmOffs0, int rmOffs1) {
            if (clonee.isLeaf()) {
                return EditorHTMLDocument.this.createLeafElement(parent, clonee.getAttributes(), clonee.getStartOffset(), clonee.getEndOffset());
            }
            Element e = EditorHTMLDocument.this.createBranchElement(parent, clonee.getAttributes());
            int n = clonee.getElementCount();
            ArrayList<Element> childrenList = new ArrayList<Element>(n);
            for (int i = 0; i < n; ++i) {
                Element elem = clonee.getElement(i);
                if (elem.getStartOffset() >= rmOffs0 && elem.getEndOffset() <= rmOffs1) continue;
                childrenList.add(this.cloneAsNecessary(e, elem, rmOffs0, rmOffs1));
            }
            Element[] children = new Element[childrenList.size()];
            children = childrenList.toArray(children);
            ((AbstractDocument.BranchElement)e).replace(0, 0, children);
            return e;
        }

        void fracture(int depth) {
            int cLength = this.insertPath.length;
            int lastIndex = -1;
            boolean needRecreate = this.recreateLeafs;
            ElemChanges lastChange = this.insertPath[cLength - 1];
            boolean childAltered = lastChange.index + 1 < lastChange.parent.getElementCount();
            int deepestAlteredIndex = needRecreate ? cLength : -1;
            int lastAlteredIndex = cLength - 1;
            this.createdFracture = true;
            for (int counter = cLength - 2; counter >= 0; --counter) {
                ElemChanges change = this.insertPath[counter];
                if (change.added.size() > 0 || counter == depth) {
                    lastIndex = counter;
                    if (!needRecreate && childAltered) {
                        needRecreate = true;
                        if (deepestAlteredIndex == -1) {
                            deepestAlteredIndex = lastAlteredIndex + 1;
                        }
                    }
                }
                if (childAltered || change.index >= change.parent.getElementCount()) continue;
                childAltered = true;
                lastAlteredIndex = counter;
            }
            if (needRecreate) {
                if (lastIndex == -1) {
                    lastIndex = cLength - 1;
                }
                this.fractureFrom(this.insertPath, lastIndex, deepestAlteredIndex);
            }
        }

        void fractureFrom(ElemChanges[] changed, int startIndex, int endFractureIndex) {
            ElemChanges change = changed[startIndex];
            int changeLength = changed.length;
            Object child = startIndex + 1 == changeLength ? change.parent.getElement(change.index) : change.parent.getElement(change.index - 1);
            Element newChild = child.isLeaf() ? EditorHTMLDocument.this.createLeafElement(change.parent, child.getAttributes(), Math.max(this.endOffset, child.getStartOffset()), child.getEndOffset()) : EditorHTMLDocument.this.createBranchElement(change.parent, child.getAttributes());
            this.fracturedParent = change.parent;
            this.fracturedChild = newChild;
            Element parent = newChild;
            while (++startIndex < endFractureIndex) {
                Element[] kids;
                int moveStartIndex;
                boolean isEnd = startIndex + 1 == endFractureIndex;
                boolean isEndLeaf = startIndex + 1 == changeLength;
                change = changed[startIndex];
                child = isEnd ? (this.offsetLastIndex || !isEndLeaf ? null : change.parent.getElement(change.index)) : change.parent.getElement(change.index - 1);
                newChild = child != null ? (child.isLeaf() ? EditorHTMLDocument.this.createLeafElement(parent, child.getAttributes(), Math.max(this.endOffset, child.getStartOffset()), child.getEndOffset()) : EditorHTMLDocument.this.createBranchElement(parent, child.getAttributes())) : null;
                int kidsToMove = change.parent.getElementCount() - change.index;
                int kidStartIndex = 1;
                if (newChild == null) {
                    if (isEndLeaf) {
                        --kidsToMove;
                        moveStartIndex = change.index + 1;
                    } else {
                        moveStartIndex = change.index;
                    }
                    kidStartIndex = 0;
                    kids = new Element[kidsToMove];
                } else {
                    if (!isEnd) {
                        ++kidsToMove;
                        moveStartIndex = change.index;
                    } else {
                        moveStartIndex = change.index + 1;
                    }
                    kids = new Element[kidsToMove];
                    kids[0] = newChild;
                }
                for (int counter = kidStartIndex; counter < kidsToMove; ++counter) {
                    Element toMove = change.parent.getElement(moveStartIndex++);
                    kids[counter] = this.recreateFracturedElement(parent, toMove);
                    change.removed.addElement(toMove);
                }
                ((AbstractDocument.BranchElement)parent).replace(0, 0, kids);
                parent = newChild;
            }
        }

        Element recreateFracturedElement(Element parent, Element toDuplicate) {
            if (toDuplicate.isLeaf()) {
                return EditorHTMLDocument.this.createLeafElement(parent, toDuplicate.getAttributes(), Math.max(toDuplicate.getStartOffset(), this.endOffset), toDuplicate.getEndOffset());
            }
            Element newParent = EditorHTMLDocument.this.createBranchElement(parent, toDuplicate.getAttributes());
            int childCount = toDuplicate.getElementCount();
            Element[] newKids = new Element[childCount];
            for (int counter = 0; counter < childCount; ++counter) {
                newKids[counter] = this.recreateFracturedElement(newParent, toDuplicate.getElement(counter));
            }
            ((AbstractDocument.BranchElement)newParent).replace(0, 0, newKids);
            return newParent;
        }

        void fractureDeepestLeaf(DefaultStyledDocument.ElementSpec[] specs) {
            ElemChanges ec = (ElemChanges)this.path.peek();
            Element child = ec.parent.getElement(ec.index);
            if (this.offset != 0) {
                Element newChild = EditorHTMLDocument.this.createLeafElement(ec.parent, child.getAttributes(), child.getStartOffset(), this.offset);
                ec.added.addElement(newChild);
            }
            ec.removed.addElement(child);
            if (child.getEndOffset() != this.endOffset) {
                this.recreateLeafs = true;
            } else {
                this.offsetLastIndex = true;
            }
        }

        void insertFirstContent(DefaultStyledDocument.ElementSpec[] specs) {
            DefaultStyledDocument.ElementSpec firstSpec = specs[0];
            ElemChanges ec = (ElemChanges)this.path.peek();
            Element child = ec.parent.getElement(ec.index);
            int firstEndOffset = this.offset + firstSpec.getLength();
            boolean isOnlyContent = specs.length == 1;
            switch (firstSpec.getDirection()) {
                case 4: {
                    if (child.getEndOffset() != firstEndOffset && !isOnlyContent) {
                        Element newE = EditorHTMLDocument.this.createLeafElement(ec.parent, child.getAttributes(), child.getStartOffset(), firstEndOffset);
                        ec.added.addElement(newE);
                        ec.removed.addElement(child);
                        if (child.getEndOffset() != this.endOffset) {
                            this.recreateLeafs = true;
                            break;
                        }
                        this.offsetLastIndex = true;
                        break;
                    }
                    this.offsetLastIndex = true;
                    this.offsetLastIndexOnReplace = true;
                    break;
                }
                case 5: {
                    if (this.offset == 0) break;
                    Element newE = EditorHTMLDocument.this.createLeafElement(ec.parent, child.getAttributes(), child.getStartOffset(), this.offset);
                    ec.added.addElement(newE);
                    Element nextChild = ec.parent.getElement(ec.index + 1);
                    newE = isOnlyContent ? EditorHTMLDocument.this.createLeafElement(ec.parent, nextChild.getAttributes(), this.offset, nextChild.getEndOffset()) : EditorHTMLDocument.this.createLeafElement(ec.parent, nextChild.getAttributes(), this.offset, firstEndOffset);
                    ec.added.addElement(newE);
                    ec.removed.addElement(child);
                    ec.removed.addElement(nextChild);
                    break;
                }
                default: {
                    Element newE;
                    if (child.getStartOffset() != this.offset) {
                        newE = EditorHTMLDocument.this.createLeafElement(ec.parent, child.getAttributes(), child.getStartOffset(), this.offset);
                        ec.added.addElement(newE);
                    }
                    ec.removed.addElement(child);
                    newE = EditorHTMLDocument.this.createLeafElement(ec.parent, firstSpec.getAttributes(), this.offset, firstEndOffset);
                    ec.added.addElement(newE);
                    if (child.getEndOffset() != this.endOffset) {
                        this.recreateLeafs = true;
                        break;
                    }
                    this.offsetLastIndex = true;
                }
            }
        }

        class ElemChanges {
            Element parent;
            int index;
            Vector added;
            Vector removed;
            boolean isFracture;

            ElemChanges(Element parent, int index, boolean isFracture) {
                this.parent = parent;
                this.index = index;
                this.isFracture = isFracture;
                this.added = new Vector();
                this.removed = new Vector();
            }

            public String toString() {
                return "added: " + this.added + "\nremoved: " + this.removed + "\n";
            }
        }
    }

    public class EditorHTMLReader
    extends HTMLDocument.HTMLReader {
        boolean emptyAnchor;
        AttributeSet styleAttributes;
        boolean implied = false;
        boolean pasting = false;
        boolean afterBodyComments = false;
        AttributeSet lastAttributeSet;
        HTML.Tag lastTag;
        boolean inStyle = false;
        boolean inComment = false;
        boolean addingComment = false;

        public EditorHTMLReader(int offset) {
            super(EditorHTMLDocument.this, offset, 0, 0, null);
            this.registerTag(HTML.Tag.A, new AAction());
            if (HTMLEditor.jvm_older) {
                this.registerTag(HTML.Tag.U, new UnderlineAction());
            }
            this.registerTag(HTML.Tag.B, new BoldAction());
            this.registerTag(HTML.Tag.I, new ItalicAction());
            this.registerTag(HTML.Tag.S, new StrikethroughAction());
            this.registerTag(HTML.Tag.SPAN, new SpanAction());
            this.registerTag(HTML.Tag.FONT, new FontAction());
            this.registerTag(HTML.Tag.PARAM, new HTMLDocument.HTMLReader.SpecialAction(this));
            this.registerTag(HTML.Tag.OBJECT, new CustomObjectAction());
            this.registerTag(RubyTag.Ruby, new HTMLDocument.HTMLReader.CharacterAction(this));
            this.registerTag(RubyTag.RT, new HTMLDocument.HTMLReader.CharacterAction(this));
            this.buildGrammar();
        }

        public EditorHTMLReader(int offset, int popDepth, int pushDepth, HTML.Tag insertTag) {
            super(EditorHTMLDocument.this, offset, popDepth, pushDepth, insertTag);
            this.registerTag(HTML.Tag.FONT, new FontAction());
            this.registerTag(HTML.Tag.A, new AAction());
            if (HTMLEditor.jvm_older) {
                this.registerTag(HTML.Tag.U, new UnderlineAction());
            }
            this.registerTag(HTML.Tag.B, new BoldAction());
            this.registerTag(HTML.Tag.I, new ItalicAction());
            this.registerTag(HTML.Tag.S, new StrikethroughAction());
            this.registerTag(HTML.Tag.SPAN, new SpanAction());
            this.registerTag(HTML.Tag.PARAM, new HTMLDocument.HTMLReader.SpecialAction(this));
            this.registerTag(HTML.Tag.OBJECT, new CustomObjectAction());
            this.registerTag(RubyTag.Ruby, new HTMLDocument.HTMLReader.CharacterAction(this));
            this.registerTag(RubyTag.RT, new HTMLDocument.HTMLReader.CharacterAction(this));
            this.buildGrammar();
        }

        void buildGrammar() {
            this.registerTag(new HTML.UnknownTag("fieldset"), new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(new HTML.UnknownTag("nav"), new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(new HTML.UnknownTag("footer"), new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(new HTML.UnknownTag("section"), new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(new HTML.UnknownTag("article"), new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(new HTML.UnknownTag("header"), new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(new HTML.UnknownTag("aside"), new HTMLDocument.HTMLReader.BlockAction(this));
            this.registerTag(new HTML.UnknownTag("blink"), new SpanAction());
            Hashtable tagTable = CustomXMLTagsGrammarSpecification.getGrammarSpecification();
            Enumeration tagsEnum = tagTable.keys();
            while (tagsEnum.hasMoreElements()) {
                String tagName = (String)tagsEnum.nextElement();
                boolean isLeaf = (Boolean)tagTable.get(tagName);
                if (tagName.equalsIgnoreCase("tbody")) continue;
                if (isLeaf) {
                    this.registerTag(new CustomTag(tagName, false, false), new HTMLDocument.HTMLReader.SpecialAction(this));
                    continue;
                }
                Hashtable renderingMappingTable = CustomXMLTagsGrammarSpecification.getRenderingModesSpecification();
                String renderingMode = (String)renderingMappingTable.get(tagName);
                if (CustomXMLTagsGrammarSpecification.isTreatAllBlockTagsAsBlocks() && CustomXMLTagsGrammarSpecification.isTagRenderingAsBlock(tagName)) {
                    this.registerTag(new CustomTag(tagName, false, false), new CustomTagBlockAction());
                    continue;
                }
                if (renderingMode == null) {
                    this.registerTag(new CustomTag(tagName, false, false), new CustomTagInlineAction());
                    continue;
                }
                if (renderingMode.equals("BLOCK_TAG")) {
                    this.registerTag(new CustomTag(tagName, false, false), new CustomTagBlockAction());
                    continue;
                }
                if (!renderingMode.equals("INLINE_TAG")) continue;
                this.registerTag(new CustomTag(tagName, false, false), new CustomTagInlineAction());
            }
        }

        void addEmptySpaceAsContent() {
            char[] one = new char[]{' '};
            this.addContent(one, 0, 1);
        }

        public void registerTag(HTML.Tag tag, HTMLDocument.HTMLReader.TagAction a) {
            super.registerTag(tag, a);
        }

        public HTMLDocument.HTMLReader.BlockAction getBlockAction() {
            return new HTMLDocument.HTMLReader.BlockAction(this);
        }

        protected void blockOpen(HTML.Tag t, MutableAttributeSet attr) {
            if (EditorHTMLDocument.this.replacementFontFamily != null) {
                attr.addAttribute(CSS.Attribute.FONT_FAMILY, EditorHTMLDocument.this.replacementFontFamily);
            }
            if (this.addingComment) {
                attr.addAttribute("visibility", "hidden");
                attr.addAttribute("position", "absolute");
                attr.addAttribute("x", "0");
                attr.addAttribute("y", "0");
            }
            super.blockOpen(t, attr);
            if (t == HTML.Tag.IMPLIED || t == HTML.Tag.P) {
                this.implied = true;
            }
        }

        protected void blockClose(HTML.Tag t) {
            if (HTMLEditor.jvm_version.startsWith("1.3")) {
                DefaultStyledDocument.ElementSpec prev;
                DefaultStyledDocument.ElementSpec elementSpec = prev = this.parseBuffer.size() > 0 ? (DefaultStyledDocument.ElementSpec)this.parseBuffer.lastElement() : null;
                if (prev != null && prev.getType() == 1 && !this.implied) {
                    SimpleAttributeSet sas = new SimpleAttributeSet();
                    sas.addAttribute(StyleConstants.NameAttribute, HTML.Tag.IMPLIED);
                    this.blockOpen(HTML.Tag.IMPLIED, sas);
                    this.blockClose(HTML.Tag.IMPLIED);
                }
            }
            if (t == HTML.Tag.IMPLIED || t == HTML.Tag.P) {
                this.implied = false;
            }
            super.blockClose(t);
        }

        public void handleEndTag(HTML.Tag t, int pos) {
            if (t instanceof HTML.UnknownTag && t.toString().indexOf(":") != -1 && EditorHTMLDocument.this.discardAllProprietaryTags) {
                return;
            }
            if (t == HTML.Tag.STYLE) {
                this.inStyle = false;
            }
            if (t == HTML.Tag.BODY || t == HTML.Tag.HTML) {
                this.afterBodyComments = true;
            }
            if (t == HTML.Tag.COMMENT) {
                this.inComment = false;
            }
            super.handleEndTag(t, pos);
        }

        Object getAttributeValueFromString(AttributeSet attr, String attributeName) {
            Enumeration<?> allAttribs = attr.getAttributeNames();
            while (allAttribs.hasMoreElements()) {
                Object nextAttrib = allAttribs.nextElement();
                if (!nextAttrib.toString().equalsIgnoreCase(attributeName)) continue;
                return attr.getAttribute(nextAttrib);
            }
            return null;
        }

        private void importStyleLink(AttributeSet attr) {
            EditorHTMLDocument.this.externalStyles.addElement(attr.copyAttributes());
            String type = (String)attr.getAttribute(HTML.Attribute.TYPE);
            if (type == null) {
                type = "text/css";
            }
            if (type.equals("text/css")) {
                String rel = (String)attr.getAttribute(HTML.Attribute.REL);
                String title = (String)attr.getAttribute(HTML.Attribute.TITLE);
                String media = (String)this.getAttributeValueFromString(attr, "media");
                media = media == null ? "all" : media.toLowerCase();
                if (rel != null) {
                    String href;
                    rel = rel.toLowerCase();
                    if ((media.indexOf("all") != -1 || media.indexOf("screen") != -1) && rel.equals("stylesheet") && (href = (String)attr.getAttribute(HTML.Attribute.HREF)) != null) {
                        URL url = null;
                        try {
                            url = EditorHTMLDocument.this.dragResolvePath != null ? new URL(EditorHTMLDocument.this.dragResolvePath, href) : new URL(EditorHTMLDocument.this.getBase(), href);
                        }
                        catch (MalformedURLException mfe) {
                            try {
                                url = new URL(href);
                            }
                            catch (MalformedURLException mfe2) {
                                url = null;
                            }
                        }
                        if (url != null) {
                            EditorHTMLDocument.this.getStyleSheet().importStyleSheet(url);
                        }
                    }
                }
            }
        }

        public StyleSheet getDocumentStyleSheet() {
            return EditorHTMLDocument.this.getStyleSheet();
        }

        public void handleSimpleTag(HTML.Tag t, MutableAttributeSet attr, int pos) {
            if (t.toString().equalsIgnoreCase("col")) {
                return;
            }
            if (t == HTML.Tag.AREA && EditorHTMLDocument.this.currentMap != null) {
                EditorHTMLDocument.this.currentMap.addNewArea((MutableAttributeSet)attr.copyAttributes());
            }
            if (t == HTML.Tag.LINK) {
                this.importStyleLink(attr);
                return;
            }
            if (t != null && t.toString().equalsIgnoreCase("img") && this.lastAttributeSet != null && this.lastTag.toString().equalsIgnoreCase("v:shape")) {
                AttributeSet previousElementAttr = this.lastAttributeSet;
                if (attr.getAttribute(HTML.Attribute.WIDTH) == null && previousElementAttr.getAttribute(CSS.Attribute.WIDTH) != null && previousElementAttr.containsAttribute(CSS.Attribute.WIDTH, previousElementAttr.getAttribute(CSS.Attribute.WIDTH))) {
                    try {
                        attr.addAttribute(HTML.Attribute.WIDTH, "" + Math.round(SferyxUtilities.getNumberFromCSString(previousElementAttr.getAttribute(CSS.Attribute.WIDTH).toString())));
                    }
                    catch (Throwable thr) {
                        thr.printStackTrace();
                    }
                }
                if (attr.getAttribute(HTML.Attribute.HEIGHT) == null && previousElementAttr.getAttribute(CSS.Attribute.HEIGHT) != null && previousElementAttr.containsAttribute(CSS.Attribute.HEIGHT, previousElementAttr.getAttribute(CSS.Attribute.HEIGHT))) {
                    try {
                        attr.addAttribute(HTML.Attribute.HEIGHT, "" + Math.round(SferyxUtilities.getNumberFromCSString(previousElementAttr.getAttribute(CSS.Attribute.HEIGHT).toString())));
                    }
                    catch (Throwable thr) {
                        thr.printStackTrace();
                    }
                }
            }
            if (t != null && t.toString().equalsIgnoreCase("img") && EditorHTMLDocument.this.dragResolvePath != null && attr.getAttribute(HTML.Attribute.SRC) != null) {
                String src = attr.getAttribute(HTML.Attribute.SRC).toString();
                try {
                    URL url = new URL(EditorHTMLDocument.this.dragResolvePath, src);
                    attr.addAttribute(HTML.Attribute.SRC, url.toString());
                }
                catch (Throwable thr) {
                    // empty catch block
                }
            }
            if (t instanceof HTML.UnknownTag && t.toString().indexOf(":") != -1 && EditorHTMLDocument.this.discardAllProprietaryTags) {
                return;
            }
            super.handleSimpleTag(t, attr, pos);
            this.lastAttributeSet = attr.copyAttributes();
            this.lastTag = t;
        }

        public void handleText(char[] data, int pos) {
            if (this.inStyle) {
                String styleDef = new String(data);
                EditorHTMLDocument.this.getStyleSheet().addRule(styleDef);
                return;
            }
            if (this.inComment && EditorHTMLDocument.this.discardAllProprietaryTags) {
                return;
            }
            super.handleText(data, pos);
        }

        private void addAfterBodyComment(String comment) {
            Vector<String> comments = EditorHTMLDocument.this.getProperty("AdditionalComments");
            if (comments != null && !(comments instanceof Vector)) {
                return;
            }
            if (comments == null) {
                comments = new Vector<String>();
                EditorHTMLDocument.this.putProperty("AdditionalComments", comments);
            }
            comment = SferyxUtilities.replaceAll(comment, "<!--", "");
            comment = SferyxUtilities.replaceAll(comment, "//-->", "");
            comment = SferyxUtilities.replaceAll(comment, "-->", "");
            comments.addElement(comment);
        }

        public void handleComment(char[] data, int pos) {
            if (EditorHTMLDocument.this.discardAllProprietaryTags) {
                return;
            }
            if (this.afterBodyComments) {
                this.addAfterBodyComment(new String(data));
                return;
            }
            super.handleComment(data, pos);
        }

        public void handleStartTag(HTML.Tag t, MutableAttributeSet attr, int pos) {
            if (t instanceof HTML.UnknownTag && t.toString().indexOf(":") != -1 && EditorHTMLDocument.this.discardAllProprietaryTags) {
                return;
            }
            if (t == HTML.Tag.MAP) {
                EditorHTMLDocument.this.currentMap = new CustomMap(attr);
                EditorHTMLDocument.this.allMaps.put("#" + attr.getAttribute(HTML.Attribute.NAME), EditorHTMLDocument.this.currentMap);
            }
            if (t == HTML.Tag.STYLE) {
                this.inStyle = true;
            }
            if (t == HTML.Tag.COMMENT) {
                this.inComment = true;
            }
            super.handleStartTag(t, attr, pos);
            if ((t == HTML.Tag.H1 || t == HTML.Tag.DIV) && !this.implied && this.pasting) {
                SimpleAttributeSet a = new SimpleAttributeSet();
                a.addAttribute(StyleConstants.NameAttribute, HTML.Tag.IMPLIED);
                DefaultStyledDocument.ElementSpec es = new DefaultStyledDocument.ElementSpec(a, 1);
                this.parseBuffer.addElement(es);
            }
        }

        protected void addContent(char[] data, int offs, int length, boolean generateImpliedPIfNecessary) {
            this.emptyAnchor = false;
            super.addContent(data, offs, length, generateImpliedPIfNecessary);
        }

        protected void addSpecialElement(HTML.Tag t, MutableAttributeSet a) {
            this.emptyAnchor = false;
            if (t == HTML.Tag.SCRIPT || t == HTML.Tag.COMMENT) {
                // empty if block
            }
            if (t == HTML.Tag.IMG) {
                this.pushCharacterStyle();
                this.charAttr.addAttributes(a.copyAttributes());
            }
            super.addSpecialElement(t, a);
            if (t == HTML.Tag.IMG) {
                this.popCharacterStyle();
            }
            this.addingComment = false;
        }

        class FontAction
        extends HTMLDocument.HTMLReader.TagAction {
            FontAction() {
                super(EditorHTMLReader.this);
            }

            public void start(HTML.Tag t, MutableAttributeSet attr) {
                if (attr.getAttribute(HTML.Attribute.ENDTAG) != null) {
                    EditorHTMLReader.this.popCharacterStyle();
                    return;
                }
                EditorHTMLReader.this.pushCharacterStyle();
                if (attr.isDefined(HTMLEditorKit.ParserCallback.IMPLIED)) {
                    attr.removeAttribute(HTMLEditorKit.ParserCallback.IMPLIED);
                }
                MutableAttributeSet attrCopy = (MutableAttributeSet)attr.copyAttributes();
                if (EditorHTMLReader.this.styleAttributes != null) {
                    EditorHTMLReader.this.charAttr.addAttribute(HTML.Attribute.STYLE, EditorHTMLReader.this.styleAttributes);
                }
                if (t == HTML.Tag.FONT) {
                    if (attr.getAttribute(HTML.Attribute.FACE) != null) {
                        EditorHTMLDocument.this.getStyleSheet().addCSSAttribute(EditorHTMLReader.this.charAttr, CSS.Attribute.FONT_FAMILY, attr.getAttribute(HTML.Attribute.FACE).toString());
                    }
                    if (attr.getAttribute(HTML.Attribute.SIZE) != null) {
                        EditorHTMLDocument.this.getStyleSheet().addCSSAttribute(EditorHTMLReader.this.charAttr, CSS.Attribute.FONT_SIZE, EditorHTMLDocument.this.getStyleSheet().getPointSize(attr.getAttribute(HTML.Attribute.SIZE).toString()) + "pt");
                    }
                    if (attr.getAttribute(HTML.Attribute.COLOR) != null) {
                        EditorHTMLDocument.this.getStyleSheet().addCSSAttribute(EditorHTMLReader.this.charAttr, CSS.Attribute.COLOR, attr.getAttribute(HTML.Attribute.COLOR).toString());
                    }
                }
                if (EditorHTMLReader.this.charAttr.getAttribute(HTML.Tag.FONT) != null) {
                    MutableAttributeSet attribs = (MutableAttributeSet)((MutableAttributeSet)EditorHTMLReader.this.charAttr.getAttribute(HTML.Tag.FONT)).copyAttributes();
                    attribs.addAttributes(attrCopy);
                    ++((EditorHTMLReader)EditorHTMLReader.this).EditorHTMLDocument.this.embeddedTagsCount;
                    attrCopy.addAttribute(sferyxInternalEmbeddedTagsCount, new Integer(((EditorHTMLReader)EditorHTMLReader.this).EditorHTMLDocument.this.embeddedTagsCount));
                    EditorHTMLReader.this.charAttr.addAttribute(HTML.Tag.FONT, attribs);
                } else {
                    ++((EditorHTMLReader)EditorHTMLReader.this).EditorHTMLDocument.this.embeddedTagsCount;
                    attrCopy.addAttribute(sferyxInternalEmbeddedTagsCount, new Integer(((EditorHTMLReader)EditorHTMLReader.this).EditorHTMLDocument.this.embeddedTagsCount));
                    EditorHTMLReader.this.charAttr.addAttribute(HTML.Tag.FONT, attrCopy);
                }
            }

            public void end(HTML.Tag t) {
                EditorHTMLReader.this.popCharacterStyle();
            }
        }

        class SpanAction
        extends HTMLDocument.HTMLReader.TagAction {
            SpanAction() {
                super(EditorHTMLReader.this);
            }

            public void start(HTML.Tag t, MutableAttributeSet attr) {
                if (attr.getAttribute(HTML.Attribute.ENDTAG) != null) {
                    if (EditorHTMLReader.this.styleAttributes != null) {
                        EditorHTMLReader.this.charAttr.removeAttributes(EditorHTMLReader.this.styleAttributes);
                    }
                    EditorHTMLReader.this.popCharacterStyle();
                    return;
                }
                EditorHTMLReader.this.pushCharacterStyle();
                if (((EditorHTMLReader)EditorHTMLReader.this).EditorHTMLDocument.this.replacementFontFamily != null) {
                    attr.addAttribute(CSS.Attribute.FONT_FAMILY, ((EditorHTMLReader)EditorHTMLReader.this).EditorHTMLDocument.this.replacementFontFamily);
                }
                MutableAttributeSet attrCopy = (MutableAttributeSet)attr.copyAttributes();
                MutableAttributeSet attrCharacterCopy = (MutableAttributeSet)attr.copyAttributes();
                Enumeration<?> keys = attr.getAttributeNames();
                while (keys.hasMoreElements()) {
                    Object key = keys.nextElement();
                    if (key != HTML.Attribute.ID && key == HTML.Attribute.CLASS || key == CSS.Attribute.FONT_WEIGHT || key == CSS.Attribute.FONT_SIZE || key == CSS.Attribute.FONT_FAMILY || key == CSS.Attribute.TEXT_DECORATION || key == CSS.Attribute.FONT_STYLE || key == CSS.Attribute.COLOR || key == CSS.Attribute.BACKGROUND_COLOR || key == CSS.Attribute.BACKGROUND || key == CSS.Attribute.VERTICAL_ALIGN || key == CSS.Attribute.DISPLAY) continue;
                    attrCharacterCopy.removeAttribute(key);
                }
                attrCopy.removeAttribute(CSS.Attribute.FONT_WEIGHT);
                attrCopy.removeAttribute(CSS.Attribute.FONT_SIZE);
                attrCopy.removeAttribute(CSS.Attribute.FONT_FAMILY);
                attrCopy.removeAttribute(CSS.Attribute.TEXT_DECORATION);
                attrCopy.removeAttribute(CSS.Attribute.FONT_STYLE);
                attrCopy.removeAttribute(CSS.Attribute.COLOR);
                attrCopy.removeAttribute(CSS.Attribute.BACKGROUND_COLOR);
                attrCopy.removeAttribute(CSS.Attribute.BACKGROUND);
                attrCopy.removeAttribute(CSS.Attribute.VERTICAL_ALIGN);
                attrCopy.removeAttribute(CSS.Attribute.DISPLAY);
                ++((EditorHTMLReader)EditorHTMLReader.this).EditorHTMLDocument.this.embeddedTagsCount;
                attrCopy.addAttribute(sferyxInternalEmbeddedTagsCount, new Integer(((EditorHTMLReader)EditorHTMLReader.this).EditorHTMLDocument.this.embeddedTagsCount));
                if (EditorHTMLReader.this.charAttr.getAttribute(t) != null) {
                    ((MutableAttributeSet)EditorHTMLReader.this.charAttr.getAttribute(t)).addAttributes(attrCopy);
                } else {
                    EditorHTMLReader.this.charAttr.addAttribute(t, attrCopy);
                }
                EditorHTMLReader.this.charAttr.addAttributes(attrCharacterCopy);
                if (EditorHTMLReader.this.styleAttributes != null) {
                    EditorHTMLReader.this.charAttr.addAttributes(EditorHTMLReader.this.styleAttributes);
                }
            }

            public void end(HTML.Tag t) {
                if (EditorHTMLReader.this.styleAttributes != null) {
                    EditorHTMLReader.this.charAttr.removeAttributes(EditorHTMLReader.this.styleAttributes);
                }
                EditorHTMLReader.this.popCharacterStyle();
            }
        }

        class StrikethroughAction
        extends HTMLDocument.HTMLReader.TagAction {
            StrikethroughAction() {
                super(EditorHTMLReader.this);
            }

            public void start(HTML.Tag t, MutableAttributeSet attr) {
                if (attr.getAttribute(HTML.Attribute.ENDTAG) != null) {
                    EditorHTMLReader.this.popCharacterStyle();
                    return;
                }
                EditorHTMLReader.this.pushCharacterStyle();
                if (attr.isDefined(HTMLEditorKit.ParserCallback.IMPLIED)) {
                    attr.removeAttribute(HTMLEditorKit.ParserCallback.IMPLIED);
                }
                if (!HTMLEditor.jvm_older) {
                    EditorHTMLReader.this.charAttr.addAttribute(HTML.Tag.STRIKE, attr.copyAttributes());
                }
                if (t == HTML.Tag.S) {
                    EditorHTMLDocument.this.getStyleSheet().addCSSAttribute(EditorHTMLReader.this.charAttr, CSS.Attribute.TEXT_DECORATION, "line-through");
                }
            }

            public void end(HTML.Tag t) {
                EditorHTMLReader.this.popCharacterStyle();
            }
        }

        class UnderlineAction
        extends HTMLDocument.HTMLReader.TagAction {
            UnderlineAction() {
                super(EditorHTMLReader.this);
            }

            public void start(HTML.Tag t, MutableAttributeSet attr) {
                if (attr.getAttribute(HTML.Attribute.ENDTAG) != null) {
                    EditorHTMLReader.this.popCharacterStyle();
                    return;
                }
                EditorHTMLReader.this.pushCharacterStyle();
                if (attr.isDefined(HTMLEditorKit.ParserCallback.IMPLIED)) {
                    attr.removeAttribute(HTMLEditorKit.ParserCallback.IMPLIED);
                }
                if (!HTMLEditor.jvm_older) {
                    EditorHTMLReader.this.charAttr.addAttribute(t, attr.copyAttributes());
                }
                if (t == HTML.Tag.U) {
                    EditorHTMLDocument.this.getStyleSheet().addCSSAttribute(EditorHTMLReader.this.charAttr, CSS.Attribute.TEXT_DECORATION, "underline");
                }
            }

            public void end(HTML.Tag t) {
                EditorHTMLReader.this.popCharacterStyle();
            }
        }

        class BoldAction
        extends HTMLDocument.HTMLReader.TagAction {
            BoldAction() {
                super(EditorHTMLReader.this);
            }

            public void start(HTML.Tag t, MutableAttributeSet attr) {
                if (attr.getAttribute(HTML.Attribute.ENDTAG) != null) {
                    EditorHTMLReader.this.popCharacterStyle();
                    return;
                }
                EditorHTMLReader.this.pushCharacterStyle();
                if (attr.isDefined(HTMLEditorKit.ParserCallback.IMPLIED)) {
                    attr.removeAttribute(HTMLEditorKit.ParserCallback.IMPLIED);
                }
                if (!HTMLEditor.jvm_older) {
                    EditorHTMLReader.this.charAttr.addAttribute(t, attr.copyAttributes());
                }
                if (t == HTML.Tag.B) {
                    EditorHTMLDocument.this.getStyleSheet().addCSSAttribute(EditorHTMLReader.this.charAttr, CSS.Attribute.FONT_WEIGHT, "bold");
                }
            }

            public void end(HTML.Tag t) {
                EditorHTMLReader.this.popCharacterStyle();
            }
        }

        class ItalicAction
        extends HTMLDocument.HTMLReader.TagAction {
            ItalicAction() {
                super(EditorHTMLReader.this);
            }

            public void start(HTML.Tag t, MutableAttributeSet attr) {
                if (attr.getAttribute(HTML.Attribute.ENDTAG) != null) {
                    EditorHTMLReader.this.popCharacterStyle();
                    return;
                }
                EditorHTMLReader.this.pushCharacterStyle();
                if (attr.isDefined(HTMLEditorKit.ParserCallback.IMPLIED)) {
                    attr.removeAttribute(HTMLEditorKit.ParserCallback.IMPLIED);
                }
                if (!HTMLEditor.jvm_older) {
                    EditorHTMLReader.this.charAttr.addAttribute(t, attr.copyAttributes());
                }
                if (t == HTML.Tag.I) {
                    EditorHTMLDocument.this.getStyleSheet().addCSSAttribute(EditorHTMLReader.this.charAttr, CSS.Attribute.FONT_STYLE, "italic");
                }
            }

            public void end(HTML.Tag t) {
                EditorHTMLReader.this.popCharacterStyle();
            }
        }

        class AAction1
        extends HTMLDocument.HTMLReader.TagAction {
            boolean blockView = false;

            AAction1() {
                super(EditorHTMLReader.this);
            }

            public void start(HTML.Tag t, MutableAttributeSet attr) {
                ++((EditorHTMLReader)EditorHTMLReader.this).EditorHTMLDocument.this.embeddedTagsCount;
                attr.addAttribute(sferyxInternalEmbeddedTagsCount, new Integer(((EditorHTMLReader)EditorHTMLReader.this).EditorHTMLDocument.this.embeddedTagsCount));
                EditorHTMLReader.this.emptyAnchor = true;
                if (attr.getAttribute(HTML.Attribute.ENDTAG) != null) {
                    EditorHTMLReader.this.popCharacterStyle();
                    return;
                }
                EditorHTMLReader.this.pushCharacterStyle();
                MutableAttributeSet test_attr = (MutableAttributeSet)attr.copyAttributes();
                test_attr.addAttribute(StyleConstants.NameAttribute, t);
                if (SferyxUtilities.isDisplayLikeBlockView(test_attr, EditorHTMLDocument.this.getStyleSheet())) {
                    EditorHTMLReader.this.blockOpen(t, attr);
                    this.blockView = true;
                    MutableAttributeSet ch = (MutableAttributeSet)attr.copyAttributes();
                    ch.addAttribute("fictional", "true");
                    EditorHTMLReader.this.charAttr.addAttribute(t, ch);
                } else {
                    EditorHTMLReader.this.charAttr.addAttribute(HTML.Tag.A, attr.copyAttributes());
                }
            }

            public void end(HTML.Tag t) {
                if (EditorHTMLReader.this.emptyAnchor) {
                    EditorHTMLReader.this.addEmptySpaceAsContent();
                }
                EditorHTMLReader.this.popCharacterStyle();
                if (this.blockView) {
                    EditorHTMLReader.this.blockClose(t);
                    this.blockView = false;
                }
            }
        }

        class AAction
        extends HTMLDocument.HTMLReader.TagAction {
            boolean blockView = false;

            AAction() {
                super(EditorHTMLReader.this);
            }

            public void start(HTML.Tag t, MutableAttributeSet attr) {
                ++((EditorHTMLReader)EditorHTMLReader.this).EditorHTMLDocument.this.embeddedTagsCount;
                attr.addAttribute(sferyxInternalEmbeddedTagsCount, new Integer(((EditorHTMLReader)EditorHTMLReader.this).EditorHTMLDocument.this.embeddedTagsCount));
                EditorHTMLReader.this.emptyAnchor = true;
                if (attr.getAttribute(HTML.Attribute.ENDTAG) != null) {
                    EditorHTMLReader.this.popCharacterStyle();
                    return;
                }
                EditorHTMLReader.this.pushCharacterStyle();
                MutableAttributeSet test_attr = (MutableAttributeSet)attr.copyAttributes();
                test_attr.addAttribute(StyleConstants.NameAttribute, t);
                if (SferyxUtilities.isDisplayLikeBlockView(test_attr, EditorHTMLDocument.this.getStyleSheet())) {
                    EditorHTMLReader.this.blockOpen(t, attr);
                    this.blockView = true;
                    MutableAttributeSet ch = (MutableAttributeSet)attr.copyAttributes();
                    ch.addAttribute("fictional", "true");
                    EditorHTMLReader.this.charAttr.addAttribute(t, ch);
                } else {
                    EditorHTMLReader.this.charAttr.addAttribute(HTML.Tag.A, attr.copyAttributes());
                }
            }

            public void end(HTML.Tag t) {
                if (EditorHTMLReader.this.emptyAnchor) {
                    EditorHTMLReader.this.addEmptySpaceAsContent();
                }
                EditorHTMLReader.this.popCharacterStyle();
                if (this.blockView) {
                    EditorHTMLReader.this.blockClose(t);
                    this.blockView = false;
                }
            }
        }

        public class CustomTagInlineAction
        extends HTMLDocument.HTMLReader.TagAction {
            public CustomTagInlineAction() {
                super(EditorHTMLReader.this);
            }

            public void start(HTML.Tag t, MutableAttributeSet attr) {
                ++((EditorHTMLReader)EditorHTMLReader.this).EditorHTMLDocument.this.embeddedTagsCount;
                attr.addAttribute(sferyxInternalEmbeddedTagsCount, new Integer(((EditorHTMLReader)EditorHTMLReader.this).EditorHTMLDocument.this.embeddedTagsCount));
                if (attr.getAttribute(HTML.Attribute.ENDTAG) != null) {
                    EditorHTMLReader.this.charAttr.removeAttribute(t);
                    EditorHTMLReader.this.popCharacterStyle();
                    return;
                }
                EditorHTMLReader.this.pushCharacterStyle();
                EditorHTMLReader.this.charAttr.addAttribute(t, attr.copyAttributes());
            }

            public void end(HTML.Tag t) {
                char[] one = new char[]{' '};
                EditorHTMLReader.this.addContent(one, 0, 1);
            }
        }

        public class CustomTagBlockAction
        extends HTMLDocument.HTMLReader.BlockAction {
            public CustomTagBlockAction() {
                super(EditorHTMLReader.this);
            }

            public void start(HTML.Tag t, MutableAttributeSet attr) {
                if (attr.getAttribute(HTML.Attribute.ENDTAG) != null) {
                    EditorHTMLReader.this.blockClose(t);
                    return;
                }
                EditorHTMLReader.this.blockOpen(t, attr);
            }

            public void end(HTML.Tag t) {
                EditorHTMLReader.this.blockClose(t);
            }
        }

        public class CustomTag
        extends HTML.UnknownTag {
            public CustomTag(String id, boolean causesBreak, boolean isBlock) {
                super(id);
            }
        }

        public class CustomObjectAction
        extends HTMLDocument.HTMLReader.TagAction {
            public CustomObjectAction() {
                super(EditorHTMLReader.this);
            }

            public void start(HTML.Tag t, MutableAttributeSet a) {
                EditorHTMLReader.this.addSpecialElement(t, a);
            }

            public void end(HTML.Tag t) {
                if (!this.isEmpty(t)) {
                    SimpleAttributeSet a = new SimpleAttributeSet();
                    a.addAttribute(HTML.Attribute.ENDTAG, "true");
                    EditorHTMLReader.this.addSpecialElement(t, a);
                }
            }

            boolean isEmpty(HTML.Tag t) {
                return false;
            }
        }

        class InlineElementAction
        extends HTMLDocument.HTMLReader.TagAction {
            int blockViewsDepth = 0;

            InlineElementAction() {
                super(EditorHTMLReader.this);
            }

            public void start(HTML.Tag t, MutableAttributeSet attr) {
                if (attr.getAttribute(HTML.Attribute.ENDTAG) != null) {
                    EditorHTMLReader.this.popCharacterStyle();
                    EditorHTMLReader.this.charAttr.removeAttribute(t);
                    return;
                }
                SimpleAttributeSet attr_copy = new SimpleAttributeSet();
                attr_copy.addAttribute(StyleConstants.NameAttribute, new HTML.UnknownTag("li"));
                attr_copy.addAttributes(attr);
                MutableAttributeSet test_attr = (MutableAttributeSet)attr.copyAttributes();
                test_attr.addAttribute(StyleConstants.NameAttribute, t);
                if (!SferyxUtilities.isDisplayLikeInlineView(test_attr, EditorHTMLDocument.this.getStyleSheet())) {
                    EditorHTMLReader.this.blockOpen(t, attr);
                    ++this.blockViewsDepth;
                } else {
                    DefaultStyledDocument.ElementSpec es = new DefaultStyledDocument.ElementSpec(attr_copy, 3);
                    EditorHTMLReader.this.parseBuffer.addElement(es);
                }
                MutableAttributeSet ch = (MutableAttributeSet)attr.copyAttributes();
                ch.addAttribute("fictional", "true");
            }

            public void end(HTML.Tag t) {
                if (this.blockViewsDepth > 0) {
                    EditorHTMLReader.this.blockClose(t);
                    --this.blockViewsDepth;
                } else {
                    SimpleAttributeSet attr = new SimpleAttributeSet();
                    attr.addAttribute(StyleConstants.NameAttribute, new HTML.UnknownTag("li"));
                    attr.addAttribute(HTML.Attribute.ENDTAG, "true");
                    DefaultStyledDocument.ElementSpec es = new DefaultStyledDocument.ElementSpec(attr.copyAttributes(), 3);
                    EditorHTMLReader.this.parseBuffer.addElement(es);
                    EditorHTMLReader.this.addEmptySpaceAsContent();
                }
            }
        }
    }

    class CustomMap {
        Shape selectedShape;
        AttributeSet attribs;
        Vector areas = new Vector();
        Vector shapes = new Vector();
        Rectangle lastPaintBounds = new Rectangle(0, 0, 0, 0);
        boolean drawingPoly;

        public Circle createNewCircle(int x, int y, int radius) {
            return new Circle(x, y, radius);
        }

        CustomMap(MutableAttributeSet a) {
            this.attribs = a.copyAttributes();
        }

        public String getName() {
            return (String)this.attribs.getAttribute(HTML.Attribute.NAME);
        }

        public void addNewArea(MutableAttributeSet a) {
            this.areas.addElement(a);
            this.createShapes();
        }

        public void removeShape(Shape shape) {
            int index = this.shapes.indexOf(shape);
            this.shapes.remove(index);
            this.areas.remove(index);
        }

        public AttributeSet getAttributesForShape(Shape shape) {
            int index = this.shapes.indexOf(shape);
            return (AttributeSet)this.areas.elementAt(index);
        }

        public void updateShape(Shape shape, MutableAttributeSet attr) {
            AttributeSet atag;
            if (attr == null) {
                return;
            }
            SimpleAttributeSet sas = new SimpleAttributeSet();
            if (attr != null && (atag = (AttributeSet)attr.getAttribute(HTML.Tag.A)) != null) {
                sas.addAttribute(HTML.Attribute.HREF, atag.getAttribute(HTML.Attribute.HREF));
                if (atag.getAttribute(HTML.Attribute.TARGET) != null) {
                    sas.addAttribute(HTML.Attribute.TARGET, atag.getAttribute(HTML.Attribute.TARGET));
                }
                if (atag.getAttribute(HTML.Attribute.ALT) != null) {
                    sas.addAttribute(HTML.Attribute.ALT, atag.getAttribute(HTML.Attribute.ALT));
                }
            }
            int index = this.shapes.indexOf(shape);
            MutableAttributeSet set = (MutableAttributeSet)this.areas.elementAt(index);
            set.addAttribute(HTML.Attribute.HREF, sas.getAttribute(HTML.Attribute.HREF));
            if (sas.getAttribute(HTML.Attribute.TARGET) != null) {
                set.addAttribute(HTML.Attribute.TARGET, sas.getAttribute(HTML.Attribute.TARGET));
            } else {
                set.removeAttribute(HTML.Attribute.TARGET);
            }
            if (sas.getAttribute(HTML.Attribute.ALT) != null) {
                set.addAttribute(HTML.Attribute.ALT, sas.getAttribute(HTML.Attribute.ALT));
            } else {
                set.removeAttribute(HTML.Attribute.ALT);
            }
        }

        public void addNewShape(Shape shape, MutableAttributeSet attr) {
            Rectangle rect;
            AttributeSet atag;
            SimpleAttributeSet sas = new SimpleAttributeSet();
            if (attr != null && (atag = (AttributeSet)attr.getAttribute(HTML.Tag.A)) != null) {
                sas.addAttribute(HTML.Attribute.HREF, atag.getAttribute(HTML.Attribute.HREF));
                if (atag.getAttribute(HTML.Attribute.TARGET) != null) {
                    sas.addAttribute(HTML.Attribute.TARGET, atag.getAttribute(HTML.Attribute.TARGET));
                }
                if (atag.getAttribute(HTML.Attribute.ALT) != null) {
                    sas.addAttribute(HTML.Attribute.ALT, atag.getAttribute(HTML.Attribute.ALT));
                }
            }
            if (shape instanceof Polygon) {
                sas.addAttribute(HTML.Attribute.SHAPE, "polygon");
                String coords = "";
                Polygon poly = (Polygon)shape;
                for (int j = 0; j < poly.npoints; ++j) {
                    if (j > 0) {
                        coords = coords + ",";
                    }
                    coords = coords + poly.xpoints[j] + "," + poly.ypoints[j];
                }
                sas.addAttribute(HTML.Attribute.COORDS, coords);
            } else if (shape instanceof Circle) {
                sas.addAttribute(HTML.Attribute.SHAPE, "circle");
                rect = (Rectangle)shape;
                String coords = rect.x + rect.width / 2 + "," + (rect.y + rect.height / 2) + "," + rect.width / 2;
                sas.addAttribute(HTML.Attribute.COORDS, coords);
            } else if (shape instanceof Rectangle) {
                sas.addAttribute(HTML.Attribute.SHAPE, "rect");
                rect = (Rectangle)shape;
                String coords = rect.x + "," + rect.y + "," + (rect.x + rect.width) + "," + (rect.y + rect.height);
                sas.addAttribute(HTML.Attribute.COORDS, coords);
            }
            this.areas.addElement(sas);
            this.shapes.addElement(shape);
        }

        public String toString() {
            String mapString = "<map name=\"" + this.attribs.getAttribute(HTML.Attribute.NAME) + "\" >";
            for (int i = 0; i < this.areas.size(); ++i) {
                Rectangle rect;
                AttributeSet areaAttribs = (AttributeSet)this.areas.elementAt(i);
                mapString = mapString + "<area shape=\"" + areaAttribs.getAttribute(HTML.Attribute.SHAPE) + "\" href=\"" + areaAttribs.getAttribute(HTML.Attribute.HREF) + "\" ";
                if (this.shapes.size() <= i) continue;
                Shape shape = (Shape)this.shapes.elementAt(i);
                if (areaAttribs.getAttribute(HTML.Attribute.ALT) != null) {
                    mapString = mapString + " alt=\"" + areaAttribs.getAttribute(HTML.Attribute.ALT).toString() + "\" ";
                }
                if (areaAttribs.getAttribute(HTML.Attribute.TARGET) != null) {
                    mapString = mapString + " target=\"" + areaAttribs.getAttribute(HTML.Attribute.TARGET).toString() + "\" ";
                }
                String coords = "coords=\"";
                if (shape instanceof Polygon) {
                    Polygon poly = (Polygon)shape;
                    for (int j = 0; j < poly.npoints; ++j) {
                        if (j > 0) {
                            coords = coords + ",";
                        }
                        coords = coords + poly.xpoints[j] + "," + poly.ypoints[j];
                    }
                } else if (shape instanceof Circle) {
                    rect = (Rectangle)shape;
                    coords = coords + (rect.x + rect.width / 2) + "," + (rect.y + rect.height / 2) + "," + rect.width / 2;
                } else if (shape instanceof Rectangle) {
                    rect = (Rectangle)shape;
                    coords = coords + rect.x + "," + rect.y + "," + (rect.x + rect.width) + "," + (rect.y + rect.height);
                }
                coords = coords + "\"";
                mapString = mapString + coords + "/ >";
            }
            mapString = mapString + "</map>";
            return mapString;
        }

        public void createShapes() {
            this.shapes.removeAllElements();
            for (int i = 0; i < this.areas.size(); ++i) {
                AttributeSet attr = (AttributeSet)this.areas.elementAt(i);
                Object shape = attr.getAttribute(HTML.Attribute.SHAPE);
                Object coords = attr.getAttribute(HTML.Attribute.COORDS);
                if (coords == null) continue;
                int[] int_coords = this.extractCoords(coords);
                if (shape != null && shape.toString().equalsIgnoreCase("polygon")) {
                    int array_length = int_coords.length / 2;
                    int[] x_coords = new int[array_length];
                    int[] y_coords = new int[array_length];
                    int x_count = 0;
                    int y_count = 0;
                    for (int j = 0; j < int_coords.length; ++j) {
                        if (j % 2 == 0) {
                            x_coords[x_count] = int_coords[j];
                            ++x_count;
                            continue;
                        }
                        y_coords[y_count] = int_coords[j];
                        ++y_count;
                    }
                    Polygon poly = new Polygon(x_coords, y_coords, array_length);
                    this.shapes.addElement(poly);
                    continue;
                }
                if (shape != null && shape.toString().equalsIgnoreCase("rect")) {
                    Rectangle poly = new Rectangle(int_coords[0], int_coords[1], int_coords[2] - int_coords[0], int_coords[3] - int_coords[1]);
                    this.shapes.addElement(poly);
                    continue;
                }
                if (shape == null || !shape.toString().equalsIgnoreCase("circle")) continue;
                Circle poly = new Circle(int_coords[0], int_coords[1], int_coords[2]);
                this.shapes.addElement(poly);
            }
        }

        public Shape getShapeForPoint(int x, int y) {
            for (int i = 0; i < this.shapes.size(); ++i) {
                Shape shape = (Shape)this.shapes.elementAt(i);
                if (shape instanceof Polygon) {
                    ((Polygon)shape).translate(this.lastPaintBounds.x, this.lastPaintBounds.y);
                } else if (shape instanceof Rectangle) {
                    ((Rectangle)shape).translate(this.lastPaintBounds.x, this.lastPaintBounds.y);
                }
                if (shape.contains(x, y)) {
                    if (shape instanceof Polygon) {
                        ((Polygon)shape).translate(-this.lastPaintBounds.x, -this.lastPaintBounds.y);
                    } else if (shape instanceof Rectangle) {
                        ((Rectangle)shape).translate(-this.lastPaintBounds.x, -this.lastPaintBounds.y);
                    }
                    return shape;
                }
                if (shape instanceof Polygon) {
                    ((Polygon)shape).translate(-this.lastPaintBounds.x, -this.lastPaintBounds.y);
                    continue;
                }
                if (!(shape instanceof Rectangle)) continue;
                ((Rectangle)shape).translate(-this.lastPaintBounds.x, -this.lastPaintBounds.y);
            }
            return null;
        }

        public void paintAreas(Graphics g, Rectangle imageBounds, Rectangle clipBounds) {
            this.lastPaintBounds = imageBounds;
            for (int i = 0; i < this.shapes.size(); ++i) {
                int[] int_coords;
                Stroke defaultStroke;
                Shape shape = (Shape)this.shapes.elementAt(i);
                if (shape != null && shape instanceof Polygon) {
                    Polygon poly = (Polygon)shape;
                    int array_length = poly.npoints;
                    poly.translate(imageBounds.x, imageBounds.y);
                    int[] x_coords = poly.xpoints;
                    int[] y_coords = poly.ypoints;
                    Stroke defaultStroke2 = ((Graphics2D)g).getStroke();
                    ((Graphics2D)g).setStroke(EditorHTMLDocument.this.mapStroke);
                    g.setXORMode(Color.white);
                    if (poly == this.selectedShape) {
                        g.setColor(Color.red);
                        if (this.drawingPoly) {
                            g.drawPolyline(poly.xpoints, poly.ypoints, poly.npoints);
                        } else {
                            g.drawPolygon(poly);
                        }
                    } else {
                        g.setColor(Color.black);
                        g.drawPolygon(poly);
                    }
                    for (int j = 0; j < array_length; ++j) {
                        g.drawRect(x_coords[j] - 2, y_coords[j] - 2, 4, 4);
                    }
                    g.setPaintMode();
                    poly.translate(-imageBounds.x, -imageBounds.y);
                    ((Graphics2D)g).setStroke(defaultStroke2);
                    continue;
                }
                if (shape != null && shape instanceof Circle) {
                    defaultStroke = ((Graphics2D)g).getStroke();
                    ((Graphics2D)g).setStroke(EditorHTMLDocument.this.mapStroke);
                    g.setXORMode(Color.white);
                    Rectangle poly = (Rectangle)shape;
                    if (poly == this.selectedShape) {
                        g.setColor(Color.red);
                    } else {
                        g.setColor(Color.black);
                    }
                    poly.translate(imageBounds.x, imageBounds.y);
                    g.drawOval(poly.x, poly.y, poly.width, poly.height);
                    int_coords = new int[]{poly.x, poly.y};
                    int width = poly.width;
                    int height = poly.height;
                    g.drawRect(int_coords[0] - 2, int_coords[1] - 2, 4, 4);
                    g.drawRect(int_coords[0] - 2 + width, int_coords[1] - 2, 4, 4);
                    g.drawRect(int_coords[0] - 2 + width, int_coords[1] - 2 + height, 4, 4);
                    g.drawRect(int_coords[0] - 2, int_coords[1] - 2 + height, 4, 4);
                    poly.translate(-imageBounds.x, -imageBounds.y);
                    g.setPaintMode();
                    ((Graphics2D)g).setStroke(defaultStroke);
                    continue;
                }
                if (shape == null || !(shape instanceof Rectangle)) continue;
                defaultStroke = ((Graphics2D)g).getStroke();
                ((Graphics2D)g).setStroke(EditorHTMLDocument.this.mapStroke);
                g.setXORMode(Color.white);
                Rectangle poly = (Rectangle)shape;
                if (poly == this.selectedShape) {
                    g.setColor(Color.red);
                } else {
                    g.setColor(Color.black);
                }
                poly.translate(imageBounds.x, imageBounds.y);
                g.drawRect(poly.x, poly.y, poly.width, poly.height);
                int_coords = new int[]{poly.x, poly.y};
                int width = poly.width;
                int height = poly.height;
                g.drawRect(int_coords[0] - 2, int_coords[1] - 2, 4, 4);
                g.drawRect(int_coords[0] - 2 + width, int_coords[1] - 2, 4, 4);
                g.drawRect(int_coords[0] - 2 + width, int_coords[1] - 2 + height, 4, 4);
                g.drawRect(int_coords[0] - 2, int_coords[1] - 2 + height, 4, 4);
                poly.translate(-imageBounds.x, -imageBounds.y);
                g.setPaintMode();
                ((Graphics2D)g).setStroke(defaultStroke);
            }
        }

        int[] extractCoords(Object stringCoords) {
            if (stringCoords == null || !(stringCoords instanceof String)) {
                return null;
            }
            StringTokenizer st = new StringTokenizer((String)stringCoords, ", \t\n\r");
            int[] retValue = null;
            int numCoords = 0;
            while (st.hasMoreElements()) {
                int scale;
                String token = st.nextToken();
                if (token.endsWith("%")) {
                    scale = -1;
                    token = token.substring(0, token.length() - 1);
                } else {
                    scale = 1;
                }
                try {
                    int intValue = Integer.parseInt(token);
                    if (retValue == null) {
                        retValue = new int[4];
                    } else if (numCoords == retValue.length) {
                        int[] temp = new int[retValue.length * 2];
                        System.arraycopy(retValue, 0, temp, 0, retValue.length);
                        retValue = temp;
                    }
                    retValue[numCoords++] = intValue * scale;
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            if (numCoords > 0 && numCoords != retValue.length) {
                int[] temp = new int[numCoords];
                System.arraycopy(retValue, 0, temp, 0, numCoords);
                retValue = temp;
            }
            return retValue;
        }

        class Circle
        extends Rectangle {
            public Circle(int x, int y, int radius) {
                super(x - radius, y - radius, 2 * radius, 2 * radius);
            }
        }
    }
}

