/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.util.Vector;
import javax.swing.text.BadLocationException;
import javax.swing.text.GapContent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class EditorGapContent
extends GapContent {
    public EditorGapContent(int initialLength) {
        super(initialLength);
    }

    public UndoableEdit insertString(int where, String str) throws BadLocationException {
        if (where > this.length() || where < 0) {
            throw new BadLocationException("Invalid insert", this.length());
        }
        char[] chars = str.toCharArray();
        this.replace(where, 0, chars, chars.length);
        return new InsertUndo(where, str.length());
    }

    class InsertUndo
    extends AbstractUndoableEdit {
        protected int offset;
        protected int length;
        protected String string;
        protected Vector posRefs;

        protected InsertUndo(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            try {
                if (this.offset + this.length > EditorGapContent.this.length()) {
                    return;
                }
                this.posRefs = EditorGapContent.this.getPositionsInRange(null, this.offset, this.length);
                this.string = EditorGapContent.this.getString(this.offset, this.length);
                EditorGapContent.this.remove(this.offset, this.length);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            try {
                EditorGapContent.this.insertString(this.offset, this.string);
                this.string = null;
                if (this.posRefs != null) {
                    EditorGapContent.this.updateUndoPositions(this.posRefs, this.offset, this.length);
                    this.posRefs = null;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

