/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Color;
import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import javax.swing.JLabel;
import javax.swing.text.AttributeSet;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;

public class CustomizableObjectView
extends ComponentView {
    public CustomizableObjectView(Element elem) {
        super(elem);
    }

    protected Component createComponent() {
        AttributeSet attr = this.getElement().getAttributes();
        String classname = (String)attr.getAttribute(HTML.Attribute.CLASSID);
        try {
            Class<?> c = Class.forName(classname);
            Object o = c.newInstance();
            if (o instanceof Component) {
                Component comp = (Component)o;
                CustomizableObjectView.setParameters(comp, attr);
                return comp;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        Component comp = this.getUnloadableRepresentation();
        return comp;
    }

    Component getUnloadableRepresentation() {
        JLabel comp = new JLabel("<Object>");
        ((Component)comp).setForeground(Color.red);
        return comp;
    }

    private Class getClass(String classname) throws ClassNotFoundException {
        Class<?> docClass = this.getDocument().getClass();
        ClassLoader loader = docClass.getClassLoader();
        Class<?> klass = loader != null ? loader.loadClass(classname) : Class.forName(classname);
        return klass;
    }

    public static void setParameters(Component comp, AttributeSet attr) {
        BeanInfo bi;
        Class<?> k = comp.getClass();
        try {
            bi = Introspector.getBeanInfo(k);
        }
        catch (IntrospectionException ex) {
            System.err.println("introspector failed, ex: " + ex);
            return;
        }
        PropertyDescriptor[] props = bi.getPropertyDescriptors();
        for (int i = 0; i < props.length; ++i) {
            Object v = attr.getAttribute(props[i].getName());
            Enumeration<?> enum_ = attr.getAttributeNames();
            while (enum_.hasMoreElements()) {
                Object name = enum_.nextElement();
                if (!name.toString().equalsIgnoreCase(props[i].getName())) continue;
                v = attr.getAttribute(name);
                break;
            }
            if (!(v instanceof String)) continue;
            String value = (String)v;
            Method writer = props[i].getWriteMethod();
            if (writer == null) {
                return;
            }
            Class<?>[] params = writer.getParameterTypes();
            if (params.length != 1) {
                return;
            }
            Object[] args = new String[]{value};
            try {
                writer.invoke((Object)comp, args);
                continue;
            }
            catch (Exception ex) {
                System.err.println("Invocation failed");
            }
        }
    }
}

