/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.util.Enumeration;
import java.util.Hashtable;

public class CustomXMLTagsGrammarSpecification {
    public static final String EMPTY_TAG = "LEAF_TAG";
    public static final String BLOCK_TAG = "BLOCK_TAG";
    public static final String INLINE_TAG = "INLINE_TAG";
    static Hashtable tagsMap = new Hashtable();
    static Hashtable emptyTagsComponentMap = new Hashtable();
    static Hashtable tagsRendingModesMap = new Hashtable();
    static boolean treatAllBlockTagsAsBlocks = false;

    public static boolean isTreatAllBlockTagsAsBlocks() {
        return treatAllBlockTagsAsBlocks;
    }

    public static void setTreatAllBlockTagsAsBlocks(boolean treat) {
        treatAllBlockTagsAsBlocks = treat;
    }

    public static String getOriginalTagName(String tagName) {
        try {
            Enumeration namesEnum = tagsMap.keys();
            while (namesEnum.hasMoreElements()) {
                String nextName = (String)namesEnum.nextElement();
                if (!nextName.equalsIgnoreCase(tagName)) continue;
                return nextName;
            }
            return tagName;
        }
        catch (Throwable throwable) {
            return tagName;
        }
    }

    public static boolean isTagRegistered(String tagName) {
        try {
            Boolean value = (Boolean)tagsMap.get(tagName);
            if (value != null) {
                return true;
            }
            String origTagName = CustomXMLTagsGrammarSpecification.getOriginalTagName(tagName);
            if (value == null && origTagName != null) {
                value = (Boolean)tagsMap.get(origTagName);
            }
            return value != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean isTagEmpty(String tagName) {
        Boolean isEmpty = (Boolean)tagsMap.get(tagName);
        String origTagName = CustomXMLTagsGrammarSpecification.getOriginalTagName(tagName);
        if (isEmpty == null && origTagName != null) {
            isEmpty = (Boolean)tagsMap.get(origTagName);
        }
        if (isEmpty != null) {
            return isEmpty;
        }
        return false;
    }

    public static boolean isTagRenderingAsBlock(String tagName) {
        String type = (String)tagsRendingModesMap.get(tagName);
        if (type != null && type.equals(BLOCK_TAG)) {
            return true;
        }
        if (type != null && type.equals(INLINE_TAG)) {
            return false;
        }
        return CustomXMLTagsGrammarSpecification.isTreatAllBlockTagsAsBlocks() && !CustomXMLTagsGrammarSpecification.isTagEmpty(tagName);
    }

    public static void registerCustomXMLTag(String tagName, boolean isLeaf) {
        tagsMap.put(tagName, new Boolean(isLeaf));
    }

    public static void registerCustomXMLTagRenderingType(String tagName, String renderingMode) {
        tagsRendingModesMap.put(tagName, renderingMode);
    }

    public static void registerEmptyCustomXMLTagComponentRepresentation(String tagName, String className) {
        emptyTagsComponentMap.put(tagName, className);
    }

    public static Hashtable getGrammarSpecification() {
        return tagsMap;
    }

    public static Hashtable getRenderingModesSpecification() {
        return tagsRendingModesMap;
    }

    static Hashtable getGrammarComponentMapping() {
        return emptyTagsComponentMap;
    }
}

