/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.border.AbstractBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import sferyx.administration.editors.EditorHTMLDocument;
import sferyx.administration.editors.HTMLEditor;
import sferyx.administration.editors.SferyxUtilities;

public class CustomTableView
extends View {
    BoxView parentView;
    Color selectionColor;
    int initialPoint = 0;
    int initialChildSize = -1;
    int currentChildSize = -1;
    int difference = 0;
    int horizontalDifference = 0;
    boolean firstTime = true;
    boolean paintInvisibleCells;
    static float[] dash1 = new float[]{2.0f};
    static BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 1.0f, dash1, 0.0f);
    boolean added = false;
    Rectangle boundsRect = new Rectangle(0, 0, 0, 0);
    int border_size = 0;
    Hashtable view_bounds_mapping = new Hashtable();
    Hashtable element_bounds_mapping = new Hashtable();
    float[] dotted_dash = new float[]{2.0f};
    float[] dashed_dash = new float[]{7.0f};

    public CustomTableView(Element elem, View view, boolean paintInvisibleCells) {
        super(elem);
        this.parentView = (BoxView)view;
        int red = SystemColor.textHighlight.getRed();
        int green = SystemColor.textHighlight.getGreen();
        int blue = SystemColor.textHighlight.getBlue();
        this.selectionColor = new Color(red, green, blue, 125);
        this.paintInvisibleCells = paintInvisibleCells;
    }

    public View getAttachedView() {
        return this.parentView;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paint(Graphics g, Shape allocation) {
        try {
            if (allocation == null) {
                return;
            }
            if (g == null) {
                return;
            }
            AbstractDocument.AbstractElement my_element = (AbstractDocument.AbstractElement)this.getElement();
            Object border_attrib = my_element.getAttribute(HTML.Attribute.BORDER);
            border_attrib = my_element.getAttribute("border");
            this.view_bounds_mapping.clear();
            this.element_bounds_mapping.clear();
            Rectangle a = (Rectangle)((Rectangle)allocation).clone();
            this.boundsRect.x = a.x;
            this.boundsRect.y = a.y;
            this.boundsRect.width = a.width;
            this.boundsRect.height = this.parentView.getHeight();
            allocation = this.boundsRect;
            if (border_attrib != null) {
                try {
                    this.border_size = Integer.parseInt((String)border_attrib);
                    if (this.border_size > 0 && ((EditorHTMLDocument)this.getDocument()).selectedCells.size() != 0) {
                        // empty if block
                    }
                }
                catch (Exception exc) {
                    // empty catch block
                }
            }
            boolean rowRemoved = false;
            if (g instanceof Graphics2D) {
                Stroke stroke = ((Graphics2D)g).getStroke();
                double topMargin = 0.0;
                double bottomMargin = 0.0;
                double leftMargin = 0.0;
                double rightMargin = 0.0;
                try {
                    if (this.parentView.getAttributes().getAttribute(CSS.Attribute.MARGIN_TOP) != null && this.parentView.getAttributes().isDefined(CSS.Attribute.MARGIN_TOP)) {
                        topMargin = (int)SferyxUtilities.getNumberFromCSString(this.parentView.getAttributes().getAttribute(CSS.Attribute.MARGIN_TOP).toString());
                    }
                }
                catch (Throwable exc) {
                    // empty catch block
                }
                try {
                    bottomMargin = ((HTMLDocument)this.getElement().getDocument()).getStyleSheet().getBoxPainter(my_element.getAttributes()).getInset(3, this.getAttachedView());
                }
                catch (Throwable exc) {
                    // empty catch block
                }
                try {
                    if (this.parentView.getAttributes().getAttribute(CSS.Attribute.MARGIN_LEFT) != null && this.parentView.getAttributes().isDefined(CSS.Attribute.MARGIN_LEFT)) {
                        leftMargin = (int)SferyxUtilities.getNumberFromCSString(this.parentView.getAttributes().getAttribute(CSS.Attribute.MARGIN_LEFT).toString());
                    }
                }
                catch (Throwable exc) {
                    // empty catch block
                }
                try {
                    rightMargin = ((HTMLDocument)this.getElement().getDocument()).getStyleSheet().getBoxPainter(my_element.getAttributes()).getInset(4, this.getAttachedView());
                }
                catch (Throwable exc) {
                    // empty catch block
                }
                if (this.initialChildSize == -1) {
                    this.initialChildSize = this.parentView.getViewCount();
                }
                this.currentChildSize = this.parentView.getViewCount();
                if (this.currentChildSize == this.initialChildSize) {
                    this.initialChildSize = this.currentChildSize;
                } else if (this.initialChildSize != this.currentChildSize) {
                    rowRemoved = true;
                }
                for (int i = 0; i < this.parentView.getViewCount(); ++i) {
                    View view = this.parentView.getView(i);
                    AbstractDocument.AbstractElement element = (AbstractDocument.AbstractElement)view.getElement();
                    if (!element.getAttribute(StyleConstants.NameAttribute).equals(HTML.Tag.TR)) continue;
                    Shape childAlloc = this.parentView.getChildAllocation(i, allocation);
                    Rectangle rowRectangle = (Rectangle)childAlloc;
                    if (rowRemoved && i == 0) {
                        this.difference = this.difference + rowRectangle.y - this.initialPoint;
                        this.initialChildSize = this.currentChildSize;
                    }
                    if (i == 0 && !rowRemoved) {
                        this.initialPoint = rowRectangle.y;
                    }
                    for (int j = 0; j < view.getViewCount(); ++j) {
                        int leftBorderWidth;
                        int rightBorderWidth;
                        int topBorderWidth;
                        int bottomBorderWidth;
                        View cellView = view.getView(j);
                        AbstractDocument.AbstractElement tdelement = (AbstractDocument.AbstractElement)cellView.getElement();
                        if (!tdelement.getAttribute(StyleConstants.NameAttribute).equals(HTML.Tag.TD) && !tdelement.getAttribute(StyleConstants.NameAttribute).equals(HTML.Tag.TH)) continue;
                        Rectangle childRect = (Rectangle)view.getChildAllocation(j, childAlloc);
                        childRect.x -= (int)leftMargin;
                        childRect.y -= (int)topMargin;
                        g.setColor(Color.lightGray);
                        if (this.border_size != 0 || this.paintInvisibleCells) {
                            // empty if block
                        }
                        if ((bottomBorderWidth = this.getCellBottomBorderSize(tdelement.getAttributes(), cellView.getElement())) > 0) {
                            Stroke origStroke = ((Graphics2D)g).getStroke();
                            g.setColor(this.getBottomBorderColor(cellView.getAttributes()));
                            ((Graphics2D)g).setStroke(new BasicStroke(bottomBorderWidth));
                            ((Graphics2D)g).setStroke(origStroke);
                        }
                        if ((topBorderWidth = this.getCellTopBorderSize(cellView.getAttributes(), cellView.getElement())) > 0) {
                            Stroke origStroke = ((Graphics2D)g).getStroke();
                            g.setColor(this.getTopBorderColor(cellView.getAttributes()));
                            ((Graphics2D)g).setStroke(new BasicStroke(topBorderWidth));
                            ((Graphics2D)g).setStroke(origStroke);
                        }
                        if ((rightBorderWidth = this.getCellRightBorderSize(cellView.getAttributes(), cellView.getElement())) > 0) {
                            Stroke origStroke = ((Graphics2D)g).getStroke();
                            g.setColor(this.getRightBorderColor(cellView.getAttributes()));
                            ((Graphics2D)g).setStroke(new BasicStroke(rightBorderWidth));
                            ((Graphics2D)g).setStroke(origStroke);
                        }
                        if ((leftBorderWidth = this.getCellLeftBorderSize(cellView.getAttributes(), cellView.getElement())) > 0) {
                            Stroke origStroke = ((Graphics2D)g).getStroke();
                            g.setColor(this.getLeftBorderColor(cellView.getAttributes()));
                            ((Graphics2D)g).setStroke(new BasicStroke(leftBorderWidth));
                            ((Graphics2D)g).setStroke(origStroke);
                        }
                        if (((EditorHTMLDocument)this.getDocument()).selectedCells.contains(tdelement)) {
                            g.setColor(this.selectionColor);
                            g.setPaintMode();
                        }
                        childRect.y -= this.difference;
                        this.view_bounds_mapping.put(cellView, childRect.clone());
                        this.element_bounds_mapping.put(tdelement, childRect.clone());
                    }
                }
            }
            ((Rectangle)allocation).y -= this.difference;
            return;
        }
        catch (Throwable thr) {
            thr.printStackTrace();
        }
    }

    void inspectTable(View tableView, Shape allocation, Graphics g) {
        try {
            for (int i = 0; i < tableView.getViewCount(); ++i) {
                View childView = tableView.getView(i);
                AbstractDocument.AbstractElement element = (AbstractDocument.AbstractElement)childView.getElement();
                Shape childAlloc = tableView.getChildAllocation(i, allocation);
                if (!element.getAttribute(StyleConstants.NameAttribute).equals(HTML.Tag.TR)) continue;
                for (int j = 0; j < childView.getViewCount(); ++j) {
                    View cellView = childView.getView(j);
                    Shape cellAlloc = childView.getChildAllocation(j, childAlloc);
                    this.findTablesAndPaintThem(cellView, g, cellAlloc);
                }
            }
        }
        catch (Throwable thr) {
            // empty catch block
        }
    }

    void findTablesAndPaintThem(View tableCellView, Graphics g, Shape allocation) {
        for (int i = 0; i < tableCellView.getViewCount(); ++i) {
            View innerView = tableCellView.getView(i);
            Rectangle childAlloc = (Rectangle)tableCellView.getChildAllocation(i, allocation);
            if (!HTMLEditor.jvm_version.startsWith("1.5") || !innerView.getClass().getName().equals("javax.swing.text.html.TableView")) continue;
            ((HTMLDocument)this.getDocument()).getStyleSheet().getBoxPainter(innerView.getAttributes()).paint(g, childAlloc.x, childAlloc.y, childAlloc.width, childAlloc.height, this);
            innerView.paint(g, childAlloc);
        }
    }

    public void paintTableBorder(View cellView, Rectangle childRect, Graphics g) {
        int leftBorderWidth;
        String style;
        int rightBorderWidth;
        int topBorderWidth;
        int rightMargin;
        int bw = this.border_size;
        String bstyle = "";
        if (this.parentView.getAttributes().getAttribute(CSS.Attribute.BORDER_STYLE) != null) {
            bstyle = this.parentView.getAttributes().getAttribute(CSS.Attribute.BORDER_STYLE).toString();
        }
        bstyle = "outset";
        AbstractBorder border = null;
        childRect.width = ((BoxView)cellView).getWidth();
        if (cellView.getAttributes().getAttribute(CSS.Attribute.PADDING_LEFT) != null && cellView.getAttributes().isDefined(CSS.Attribute.PADDING_LEFT)) {
            int leftMargin = (int)SferyxUtilities.getNumberFromCSString(cellView.getAttributes().getAttribute(CSS.Attribute.PADDING_LEFT).toString());
            childRect.width = childRect.width + leftMargin + 1;
        }
        if (cellView.getAttributes().getAttribute(CSS.Attribute.PADDING_RIGHT) != null && cellView.getAttributes().isDefined(CSS.Attribute.PADDING_RIGHT)) {
            rightMargin = (int)SferyxUtilities.getNumberFromCSString(cellView.getAttributes().getAttribute(CSS.Attribute.PADDING_RIGHT).toString());
            childRect.width = childRect.width + rightMargin + 1;
        }
        if (cellView.getAttributes().getAttribute(CSS.Attribute.PADDING_TOP) != null && cellView.getAttributes().isDefined(CSS.Attribute.PADDING_TOP)) {
            rightMargin = (int)SferyxUtilities.getNumberFromCSString(cellView.getAttributes().getAttribute(CSS.Attribute.PADDING_TOP).toString());
        }
        if (cellView.getAttributes().getAttribute(CSS.Attribute.PADDING_BOTTOM) != null && cellView.getAttributes().isDefined(CSS.Attribute.PADDING_BOTTOM)) {
            rightMargin = (int)SferyxUtilities.getNumberFromCSString(cellView.getAttributes().getAttribute(CSS.Attribute.PADDING_BOTTOM).toString());
        }
        if (cellView.getAttributes().getAttribute(CSS.Attribute.MARGIN_BOTTOM) != null && cellView.getAttributes().isDefined(CSS.Attribute.MARGIN_BOTTOM)) {
            rightMargin = (int)SferyxUtilities.getNumberFromCSString(cellView.getAttributes().getAttribute(CSS.Attribute.MARGIN_BOTTOM).toString());
            childRect.height = childRect.height + rightMargin + 1;
        }
        if (cellView.getAttributes().getAttribute(CSS.Attribute.MARGIN_TOP) != null && cellView.getAttributes().isDefined(CSS.Attribute.MARGIN_TOP)) {
            rightMargin = (int)SferyxUtilities.getNumberFromCSString(cellView.getAttributes().getAttribute(CSS.Attribute.MARGIN_TOP).toString());
            childRect.height = childRect.height - rightMargin + 1;
        }
        if (cellView.getAttributes().getAttribute(CSS.Attribute.MARGIN_LEFT) != null && cellView.getAttributes().isDefined(CSS.Attribute.MARGIN_LEFT)) {
            rightMargin = (int)SferyxUtilities.getNumberFromCSString(cellView.getAttributes().getAttribute(CSS.Attribute.MARGIN_LEFT).toString());
            childRect.width = childRect.width - rightMargin + 1;
        }
        if (bw > 0) {
            if (bstyle.equals("inset")) {
                Color c = SferyxUtilities.getBorderColor(this.parentView.getElement(), this.parentView.getAttributes());
                border = new EtchedBorder(1, c.brighter(), c.darker());
            } else if (bstyle.equals("outset")) {
                Color c = this.getBorderColor(this.parentView.getAttributes());
                border = new EtchedBorder(0, c.brighter(), c.darker());
            } else if (bstyle.equals("solid")) {
                Color c = this.getBorderColor(this.parentView.getAttributes());
                border = new LineBorder(c);
            }
            border.paintBorder(null, g, childRect.x, childRect.y, childRect.width, childRect.height + 1);
            return;
        }
        int bottomMargin = 0;
        bottomMargin = (int)((HTMLDocument)this.getElement().getDocument()).getStyleSheet().getBoxPainter(this.parentView.getElement().getAttributes()).getInset(3, this.getAttachedView());
        int topMargin = 0;
        topMargin = (int)((HTMLDocument)this.getElement().getDocument()).getStyleSheet().getBoxPainter(this.parentView.getElement().getAttributes()).getInset(1, this.getAttachedView());
        int bottomBorderWidth = this.getCellBottomBorderSize(cellView.getAttributes(), cellView.getElement());
        if (bottomBorderWidth > 0) {
            Stroke origStroke = ((Graphics2D)g).getStroke();
            g.setColor(SferyxUtilities.getBottomBorderColor(cellView.getElement(), cellView.getAttributes()));
            String style2 = this.getBottomBorderStyle(cellView.getAttributes());
            Stroke stroke = origStroke;
            stroke = this.getBorderStroke(stroke, bottomBorderWidth, style2);
            ((Graphics2D)g).setStroke(stroke);
            ((Graphics2D)g).drawLine(childRect.x - bottomBorderWidth, childRect.y - this.difference + childRect.height, childRect.x + childRect.width + bottomBorderWidth, childRect.y - this.difference + childRect.height);
            if (style2.equals("double")) {
                ((Graphics2D)g).drawLine(childRect.x, childRect.y - this.difference + childRect.height + 2 * bottomBorderWidth, childRect.x + childRect.width, childRect.y - this.difference + childRect.height + 2 * bottomBorderWidth);
            }
            ((Graphics2D)g).setStroke(origStroke);
        }
        if ((topBorderWidth = this.getCellTopBorderSize(cellView.getAttributes(), cellView.getElement())) > 0) {
            Stroke origStroke = ((Graphics2D)g).getStroke();
            g.setColor(SferyxUtilities.getTopBorderColor(cellView.getElement(), cellView.getAttributes()));
            String style3 = this.getTopBorderStyle(cellView.getAttributes());
            Stroke stroke = origStroke;
            stroke = this.getBorderStroke(stroke, topBorderWidth, style3);
            ((Graphics2D)g).setStroke(stroke);
            ((Graphics2D)g).drawLine(childRect.x - topBorderWidth, childRect.y - this.difference, childRect.x + childRect.width + topBorderWidth, childRect.y - this.difference);
            if (style3.equals("double")) {
                ((Graphics2D)g).drawLine(childRect.x, childRect.y - this.difference - 2 * topBorderWidth, childRect.x + childRect.width, childRect.y - this.difference - 2 * topBorderWidth);
            }
            ((Graphics2D)g).setStroke(origStroke);
        }
        if ((rightBorderWidth = this.getCellRightBorderSize(cellView.getAttributes(), cellView.getElement())) > 0) {
            Stroke origStroke = ((Graphics2D)g).getStroke();
            g.setColor(SferyxUtilities.getRightBorderColor(cellView.getElement(), cellView.getAttributes()));
            style = this.getRightBorderStyle(cellView.getAttributes());
            Stroke stroke = origStroke;
            stroke = this.getBorderStroke(stroke, rightBorderWidth, style);
            ((Graphics2D)g).setStroke(stroke);
            ((Graphics2D)g).drawLine(childRect.x + childRect.width + rightBorderWidth, childRect.y - this.difference, childRect.x + childRect.width + rightBorderWidth, childRect.y - this.difference + childRect.height);
            if (style.equals("double")) {
                ((Graphics2D)g).drawLine(childRect.x + childRect.width + 2 * rightBorderWidth, childRect.y - this.difference, childRect.x + childRect.width + 2 * rightBorderWidth, childRect.y - this.difference + childRect.height);
            }
            ((Graphics2D)g).setStroke(origStroke);
        }
        if ((leftBorderWidth = this.getCellLeftBorderSize(cellView.getAttributes(), cellView.getElement())) > 0) {
            style = this.getLeftBorderStyle(cellView.getAttributes());
            Stroke origStroke = ((Graphics2D)g).getStroke();
            g.setColor(SferyxUtilities.getLeftBorderColor(cellView.getElement(), cellView.getAttributes()));
            Stroke stroke = origStroke;
            stroke = this.getBorderStroke(stroke, leftBorderWidth, style);
            ((Graphics2D)g).setStroke(stroke);
            ((Graphics2D)g).drawLine(childRect.x - leftBorderWidth, childRect.y - this.difference, childRect.x - leftBorderWidth, childRect.y - this.difference + childRect.height);
            if (style.equals("double")) {
                ((Graphics2D)g).drawLine(childRect.x - 2 * leftBorderWidth, childRect.y - this.difference, childRect.x - 2 * leftBorderWidth, childRect.y - this.difference + childRect.height);
            }
            ((Graphics2D)g).setStroke(origStroke);
        }
    }

    public Stroke getBorderStroke(Stroke stroke, int borderWidth, String style) {
        stroke = style.equals("dashed") ? new BasicStroke(borderWidth, 0, 0, 1.0f, this.dashed_dash, 0.0f) : (style.equals("dotted") ? new BasicStroke(borderWidth, 0, 0, 1.0f, this.dotted_dash, 0.0f) : new BasicStroke(borderWidth));
        return stroke;
    }

    public Color getBorderColor(AttributeSet attribs) {
        CSS.Attribute attribute_class = attribs.getAttribute(CSS.Attribute.BORDER_COLOR) != null && !attribs.getAttribute(CSS.Attribute.BORDER_COLOR).toString().equalsIgnoreCase("gray") ? CSS.Attribute.BORDER_COLOR : (attribs.getAttribute(CSS.Attribute.BORDER) != null ? CSS.Attribute.BORDER : CSS.Attribute.BORDER);
        return this.getColor(attribs, attribute_class);
    }

    public Color getTopBorderColor(AttributeSet attribs) {
        CSS.Attribute attribute_class;
        Color color;
        if (attribs.getAttribute(CSS.Attribute.BORDER_TOP) != null && (color = this.getColor(attribs, attribute_class = CSS.Attribute.BORDER_TOP)) != Color.gray) {
            return color;
        }
        attribute_class = attribs.getAttribute(CSS.Attribute.BORDER_COLOR) != null && !attribs.getAttribute(CSS.Attribute.BORDER_COLOR).toString().equalsIgnoreCase("gray") ? CSS.Attribute.BORDER_COLOR : (attribs.getAttribute(CSS.Attribute.BORDER) != null ? CSS.Attribute.BORDER : CSS.Attribute.BORDER);
        color = this.getColor(attribs, attribute_class);
        return color;
    }

    public Color getBottomBorderColor(AttributeSet attribs) {
        CSS.Attribute attribute_class;
        Color color;
        if (attribs.getAttribute(CSS.Attribute.BORDER_BOTTOM) != null && (color = this.getColor(attribs, attribute_class = CSS.Attribute.BORDER_BOTTOM)) != Color.gray) {
            return color;
        }
        attribute_class = attribs.getAttribute(CSS.Attribute.BORDER_COLOR) != null && !attribs.getAttribute(CSS.Attribute.BORDER_COLOR).toString().equalsIgnoreCase("gray") ? CSS.Attribute.BORDER_COLOR : (attribs.getAttribute(CSS.Attribute.BORDER) != null ? CSS.Attribute.BORDER : CSS.Attribute.BORDER);
        color = this.getColor(attribs, attribute_class);
        return color;
    }

    public Color getRightBorderColor(AttributeSet attribs) {
        CSS.Attribute attribute_class;
        Color color;
        if (attribs.getAttribute(CSS.Attribute.BORDER_RIGHT) != null && (color = this.getColor(attribs, attribute_class = CSS.Attribute.BORDER_RIGHT)) != Color.gray) {
            return color;
        }
        attribute_class = attribs.getAttribute(CSS.Attribute.BORDER_COLOR) != null && !attribs.getAttribute(CSS.Attribute.BORDER_COLOR).toString().equalsIgnoreCase("gray") ? CSS.Attribute.BORDER_COLOR : (attribs.getAttribute(CSS.Attribute.BORDER) != null ? CSS.Attribute.BORDER : CSS.Attribute.BORDER);
        color = this.getColor(attribs, attribute_class);
        return color;
    }

    public Color getLeftBorderColor(AttributeSet attribs) {
        CSS.Attribute attribute_class;
        Color color;
        if (attribs.getAttribute(CSS.Attribute.BORDER_LEFT) != null && (color = this.getColor(attribs, attribute_class = CSS.Attribute.BORDER_LEFT)) != Color.gray) {
            return color;
        }
        attribute_class = attribs.getAttribute(CSS.Attribute.BORDER_COLOR) != null && !attribs.getAttribute(CSS.Attribute.BORDER_COLOR).toString().equalsIgnoreCase("gray") ? CSS.Attribute.BORDER_COLOR : (attribs.getAttribute(CSS.Attribute.BORDER) != null ? CSS.Attribute.BORDER : CSS.Attribute.BORDER);
        color = this.getColor(attribs, attribute_class);
        return color;
    }

    public Color getColor(AttributeSet attribs, Object attribute_class) {
        if (attribs.getAttribute(attribute_class) != null) {
            String wholeAttributeString = attribs.getAttribute(attribute_class).toString();
            if (attribute_class == CSS.Attribute.BORDER_COLOR) {
                return ((HTMLDocument)this.parentView.getElement().getDocument()).getStyleSheet().stringToColor(wholeAttributeString);
            }
            if (wholeAttributeString.indexOf("rgb(") != -1) {
                int start = wholeAttributeString.indexOf("rgb(");
                int end = wholeAttributeString.indexOf(")", start);
                return ((HTMLDocument)this.parentView.getElement().getDocument()).getStyleSheet().stringToColor(wholeAttributeString.substring(start, end + 1));
            }
            StringTokenizer st = new StringTokenizer(wholeAttributeString, " ;");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.startsWith("#")) {
                    return ((HTMLDocument)this.parentView.getElement().getDocument()).getStyleSheet().stringToColor(token);
                }
                if (token.equalsIgnoreCase("Black")) {
                    return ((HTMLDocument)this.parentView.getElement().getDocument()).getStyleSheet().stringToColor("000000");
                }
                if (token.equalsIgnoreCase("Silver")) {
                    return ((HTMLDocument)this.parentView.getElement().getDocument()).getStyleSheet().stringToColor("C0C0C0");
                }
                if (token.equalsIgnoreCase("Gray")) {
                    return ((HTMLDocument)this.parentView.getElement().getDocument()).getStyleSheet().stringToColor("808080");
                }
                if (token.equalsIgnoreCase("White")) {
                    return ((HTMLDocument)this.parentView.getElement().getDocument()).getStyleSheet().stringToColor("FFFFFF");
                }
                if (token.equalsIgnoreCase("Maroon")) {
                    return ((HTMLDocument)this.parentView.getElement().getDocument()).getStyleSheet().stringToColor("800000");
                }
                if (token.equalsIgnoreCase("Red")) {
                    return ((HTMLDocument)this.parentView.getElement().getDocument()).getStyleSheet().stringToColor("FF0000");
                }
                if (token.equalsIgnoreCase("Purple")) {
                    return ((HTMLDocument)this.parentView.getElement().getDocument()).getStyleSheet().stringToColor("800080");
                }
                if (token.equalsIgnoreCase("Fuchsia")) {
                    return ((HTMLDocument)this.parentView.getElement().getDocument()).getStyleSheet().stringToColor("FF00FF");
                }
                if (token.equalsIgnoreCase("Green")) {
                    return ((HTMLDocument)this.parentView.getElement().getDocument()).getStyleSheet().stringToColor("008000");
                }
                if (token.equalsIgnoreCase("Lime")) {
                    return ((HTMLDocument)this.parentView.getElement().getDocument()).getStyleSheet().stringToColor("00FF00");
                }
                if (token.equalsIgnoreCase("Olive")) {
                    return ((HTMLDocument)this.parentView.getElement().getDocument()).getStyleSheet().stringToColor("808000");
                }
                if (token.equalsIgnoreCase("Yellow")) {
                    return ((HTMLDocument)this.parentView.getElement().getDocument()).getStyleSheet().stringToColor("FFFF00");
                }
                if (token.equalsIgnoreCase("Navy")) {
                    return ((HTMLDocument)this.parentView.getElement().getDocument()).getStyleSheet().stringToColor("000080");
                }
                if (token.equalsIgnoreCase("Blue")) {
                    return ((HTMLDocument)this.parentView.getElement().getDocument()).getStyleSheet().stringToColor("0000FF");
                }
                if (token.equalsIgnoreCase("Teal")) {
                    return ((HTMLDocument)this.parentView.getElement().getDocument()).getStyleSheet().stringToColor("008080");
                }
                if (token.equalsIgnoreCase("Aqua")) {
                    return ((HTMLDocument)this.parentView.getElement().getDocument()).getStyleSheet().stringToColor("00FFFF");
                }
                if (!token.equalsIgnoreCase("Orange")) continue;
                return ((HTMLDocument)this.parentView.getElement().getDocument()).getStyleSheet().stringToColor("FFA500");
            }
            return Color.gray;
        }
        return Color.gray;
    }

    public String getTopBorderStyle(AttributeSet attribs) {
        Object attribute_class = attribs.getAttribute("border-top-style") != null ? "border-top-style" : (attribs.getAttribute(CSS.Attribute.BORDER_TOP) != null ? CSS.Attribute.BORDER_TOP : CSS.Attribute.BORDER);
        return this.getBorderStlyeValue(attribs, attribute_class);
    }

    public String getBottomBorderStyle(AttributeSet attribs) {
        Object attribute_class = attribs.getAttribute("border-bottom-style") != null ? "border-bottom-style" : (attribs.getAttribute(CSS.Attribute.BORDER_BOTTOM) != null ? CSS.Attribute.BORDER_BOTTOM : CSS.Attribute.BORDER);
        return this.getBorderStlyeValue(attribs, attribute_class);
    }

    public String getLeftBorderStyle(AttributeSet attribs) {
        Object attribute_class = attribs.getAttribute("border-left-style") != null ? "border-left-style" : (attribs.getAttribute(CSS.Attribute.BORDER_LEFT) != null ? CSS.Attribute.BORDER_LEFT : CSS.Attribute.BORDER);
        return this.getBorderStlyeValue(attribs, attribute_class);
    }

    public String getRightBorderStyle(AttributeSet attribs) {
        Object attribute_class = attribs.getAttribute("border-right-style") != null ? "border-right-style" : (attribs.getAttribute(CSS.Attribute.BORDER_RIGHT) != null ? CSS.Attribute.BORDER_RIGHT : CSS.Attribute.BORDER);
        return this.getBorderStlyeValue(attribs, attribute_class);
    }

    public String getBorderStlyeValue(AttributeSet attribs, Object attribute_class) {
        if (attribs.getAttribute(attribute_class) == null) {
            return "none";
        }
        String border_width_str = attribs.getAttribute(attribute_class).toString();
        if (border_width_str.indexOf("none") != -1) {
            return "none";
        }
        if (border_width_str.indexOf("hidden") != -1) {
            return "hidden";
        }
        if (border_width_str.indexOf("dotted") != -1) {
            return "dotted";
        }
        if (border_width_str.indexOf("dashed") != -1) {
            return "dashed";
        }
        if (border_width_str.indexOf("solid") != -1) {
            return "solid";
        }
        if (border_width_str.indexOf("double") != -1) {
            return "double";
        }
        if (border_width_str.indexOf("groove") != -1) {
            return "groove";
        }
        if (border_width_str.indexOf("ridge") != -1) {
            return "ridge";
        }
        if (border_width_str.indexOf("inset") != -1) {
            return "inset";
        }
        if (border_width_str.indexOf("outset") != -1) {
            return "outset";
        }
        return "none";
    }

    public int getCellTopBorderSize(AttributeSet attribs, Element elem) {
        CSS.Attribute attribute_class = SferyxUtilities.getStyleSheetCSSValueForElement(elem, CSS.Attribute.BORDER_TOP_WIDTH) != null ? CSS.Attribute.BORDER_TOP_WIDTH : (SferyxUtilities.getStyleSheetCSSValueForElement(elem, CSS.Attribute.BORDER_TOP) != null ? CSS.Attribute.BORDER_TOP : (SferyxUtilities.getStyleSheetCSSValueForElement(elem, CSS.Attribute.BORDER_RIGHT_WIDTH) != null ? CSS.Attribute.BORDER_WIDTH : CSS.Attribute.BORDER));
        return this.getBorderThiknessValue(attribs, attribute_class, elem);
    }

    public int getCellRightBorderSize(AttributeSet attribs, Element elem) {
        CSS.Attribute attribute_class = SferyxUtilities.getStyleSheetCSSValueForElement(elem, CSS.Attribute.BORDER_RIGHT_WIDTH) != null ? CSS.Attribute.BORDER_RIGHT_WIDTH : (SferyxUtilities.getStyleSheetCSSValueForElement(elem, CSS.Attribute.BORDER_RIGHT) != null ? CSS.Attribute.BORDER_RIGHT : (SferyxUtilities.getStyleSheetCSSValueForElement(elem, CSS.Attribute.BORDER_WIDTH) != null ? CSS.Attribute.BORDER_WIDTH : CSS.Attribute.BORDER));
        return this.getBorderThiknessValue(attribs, attribute_class, elem);
    }

    public int getCellLeftBorderSize(AttributeSet attribs, Element elem) {
        CSS.Attribute attribute_class = SferyxUtilities.getStyleSheetCSSValueForElement(elem, CSS.Attribute.BORDER_LEFT_WIDTH) != null ? CSS.Attribute.BORDER_LEFT_WIDTH : (SferyxUtilities.getStyleSheetCSSValueForElement(elem, CSS.Attribute.BORDER_LEFT) != null ? CSS.Attribute.BORDER_LEFT : (SferyxUtilities.getStyleSheetCSSValueForElement(elem, CSS.Attribute.BORDER_WIDTH) != null ? CSS.Attribute.BORDER_WIDTH : CSS.Attribute.BORDER));
        return this.getBorderThiknessValue(attribs, attribute_class, elem);
    }

    public int getBorderThiknessValue(AttributeSet attribs, Object attribute_class, Element elem) {
        Object css_border_width = SferyxUtilities.getStyleSheetCSSValueForElement(elem, (CSS.Attribute)attribute_class);
        if (css_border_width == null) {
            return 0;
        }
        String border_width_str = css_border_width.toString();
        if (border_width_str.indexOf("pt") != -1) {
            if ((border_width_str = border_width_str.substring(0, border_width_str.indexOf("pt")).trim()).indexOf(" ") != -1) {
                int indexOfSpace = border_width_str.lastIndexOf(" ");
                border_width_str = border_width_str.substring(indexOfSpace).trim();
            }
            try {
                int borderSize = Integer.parseInt(border_width_str);
                return borderSize;
            }
            catch (Throwable thr) {}
        } else if (border_width_str.indexOf("px") != -1) {
            if ((border_width_str = border_width_str.substring(0, border_width_str.indexOf("px")).trim()).indexOf(" ") != -1) {
                int indexOfSpace = border_width_str.lastIndexOf(" ");
                border_width_str = border_width_str.substring(indexOfSpace).trim();
            }
            try {
                int borderSize = Integer.parseInt(border_width_str);
                return borderSize;
            }
            catch (Throwable thr) {}
        } else {
            if (border_width_str.indexOf("thin") != -1) {
                return 2;
            }
            if (border_width_str.indexOf("medium") != -1) {
                return 5;
            }
            if (border_width_str.indexOf("thick") != -1) {
                return 10;
            }
            if (border_width_str.indexOf("solid") != -1) {
                return 4;
            }
        }
        try {
            int intValue = Integer.parseInt(border_width_str);
            return intValue;
        }
        catch (Throwable thr) {
            return 0;
        }
    }

    public int getCellBottomBorderSize(AttributeSet attribs, Element elem) {
        CSS.Attribute attribute_class = SferyxUtilities.getStyleSheetCSSValueForElement(elem, CSS.Attribute.BORDER_BOTTOM_WIDTH) != null ? CSS.Attribute.BORDER_BOTTOM_WIDTH : (SferyxUtilities.getStyleSheetCSSValueForElement(elem, CSS.Attribute.BORDER_BOTTOM) != null ? CSS.Attribute.BORDER_BOTTOM : (SferyxUtilities.getStyleSheetCSSValueForElement(elem, CSS.Attribute.BORDER_WIDTH) != null ? CSS.Attribute.BORDER_WIDTH : CSS.Attribute.BORDER));
        return this.getBorderThiknessValue(attribs, attribute_class, elem);
    }

    public int getWidth() {
        return 0;
    }

    public int getHeight() {
        return 0;
    }

    public float getMaximumSpan(int axis) {
        return 0.0f;
    }

    public float getMinimumSpan(int axis) {
        return 0.0f;
    }

    public float getPreferredSpan(int param) {
        return 0.0f;
    }

    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        return this.parentView.modelToView(pos, a, b);
    }

    public float getAlignment(int axis) {
        return 0.0f;
    }

    public int viewToModel(float param, float param1, Shape shape, Position.Bias[] bias) {
        int childIndex = this.parentView.getViewCount() - 2;
        View child = this.parentView.getView(childIndex);
        Shape childBounds = this.parentView.getChildAllocation(childIndex, shape);
        return child.viewToModel(param, param1, shape, bias);
    }
}

