/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.BitSet;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import sferyx.administration.editors.CustomBoxPainter;
import sferyx.administration.editors.CustomTableCelView;
import sferyx.administration.editors.HTMLEditor;
import sferyx.administration.editors.TableView;

public class CustomTableRowView
extends BoxView {
    TableView tableView;
    private AttributeSet attr;
    BitSet fillColumns;
    int rowIndex;
    int viewIndex;
    boolean multiRowCells;
    boolean loading = false;
    CustomBoxPainter boxPainter = null;
    int[] offsets_X = new int[0];
    int[] offsets_Y = new int[0];
    int[] spans_X = new int[0];
    int[] spans_Y = new int[0];
    int lastTargetSpan_Y = -1;

    public CustomTableRowView(Element elem, TableView view) {
        super(elem, 0);
        this.tableView = view;
        this.fillColumns = new BitSet();
        this.setPropertiesFromAttributes();
    }

    public void setParent(View parent) {
        if (parent instanceof TableView) {
            this.loading = ((TableView)parent).loading;
        }
        super.setParent(parent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void layout(int width, int height) {
        try {
            super.layout(width, height);
            if (this.offsets_X.length == 0) {
                this.offsets_X = new int[this.getViewCount()];
            }
            if (this.spans_X.length == 0) {
                this.spans_X = new int[this.getViewCount()];
            }
            if (this.offsets_Y.length == 0) {
                this.offsets_Y = new int[this.getViewCount()];
            }
            if (this.spans_Y.length == 0) {
                this.spans_Y = new int[this.getViewCount()];
            }
            if (this.offsets_X != null && this.spans_X != null && this.offsets_Y != null && this.spans_Y != null && !HTMLEditor.jvm_version.startsWith("1.3")) return;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void clearFilledColumns() {
        this.fillColumns.and(TableView.EMPTY);
    }

    void fillColumn(int col) {
        this.fillColumns.set(col);
    }

    boolean isFilled(int col) {
        return this.fillColumns.get(col);
    }

    int getColumnCount() {
        int nfill = 0;
        int n = this.fillColumns.size();
        for (int i = 0; i < n; ++i) {
            if (!this.fillColumns.get(i)) continue;
            ++nfill;
        }
        return this.getViewCount() + nfill;
    }

    public AttributeSet getAttributes() {
        StyleSheet sheet = this.getStyleSheet();
        if (this.attr == null) {
            this.attr = sheet.getViewAttributes(this);
        }
        return this.attr;
    }

    View findViewAtPoint(int x, int y, Rectangle alloc) {
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            if (!this.getChildAllocation(i, alloc).contains(x, y)) continue;
            this.childAllocation(i, alloc);
            return this.getView(i);
        }
        return null;
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        return doc.getStyleSheet();
    }

    public void preferenceChanged(View child, boolean width, boolean height) {
        super.preferenceChanged(child, width, height);
        if (this.tableView.multiRowCells && height) {
            for (int i = this.rowIndex - 1; i >= 0; --i) {
                CustomTableRowView rv = this.tableView.getRow(i);
                if (!rv.multiRowCells) continue;
                rv.preferenceChanged(null, false, true);
                break;
            }
        }
    }

    protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements r) {
        SizeRequirements req = new SizeRequirements();
        req.minimum = this.tableView.totalColumnRequirements.minimum;
        req.maximum = this.tableView.totalColumnRequirements.maximum;
        req.preferred = this.tableView.totalColumnRequirements.preferred;
        req.alignment = 0.0f;
        return req;
    }

    public int getSpan(int axis, int index) {
        return super.getSpan(axis, index);
    }

    public int getOffset(int axis, int index) {
        return super.getOffset(axis, index);
    }

    public float getMinimumSpan(int axis) {
        float value = 0.0f;
        if (axis == 0) {
            value = this.tableView.totalColumnRequirements.minimum + this.getLeftInset() + this.getRightInset();
        } else if (axis == 1 && HTMLEditor.jvm_version.startsWith("1.3")) {
            for (int i = 0; i < this.getViewCount(); ++i) {
                if (!(value < this.getView(i).getMinimumSpan(axis))) continue;
                value = this.getView(i).getMinimumSpan(axis);
            }
        } else {
            value = super.getMinimumSpan(axis);
        }
        return value;
    }

    public float getMaximumSpan(int axis) {
        float value = axis == 0 ? 2.1474836E9f : super.getMaximumSpan(axis);
        return value;
    }

    public float getPreferredSpan(int axis) {
        float value = axis == 0 ? (float)(this.tableView.totalColumnRequirements.preferred + this.getLeftInset() + this.getRightInset()) : super.getPreferredSpan(axis);
        return value;
    }

    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.changedUpdate(e, a, f);
    }

    public void paint(Graphics g, Shape allocation) {
        Rectangle a = (Rectangle)allocation;
        if (this.boxPainter == null || !this.boxPainter.attr.equals(this.getAttributes())) {
            this.boxPainter = new CustomBoxPainter(this.getAttributes(), this.getStyleSheet(), this);
        }
        this.boxPainter.paint(g, a.x, a.y, a.width, a.height, this);
        super.paint(g, a);
    }

    public void replace(int offset, int length, View[] views) {
        super.replace(offset, length, views);
        this.tableView.invalidateGrid();
    }

    protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
        long min = 0L;
        long pref = 0L;
        long max = 0L;
        this.multiRowCells = false;
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            View v = this.getView(i);
            if (!(v instanceof CustomTableCelView)) continue;
            if (this.tableView.getRowsOccupied(v) > 1) {
                this.multiRowCells = true;
                max = Math.max((long)((int)v.getMaximumSpan(axis)), max);
                continue;
            }
            min = Math.max((long)((int)v.getMinimumSpan(axis)), min);
            pref = Math.max((long)((int)v.getPreferredSpan(axis)), pref);
            max = Math.max((long)((int)v.getMaximumSpan(axis)), max);
        }
        if (r == null) {
            r = new SizeRequirements();
            r.alignment = 0.5f;
        }
        r.preferred = (int)pref;
        r.minimum = (int)min;
        r.maximum = (int)max;
        return r;
    }

    protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        int col = 0;
        int ncells = this.getViewCount();
        int cell = 0;
        while (cell < ncells) {
            View cv = this.getView(cell);
            if (cv instanceof CustomTableCelView) {
                while (this.isFilled(col)) {
                    ++col;
                }
                int colSpan = this.tableView.getColumnsOccupied(cv);
                spans[cell] = this.tableView.columnSpans[col];
                offsets[cell] = this.tableView.columnOffsets[col];
                if (colSpan > 1) {
                    int n = this.tableView.columnSpans.length;
                    for (int j = 1; j < colSpan; ++j) {
                        if (col + j >= n) continue;
                        int n2 = cell;
                        spans[n2] = spans[n2] + this.tableView.columnSpans[col + j];
                    }
                    col += colSpan - 1;
                }
            }
            ++cell;
            ++col;
        }
        this.offsets_X = offsets;
        this.spans_X = spans;
    }

    protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        this.lastTargetSpan_Y = targetSpan;
        super.layoutMinorAxis(targetSpan, axis, offsets, spans);
        int col = 0;
        int ncells = this.getViewCount();
        int cell = 0;
        while (cell < ncells) {
            View cv = this.getView(cell);
            if (cv instanceof CustomTableCelView) {
                while (this.isFilled(col)) {
                    ++col;
                }
                int colSpan = this.tableView.getColumnsOccupied(cv);
                int rowSpan = this.tableView.getRowsOccupied(cv);
                if (rowSpan > 1) {
                    int row0 = this.rowIndex;
                    int row1 = Math.min(this.rowIndex + rowSpan - 1, this.tableView.getRowCount() - 1);
                    spans[cell] = this.tableView.getMultiRowSpan(row0, row1);
                }
                if (colSpan > 1) {
                    col += colSpan - 1;
                }
            }
            ++cell;
            ++col;
        }
        for (int i = this.rowIndex - 1; i >= 0; --i) {
            CustomTableRowView rv = this.tableView.getRow(i);
            if (!rv.multiRowCells) continue;
            rv.preferenceChanged(null, false, true);
        }
        this.offsets_Y = offsets;
        this.spans_Y = spans;
    }

    public int getResizeWeight(int axis) {
        return 1;
    }

    protected View getViewAtPosition(int pos, Rectangle a) {
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            View v = this.getView(i);
            int p0 = v.getStartOffset();
            int p1 = v.getEndOffset();
            if (pos < p0 || pos >= p1) continue;
            if (a != null) {
                this.childAllocation(i, a);
            }
            return v;
        }
        if (pos == this.getEndOffset()) {
            View v = this.getView(n - 1);
            if (a != null) {
                this.childAllocation(n - 1, a);
            }
            return v;
        }
        return null;
    }

    public void setPropertiesFromAttributes() {
        StyleSheet sheet = this.getStyleSheet();
        this.attr = sheet.getViewAttributes(this);
    }
}

