/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.geom.AffineTransform;
import javax.swing.SizeRequirements;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.StyleSheet;
import sferyx.administration.editors.CustomBoxPainter;
import sferyx.administration.editors.CustomEditorPane;
import sferyx.administration.editors.CustomLayoutBoxView;
import sferyx.administration.editors.EditorHTMLDocument;
import sferyx.administration.editors.HTMLEditor;
import sferyx.administration.editors.SferyxUtilities;

public class CustomTableCelView
extends CustomLayoutBoxView {
    AttributeSet attr;
    StyleSheet sheet;
    AttributeSet oldElementAttributes;
    AttributeSet oldTableElementAttributes;
    boolean paintInvisibleCells = true;
    Rectangle myRect;
    CustomBoxPainter boxPainter;
    static float[] dashed_dash = new float[]{2.0f};
    static BasicStroke invisibleStroke = new BasicStroke(1.0f, 0, 0, 1.0f, dashed_dash, 0.0f);
    static int red = SystemColor.textHighlight.getRed();
    static int green = SystemColor.textHighlight.getGreen();
    static int blue = SystemColor.textHighlight.getBlue();
    static Color selectionColor = new Color(red, green, blue, 125);

    public short getLeftInset() {
        return (short)((short)this.getLeftPadding() + (short)this.getLeftMargin());
    }

    public short getRightInset() {
        return (short)this.getRightPadding();
    }

    public short getTopInset() {
        return (short)this.getTopPadding();
    }

    public short getBottomInset() {
        return (short)this.getBottomPadding();
    }

    public void layout(int width, int height) {
        super.layout(width, height);
    }

    public AttributeSet getAttributes() {
        if (this.sheet == null) {
            this.sheet = this.getStyleSheet();
        }
        if (this.attr == null || !this.oldElementAttributes.equals(this.getElement().getAttributes()) || !this.oldTableElementAttributes.equals(this.getElement().getParentElement().getParentElement().getAttributes())) {
            this.attr = this.sheet.getViewAttributes(this);
            this.oldElementAttributes = this.getElement().getAttributes().copyAttributes();
            this.oldTableElementAttributes = this.getElement().getParentElement().getParentElement().getAttributes().copyAttributes();
        }
        return this.attr;
    }

    public void paint(Graphics g, Shape allocation) {
        Rectangle a = (Rectangle)allocation;
        AffineTransform saveAT = (AffineTransform)((Graphics2D)g).getTransform().clone();
        this.checkTransformation(g, a);
        if (this.myRect == null) {
            this.myRect = new Rectangle(a.x, a.y, a.width, a.height);
        } else {
            this.myRect.x = a.x;
            this.myRect.y = a.y;
            this.myRect.width = a.width;
            this.myRect.height = a.height;
        }
        int borderThickness = 0;
        boolean borderCollapse = false;
        if (this.getParent().getParent().getElement().getAttributes().getAttribute("border-collapse") == null || !this.getParent().getParent().getElement().getAttributes().getAttribute("border-collapse").toString().equals("collapse")) {
            a = new Rectangle(a.x + this.getLeftMargin(), a.y + this.getTopMargin(), a.width - this.getLeftMargin(), a.height - this.getBottomMargin());
        } else {
            borderThickness = SferyxUtilities.getCellBottomBorderSize(this.getAttributes(), this.getElement());
            a = new Rectangle(a.x, a.y, a.width, a.height + borderThickness);
            borderCollapse = true;
        }
        if (this.boxPainter == null || !this.boxPainter.attr.equals(this.getAttributes())) {
            this.boxPainter = new CustomBoxPainter(this.getAttributes(), this.getStyleSheet(), this);
        }
        if (borderCollapse) {
            this.boxPainter.paint(g, a.x, a.y - this.getTopMargin() + borderThickness, a.width, a.height + this.getBottomMargin() - borderThickness, this);
        } else {
            this.boxPainter.paint(g, a.x, a.y, a.width, a.height, this);
        }
        int n = this.getViewCount();
        try {
            for (int i = 0; i < n; ++i) {
                View v = this.getView(i);
                v.paint(g, this.getChildAllocation(i, allocation));
            }
        }
        catch (Throwable thr) {
            // empty catch block
        }
        if ((this.getContainer() == null || !((CustomEditorPane)this.getContainer()).isDontPaintInvisibleCells()) && this.paintInvisibleCells) {
            g.setColor(Color.lightGray);
            Stroke s = ((Graphics2D)g).getStroke();
            ((Graphics2D)g).setStroke(invisibleStroke);
            g.drawRect(a.x, a.y, a.width, a.height);
            ((Graphics2D)g).setStroke(s);
        }
        try {
            SferyxUtilities.paintViewBorder(this, a, g);
        }
        catch (Throwable thr) {
            thr.printStackTrace();
        }
        if (((EditorHTMLDocument)this.getDocument()).selectedCells.contains(this.getElement())) {
            g.setColor(selectionColor);
            g.fillRect(a.x, a.y, a.width, a.height);
            g.setPaintMode();
        }
        ((Graphics2D)g).setTransform(saveAT);
    }

    public CustomTableCelView(Element elem) {
        super(elem, 1);
    }

    protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        super.layoutMajorAxis(targetSpan, axis, offsets, spans);
        if (offsets == null || offsets.length == 0) {
            return;
        }
        int used = 0;
        int n = spans.length;
        for (int i = 0; i < n; ++i) {
            if (offsets[i] + spans[i] <= used) continue;
            used = offsets[i] + spans[i];
        }
        int adjust = 0;
        if (used < targetSpan) {
            Object valign_;
            AttributeSet rowAttr;
            String valign = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.VALIGN);
            if (valign == null && (valign = (String)(rowAttr = this.getElement().getParentElement().getAttributes()).getAttribute(HTML.Attribute.VALIGN)) == null && (valign_ = this.getAttributes().getAttribute(CSS.Attribute.VERTICAL_ALIGN)) != null) {
                valign = valign_.toString();
            }
            if (valign == null || valign.equals("middle")) {
                adjust = (targetSpan - used) / 2;
            } else if (valign.equals("bottom")) {
                adjust = targetSpan - used;
            } else if (valign.equals("top")) {
                adjust = 0;
                offsets[0] = 0;
            }
        }
        if (adjust > 0) {
            int i = 0;
            while (i < n) {
                int n2 = i++;
                offsets[n2] = offsets[n2] + adjust;
            }
        }
    }

    protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements r) {
        SizeRequirements req = super.calculateMajorAxisRequirements(axis, r);
        req.maximum = Integer.MAX_VALUE;
        if (axis == 1 && HTMLEditor.jvm_version.startsWith("1.3")) {
            int minSpan = 0;
            for (int i = 0; i < this.getViewCount(); ++i) {
                minSpan = (int)((float)minSpan + this.getView(i).getMinimumSpan(axis));
            }
            req.minimum = minSpan;
        }
        return req;
    }

    public float getMaximumSpan(int axis) {
        return this.getMaximumSpan_(axis);
    }

    public float getMaximumSpan_(int axis) {
        float min_span;
        float max_span = super.getMaximumSpan(axis);
        if (axis == 1 && HTMLEditor.jvm_version.startsWith("1.3") && max_span < (min_span = this.getMinimumSpan(axis))) {
            max_span = min_span;
        }
        return max_span;
    }

    public float getPreferredSpan(int axis) {
        return this.getPreferredSpan_(axis);
    }

    public float getPreferredSpan_(int axis) {
        float min_span;
        float max_span = super.getPreferredSpan(axis);
        if (axis == 1 && HTMLEditor.jvm_version.startsWith("1.3") && max_span < (min_span = this.getMinimumSpan(axis))) {
            max_span = min_span;
        }
        if (axis == 1) {
            int result = this.getMaxSpan(0, this.getViewCount(), this.spans_Y, this.offsets_Y) + this.getTopMargin() + this.getBottomMargin();
            return result;
        }
        return max_span;
    }

    public float getMinimumSpan(int axis) {
        return this.getMinimumSpan_(axis);
    }

    public float getMinimumSpan_(int axis) {
        if (axis == 1 && HTMLEditor.jvm_version.startsWith("1.3")) {
            float minSpan = 0.0f;
            for (int i = 0; i < this.getViewCount(); ++i) {
                minSpan += this.getView(i).getMinimumSpan(axis);
            }
            return minSpan;
        }
        if (axis == 1) {
            return super.getMinimumSpan(axis);
        }
        return super.getMinimumSpan(axis);
    }

    protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
        SizeRequirements rv = super.calculateMinorAxisRequirements(axis, r);
        int n = this.getViewCount();
        int min = 0;
        for (int i = 0; i < n; ++i) {
            View v = this.getView(i);
            min = Math.max((int)v.getMinimumSpan(axis), min);
        }
        rv.minimum = Math.min(rv.minimum, min);
        return rv;
    }
}

