/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.BlockView;
import javax.swing.text.html.HTML;
import javax.swing.text.html.StyleSheet;
import sferyx.administration.editors.CustomSimpleParagraphView;

public class CustomSimpleListView
extends BlockView {
    private StyleSheet.ListPainter listPainter;

    public CustomSimpleListView(Element elem) {
        super(elem, 1);
    }

    public float getAlignment(int axis) {
        switch (axis) {
            case 0: {
                return 0.5f;
            }
            case 1: {
                return 0.5f;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    public void paint(Graphics g, Shape allocation) {
        this.setPropertiesFromAttributes();
        super.paint(g, allocation);
    }

    protected void paintChild(Graphics g, Rectangle alloc, int index) {
        if ((this.getElement().getAttributes().getAttribute(HTML.Attribute.TYPE) == null || this.getElement().getAttributes().getAttribute(HTML.Attribute.TYPE).equals("disc")) && this.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.UL) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.getElement().getAttributes().getAttribute(HTML.Attribute.DIR) != null && this.getElement().getAttributes().getAttribute(HTML.Attribute.DIR).toString().equalsIgnoreCase("rtl")) {
                int y = this.getCorrectOffset(index, alloc);
                this.listPainter.paint(g, alloc.x + alloc.width, y, alloc.width, alloc.height, this, index);
            } else {
                int y = this.getCorrectOffset(index, alloc);
                this.listPainter.paint(g, alloc.x, y, alloc.width, alloc.height, this, index);
            }
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        } else if (this.getElement().getAttributes().getAttribute(HTML.Attribute.DIR) != null && this.getElement().getAttributes().getAttribute(HTML.Attribute.DIR).toString().equalsIgnoreCase("rtl")) {
            int y = this.getCorrectOffset(index, alloc);
            this.listPainter.paint(g, alloc.x + alloc.width, y, alloc.width, alloc.height, this, index);
        } else {
            int y = this.getCorrectOffset(index, alloc);
            this.listPainter.paint(g, alloc.x, y, alloc.width, alloc.height, this, index);
        }
        super.paintChild(g, alloc, index);
    }

    int getCorrectOffset(int index, Rectangle alloc) {
        int y = alloc.y;
        View child = this.getView(index);
        int stringheight = 0;
        Font font = new Font("Serif", 0, 12);
        if (font != null) {
            FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
            stringheight = fm.getAscent();
        }
        if (child.getViewCount() > 0 && child.getView(0) instanceof CustomSimpleParagraphView) {
            int top = ((CustomSimpleParagraphView)child.getView(0)).getTopMargin();
            View paragraphView = child.getView(0);
            Rectangle paragraphAlloc = (Rectangle)child.getChildAllocation(0, alloc);
            if (paragraphView.getViewCount() > 0) {
                View firstRowView = paragraphView.getView(0);
                Rectangle firstRowAlloc = (Rectangle)paragraphView.getChildAllocation(0, paragraphAlloc);
                Object cName = paragraphView.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
                if (firstRowAlloc.height > stringheight) {
                    int total = firstRowAlloc.y + firstRowAlloc.height / 2 - stringheight / 2;
                    y = Math.min(total, alloc.y + alloc.height);
                } else {
                    y = firstRowAlloc.y;
                }
            }
        }
        return y;
    }

    protected void setPropertiesFromAttributes() {
        super.setPropertiesFromAttributes();
        this.listPainter = this.getStyleSheet().getListPainter(this.getAttributes());
    }
}

