/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import javax.swing.SizeRequirements;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import sferyx.administration.editors.CustomBlockView;
import sferyx.administration.editors.CustomImageView;
import sferyx.administration.editors.CustomParagraphView;
import sferyx.administration.editors.CustomSimpleParagraphView;

class CustomPreviewHTMLFactory
extends HTMLEditorKit.HTMLFactory {
    CustomPreviewHTMLFactory() {
    }

    public View create(Element elem) {
        Object o = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
        String ver = null;
        String os = null;
        try {
            ver = System.getProperty("java.version");
            os = System.getProperty("os.name");
        }
        catch (Throwable thorw) {
            // empty catch block
        }
        if (o instanceof HTML.Tag) {
            HTML.Tag kind = (HTML.Tag)o;
            if (kind == HTML.Tag.IMG) {
                return new CustomImageView(elem);
            }
            if (ver != null && os != null && !ver.startsWith("1.3")) {
                if (kind == HTML.Tag.IMPLIED) {
                    String ws = (String)elem.getAttributes().getAttribute(CSS.Attribute.WHITE_SPACE);
                    if (ws != null && ws.equals("pre")) {
                        return super.create(elem);
                    }
                    return new CustomParagraphView(elem);
                }
                if (kind == HTML.Tag.P || kind == HTML.Tag.H1 || kind == HTML.Tag.H2 || kind == HTML.Tag.H3 || kind == HTML.Tag.H4 || kind == HTML.Tag.H5 || kind == HTML.Tag.H6 || kind == HTML.Tag.DT) {
                    return new CustomParagraphView(elem);
                }
                if (kind == HTML.Tag.BODY) {
                    return new CustomBlockView(elem, 1){

                        protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements r) {
                            r = super.calculateMajorAxisRequirements(axis, r);
                            r.maximum = Integer.MAX_VALUE;
                            return r;
                        }
                    };
                }
                if (kind == HTML.Tag.HTML) {
                    return new CustomBlockView(elem, 1);
                }
                if (kind == HTML.Tag.LI || kind == HTML.Tag.CENTER || kind == HTML.Tag.DL || kind == HTML.Tag.DD || kind == HTML.Tag.DIV || kind == HTML.Tag.BLOCKQUOTE || kind == HTML.Tag.PRE || kind == HTML.Tag.FORM) {
                    return new CustomBlockView(elem, 1);
                }
            } else if (ver != null && os != null && ver.startsWith("1.3")) {
                if (kind == HTML.Tag.IMPLIED) {
                    String ws = (String)elem.getAttributes().getAttribute(CSS.Attribute.WHITE_SPACE);
                    if (ws != null && ws.equals("pre")) {
                        return super.create(elem);
                    }
                    return new CustomSimpleParagraphView(elem);
                }
                if (kind == HTML.Tag.P || kind == HTML.Tag.H1 || kind == HTML.Tag.H2 || kind == HTML.Tag.H3 || kind == HTML.Tag.H4 || kind == HTML.Tag.H5 || kind == HTML.Tag.H6 || kind == HTML.Tag.DT) {
                    return new CustomSimpleParagraphView(elem);
                }
            }
        }
        return super.create(elem);
    }
}

