/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.SizeRequirements;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.InlineView;
import javax.swing.text.html.MinimalHTMLWriter;
import javax.swing.text.html.StyleSheet;
import sferyx.administration.editors.CustomBRView;
import sferyx.administration.editors.CustomBlockInlineXMLTagView;
import sferyx.administration.editors.CustomBlockView;
import sferyx.administration.editors.CustomBlockXMLTagView;
import sferyx.administration.editors.CustomEmptyXMLTagView;
import sferyx.administration.editors.CustomFormInputView;
import sferyx.administration.editors.CustomImageView;
import sferyx.administration.editors.CustomInlineView;
import sferyx.administration.editors.CustomLayoutBoxView;
import sferyx.administration.editors.CustomListView;
import sferyx.administration.editors.CustomObjectView;
import sferyx.administration.editors.CustomParagraphView;
import sferyx.administration.editors.CustomSimpleParagraphView;
import sferyx.administration.editors.CustomTableView;
import sferyx.administration.editors.CustomUnknownTagView;
import sferyx.administration.editors.CustomXMLTagsGrammarSpecification;
import sferyx.administration.editors.CustomizableObjectView;
import sferyx.administration.editors.EditorHTMLDocument;
import sferyx.administration.editors.EmptyView;
import sferyx.administration.editors.HRuleView;
import sferyx.administration.editors.HTMLEditor;
import sferyx.administration.editors.IFrameView;
import sferyx.administration.editors.PreParagraphView;
import sferyx.administration.editors.SferyxUtilities;
import sferyx.administration.editors.TableView;
import sferyx.administration.editors.XHTMLWriter;
import sferyx.administration.editors.parser.ParserDelegator;

public class CustomPreviewHTMLEditorKit
extends HTMLEditorKit {
    private ViewFactory customFactory = new CustomPreviewHTMLFactory();
    StyleSheet defaultStyles;
    JEditorPane editorPane;
    boolean foundNewCharset = false;
    String newCharset = null;
    String defaultCharset = null;
    char[] discovery_buffer;
    char[] read_buffer;
    static /* synthetic */ Class class$sferyx$administration$editors$CustomHTMLEditorKit;

    public ViewFactory getViewFactory() {
        return this.customFactory;
    }

    static InputStream getResourceAsStream(String name) {
        try {
            return (class$sferyx$administration$editors$CustomHTMLEditorKit == null ? (class$sferyx$administration$editors$CustomHTMLEditorKit = CustomPreviewHTMLEditorKit.class$("sferyx.administration.editors.CustomHTMLEditorKit")) : class$sferyx$administration$editors$CustomHTMLEditorKit).getResourceAsStream(name);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public void setStyleSheet(StyleSheet s) {
        this.defaultStyles = s;
    }

    public StyleSheet getStyleSheet() {
        if (this.defaultStyles == null) {
            this.defaultStyles = new StyleSheet();
            try {
                InputStream is = CustomPreviewHTMLEditorKit.getResourceAsStream("/sferyx/administration/editors/icons/sferyx.css");
                BufferedReader r = new BufferedReader(new InputStreamReader(is));
                this.defaultStyles.loadRules(r, null);
                is.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return this.defaultStyles;
    }

    protected HTMLEditorKit.Parser getParser() {
        return new ParserDelegator();
    }

    public void install(JEditorPane c) {
        this.editorPane = c;
        super.install(c);
    }

    public void findCharacterEncoding(String line) {
        int indexOfEndOfCharsetDirective;
        String lowerCaseLine = line.toLowerCase();
        int indexOfHTTPEquiv = lowerCaseLine.indexOf("http-equiv");
        int indexOfCharsetDirective = lowerCaseLine.indexOf("charset=");
        if (indexOfCharsetDirective != -1 && (indexOfEndOfCharsetDirective = lowerCaseLine.indexOf(">", indexOfCharsetDirective)) == -1) {
            return;
        }
        if (indexOfHTTPEquiv != -1 && indexOfCharsetDirective != -1) {
            this.foundNewCharset = true;
            String charsetFragment = lowerCaseLine.substring(indexOfCharsetDirective + 8);
            StringTokenizer st = new StringTokenizer(charsetFragment, "'\">/ ");
            try {
                this.newCharset = st.nextToken();
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    StringBuffer readStreamContentFully(Reader in) {
        if (this.discovery_buffer == null) {
            this.discovery_buffer = new char[10000];
        }
        if (this.read_buffer == null) {
            this.read_buffer = new char[10000];
        }
        StringBuffer nondecodedContentBuffer = new StringBuffer();
        StringBuffer contentBuffer = new StringBuffer();
        char[] buffer = this.discovery_buffer;
        try {
            Reader datainputstream = in;
            int state = 0;
            int bytesRead = 0;
            boolean flag = true;
            while (state != -1) {
                int j = buffer.length;
                if (j >= buffer.length) {
                    state = bytesRead = datainputstream.read(buffer, 0, buffer.length);
                } else {
                    bytesRead = j;
                    state = datainputstream.read(buffer, 0, bytesRead);
                    flag = false;
                }
                if (state == -1) break;
                if (this.foundNewCharset) {
                    try {
                        if (!HTMLEditor.jvm_older && Charset.isSupported(this.newCharset)) {
                            contentBuffer.append(new String(buffer, 0, state));
                            continue;
                        }
                        try {
                            contentBuffer.append(new String(buffer, 0, state));
                        }
                        catch (Throwable thr) {
                            contentBuffer.append(new String(buffer, 0, state));
                        }
                    }
                    catch (Throwable thr) {
                        String string = new String(buffer, 0, state);
                        contentBuffer.append(string);
                        if (!this.foundNewCharset) continue;
                        buffer = this.read_buffer;
                    }
                    continue;
                }
                String string = new String(buffer, 0, state);
                contentBuffer.append(string);
                this.findCharacterEncoding(contentBuffer.toString());
                if (!this.foundNewCharset) continue;
                buffer = this.read_buffer;
                String undecodedContent = contentBuffer.toString();
                contentBuffer = new StringBuffer();
                byte[] oldBytes = undecodedContent.getBytes(this.newCharset);
                try {
                    contentBuffer.append(new String(oldBytes, 0, oldBytes.length, this.newCharset));
                }
                catch (Throwable thrr) {
                    contentBuffer.append(new String(oldBytes, 0, oldBytes.length));
                }
            }
            datainputstream.close();
            if (!this.foundNewCharset) return contentBuffer;
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return contentBuffer;
    }

    byte[] appendBuffer(byte[] from, byte[] to, int length) {
        int pos = 0;
        if (to == null) {
            to = new byte[length];
        } else {
            pos = to.length;
            byte[] newArray = new byte[to.length + length];
            System.arraycopy(to, 0, newArray, 0, to.length);
            to = newArray;
        }
        System.arraycopy(from, 0, to, pos, length);
        return to;
    }

    public void read(Reader in, Document doc, int pos) throws IOException, BadLocationException {
        HTMLEditor htmlEdiotr = SferyxUtilities.getHostHTMLEditor(this.editorPane);
        String documentContent = this.readStreamContentFully(in).toString();
        documentContent = htmlEdiotr.extractBodyStyleSheetDefinitions(documentContent);
        StringReader sreder = new StringReader(documentContent);
        ((EditorHTMLDocument)doc).setAsynchronousLoadPriority(-1);
        ((EditorHTMLDocument)doc).setTokenThreshold(10000);
        super.read(sreder, doc, pos);
    }

    public void write(Writer out, Document doc, int pos, int len) throws IOException, BadLocationException {
        if (doc instanceof HTMLDocument) {
            XHTMLWriter w = new XHTMLWriter(out, (HTMLDocument)doc, pos, len);
            w.write();
        } else if (doc instanceof StyledDocument) {
            MinimalHTMLWriter w = new MinimalHTMLWriter(out, (StyledDocument)doc, pos, len);
            w.write();
        } else {
            super.write(out, doc, pos, len);
        }
    }

    public Document createDefaultDocument() {
        StyleSheet styles = this.getStyleSheet();
        StyleSheet ss = this.editorPane != null && SferyxUtilities.getHostHTMLEditor(this.editorPane) != null ? SferyxUtilities.getHostHTMLEditor(this.editorPane).getNewStyleSheetInstance() : new StyleSheet();
        ss.addStyleSheet(styles);
        EditorHTMLDocument doc = new EditorHTMLDocument(ss);
        doc.putProperty("IgnoreCharsetDirective", new Boolean(true));
        doc.setParser(this.getParser());
        doc.setAsynchronousLoadPriority(4);
        doc.setTokenThreshold(100);
        return doc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class CustomPreviewHTMLFactory
    extends HTMLEditorKit.HTMLFactory {
        View lastTableView;
        Vector shadows = new Vector();

        private void addShadow() {
        }

        public View create(Element elem) {
            Object o = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
            String ver = null;
            String os = null;
            try {
                ver = System.getProperty("java.version");
                os = System.getProperty("os.name");
            }
            catch (Throwable thorw) {
                // empty catch block
            }
            if (o instanceof HTML.Tag) {
                HTML.Tag kind = (HTML.Tag)o;
                if (kind == HTML.Tag.OBJECT || kind == HTML.Tag.APPLET) {
                    Object custom_rendering = elem.getAttributes().getAttribute("use_custom_object_rendering");
                    if (custom_rendering != null && custom_rendering.toString().equalsIgnoreCase("true")) {
                        return new CustomizableObjectView(elem);
                    }
                    return new CustomObjectView(elem);
                }
                if (kind == HTML.Tag.IMG) {
                    return new CustomImageView(elem);
                }
                if (ver != null && os != null && !ver.startsWith("1.2")) {
                    if (kind == HTML.Tag.IMPLIED) {
                        String ws = (String)elem.getAttributes().getAttribute(CSS.Attribute.WHITE_SPACE);
                        if (ws != null && ws.equals("pre")) {
                            return new PreParagraphView(elem);
                        }
                        return new CustomParagraphView(elem);
                    }
                    if (kind == HTML.Tag.P || kind == HTML.Tag.H1 || kind == HTML.Tag.H2 || kind == HTML.Tag.H3 || kind == HTML.Tag.H4 || kind == HTML.Tag.H5 || kind == HTML.Tag.H6 || kind == HTML.Tag.DT) {
                        return new CustomParagraphView(elem);
                    }
                    if (kind == HTML.Tag.BR) {
                        return new CustomBRView(elem);
                    }
                    if (kind.toString().equalsIgnoreCase("iframe")) {
                        return new IFrameView(elem);
                    }
                    if (kind == HTML.Tag.BODY) {
                        return new CustomLayoutBoxView(this, elem, 1){
                            private final /* synthetic */ CustomPreviewHTMLFactory this$1;
                            {
                                this.this$1 = this$1;
                            }

                            protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements r) {
                                try {
                                    r = super.calculateMajorAxisRequirements(axis, r);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                if (r != null) {
                                    r.maximum = Integer.MAX_VALUE;
                                }
                                return r;
                            }
                        };
                    }
                    if (kind == HTML.Tag.HTML) {
                        return new CustomBlockView(elem, 1);
                    }
                    if (elem.getName().equalsIgnoreCase("nav") || elem.getName().equalsIgnoreCase("footer") || elem.getName().equalsIgnoreCase("section") || elem.getName().equalsIgnoreCase("article") || elem.getName().equalsIgnoreCase("aside") || elem.getName().equalsIgnoreCase("header")) {
                        return new CustomBlockView(elem, 1);
                    }
                    if (kind == HTML.Tag.TR) {
                        return new CustomBlockView(elem, 1);
                    }
                    if (kind == HTML.Tag.TD || kind == HTML.Tag.TH) {
                        return new CustomBlockView(elem, 1);
                    }
                    if (kind == HTML.Tag.OL || kind == HTML.Tag.UL) {
                        return new CustomListView(elem);
                    }
                    if (kind == HTML.Tag.TABLE) {
                        TableView defaultView = new TableView(elem, false);
                        return defaultView;
                    }
                    if (kind == HTML.Tag.LI || kind == HTML.Tag.CENTER || kind == HTML.Tag.DL || kind == HTML.Tag.DD || kind == HTML.Tag.DIV || kind == HTML.Tag.BLOCKQUOTE || kind == HTML.Tag.PRE || kind == HTML.Tag.FORM || kind.toString().equalsIgnoreCase("fieldset")) {
                        return new CustomBlockView(elem, 1);
                    }
                    if (kind == HTML.Tag.A && SferyxUtilities.getStyleSheetCSSValueForElement(elem, CSS.Attribute.DISPLAY) != null && SferyxUtilities.getStyleSheetCSSValueForElement(elem, CSS.Attribute.DISPLAY).toString().equalsIgnoreCase("block")) {
                        return new CustomParagraphView(elem);
                    }
                } else if (ver != null && os != null && ver.startsWith("1.2")) {
                    if (kind == HTML.Tag.TABLE) {
                        TableView defaultView = new TableView(elem);
                        this.lastTableView = defaultView;
                        CustomTableView customView = new CustomTableView(this.lastTableView.getElement(), this.lastTableView, true);
                        this.shadows.addElement(customView);
                        Runnable doFire = new Runnable(this){
                            private final /* synthetic */ CustomPreviewHTMLFactory this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                try {
                                    Enumeration<E> allCustom = this.this$1.shadows.elements();
                                    Component container = null;
                                    while (allCustom.hasMoreElements()) {
                                        CustomTableView currCustomView = (CustomTableView)allCustom.nextElement();
                                        if (currCustomView.getParent() == null) {
                                            currCustomView.getAttachedView().append(currCustomView);
                                        }
                                        container = currCustomView.getContainer();
                                    }
                                    if (container != null) {
                                        try {
                                            container.repaint();
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    this.this$1.shadows.removeAllElements();
                                }
                                catch (Throwable throwable) {
                                    throwable.printStackTrace();
                                }
                            }
                        };
                        SwingUtilities.invokeLater(doFire);
                        return defaultView;
                    }
                    if (kind == HTML.Tag.IMPLIED) {
                        String ws = (String)elem.getAttributes().getAttribute(CSS.Attribute.WHITE_SPACE);
                        if (ws != null && ws.equals("pre")) {
                            return super.create(elem);
                        }
                        return new CustomSimpleParagraphView(elem);
                    }
                    if (kind == HTML.Tag.P || kind == HTML.Tag.H1 || kind == HTML.Tag.H2 || kind == HTML.Tag.H3 || kind == HTML.Tag.H4 || kind == HTML.Tag.H5 || kind == HTML.Tag.H6 || kind == HTML.Tag.DT) {
                        return new CustomSimpleParagraphView(elem);
                    }
                }
                if (kind instanceof HTML.UnknownTag) {
                    Object tagType = CustomXMLTagsGrammarSpecification.getGrammarSpecification().get(kind.toString());
                    if (tagType != null) {
                        if (((Boolean)tagType).booleanValue()) {
                            return new CustomEmptyXMLTagView(elem);
                        }
                        String tagName = kind.toString();
                        Hashtable renderingMappingTable = CustomXMLTagsGrammarSpecification.getRenderingModesSpecification();
                        String renderingMode = (String)renderingMappingTable.get(tagName);
                        if (CustomXMLTagsGrammarSpecification.isTreatAllBlockTagsAsBlocks()) {
                            return new CustomBlockXMLTagView(elem, 1);
                        }
                        if (renderingMode == null) {
                            return new CustomBlockInlineXMLTagView(elem, 1);
                        }
                        if (renderingMode.equals("BLOCK_TAG")) {
                            return new CustomBlockXMLTagView(elem, 1);
                        }
                        if (renderingMode.equals("INLINE_TAG")) {
                            return new CustomBlockXMLTagView(elem, 1);
                        }
                        return new CustomBlockXMLTagView(elem, 1);
                    }
                    return new CustomUnknownTagView(elem);
                }
                if (kind == HTML.Tag.SPAN) {
                    return new InlineView(elem);
                }
                if (kind == HTML.Tag.TITLE || kind == HTML.Tag.META || kind == HTML.Tag.LINK || kind == HTML.Tag.STYLE || kind == HTML.Tag.SCRIPT || kind == HTML.Tag.AREA || kind == HTML.Tag.MAP || kind == HTML.Tag.PARAM || kind == HTML.Tag.APPLET) {
                    return new CustomUnknownTagView(elem);
                }
                if (kind == HTML.Tag.COMMENT) {
                    return new CustomUnknownTagView(elem);
                }
                if (kind == HTML.Tag.INPUT || kind == HTML.Tag.SELECT || kind == HTML.Tag.TEXTAREA) {
                    return new CustomFormInputView(elem);
                }
                if (kind == HTML.Tag.CONTENT) {
                    return new CustomInlineView(elem);
                }
                if (kind == HTML.Tag.HR) {
                    return new HRuleView(elem);
                }
            }
            try {
                return super.create(elem);
            }
            catch (Throwable thr) {
                return new EmptyView(elem);
            }
        }
    }
}

