/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.ParagraphView;
import javax.swing.text.html.StyleSheet;
import sferyx.administration.editors.AlternativeCSSAttribute;
import sferyx.administration.editors.CSSLayoutViews;
import sferyx.administration.editors.CustomBlockView;
import sferyx.administration.editors.CustomBoxPainter;
import sferyx.administration.editors.CustomLayoutBoxView;
import sferyx.administration.editors.HiddenValue;
import sferyx.administration.editors.Row;
import sferyx.administration.editors.SferyxUtilities;
import sferyx.administration.editors.alignedImage;

public class CustomParagraphView
extends ParagraphView
implements CSSLayoutViews {
    Rectangle tempRect = new Rectangle();
    short leftInset = 0;
    short rightInset = 0;
    int justification;
    float lineSpacing = -1.0f;
    int currParentViewIndex = -1;
    View imageView;
    boolean forceChange = false;
    AttributeSet attr;
    StyleSheet sheet;
    boolean margin_right_em = false;
    boolean margin_left_em = false;
    Rectangle myAllocation;
    CustomBoxPainter boxPainter;
    static Font tagsFont = new Font("Arial", 1, 11);
    boolean revealBlockViews = false;
    float lastRowLeftInset = 0.0f;
    float lastRowRightInset = 0.0f;
    Vector leftAlignedViewsPoly = new Vector();
    Vector rightAlignedViewsPoly = new Vector();
    int totalHeight = 0;
    int imageOffset = -1;
    int imageSpan = -1;
    int currentImageDimension = 0;
    boolean containsAlignedImages = false;
    int upperParagraphsExcess = 0;
    int upperSpanRestriction = 0;
    int upperOffsetRestriction = 0;
    int upperRightSpanRestriction = 0;
    boolean containsImages = false;
    int targetSpan_X;
    int[] offsets_X;
    int[] offsets_Y;
    int[] spans_X;
    int[] spans_Y;

    public CustomParagraphView(Element elem) {
        super(elem);
    }

    protected void setPropertiesFromAttributes() {
        if (this.attr == null) {
            StyleSheet sheet = this.getStyleSheet();
            this.attr = sheet.getViewAttributes(this);
        }
        if (this.attr != null) {
            Object o = this.attr.getAttribute(CSS.Attribute.TEXT_ALIGN);
            if (o != null) {
                String ta = o.toString();
                if (ta.equals("left")) {
                    this.setJustification(0);
                } else if (ta.equals("center")) {
                    this.setJustification(1);
                } else if (ta.startsWith("center")) {
                    this.setJustification(1);
                } else if (ta.equals("right")) {
                    this.setJustification(2);
                } else if (ta.startsWith("right")) {
                    this.setJustification(2);
                } else if (ta.equals("justify")) {
                    this.setJustification(3);
                }
            } else {
                Document doc = this.getElement().getDocument();
                o = doc.getProperty(TextAttribute.RUN_DIRECTION);
                if (o != null && o.equals(TextAttribute.RUN_DIRECTION_RTL)) {
                    this.setJustification(2);
                } else {
                    this.setJustification(0);
                }
            }
            if (this.attr.getAttribute("direction") != null && this.attr.getAttribute("direction").toString().equalsIgnoreCase("rtl")) {
                this.setJustification(2);
            }
        }
    }

    protected void setParagraphInsets(AttributeSet attr) {
    }

    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.changedUpdate(e, a, f);
        this.forceChange = true;
    }

    public AttributeSet getAttributes() {
        this.sheet = this.getStyleSheet();
        if (this.attr == null) {
            this.attr = this.sheet.getViewAttributes(this);
        }
        if (this.forceChange) {
            this.attr = this.sheet.getViewAttributes(this);
            this.setPropertiesFromAttributes();
            this.forceChange = false;
        }
        return this.attr;
    }

    public boolean isAbsolutePositioning() {
        if (this.getElement().getAttributes().getAttribute("position") != null && this.getElement().getAttributes().isDefined("position") && this.getElement().getAttributes().getAttribute("position").toString().trim().equals("absolute")) {
            return true;
        }
        return this.getAttributes().getAttribute("position") != null && this.getAttributes().getAttribute("position").toString().trim().equals("absolute");
    }

    public boolean isRelativePositioning() {
        if (this.getElement().getAttributes().getAttribute("position") != null && this.getElement().getAttributes().isDefined("position") && this.getElement().getAttributes().getAttribute("position").toString().trim().equals("relative")) {
            return true;
        }
        return this.getAttributes().getAttribute("position") != null && this.getAttributes().getAttribute("position").toString().trim().equals("relative");
    }

    public int getAbsoluteX() {
        return SferyxUtilities.getAbsoluteX(this);
    }

    public int getAbsoluteY() {
        return SferyxUtilities.getAbsoluteY(this);
    }

    public boolean isVisible() {
        return true;
    }

    public void setParent(View parent) {
        super.setParent(parent);
    }

    public int getRightMargin() {
        return SferyxUtilities.getRightMargin(this);
    }

    public int getLeftMargin() {
        return SferyxUtilities.getLeftMargin(this);
    }

    public int getTopMargin() {
        if (this.getElement().getName().equals("p") && SferyxUtilities.getElementIndex(this.getElement()) == 0 && !this.getElement().getAttributes().isDefined(CSS.Attribute.MARGIN_TOP) && !this.getElement().getAttributes().isDefined(HiddenValue.MARGIN_TOP)) {
            return 0;
        }
        return SferyxUtilities.getTopMargin(this);
    }

    public int getBottomMargin() {
        return SferyxUtilities.getBottomMargin(this);
    }

    public int getRightPadding() {
        return SferyxUtilities.getRightPadding(this);
    }

    public int getLeftPadding() {
        return SferyxUtilities.getLeftPadding(this);
    }

    public int getTopPadding() {
        return SferyxUtilities.getTopPadding(this);
    }

    public int getBottomPadding() {
        return SferyxUtilities.getBottomPadding(this);
    }

    protected int getOffset(int axis, int childIndex) {
        try {
            if (childIndex >= this.getViewCount()) {
                return 0;
            }
            return super.getOffset(axis, childIndex);
        }
        catch (Throwable thr) {
            return 0;
        }
    }

    protected int getSpan(int axis, int childIndex) {
        try {
            if (childIndex >= this.getViewCount()) {
                return 0;
            }
            return super.getSpan(axis, childIndex);
        }
        catch (Throwable thr) {
            return 0;
        }
    }

    public void paint(Graphics g, Shape allocation) {
        this.myAllocation = (Rectangle)allocation;
        if (!this.isVisible()) {
            return;
        }
        try {
            Rectangle alloc;
            Rectangle rectangle = alloc = allocation instanceof Rectangle ? (Rectangle)allocation : allocation.getBounds();
            if (this.boxPainter == null || !this.boxPainter.attr.equals(this.getAttributes())) {
                this.boxPainter = new CustomBoxPainter(this.getAttributes(), this.getStyleSheet(), this);
            }
            this.boxPainter.paint(g, alloc.x, alloc.y, alloc.width, alloc.height, this);
            if (!SferyxUtilities.getJVMVersion().startsWith("1.3")) {
                // empty if block
            }
            int n = this.getViewCount();
            int x = alloc.x + this.getLeftInset();
            int y = alloc.y + this.getTopInset();
            Rectangle clip = g.getClipBounds();
            for (int i = 0; i < n; ++i) {
                this.tempRect.x = x + this.getOffset(0, i);
                this.tempRect.y = y + this.getOffset(1, i);
                this.tempRect.width = this.getSpan(0, i);
                this.tempRect.height = this.getSpan(1, i);
                if (this.tempRect == null || !this.tempRect.intersects(clip) && ((Row)this.getView((int)i)).realImageDimension <= 0) continue;
                this.paintChild(g, this.tempRect, i);
            }
            if (!SferyxUtilities.getJVMVersion().startsWith("1.3")) {
                // empty if block
            }
            Rectangle borderRect = new Rectangle();
            borderRect.x = alloc.x;
            borderRect.y = alloc.y;
            borderRect.width = alloc.width;
            borderRect.height = alloc.height;
            SferyxUtilities.paintViewBorder(this, borderRect, g);
            if (!SferyxUtilities.getJVMVersion().startsWith("1.3")) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
            }
            if (this.revealBlockViews && !this.getElement().getName().equals("p-implied")) {
                g.setFont(tagsFont);
                g.setColor(Color.yellow);
                g.fill3DRect(alloc.x, alloc.y, g.getFontMetrics().stringWidth("<" + this.getElement().getName() + ">"), g.getFontMetrics().getHeight(), true);
                g.setColor(Color.blue);
                g.drawString("<" + this.getElement().getName() + ">", alloc.x, alloc.y + g.getFontMetrics().getHeight() - g.getFontMetrics().getAscent() / 2);
                if (SferyxUtilities.isFloatLeftView(this.getAttributes(), this.getStyleSheet())) {
                    g.setColor(Color.green);
                    g.drawRect(alloc.x + 2, alloc.y + 2, alloc.width - 4, alloc.height - 4);
                } else if (SferyxUtilities.isFloatRightView(this.getAttributes(), this.getStyleSheet())) {
                    g.setColor(Color.red);
                    g.drawRect(alloc.x + 2, alloc.y + 2, alloc.width - 4, alloc.height - 4);
                } else {
                    g.setColor(Color.yellow);
                    g.drawRect(alloc.x + 2, alloc.y + 2, alloc.width - 4, alloc.height - 4);
                }
                g.setFont(tagsFont);
                g.setColor(Color.yellow);
                g.fill3DRect(alloc.x + alloc.width - g.getFontMetrics().stringWidth("</" + this.getElement().getName() + ">"), alloc.y + alloc.height - g.getFontMetrics().getHeight(), g.getFontMetrics().stringWidth("</" + this.getElement().getName() + ">"), g.getFontMetrics().getHeight(), true);
                g.setColor(Color.blue);
                g.drawString("</" + this.getElement().getName() + ">", alloc.x + alloc.width - g.getFontMetrics().stringWidth("</" + this.getElement().getName() + ">"), alloc.y + alloc.height - g.getFontMetrics().getAscent() / 2);
            }
            if (this.getStartOffset() + 1 == this.getEndOffset() && this.isShowParagraphsEnabled()) {
                g.drawString("\u00b6", ((Rectangle)allocation).x + 5, ((Rectangle)allocation).y + ((Rectangle)allocation).height - 5);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    boolean isShowParagraphsEnabled() {
        return SferyxUtilities.getHostHTMLEditor(this) != null && SferyxUtilities.getHostHTMLEditor(this).isShowParagraphsEnabled();
    }

    public View createRow() {
        Element elem = this.getElement();
        Row row = new Row(elem);
        return row;
    }

    public Shape getChildAllocation(int index, Shape a) {
        if (a != null) {
            Shape ca = super.getChildAllocation(index, a);
            if (ca != null && !this.isAllocationValid()) {
                Rectangle r;
                Rectangle rectangle = r = ca instanceof Rectangle ? (Rectangle)ca : ca.getBounds();
                if (r.width == 0 && r.height == 0) {
                    return null;
                }
            }
            return ca;
        }
        return null;
    }

    public View findImageChildView() {
        return this.imageView;
    }

    public void setLeftInsetAndUpdate(short leftInset) {
        this.leftInset = leftInset;
    }

    public void setRightInsetAndUpdate(short rightInset) {
        this.rightInset = rightInset;
    }

    protected short getTopInset() {
        return (short)(this.getTopPadding() + SferyxUtilities.getCellTopBorderSize(this.getAttributes(), this.getElement()));
    }

    protected short getBottomInset() {
        return (short)(this.getBottomPadding() + SferyxUtilities.getCellBottomBorderSize(this.getAttributes(), this.getElement()));
    }

    protected void updateLayout(DocumentEvent.ElementChange ec, DocumentEvent e, Shape a) {
        super.updateLayout(ec, e, a);
    }

    public short getLeftInset() {
        boolean inset = false;
        return (short)(this.getLeftPadding() + SferyxUtilities.getCellLeftBorderSize(this.getAttributes(), this.getElement()));
    }

    public short getRightInset() {
        boolean inset = false;
        return (short)(this.getRightPadding() + SferyxUtilities.getCellRightBorderSize(this.getAttributes(), this.getElement()));
    }

    public int indexOfView(View v) {
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            View currView = this.getView(i);
            if (currView != v) continue;
            return i;
        }
        return -1;
    }

    public short getSuperLeftInset() {
        return super.getLeftInset();
    }

    public short getSuperRightInset() {
        return super.getRightInset();
    }

    public short getSuperTopInset() {
        return super.getTopInset();
    }

    public short getSuperBottomInset() {
        return super.getBottomInset();
    }

    public void setInsets(short top, short left, short bottom, short right) {
        super.setInsets(top, left, bottom, right);
    }

    protected void adjustParagraphLayout(View parentView, int myIndex, int targetSpan, int[] offsets, int[] spans) {
        try {
            Vector<alignedImage> leftAlignedImages = new Vector<alignedImage>();
            int n = parentView.getViewCount();
            boolean startIndex = false;
            for (int i = 0; i < myIndex; ++i) {
                View currentView = parentView.getView(i);
                int paragraphOffset = this.getMyOffset();
                if (currentView instanceof CustomParagraphView) {
                    CustomParagraphView currentCustomParagraphView = (CustomParagraphView)currentView;
                    if (currentCustomParagraphView.containsAlignedImages) {
                        for (int x = 0; x < currentCustomParagraphView.getViewCount(); ++x) {
                            int indexOfimage;
                            View imageView_ = ((Row)currentCustomParagraphView.getView(x)).findImageChildView();
                            if (imageView_ == null || imageView_.getParent() == null || imageView_.getParent().getParent() != currentCustomParagraphView || (indexOfimage = currentCustomParagraphView.indexOfView(imageView_.getParent())) == -1) continue;
                            int img_offset = currentCustomParagraphView.getOffset(1, indexOfimage);
                            leftAlignedImages.addElement(new alignedImage(imageView_, img_offset + currentCustomParagraphView.getMyOffset() + (int)imageView_.getPreferredSpan(1), img_offset + currentCustomParagraphView.getMyOffset(), currentCustomParagraphView));
                        }
                    }
                }
                for (int j = 0; j < leftAlignedImages.size(); ++j) {
                    alignedImage alignedImage_ = (alignedImage)leftAlignedImages.elementAt(j);
                    if (this.isLeftAlignedView(alignedImage_.my_imageView) && alignedImage_.my_offset >= paragraphOffset && alignedImage_.my_parentView != this && parentView.getView(myIndex - 1) instanceof CustomParagraphView) {
                        int difference = (int)((CustomParagraphView)parentView.getView((int)(myIndex - 1))).lastRowLeftInset;
                        offsets[myIndex] = offsets[myIndex - 1] + difference;
                        spans[myIndex] = targetSpan - offsets[myIndex];
                    }
                    if (this.isRightAlignedView(alignedImage_.my_imageView) && alignedImage_.my_offset >= paragraphOffset && alignedImage_.my_parentView == this) continue;
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    protected void adjustChildParagraphsLayout(View parentView, int targetSpan) {
        try {
            int myIndex = this.getMyIndex();
            Vector<alignedImage> leftAlignedImages = new Vector<alignedImage>();
            int n = parentView.getViewCount();
            boolean startIndex = false;
            for (int i = 0; i < n; ++i) {
                alignedImage alignedImage_;
                int j;
                View currentParagraphView = parentView.getView(i);
                int paragraphOffset = 0;
                if (currentParagraphView instanceof CustomParagraphView) {
                    paragraphOffset = ((CustomParagraphView)currentParagraphView).getMyOffset();
                } else if (currentParagraphView instanceof CustomBlockView) {
                    paragraphOffset = ((CustomBlockView)currentParagraphView).getMyOffset();
                }
                if (currentParagraphView instanceof CustomParagraphView) {
                    CustomParagraphView currentCustomParagraphView = (CustomParagraphView)currentParagraphView;
                    if (currentCustomParagraphView.containsAlignedImages) {
                        for (int x = 0; x < currentCustomParagraphView.getViewCount(); ++x) {
                            int indexOfimage;
                            View imageView_ = ((Row)((CustomParagraphView)currentParagraphView).getView(x)).findImageChildView();
                            if (imageView_ == null || imageView_.getParent() == null || imageView_.getParent().getParent() != currentParagraphView || (indexOfimage = currentCustomParagraphView.indexOfView(imageView_.getParent())) == -1) continue;
                            int img_offset = currentCustomParagraphView.getOffset(1, indexOfimage);
                            leftAlignedImages.addElement(new alignedImage(imageView_, img_offset + paragraphOffset + (int)imageView_.getPreferredSpan(1), img_offset + paragraphOffset, currentCustomParagraphView));
                        }
                    }
                    currentCustomParagraphView.leftInset = 0;
                    currentCustomParagraphView.rightInset = 0;
                    for (j = 0; j < leftAlignedImages.size(); ++j) {
                        alignedImage_ = (alignedImage)leftAlignedImages.elementAt(j);
                        if (this.isLeftAlignedView(alignedImage_.my_imageView) && alignedImage_.my_offset >= paragraphOffset && alignedImage_.my_parentView != currentCustomParagraphView) {
                            if (((CustomParagraphView)alignedImage_.my_parentView).lastRowLeftInset != 0.0f) {
                                currentCustomParagraphView.setLeftInsetAndUpdate((short)((CustomParagraphView)alignedImage_.my_parentView).lastRowLeftInset);
                            }
                            currentCustomParagraphView.imageSpan = (int)alignedImage_.my_imageView.getPreferredSpan(1);
                            currentCustomParagraphView.imageOffset = alignedImage_.start_offset;
                        }
                        if (!this.isRightAlignedView(alignedImage_.my_imageView) || alignedImage_.my_offset < paragraphOffset || alignedImage_.my_parentView == currentCustomParagraphView) continue;
                        currentCustomParagraphView.setRightInsetAndUpdate((short)((short)alignedImage_.my_imageView.getPreferredSpan(0) + ((CustomParagraphView)alignedImage_.my_parentView).rightInset));
                        currentCustomParagraphView.imageSpan = (int)alignedImage_.my_imageView.getPreferredSpan(1);
                        currentCustomParagraphView.imageOffset = alignedImage_.start_offset;
                    }
                    continue;
                }
                if (!(currentParagraphView instanceof CustomBlockView)) continue;
                CustomBlockView blockView_ = (CustomBlockView)currentParagraphView;
                blockView_.leftAlignedImageOffset = 0;
                blockView_.rightAlignedImageOffset = 0;
                for (j = 0; j < leftAlignedImages.size(); ++j) {
                    CustomBlockView blockView;
                    if (paragraphOffset == 0) continue;
                    alignedImage_ = (alignedImage)leftAlignedImages.elementAt(j);
                    if (this.isLeftAlignedView(alignedImage_.my_imageView) && alignedImage_.my_offset >= paragraphOffset && alignedImage_.my_parentView != currentParagraphView) {
                        try {
                            if (!(currentParagraphView instanceof CustomBlockView)) continue;
                            blockView = (CustomBlockView)currentParagraphView;
                            if (((CustomParagraphView)alignedImage_.my_parentView).lastRowLeftInset == 0.0f) continue;
                            blockView.leftAlignedImageOffset = (short)((CustomParagraphView)alignedImage_.my_parentView).lastRowLeftInset;
                        }
                        catch (Throwable throwable) {}
                        continue;
                    }
                    if (!this.isRightAlignedView(alignedImage_.my_imageView) || alignedImage_.my_offset < paragraphOffset || alignedImage_.my_parentView == currentParagraphView) continue;
                    try {
                        if (!(currentParagraphView instanceof CustomBlockView)) continue;
                        blockView = (CustomBlockView)currentParagraphView;
                        blockView.rightAlignedImageOffset = (int)alignedImage_.my_imageView.getPreferredSpan(0);
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void adjustChildRowsLayout(int index, int[] offsets, int[] spans) {
        int n = this.getViewCount();
        int parentViewIndex = -1;
        float currentHeightCalculated = 0.0f;
        Row parentRowView = null;
        Vector<Row> imageViews = new Vector<Row>();
        Hashtable<Row, Integer> viewsToIndexes = new Hashtable<Row, Integer>();
        Hashtable<Row, Float> viewsToHeights = new Hashtable<Row, Float>();
        Hashtable<View, Integer> imagesToIndexes = new Hashtable<View, Integer>();
        float leftInset = 0.0f;
        float rightInset = 0.0f;
        for (int i = 0; i < n; ++i) {
            Row v = (Row)super.getView(i);
            if (v == null) {
                return;
            }
            View imageView = v.findImageChildView();
            float currentViewHeight = v.getPreferredSpan(1);
            if (imageView != null) {
                parentRowView = v;
                parentViewIndex = i;
                leftInset += (float)parentRowView.getCurrentLeftOffset();
                rightInset += (float)parentRowView.getCurrentRightOffset();
                imageViews.addElement(parentRowView);
                viewsToIndexes.put(parentRowView, new Integer(i));
                viewsToHeights.put(parentRowView, new Float(currentHeightCalculated));
                imagesToIndexes.put(imageView, new Integer(i));
                currentHeightCalculated = 0.0f;
                if (imageView != null) {
                    if (this.imageView != null && imagesToIndexes.get(this.imageView) != null) {
                        int old_index = (Integer)imagesToIndexes.get(this.imageView);
                        if ((float)this.getOffset(1, i) + parentRowView.imageView.getPreferredSpan(1) > (float)this.getOffset(1, old_index) + this.imageView.getPreferredSpan(1)) {
                            this.imageView = imageView;
                        }
                    } else {
                        this.imageView = imageView;
                    }
                }
            }
            if (v != parentRowView) {
                if (parentViewIndex != -1 && i > parentViewIndex && parentRowView.imageView != null) {
                    float imageHeight = parentRowView.imageView.getPreferredSpan(1);
                    if ((currentHeightCalculated += currentViewHeight) <= imageHeight) {
                        offsets[i] = (int)leftInset;
                        spans[i] = spans[i] - (int)leftInset - (int)rightInset;
                    } else {
                        leftInset -= (float)parentRowView.getCurrentLeftOffset();
                        rightInset -= (float)parentRowView.getCurrentRightOffset();
                        imageViews.removeElement(parentRowView);
                        viewsToIndexes.remove(parentRowView);
                        if (imageViews.size() > 0) {
                            parentRowView = (Row)imageViews.elementAt(imageViews.size() - 1);
                            parentViewIndex = (Integer)viewsToIndexes.get(parentRowView);
                            float old_height = ((Float)viewsToHeights.get(parentRowView)).floatValue();
                            currentHeightCalculated += old_height;
                        } else {
                            parentRowView = null;
                            parentViewIndex = -1;
                            currentHeightCalculated = 0.0f;
                            leftInset = 0.0f;
                        }
                    }
                }
            } else {
                currentHeightCalculated += currentViewHeight;
            }
            this.lastRowLeftInset = leftInset;
            this.lastRowRightInset = rightInset;
        }
    }

    public void adjustChildRowsLayout() {
        int n = this.getViewCount();
        int parentViewIndex = -1;
        float currentHeightCalculated = 0.0f;
        Row parentRowView = null;
        Vector<Row> imageViews = new Vector<Row>();
        Hashtable<Row, Integer> viewsToIndexes = new Hashtable<Row, Integer>();
        Hashtable<Row, Float> viewsToHeights = new Hashtable<Row, Float>();
        Hashtable<View, Integer> imagesToIndexes = new Hashtable<View, Integer>();
        float leftInset = 0.0f;
        float rightInset = 0.0f;
        for (int i = 0; i < n; ++i) {
            Row v = (Row)this.getView(i);
            if (v == null) {
                return;
            }
            View imageView = v.findImageChildView();
            float currentViewHeight = v.getPreferredSpan(1);
            if (imageView != null) {
                parentRowView = v;
                parentViewIndex = i;
                leftInset += (float)parentRowView.getCurrentLeftOffset();
                rightInset += (float)parentRowView.getCurrentRightOffset();
                imageViews.addElement(parentRowView);
                viewsToIndexes.put(parentRowView, new Integer(i));
                viewsToHeights.put(parentRowView, new Float(currentHeightCalculated));
                imagesToIndexes.put(imageView, new Integer(i));
                currentHeightCalculated = 0.0f;
                if (imageView != null) {
                    if (this.imageView != null && imagesToIndexes.get(this.imageView) != null) {
                        int old_index = (Integer)imagesToIndexes.get(this.imageView);
                        if ((float)this.getOffset(1, i) + parentRowView.imageView.getPreferredSpan(1) > (float)this.getOffset(1, old_index) + this.imageView.getPreferredSpan(1)) {
                            this.imageView = imageView;
                        }
                    } else {
                        this.imageView = imageView;
                    }
                }
            }
            if (v != parentRowView) {
                if (parentViewIndex == -1 || i <= parentViewIndex || parentRowView.imageView == null) continue;
                float imageHeight = parentRowView.imageView.getPreferredSpan(1);
                if ((currentHeightCalculated += currentViewHeight) <= imageHeight) {
                    v.setLeftInsetAndUpdate((short)leftInset);
                    v.setRightInsetAndUpdate((short)rightInset);
                    continue;
                }
                leftInset -= (float)parentRowView.getCurrentLeftOffset();
                rightInset -= (float)parentRowView.getCurrentRightOffset();
                imageViews.removeElement(parentRowView);
                viewsToIndexes.remove(parentRowView);
                if (imageViews.size() > 0) {
                    parentRowView = (Row)imageViews.elementAt(imageViews.size() - 1);
                    parentViewIndex = (Integer)viewsToIndexes.get(parentRowView);
                    float old_height = ((Float)viewsToHeights.get(parentRowView)).floatValue();
                    currentHeightCalculated += old_height;
                    continue;
                }
                parentRowView = null;
                parentViewIndex = -1;
                currentHeightCalculated = 0.0f;
                leftInset = 0.0f;
                continue;
            }
            currentHeightCalculated += currentViewHeight;
        }
    }

    public void adjustChildRowsLayoutForAllRows() {
        for (int i = 0; i < this.getViewCount(); ++i) {
            this.adjustChildRowsLayout(i);
        }
    }

    public void adjustChildRowsLayoutForAllSuperiorRows(int index) {
        block3: {
            block2: {
                if (!SferyxUtilities.getJVMVersion().startsWith("1.3")) break block2;
                if (!this.containsAlignedImages) break block3;
                for (int i = 0; i <= index; ++i) {
                    this.adjustChildRowsLayout(i);
                }
                break block3;
            }
            for (int i = 0; i <= index; ++i) {
                this.adjustChildRowsLayout(i);
            }
        }
    }

    public void adjustChildRowsLayoutForAllInferiorRows(int index) {
        for (int i = index; i < this.getViewCount(); ++i) {
            this.adjustChildRowsLayout(i);
        }
    }

    public void adjustChildRowsLayout(int index) {
        if (index < 0) {
            return;
        }
        if (index == 0) {
            this.leftAlignedViewsPoly.removeAllElements();
            this.rightAlignedViewsPoly.removeAllElements();
            this.totalHeight = 0;
        }
        Row currentRow = (Row)this.getView(index);
        int currentRowOffset = this.totalHeight;
        this.totalHeight = (int)((float)this.totalHeight + currentRow.getPreferredSpan(1));
        currentRow.findImageChildView();
        if (index > 0) {
            Row previousRow = (Row)this.getView(index - 1);
            if (previousRow == null) {
                return;
            }
            int upperRightOffset = previousRow.rightInset + previousRow.currentRightOffset;
            int upperLeftOffset = previousRow.leftInset + previousRow.currentLeftOffset;
            currentRow.rightInset = (short)upperRightOffset;
            currentRow.leftInset = (short)upperLeftOffset;
            this.lastRowLeftInset = currentRow.leftInset;
            this.lastRowRightInset = currentRow.rightInset;
            Object[] rects = new Rectangle[this.leftAlignedViewsPoly.size()];
            this.leftAlignedViewsPoly.copyInto(rects);
            for (int i = rects.length - 1; i >= 0; --i) {
                Object rect = rects[i];
                if (rect == null || ((Rectangle)rect).y + ((Rectangle)rect).height >= this.totalHeight || i != this.leftAlignedViewsPoly.size() - 1) continue;
                currentRow.leftInset = (short)(currentRow.leftInset - ((Rectangle)rect).width);
                this.leftAlignedViewsPoly.removeElement(rect);
            }
            Object[] rightRects = new Rectangle[this.rightAlignedViewsPoly.size()];
            this.rightAlignedViewsPoly.copyInto(rightRects);
            for (int i = rightRects.length - 1; i >= 0; --i) {
                Object rect = rightRects[i];
                if (rect == null || ((Rectangle)rect).y + ((Rectangle)rect).height >= this.totalHeight || i != this.rightAlignedViewsPoly.size() - 1) continue;
                currentRow.rightInset = (short)(currentRow.rightInset - ((Rectangle)rect).width);
                this.rightAlignedViewsPoly.removeElement(rect);
            }
            if (index == this.getViewCount() - 1) {
                this.lastRowLeftInset += (float)currentRow.currentLeftOffset;
                this.lastRowRightInset += (float)currentRow.currentRightOffset;
            }
        } else {
            this.lastRowLeftInset = currentRow.currentLeftOffset;
            this.lastRowRightInset = currentRow.currentRightOffset;
        }
        if (!currentRow.leftViews.isEmpty()) {
            for (int i = 0; i < currentRow.leftViews.size(); ++i) {
                View currentView = (View)currentRow.leftViews.elementAt(i);
                Rectangle rect = new Rectangle(currentRow.leftInset + currentRow.getOffset(0, i), currentRowOffset, (int)currentView.getPreferredSpan(0), (int)currentView.getPreferredSpan(1));
                this.leftAlignedViewsPoly.addElement(rect);
            }
        }
        if (!currentRow.rightViews.isEmpty()) {
            for (int i = 0; i < currentRow.rightViews.size(); ++i) {
                View currentView = (View)currentRow.rightViews.elementAt(i);
                Rectangle rect = new Rectangle(currentRow.rightInset + currentRow.getOffset(0, i), currentRowOffset, (int)currentView.getPreferredSpan(0), (int)currentView.getPreferredSpan(1));
                this.rightAlignedViewsPoly.addElement(rect);
            }
        }
    }

    void empty(int index) {
        int n = this.getViewCount();
        int parentViewIndex = -1;
        float currentHeightCalculated = 0.0f;
        Row parentRowView = null;
        Vector<Row> imageViews = new Vector<Row>();
        Hashtable<Row, Integer> viewsToIndexes = new Hashtable<Row, Integer>();
        Hashtable<Row, Float> viewsToHeights = new Hashtable<Row, Float>();
        Hashtable<View, Integer> imagesToIndexes = new Hashtable<View, Integer>();
        float leftInset = 0.0f;
        float rightInset = 0.0f;
        for (int i = 0; i < n; ++i) {
            Row v = (Row)super.getView(i);
            if (v == null) {
                return;
            }
            View imageView = v.findImageChildView();
            float currentViewHeight = v.getPreferredSpan(1);
            if (imageView != null) {
                parentRowView = v;
                parentViewIndex = i;
                leftInset += (float)parentRowView.getCurrentLeftOffset();
                rightInset += (float)parentRowView.getCurrentRightOffset();
                imageViews.addElement(parentRowView);
                viewsToIndexes.put(parentRowView, new Integer(i));
                viewsToHeights.put(parentRowView, new Float(currentHeightCalculated));
                imagesToIndexes.put(imageView, new Integer(i));
                currentHeightCalculated = 0.0f;
                if (imageView != null) {
                    if (this.imageView != null && imagesToIndexes.get(this.imageView) != null) {
                        int old_index = (Integer)imagesToIndexes.get(this.imageView);
                        if ((float)this.getOffset(1, i) + parentRowView.imageView.getPreferredSpan(1) > (float)this.getOffset(1, old_index) + this.imageView.getPreferredSpan(1)) {
                            this.imageView = imageView;
                        }
                    } else {
                        this.imageView = imageView;
                    }
                }
            }
            if (v != parentRowView) {
                if (parentViewIndex == -1 || i <= parentViewIndex || parentRowView.imageView == null) continue;
                float imageHeight = parentRowView.imageView.getPreferredSpan(1);
                if ((currentHeightCalculated += currentViewHeight) <= imageHeight) {
                    v.setLeftInsetAndUpdate((short)leftInset);
                    v.setRightInsetAndUpdate((short)rightInset);
                    continue;
                }
                leftInset -= (float)parentRowView.getCurrentLeftOffset();
                rightInset -= (float)parentRowView.getCurrentRightOffset();
                imageViews.removeElement(parentRowView);
                viewsToIndexes.remove(parentRowView);
                if (imageViews.size() > 0) {
                    parentRowView = (Row)imageViews.elementAt(imageViews.size() - 1);
                    parentViewIndex = (Integer)viewsToIndexes.get(parentRowView);
                    float old_height = ((Float)viewsToHeights.get(parentRowView)).floatValue();
                    currentHeightCalculated += old_height;
                    continue;
                }
                parentRowView = null;
                parentViewIndex = -1;
                currentHeightCalculated = 0.0f;
                leftInset = 0.0f;
                continue;
            }
            currentHeightCalculated += currentViewHeight;
        }
        this.lastRowLeftInset = leftInset;
        this.lastRowRightInset = rightInset;
    }

    boolean isLastInParent() {
        View parent = this.getParent();
        if (parent == null) {
            return false;
        }
        int n = parent.getViewCount();
        View lastView = parent.getView(n - 1);
        return lastView == this;
    }

    public int getInternalVerticalSpan() {
        return (int)super.getPreferredSpan(1);
    }

    public int getMyIndex() {
        View parentView = this.getParent();
        int n = parentView.getViewCount();
        for (int i = 0; i < n; ++i) {
            View currView = parentView.getView(i);
            if (currView != this) continue;
            return i;
        }
        return -1;
    }

    public int getMyOffset() {
        View currentView;
        View parentView = this.getParent();
        if (parentView instanceof CustomLayoutBoxView) {
            return ((CustomLayoutBoxView)parentView).getOffset(1, this.getMyIndex());
        }
        int n = parentView.getViewCount();
        int offset = 0;
        for (int i = 0; i < n && (currentView = parentView.getView(i)) != this; ++i) {
            offset = (int)((float)offset + currentView.getPreferredSpan(1));
        }
        return offset;
    }

    public int getMyOffset1() {
        int paragraphOffset = -1;
        try {
            View parentView = this.getParent();
            if (parentView instanceof CustomParagraphView) {
                paragraphOffset = ((CustomParagraphView)parentView).getOffset(1, this.getMyIndex());
            } else if (parentView instanceof CustomLayoutBoxView) {
                paragraphOffset = ((CustomBlockView)parentView).getOffset(1, this.getMyIndex());
            } else {
                View currentView;
                int n = parentView.getViewCount();
                boolean offset = false;
                for (int i = 0; i < n && (currentView = parentView.getView(i)) != this; ++i) {
                    paragraphOffset = (int)((float)paragraphOffset + currentView.getPreferredSpan(1));
                }
            }
            return paragraphOffset;
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    int getRealSpan() {
        int n = this.getViewCount();
        int realSpan = 0;
        int imgIndex = -1;
        for (int i = 0; i < n; ++i) {
            Row currView = (Row)this.getView(i);
            if (currView.realImageDimension != 0) {
                imgIndex = i;
                realSpan += currView.realImageDimension;
                realSpan += currView.realSpan;
            }
            if (imgIndex != -1) continue;
            realSpan += currView.realSpan;
            float above = StyleConstants.getSpaceAbove(currView.getAttributes());
            float below = StyleConstants.getSpaceBelow(currView.getAttributes());
            realSpan = (int)((float)realSpan + above);
            realSpan = (int)((float)realSpan + below);
        }
        return realSpan;
    }

    int getRealSpan(CustomParagraphView currentParagraph) {
        int n = currentParagraph.getViewCount();
        int realSpan = 0;
        int imgIndex = -1;
        int currParCumulative = 0;
        for (int i = 0; i < n; ++i) {
            Row currView = (Row)currentParagraph.getView(i);
            if (currView.realImageDimension != 0) {
                imgIndex = i;
                realSpan += currView.realImageDimension;
                realSpan += currView.realSpan;
                this.currentImageDimension = currView.realImageDimension;
                this.containsAlignedImages = true;
            }
            if (imgIndex == -1 && this.currentImageDimension == 0) {
                realSpan += currView.realSpan;
                float above = StyleConstants.getSpaceAbove(currView.getAttributes());
                float below = StyleConstants.getSpaceBelow(currView.getAttributes());
                realSpan = (int)((float)realSpan + above);
                realSpan = (int)((float)realSpan + below);
            }
            if ((currParCumulative += currView.realSpan) <= this.currentImageDimension) continue;
            this.currentImageDimension = 0;
        }
        return realSpan;
    }

    int getTotalRealSpan() {
        View parent = this.getParent();
        int n = parent.getViewCount();
        int totalRealSpan = 0;
        this.currentImageDimension = 0;
        this.containsAlignedImages = false;
        for (int i = 0; i < n; ++i) {
            View currView = parent.getView(i);
            if (currView instanceof CustomParagraphView) {
                totalRealSpan += this.getRealSpan((CustomParagraphView)currView);
                continue;
            }
            totalRealSpan = (int)((float)totalRealSpan + currView.getPreferredSpan(1));
        }
        return totalRealSpan;
    }

    public float getHeightCSSValue() {
        float span = -1.0f;
        if (SferyxUtilities.getStyleSheetCSSValueForElement(this.getStyleSheet(), this.getAttributes(), CSS.Attribute.HEIGHT) != null && (span = SferyxUtilities.getNumberFromCSString(SferyxUtilities.getStyleSheetCSSValueForElement(this.getStyleSheet(), this.getAttributes(), CSS.Attribute.HEIGHT).toString())) != -1.0f) {
            return span;
        }
        AttributeSet elemAttribs = this.getElement().getAttributes();
        String emMargin = (String)elemAttribs.getAttribute("height");
        AttributeSet viewAttributes = this.getAttributes();
        if (emMargin == null) {
            emMargin = (String)viewAttributes.getAttribute("height");
        }
        if (emMargin == null) {
            emMargin = (String)elemAttribs.getAttribute(AlternativeCSSAttribute.HEIGHT);
        }
        if (emMargin == null) {
            emMargin = (String)viewAttributes.getAttribute(AlternativeCSSAttribute.HEIGHT);
        }
        if (emMargin != null && elemAttribs.isDefined("height") || viewAttributes.isDefined(AlternativeCSSAttribute.HEIGHT) || elemAttribs.isDefined(AlternativeCSSAttribute.HEIGHT)) {
            if (emMargin != null && emMargin.indexOf("em") != -1 && emMargin.indexOf("rem") == -1) {
                float emValue = SferyxUtilities.convertEmValue(emMargin);
                if (emValue != -1.0f) {
                    Font font = this.getStyleSheet().getFont(this.getAttributes());
                    int result = (int)((float)font.getSize() * emValue);
                    this.margin_left_em = true;
                    return result;
                }
            } else if (emMargin != null && emMargin.indexOf("rem") != -1) {
                float emValue = SferyxUtilities.convertEmValue(emMargin);
                if (emValue != -1.0f && this.getContainer() != null) {
                    View rootView = ((JEditorPane)this.getContainer()).getUI().getRootView((JEditorPane)this.getContainer());
                    Font font = this.getStyleSheet().getFont(rootView.getAttributes());
                    int result = (int)((float)font.getSize() * emValue);
                    this.margin_left_em = true;
                    return result;
                }
            } else if (emMargin != null && emMargin.indexOf("%") != -1) {
                try {
                    float emValue = Float.parseFloat(emMargin.substring(0, emMargin.indexOf("%")));
                    if (emValue != -1.0f && this.getParent() instanceof BoxView) {
                        int result = (int)((float)((BoxView)this.getParent()).getWidth() * emValue / 100.0f);
                        return result;
                    }
                }
                catch (Throwable thr) {
                    // empty catch block
                }
            }
        }
        return span;
    }

    public float getWidthCSSValue() {
        float span = -1.0f;
        span = SferyxUtilities.getStyleSheetCSSWidthForView(this.getStyleSheet(), this);
        if (span != -1.0f) {
            return span;
        }
        AttributeSet elemAttribs = this.getElement().getAttributes();
        String emMargin = (String)elemAttribs.getAttribute("width");
        AttributeSet viewAttributes = this.getAttributes();
        if (emMargin == null) {
            emMargin = (String)viewAttributes.getAttribute("width");
        }
        if (emMargin == null) {
            emMargin = (String)elemAttribs.getAttribute(AlternativeCSSAttribute.WIDTH);
        }
        if (emMargin == null) {
            emMargin = (String)viewAttributes.getAttribute(AlternativeCSSAttribute.WIDTH);
        }
        if (emMargin != null & (elemAttribs.isDefined("width") || viewAttributes.isDefined("width") || viewAttributes.isDefined(AlternativeCSSAttribute.WIDTH) || elemAttribs.isDefined(AlternativeCSSAttribute.WIDTH))) {
            if (emMargin != null && emMargin.indexOf("em") != -1 && emMargin.indexOf("rem") == -1) {
                float emValue = SferyxUtilities.convertEmValue(emMargin);
                if (emValue != -1.0f) {
                    Font font = this.getStyleSheet().getFont(this.getAttributes());
                    int result = (int)((float)font.getSize() * emValue);
                    this.margin_left_em = true;
                    return result;
                }
            } else if (emMargin != null && emMargin.indexOf("rem") != -1) {
                float emValue = SferyxUtilities.convertEmValue(emMargin);
                if (emValue != -1.0f && this.getContainer() != null) {
                    View rootView = ((JEditorPane)this.getContainer()).getUI().getRootView((JEditorPane)this.getContainer());
                    Font font = this.getStyleSheet().getFont(rootView.getAttributes());
                    int result = (int)((float)font.getSize() * emValue);
                    this.margin_left_em = true;
                    return result;
                }
            } else if (emMargin != null && emMargin.indexOf("%") != -1) {
                try {
                    float emValue = Float.parseFloat(emMargin.substring(0, emMargin.indexOf("%")));
                    if (emValue != -1.0f && this.getParent() instanceof BoxView) {
                        int result = (int)((float)((BoxView)this.getParent()).getWidth() * emValue / 100.0f);
                        return result;
                    }
                }
                catch (Throwable thr) {
                    // empty catch block
                }
            }
        }
        return span;
    }

    public int getTopBottomBorderInset() {
        AttributeSet viewAttributes = this.getAttributes();
        return SferyxUtilities.getCellTopBorderSize(viewAttributes, this.getElement()) + SferyxUtilities.getCellBottomBorderSize(viewAttributes, this.getElement());
    }

    public int getLeftRightBorderInset() {
        AttributeSet viewAttributes = this.getAttributes();
        return SferyxUtilities.getCellLeftBorderSize(viewAttributes, this.getElement()) + SferyxUtilities.getCellRightBorderSize(viewAttributes, this.getElement());
    }

    public float getMaximumSpan(int axis) {
        float span_;
        block14: {
            try {
                if (!this.isVisible()) {
                    return 0.0f;
                }
            }
            catch (Throwable thr) {
                // empty catch block
            }
            if (SferyxUtilities.isViewNotVisible(this, this.getStyleSheet())) {
                return 0.0f;
            }
            if (axis == 0) {
                float span = -1.0f;
                float width = this.getWidthCSSValue();
                if (width != -1.0f && (span = width + (float)this.getLeftPadding() + (float)this.getRightPadding() + (float)this.getLeftRightBorderInset()) != -1.0f) {
                    return span;
                }
            }
            if (axis == 0 && (SferyxUtilities.isFloatLeftView(this.getElement().getAttributes(), this.getStyleSheet()) || SferyxUtilities.isFloatLeftView(this.getAttributes(), this.getStyleSheet()) || SferyxUtilities.isFloatRightView(this.getElement().getAttributes(), this.getStyleSheet()) || SferyxUtilities.isFloatRightView(this.getAttributes(), this.getStyleSheet()) || this.isAbsolutePositioning())) {
                return this.getPreferredSpan(axis);
            }
            float span = -1.0f;
            if (axis != 0) break block14;
            span = this.getWidthCSSValue();
            try {
                if (span == -1.0f) {
                    span = super.getMaximumSpan(axis);
                }
            }
            finally {
                float min_span = 0.0f;
            }
            {
            }
        }
        float orig_span = super.getMaximumSpan(axis);
        if (axis == 1 && this.isLastInParent() && this.getParent() instanceof CustomLayoutBoxView && (span_ = this.getAlignedViewsSpan(orig_span)) > orig_span) {
            return span_;
        }
        return orig_span;
    }

    public float getMinimumSpan(int axis) {
        float span_;
        try {
            if (!this.isVisible()) {
                return 0.0f;
            }
        }
        catch (Throwable thr) {
            // empty catch block
        }
        if (SferyxUtilities.isViewNotVisible(this, this.getStyleSheet())) {
            return 0.0f;
        }
        if (axis == 0) {
            float span = -1.0f;
            float width = this.getWidthCSSValue();
            if (width != -1.0f && (span = width + (float)this.getLeftPadding() + (float)this.getRightPadding() + (float)this.getLeftRightBorderInset()) != -1.0f) {
                return span;
            }
        }
        float orig_span = super.getMinimumSpan(axis);
        if (axis == 1 && this.isLastInParent() && this.getParent() instanceof CustomLayoutBoxView && (span_ = this.getAlignedViewsSpan(orig_span)) > orig_span) {
            return span_;
        }
        return orig_span;
    }

    public float getPreferredSpan(int axis) {
        try {
            if (!this.isVisible()) {
                return 0.0f;
            }
        }
        catch (Throwable thr) {
            // empty catch block
        }
        if (SferyxUtilities.isViewNotVisible(this, this.getStyleSheet())) {
            return 0.0f;
        }
        try {
            if (axis == 0) {
                float span = -1.0f;
                float width = this.getWidthCSSValue();
                if (width != -1.0f && (span = width + (float)this.getLeftPadding() + (float)this.getRightPadding() + (float)this.getLeftRightBorderInset()) != -1.0f) {
                    return span;
                }
            }
            float span = super.getPreferredSpan(axis);
            if (axis == 0) {
                span = this.getWidthCSSValue();
                if (span == -1.0f) {
                    span = super.getPreferredSpan(axis);
                }
                float min_span = super.getMinimumSpan(axis);
                if (span + (float)this.getLeftPadding() + (float)this.getRightPadding() > min_span) {
                    return span + (float)this.getLeftPadding() + (float)this.getRightPadding();
                }
                return min_span;
            }
            if (axis == 1 && this.isLastInParent() && this.getParent() instanceof CustomLayoutBoxView) {
                span = this.getAlignedViewsSpan(span);
            }
            if (axis == 1) {
                // empty if block
            }
            return span;
        }
        catch (Throwable throwable) {
            return 0.0f;
        }
    }

    float getAlignedViewsSpan(float span) {
        for (int j = 0; j < this.getParent().getViewCount(); ++j) {
            if (!(this.getParent().getView(j) instanceof CustomParagraphView)) continue;
            Vector leftAlignedViewsPoly_ = ((CustomParagraphView)this.getParent().getView((int)j)).leftAlignedViewsPoly;
            for (int i = 0; i < leftAlignedViewsPoly_.size(); ++i) {
                Rectangle rect = (Rectangle)leftAlignedViewsPoly_.elementAt(i);
                if (!((float)(((CustomParagraphView)this.getParent().getView(j)).getMyOffset() + rect.y + rect.height) > (float)this.getMyOffset() + span)) continue;
                span = ((CustomParagraphView)this.getParent().getView(j)).getMyOffset() + rect.y + rect.height - this.getMyOffset();
            }
            Vector rightAlignedViewsPoly_ = ((CustomParagraphView)this.getParent().getView((int)j)).rightAlignedViewsPoly;
            for (int i = 0; i < rightAlignedViewsPoly_.size(); ++i) {
                Rectangle rect = (Rectangle)rightAlignedViewsPoly_.elementAt(i);
                if (!((float)(((CustomParagraphView)this.getParent().getView(j)).getMyOffset() + rect.y + rect.height) > (float)this.getMyOffset() + span)) continue;
                span = ((CustomParagraphView)this.getParent().getView(j)).getMyOffset() + rect.y + rect.height - this.getMyOffset();
            }
        }
        return span;
    }

    public float getMinimumSpan1(int axis) {
        float orig_span = 0.0f;
        try {
            orig_span = super.getMinimumSpan(axis);
        }
        catch (Throwable thrr) {
            orig_span = 0.0f;
        }
        float span = orig_span;
        try {
            if (axis == 0) {
                if (SferyxUtilities.getStyleSheetCSSValueForElement(this.getStyleSheet(), this.getAttributes(), CSS.Attribute.WIDTH) != null) {
                    span = SferyxUtilities.getNumberFromCSString(SferyxUtilities.getStyleSheetCSSValueForElement(this.getStyleSheet(), this.getAttributes(), CSS.Attribute.WIDTH).toString());
                }
                if (span > orig_span) {
                    return span;
                }
                return orig_span;
            }
            int n = this.getViewCount();
            for (int i = 0; i < n; ++i) {
                Row v = (Row)this.getView(i);
                if (!((float)(this.getOffset(1, i) + v.realImageDimension) > span)) continue;
                return this.getOffset(1, i) + v.realImageDimension;
            }
            return span;
        }
        catch (Throwable thr) {
            return 0.0f;
        }
    }

    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.removeUpdate(e, a, f);
    }

    public int getFlowSpan(int index) {
        int span;
        Row v = (Row)this.getView(index);
        v.parentSpan = this.layoutSpan;
        if (this.containsAlignedImages || this.containsImages) {
            this.adjustChildRowsLayoutForAllSuperiorRows(index);
        }
        int newSpan = span = super.getFlowSpan(index);
        newSpan = span - v.leftInset - v.getLeftInset() - v.rightInset - this.getLeftPadding() - this.getRightPadding();
        if (newSpan > 0) {
            return newSpan;
        }
        return 0;
    }

    protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        int n = this.getViewCount();
        int i = 0;
        while (i < n) {
            Row v = (Row)this.getView(i);
            v.parentSpan = targetSpan;
            int min = (int)v.getMinimumSpan(axis);
            int max = (int)v.getMaximumSpan(axis);
            if (max < targetSpan) {
                float align = v.getAlignment(axis);
                offsets[i] = (int)((float)(targetSpan - max) * align);
                spans[i] = max;
            } else {
                offsets[i] = 0;
                spans[i] = Math.max(min, targetSpan);
            }
            int n2 = i;
            offsets[n2] = offsets[n2] + v.leftInset;
            int n3 = i++;
            offsets[n3] = offsets[n3] + this.getLeftPadding();
        }
    }

    protected int getNextEastWestVisualPositionFrom(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        return super.getNextEastWestVisualPositionFrom(pos, b, a, direction, biasRet);
    }

    protected void baselineLayout(int targetSpan, int axis, int[] offsets, int[] spans) {
        super.baselineLayout(targetSpan, axis, offsets, spans);
    }

    protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
        SizeRequirements req = super.calculateMinorAxisRequirements(axis, r);
        return req;
    }

    protected void layout(int width, int height) {
        try {
            super.layout(width, height);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        this.offsets_Y = offsets;
        this.spans_Y = spans;
        long minimum = 0L;
        long maximum = 0L;
        long preferred = 0L;
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            View v = this.getView(i);
            spans[i] = (int)v.getPreferredSpan(axis);
            preferred += (long)spans[i];
            minimum = (long)((float)minimum + v.getMinimumSpan(axis));
            maximum = (long)((float)maximum + v.getMaximumSpan(axis));
        }
        long desiredAdjustment = (long)targetSpan - preferred;
        float adjustmentFactor = 0.0f;
        if (desiredAdjustment != 0L) {
            float maximumAdjustment;
            float f = maximumAdjustment = desiredAdjustment > 0L ? (float)(maximum - preferred) : (float)(preferred - minimum);
            if (maximumAdjustment == 0.0f) {
                adjustmentFactor = 0.0f;
            } else {
                adjustmentFactor = (float)desiredAdjustment / maximumAdjustment;
                adjustmentFactor = Math.min(adjustmentFactor, 1.0f);
                adjustmentFactor = Math.max(adjustmentFactor, -1.0f);
            }
        }
        int totalOffset = 0;
        for (int i = 0; i < n; ++i) {
            View v = this.getView(i);
            offsets[i] = totalOffset;
            int availableSpan = adjustmentFactor > 0.0f ? (int)v.getMaximumSpan(axis) - spans[i] : spans[i] - (int)v.getMinimumSpan(axis);
            float adjF = adjustmentFactor * (float)availableSpan;
            adjF = adjF < 0.0f ? (adjF -= 0.5f) : (adjF += 0.5f);
            int adj = (int)adjF;
            int n2 = i;
            spans[n2] = spans[n2] + adj;
            totalOffset = (int)Math.min((long)totalOffset + (long)spans[i], Integer.MAX_VALUE);
        }
    }

    protected void setLineSpacing(float ls) {
    }

    protected void setJustification(int j) {
        this.justification = j;
        super.setJustification(j);
    }

    public float getJustification() {
        return this.justification;
    }

    public boolean isLeftAlignedView(View view) {
        try {
            Object align_attribute = view.getElement().getAttributes().getAttribute(HTML.Attribute.ALIGN);
            Object name_attribute = view.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (SferyxUtilities.isFloatLeftView(view, ((HTMLDocument)this.getElement().getDocument()).getStyleSheet())) {
                return true;
            }
            boolean isFloat = false;
            if (align_attribute == null && SferyxUtilities.getStyleSheetCSSValueForElement(view.getElement(), CSS.Attribute.FLOAT) != null) {
                align_attribute = SferyxUtilities.getStyleSheetCSSValueForElement(view.getElement(), CSS.Attribute.FLOAT).toString();
                isFloat = true;
            }
            return align_attribute != null && ((String)align_attribute).equalsIgnoreCase("left") && view.getElement().getAttributes().containsAttribute(HTML.Attribute.ALIGN, "left") || align_attribute != null && isFloat && align_attribute.equals("left");
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean isRightAlignedView(View view) {
        try {
            Object align_attribute = view.getElement().getAttributes().getAttribute(HTML.Attribute.ALIGN);
            Object name_attribute = view.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (SferyxUtilities.isFloatRightView(view, ((HTMLDocument)this.getElement().getDocument()).getStyleSheet())) {
                return true;
            }
            boolean isFloat = false;
            if (align_attribute == null && SferyxUtilities.getStyleSheetCSSValueForElement(view.getElement(), CSS.Attribute.FLOAT) != null) {
                align_attribute = SferyxUtilities.getStyleSheetCSSValueForElement(view.getElement(), CSS.Attribute.FLOAT).toString();
                isFloat = true;
            }
            return align_attribute != null && ((String)align_attribute).equalsIgnoreCase("right") && view.getElement().getAttributes().containsAttribute(HTML.Attribute.ALIGN, "right") || align_attribute != null && isFloat && align_attribute.equals("right");
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

