/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import sferyx.administration.editors.CustomImageView;

public class CustomObjectView
extends CustomImageView {
    ImageIcon flashImageIcon;
    Image flashImage;

    public CustomObjectView(Element elem) {
        super(elem);
        try {
            this.flashImage = this.getEditorImageURL() != null ? this.loadEditorImage(this.getEditorImageURL()) : (this.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute).equals(HTML.Tag.APPLET) ? this.loadIconInternally("/sferyx/administration/editors/icons/java-icon.gif") : (this.getClassID() != null && this.getClassID().equalsIgnoreCase("clsid:D27CDB6E-AE6D-11cf-96B8-444553540000") ? this.loadIconInternally("/sferyx/administration/editors/icons/flash-icon.gif") : (this.getClassID() != null && this.getClassID().equalsIgnoreCase("clsid:8AD9C840-044E-11D1-B3E9-00805F499D93") ? this.loadIconInternally("/sferyx/administration/editors/icons/java-icon.gif") : this.loadIconInternally("/sferyx/administration/editors/icons/object-icon.gif"))));
            this.flashImageIcon = new ImageIcon(this.flashImage);
            this.setPropertiesFromAttributes();
            this.width = this.getIntAttr(HTML.Attribute.WIDTH, -1);
            this.height = this.getIntAttr(HTML.Attribute.HEIGHT, -1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getClassID() {
        if (this.getElement().getAttributes().getAttribute(HTML.Attribute.CLASSID) != null) {
            return this.getElement().getAttributes().getAttribute(HTML.Attribute.CLASSID).toString();
        }
        return null;
    }

    public URL getEditorImageURL() {
        String src = (String)this.getElement().getAttributes().getAttribute("editor_icon");
        if (src == null) {
            return null;
        }
        URL reference = ((HTMLDocument)this.getDocument()).getBase();
        try {
            URL u = new URL(reference, src);
            return u;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private Image loadEditorImage(URL url) {
        URL src = url;
        Image newImage = null;
        if (src != null && (newImage = Toolkit.getDefaultToolkit().getImage(src)) != null && this.getLoadsSynchronously()) {
            ImageIcon ii = new ImageIcon();
            ii.setImage(newImage);
        }
        return newImage;
    }

    public Image getImage() {
        return this.flashImage;
    }

    public Icon getNoImageIcon() {
        return this.flashImageIcon;
    }

    private Image loadIconInternally(String location) {
        try {
            InputStream in = this.getClass().getResourceAsStream(location);
            if (in == null) {
                System.err.println("Image not found.");
            }
            byte[] buffer = new byte[in.available()];
            in.read(buffer);
            return Toolkit.getDefaultToolkit().createImage(buffer);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g, Shape a) {
        if (a == null) {
            return;
        }
        if (g == null) {
            return;
        }
        Rectangle clip1 = g.getClipBounds();
        this.paintBounds.x = ((Rectangle)a).x;
        this.paintBounds.y = ((Rectangle)a).y;
        this.paintBounds.width = ((Rectangle)a).width;
        this.paintBounds.height = ((Rectangle)a).height;
        try {
            block18: {
                try {
                    this.sync();
                    Rectangle rect = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
                    Image image = this.getImage();
                    Rectangle clip = g.getClipBounds();
                    this.fBounds.setBounds(rect);
                    this.paintHighlights(g, a);
                    this.paintBorder(g, rect);
                    if (clip != null) {
                        g.clipRect(rect.x + this.leftInset, rect.y + this.topInset, rect.width - this.leftInset - this.rightInset, rect.height - this.topInset - this.bottomInset);
                    }
                    if (image != null) {
                        if (!this.hasPixels(image)) {
                            Icon icon;
                            Icon icon2 = icon = image == null ? this.getNoImageIcon() : this.getLoadingImageIcon();
                            if (icon != null) {
                                icon.paintIcon(this.getContainer(), g, rect.x + this.leftInset, rect.y + this.topInset);
                            }
                        } else {
                            int imageWidth = image.getWidth(this.imageObserver);
                            int imageHeight = image.getHeight(this.imageObserver);
                            g.drawImage(image, rect.x + this.leftInset + rect.width / 2 - imageWidth / 2, rect.y + this.topInset + rect.height / 2 - imageHeight / 2, imageWidth, imageHeight, this.imageObserver);
                        }
                    } else {
                        View view;
                        Icon icon = this.getNoImageIcon();
                        if (icon != null) {
                            icon.paintIcon(this.getContainer(), g, rect.x + this.leftInset, rect.y + this.topInset);
                        }
                        if ((view = this.getAltView()) != null && ((this.state & 4) == 0 || this.width > 38)) {
                            Rectangle altRect = new Rectangle(rect.x + this.leftInset + 38, rect.y + this.topInset, rect.width - this.leftInset - this.rightInset - 38, rect.height - this.topInset - this.bottomInset);
                            view.paint(g, altRect);
                        }
                    }
                    if (clip != null) {
                        g.setClip(clip.x, clip.y, clip.width, clip.height);
                    }
                    if (!this.isSelected()) break block18;
                    g.setXORMode(Color.white);
                    Rectangle rect1 = (Rectangle)a;
                    g.setColor(Color.black);
                    g.drawRect(rect1.x - 1, rect1.y - 1, rect1.width + 1, rect1.height + 1);
                    g.fillRect(rect1.x + rect1.width / 2 - 3, rect1.y + rect1.height - 6, 6, 6);
                    g.fillRect(rect1.x + rect1.width - 6, rect1.y + rect1.height / 2 - 3, 6, 6);
                    g.fillRect(rect1.x + rect1.width - 6, rect1.y + rect1.height - 6, 6, 6);
                    g.fillRect(rect1.x - 1, rect1.y + rect1.height / 2 - 3, 6, 6);
                    g.fillRect(rect1.x + rect1.width / 2 - 3, rect1.y - 1, 6, 6);
                    g.fillRect(rect1.x + rect1.width - 6, rect1.y - 1, 6, 6);
                    g.fillRect(rect1.x - 1, rect1.y - 1, 6, 6);
                    g.fillRect(rect1.x - 1, rect1.y + rect1.height - 6, 6, 6);
                    g.setPaintMode();
                }
                catch (Exception e) {
                    Object var11_15 = null;
                    if (clip1 != null) {
                        g.setClip(clip1.x, clip1.y, clip1.width, clip1.height);
                    }
                }
            }
            Object var11_14 = null;
            if (clip1 != null) {
                g.setClip(clip1.x, clip1.y, clip1.width, clip1.height);
            }
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            if (clip1 != null) {
                g.setClip(clip1.x, clip1.y, clip1.width, clip1.height);
            }
            throw throwable;
        }
    }

    int getIntAttr(HTML.Attribute name, int deflt) {
        AttributeSet attr = this.getElement().getAttributes();
        if (attr.isDefined(name)) {
            int i;
            String val = attr.getAttribute(name).toString();
            try {
                if (val != null && val.endsWith("%") && this.getParent() != null) {
                    int img_size = -1;
                    if (name == HTML.Attribute.WIDTH) {
                        if (this.getContainer() != null) {
                            img_size = this.getContainer().getWidth();
                        }
                    } else if (name == HTML.Attribute.HEIGHT && this.getContainer() != null) {
                        img_size = this.getContainer().getHeight();
                    }
                    String percent_value = val.substring(0, val.length() - 1);
                    int percent_num = Integer.parseInt(percent_value);
                    int result = percent_num * img_size / 100;
                    return result;
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            if (val == null) {
                i = deflt;
            } else {
                try {
                    i = Math.max(0, Integer.parseInt(val));
                }
                catch (NumberFormatException x) {
                    i = deflt;
                }
            }
            return i;
        }
        return deflt;
    }

    protected void setPropertiesFromAttributes() {
        super.setPropertiesFromAttributes();
        this.width = this.getIntAttr(HTML.Attribute.WIDTH, -1);
        this.height = this.getIntAttr(HTML.Attribute.HEIGHT, -1);
    }
}

