/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.StyleSheet;
import sferyx.administration.editors.CustomBlockView;
import sferyx.administration.editors.CustomParagraphView;
import sferyx.administration.editors.EditorHTMLDocument;
import sferyx.administration.editors.SferyxUtilities;

public class CustomListView
extends CustomBlockView {
    private StyleSheet.ListPainter listPainter;

    public CustomListView(Element elem) {
        super(elem, 1);
    }

    public short getLeftInset() {
        return (short)(this.getLeftPadding() + SferyxUtilities.getCellLeftBorderSize(this.getAttributes(), this.getElement()));
    }

    public short getRightInset() {
        return (short)(this.getRightPadding() + SferyxUtilities.getCellRightBorderSize(this.getAttributes(), this.getElement()));
    }

    public float getAlignment(int axis) {
        switch (axis) {
            case 0: {
                return 0.5f;
            }
            case 1: {
                return 0.5f;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    public void paint(Graphics g, Shape allocation) {
        this.setPropertiesFromAttributes();
        super.paint(g, allocation);
    }

    public void paintOnlyBulletsForChild(Graphics g, Rectangle alloc, int index) {
        AttributeSet elementAttributes = this.getElement().getAttributes();
        if ((elementAttributes.getAttribute(HTML.Attribute.TYPE) == null || elementAttributes.getAttribute(HTML.Attribute.TYPE).equals("disc")) && elementAttributes.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.UL) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (elementAttributes.getAttribute(HTML.Attribute.DIR) != null && elementAttributes.getAttribute(HTML.Attribute.DIR).toString().equalsIgnoreCase("rtl")) {
                int y = this.getCorrectOffset(index, alloc);
                if (this.getView(index).getAttributes().getAttribute(CSS.Attribute.DISPLAY) == null || !this.getView(index).getAttributes().getAttribute(CSS.Attribute.DISPLAY).toString().equalsIgnoreCase("inline")) {
                    this.listPainter.paint(g, alloc.x + alloc.width, y, alloc.width, alloc.height, this, index);
                }
            } else {
                boolean isSqare;
                int y = this.getCorrectOffset(index, alloc);
                boolean bl = isSqare = this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE) != null && this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE).toString().equalsIgnoreCase("square");
                if (isSqare) {
                    this.paintSquare(g, index, alloc, y);
                } else if (this.getView(index).getAttributes().getAttribute(CSS.Attribute.DISPLAY) == null || !this.getView(index).getAttributes().getAttribute(CSS.Attribute.DISPLAY).toString().equalsIgnoreCase("inline")) {
                    if ((elementAttributes.getAttribute(HTML.Attribute.TYPE) == null || elementAttributes.getAttribute(HTML.Attribute.TYPE).equals("disc")) && elementAttributes.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.UL) {
                        if (this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE) != null && this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE).toString().equalsIgnoreCase("disc") && this.getContainer() != null && this.getContainer().getComponentOrientation() != ComponentOrientation.RIGHT_TO_LEFT) {
                            if (this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_IMAGE) == null && this.getView(index).getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_IMAGE) == null) {
                                if (!(this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE) != null && this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE).toString() != null && this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE).toString().indexOf("none") != -1 || this.getView(index).getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE) != null && this.getView(index).getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE).toString() != null && this.getView(index).getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE).toString().indexOf("none") != -1 || this.getView(index).getAttributes().getAttribute(CSS.Attribute.DISPLAY) != null && this.getView(index).getAttributes().getAttribute(CSS.Attribute.DISPLAY).toString().equalsIgnoreCase("inline") || this.getAttributes().getAttribute(CSS.Attribute.DISPLAY) != null && this.getAttributes().getAttribute(CSS.Attribute.DISPLAY).toString().equalsIgnoreCase("inline") || SferyxUtilities.isFloatLeftView(this.getView(index), this.getStyleSheet()) || SferyxUtilities.isFloatRightView(this.getView(index), this.getStyleSheet()))) {
                                    this.paintBullet(g, index, alloc, y);
                                }
                            } else if (this.getView(index).getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_IMAGE) != null) {
                                this.paintImage(g, index, alloc, y, this.getView(index).getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_IMAGE).toString());
                            } else {
                                this.listPainter.paint(g, alloc.x, y, alloc.width, alloc.height, this, index);
                            }
                        } else if (this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE) != null && this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE).toString().equalsIgnoreCase("circle") && this.getContainer() != null && this.getContainer().getComponentOrientation() != ComponentOrientation.RIGHT_TO_LEFT) {
                            this.paintCircle(g, index, alloc, y);
                        } else {
                            this.listPainter.paint(g, alloc.x, y, alloc.width, alloc.height, this, index);
                        }
                    } else if (!(this.getView(index).getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE) != null && this.getView(index).getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE).toString() != null && this.getView(index).getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE).toString().indexOf("none") != -1 || this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE) != null && this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE).toString() != null && this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE).toString().indexOf("none") != -1)) {
                        this.listPainter.paint(g, alloc.x, y, alloc.width, alloc.height, this, index);
                    }
                }
            }
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        } else if ((elementAttributes.getAttribute(HTML.Attribute.TYPE) == null || elementAttributes.getAttribute(HTML.Attribute.TYPE).equals("circle")) && elementAttributes.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.UL && this.getContainer().getComponentOrientation() != ComponentOrientation.RIGHT_TO_LEFT) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int y = this.getCorrectOffset(index, alloc);
            this.paintCircle(g, index, alloc, y);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        } else if (elementAttributes.getAttribute(HTML.Attribute.DIR) != null && elementAttributes.getAttribute(HTML.Attribute.DIR).toString().equalsIgnoreCase("rtl")) {
            int y = this.getCorrectOffset(index, alloc);
            this.listPainter.paint(g, alloc.x + alloc.width, y, alloc.width, alloc.height, this, index);
        } else {
            boolean isSqare;
            int y = this.getCorrectOffset(index, alloc);
            boolean bl = isSqare = elementAttributes.getAttribute(HTML.Attribute.TYPE) != null && elementAttributes.getAttribute(HTML.Attribute.TYPE).toString().equalsIgnoreCase("square") && elementAttributes.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.UL;
            if (!isSqare) {
                boolean bl2 = isSqare = this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE) != null && this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE).toString().equalsIgnoreCase("square");
            }
            if (!isSqare || this.getContainer() != null && this.getContainer().getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                this.listPainter.paint(g, alloc.x, y, alloc.width, alloc.height, this, index);
            } else {
                this.paintSquare(g, index, alloc, y);
            }
        }
    }

    protected void paintChild(Graphics g, Rectangle alloc, int index) {
        AttributeSet elementAttributes = this.getElement().getAttributes();
        if ((elementAttributes.getAttribute(HTML.Attribute.TYPE) == null || elementAttributes.getAttribute(HTML.Attribute.TYPE).equals("disc")) && elementAttributes.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.UL) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (elementAttributes.getAttribute(HTML.Attribute.DIR) != null && elementAttributes.getAttribute(HTML.Attribute.DIR).toString().equalsIgnoreCase("rtl")) {
                int y = this.getCorrectOffset(index, alloc);
                if (this.getView(index).getAttributes().getAttribute(CSS.Attribute.DISPLAY) == null || !this.getView(index).getAttributes().getAttribute(CSS.Attribute.DISPLAY).toString().equalsIgnoreCase("inline")) {
                    this.listPainter.paint(g, alloc.x + alloc.width, y, alloc.width, alloc.height, this, index);
                }
            } else {
                boolean isSqare;
                int y = this.getCorrectOffset(index, alloc);
                boolean bl = isSqare = this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE) != null && this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE).toString().equalsIgnoreCase("square");
                if (isSqare) {
                    this.paintSquare(g, index, alloc, y);
                } else if (this.getView(index).getAttributes().getAttribute(CSS.Attribute.DISPLAY) == null || !this.getView(index).getAttributes().getAttribute(CSS.Attribute.DISPLAY).toString().equalsIgnoreCase("inline")) {
                    if ((elementAttributes.getAttribute(HTML.Attribute.TYPE) == null || elementAttributes.getAttribute(HTML.Attribute.TYPE).equals("disc")) && elementAttributes.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.UL) {
                        if (this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE) != null && this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE).toString().equalsIgnoreCase("disc") && this.getContainer() != null && this.getContainer().getComponentOrientation() != ComponentOrientation.RIGHT_TO_LEFT) {
                            if (this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_IMAGE) == null && this.getView(index).getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_IMAGE) == null) {
                                if (!(this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE) != null && this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE).toString() != null && this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE).toString().indexOf("none") != -1 || this.getView(index).getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE) != null && this.getView(index).getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE).toString() != null && this.getView(index).getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE).toString().indexOf("none") != -1 || this.getView(index).getAttributes().getAttribute(CSS.Attribute.DISPLAY) != null && this.getView(index).getAttributes().getAttribute(CSS.Attribute.DISPLAY).toString().equalsIgnoreCase("inline") || this.getAttributes().getAttribute(CSS.Attribute.DISPLAY) != null && this.getAttributes().getAttribute(CSS.Attribute.DISPLAY).toString().equalsIgnoreCase("inline") || SferyxUtilities.isFloatLeftView(this.getView(index), this.getStyleSheet()) || SferyxUtilities.isFloatRightView(this.getView(index), this.getStyleSheet()))) {
                                    this.paintBullet(g, index, alloc, y);
                                }
                            } else if (this.getView(index).getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_IMAGE) != null) {
                                this.paintImage(g, index, alloc, y, this.getView(index).getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_IMAGE).toString());
                            } else {
                                this.listPainter.paint(g, alloc.x, y, alloc.width, alloc.height, this, index);
                            }
                        } else if (this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE) != null && this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE).toString().equalsIgnoreCase("circle") && this.getContainer() != null && this.getContainer().getComponentOrientation() != ComponentOrientation.RIGHT_TO_LEFT) {
                            this.paintCircle(g, index, alloc, y);
                        } else {
                            this.listPainter.paint(g, alloc.x, y, alloc.width, alloc.height, this, index);
                        }
                    } else if (!(this.getView(index).getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE) != null && this.getView(index).getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE).toString() != null && this.getView(index).getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE).toString().indexOf("none") != -1 || this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE) != null && this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE).toString() != null && this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE).toString().indexOf("none") != -1)) {
                        this.listPainter.paint(g, alloc.x, y, alloc.width, alloc.height, this, index);
                    }
                }
            }
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        } else if ((elementAttributes.getAttribute(HTML.Attribute.TYPE) == null || elementAttributes.getAttribute(HTML.Attribute.TYPE).equals("circle")) && elementAttributes.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.UL && this.getContainer().getComponentOrientation() != ComponentOrientation.RIGHT_TO_LEFT) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int y = this.getCorrectOffset(index, alloc);
            this.paintCircle(g, index, alloc, y);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        } else if (elementAttributes.getAttribute(HTML.Attribute.DIR) != null && elementAttributes.getAttribute(HTML.Attribute.DIR).toString().equalsIgnoreCase("rtl")) {
            int y = this.getCorrectOffset(index, alloc);
            this.listPainter.paint(g, alloc.x + alloc.width, y, alloc.width, alloc.height, this, index);
        } else {
            boolean isSqare;
            int y = this.getCorrectOffset(index, alloc);
            boolean bl = isSqare = elementAttributes.getAttribute(HTML.Attribute.TYPE) != null && elementAttributes.getAttribute(HTML.Attribute.TYPE).toString().equalsIgnoreCase("square") && elementAttributes.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.UL;
            if (!isSqare) {
                boolean bl2 = isSqare = this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE) != null && this.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE).toString().equalsIgnoreCase("square");
            }
            if (!isSqare || this.getContainer() != null && this.getContainer().getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                this.listPainter.paint(g, alloc.x, y, alloc.width, alloc.height, this, index);
            } else {
                this.paintSquare(g, index, alloc, y);
            }
        }
        super.paintChild(g, alloc, index);
    }

    void paintSquare(Graphics g, int index, Rectangle alloc, int y) {
        View cv = this.getView(index);
        AttributeSet elementAttributes = cv.getElement().getAttributes();
        Object name = elementAttributes.getAttribute(StyleConstants.NameAttribute);
        if (name == HTML.Tag.LI) {
            Shape shape;
            View pView;
            Object cName;
            int new_x = alloc.x;
            int new_y = y;
            int new_h = alloc.height;
            float align = 0.0f;
            if (cv.getViewCount() > 0 && ((cName = (pView = cv.getView(0)).getElement().getAttributes().getAttribute(StyleConstants.NameAttribute)) == HTML.Tag.P || cName == HTML.Tag.IMPLIED) && pView.getViewCount() > 0 && (shape = cv.getChildAllocation(0, alloc)) != null && (shape = pView.getView(0).getChildAllocation(0, shape)) != null) {
                Rectangle rect_ = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                align = pView.getView(0).getAlignment(1);
                new_y = rect_.y;
                new_h = rect_.height;
            }
            int squareSize = 5;
            new_y = Math.max(new_y, new_y + (int)(align * (float)new_h) - squareSize);
            new_x = new_x - squareSize - 5;
            String color = null;
            AttributeSet attribs = this.getAttributes();
            if (attribs.getAttribute(CSS.Attribute.COLOR) != null && attribs.isDefined(CSS.Attribute.COLOR)) {
                color = attribs.getAttribute(CSS.Attribute.COLOR).toString();
                Color colorValue = this.getStyleSheet().stringToColor(color);
                if (colorValue != null) {
                    g.setColor(colorValue);
                }
            }
            if (color == null) {
                if (StyleConstants.getForeground(this.getAttributes()) != null) {
                    g.setColor(StyleConstants.getForeground(this.getAttributes()));
                } else {
                    g.setColor(Color.black);
                }
            }
            g.fillRect(new_x, new_y - 2, squareSize, squareSize);
        }
    }

    void paintImage(Graphics g, int index, Rectangle alloc, int y, String imageValue) {
        try {
            URL url = new URL(((EditorHTMLDocument)this.getElement().getDocument()).getStyleSheet().getBase(), SferyxUtilities.convertStyleDeclarationtoURL(imageValue));
            ImageIcon image = new ImageIcon(url);
            View cv = this.getView(index);
            Object name = cv.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (name == HTML.Tag.LI) {
                Shape shape;
                View pView;
                Object cName;
                int new_x = alloc.x;
                int new_y = y;
                int new_h = alloc.height;
                float align = 0.0f;
                if (cv.getViewCount() > 0 && ((cName = (pView = cv.getView(0)).getElement().getAttributes().getAttribute(StyleConstants.NameAttribute)) == HTML.Tag.P || cName == HTML.Tag.IMPLIED) && pView.getViewCount() > 0 && (shape = cv.getChildAllocation(0, alloc)) != null && (shape = pView.getView(0).getChildAllocation(0, shape)) != null) {
                    Rectangle rect_ = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                    align = pView.getView(0).getAlignment(1);
                    new_y = rect_.y;
                    new_h = rect_.height;
                }
                int squareSize = image.getImage().getWidth(this.getContainer());
                new_y = Math.max(new_y, new_y + (int)(align * (float)new_h) - squareSize);
                new_x = new_x - squareSize - 5;
                g.drawImage(image.getImage(), new_x, new_y - 2, this.getContainer());
            }
        }
        catch (Throwable thr) {
            // empty catch block
        }
    }

    void paintBullet(Graphics g, int index, Rectangle alloc, int y) {
        View cv = this.getView(index);
        Object name = cv.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (name == HTML.Tag.LI) {
            Shape shape;
            View pView;
            Object cName;
            int new_x = alloc.x;
            int new_y = y;
            int new_h = alloc.height;
            float align = 0.0f;
            if (cv.getViewCount() > 0 && ((cName = (pView = cv.getView(0)).getElement().getAttributes().getAttribute(StyleConstants.NameAttribute)) == HTML.Tag.P || cName == HTML.Tag.IMPLIED) && pView.getViewCount() > 0 && (shape = cv.getChildAllocation(0, alloc)) != null && (shape = pView.getView(0).getChildAllocation(0, shape)) != null) {
                Rectangle rect_ = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                align = pView.getView(0).getAlignment(1);
                new_y = rect_.y;
                new_h = rect_.height;
            }
            int squareSize = 5;
            new_y = Math.max(new_y, new_y + (int)(align * (float)new_h) - squareSize);
            new_x = new_x - squareSize - 5;
            String color = null;
            AttributeSet attribs = this.getAttributes();
            if (attribs.getAttribute(CSS.Attribute.COLOR) != null && attribs.isDefined(CSS.Attribute.COLOR)) {
                color = attribs.getAttribute(CSS.Attribute.COLOR).toString();
                Color colorValue = this.getStyleSheet().stringToColor(color);
                if (colorValue != null) {
                    g.setColor(colorValue);
                }
            }
            if (color == null) {
                if (StyleConstants.getForeground(this.getAttributes()) != null) {
                    g.setColor(StyleConstants.getForeground(this.getAttributes()));
                } else {
                    g.setColor(Color.black);
                }
            }
            g.fillOval(new_x, new_y - 2, squareSize, squareSize);
        }
    }

    void paintCircle(Graphics g, int index, Rectangle alloc, int y) {
        View cv = this.getView(index);
        Object name = cv.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (name == HTML.Tag.LI) {
            Shape shape;
            View pView;
            Object cName;
            int new_x = alloc.x;
            int new_y = y;
            int new_h = alloc.height;
            float align = 0.0f;
            if (cv.getViewCount() > 0 && ((cName = (pView = cv.getView(0)).getElement().getAttributes().getAttribute(StyleConstants.NameAttribute)) == HTML.Tag.P || cName == HTML.Tag.IMPLIED) && pView.getViewCount() > 0 && (shape = cv.getChildAllocation(0, alloc)) != null && (shape = pView.getView(0).getChildAllocation(0, shape)) != null) {
                Rectangle rect_ = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                align = pView.getView(0).getAlignment(1);
                new_y = rect_.y;
                new_h = rect_.height;
            }
            int squareSize = 5;
            new_y = Math.max(new_y, new_y + (int)(align * (float)new_h) - squareSize);
            new_x = new_x - squareSize - 5;
            String color = null;
            AttributeSet attribs = this.getAttributes();
            if (attribs.getAttribute(CSS.Attribute.COLOR) != null && attribs.isDefined(CSS.Attribute.COLOR)) {
                color = attribs.getAttribute(CSS.Attribute.COLOR).toString();
                Color colorValue = this.getStyleSheet().stringToColor(color);
                if (colorValue != null) {
                    g.setColor(colorValue);
                }
            }
            if (color == null) {
                if (StyleConstants.getForeground(this.getAttributes()) != null) {
                    g.setColor(StyleConstants.getForeground(this.getAttributes()));
                } else {
                    g.setColor(Color.black);
                }
            }
            g.drawOval(new_x, new_y - 2, squareSize, squareSize);
        }
    }

    int getCorrectOffset(int index, Rectangle alloc) {
        int y = alloc.y;
        View child = this.getView(index);
        int stringheight = 0;
        Font font = new Font("Serif", 0, 12);
        if (font != null) {
            FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
            stringheight = fm.getAscent();
        }
        if (child.getViewCount() > 0 && child.getView(0) instanceof CustomParagraphView) {
            int top = ((CustomParagraphView)child.getView(0)).getTopMargin();
            View paragraphView = child.getView(0);
            Rectangle paragraphAlloc = (Rectangle)child.getChildAllocation(0, alloc);
            if (paragraphView.getViewCount() > 0) {
                View firstRowView = paragraphView.getView(0);
                Rectangle firstRowAlloc = (Rectangle)paragraphView.getChildAllocation(0, paragraphAlloc);
                Object cName = paragraphView.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
                if (cName == HTML.Tag.P || cName == HTML.Tag.IMPLIED) {
                    y = alloc.y + top;
                } else if (firstRowAlloc.height > stringheight) {
                    int total = firstRowAlloc.y + firstRowAlloc.height / 2 - stringheight / 2;
                    y = Math.min(total, alloc.y + alloc.height);
                } else {
                    y = firstRowAlloc.y;
                }
            }
        }
        return y;
    }

    protected void setPropertiesFromAttributes() {
        super.setPropertiesFromAttributes();
        this.listPainter = this.getStyleSheet().getListPainter(this.getAttributes());
    }
}

