/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JViewport;
import javax.swing.SizeRequirements;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.BlockView;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import sferyx.administration.editors.AlternativeCSSAttribute;
import sferyx.administration.editors.CSSLayoutViews;
import sferyx.administration.editors.CustomBlockView;
import sferyx.administration.editors.CustomBoxPainter;
import sferyx.administration.editors.CustomEditorPane;
import sferyx.administration.editors.CustomFrameSetView;
import sferyx.administration.editors.CustomParagraphView;
import sferyx.administration.editors.CustomTableCelView;
import sferyx.administration.editors.CustomTableRowView;
import sferyx.administration.editors.EditorHTMLDocument;
import sferyx.administration.editors.SferyxUtilities;
import sferyx.administration.editors.TableView;

public class CustomLayoutBoxView
extends BlockView
implements CSSLayoutViews {
    boolean loading = false;
    boolean valid = false;
    boolean forceChange = false;
    AttributeSet attribs;
    StyleSheet sheet_;
    boolean changed = false;
    boolean margin_right_em = false;
    boolean margin_left_em = false;
    int rightAlignedImageOffset = 0;
    int leftAlignedImageOffset = 0;
    int initialOffset_X = 0;
    int initialOffset_Y = 0;
    int upperViewsOffset_Y = 0;
    boolean containsAlignedImages;
    Rectangle insideAlloc = new Rectangle();
    int indexDown = -1;
    int[] offsets_X = new int[0];
    int[] offsets_Y = new int[0];
    int[] spans_X = new int[0];
    int[] spans_Y = new int[0];
    int targetSpan_X = 0;
    int targetSpan_Y = 0;
    Rectangle toIndexRect = new Rectangle();
    Rectangle rect = new Rectangle();
    boolean forceSizeUpdate = false;
    int alignedLeftViewsSpan = 0;
    int alignedRightViewsSpan = 0;
    int alignedNormalViewsSpan = 0;
    Rectangle tempRect = new Rectangle();
    boolean revealBlockViews = false;
    CustomBoxPainter boxPainter;
    Rectangle myAllocation;
    static Font tagsFont = new Font("Arial", 1, 11);
    boolean removeUpdateNeeded = false;
    float currWidth = 0.0f;
    float currHeight = 0.0f;
    Object cssWidth;
    Object cssHeight;

    public CustomLayoutBoxView(Element elem, int axis) {
        super(elem, axis);
        if (((EditorHTMLDocument)elem.getDocument()).loading) {
            this.loading = true;
            ((EditorHTMLDocument)elem.getDocument()).loading = false;
        }
    }

    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.changedUpdate(e, a, f);
        this.forceChange = true;
    }

    public AttributeSet getAttributes() {
        this.sheet_ = this.getStyleSheet();
        if (this.attribs == null) {
            this.attribs = this.sheet_.getViewAttributes(this);
        }
        if (this.forceChange) {
            if (!SferyxUtilities.matchNameAttribute(this.getElement(), HTML.Tag.HTML)) {
                this.attribs = this.sheet_.getViewAttributes(this);
            }
            this.forceChange = false;
        }
        return this.attribs;
    }

    public StyleSheet getStyleSheet() {
        return super.getStyleSheet();
    }

    public View getView(int n) {
        if (n < 0) {
            return null;
        }
        return super.getView(n);
    }

    public int getOffset(int axis, int childIndex) {
        if (axis == 0 && this.offsets_X != null && childIndex < this.offsets_X.length && childIndex >= 0) {
            return this.offsets_X[childIndex];
        }
        if (this.offsets_Y != null && childIndex < this.offsets_Y.length && childIndex >= 0) {
            return this.offsets_Y[childIndex];
        }
        if (childIndex < 0) {
            return 0;
        }
        try {
            return super.getOffset(axis, childIndex);
        }
        catch (Throwable thr) {
            return 0;
        }
    }

    public int getSpan(int axis, int childIndex) {
        if (axis == 0 && this.spans_X != null && childIndex < this.spans_X.length && childIndex >= 0) {
            return this.spans_X[childIndex];
        }
        if (this.spans_Y != null && childIndex < this.spans_Y.length && childIndex >= 0) {
            return this.spans_Y[childIndex];
        }
        if (childIndex < 0) {
            return 0;
        }
        return super.getSpan(axis, childIndex);
    }

    public int getRightMargin() {
        return SferyxUtilities.getRightMargin(this);
    }

    public int getLeftMargin() {
        return SferyxUtilities.getLeftMargin(this);
    }

    public int getTopMargin() {
        return SferyxUtilities.getTopMargin(this);
    }

    public int getBottomMargin() {
        return SferyxUtilities.getBottomMargin(this);
    }

    public int getRightPadding() {
        return SferyxUtilities.getRightPadding(this) + SferyxUtilities.getCellRightBorderSize(this.getAttributes(), this.getElement());
    }

    public int getLeftPadding() {
        return SferyxUtilities.getLeftPadding(this) + SferyxUtilities.getCellLeftBorderSize(this.getAttributes(), this.getElement());
    }

    public int getTopPadding() {
        return SferyxUtilities.getTopPadding(this) + SferyxUtilities.getCellTopBorderSize(this.getAttributes(), this.getElement());
    }

    public int getBottomPadding() {
        return SferyxUtilities.getBottomPadding(this) + SferyxUtilities.getCellBottomBorderSize(this.getAttributes(), this.getElement());
    }

    public int getLeftRightBorderInset() {
        AttributeSet viewAttributes = this.getAttributes();
        return SferyxUtilities.getCellLeftBorderSize(viewAttributes, this.getElement()) + SferyxUtilities.getCellRightBorderSize(viewAttributes, this.getElement());
    }

    public int getTopBottomBorderInset() {
        AttributeSet viewAttributes = this.getAttributes();
        return SferyxUtilities.getCellTopBorderSize(viewAttributes, this.getElement()) + SferyxUtilities.getCellBottomBorderSize(viewAttributes, this.getElement());
    }

    public short getLeftInset() {
        return (short)this.getLeftPadding();
    }

    public short getRightInset() {
        return (short)this.getRightPadding();
    }

    public short getTopInset() {
        return (short)this.getTopPadding();
    }

    public short getBottomInset() {
        return (short)this.getBottomPadding();
    }

    public void setInsets(short top, short left, short bottom, short right) {
        super.setInsets(top, left, bottom, right);
    }

    public int getMyIndex() {
        View parentView = this.getParent();
        int n = parentView.getViewCount();
        for (int i = 0; i < n; ++i) {
            View currView = parentView.getView(i);
            if (currView != this) continue;
            return i;
        }
        return -1;
    }

    void adjustFloatPositionsForView(int width, View view, int i) {
        if (i == 0) {
            return;
        }
        Rectangle currentRect = new Rectangle();
        currentRect.x = this.offsets_X[i];
        currentRect.y = this.offsets_Y[i];
        currentRect.width = this.spans_X[i];
        currentRect.height = this.spans_Y[i];
        if (view instanceof CSSLayoutViews) {
            // empty if block
        }
        if (!(view instanceof CSSLayoutViews) || !((CSSLayoutViews)((Object)view)).isAbsolutePositioning()) {
            // empty if block
        }
        if (SferyxUtilities.isFloatRightView(view, this.getStyleSheet())) {
            currentRect.x = width - currentRect.width;
            boolean update = true;
            block0: while (update) {
                for (int j = 0; j < i; ++j) {
                    View previousView = this.getView(j);
                    Rectangle prevRect = new Rectangle(this.offsets_X[j], this.offsets_Y[j], this.spans_X[j], this.spans_Y[j]);
                    if (view instanceof CSSLayoutViews) {
                        // empty if block
                    }
                    if (prevRect.intersects(currentRect) || currentRect.contains(prevRect) || prevRect.contains(currentRect)) {
                        if (currentRect.x - prevRect.width > 0) {
                            currentRect.x -= prevRect.width;
                            update = true;
                            continue block0;
                        }
                        currentRect.y += prevRect.height;
                        currentRect.x = width - currentRect.width;
                        update = true;
                        continue block0;
                    }
                    update = false;
                }
            }
            this.offsets_X[i] = currentRect.x;
            this.offsets_Y[i] = currentRect.y;
        } else {
            currentRect.x = 0;
            boolean update = true;
            block2: while (update) {
                for (int j = 0; j < i; ++j) {
                    View previousView = this.getView(j);
                    Rectangle prevRect = new Rectangle(this.offsets_X[j], this.offsets_Y[j], this.spans_X[j], this.spans_Y[j]);
                    if (view instanceof CSSLayoutViews) {
                        // empty if block
                    }
                    if (prevRect.intersects(currentRect) || currentRect.contains(prevRect) || prevRect.contains(currentRect)) {
                        if (prevRect.x + currentRect.width + prevRect.width <= width) {
                            currentRect.x = prevRect.x + prevRect.width;
                            update = true;
                            continue block2;
                        }
                        currentRect.y += prevRect.height;
                        currentRect.x = 0;
                        update = true;
                        continue block2;
                    }
                    update = false;
                }
            }
            this.offsets_X[i] = currentRect.x;
            this.offsets_Y[i] = currentRect.y;
        }
    }

    void adjustFloatPositions(int width) {
        Rectangle currentRect = new Rectangle();
        boolean rightSpan = false;
        for (int i = 1; i < this.getViewCount(); ++i) {
            Rectangle prevRect;
            View previousView;
            int j;
            boolean update;
            View view = this.getView(i);
            currentRect.x = this.offsets_X[i];
            currentRect.y = this.offsets_Y[i];
            currentRect.width = this.spans_X[i];
            currentRect.height = this.spans_Y[i];
            if (view instanceof CSSLayoutViews) {
                // empty if block
            }
            if (!(view instanceof CSSLayoutViews) || !((CSSLayoutViews)((Object)view)).isAbsolutePositioning()) {
                // empty if block
            }
            if (SferyxUtilities.isFloatRightView(view, this.getStyleSheet())) {
                currentRect.x = width - currentRect.width;
                update = true;
                block1: while (update) {
                    for (j = 0; j < i; ++j) {
                        previousView = this.getView(j);
                        prevRect = new Rectangle(this.offsets_X[j], this.offsets_Y[j], this.spans_X[j], this.spans_Y[j]);
                        if (view instanceof CSSLayoutViews) {
                            // empty if block
                        }
                        if (SferyxUtilities.isFloatRightView(previousView, this.getStyleSheet()) && (prevRect.intersects(currentRect) || currentRect.contains(prevRect) || prevRect.contains(currentRect))) {
                            if (currentRect.x - prevRect.width > 0) {
                                currentRect.x -= prevRect.width;
                                update = true;
                                continue block1;
                            }
                            currentRect.y += prevRect.height;
                            currentRect.x = width - currentRect.width;
                            update = true;
                            continue block1;
                        }
                        update = false;
                    }
                }
                this.offsets_X[i] = currentRect.x;
                this.offsets_Y[i] = currentRect.y;
                continue;
            }
            currentRect.x = 0;
            update = true;
            block3: while (update) {
                for (j = 0; j < i; ++j) {
                    previousView = this.getView(j);
                    prevRect = new Rectangle(this.offsets_X[j], this.offsets_Y[j], this.spans_X[j], this.spans_Y[j]);
                    if (view instanceof CSSLayoutViews) {
                        // empty if block
                    }
                    if (SferyxUtilities.isFloatLeftView(previousView, this.getStyleSheet()) && (prevRect.intersects(currentRect) || currentRect.contains(prevRect) || prevRect.contains(currentRect))) {
                        if (prevRect.x + currentRect.width + prevRect.width <= width) {
                            currentRect.x = prevRect.x + prevRect.width;
                            update = true;
                            continue block3;
                        }
                        currentRect.y += prevRect.height;
                        currentRect.x = 0;
                        update = true;
                        continue block3;
                    }
                    update = false;
                }
            }
            this.offsets_X[i] = currentRect.x;
            this.offsets_Y[i] = currentRect.y;
        }
    }

    private void safePreferenceChanged() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.preferenceChanged(null, true, true);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CustomLayoutBoxView.this.preferenceChanged(null, true, true);
                }
            });
        }
    }

    protected void loadChildren_(ViewFactory f) {
        if (f == null) {
            return;
        }
        Element e = this.getElement();
        int n = e.getElementCount();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                View[] added = new View[]{f.create(e.getElement(i))};
                if (i < 10) {
                    this.replace(i, 0, added);
                    if (i != this.getElement().getElementCount() - 1 || !this.loading) continue;
                    this.loading = false;
                    continue;
                }
                this.replace_(i, 0, added);
            }
        }
    }

    protected void replace_(final int i, final int e, final View[] added) {
        Runnable docUpdate = new Runnable(){

            public void run() {
                CustomLayoutBoxView.this.replace(i, e, added);
                if (i == CustomLayoutBoxView.this.getElement().getElementCount() - 1 && CustomLayoutBoxView.this.loading) {
                    CustomLayoutBoxView.this.loading = false;
                }
            }
        };
        SwingUtilities.invokeLater(docUpdate);
    }

    protected void loadChildren(ViewFactory f) {
        if (!this.loading) {
            super.loadChildren(f);
            return;
        }
        final ViewFactory fac = f;
        Runnable docUpdate1 = new Runnable(){

            public void run() {
                CustomLayoutBoxView.this.loadChildren_(fac);
            }
        };
        SwingUtilities.invokeLater(docUpdate1);
    }

    protected Rectangle getInsideAllocation(Shape a) {
        if (a != null) {
            Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            this.insideAlloc.setBounds(alloc);
            this.insideAlloc.x += this.getLeftInset();
            this.insideAlloc.y += this.getTopInset();
            this.insideAlloc.width -= this.getLeftInset() + this.getRightInset();
            this.insideAlloc.height -= this.getTopInset() + this.getBottomInset();
            return this.insideAlloc;
        }
        return null;
    }

    int getAdjustedRightSpan(int i, int rightSpan, int targetSpan, int[] spans) {
        int correctOfset = rightSpan;
        for (int j = i; j >= 0; --j) {
            View previousView = SferyxUtilities.getPreviousLayoutView(j, this);
            if (previousView == null || !SferyxUtilities.isFloatRightView(previousView, this.getStyleSheet())) continue;
            if (correctOfset + spans[i] < targetSpan) break;
            int index = SferyxUtilities.indexOfView(previousView);
            correctOfset -= spans[index];
        }
        return correctOfset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        if (this.getContainer() != null && this.getElement().getName().equals("body") && ((CustomEditorPane)this.getContainer()).scale > 1.0) {
            targetSpan = (int)((double)targetSpan / ((CustomEditorPane)this.getContainer()).scale);
        }
        this.containsAlignedImages = false;
        int alignedLeftViewsSpan_X = 0;
        int alignedRightViewsSpan_X = 0;
        boolean alignedLeftViewsSpan_Y = false;
        boolean alignedRightViewsSpan_Y = false;
        int previousLeftOffset = 0;
        boolean containsFloat = false;
        try {
            for (int i = 0; i < offsets.length; ++i) {
                int min;
                AttributeSet viewAttributes;
                View prevLayoutView;
                View view;
                block90: {
                    block95: {
                        block94: {
                            block93: {
                                block91: {
                                    block92: {
                                        int rightMargin;
                                        View previousView;
                                        view = this.getView(i);
                                        if (SferyxUtilities.isItACommentView(view)) {
                                            offsets[i] = 0;
                                            spans[i] = 0;
                                            continue;
                                        }
                                        prevLayoutView = SferyxUtilities.getPreviousLayoutView(view);
                                        viewAttributes = view.getAttributes();
                                        min = (int)view.getMinimumSpan(axis);
                                        int max = (int)view.getMaximumSpan(axis);
                                        AttributeSet a = viewAttributes;
                                        Object value = a.getAttribute(CSS.Attribute.WIDTH);
                                        if (value != null && value.toString().trim().endsWith("%")) {
                                            float nV = Float.parseFloat(value.toString().trim().substring(0, value.toString().trim().indexOf("%")));
                                            max = min = Math.max((int)(nV / 100.0f * (float)targetSpan), min);
                                        }
                                        if (max < targetSpan) {
                                            float align = view.getAlignment(axis);
                                            offsets[i] = (int)((float)(targetSpan - max) * align);
                                            spans[i] = max;
                                        } else {
                                            offsets[i] = 0;
                                            spans[i] = Math.max(min, targetSpan);
                                        }
                                        if (view instanceof CustomFrameSetView) {
                                            offsets[i] = 0;
                                            spans[i] = targetSpan;
                                        }
                                        if (SferyxUtilities.isFloatLeftView(view, this.getStyleSheet()) || SferyxUtilities.isFloatRightView(view, this.getStyleSheet())) {
                                            containsFloat = true;
                                        }
                                        if (SferyxUtilities.isViewNotVisible(view, this.getStyleSheet())) {
                                            offsets[i] = 0;
                                            spans[i] = 0;
                                            continue;
                                        }
                                        if (view instanceof CSSLayoutViews && ((CSSLayoutViews)((Object)view)).isAbsolutePositioning()) {
                                            if (!SferyxUtilities.isDefinedAbsoluteX(view)) continue;
                                            offsets[i] = ((CSSLayoutViews)((Object)view)).getAbsoluteX() - this.getLeftPadding();
                                            continue;
                                        }
                                        offsets[i] = alignedLeftViewsSpan_X;
                                        if (this.getContainer() != null && ((CustomEditorPane)this.getContainer()).isWrapParagraphLinesAlwaysOnEditorSize() && offsets[i] + spans[i] >= targetSpan) {
                                            spans[i] = targetSpan - offsets[i];
                                        }
                                        if (!containsFloat) break block90;
                                        if (!SferyxUtilities.isFloatLeftView(view, this.getStyleSheet())) break block91;
                                        if (i > 0 && prevLayoutView != null && !SferyxUtilities.isFloatRightView(prevLayoutView, this.getStyleSheet()) && (previousView = prevLayoutView) instanceof CSSLayoutViews && alignedLeftViewsSpan_X > 0 && offsets[i] + spans[i] + (rightMargin = ((CSSLayoutViews)((Object)previousView)).getRightMargin()) <= targetSpan) {
                                            offsets[i] = offsets[i] + rightMargin;
                                            alignedLeftViewsSpan_X += rightMargin;
                                        }
                                        if (!(offsets[i] + spans[i] <= targetSpan || SferyxUtilities.isClearLeftView(this.getView(i), this.getStyleSheet()) || SferyxUtilities.isClearBothView(this.getView(i), this.getStyleSheet()) || targetSpan - offsets[i] < min || i <= 0 || prevLayoutView == null || SferyxUtilities.isClearRightView(prevLayoutView, this.getStyleSheet()) || SferyxUtilities.isClearBothView(prevLayoutView, this.getStyleSheet()) || min == 0)) {
                                            spans[i] = targetSpan - offsets[i];
                                        }
                                        if ((alignedLeftViewsSpan_X += spans[i]) != targetSpan) break block92;
                                        offsets[i] = alignedLeftViewsSpan_X - spans[i];
                                        alignedLeftViewsSpan_X = 0;
                                        break block90;
                                    }
                                    if (alignedLeftViewsSpan_X > targetSpan) {
                                        try {
                                            int correctOffset;
                                            alignedLeftViewsSpan_X = correctOffset = this.getCorrectOffset(this.indexDown, i, spans, offsets, spans[i], targetSpan);
                                        }
                                        catch (Throwable thr) {
                                            thr.printStackTrace();
                                        }
                                        offsets[i] = alignedLeftViewsSpan_X;
                                        this.indexDown = i;
                                        alignedLeftViewsSpan_X += spans[i];
                                    }
                                    break block90;
                                }
                                if (!SferyxUtilities.isFloatRightView(view, this.getStyleSheet())) break block93;
                                if (alignedRightViewsSpan_X + this.alignedNormalViewsSpan + alignedLeftViewsSpan_X >= targetSpan) {
                                    // empty if block
                                }
                                if (i > 0) {
                                    if (prevLayoutView != null && !SferyxUtilities.isClearRightView(prevLayoutView, this.getStyleSheet())) {
                                        int newspan;
                                        if (spans[i] + alignedRightViewsSpan_X <= targetSpan) {
                                            offsets[i] = targetSpan - spans[i] - alignedRightViewsSpan_X;
                                        } else {
                                            alignedRightViewsSpan_X = this.getAdjustedRightSpan(i, alignedRightViewsSpan_X, targetSpan, spans);
                                            offsets[i] = targetSpan - spans[i] - alignedRightViewsSpan_X;
                                        }
                                        alignedRightViewsSpan_X += spans[i];
                                        int indexOfPreviousLayoutView = SferyxUtilities.indexOfView(prevLayoutView);
                                        if (offsets[indexOfPreviousLayoutView] + spans[indexOfPreviousLayoutView] >= offsets[i] && (float)(newspan = spans[indexOfPreviousLayoutView] - (offsets[indexOfPreviousLayoutView] + spans[indexOfPreviousLayoutView] - offsets[i])) >= prevLayoutView.getMinimumSpan(0)) {
                                            spans[indexOfPreviousLayoutView] = newspan;
                                        }
                                    } else {
                                        offsets[i] = targetSpan - spans[i];
                                        alignedRightViewsSpan_X = spans[i];
                                    }
                                    if (alignedRightViewsSpan_X > targetSpan) {
                                        offsets[i] = targetSpan - spans[i];
                                        alignedRightViewsSpan_X = targetSpan - spans[i];
                                    }
                                } else {
                                    offsets[i] = targetSpan - spans[i];
                                    alignedRightViewsSpan_X = spans[i];
                                }
                                if (alignedRightViewsSpan_X + alignedLeftViewsSpan_X >= targetSpan) {
                                    alignedRightViewsSpan_X = 0;
                                }
                                break block90;
                            }
                            if (i <= 0 || prevLayoutView == null || !SferyxUtilities.isFloatRightView(prevLayoutView, this.getStyleSheet())) break block94;
                            if (!SferyxUtilities.isClearRightView(view, this.getStyleSheet()) && !SferyxUtilities.isClearBothView(view, this.getStyleSheet())) {
                                if (spans[i] > targetSpan - alignedRightViewsSpan_X && spans[i] - alignedRightViewsSpan_X >= min) {
                                    spans[i] = spans[i] - alignedRightViewsSpan_X;
                                    offsets[i] = offsets[i] - alignedRightViewsSpan_X;
                                }
                                break block95;
                            } else {
                                alignedRightViewsSpan_X = 0;
                                this.alignedNormalViewsSpan = 0;
                            }
                            break block95;
                        }
                        if (i > 0 && prevLayoutView != null && SferyxUtilities.isFloatLeftView(prevLayoutView, this.getStyleSheet()) && !SferyxUtilities.isDisplayLikeInlineView(prevLayoutView, this.getStyleSheet())) {
                            if (!SferyxUtilities.isClearLeftView(view, this.getStyleSheet()) && !SferyxUtilities.isClearBothView(view, this.getStyleSheet())) {
                                View previousView = prevLayoutView;
                                if (previousView instanceof CSSLayoutViews && (this.alignedNormalViewsSpan > 0 || alignedLeftViewsSpan_X > 0)) {
                                    offsets[i] = offsets[i] + ((CSSLayoutViews)((Object)previousView)).getRightMargin();
                                    this.alignedNormalViewsSpan += ((CSSLayoutViews)((Object)previousView)).getRightMargin();
                                }
                                if (spans[i] <= targetSpan - alignedLeftViewsSpan_X - alignedRightViewsSpan_X || spans[i] - alignedLeftViewsSpan_X - alignedRightViewsSpan_X < min || view instanceof CustomParagraphView) {
                                    // empty if block
                                }
                                if (!(view instanceof CustomBlockView)) {
                                    // empty if block
                                }
                            } else {
                                alignedLeftViewsSpan_X = 0;
                                this.alignedNormalViewsSpan = 0;
                            }
                        }
                    }
                    if (prevLayoutView != null && SferyxUtilities.isDisplayLikeInlineView(prevLayoutView, this.getStyleSheet())) {
                        offsets[i] = 0;
                        alignedLeftViewsSpan_X = 0;
                    } else {
                        if (alignedRightViewsSpan_X + alignedLeftViewsSpan_X + spans[i] > targetSpan) {
                            if (targetSpan - alignedLeftViewsSpan_X - alignedRightViewsSpan_X >= min) {
                                spans[i] = targetSpan - alignedLeftViewsSpan_X - alignedRightViewsSpan_X;
                            } else {
                                offsets[i] = alignedLeftViewsSpan_X - spans[i];
                                alignedLeftViewsSpan_X = spans[i];
                                this.alignedNormalViewsSpan = spans[i];
                            }
                        }
                        previousLeftOffset = alignedLeftViewsSpan_X;
                        this.alignedNormalViewsSpan += spans[i];
                        if ((alignedLeftViewsSpan_X += spans[i]) < targetSpan) {
                            offsets[i] = alignedLeftViewsSpan_X - spans[i];
                            alignedLeftViewsSpan_X -= spans[i];
                        } else if (alignedLeftViewsSpan_X == targetSpan) {
                            offsets[i] = alignedLeftViewsSpan_X - spans[i];
                            alignedLeftViewsSpan_X = 0;
                        } else if (alignedLeftViewsSpan_X > targetSpan) {
                            offsets[i] = alignedLeftViewsSpan_X = 0;
                            this.indexDown = i;
                            alignedLeftViewsSpan_X += spans[i];
                        }
                        View previousFloatView = SferyxUtilities.getPreviousFloatView(view);
                        if (previousFloatView != null) {
                            int indexOfFloat = SferyxUtilities.indexOfView(previousFloatView);
                            if (previousFloatView.getPreferredSpan(1) > (float)SferyxUtilities.getTotalSpanBetween(i, indexOfFloat, this) && SferyxUtilities.isFloatLeftView(previousFloatView, this.getStyleSheet()) && !SferyxUtilities.isClearLeftView(view, this.getStyleSheet()) && !SferyxUtilities.isClearBothView(view, this.getStyleSheet()) && offsets[indexOfFloat] + spans[indexOfFloat] + spans[i] - offsets[indexOfFloat] - spans[indexOfFloat] <= targetSpan && (float)(spans[i] - offsets[indexOfFloat] - spans[indexOfFloat]) > view.getMinimumSpan(0)) {
                                offsets[i] = offsets[indexOfFloat] + spans[indexOfFloat];
                                if (previousFloatView instanceof CSSLayoutViews && (this.alignedNormalViewsSpan > 0 || alignedLeftViewsSpan_X > 0)) {
                                    offsets[i] = offsets[i] + ((CSSLayoutViews)((Object)previousFloatView)).getRightMargin();
                                    this.alignedNormalViewsSpan += ((CSSLayoutViews)((Object)previousFloatView)).getRightMargin();
                                }
                                if (spans[i] + offsets[indexOfFloat] + spans[indexOfFloat] > targetSpan) {
                                    spans[i] = spans[i] - offsets[indexOfFloat] - spans[indexOfFloat];
                                }
                                alignedLeftViewsSpan_X = offsets[i] + spans[i];
                                this.alignedNormalViewsSpan = offsets[i] + spans[i];
                            }
                        }
                    }
                }
                if (SferyxUtilities.isFloatLeftView(view, this.getStyleSheet()) || !SferyxUtilities.isFloatRightView(view, this.getStyleSheet())) {
                    // empty if block
                }
                AttributeSet elementAttributes = view.getElement().getAttributes();
                if (view instanceof CSSLayoutViews) {
                    block89: {
                        int leftMargin = ((CSSLayoutViews)((Object)view)).getLeftMargin();
                        try {
                            String percent = null;
                            if (viewAttributes.getAttribute(AlternativeCSSAttribute.MARGIN_LEFT) != null && viewAttributes.getAttribute(AlternativeCSSAttribute.MARGIN_LEFT).toString().indexOf("%") != -1 && elementAttributes.isDefined(AlternativeCSSAttribute.MARGIN_LEFT)) {
                                percent = viewAttributes.getAttribute(AlternativeCSSAttribute.MARGIN_LEFT).toString().trim();
                            } else if (elementAttributes.getAttribute(AlternativeCSSAttribute.MARGIN_LEFT) != null && elementAttributes.getAttribute(AlternativeCSSAttribute.MARGIN_LEFT).toString().indexOf("%") != -1 && elementAttributes.isDefined(AlternativeCSSAttribute.MARGIN_LEFT)) {
                                percent = elementAttributes.getAttribute(AlternativeCSSAttribute.MARGIN_LEFT).toString().trim();
                            }
                            if (percent != null) {
                                percent = percent.substring(0, percent.indexOf("%"));
                                int number = (int)Float.parseFloat(percent);
                                if (!SferyxUtilities.isFloatLeftView(view, this.getStyleSheet()) && !SferyxUtilities.isFloatRightView(view, this.getStyleSheet())) {
                                    if (number * targetSpan / 100 > previousLeftOffset) {
                                        offsets[i] = number * targetSpan / 100;
                                        this.alignedNormalViewsSpan += number * targetSpan / 100;
                                        break block89;
                                    }
                                    if (previousLeftOffset + spans[i] < targetSpan) {
                                        offsets[i] = previousLeftOffset;
                                    }
                                    break block89;
                                }
                                if (!SferyxUtilities.isFloatRightView(view, this.getStyleSheet())) {
                                    offsets[i] = offsets[i] + number * targetSpan / 100;
                                    alignedLeftViewsSpan_X += leftMargin;
                                }
                                break block89;
                            }
                            if (!SferyxUtilities.isFloatLeftView(view, this.getStyleSheet()) && !SferyxUtilities.isFloatRightView(view, this.getStyleSheet())) {
                                if (leftMargin > previousLeftOffset) {
                                    offsets[i] = leftMargin;
                                    if (offsets[i] + spans[i] > targetSpan) {
                                        spans[i] = spans[i] < leftMargin ? spans[i] - (targetSpan - (offsets[i] + spans[i])) : spans[i] - leftMargin;
                                    }
                                    this.alignedNormalViewsSpan = leftMargin + spans[i];
                                    break block89;
                                } else if (previousLeftOffset + spans[i] >= targetSpan && !SferyxUtilities.isClearLeftView(view, this.getStyleSheet()) && !SferyxUtilities.isClearBothView(view, this.getStyleSheet()) && i > 0 && prevLayoutView != null && SferyxUtilities.isFloatLeftView(prevLayoutView, this.getStyleSheet()) && targetSpan - previousLeftOffset >= min) {
                                    // empty if block
                                }
                                break block89;
                            }
                            if (!SferyxUtilities.isFloatRightView(view, this.getStyleSheet())) {
                                offsets[i] = offsets[i] + leftMargin;
                                alignedLeftViewsSpan_X += leftMargin;
                            }
                        }
                        catch (Throwable thr) {
                            thr.printStackTrace();
                        }
                    }
                    if (offsets[i] + spans[i] > targetSpan && targetSpan - offsets[i] >= min && (prevLayoutView == null || SferyxUtilities.isFloatLeftView(view, this.getStyleSheet()) || SferyxUtilities.isFloatRightView(view, this.getStyleSheet()) || !SferyxUtilities.isDisplayLikeInlineView(prevLayoutView, this.getStyleSheet()))) {
                        spans[i] = targetSpan - offsets[i];
                    }
                }
                if (i <= 0 || this.getView(i - 1) instanceof CustomBlockView) {
                    // empty if block
                }
                if (SferyxUtilities.isLeftMarginAuto(view)) {
                    if (targetSpan > spans[i]) {
                        offsets[i] = (int)((double)(targetSpan - spans[i]) * 0.5);
                    }
                } else if ((SferyxUtilities.isFloatCenterView(elementAttributes, this.getStyleSheet()) || SferyxUtilities.isFloatCenterView(viewAttributes, this.getStyleSheet()) || SferyxUtilities.isFloatCenterView(view.getParent().getElement().getAttributes(), this.getStyleSheet()) || SferyxUtilities.isFloatCenterView(view.getParent().getAttributes(), this.getStyleSheet())) && (SferyxUtilities.matchNameAttribute(elementAttributes, HTML.Tag.TABLE) || SferyxUtilities.isFloatCenterView(this.getElement().getAttributes(), this.getStyleSheet()) || SferyxUtilities.isFloatCenterView(this.getAttributes(), this.getStyleSheet())) && !SferyxUtilities.isFloatLeftView(viewAttributes, this.getStyleSheet()) && !SferyxUtilities.isFloatRightView(viewAttributes, this.getStyleSheet()) && targetSpan > offsets[i] + spans[i] + alignedLeftViewsSpan_X + alignedRightViewsSpan_X) {
                    offsets[i] = (int)((double)(targetSpan - spans[i]) * 0.5);
                }
                if (view instanceof CustomParagraphView) {
                    ((CustomParagraphView)view).adjustChildRowsLayoutForAllRows();
                }
                if (view instanceof TableView && offsets[i] + ((TableView)view).getLeftMargin() < targetSpan - min) {
                    int n = i;
                    offsets[n] = offsets[n] + ((TableView)view).getLeftMargin();
                    if (offsets[i] + spans[i] > targetSpan && spans[i] > ((TableView)view).getLeftMargin()) {
                        spans[i] = spans[i] - ((TableView)view).getLeftMargin();
                    }
                }
                if (this.containsAlignedImages) {
                    this.adjustParagraphLayout(this, i, targetSpan, offsets, spans, view);
                    if (offsets[i] + spans[i] > targetSpan && targetSpan - offsets[i] >= min) {
                        spans[i] = targetSpan - offsets[i];
                    }
                }
                if (view instanceof CustomParagraphView && ((CustomParagraphView)view).containsAlignedImages) {
                    this.containsAlignedImages = true;
                }
                if (view instanceof CSSLayoutViews) {
                    if (((CSSLayoutViews)((Object)view)).isRelativePositioning()) {
                        int n = i;
                        offsets[n] = offsets[n] + SferyxUtilities.getX(view);
                    } else if (((CSSLayoutViews)((Object)view)).isAbsolutePositioning()) {
                        // empty if block
                    }
                }
                if (view instanceof CustomBlockView && offsets[i] + spans[i] + ((CustomBlockView)view).getRightMargin() > targetSpan && ((CustomBlockView)view).getRightMargin() > 0) {
                    spans[i] = spans[i] + (targetSpan - offsets[i] - spans[i] - ((CustomBlockView)view).getRightMargin());
                }
                if (!(view instanceof CustomParagraphView) || offsets[i] + spans[i] + ((CustomParagraphView)view).getRightMargin() <= targetSpan || ((CustomParagraphView)view).getRightMargin() <= 0) continue;
                spans[i] = spans[i] + (targetSpan - offsets[i] - spans[i] - ((CustomParagraphView)view).getRightMargin());
            }
            this.spans_X = spans;
            this.offsets_X = offsets;
            this.targetSpan_X = targetSpan;
        }
        catch (Throwable throwable) {
            Object var24_34 = null;
            this.spans_X = spans;
            this.offsets_X = offsets;
            this.targetSpan_X = targetSpan;
            throw throwable;
        }
    }

    protected void adjustAllParagraphsLayout(int targetSpan, int[] offsets, int[] spans) {
        CustomParagraphView lastParagraph = null;
        int index = -1;
        for (int i = 0; i < this.getViewCount(); ++i) {
            if (!(this.getView(i) instanceof CustomParagraphView)) continue;
            lastParagraph = (CustomParagraphView)this.getView(i);
            index = i;
            this.adjustParagraphLayout(this, index, targetSpan, offsets, spans, lastParagraph);
        }
        if (lastParagraph != null) {
            // empty if block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void adjustParagraphLayout(View parentView, int myIndex, int targetSpan, int[] offsets, int[] spans, View thisView) {
        if (!this.containsAlignedImages) {
            return;
        }
        if (myIndex == 0) {
            return;
        }
        try {
            int difference;
            int j;
            Vector<Rectangle> leftAlignedImages = new Vector<Rectangle>();
            Vector<Rectangle> rightAlignedImages = new Vector<Rectangle>();
            int n = parentView.getViewCount();
            boolean startIndex = false;
            float thisViewMinSpan = thisView.getMinimumSpan(0);
            boolean arePreviousAligned = false;
            for (int i = 0; i < myIndex; ++i) {
                Rectangle rect;
                Rectangle rect_;
                int k;
                View currentView = parentView.getView(i);
                if (!(currentView instanceof CustomParagraphView)) continue;
                CustomParagraphView currentCustomParagraphView = (CustomParagraphView)currentView;
                int paragraphOffset = currentCustomParagraphView.getMyOffset();
                for (k = 0; k < currentCustomParagraphView.leftAlignedViewsPoly.size(); ++k) {
                    rect_ = (Rectangle)currentCustomParagraphView.leftAlignedViewsPoly.elementAt(k);
                    rect = new Rectangle(rect_.x, rect_.y, rect_.width, rect_.height);
                    rect.y += paragraphOffset;
                    leftAlignedImages.addElement(rect);
                }
                for (k = 0; k < currentCustomParagraphView.rightAlignedViewsPoly.size(); ++k) {
                    rect_ = (Rectangle)currentCustomParagraphView.rightAlignedViewsPoly.elementAt(k);
                    rect = new Rectangle(rect_.x, rect_.y, rect_.width, rect_.height);
                    rect.y += paragraphOffset;
                    rightAlignedImages.addElement(rect);
                }
            }
            boolean changed = false;
            if (thisView instanceof CustomParagraphView) {
                offsets[myIndex] = offsets[myIndex] > ((CustomParagraphView)thisView).upperOffsetRestriction ? offsets[myIndex] - ((CustomParagraphView)thisView).upperOffsetRestriction : 0;
                spans[myIndex] = spans[myIndex] + ((CustomParagraphView)thisView).upperOffsetRestriction;
                ((CustomParagraphView)thisView).upperOffsetRestriction = 0;
                ((CustomParagraphView)thisView).upperSpanRestriction = 0;
            }
            for (j = 0; j < leftAlignedImages.size(); ++j) {
                int thisParagraphOffset = 0;
                thisParagraphOffset = thisView instanceof CustomParagraphView ? ((CustomParagraphView)thisView).getMyOffset() : this.getOffset(1, myIndex);
                Rectangle rect = (Rectangle)leftAlignedImages.elementAt(j);
                if (rect.x + rect.width >= targetSpan || (float)(targetSpan - (rect.x + rect.width)) < thisViewMinSpan || rect.y + rect.height < thisParagraphOffset) continue;
                if (parentView.getView(myIndex - 1) instanceof CustomParagraphView) {
                    if (SferyxUtilities.isClearLeftView(this.getView(myIndex), this.getStyleSheet()) || SferyxUtilities.isClearBothView(this.getView(myIndex), this.getStyleSheet())) continue;
                    difference = (int)((CustomParagraphView)parentView.getView((int)(myIndex - 1))).lastRowLeftInset;
                    if (thisView instanceof CustomParagraphView) {
                        ((CustomParagraphView)thisView).upperOffsetRestriction = offsets[myIndex - 1] + difference;
                    }
                    offsets[myIndex] = offsets[myIndex - 1] + difference;
                    if (offsets[myIndex] + spans[myIndex] <= targetSpan) continue;
                    if (thisView instanceof CustomParagraphView) {
                        ((CustomParagraphView)thisView).upperSpanRestriction = spans[myIndex] - (targetSpan - offsets[myIndex]);
                    }
                    spans[myIndex] = targetSpan - offsets[myIndex];
                    continue;
                }
                if (SferyxUtilities.isClearLeftView(this.getView(myIndex), this.getStyleSheet()) || SferyxUtilities.isClearBothView(this.getView(myIndex), this.getStyleSheet())) continue;
                offsets[myIndex] = offsets[myIndex - 1];
                if (offsets[myIndex] + spans[myIndex] <= targetSpan) continue;
                spans[myIndex] = targetSpan - offsets[myIndex];
            }
            for (j = 0; j < rightAlignedImages.size(); ++j) {
                int thisParagraphOffset = 0;
                thisParagraphOffset = thisView instanceof CustomParagraphView ? ((CustomParagraphView)thisView).getMyOffset() : this.getOffset(1, myIndex);
                Rectangle rect = (Rectangle)rightAlignedImages.elementAt(j);
                if (rect.x + rect.width >= targetSpan || (float)(targetSpan - (rect.x + rect.width)) < thisViewMinSpan || rect.y + rect.height < thisParagraphOffset) continue;
                if (parentView.getView(myIndex - 1) instanceof CustomParagraphView) {
                    if (SferyxUtilities.isClearRightView(this.getView(myIndex), this.getStyleSheet()) || SferyxUtilities.isClearBothView(this.getView(myIndex), this.getStyleSheet())) continue;
                    difference = (int)((CustomParagraphView)parentView.getView((int)(myIndex - 1))).lastRowRightInset;
                    if (difference > 0 && offsets[myIndex] + spans[myIndex] > targetSpan - difference) {
                        spans[myIndex] = targetSpan - difference - offsets[myIndex];
                        continue;
                    }
                    if (offsets[myIndex] + spans[myIndex] <= offsets[myIndex - 1] + spans[myIndex - 1]) continue;
                    if (thisView instanceof CustomParagraphView) {
                        // empty if block
                    }
                    spans[myIndex] = spans[myIndex] - (offsets[myIndex] + spans[myIndex] - (offsets[myIndex - 1] + spans[myIndex - 1]));
                    continue;
                }
                if (SferyxUtilities.isClearRightView(this.getView(myIndex), this.getStyleSheet()) || SferyxUtilities.isClearBothView(this.getView(myIndex), this.getStyleSheet())) continue;
                spans[myIndex] = spans[myIndex - 1];
            }
            if (!changed) {
                // empty if block
            }
            if (thisView instanceof CustomParagraphView && this.spans_Y.length > myIndex && SferyxUtilities.getJVMVersion().startsWith("1.3")) return;
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    int getCorrectOffset(int fromIndex, int toIndex, int[] spans, int[] offsets, int currentSpan, int targetSpan) {
        if (fromIndex >= spans.length) {
            return 0;
        }
        if (fromIndex == -1) {
            fromIndex = 0;
        }
        int maxSpan_X = 0;
        boolean maxSpan = false;
        int maxSpanIndex = 0;
        for (int i = fromIndex; i < maxSpanIndex && i <= spans.length && i <= offsets.length; ++i) {
            maxSpan_X += spans[i];
        }
        if (fromIndex == maxSpanIndex) {
            maxSpan_X = spans[fromIndex];
        }
        if (maxSpan_X + currentSpan == targetSpan) {
            return maxSpan_X;
        }
        if (maxSpan_X + currentSpan > targetSpan) {
            return 0;
        }
        return maxSpan_X;
    }

    int getRealFloatSpan(int fromIndex, int toIndex, int[] spans, int[] offsets) {
        if (fromIndex >= spans.length) {
            return 0;
        }
        if (toIndex > spans.length) {
            return 0;
        }
        if (fromIndex == -1) {
            fromIndex = 0;
        }
        int maxSpan = 0;
        for (int i = fromIndex; i < toIndex && i <= spans.length && i <= offsets.length; ++i) {
            View view = this.getView(i);
            if (SferyxUtilities.matchNameAttribute(view.getElement(), HTML.Tag.DIV) && (SferyxUtilities.isFloatLeftView(view.getAttributes(), this.getStyleSheet()) || SferyxUtilities.isFloatRightView(view.getAttributes(), this.getStyleSheet()))) {
                if (!SferyxUtilities.isClearBothView(view.getAttributes(), this.getStyleSheet()) && !SferyxUtilities.isClearLeftView(view.getAttributes(), this.getStyleSheet()) && !SferyxUtilities.isClearRightView(view.getAttributes(), this.getStyleSheet())) continue;
                if (SferyxUtilities.isClearBothView(view.getAttributes(), this.getStyleSheet()) || SferyxUtilities.isClearLeftView(view.getAttributes(), this.getStyleSheet()) || SferyxUtilities.isClearRightView(view.getAttributes(), this.getStyleSheet())) {
                    // empty if block
                }
            }
            maxSpan = spans[i] + offsets[i];
            if (view instanceof CustomBlockView) {
                // empty if block
            }
            if (!(view instanceof CustomParagraphView)) continue;
        }
        int resultSpan = maxSpan + this.getBottomInset() + this.getTopInset();
        float css_height = this.getHeightCSSValue();
        if (css_height != -1.0f && css_height > (float)resultSpan) {
            return (int)css_height;
        }
        return resultSpan;
    }

    int getMaxSpan(int fromIndex, int toIndex, int[] spans, int[] offsets) {
        if (fromIndex >= spans.length) {
            return 0;
        }
        if (toIndex > spans.length) {
            return 0;
        }
        if (fromIndex == -1) {
            fromIndex = 0;
        }
        int maxSpan = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            View view = this.getView(i);
            if (i >= spans.length || i >= offsets.length) break;
            if (!SferyxUtilities.isFloatLeftView(view, this.getStyleSheet()) && !SferyxUtilities.isFloatRightView(view, this.getStyleSheet())) {
                int top;
                int prevBottom;
                if (view instanceof CSSLayoutViews && ((CSSLayoutViews)((Object)view)).isAbsolutePositioning() && !this.getElement().getName().equals("body")) continue;
                maxSpan += spans[i];
                if (view instanceof CSSLayoutViews) {
                    if (i == 0) {
                        maxSpan += ((CSSLayoutViews)((Object)view)).getTopMargin();
                    }
                    if (i > 0 && this.getView(i - 1) instanceof CSSLayoutViews) {
                        prevBottom = ((CSSLayoutViews)((Object)this.getView(i - 1))).getBottomMargin();
                        maxSpan = prevBottom > (top = ((CSSLayoutViews)((Object)view)).getTopMargin()) ? (maxSpan += prevBottom) : (maxSpan += top);
                    }
                    if (i != toIndex - 1 || !(view instanceof CSSLayoutViews)) continue;
                    maxSpan += ((CSSLayoutViews)((Object)view)).getBottomMargin();
                    continue;
                }
                if (!(view instanceof TableView)) continue;
                maxSpan = i > 0 && this.getView(i - 1) instanceof CSSLayoutViews ? ((prevBottom = ((CSSLayoutViews)((Object)this.getView(i - 1))).getBottomMargin()) > (top = ((TableView)view).getTopMargin()) ? (maxSpan += prevBottom) : (maxSpan += top)) : (maxSpan += ((TableView)view).getTopMargin());
                if (i != toIndex - 1) continue;
                maxSpan += ((TableView)view).getBottomMargin();
                continue;
            }
            if (spans[i] + offsets[i] <= maxSpan || view instanceof CSSLayoutViews && ((CSSLayoutViews)((Object)view)).isAbsolutePositioning() && !this.getElement().getName().equals("body")) continue;
            maxSpan = spans[i] + offsets[i];
            if (view instanceof CSSLayoutViews) {
                maxSpan += ((CSSLayoutViews)((Object)view)).getTopMargin();
                maxSpan += ((CSSLayoutViews)((Object)view)).getBottomMargin();
            } else if (view instanceof TableView) {
                maxSpan += ((TableView)view).getTopMargin();
                maxSpan += ((TableView)view).getBottomMargin();
            }
            if (view instanceof CustomBlockView) {
                // empty if block
            }
            if (!(view instanceof CustomParagraphView)) continue;
        }
        int resultSpan = maxSpan + this.getBottomPadding() + this.getTopPadding();
        float css_height = this.getHeightCSSValue() + (float)this.getBottomPadding() + (float)this.getTopPadding();
        if (css_height != -1.0f && css_height > (float)resultSpan) {
            return (int)css_height;
        }
        return resultSpan;
    }

    int getMaxSpan_orig(int fromIndex, int toIndex, int[] spans, int[] offsets) {
        if (fromIndex >= spans.length) {
            return 0;
        }
        if (toIndex > spans.length) {
            return 0;
        }
        if (fromIndex == -1) {
            fromIndex = 0;
        }
        int maxSpan = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            View view = this.getView(i);
            if (i > spans.length || i > offsets.length) break;
            if (spans[i] + offsets[i] <= maxSpan || view instanceof CSSLayoutViews && ((CSSLayoutViews)((Object)view)).isAbsolutePositioning() && !this.getElement().getName().equals("body")) continue;
            maxSpan = spans[i] + offsets[i];
            if (view instanceof CSSLayoutViews) {
                // empty if block
            }
            if (view instanceof CustomBlockView) {
                // empty if block
            }
            if (!(view instanceof CustomParagraphView)) continue;
        }
        int resultSpan = maxSpan + this.getBottomPadding() + this.getTopPadding();
        float css_height = this.getHeightCSSValue() + (float)this.getBottomPadding() + (float)this.getTopPadding();
        if (css_height != -1.0f && css_height > (float)resultSpan) {
            return (int)css_height;
        }
        return resultSpan;
    }

    int getMaxSpan(int fromIndex, int toIndex, int[] spans) {
        if (fromIndex == -1) {
            fromIndex = 0;
        }
        int maxSpan = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (spans[i] <= maxSpan) continue;
            maxSpan = spans[i];
        }
        return maxSpan;
    }

    int getPreviousUnderlyingViewOffset_X(int fromIndex, int toIndex, int[] spans, int[] offsets, int currentOffset) {
        if (fromIndex == -1) {
            fromIndex = 0;
        }
        for (int i = fromIndex; i < toIndex; ++i) {
            if (spans[i] + offsets[i] <= currentOffset) continue;
            currentOffset = spans[i] + offsets[i];
        }
        return currentOffset;
    }

    int adjustXOffsets(int fromIndex, int toIndex) {
        int x = this.offsets_X[toIndex];
        int y = this.offsets_Y[toIndex];
        int spanX = this.spans_X[toIndex];
        int spanY = this.spans_Y[toIndex];
        Rectangle rect = new Rectangle(x, y, spanX, spanY);
        for (int i = fromIndex; i < toIndex; ++i) {
            View view = this.getView(i);
            int viewX = this.offsets_X[i];
            int viewY = this.offsets_Y[i];
            int viewSpanX = this.spans_X[i];
            int viewSpanY = this.spans_Y[i];
            if (SferyxUtilities.isItALeftImageView(view)) {
                viewSpanX = (int)view.getView(0).getView(0).getPreferredSpan(0);
                viewSpanY = (int)view.getView(0).getView(0).getPreferredSpan(1);
            } else if (SferyxUtilities.isItARightImageView(view)) {
                viewSpanX = (int)view.getView(0).getView(1).getPreferredSpan(0);
                viewSpanY = (int)view.getView(0).getView(1).getPreferredSpan(1);
            }
            Rectangle viewRect = new Rectangle(viewX, viewY, viewSpanX, viewSpanY);
            if (!viewRect.intersects(rect)) continue;
            if ((float)(this.spans_X[toIndex] - viewSpanX) >= view.getMinimumSpan(0) && this.offsets_X[toIndex] + viewSpanX + this.spans_X[toIndex] - viewSpanX <= this.targetSpan_X) {
                int n = toIndex;
                this.offsets_X[n] = this.offsets_X[n] + viewSpanX;
                this.spans_X[toIndex] = this.spans_X[toIndex] - viewSpanX;
                continue;
            }
            return this.offsets_Y[toIndex];
        }
        return 0;
    }

    float getYSpanExcludingFloats() {
        float css_height = this.getHeightCSSValue();
        if (css_height != -1.0f) {
            return css_height;
        }
        float maxSpan = 0.0f;
        for (int i = 0; i < this.getViewCount(); ++i) {
            View view = this.getView(i);
            if (SferyxUtilities.isFloatLeftView(view, this.getStyleSheet()) || SferyxUtilities.isFloatRightView(view, this.getStyleSheet())) continue;
            maxSpan = this.getSpan(1, i) + this.getOffset(1, i);
        }
        return maxSpan;
    }

    int getPreviousUnderlyingViewOffset_Y(int fromIndex, int toIndex, int[] spans, int[] offsets, int currentOffset) {
        if (fromIndex == -1) {
            fromIndex = 0;
        }
        this.toIndexRect.x = this.offsets_X[toIndex] + 2;
        this.toIndexRect.y = currentOffset;
        this.toIndexRect.width = this.spans_X[toIndex] - 4;
        this.toIndexRect.height = this.spans_Y[toIndex];
        for (int i = fromIndex; i < toIndex; ++i) {
            if (this.getView(i) instanceof CSSLayoutViews && ((CSSLayoutViews)((Object)this.getView(i))).isAbsolutePositioning()) continue;
            this.rect.x = this.offsets_X[i] + 2;
            this.rect.y = this.offsets_Y[i];
            this.rect.width = this.spans_X[i] - 4;
            this.rect.height = this.spans_Y[i];
            if (this.rect.height == 0 || this.rect.width == 0 || this.toIndexRect.width == 0 || this.toIndexRect.height == 0 || !this.rect.contains(this.toIndexRect) && !this.rect.intersects(this.toIndexRect) && !this.toIndexRect.contains(this.rect) && !this.toIndexRect.intersects(this.rect) && this.rect.y < this.toIndexRect.y + this.toIndexRect.height || this.rect.y + this.rect.height < currentOffset) continue;
            currentOffset = this.rect.y + this.rect.height;
        }
        return currentOffset;
    }

    int getAbsolutePositionedElementsSpanY() {
        int totalOffset = 0;
        for (int i = 0; i < this.getViewCount(); ++i) {
            int span;
            int y;
            View v = this.getView(i);
            if (!(v instanceof CSSLayoutViews) || !((CSSLayoutViews)((Object)v)).isAbsolutePositioning() || (y = ((CSSLayoutViews)((Object)v)).getAbsoluteY()) + (span = this.getSpan(1, i)) <= totalOffset) continue;
            totalOffset = y + span;
        }
        return totalOffset;
    }

    protected void layoutSuperMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans, int i, View v, int totalOffset) {
        long minimum = 0L;
        long maximum = 0L;
        long preferred = 0L;
        int n = this.getViewCount();
        spans[i] = v instanceof CustomLayoutBoxView ? ((CustomLayoutBoxView)v).getMaxSpan(0, v.getViewCount(), ((CustomLayoutBoxView)v).spans_Y, ((CustomLayoutBoxView)v).offsets_Y) : (int)v.getPreferredSpan(axis);
        minimum = (long)((float)minimum + v.getMinimumSpan(axis));
        maximum = (long)((float)maximum + v.getMaximumSpan(axis));
        long desiredAdjustment = (long)targetSpan - (preferred += (long)spans[i]);
        float adjustmentFactor = 0.0f;
        if (desiredAdjustment != 0L) {
            float maximumAdjustment;
            float f = maximumAdjustment = desiredAdjustment > 0L ? (float)(maximum - preferred) : (float)(preferred - minimum);
            if (maximumAdjustment == 0.0f) {
                adjustmentFactor = 0.0f;
            } else {
                adjustmentFactor = (float)desiredAdjustment / maximumAdjustment;
                adjustmentFactor = Math.min(adjustmentFactor, 1.0f);
                adjustmentFactor = Math.max(adjustmentFactor, -1.0f);
            }
        }
        View view = v;
        offsets[i] = totalOffset;
    }

    protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        this.alignedLeftViewsSpan = 0;
        this.alignedRightViewsSpan = 0;
        this.alignedNormalViewsSpan = 0;
        int alignedLeftViewsSpan_X = 0;
        boolean alignedRightViewsSpan_X = false;
        int lastMovedIndex = -1;
        boolean maxSpan = false;
        this.forceSizeUpdate = false;
        int totalSpan = 0;
        boolean containsFloat = false;
        for (int i = 0; i < offsets.length; ++i) {
            int prevBottomMargin;
            View view = this.getView(i);
            if (SferyxUtilities.isItACommentView(view)) {
                offsets[i] = 0;
                spans[i] = 0;
                continue;
            }
            View prevLayoutView = SferyxUtilities.getPreviousLayoutView(view);
            this.layoutSuperMajorAxis(targetSpan, axis, offsets, spans, i, view, totalSpan);
            if (SferyxUtilities.isFloatLeftView(view, this.getStyleSheet()) || SferyxUtilities.isFloatRightView(view, this.getStyleSheet())) {
                containsFloat = true;
            }
            if (view instanceof CustomFrameSetView) {
                offsets[i] = 0;
                spans[i] = targetSpan;
                if (this.getContainer() != null) {
                    JComponent comp = (JComponent)this.getContainer();
                    if (spans[i] < comp.getVisibleRect().height) {
                        spans[i] = comp.getVisibleRect().height - comp.getInsets().top - comp.getInsets().bottom - this.getTopMargin() - this.getBottomPadding() - this.getTopPadding() - this.getBottomPadding();
                    }
                }
                return;
            }
            if (SferyxUtilities.isViewNotVisible(view, this.getStyleSheet())) {
                offsets[i] = 0;
                spans[i] = 0;
                continue;
            }
            if (view instanceof CSSLayoutViews && ((CSSLayoutViews)((Object)view)).isAbsolutePositioning()) {
                if (!SferyxUtilities.isDefinedAbsoluteY(view)) continue;
                offsets[i] = ((CSSLayoutViews)((Object)view)).getAbsoluteY() + ((CSSLayoutViews)((Object)view)).getTopMargin();
                continue;
            }
            if (view instanceof BlockView || view instanceof BoxView) {
                // empty if block
            }
            int oldSpan = spans[i];
            if (SferyxUtilities.matchNameAttribute(view.getElement(), HTML.Tag.BODY) && view instanceof CustomLayoutBoxView) {
                offsets[i] = ((CustomLayoutBoxView)view).getTopMargin();
            }
            AttributeSet viewAttributes = view.getAttributes();
            AttributeSet elementAttributes = view.getElement().getAttributes();
            if (containsFloat) {
                View previousView;
                if (SferyxUtilities.isFloatLeftView(viewAttributes, this.getStyleSheet()) || SferyxUtilities.isFloatLeftView(elementAttributes, this.getStyleSheet())) {
                    if (SferyxUtilities.isItALeftImageView(view)) {
                        // empty if block
                    }
                    if ((alignedLeftViewsSpan_X += this.spans_X[i]) < this.targetSpan_X) {
                        if (i > 0) {
                            if (prevLayoutView != null) {
                                offsets[i] = offsets[SferyxUtilities.indexOfView(prevLayoutView)];
                            }
                        } else {
                            offsets[i] = this.alignedNormalViewsSpan;
                        }
                    } else if (alignedLeftViewsSpan_X == this.targetSpan_X) {
                        if (i > 0) {
                            if (prevLayoutView == null) {
                                offsets[i] = offsets[i - 1];
                            }
                        } else {
                            offsets[i] = this.alignedNormalViewsSpan;
                        }
                        alignedLeftViewsSpan_X = 0;
                        this.alignedNormalViewsSpan += spans[i];
                    } else if (alignedLeftViewsSpan_X > this.targetSpan_X) {
                        offsets[i] = this.alignedNormalViewsSpan;
                        alignedLeftViewsSpan_X = 0;
                        this.alignedNormalViewsSpan += spans[i];
                    }
                    containsFloat = true;
                    if (view instanceof CSSLayoutViews && (prevLayoutView == null || !SferyxUtilities.isFloatLeftView(prevLayoutView, this.getStyleSheet()) && !SferyxUtilities.isFloatRightView(prevLayoutView, this.getStyleSheet()))) {
                        int n = i;
                        offsets[n] = offsets[n] + ((CSSLayoutViews)((Object)view)).getTopMargin();
                        this.alignedLeftViewsSpan += ((CSSLayoutViews)((Object)view)).getTopMargin();
                    }
                } else if (SferyxUtilities.isFloatRightView(viewAttributes, this.getStyleSheet()) || SferyxUtilities.isFloatRightView(elementAttributes, this.getStyleSheet())) {
                    if (SferyxUtilities.isItARightImageView(view)) {
                        // empty if block
                    }
                    if ((alignedLeftViewsSpan_X += this.spans_X[i]) < this.targetSpan_X) {
                        if (i > 0) {
                            if (prevLayoutView != null) {
                                offsets[i] = offsets[SferyxUtilities.indexOfView(prevLayoutView)];
                            }
                        } else {
                            offsets[i] = this.alignedNormalViewsSpan;
                        }
                        this.alignedNormalViewsSpan += spans[i];
                    } else if (alignedLeftViewsSpan_X == this.targetSpan_X) {
                        if (i > 0) {
                            if (prevLayoutView != null) {
                                offsets[i] = offsets[SferyxUtilities.indexOfView(prevLayoutView)];
                            }
                        } else {
                            offsets[i] = this.alignedNormalViewsSpan;
                        }
                        alignedLeftViewsSpan_X = 0;
                        this.alignedNormalViewsSpan += spans[i];
                    } else if (alignedLeftViewsSpan_X > this.targetSpan_X) {
                        offsets[i] = this.alignedNormalViewsSpan;
                        alignedLeftViewsSpan_X = 0;
                        this.alignedNormalViewsSpan += spans[i];
                    }
                    if (view instanceof CSSLayoutViews && (prevLayoutView == null || !SferyxUtilities.isFloatLeftView(prevLayoutView, this.getStyleSheet()) && !SferyxUtilities.isFloatRightView(prevLayoutView, this.getStyleSheet()))) {
                        int n = i;
                        offsets[n] = offsets[n] + ((CSSLayoutViews)((Object)view)).getTopMargin();
                        this.alignedNormalViewsSpan += ((CSSLayoutViews)((Object)view)).getTopMargin();
                    }
                    containsFloat = true;
                } else {
                    if (prevLayoutView != null && !SferyxUtilities.isFloatLeftView(prevLayoutView, this.getStyleSheet()) && !SferyxUtilities.isFloatRightView(prevLayoutView, this.getStyleSheet()) && prevLayoutView instanceof CSSLayoutViews) {
                        int n = i;
                        offsets[n] = offsets[n] + ((CSSLayoutViews)((Object)prevLayoutView)).getBottomMargin();
                        this.alignedNormalViewsSpan += ((CSSLayoutViews)((Object)prevLayoutView)).getBottomMargin();
                    }
                    if (view instanceof CSSLayoutViews) {
                        // empty if block
                    }
                    if (SferyxUtilities.isItACommentView(view)) {
                        if (i > 0) {
                            if (prevLayoutView != null) {
                                offsets[i] = offsets[SferyxUtilities.indexOfView(prevLayoutView)];
                            }
                        } else {
                            offsets[i] = this.alignedNormalViewsSpan;
                        }
                    } else {
                        offsets[i] = this.alignedNormalViewsSpan;
                        this.alignedNormalViewsSpan += spans[i];
                        if ((alignedLeftViewsSpan_X += this.spans_X[i]) > this.targetSpan_X) {
                            alignedLeftViewsSpan_X = 0;
                        }
                    }
                }
                if (i > 0 && (previousView = prevLayoutView) != null) {
                    if (SferyxUtilities.isFloatRightView(previousView.getAttributes(), this.getStyleSheet()) || SferyxUtilities.isFloatRightView(previousView.getElement().getAttributes(), this.getStyleSheet())) {
                        if (!SferyxUtilities.isClearBothView(previousView.getAttributes(), this.getStyleSheet()) && !SferyxUtilities.isClearLeftView(previousView.getAttributes(), this.getStyleSheet()) && this.offsets_X[i] + this.spans_X[i] <= this.offsets_X[SferyxUtilities.indexOfView(prevLayoutView)] && this.spans_X[i] + this.spans_X[SferyxUtilities.indexOfView(prevLayoutView)] <= this.targetSpan_X) {
                            offsets[i] = offsets[SferyxUtilities.indexOfView(prevLayoutView)];
                            this.alignedNormalViewsSpan -= spans[SferyxUtilities.indexOfView(prevLayoutView)];
                        }
                    } else if (SferyxUtilities.isFloatLeftView(previousView.getAttributes(), this.getStyleSheet()) || SferyxUtilities.isFloatLeftView(previousView.getElement().getAttributes(), this.getStyleSheet())) {
                        if (!SferyxUtilities.isClearBothView(previousView.getAttributes(), this.getStyleSheet()) && !SferyxUtilities.isClearRightView(previousView.getAttributes(), this.getStyleSheet()) && this.offsets_X[i] >= this.offsets_X[SferyxUtilities.indexOfView(prevLayoutView)] + this.spans_X[SferyxUtilities.indexOfView(prevLayoutView)] && this.spans_X[i] + this.spans_X[SferyxUtilities.indexOfView(prevLayoutView)] <= this.targetSpan_X) {
                            if (prevLayoutView != null) {
                                offsets[i] = offsets[SferyxUtilities.indexOfView(prevLayoutView)];
                            }
                            this.alignedNormalViewsSpan = prevLayoutView != null ? (this.alignedNormalViewsSpan -= spans[SferyxUtilities.indexOfView(prevLayoutView)]) : (this.alignedNormalViewsSpan -= spans[i - 1]);
                        }
                    } else {
                        View previousFloatView = SferyxUtilities.getPreviousFloatView(view);
                        if (previousFloatView != null) {
                            int indexOfFloat = SferyxUtilities.indexOfView(previousFloatView);
                            if (previousFloatView.getPreferredSpan(1) > (float)SferyxUtilities.getTotalSpanBetween(i, indexOfFloat, this)) {
                                if (previousView != null && !SferyxUtilities.isClearLeftView(view, this.getStyleSheet()) && !SferyxUtilities.isClearBothView(view, this.getStyleSheet())) {
                                    offsets[i] = offsets[SferyxUtilities.indexOfView(previousView)] + spans[SferyxUtilities.indexOfView(previousView)];
                                }
                                if (offsets[indexOfFloat] + spans[indexOfFloat] <= offsets[i] || SferyxUtilities.isFloatLeftView(previousFloatView, this.getStyleSheet())) {
                                    // empty if block
                                }
                            }
                        }
                        if (previousView instanceof CustomLayoutBoxView) {
                            // empty if block
                        }
                    }
                }
            }
            this.spans_Y = spans;
            this.offsets_Y = offsets;
            if (this.getView(i) instanceof TableView) {
                offsets[i] = offsets[i] + ((TableView)this.getView(i)).getTopMargin();
            }
            if (i > 0 && prevLayoutView instanceof TableView) {
                offsets[i] = offsets[i] + ((TableView)prevLayoutView).getBottomMargin();
            }
            int new_offset = offsets[i];
            if (containsFloat && i > 0) {
                int new_alignedNormalViewsSpan;
                int prevIndex = 0;
                new_offset = this.getPreviousUnderlyingViewOffset_Y(prevIndex, i, spans, offsets, offsets[i]);
                if (new_offset > offsets[i]) {
                    offsets[i] = i > 0 ? new_offset : new_offset;
                }
                if ((new_alignedNormalViewsSpan = new_offset) > this.alignedNormalViewsSpan) {
                    this.alignedNormalViewsSpan = new_alignedNormalViewsSpan;
                }
            } else if (i > 0) {
                // empty if block
            }
            if (!(i <= 0 || SferyxUtilities.isFloatLeftView(viewAttributes, this.getStyleSheet()) || SferyxUtilities.isFloatLeftView(elementAttributes, this.getStyleSheet()) || SferyxUtilities.isFloatRightView(viewAttributes, this.getStyleSheet()) || SferyxUtilities.isFloatRightView(elementAttributes, this.getStyleSheet()) || prevLayoutView == null || SferyxUtilities.isFloatLeftView(prevLayoutView.getAttributes(), this.getStyleSheet()) || SferyxUtilities.isFloatLeftView(prevLayoutView.getElement().getAttributes(), this.getStyleSheet()) || SferyxUtilities.isFloatRightView(prevLayoutView.getAttributes(), this.getStyleSheet()) || SferyxUtilities.isFloatRightView(prevLayoutView.getElement().getAttributes(), this.getStyleSheet()))) {
                try {
                    int topMargin = 0;
                    prevBottomMargin = 0;
                    if (this.getView(i) instanceof CustomBlockView) {
                        topMargin = ((CustomBlockView)this.getView(i)).getTopMargin();
                    } else if (this.getView(i) instanceof CustomParagraphView) {
                        topMargin = ((CustomParagraphView)this.getView(i)).getTopMargin();
                    }
                    if (i > 0 && prevLayoutView instanceof CustomBlockView) {
                        prevBottomMargin = ((CustomBlockView)prevLayoutView).getBottomMargin();
                    } else if (i > 0 && prevLayoutView instanceof CustomParagraphView) {
                        prevBottomMargin = ((CustomParagraphView)prevLayoutView).getBottomMargin();
                    }
                    if (prevBottomMargin >= topMargin) {
                        if (i > 0) {
                            offsets[i] = offsets[i] + prevBottomMargin;
                        }
                    } else if (i > 0) {
                        offsets[i] = offsets[i] + topMargin;
                    }
                }
                catch (Throwable thr) {
                    thr.printStackTrace();
                }
            } else if (i == 0) {
                try {
                    int topMargin = 0;
                    prevBottomMargin = 0;
                    if (this.getView(i) instanceof CustomBlockView) {
                        topMargin = ((CustomBlockView)this.getView(i)).getTopMargin();
                    } else if (this.getView(i) instanceof CustomParagraphView) {
                        topMargin = ((CustomParagraphView)this.getView(i)).getTopMargin();
                    }
                    int n = i;
                    offsets[n] = offsets[n] + topMargin;
                }
                catch (Throwable thr) {
                    thr.printStackTrace();
                }
            }
            if (view instanceof CSSLayoutViews) {
                if (((CSSLayoutViews)((Object)view)).isRelativePositioning()) {
                    int n = i;
                    offsets[n] = offsets[n] + SferyxUtilities.getY(view);
                } else if (((CSSLayoutViews)((Object)view)).isAbsolutePositioning()) {
                    // empty if block
                }
            }
            totalSpan = offsets[i] + spans[i];
        }
        this.spans_Y = spans;
        this.offsets_Y = offsets;
        this.valid = true;
    }

    public float getHeightCSSValue() {
        float span = -1.0f;
        if (SferyxUtilities.getStyleSheetCSSValueForElement(this.getStyleSheet(), this.getAttributes(), CSS.Attribute.HEIGHT) != null && (span = SferyxUtilities.getNumberFromCSString(SferyxUtilities.getStyleSheetCSSValueForElement(this.getStyleSheet(), this.getAttributes(), CSS.Attribute.HEIGHT).toString())) != -1.0f) {
            return span;
        }
        AttributeSet eleAttribs = this.getElement().getAttributes();
        String emMargin = (String)eleAttribs.getAttribute("height");
        AttributeSet viewAttributes = this.getAttributes();
        if (emMargin == null) {
            emMargin = (String)viewAttributes.getAttribute("height");
        }
        if (emMargin == null) {
            emMargin = (String)eleAttribs.getAttribute(AlternativeCSSAttribute.HEIGHT);
        }
        if (emMargin == null) {
            emMargin = (String)viewAttributes.getAttribute(AlternativeCSSAttribute.HEIGHT);
        }
        if (emMargin != null && eleAttribs.isDefined("height") || viewAttributes.isDefined(AlternativeCSSAttribute.HEIGHT) || eleAttribs.isDefined(AlternativeCSSAttribute.HEIGHT)) {
            if (emMargin != null && emMargin.indexOf("em") != -1 && emMargin.indexOf("rem") == -1) {
                float emValue = SferyxUtilities.convertEmValue(emMargin);
                if (emValue != -1.0f) {
                    Font font = this.getStyleSheet().getFont(this.getAttributes());
                    int result = (int)((float)font.getSize() * emValue);
                    this.margin_left_em = true;
                    return result;
                }
            } else if (emMargin != null && emMargin.indexOf("rem") != -1) {
                float emValue = SferyxUtilities.convertEmValue(emMargin);
                if (emValue != -1.0f && this.getContainer() != null) {
                    View rootView = ((JEditorPane)this.getContainer()).getUI().getRootView((JEditorPane)this.getContainer());
                    Font font = this.getStyleSheet().getFont(rootView.getAttributes());
                    int result = (int)((float)font.getSize() * emValue);
                    this.margin_left_em = true;
                    return result;
                }
            } else if (emMargin != null && emMargin.indexOf("%") != -1) {
                try {
                    float emValue = Float.parseFloat(emMargin.substring(0, emMargin.indexOf("%")));
                    if (emValue != -1.0f && this.getParent() instanceof BoxView) {
                        int result = (int)((float)((BoxView)this.getParent()).getWidth() * emValue / 100.0f);
                        return result;
                    }
                }
                catch (Throwable thr) {
                    // empty catch block
                }
            }
        }
        return span;
    }

    public float getWidthCSSValue() {
        float span = -1.0f;
        span = SferyxUtilities.getStyleSheetCSSWidthForView(this.getStyleSheet(), this);
        if (span != -1.0f) {
            return span;
        }
        AttributeSet eleAttribs = this.getElement().getAttributes();
        String emMargin = (String)eleAttribs.getAttribute("width");
        AttributeSet viewAttributes = this.getAttributes();
        if (emMargin == null) {
            emMargin = (String)viewAttributes.getAttribute("width");
        }
        if (emMargin == null) {
            emMargin = (String)eleAttribs.getAttribute(AlternativeCSSAttribute.WIDTH);
        }
        if (emMargin == null) {
            emMargin = (String)viewAttributes.getAttribute(AlternativeCSSAttribute.WIDTH);
        }
        if (emMargin != null & (eleAttribs.isDefined("width") || viewAttributes.isDefined("width") || viewAttributes.isDefined(AlternativeCSSAttribute.WIDTH) || eleAttribs.isDefined(AlternativeCSSAttribute.WIDTH))) {
            if (emMargin != null && emMargin.indexOf("em") != -1 && emMargin.indexOf("rem") == -1) {
                float emValue = SferyxUtilities.convertEmValue(emMargin);
                if (emValue != -1.0f) {
                    Font font = this.getStyleSheet().getFont(this.getAttributes());
                    int result = (int)((float)font.getSize() * emValue);
                    this.margin_left_em = true;
                    return result;
                }
            } else if (emMargin != null && emMargin.indexOf("rem") != -1) {
                float emValue = SferyxUtilities.convertEmValue(emMargin);
                if (emValue != -1.0f && this.getContainer() != null) {
                    View rootView = ((JEditorPane)this.getContainer()).getUI().getRootView((JEditorPane)this.getContainer());
                    Font font = this.getStyleSheet().getFont(rootView.getAttributes());
                    int result = (int)((float)font.getSize() * emValue);
                    this.margin_left_em = true;
                    return result;
                }
            } else if (emMargin != null && emMargin.indexOf("%") != -1) {
                try {
                    float emValue = Float.parseFloat(emMargin.substring(0, emMargin.indexOf("%")));
                    if (emValue != -1.0f && this.getParent() instanceof BoxView) {
                        int result = (int)((float)((BoxView)this.getParent()).getWidth() * emValue / 100.0f);
                        return result;
                    }
                }
                catch (Throwable thr) {
                    // empty catch block
                }
            }
        }
        return span;
    }

    public float getFloatingChildrenSpan(int axis) {
        float totalSpan = 0.0f;
        float maxSpan = super.getMaximumSpan(axis);
        float fixedWidth = this.getWidthCSSValue();
        if (fixedWidth > 0.0f) {
            maxSpan = fixedWidth;
        }
        for (int i = 0; i < this.getViewCount(); ++i) {
            float viewSpan;
            View view = this.getView(i);
            AttributeSet viewAttributes = view.getAttributes();
            if (SferyxUtilities.isFloatLeftView(viewAttributes, this.getStyleSheet()) || SferyxUtilities.isFloatRightView(viewAttributes, this.getStyleSheet())) {
                viewSpan = view.getPreferredSpan(axis);
                if (totalSpan + viewSpan > maxSpan && !SferyxUtilities.isClearBothView(viewAttributes, this.getStyleSheet()) && !SferyxUtilities.isClearLeftView(viewAttributes, this.getStyleSheet()) && !SferyxUtilities.isClearRightView(viewAttributes, this.getStyleSheet())) continue;
                if (SferyxUtilities.isClearBothView(viewAttributes, this.getStyleSheet()) || SferyxUtilities.isClearLeftView(viewAttributes, this.getStyleSheet()) || SferyxUtilities.isClearRightView(viewAttributes, this.getStyleSheet())) {
                    if (!(viewSpan > totalSpan) || viewSpan > totalSpan) {
                        // empty if block
                    }
                    return -1.0f;
                }
                if (!(totalSpan + viewSpan <= maxSpan)) continue;
                totalSpan += viewSpan;
                if (!(view instanceof CustomBlockView)) continue;
                totalSpan += (float)(((CustomBlockView)view).getLeftMargin() + ((CustomBlockView)view).getRightMargin());
                continue;
            }
            if (SferyxUtilities.getPreviousLayoutView(view) == null || !SferyxUtilities.isFloatLeftView(SferyxUtilities.getPreviousLayoutView(view), this.getStyleSheet()) && !SferyxUtilities.isFloatRightView(SferyxUtilities.getPreviousLayoutView(view), this.getStyleSheet())) continue;
            viewSpan = view.getPreferredSpan(axis);
            if (SferyxUtilities.isClearBothView(viewAttributes, this.getStyleSheet()) || SferyxUtilities.isClearLeftView(viewAttributes, this.getStyleSheet()) || SferyxUtilities.isClearRightView(viewAttributes, this.getStyleSheet())) continue;
            totalSpan += viewSpan;
            if (!(view instanceof CustomBlockView)) continue;
            totalSpan += (float)(((CustomBlockView)view).getLeftMargin() + ((CustomBlockView)view).getRightMargin());
        }
        return totalSpan;
    }

    protected View getViewAtPoint(int x, int y, Rectangle alloc) {
        if (this.spans_X.length == 0 || this.spans_Y.length == 0) {
            return null;
        }
        for (int i = 0; i < this.getViewCount(); ++i) {
            int curr_span_X = this.spans_X[i];
            int curr_span_Y = this.spans_Y[i];
            int curr_offset_X = this.offsets_X[i];
            int curr_offset_Y = this.offsets_Y[i];
            int higherIndex = -1;
            if (x > alloc.x + curr_offset_X && x < alloc.x + curr_offset_X + curr_span_X && y > alloc.y + curr_offset_Y && y < alloc.y + curr_offset_Y + curr_span_Y) {
                higherIndex = i;
            }
            if (higherIndex != -1) {
                this.childAllocation(higherIndex, alloc);
                return this.getView(higherIndex);
            }
            if (x > curr_offset_X && x < curr_offset_X + curr_span_X && y > alloc.y + curr_offset_Y && y < alloc.y + curr_offset_Y + curr_span_Y) {
                higherIndex = i;
            }
            if (higherIndex == -1) continue;
            this.childAllocation(higherIndex, alloc);
            return this.getView(higherIndex);
        }
        return super.getViewAtPoint(x, y, alloc);
    }

    public int getMyOffset() {
        int paragraphOffset = -1;
        View parentView = this.getParent();
        if (parentView instanceof CustomParagraphView) {
            paragraphOffset = ((CustomParagraphView)parentView).getOffset(1, this.getMyIndex());
        } else if (parentView instanceof CustomBlockView) {
            paragraphOffset = ((CustomBlockView)parentView).getOffset(1, this.getMyIndex());
        } else {
            View currentView;
            int n = parentView.getViewCount();
            boolean offset = false;
            for (int i = 0; i < n && (currentView = parentView.getView(i)) != this; ++i) {
                paragraphOffset = (int)((float)paragraphOffset + currentView.getPreferredSpan(1));
            }
        }
        return paragraphOffset;
    }

    public boolean isAbsolutePositioning() {
        if (this.getElement().getAttributes().getAttribute("position") != null && this.getElement().getAttributes().isDefined("position") && this.getElement().getAttributes().getAttribute("position").toString().trim().equals("absolute")) {
            return true;
        }
        return this.getAttributes().getAttribute("position") != null && this.getAttributes().containsAttribute("position", this.getAttributes().getAttribute("position")) && this.getAttributes().getAttribute("position").toString().trim().equals("absolute");
    }

    public boolean isRelativePositioning() {
        if (this.getElement().getAttributes().getAttribute("position") != null && this.getElement().getAttributes().isDefined("position") && this.getElement().getAttributes().getAttribute("position").toString().trim().equals("relative")) {
            return true;
        }
        return this.getAttributes().getAttribute("position") != null && this.getAttributes().containsAttribute("position", this.getAttributes().getAttribute("position")) && this.getAttributes().getAttribute("position").toString().trim().equals("relative");
    }

    public int getAbsoluteX() {
        return SferyxUtilities.getAbsoluteX(this);
    }

    public int getAbsoluteX_() {
        try {
            View referenceParent = SferyxUtilities.getAbsolutePositioningReferenceParent(this);
            int additionalOffset = 0;
            int referenceParentSpan = 0;
            if (this.isAbsolutePositioning()) {
                if (!referenceParent.getElement().getName().equalsIgnoreCase("body")) {
                    View parentOfreferenceParent = referenceParent.getParent();
                    if (parentOfreferenceParent != null && parentOfreferenceParent instanceof CustomLayoutBoxView) {
                        additionalOffset -= SferyxUtilities.getAbsolutePositioningReferenceOffsetX(this);
                        referenceParentSpan = ((CustomLayoutBoxView)parentOfreferenceParent).getSpan(0, SferyxUtilities.indexOfView(referenceParent));
                    }
                } else if (referenceParent.getContainer() != null) {
                    referenceParentSpan = ((JEditorPane)referenceParent.getContainer()).getVisibleRect().width;
                }
            }
            if (this.getElement().getAttributes().getAttribute("left") != null && this.getElement().getAttributes().isDefined("left")) {
                return additionalOffset + (int)SferyxUtilities.getNumberFromCSString((String)this.getElement().getAttributes().getAttribute("left"));
            }
            if (this.getElement().getAttributes().getAttribute("right") != null && this.getElement().getAttributes().isDefined("right")) {
                int span = ((CustomLayoutBoxView)this.getParent()).getSpan(0, SferyxUtilities.indexOfView(this));
                return additionalOffset + referenceParentSpan - span - (int)SferyxUtilities.getNumberFromCSString((String)this.getElement().getAttributes().getAttribute("right"));
            }
            if (this.getAttributes().getAttribute("left") != null && this.getAttributes().isDefined("left")) {
                return additionalOffset + (int)SferyxUtilities.getNumberFromCSString((String)this.getAttributes().getAttribute("left"));
            }
            if (this.getAttributes().getAttribute("right") != null && this.getAttributes().isDefined("right")) {
                int span = ((CustomLayoutBoxView)this.getParent()).getSpan(0, SferyxUtilities.indexOfView(this));
                return additionalOffset + referenceParentSpan - span - (int)SferyxUtilities.getNumberFromCSString((String)this.getAttributes().getAttribute("right"));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    public int getAbsoluteY() {
        return SferyxUtilities.getAbsoluteY(this);
    }

    public int getAbsoluteY_() {
        View referenceParent = SferyxUtilities.getAbsolutePositioningReferenceParent(this);
        int additionalOffset = 0;
        int referenceParentSpan = 0;
        if (this.isAbsolutePositioning()) {
            if (!referenceParent.getElement().getName().equalsIgnoreCase("body")) {
                View parentOfreferenceParent = referenceParent.getParent();
                if (parentOfreferenceParent != null && parentOfreferenceParent instanceof CustomLayoutBoxView) {
                    additionalOffset -= SferyxUtilities.getAbsolutePositioningReferenceOffset(this);
                    referenceParentSpan = ((CustomLayoutBoxView)parentOfreferenceParent).getSpan(1, SferyxUtilities.indexOfView(referenceParent));
                }
            } else {
                if (referenceParent.getContainer() != null) {
                    referenceParentSpan = ((JEditorPane)referenceParent.getContainer()).getVisibleRect().height;
                }
                additionalOffset -= SferyxUtilities.getAbsolutePositioningReferenceOffset(this.getParent());
                if (this.getParent() instanceof CustomLayoutBoxView) {
                    additionalOffset -= ((CustomLayoutBoxView)this.getParent()).getTopPadding();
                }
            }
        }
        try {
            if (this.getElement().getAttributes().getAttribute("top") != null && this.getElement().getAttributes().isDefined("top")) {
                return additionalOffset + (int)SferyxUtilities.getNumberFromCSString((String)this.getElement().getAttributes().getAttribute("top"));
            }
            if (this.getElement().getAttributes().getAttribute("bottom") != null && this.getElement().getAttributes().isDefined("bottom")) {
                int span = ((CustomLayoutBoxView)this.getParent()).getSpan(1, SferyxUtilities.indexOfView(this));
                return additionalOffset + referenceParentSpan - span - (int)SferyxUtilities.getNumberFromCSString((String)this.getElement().getAttributes().getAttribute("bottom"));
            }
        }
        catch (Throwable thr) {
            // empty catch block
        }
        try {
            if (this.getAttributes().getAttribute("top") != null && this.getAttributes().isDefined("top")) {
                return additionalOffset + (int)SferyxUtilities.getNumberFromCSString((String)this.getAttributes().getAttribute("top"));
            }
            if (this.getAttributes().getAttribute("bottom") != null && this.getAttributes().isDefined("bottom")) {
                int span = ((CustomLayoutBoxView)this.getParent()).getSpan(1, SferyxUtilities.indexOfView(this));
                return additionalOffset + referenceParentSpan - span - (int)SferyxUtilities.getNumberFromCSString((String)this.getAttributes().getAttribute("bottom"));
            }
        }
        catch (Throwable thr) {
            // empty catch block
        }
        return additionalOffset;
    }

    public void paintThisViewOnly(Graphics g, Shape allocation) {
        Rectangle alloc = allocation instanceof Rectangle ? (Rectangle)allocation : allocation.getBounds();
        this.getStyleSheet().getBoxPainter(this.getAttributes()).paint(g, alloc.x + this.getLeftInset(), alloc.y, alloc.width - this.getLeftInset(), alloc.height, this);
        boolean absolutePositioning = this.isAbsolutePositioning();
        int n = this.getViewCount();
        int x = alloc.x + this.getLeftInset();
        int y = alloc.y + this.getTopInset();
        Rectangle clip = g.getClipBounds();
        for (int i = 0; i < n; ++i) {
            this.tempRect.x = x + this.getOffset(0, i);
            this.tempRect.y = y + this.getOffset(1, i);
            if (absolutePositioning) {
                this.tempRect.x = this.getAbsoluteX() + this.getOffset(0, i);
                this.tempRect.y = this.getAbsoluteX() + this.getOffset(1, i);
            }
            this.tempRect.width = this.getSpan(0, i);
            this.tempRect.height = this.getSpan(1, i);
            Rectangle newRect = new Rectangle(this.tempRect);
            newRect.height += 600;
            if (!newRect.intersects(clip) || !SferyxUtilities.getJVMVersion().startsWith("1.5") || !this.getView(i).getClass().getName().equals("javax.swing.text.html.TableView")) continue;
            this.getStyleSheet().getBoxPainter(this.getView(i).getAttributes()).paint(g, this.tempRect.x, this.tempRect.y, this.tempRect.width, this.tempRect.height, this);
            this.inspectTable(this.getView(i), this.tempRect, g);
        }
    }

    Shape getTransformedShape(Shape shape) {
        try {
            CustomLayoutBoxView parent;
            if (!(this.getParent() instanceof CustomLayoutBoxView) && !(this.getParent() instanceof CustomTableRowView)) {
                return shape;
            }
            int x = 0;
            int y = 0;
            int width = 0;
            int height = 0;
            if (this.getParent() instanceof CustomLayoutBoxView) {
                parent = (CustomLayoutBoxView)this.getParent();
                x = parent.getOffset(0, SferyxUtilities.indexOfView(this));
                y = parent.getOffset(1, SferyxUtilities.indexOfView(this));
                width = parent.getSpan(0, SferyxUtilities.indexOfView(this));
                height = parent.getSpan(1, SferyxUtilities.indexOfView(this));
            } else if (this.getParent() instanceof CustomTableRowView) {
                parent = (CustomTableCelView)this;
                if (((CustomTableCelView)parent).myRect != null) {
                    x = ((CustomTableCelView)parent).myRect.x;
                    y = ((CustomTableCelView)parent).myRect.y;
                    width = ((CustomTableCelView)parent).myRect.width;
                    height = ((CustomTableCelView)parent).myRect.height;
                }
            }
            Rectangle alloc = new Rectangle(x, y, width, height);
            String transform = null;
            if (this.getElement().getAttributes().getAttribute("transform") != null && this.getElement().getAttributes().isDefined("transform")) {
                transform = this.getElement().getAttributes().getAttribute("transform").toString().toLowerCase().trim();
            } else if (this.getAttributes().getAttribute("transform") != null && this.getAttributes().isDefined("transform")) {
                transform = this.getAttributes().getAttribute("transform").toString().toLowerCase().trim();
            }
            if (transform != null && transform.startsWith("rotate(") && transform.endsWith(")") && transform.length() > 8) {
                String angle = transform.substring(transform.indexOf("(") + 1, transform.indexOf(")"));
                if (angle.endsWith("deg")) {
                    angle = angle.substring(0, angle.indexOf("deg"));
                }
                AffineTransform transf = AffineTransform.getRotateInstance(Double.valueOf(angle) * Math.PI / 180.0, alloc.x + alloc.width / 2, alloc.y + alloc.height / 2);
                shape = transf.createTransformedShape(shape);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return shape;
    }

    Shape getInvertedTransformedShape(Shape shape) {
        block13: {
            try {
                CustomLayoutBoxView parent;
                if (!(this.getParent() instanceof CustomLayoutBoxView) && !(this.getParent() instanceof CustomTableRowView)) {
                    return shape;
                }
                int x = 0;
                int y = 0;
                int width = 0;
                int height = 0;
                if (this.getParent() instanceof CustomLayoutBoxView) {
                    parent = (CustomLayoutBoxView)this.getParent();
                    x = parent.getOffset(0, SferyxUtilities.indexOfView(this));
                    y = parent.getOffset(1, SferyxUtilities.indexOfView(this));
                    width = parent.getSpan(0, SferyxUtilities.indexOfView(this));
                    height = parent.getSpan(1, SferyxUtilities.indexOfView(this));
                } else if (this.getParent() instanceof CustomTableRowView) {
                    parent = (CustomTableCelView)this;
                    if (((CustomTableCelView)parent).myRect != null) {
                        x = ((CustomTableCelView)parent).myRect.x;
                        y = ((CustomTableCelView)parent).myRect.y;
                        width = ((CustomTableCelView)parent).myRect.width;
                        height = ((CustomTableCelView)parent).myRect.height;
                    }
                }
                Rectangle alloc = new Rectangle(x, y, width, height);
                String transform = null;
                if (this.getElement().getAttributes().getAttribute("transform") != null && this.getElement().getAttributes().isDefined("transform")) {
                    transform = this.getElement().getAttributes().getAttribute("transform").toString().toLowerCase().trim();
                } else if (this.getAttributes().getAttribute("transform") != null && this.getAttributes().isDefined("transform")) {
                    transform = this.getAttributes().getAttribute("transform").toString().toLowerCase().trim();
                }
                if (transform == null || !transform.startsWith("rotate(") || !transform.endsWith(")") || transform.length() <= 8) break block13;
                String angle = transform.substring(transform.indexOf("(") + 1, transform.indexOf(")"));
                if (angle.endsWith("deg")) {
                    angle = angle.substring(0, angle.indexOf("deg"));
                }
                AffineTransform transf = AffineTransform.getRotateInstance(Double.valueOf(angle) * Math.PI / 180.0, alloc.x + alloc.width / 2, alloc.y + alloc.height / 2);
                try {
                    transf = transf.createInverse();
                }
                catch (Throwable thr) {
                    // empty catch block
                }
                shape = transf.createTransformedShape(shape);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return shape;
    }

    Point getInvertedTransformedPoint(Point p, Shape shape) {
        block13: {
            try {
                CustomLayoutBoxView parent;
                if (!(this.getParent() instanceof CustomLayoutBoxView) && !(this.getParent() instanceof CustomTableRowView)) {
                    return p;
                }
                int x = 0;
                int y = 0;
                int width = 0;
                int height = 0;
                if (this.getParent() instanceof CustomLayoutBoxView) {
                    parent = (CustomLayoutBoxView)this.getParent();
                    x = parent.getOffset(0, SferyxUtilities.indexOfView(this));
                    y = parent.getOffset(1, SferyxUtilities.indexOfView(this));
                    width = parent.getSpan(0, SferyxUtilities.indexOfView(this));
                    height = parent.getSpan(1, SferyxUtilities.indexOfView(this));
                } else if (this.getParent() instanceof CustomTableRowView) {
                    parent = (CustomTableCelView)this;
                    if (((CustomTableCelView)parent).myRect != null) {
                        x = ((CustomTableCelView)parent).myRect.x;
                        y = ((CustomTableCelView)parent).myRect.y;
                        width = ((CustomTableCelView)parent).myRect.width;
                        height = ((CustomTableCelView)parent).myRect.height;
                    }
                }
                Rectangle alloc = new Rectangle(x, y, width, height);
                String transform = null;
                if (this.getElement().getAttributes().getAttribute("transform") != null && this.getElement().getAttributes().isDefined("transform")) {
                    transform = this.getElement().getAttributes().getAttribute("transform").toString().toLowerCase().trim();
                } else if (this.getAttributes().getAttribute("transform") != null && this.getAttributes().isDefined("transform")) {
                    transform = this.getAttributes().getAttribute("transform").toString().toLowerCase().trim();
                }
                if (transform == null || !transform.startsWith("rotate(") || !transform.endsWith(")") || transform.length() <= 8) break block13;
                String angle = transform.substring(transform.indexOf("(") + 1, transform.indexOf(")"));
                if (angle.endsWith("deg")) {
                    angle = angle.substring(0, angle.indexOf("deg"));
                }
                AffineTransform transf = AffineTransform.getRotateInstance(Double.valueOf(angle) * Math.PI / 180.0, alloc.x + alloc.width / 2, alloc.y + alloc.height / 2);
                try {
                    transf = transf.createInverse();
                }
                catch (Throwable thr) {
                    // empty catch block
                }
                Point2D po = transf.transform(p, p);
                p = new Point((int)po.getX(), (int)po.getY());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return p;
    }

    Point getTransformedPoint(Point p, Shape shape) {
        try {
            CustomLayoutBoxView parent;
            if (!(this.getParent() instanceof CustomLayoutBoxView) && !(this.getParent() instanceof CustomTableRowView)) {
                return p;
            }
            int x = 0;
            int y = 0;
            int width = 0;
            int height = 0;
            if (this.getParent() instanceof CustomLayoutBoxView) {
                parent = (CustomLayoutBoxView)this.getParent();
                x = parent.getOffset(0, SferyxUtilities.indexOfView(this));
                y = parent.getOffset(1, SferyxUtilities.indexOfView(this));
                width = parent.getSpan(0, SferyxUtilities.indexOfView(this));
                height = parent.getSpan(1, SferyxUtilities.indexOfView(this));
            } else if (this.getParent() instanceof CustomTableRowView) {
                parent = (CustomTableCelView)this;
                if (((CustomTableCelView)parent).myRect != null) {
                    x = ((CustomTableCelView)parent).myRect.x;
                    y = ((CustomTableCelView)parent).myRect.y;
                    width = ((CustomTableCelView)parent).myRect.width;
                    height = ((CustomTableCelView)parent).myRect.height;
                }
            }
            Rectangle alloc = new Rectangle(x, y, width, height);
            String transform = null;
            if (this.getElement().getAttributes().getAttribute("transform") != null && this.getElement().getAttributes().isDefined("transform")) {
                transform = this.getElement().getAttributes().getAttribute("transform").toString().toLowerCase().trim();
            } else if (this.getAttributes().getAttribute("transform") != null && this.getAttributes().isDefined("transform")) {
                transform = this.getAttributes().getAttribute("transform").toString().toLowerCase().trim();
            }
            if (transform != null && transform.startsWith("rotate(") && transform.endsWith(")") && transform.length() > 8) {
                String angle = transform.substring(transform.indexOf("(") + 1, transform.indexOf(")"));
                if (angle.endsWith("deg")) {
                    angle = angle.substring(0, angle.indexOf("deg"));
                }
                AffineTransform transf = AffineTransform.getRotateInstance(Double.valueOf(angle) * Math.PI / 180.0, alloc.x + alloc.width / 2, alloc.y + alloc.height / 2);
                Point2D po = transf.transform(p, p);
                p = new Point((int)po.getX(), (int)po.getY());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return p;
    }

    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        Shape shape = super.modelToView(pos, a, b);
        shape = this.getTransformedShape(shape);
        return shape;
    }

    void checkTransformation(Graphics g, Rectangle alloc) {
        try {
            String transform = null;
            if (this.getElement().getAttributes().getAttribute("transform") != null && this.getElement().getAttributes().isDefined("transform")) {
                transform = this.getElement().getAttributes().getAttribute("transform").toString().toLowerCase().trim();
            } else if (this.getAttributes().getAttribute("transform") != null && this.getAttributes().isDefined("transform")) {
                transform = this.getAttributes().getAttribute("transform").toString().toLowerCase().trim();
            }
            if (transform != null && transform.startsWith("rotate(") && transform.endsWith(")") && transform.length() > 8) {
                String angle = transform.substring(transform.indexOf("(") + 1, transform.indexOf(")"));
                if (angle.endsWith("deg")) {
                    angle = angle.substring(0, angle.indexOf("deg"));
                }
                Rectangle rot_alloc = alloc;
                AffineTransform transf = AffineTransform.getRotateInstance(Double.valueOf(angle) * Math.PI / 180.0, rot_alloc.x + rot_alloc.width / 2, rot_alloc.y + rot_alloc.height / 2);
                AffineTransform curr_transf = ((Graphics2D)g).getTransform();
                if (curr_transf != null) {
                    curr_transf.concatenate(transf);
                    ((Graphics2D)g).setTransform(curr_transf);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void paint(Graphics g, Shape allocation) {
        Rectangle alloc = allocation instanceof Rectangle ? (Rectangle)allocation : allocation.getBounds();
        Rectangle clip = g.getClipBounds();
        this.myAllocation = alloc;
        if (!this.isVisible()) {
            return;
        }
        AffineTransform saveAT = (AffineTransform)((Graphics2D)g).getTransform().clone();
        this.checkTransformation(g, alloc);
        if (SferyxUtilities.matchNameAttribute(this.getElement(), HTML.Tag.HTML)) {
            // empty if block
        }
        if ((SferyxUtilities.matchNameAttribute(this.getElement(), HTML.Tag.BODY) || SferyxUtilities.matchNameAttribute(this.getElement(), HTML.Tag.HTML)) && this.getContainer() != null) {
            JComponent comp = (JComponent)this.getContainer();
            if (alloc.height < comp.getVisibleRect().height) {
                alloc.height = comp.getVisibleRect().height - comp.getInsets().top - comp.getInsets().bottom;
            }
        }
        boolean absolutePositioning = this.isAbsolutePositioning();
        if (alloc.intersects(clip)) {
            if (this.boxPainter == null || !this.boxPainter.attr.equals(this.getAttributes())) {
                this.boxPainter = new CustomBoxPainter(this.getAttributes(), this.getStyleSheet(), this);
            }
            this.boxPainter.paint(g, alloc.x, alloc.y, alloc.width, alloc.height, this);
        }
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            this.tempRect = (Rectangle)this.getChildAllocation(i, alloc);
            if (!SferyxUtilities.getJVMVersion().startsWith("1.3")) {
                // empty if block
            }
            if (this.tempRect != null && (this.tempRect.intersects(clip) || this.getView(i) instanceof CustomParagraphView && ((CustomParagraphView)this.getView((int)i)).containsAlignedImages)) {
                try {
                    this.paintChild(g, this.tempRect, i);
                }
                catch (Throwable trw) {
                    // empty catch block
                }
            }
            if (SferyxUtilities.getJVMVersion().startsWith("1.3")) continue;
        }
        if (alloc.intersects(clip)) {
            Rectangle borderRect = new Rectangle();
            borderRect.x = alloc.x;
            borderRect.y = alloc.y;
            borderRect.width = alloc.width;
            borderRect.height = alloc.height;
            SferyxUtilities.paintViewBorder(this, borderRect, g);
        }
        if (this.revealBlockViews) {
            g.setFont(tagsFont);
            g.setColor(Color.yellow);
            g.fill3DRect(alloc.x, alloc.y, g.getFontMetrics().stringWidth("<" + this.getElement().getName() + ">"), g.getFontMetrics().getHeight(), true);
            g.setColor(Color.blue);
            g.drawString("<" + this.getElement().getName() + ">", alloc.x, alloc.y + g.getFontMetrics().getHeight() - g.getFontMetrics().getAscent() / 2);
            if (SferyxUtilities.isFloatLeftView(this.getAttributes(), this.getStyleSheet())) {
                g.setColor(Color.green);
                g.drawRect(alloc.x + 2, alloc.y + 2, alloc.width - 4, alloc.height - 4);
            } else if (SferyxUtilities.isFloatRightView(this.getAttributes(), this.getStyleSheet())) {
                g.setColor(Color.red);
                g.drawRect(alloc.x + 2, alloc.y + 2, alloc.width - 4, alloc.height - 4);
            } else {
                g.setColor(Color.yellow);
                g.drawRect(alloc.x + 2, alloc.y + 2, alloc.width - 4, alloc.height - 4);
            }
            if (SferyxUtilities.isClearBothView(this.getAttributes(), this.getStyleSheet())) {
                g.setColor(new Color(255, 0, 0, 128));
            }
            g.setFont(tagsFont);
            g.setColor(Color.yellow);
            g.fill3DRect(alloc.x + alloc.width - g.getFontMetrics().stringWidth("</" + this.getElement().getName() + ">"), alloc.y + alloc.height - g.getFontMetrics().getHeight(), g.getFontMetrics().stringWidth("</" + this.getElement().getName() + ">"), g.getFontMetrics().getHeight(), true);
            g.setColor(Color.blue);
            g.drawString("</" + this.getElement().getName() + ">", alloc.x + alloc.width - g.getFontMetrics().stringWidth("</" + this.getElement().getName() + ">"), alloc.y + alloc.height - g.getFontMetrics().getAscent() / 2);
        }
        ((Graphics2D)g).setTransform(saveAT);
    }

    void inspectTable(View tableView, Shape allocation, Graphics g) {
        try {
            for (int i = 0; i < tableView.getViewCount(); ++i) {
                View childView = tableView.getView(i);
                AbstractDocument.AbstractElement element = (AbstractDocument.AbstractElement)childView.getElement();
                Shape childAlloc = tableView.getChildAllocation(i, allocation);
                if (!element.getAttribute(StyleConstants.NameAttribute).equals(HTML.Tag.TR)) continue;
                for (int j = 0; j < childView.getViewCount(); ++j) {
                    View cellView = childView.getView(j);
                    Shape cellAlloc = childView.getChildAllocation(j, childAlloc);
                    this.findTablesAndPaintThem(cellView, g, cellAlloc);
                }
            }
        }
        catch (Throwable thr) {
            // empty catch block
        }
    }

    void findTablesAndPaintThem(View tableCellView, Graphics g, Shape allocation) {
        for (int i = 0; i < tableCellView.getViewCount(); ++i) {
            View innerView = tableCellView.getView(i);
            Rectangle childAlloc = (Rectangle)tableCellView.getChildAllocation(i, allocation);
            if (!SferyxUtilities.getJVMVersion().startsWith("1.5") || !innerView.getClass().getName().equals("javax.swing.text.html.TableView")) continue;
            ((HTMLDocument)this.getDocument()).getStyleSheet().getBoxPainter(innerView.getAttributes()).paint(g, childAlloc.x, childAlloc.y, childAlloc.width, childAlloc.height, this);
            this.inspectTable(innerView, childAlloc, g);
        }
    }

    public int getNextVisualPositionFrom(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        Rectangle alloc = (Rectangle)a;
        try {
            int position = super.getNextVisualPositionFrom(pos, b, alloc, direction, biasRet);
            return position;
        }
        catch (Throwable thr) {
            return pos;
        }
    }

    public boolean isVisible() {
        Container c = this.getContainer();
        if (c != null && ((JComponent)c).getGraphics() != null) {
            Rectangle rect = ((JComponent)c).getGraphics().getClipRect();
            if (rect != null) {
                if (this.myAllocation == null) {
                    return true;
                }
                return this.myAllocation != null && (this.myAllocation.intersects(rect) || rect.contains(this.myAllocation));
            }
            return true;
        }
        return false;
    }

    public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
        Rectangle alloc = this.getInsideAllocation(a);
        if (this.isAbsolutePositioning()) {
            alloc.x = this.getAbsoluteX();
            alloc.y = this.getAbsoluteY();
        }
        Point r = new Point((int)x, (int)y);
        r = this.getInvertedTransformedPoint(r, a);
        x = r.x;
        y = r.y;
        if (this.isBefore((int)x, (int)y, alloc)) {
            int retValue = -1;
            try {
                retValue = this.getNextVisualPositionFrom(-1, Position.Bias.Forward, a, 3, bias);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
            catch (IllegalArgumentException iae) {
                iae.printStackTrace();
            }
            if (retValue == -1) {
                retValue = this.getStartOffset();
                bias[0] = Position.Bias.Forward;
            }
            return retValue;
        }
        if (this.isAfter((int)x, (int)y, alloc)) {
            int retValue = -1;
            try {
                retValue = this.getNextVisualPositionFrom(-1, Position.Bias.Forward, a, 7, bias);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
            catch (IllegalArgumentException iae) {
                iae.printStackTrace();
            }
            if (retValue == -1) {
                retValue = this.getEndOffset() - 1;
                bias[0] = Position.Bias.Forward;
            }
            return retValue;
        }
        try {
            View v = this.getViewAtPoint((int)x, (int)y, alloc);
            if (v != null && alloc != null) {
                return v.viewToModel(x, y, alloc, bias);
            }
        }
        catch (Throwable thr) {
            // empty catch block
        }
        return -1;
    }

    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.removeUpdate(e, a, f);
        this.removeUpdateNeeded = true;
    }

    protected void updateLayout(DocumentEvent.ElementChange ec, DocumentEvent e, Shape a) {
        super.updateLayout(ec, e, a);
    }

    public float getMaximumSpan(int axis) {
        float orig_span;
        if (this.getElement().getName().equals("body") && axis == 0 && this.getContainer() != null && this.getContainer() instanceof CustomEditorPane && ((CustomEditorPane)this.getContainer()).isWrapParagraphLinesAlwaysOnEditorSize() && (orig_span = super.getMaximumSpan(axis)) >= (float)this.getContainer().getWidth()) {
            return ((JViewport)this.getContainer().getParent()).getExtentSize().width - 10;
        }
        float span = super.getMaximumSpan(axis);
        return span;
    }

    public float getPreferredSpan(int axis) {
        float orig_span;
        if (this.getElement().getName().equals("body") && axis == 0 && this.getContainer() != null && this.getContainer() instanceof CustomEditorPane && ((CustomEditorPane)this.getContainer()).isWrapParagraphLinesAlwaysOnEditorSize() && (orig_span = super.getPreferredSpan(axis)) >= (float)this.getContainer().getWidth()) {
            return ((JViewport)this.getContainer().getParent()).getExtentSize().width - 10;
        }
        float span = super.getPreferredSpan(axis);
        return span;
    }

    public float getMinimumSpan(int axis) {
        float orig_span;
        if (this.getElement().getName().equals("body") && axis == 0 && this.getContainer() != null && this.getContainer() instanceof CustomEditorPane && ((CustomEditorPane)this.getContainer()).isWrapParagraphLinesAlwaysOnEditorSize() && (orig_span = super.getMinimumSpan(axis)) >= (float)this.getContainer().getWidth()) {
            return ((JViewport)this.getContainer().getParent()).getExtentSize().width - 10;
        }
        float span = super.getMinimumSpan(axis);
        return span;
    }

    protected void layout(int width, int height) {
        try {
            super.layout(width, height);
            if (this.offsets_X.length == 0) {
                this.offsets_X = new int[this.getViewCount()];
            }
            if (this.spans_X.length == 0) {
                this.spans_X = new int[this.getViewCount()];
            }
            if (this.offsets_Y.length == 0) {
                this.offsets_Y = new int[this.getViewCount()];
            }
            if (this.spans_Y.length == 0) {
                this.spans_Y = new int[this.getViewCount()];
            }
            if (this.offsets_X != null && this.spans_X != null && this.offsets_Y != null && this.spans_Y != null && SferyxUtilities.getJVMVersion().startsWith("1.3")) {
                this.layoutMajorAxis(height, 1, this.offsets_Y, this.spans_Y);
            }
            if (this.containsAlignedImages || this.removeUpdateNeeded) {
                this.adjustAllParagraphsLayout(width, this.offsets_X, this.spans_X);
                this.removeUpdateNeeded = false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setParent(View parent) {
        if (parent instanceof CustomLayoutBoxView) {
            this.loading = ((CustomLayoutBoxView)parent).loading;
        } else if (parent instanceof CustomTableRowView) {
            this.loading = ((CustomTableRowView)parent).loading;
        }
        if (parent != null) {
            super.setParent(parent);
        }
    }

    public void setSize(float width, float height) {
        super.setSize(width, height);
        if (this.currWidth != width || this.currHeight != height) {
            // empty if block
        }
        this.currWidth = width;
        this.currHeight = height;
    }

    protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements r) {
        if (r == null) {
            r = new SizeRequirements();
        }
        if (!this.spanSetFromAttributes(axis, r, this.cssWidth, this.cssHeight)) {
            r = super.calculateMajorAxisRequirements(axis, r);
        } else {
            SizeRequirements parentR = super.calculateMajorAxisRequirements(axis, null);
            int margin = axis == 0 ? this.getLeftInset() + this.getRightInset() : this.getTopInset() + this.getBottomInset();
            r.minimum -= margin;
            r.preferred -= margin;
            r.maximum -= margin;
            this.constrainSize(axis, r, parentR);
        }
        return r;
    }

    private void constrainSize(int axis, SizeRequirements want, SizeRequirements min) {
        if (min.minimum > want.minimum) {
            want.minimum = want.preferred = min.minimum;
            want.maximum = Math.max(want.maximum, min.maximum);
        }
    }

    protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
        Object o;
        if (r == null) {
            r = new SizeRequirements();
        }
        if (!this.spanSetFromAttributes(axis, r, this.cssWidth, this.cssHeight)) {
            r = super.calculateMinorAxisRequirements(axis, r);
        } else {
            SizeRequirements parentR = super.calculateMinorAxisRequirements(axis, null);
            int margin = axis == 0 ? this.getLeftInset() + this.getRightInset() : this.getTopInset() + this.getBottomInset();
            r.minimum -= margin;
            r.preferred -= margin;
            r.maximum -= margin;
            this.constrainSize(axis, r, parentR);
        }
        if (axis == 0 && (o = this.getAttributes().getAttribute(CSS.Attribute.TEXT_ALIGN)) != null) {
            String align = o.toString();
            r.alignment = align.equals("center") ? 0.5f : (align.equals("right") ? 1.0f : 0.0f);
        }
        return r;
    }

    boolean spanSetFromAttributes(int axis, SizeRequirements r, Object cssWidth, Object cssHeight) {
        if (axis == 0) {
            if (cssWidth != null && !cssWidth.toString().endsWith("%")) {
                r.preferred = r.maximum = (int)SferyxUtilities.getNumberFromCSString(cssWidth.toString());
                r.minimum = r.maximum;
                return true;
            }
        } else if (cssHeight != null && !cssHeight.toString().endsWith("%")) {
            r.preferred = r.maximum = (int)SferyxUtilities.getNumberFromCSString(cssHeight.toString());
            r.minimum = r.maximum;
            return true;
        }
        return false;
    }

    protected void setPropertiesFromAttributes() {
        AttributeSet attribs = this.getAttributes();
        this.cssWidth = attribs.getAttribute(CSS.Attribute.WIDTH);
        this.cssHeight = attribs.getAttribute(CSS.Attribute.HEIGHT);
    }
}

