/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import sferyx.administration.editors.CustomHTMLFactory;
import sferyx.administration.editors.CustomUnknownTagView;
import sferyx.administration.editors.HTMLEditor;
import sferyx.administration.editors.SferyxUtilities;

public class CustomLayerView
extends CustomUnknownTagView {
    Component c;

    public CustomLayerView(Element elem) {
        super(elem);
    }

    public float getPreferredSpan(int param) {
        return 10.0f;
    }

    public void paint(Graphics graphics, Shape shape) {
        if (this.c == null) {
            this.c = this.createComponent();
        }
    }

    protected Component createComponent() {
        AttributeSet attr = this.getElement().getAttributes();
        HTMLEditor editorPane = new HTMLEditor();
        ((CustomHTMLFactory)editorPane.getInternalJEditorPane().getEditorKit().getViewFactory()).layeringDisabled = true;
        editorPane.setBorder(new LineBorder(Color.red, 2));
        this.getContainer().add(editorPane);
        JRootPane rootPane = SwingUtilities.getRootPane(this.getContainer());
        JLayeredPane layers = rootPane.getLayeredPane();
        editorPane.setLocation(this.getAbsoluteX(), this.getAbsoluteY());
        editorPane.setSize(new Dimension(this.getAbsoluteWidth(), this.getAbsoluteHeight()));
        editorPane.setMainMenuVisible(false);
        editorPane.setSourceEditorVisible(false);
        editorPane.setPreviewVisible(false);
        editorPane.setStatusBarVisible(false);
        editorPane.setVisible(true);
        editorPane.setContent(SferyxUtilities.dumpDocumentElement(this.getElement()));
        return editorPane;
    }

    public AttributeSet getAllAttributes() {
        Style attr = ((HTMLDocument)this.getElement().getDocument()).getStyleSheet().getRule((HTML.Tag)this.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute), this.getElement());
        return attr;
    }

    int getAbsoluteX() {
        try {
            String left = (String)this.getElement().getAttributes().getAttribute("left");
            if (left != null) {
                return Integer.parseInt(this.getNumericValue(left));
            }
            return Integer.parseInt(this.getNumericValue(this.getAllAttributes().getAttribute("left").toString()));
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    String getNumericValue(Object value) {
        return this.getNumericValue(value.toString());
    }

    String getNumericValue(String value) {
        if (value.endsWith("px") || value.endsWith("pt")) {
            value = value.substring(0, value.length() - 2);
        } else if (value.endsWith("%")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    int getAbsoluteWidth() {
        try {
            Object width = this.getElement().getAttributes().getAttribute(CSS.Attribute.WIDTH);
            if (width != null) {
                return Integer.parseInt(this.getNumericValue(width));
            }
            int width_ = Integer.parseInt(this.getNumericValue(this.getAllAttributes().getAttribute(CSS.Attribute.WIDTH).toString()));
            return width_;
        }
        catch (Throwable thr) {
            thr.printStackTrace();
            return 0;
        }
    }

    int getAbsoluteHeight() {
        try {
            Object width = this.getElement().getAttributes().getAttribute(CSS.Attribute.HEIGHT);
            if (width != null) {
                return Integer.parseInt(this.getNumericValue(width.toString()));
            }
            int height_ = Integer.parseInt(this.getNumericValue(this.getAllAttributes().getAttribute(CSS.Attribute.HEIGHT).toString()));
            return height_;
        }
        catch (Throwable thr) {
            thr.printStackTrace();
            return 0;
        }
    }

    int getAbsoluteY() {
        try {
            String left = (String)this.getElement().getAttributes().getAttribute("top");
            if (left != null) {
                return Integer.parseInt(this.getNumericValue(left));
            }
            return Integer.parseInt(this.getNumericValue(this.getAllAttributes().getAttribute("top").toString()));
        }
        catch (Throwable throwable) {
            return 0;
        }
    }
}

